#pragma once
#include "stdafx.h"
#include "GetRefusalDlg.h"
#include "RefFilesChildDlg.h"
#include "RefChildsChildDlg.h"
#include "RefCharactChildDlg.h"
#include "RefResultsChildDlg.h"
#include "RefClassifChildDlg.h"
#include "RefApprovalChildDlg.h"
#include "RefDocumentsChildDlg.h"
#include "RefAdminInfoChildDlg.h"
#include "RefResearchResultsChildDlg.h"
#include "afxwin.h"

class CRefChildsChildDlg;
class CRefResultsChildDlg;
class CRefClassifChildDlg;
class CRefResearchResultsChildDlg;

class APL_CLASS_TYPE CRefusalPropertyDlg : public CaplTranslateDialog
{
	DECLARE_DYNAMIC(CRefusalPropertyDlg)

public:
	CRefusalPropertyDlg(CaplAPI *api, CaplFaultMgr *FaultMgr, CWnd* pParent = NULL);   // standard constructor
	virtual ~CRefusalPropertyDlg()
	{		
	};

	// Dialog Data
	enum { IDD = IDD_REFUSAL_CARD };

	CString m_sRefType;
	CString m_sRefState;
	CString m_sRefDescr;
	CString m_sRefDoc;
	CString m_sRefDocNum;
	CString m_sRefDocDate;
	CString m_sRefOrg;
	CString m_sRefSector;
	CString m_sRefStage;
	CString m_sRefDateDetect;
	CString m_sRefDateRemove;
	CString m_sRefMainPdf;
	CString m_sRefSystem;
	CString m_sRefIngItemShifr;
	CString m_sRefIngItemName;
	CString m_sRefIngItemLot;
	CString m_sRefIngItemSn;
	CString m_sRefEdItemShifr;
	CString m_sRefEdItemName;
	CString m_sRefEdItemLot;
	CString m_sRefEdItemSn;
	CString m_sExtView;
	CString m_sResources;
	CString m_sParentType;
	CString m_sParentState;
	CString m_sParentDoc;
	CString m_sParentDocNum;
	CString m_sParentDate;

	CString m_sSetupCode;

	aplExtent m_aeNewCharVal;
	aplExtent m_aeRefusalToUpdate;

	aplExtent m_extDocs4Add; //  ,     

	CaplAPI *m_api;
	CaplFaultMgr *m_FaultMgr;

	CaplInstance *m_ciRef;
	CaplInstance *m_ciEdItem;
	CaplInstance *m_ciMainPdf;
	CaplInstance *m_ciSystem;
	CaplInstance *m_ciIngItem;
	CaplInstance *m_ciType;
	CaplInstance *m_ciStage;
	CaplInstance *m_ciOrg;
	CaplInstance *m_ciSector;
	CaplInstance *m_ciIngLot;
	CaplInstance *m_ciEdLot;
	CaplInstance *m_ciParentRef;
	CaplInstance *m_ciTmpRef;

	CaplInstance *m_ciSourceRefusal;//     .


	CTabCtrl m_tab;
	CaplListCtrl m_list_ref_res;
	CButton m_check_ref_date_remove;

	CString m_sSpavPKI;
	CString m_sSpavKomponent;
	CString m_sSpavElement;

	CaplButton m_ok_btn;
	CaplButton m_cancel_btn;
	CaplButton m_btn_choose_org;
	CaplButton m_btn_choose_sector;
	CaplButton m_btn_choose_main_pdf;
	CaplButton m_btn_choose_system;
	CaplButton m_btn_choose_ing_item;
	CaplButton m_btn_choose_ed_item;
	CaplButton m_btn_choose_ed_pdf;
	CaplButton m_clear_org;
	CaplButton m_clear_sector;
	CaplButton m_clear_main_pdf;
	CaplButton m_clear_system;
	CaplButton m_clear_ing_item;
	CaplButton m_clear_ed_item;
	CaplButton m_clear_ed_pdf;
	CaplButton m_btn_choose_ing_ref;
	CaplButton m_btn_clear_ing_ref;

	CComboBox m_combo_ref_type;
	CComboBox m_combo_ref_state;
	CComboBox m_combo_ref_doc;
	CComboBox m_combo_ref_stage;

	CDateTimeCtrl m_date_ref_doc_date;
	CDateTimeCtrl m_date_ref_date_detect;
	CDateTimeCtrl m_date_ref_date_remove;
	CDateTimeCtrl m_date_ref_ing_item_date;
	CDateTimeCtrl m_date_ref_ed_item_date;	

	CRefResultsChildDlg *m_pRefResults;
	CRefClassifChildDlg *m_pRefusalClassif;
	CRefResearchResultsChildDlg *m_pRefResearchResults;
	CRefDocumentsChildDlg *m_pRefDoc;
	CRefApprovalChildDlg *m_pRefAppr;
	CRefCharactChildDlg *m_pRefCharact;
	CRefChildsChildDlg	*m_pRefChild;
	CRefAdminInfoChildDlg *m_pRefAdminInfo;
	CRefFilesChildDlg *m_pRefFiles;

	bool m_bChildDlg;

	//     
	void FillInfoAboutRelatingRefusal();

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	virtual void OnOK();


	 void SetReadOnly(); //     

	//  
	void InitBtns();

	//  
	void InitTabs();

	//     ,  
	void SetActiveTabs();

	//    
	//   
	void FillInfoFromInst();
	void GetCommomInfoFromInst();

	//    
	void SaveRefusalBase(CaplInstance *&ciRefusal, bool bExitDlg);

	//      
	void MakeEdItemEmpty();

	//     
	void MakeIngItemEmpty();

	//     
	bool CheckEdItemComposition();

	//    
	bool CheckIngItemComposition();

	//    
	bool CheckSystemComposition();

	//     
	bool CheckMainPdfComposition();

	//    
	void InitComboBoxes();
	void InitComboStage();
	void InitComboType();

	//    
	void UpdateRefusalData();

	//     
	void LoadResources();

	//    
	void GetInfoAboutIngItem();
	void GetInfoAboutEdItem();

	//     
	void IsEnableReportBtn();

	//     
	bool Check();

	//     
	bool PrepareResourceList();

	//   
	void SaveResources(CaplInstance *ciRefusal);

	//      
	void SetResourceToMainRefusal();	

	//  
	void MoveDialog();	

	//   
	void DiscardChanges();

	DECLARE_MESSAGE_MAP()

	afx_msg void OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSelchangingTab(NMHDR* pNMHDR, LRESULT* pResult);	
	afx_msg void OnChooseOrg();
	afx_msg void OnChooseEdItem();
	afx_msg void OnChooseEdPdf();
	afx_msg void OnChooseIngItem();
	afx_msg void OnChooseSystem();
	afx_msg void OnChooseMainPdf();
	afx_msg void OnCheckDateRemove();

	afx_msg void OnClearOrg();
	afx_msg void OnClearMainPdf();
	afx_msg void OnClearSystem();
	afx_msg void OnClearIng();
	afx_msg void OnClearEd();
	afx_msg void OnClearEdPdf();
	afx_msg void OnDestroy();

public:
	afx_msg void OnBnClickedCreateFaultsReportButton();
	afx_msg void OnBnClickedChooseSector();
	afx_msg void OnBnClickedClearSector();
	afx_msg void OnCbnSelchangeRefDoc();
	afx_msg void OnBnClickedClearIngRef();
	afx_msg void OnBnClickedChooseIngRef();
	CEdit m_RefDocNumCtrl;
};