#pragma once
#include "resource.h"
#include "RefusalPropertyDlg.h"

// CRefDocumentsChildDlg dialog

class CRefusalPropertyDlg;
class CRefDocumentsChildDlg : public CaplTranslateDialog
{
	DECLARE_DYNAMIC(CRefDocumentsChildDlg)

public:
	CRefDocumentsChildDlg(CaplAPI *api, CWnd* pParent = NULL);   // standard constructor
	virtual ~CRefDocumentsChildDlg();

// Dialog Data
	enum { IDD = IDD_REF_DOC };

	CaplButton m_create_new;
	CaplButton m_add_exist;

	CImageList imageList;
	CSortListCtrl m_list;

	CaplButton m_view;
	CaplButton m_check_out;
	CaplButton m_check_in;
	CaplButton m_undo_check_out;
	CaplButton m_delete;

	CaplAPI *m_api;
	CaplInstance *m_ciRef;

	aplExtent m_aeNewDoc;
	aplExtent m_aeDeleted;
	aplExtent m_aeCurrentAssoc;

	CRefusalPropertyDlg *m_pParentDlg;

	void InitBtns();
	void InitList();
	void FillList();
	void UpdateToolBar(int nIndex = -1);
	void DiscardChanges();
	bool Check(CaplInstance *ciDoc);
	int GetIndexByInst(CaplInstance *ciObject);
	void SetItemIcon(int nIndex, bool bNormal);
	int AddDocument(CaplInstance *ciDoc, bool bSetDocAsData);
	void SaveRefData(CaplInstance *ciRef, bool bExitDlg);
	void DelDocumentAsAttr(CaplInstance *ciDoc);

	void DelAssoc(CaplInstance *ciReference, bool bShowQuestion = true);
	void DelDocument(CaplInstance *ciDoc, bool bShowQuestion = true);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	virtual void OnOK();

	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnHdnItemchangedList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedAddExist();
	afx_msg void OnBnClickedCreateNew();
	afx_msg void OnBnClickedDelete();
	afx_msg void OnLvnItemchangedList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedView();
	afx_msg void OnBnClickedCheckOut();
	afx_msg void OnBnClickedCheckIn();
	afx_msg void OnBnClickedUndoCheckOut();
	afx_msg void OnDblClick(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMClickList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnKeydownList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnItemActivateList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnItemchangingList(NMHDR *pNMHDR, LRESULT *pResult);
};
