// AplLoadData.cpp : Implementation of CAplLoadData
#include "stdafx.h"
#include "APL_PSS_API.h"
#include "AplLoadData.h"
#include "GeneralFunctions.h"

/////////////////////////////////////////////////////////////////////////////
// CAplLoadData

CAplLoadData::CAplLoadData()
{
	m_api= NULL;
	m_ld= NULL;
	
	m_bAutoClearQueries= true;
	m_bReturnResult= false;
	m_LastErrorCode= APL_NET_OK;
	m_sDefaultWaitText= APL_T(",   ...");
	m_swWaitText= m_sDefaultWaitText.AllocSysString();
}

CAplLoadData::~CAplLoadData()
{
	if(m_ld)
	{
		delete m_ld;
		m_ld= NULL;
	}	

	SysFreeString(m_swWaitText);
}

STDMETHODIMP CAplLoadData::InitAPI(long apiClass, VARIANT *result)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	m_api= (CaplAPI*)apiClass;
	if(!m_api) return S_OK;

	if(m_ld)
	{
		delete m_ld;
		m_ld= NULL;
	}

	m_ld= new CaplLoadData(&(m_api->m_data), DEF_SOURCE);

	return S_OK;
}

STDMETHODIMP CAplLoadData::AddAQuery(long Index,  long Instance,  BOOL LoadAllAttrs,  long* result)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	*result= -1;

	if(!m_ld){m_LastErrorCode= 1012;return S_OK;}

	CaplInstance* pInst= (CaplInstance*)Instance;
	if(!m_api->m_data.IsMyInstance(pInst, true)) {m_LastErrorCode= APL_NET_SRV_APLAPIERR_BADINSTANCE; return S_OK;}
	
	*result= m_ld->AddQuery(Index, pInst, (LoadAllAttrs)?true:false);

	return S_OK;
}

STDMETHODIMP CAplLoadData::AddBQuery(long Instance, long Entity, long Attr, BOOL LoadAllAttrs, long *result)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	*result= -1;
	
	if(!m_ld){m_LastErrorCode= 1012;return S_OK;}

	CaplInstance* pInst= (CaplInstance*)Instance;
	if(!m_api->m_data.IsMyInstance(pInst, true)) {m_LastErrorCode= APL_NET_SRV_APLAPIERR_BADINSTANCE; return S_OK;}

	int i;
	bool bFind;

	bFind= false;
	for(i= 0; i<m_api->m_data.entities.GetSize(); i++)
	{
		if(m_api->m_data.entities[i]==(CaplEntity*)Entity)
		{
			bFind= true;
			break;
		}
	}
	if(!bFind)
	{
		m_LastErrorCode= APL_NET_SRV_APLAPIERR_BADENT;
		return S_OK;
	}

	bFind= false;
	for(i= 0; i<m_api->m_data.attrs.GetSize(); i++)
	{
		if(m_api->m_data.attrs[i]==(CaplAttr*)Attr)
		{
			bFind= true;
			break;
		}
	}
	if(!bFind)
	{
		m_LastErrorCode= APL_NET_SRV_APLAPIERR_BADATTR;
		return S_OK;
	}

	*result= m_ld->AddQuery(_T('b'), pInst->GetId(), (CaplEntity*)Entity, (CaplAttr*)Attr, true, (LoadAllAttrs)?true:false);

	return S_OK;
}

STDMETHODIMP CAplLoadData::AddBQueryBN(long Instance, BSTR EntityName, BSTR AttrName, BOOL LoadAllAttrs, long *result)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	*result= -1;

	if(!m_ld){m_LastErrorCode= 1012;return S_OK;}

	CaplInstance* pInst= (CaplInstance*)Instance;
	if(!m_api->m_data.IsMyInstance(pInst, true)) {m_LastErrorCode= APL_NET_SRV_APLAPIERR_BADINSTANCE; return S_OK;}

	CaplEntity* pEntity= NULL;
	CaplAttr* pAttr= NULL;

	CString sEntity(EntityName);
	CString sAttr(AttrName);
	
	pEntity= m_api->m_data.GetEntityBN(sEntity);
	if(!pEntity) {m_LastErrorCode= APL_NET_SRV_APLAPIERR_BADENT; return S_OK;}	
	pAttr= m_api->m_data.GetAttrDefinition(pEntity, sAttr);
	if(!pAttr){m_LastErrorCode= APL_NET_SRV_APLAPIERR_BADATTR; return S_OK;}

	*result= m_ld->AddQuery(_T('b'), pInst->GetId(), pEntity, pAttr, true, (LoadAllAttrs)?true:false);

	return S_OK;
}

STDMETHODIMP CAplLoadData::AddRQuery(long Index, long Entity, long Attr, BOOL LoadAllAttrs, long *result)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	*result= -1;

	if(!m_ld){m_LastErrorCode= 1012;return S_OK;}

	int i;
	bool bFind;

	bFind= false;
	for(i= 0; i<m_api->m_data.entities.GetSize(); i++)
	{
		if(m_api->m_data.entities[i]==(CaplEntity*)Entity)
		{
			bFind= true;
			break;
		}
	}
	if(!bFind)
	{
		m_LastErrorCode= APL_NET_SRV_APLAPIERR_BADENT;
		return S_OK;
	}

	bFind= false;
	for(i= 0; i<m_api->m_data.attrs.GetSize(); i++)
	{
		if(m_api->m_data.attrs[i]==(CaplAttr*)Attr)
		{
			bFind= true;
			break;
		}
	}
	if(!bFind)
	{
		m_LastErrorCode= APL_NET_SRV_APLAPIERR_BADATTR;
		return S_OK;
	}

	*result= m_ld->AddQuery(_T('r'), Index, (CaplEntity*)Entity, (CaplAttr*)Attr, true, (LoadAllAttrs)?true:false);

	return S_OK;
}

STDMETHODIMP CAplLoadData::AddRQueryBN(long Index, BSTR EntityName, BSTR AttrName, BOOL LoadAllAttrs, long *result)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	*result= -1;

	if(!m_ld){m_LastErrorCode= 1012;return S_OK;}
		
	CaplEntity* pEntity= NULL;
	CaplAttr* pAttr= NULL;

	CString sEntity(EntityName);
	CString sAttr(AttrName);
	
	pEntity= m_api->m_data.GetEntityBN(sEntity);
	if(!pEntity) {m_LastErrorCode= APL_NET_SRV_APLAPIERR_BADENT; return S_OK;}	
	pAttr= m_api->m_data.GetAttrDefinition(pEntity, sAttr);
	if(!pAttr){m_LastErrorCode= APL_NET_SRV_APLAPIERR_BADATTR; return S_OK;}

	*result= m_ld->AddQuery(_T('r'), Index, pEntity, pAttr, true, (LoadAllAttrs)?true:false);
	
	return S_OK;
}

STDMETHODIMP CAplLoadData::AddDQuery(long Index, long Attr, BOOL LoadAllAttrs, long *result)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	*result= -1;
	
	if(!m_ld){m_LastErrorCode= 1012;return S_OK;}

	int i;
	bool bFind;
	
	bFind= false;
	for(i= 0; i<m_api->m_data.attrs.GetSize(); i++)
	{
		if(m_api->m_data.attrs[i]==(CaplAttr*)Attr)
		{
			bFind= true;
			break;
		}
	}
	if(!bFind)
	{
		m_LastErrorCode= APL_NET_SRV_APLAPIERR_BADATTR;
		return S_OK;
	}

	*result= m_ld->AddQuery(_T('d'), Index, 0, (CaplAttr*)Attr, true, (LoadAllAttrs)?true:false);
	
	return S_OK;
}

STDMETHODIMP CAplLoadData::AddDQueryBN( long Index, BSTR EntityName,  BSTR AttrName,  BOOL LoadAllAttrs,  long* result)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	*result= -1;
	if(!m_ld){m_LastErrorCode= 1012;return S_OK;}
		
	CaplEntity* pEntity= NULL;
	CaplAttr* pAttr= NULL;

	CString sEntity(EntityName);
	CString sAttr(AttrName);
	
	pEntity= m_api->m_data.GetEntityBN(sEntity);
	if(!pEntity) {m_LastErrorCode= APL_NET_SRV_APLAPIERR_BADENT; return S_OK;}	
	pAttr= m_api->m_data.GetAttrDefinition(pEntity, sAttr);
	if(!pAttr){m_LastErrorCode= APL_NET_SRV_APLAPIERR_BADATTR; return S_OK;}

	*result= m_ld->AddQuery(_T('d'), Index, 0, pAttr, true, (LoadAllAttrs)?true:false);	

	return S_OK;
}

STDMETHODIMP CAplLoadData::AddEQuery(long Entity, BOOL LoadAllAttrs, long *result)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	*result= -1;
	if(!m_ld){m_LastErrorCode= 1012;return S_OK;}
		
	int i;
	bool bFind;

	bFind= false;
	for(i= 0; i<m_api->m_data.entities.GetSize(); i++)
	{
		if(m_api->m_data.entities[i]==(CaplEntity*)Entity)
		{
			bFind= true;
			break;
		}
	}
	if(!bFind)
	{
		m_LastErrorCode= APL_NET_SRV_APLAPIERR_BADENT;
		return S_OK;
	}

	*result= m_ld->AddQuery(_T('e'), 0, (CaplEntity*)Entity, 0, true, (LoadAllAttrs)?true:false);

	return S_OK;
}

STDMETHODIMP CAplLoadData::AddEQueryBN(BSTR EntityName, BOOL LoadAllAttrs, long *result)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	*result= -1;
	if(!m_ld){m_LastErrorCode= 1012;return S_OK;}

	CaplEntity* pEntity= NULL;
	CString sEntity(EntityName);
	
	pEntity= m_api->m_data.GetEntityBN(sEntity);
	if(!pEntity) {m_LastErrorCode= APL_NET_SRV_APLAPIERR_BADENT;return S_OK;}
	
	*result= m_ld->AddQuery(_T('e'), 0, pEntity, 0, true, (LoadAllAttrs)?true:false);	

	return S_OK;
}


STDMETHODIMP CAplLoadData::AddUQuery(long FirstIndex, long PrevIndex, long *result)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	*result= -1;
	if(!m_ld){m_LastErrorCode= 1012;return S_OK;}

	*result= m_ld->AddQuery(FirstIndex, _T('u'), PrevIndex, (CaplEntity*)NULL, (CaplAttr*)NULL, true, true);		

	return S_OK;
}

STDMETHODIMP CAplLoadData::LoadQuery(VARIANT *result)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	if(!m_ld)
	{
		result->vt=VT_BOOL; 
		result->boolVal= 0;
		m_LastErrorCode= 1012;
		return S_OK;
	}

	aplExtent *resultExt= NULL;
	aplExtent ext;
	LongArray lArray;
	CString sWaitStr(m_swWaitText);

	if(m_bReturnResult) resultExt= &ext;
	else 
	{
		result->vt=VT_BOOL; 
		result->boolVal= 0;
	}

	bool bRes= m_ld->LoadEx(m_bAutoClearQueries, resultExt, sWaitStr);
	m_LastErrorCode= m_api->m_data.GetLastAplError();

	if(m_bReturnResult)
	{
		for (int i= 0; i<ext.GetSize(); i++)
		{
			lArray.Add((long)ext[i]);
		}	
		FillVariant<LongArray, long>(result, lArray, VT_I4);		
	}
	else
	{
		if(bRes || (m_api->m_data.GetLastAplError()!=APL_SOCK_OPERATION_IN_PROGRESS))
			result->boolVal= (short)0xffff;
	}

	return S_OK;
}

STDMETHODIMP CAplLoadData::ClearQuery(VARIANT *result)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
	result->vt=VT_BOOL; 
	result->boolVal= 0;
	if(!m_ld){m_LastErrorCode= 1012;return S_OK;}

	if(m_ld->ClearQuery())
		result->boolVal= (short)0xffff;

	return S_OK;
}

STDMETHODIMP CAplLoadData::get_ReturnResult(BOOL *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	*pVal= (true==m_bReturnResult)?TRUE:FALSE;

	return S_OK;
}

STDMETHODIMP CAplLoadData::put_ReturnResult(BOOL newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	m_bReturnResult= (TRUE==newVal)?true:false;

	return S_OK;
}

STDMETHODIMP CAplLoadData::get_AutoClearQueries(BOOL *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	*pVal= (true==m_bAutoClearQueries)?TRUE:FALSE;	

	return S_OK;
}

STDMETHODIMP CAplLoadData::put_AutoClearQueries(BOOL newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	m_bAutoClearQueries= (TRUE==newVal)?true:false;

	return S_OK;
}

STDMETHODIMP CAplLoadData::get_WaitText(BSTR *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	*pVal= m_swWaitText;
	
	return S_OK;
}

STDMETHODIMP CAplLoadData::put_WaitText(BSTR newVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	CString sStr(newVal);
	SysFreeString(m_swWaitText);
	m_swWaitText= sStr.AllocSysString();

	return S_OK;
}

STDMETHODIMP CAplLoadData::get_LastErrorCode(long *pVal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	*pVal= m_LastErrorCode;

	return S_OK;
}
