// AplLoadData.h : Declaration of the CAplLoadData

#ifndef __APLLOADDATA_H_
#define __APLLOADDATA_H_

#include "resource.h"       // main symbols
#include <apl_api.h>

/////////////////////////////////////////////////////////////////////////////
// CAplLoadData
class ATL_NO_VTABLE CAplLoadData : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CAplLoadData, &CLSID_AplLoadData>,
	public IDispatchImpl<IAplLoadData, &IID_IAplLoadData, &LIBID_APL_PSS_API_Lib>
{
public:
	CAplLoadData();
	~CAplLoadData();

DECLARE_REGISTRY_RESOURCEID(IDR_APLLOADDATA)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CAplLoadData)
	COM_INTERFACE_ENTRY(IAplLoadData)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()

//
public:
	CaplAPI* m_api;
	CaplLoadData* m_ld;
	
	bool m_bAutoClearQueries;
	bool m_bReturnResult;
	long m_LastErrorCode;
	CString m_sDefaultWaitText;
	BSTR m_swWaitText;

// IAplLoadData
public:
	STDMETHOD(AddUQuery)(/*[in]*/ long FirstIndex, /*[in]*/ long PrevIndex, /*[out, retval]*/ long* result);
	STDMETHOD(get_LastErrorCode)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_WaitText)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_WaitText)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_AutoClearQueries)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_AutoClearQueries)(/*[in]*/ BOOL newVal);
	STDMETHOD(get_ReturnResult)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_ReturnResult)(/*[in]*/ BOOL newVal);
	STDMETHOD(ClearQuery)(/*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadQuery)(/*[out, retval]*/ VARIANT* result);
	STDMETHOD(AddEQueryBN)(/*[in]*/ BSTR EntityName, /*[in, defaultvalue(FALSE)]*/ BOOL LoadAllAttrs, /*[out, retval]*/ long* result);
	STDMETHOD(AddEQuery)(/*[in]*/ long Entity, /*[in, defaultvalue(FALSE)]*/ BOOL LoadAllAttrs, /*[out, retval]*/ long* result);
	STDMETHOD(AddDQueryBN)(/*[in]*/ long Index, /*[in]*/ BSTR EntityName, /*[in]*/ BSTR AttrName, /*[in, defaultvalue(FALSE)]*/ BOOL LoadAllAttrs, /*[out, retval]*/ long* result);
	STDMETHOD(AddDQuery)(/*[in]*/ long Index, /*[in]*/ long Attr, /*[in, defaultvalue(FALSE)]*/ BOOL LoadAllAttrs, /*[out, retval]*/ long* result);
	STDMETHOD(AddRQueryBN)(/*[in]*/ long Index, /*[in]*/ BSTR EntityName, /*[in]*/ BSTR AttrName, /*[in, defaultvalue(FALSE)]*/ BOOL LoadAllAttrs, /*[out, retval]*/ long* result);
	STDMETHOD(AddRQuery)(/*[in]*/ long Index, /*[in]*/ long Entity, /*[in]*/ long Attr, /*[in, defaultvalue(FALSE)]*/ BOOL LoadAllAttrs, /*[out, retval]*/ long* result);
	STDMETHOD(AddBQueryBN)(/*[in]*/ long Instance, /*[in]*/ BSTR EntityName, /*[in]*/ BSTR AttrName, /*[in, defaultvalue(FALSE)]*/ BOOL LoadAllAttrs, /*[out, retval]*/ long* result);
	STDMETHOD(AddBQuery)(/*[in]*/ long Instance, /*[in]*/ long Entity, /*[in]*/ long Attr, /*[in, defaultvalue(FALSE)]*/ BOOL LoadAllAttrs, /*[out, retval]*/ long* result);
	STDMETHOD(AddAQuery)(/*[in]*/ long Index, /*[in]*/ long Instance, /*[in, defaultvalue(FALSE)]*/ BOOL LoadAllAttrs, /*[out, retval]*/ long* result);
	STDMETHOD(InitAPI)(/*[in]*/ long apiClass, /*[out, retval]*/ VARIANT* result);
};

#endif //__APLLOADDATA_H_
