// AplStringMap.h : Declaration of the CAplStringMap

#ifndef __APLSTRINGMAP_H_
#define __APLSTRINGMAP_H_

#include "resource.h"       // main symbols
#include <apl_api.h>

/////////////////////////////////////////////////////////////////////////////
// CAplStringMap
class ATL_NO_VTABLE CAplStringMap : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CAplStringMap, &CLSID_AplStringMap>,
	public IDispatchImpl<IAplStringMap, &IID_IAplStringMap, &LIBID_APL_PSS_API_Lib>
{
public:
	CAplStringMap()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_APLSTRINGMAP)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CAplStringMap)
	COM_INTERFACE_ENTRY(IAplStringMap)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()

// IAplStringMap
private:
	CaplStrMap m_map;

// IAplStringMap
public:
	STDMETHOD(get_Size)(/*[out, retval]*/ long *pVal);
	STDMETHOD(Sort)();
	STDMETHOD(GetByKey)(/*[in]*/ BSTR key, /*[out, retval]*/ long* result);
	STDMETHOD(GetByKeyP)(/*[in]*/ BSTR key, /*[out, retval]*/ long* result);
	STDMETHOD(FindIndexByKey)(/*[in]*/ BSTR key, /*[out, retval]*/ long* result);
	STDMETHOD(GetByIndex)(/*[in]*/ long index, /*[out]*/ BSTR* key, /*[out]*/ long* value, /*[out, retval]*/ BOOL* result);
	STDMETHOD(SetByIndex)(/*[in]*/ long index, /*[out]*/ long value, /*[out, retval]*/ BOOL* result);
	STDMETHOD(Clear)();
	STDMETHOD(Remove)(/*[in]*/ long index, /*[out, retval]*/ BOOL* result);
	STDMETHOD(Add)(/*[in]*/ BSTR key, /*[in]*/ long value, /*[out, retval]*/ long* result);
};

#endif //__APLSTRINGMAP_H_
