// aplMapElement.cpp : Implementation of CaplMapElement
#include "stdafx.h"
#include "APL_PSS_API.h"
#include "aplMapElement.h"

/////////////////////////////////////////////////////////////////////////////
// CAplLongMap

STDMETHODIMP CAplLongMap::Add(long key, long value, long *result)
{
	*result= m_map.Add(key, value);
	return S_OK;
}

STDMETHODIMP CAplLongMap::Remove(long index, BOOL *result)
{
	*result= FALSE;
	if(m_map.Remove(index))	*result= TRUE;
	return S_OK;
}

STDMETHODIMP CAplLongMap::Clear()
{
	m_map.RemoveAll();
	return S_OK;
}

STDMETHODIMP CAplLongMap::GetByIndex(long index, long* key, long* value, BOOL* result)
{
	if(index<0 || index>=m_map.Size)
	{
		*key= -1;
		*value= -1;
		*result= FALSE;
	}
	else
	{
		*key= m_map[index].in;
		*value= m_map[index].out;
		*result= TRUE;
	}

	return S_OK;
}

STDMETHODIMP CAplLongMap::FindIndexByKey(long key, long *result)
{
	*result= m_map.QFindByIn(key);
	return S_OK;
}

STDMETHODIMP CAplLongMap::GetByKey(long key, long *result)
{
	*result= m_map.QGetByIn(key);
	return S_OK;
}

STDMETHODIMP CAplLongMap::GetByKeyP(long key, long *result)
{
	*result= (long)m_map.QGetPointerByIn(key);
	return S_OK;
}

STDMETHODIMP CAplLongMap::Sort()
{
	m_map.SortIn();
	return S_OK;
}

STDMETHODIMP CAplLongMap::get_AutoSort(BOOL *pVal)
{
	if(m_map.bAutoSort) *pVal= TRUE;
	else *pVal= FALSE;
	
	return S_OK;
}

STDMETHODIMP CAplLongMap::put_AutoSort(BOOL newVal)
{
	if(newVal) m_map.bAutoSort= true;
	else m_map.bAutoSort= false;

	return S_OK;
}

STDMETHODIMP CAplLongMap::get_Size(long *pVal)
{
	*pVal= m_map.Size;
	return S_OK;
}

CaplMap* CAplLongMap::GetInnerMap()
{
	return &m_map;
}
