// aplMapElement.h : Declaration of the CaplMapElement

#ifndef __APLMAPELEMENT_H_
#define __APLMAPELEMENT_H_

#include "resource.h"       // main symbols
#include <apl_api.h>

/////////////////////////////////////////////////////////////////////////////
// CaplMapElement
class ATL_NO_VTABLE CAplLongMap : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CAplLongMap, &CLSID_AplLongMap>,
	public IDispatchImpl<IAplLongMap, &IID_IAplLongMap, &LIBID_APL_PSS_API_Lib>
{
public:
	CAplLongMap()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_APLMAPELEMENT)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CAplLongMap)
	COM_INTERFACE_ENTRY(IAplLongMap)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()

private:
	CaplMap m_map;

// IAplLongMap
public:
	CaplMap* GetInnerMap();
	STDMETHOD(get_Size)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_AutoSort)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_AutoSort)(/*[in]*/ BOOL newVal);
	STDMETHOD(Sort)();
	STDMETHOD(GetByKey)(/*[in]*/ long key, /*[out, retval]*/ long* result);
	STDMETHOD(GetByKeyP)(/*[in]*/ long key, /*[out, retval]*/ long* result);
	STDMETHOD(FindIndexByKey)(/*[in]*/ long key, /*[out, retval]*/ long* result);
	STDMETHOD(GetByIndex)(/*[in]*/ long index, /*[out]*/ long* key, /*[out]*/ long* value, /*[out, retval]*/ BOOL* result);
	STDMETHOD(Clear)();
	STDMETHOD(Remove)(/*[in]*/ long index, /*[out, retval]*/ BOOL* result);
	STDMETHOD(Add)(/*[in]*/ long key, /*[in]*/ long value, /*[out, retval]*/ long* result);
};

#endif //__APLMAPELEMENT_H_
