// AddInModProp.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "PSMDoc.h"
#include "AddInModProp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAddInModProp dialog


CAddInModProp::CAddInModProp(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CAddInModProp::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAddInModProp)
	m_descr = _T("");
	m_fname = _T("");
	m_name = _T("");
	//}}AFX_DATA_INIT
	m_pItem = 0;
}


void CAddInModProp::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddInModProp)
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Text(pDX, IDC_DESCR, m_descr);
	DDX_Text(pDX, IDC_FILE_NAME, m_fname);
	DDX_Text(pDX, IDC_NAME, m_name);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAddInModProp, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CAddInModProp)
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddInModProp message handlers


BOOL CAddInModProp::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));

	if(m_pItem==0)
	{
		EndDialog(0);
		return FALSE;
	}
	m_name = m_pItem->m_sName;
	m_descr = m_pItem->m_sDescr;
	m_fname = m_pItem->m_sPath;
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAddInModProp::OnBrowse() 
{
	UpdateData();
	CFileDialog f_dlg(true,_T("*.dll"),m_fname,OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, APL_T("  (*.dll)|*.dll|  (*.*)|*.*|"),this);
	if(f_dlg.DoModal()==IDOK)
	{
		CString str1, str2;
		int ind1, ind2;
		ind1 = m_fname.ReverseFind(_T('\\'));
		if(ind1<0) str1 = m_fname;
		else str1 = m_fname.Right(m_fname.GetLength()-ind1-1);
		str2 = f_dlg.GetPathName();
		ind2 = str2.ReverseFind(_T('\\'));
		if(ind2>-1) str2 = str2.Right(str2.GetLength()-ind2-1);
		if(str2.CompareNoCase(str1)!=0)
		{
			AfxMessageBox( APL_T("   !"));
			return;
		}
		m_fname = f_dlg.GetPathName();
		m_pItem->m_sPath = m_fname;
	}
	UpdateData(FALSE);
}

void CAddInModProp::OnOK() 
{
	if(!UpdateData()) return;
	if(m_pItem->m_sPath != m_fname)//  
	{
		m_pItem->m_sPath = m_fname;
	}
	
	CaplTranslateDialog::OnOK();
}
