// ApprovalListView.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "ApprovalListView.h"

#include "PSMDoc.h"
#include "TreeProductItem.h"
#include "aplTreeApprovalItem.h"
#include "aplTreeCharacteristicItem.h"
#include "aplCharacteristicGroupTreeItem.h"
#include "aplDocTreeItem.h"
#include "apl_lot_item.h"
#include "apl_prd_inst_item.h"
#include "aplBPTreeItem.h"
#include "aplBPInstTreeItem.h"
#include "act_res_treeitem.h"
#include "aplProjectTreeItem.h"
#include "aplDocCopyItem.h"
#include "aplChangeTreeItem.h"
#include "CaplRefusalTreeItem.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CApprovalListView

IMPLEMENT_DYNCREATE(CApprovalListView, CaplListView)

CApprovalListView::CApprovalListView()
{
	SetUniqueName(_T("CApprovalListView"));
}

CApprovalListView::~CApprovalListView()
{
}


BEGIN_MESSAGE_MAP(CApprovalListView, CaplListView)
	//{{AFX_MSG_MAP(CApprovalListView)
	ON_WM_CREATE()
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CApprovalListView drawing

void CApprovalListView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CApprovalListView diagnostics

#ifdef _DEBUG
void CApprovalListView::AssertValid() const
{
	CListView::AssertValid();
}

void CApprovalListView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CApprovalListView message handlers

int CApprovalListView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CaplListView::OnCreate(lpCreateStruct) == -1)
		return -1;
	// TODO: Add your specialized creation code here
    ListView_SetExtendedListViewStyle(m_hWnd,
		ListView_GetExtendedListViewStyle(m_hWnd)
                | LVS_EX_FULLROWSELECT|/*LVS_EX_GRIDLINES|*/LVS_EX_INFOTIP);

	LIST.InsertColumn(0, APL_T("."),LVCFMT_LEFT,80);
	LIST.InsertColumn(1, APL_T(""),LVCFMT_LEFT,80);
	LIST.InsertColumn(2, APL_T(""),LVCFMT_LEFT,100);
	LIST.InsertColumn(3, APL_T(""),LVCFMT_LEFT,110);
	LIST.InsertColumn(4, APL_T(" "),LVCFMT_LEFT,110);
	LoadColumnWidths();

	SetColumnDate(3);
	SetColumnDate(4);
	return 0;
}

void CApprovalListView::UpdateTreeItem(CaplTreeItem *item)
{
	//if(item==m_cur_item) return;
	m_cur_item=item;
	GetListCtrl().DeleteAllItems();
	if(item==0) return;
	CString m_type = _T(""),s_dt;
	aplExtent ext0;
	int i,k;
	CaplInstance *baseinst=0,*inst;
	CString buf;
	COleDateTime odt;

	CaplInstance *m_prd=0, *m_pdf=0,*m_val=0,*inst0=0; 
	
	if(item->m_type==APL_TREE_ITEM_PRODUCT)
	{
		m_prd=((CaplProductTreeItem*)item)->m_prd;
		m_pdf=((CaplProductTreeItem*)item)->m_pdf;
		if(m_pdf!=0) baseinst=m_pdf;
		else baseinst=m_prd;
	}
	else if(item->m_type==APL_TREE_ITEM_DOCUMENT)
	{
		if(((CaplDocTreeItem*)item)->m_rev!=0) baseinst=((CaplDocTreeItem*)item)->m_rev;
		else item->m_doc_data.GetAttrBN(((CaplDocTreeItem*)item)->m_inst, S::active, baseinst);
	}
	else if(item->m_type==APL_TREE_ITEM_LOT) baseinst=((CaplLotTreeItem*)item)->m_lot;
	else if(item->m_type==APL_TREE_ITEM_PRDINST) baseinst=((CaplPrdInstTreeItem*)item)->m_inst;
	else if(item->m_type==APL_TREE_ITEM_BP)
	{
		CaplInstance *rev=((CaplBPTreeItem*)item)->m_rev;
		if(rev) 
			baseinst=rev;
		else 
		{
			baseinst=((CaplBPTreeItem*)item)->m_inst;
			if(item->m_doc->m_api.m_bp_mgr.m_bUseVersions)
				item->m_doc_data.GetAttr(baseinst,item->m_doc->m_api.m_bp_mgr.a_bp_act,inst0);
		}
	}
	else if(item->m_type==APL_TREE_ITEM_BPINST) baseinst=((CaplBPInstTreeItem*)item)->m_inst;
	else if(item->m_type==APL_TREE_ITEM_REFUSAL) baseinst=((CaplRefusalTreeItem*)item)->m_refusal;
	else if(item->m_type==APL_TREE_ITEM_PROJECT) baseinst=((CaplProjectTreeItem*)item)->m_inst;
	else if(item->m_type==APL_TREE_ITEM_BPRES) baseinst=((CaplBPResourceTreeItem*)item)->m_inst;
	else if(item->m_type==APL_TREE_ITEM_CHANGE) baseinst=((CaplChangeTreeItem*)item)->m_chng;
	else if(item->m_type==APL_TREE_ITEM_CHARACTERISTIC)
	{
		CaplInstance *rev=((CaplCharacteristicTreeItem*)item)->m_rev;
		if(rev) 
			baseinst=rev;
		else 
		{
			baseinst=((CaplCharacteristicTreeItem*)item)->m_val;
		}
	}
	else if(item->m_type==APL_TREE_ITEM_CHARACTERISTICGROUP) baseinst=((CaplCharacteristicGroupTreeItem*)item)->m_group;
	else if(item->m_type==_T("DocHardCopy")) baseinst=((CaplDocCopyTreeItem*)item)->m_inst;

	if(baseinst==0)return;
	if(baseinst->GetType()==0)return;
	if(baseinst->GetAccessmode()>aplRO)return;
	
	if(item->m_doc->m_api.m_charact_mgr.m_bUseVersions)
	{
		if(item->m_doc->m_api.m_data.IsKindOf(baseinst,item->m_doc->m_api.m_charact_mgr.e_apl_charact_value))
			item->m_doc_data.GetAttr(baseinst,item->m_doc->m_api.m_charact_mgr.a_apl_charact_val_act_ver,inst0);
	}


	StartBusy();
	
	//CaplApprovalTreeItem:: LoadAllApproval(&(item->m_doc->m_api.m_data),);

	bool bShowRevocated=false;
	if(CPSMDoc::m_show_revocated_approval) bShowRevocated=true;

	SetStatusString( APL_T("  "));
	item->m_doc->m_api.m_appr_mgr.LoadItemApproval(baseinst,ext0,true,bShowRevocated);
	aplExtent ext1;
	if(inst0)
		if(inst0->GetAccessmode()<aplNO)
		{
			item->m_doc->m_api.m_appr_mgr.LoadItemApproval(inst0,ext1,true,bShowRevocated);
			ext0.Append(ext1);
		}
	SetStatusString(_T(""));
	SetRedraw(FALSE);

	CaplAPI *m_api=&(item->m_doc->m_api);

	for(i=0;i<ext0.Size;i++)
	{
		CaplInstance *appr=ext0[i];
		if(appr!=0)
		{
			if(!bShowRevocated)
			{
				m_api->m_data.GetAttr(appr,m_api->m_appr_mgr.a_appr_revocation_date_time,buf);
				if(buf!=_T("")) continue;
			}

			if(appr->GetAccessmode() == aplNO)
			{
				buf = APL_T("<   >");
			}
			else
			{
				item->m_doc_data.GetAttr(appr,m_api->m_appr_mgr.a_appr_status,inst);
				if(inst!=0) item->m_doc_data.GetAttr(inst,m_api->m_appr_mgr.a_appr_status_name,buf);
			}

			k=LIST.InsertItem(0,buf);
			LIST.SetItemData(k,(long)appr);
			if(appr->GetAccessmode() == aplNO)continue;

			item->m_doc_data.GetAttr(appr,m_api->m_appr_mgr.a_appr_role,buf);
			LIST.SetItemText(k,1,buf);

			item->m_doc_data.GetAttr(appr,m_api->m_appr_mgr.a_appr_pers_org,inst);
			if(inst!=0)
				if(item->m_doc_data.IsKindOf(inst, item->m_doc->m_api.m_appr_mgr.e_pers_org))
					item->m_doc_data.GetAttr(inst,m_api->m_appr_mgr.a_po_the_pers,inst);
			//if(inst!=0)item->m_doc_data.GetAttrBN(inst,_T("last_name"),buf);
			if(inst!=0)item->m_doc->m_api.GetItemName(inst,buf);
			LIST.SetItemText(k,2,buf);

			item->m_doc_data.GetAttr(appr,m_api->m_appr_mgr.a_appr_appr_date_time_s,s_dt);
			if(aplString2Date(s_dt,odt))
				buf=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
			else buf=_T("");
			LIST.SetItemText(k,3,buf);
			
			item->m_doc_data.GetAttr(appr,m_api->m_appr_mgr.a_appr_revocation_date_time,s_dt);
			if(aplString2Date(s_dt,odt))
				buf=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
			else buf=_T("");
			LIST.SetItemText(k,4,buf);
		}
	}
	SortColumn(m_aCombinedSortedColumns[0]);
	SortColumn(m_aCombinedSortedColumns[0]);
	SetRedraw(TRUE);
	StopBusy();
}

void CApprovalListView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	if(m_cur_item!=0)
	{
		int i=LIST.HitTest(point); 
		ShowProterties(false,i);
	}	
	CListView::OnLButtonDblClk(nFlags, point);
}

bool CApprovalListView::ShowProterties(bool bTest, int item)
{
	if(bTest) return true;
	if(item<0) return false;

	CaplInstance *inst=(CaplInstance *)LIST.GetItemData(item);
	if(inst!=0)
	{
		CaplApprovalTreeItem *doc_item=new CaplApprovalTreeItem(0,m_cur_item->m_doc,inst);
		if(doc_item!=0) 
		{
			doc_item->ShowProperties();
			m_cur_item->m_doc->m_items.Remove(m_cur_item->m_doc->m_items.Find(doc_item));
		}
	}
	return false;
}

LRESULT CApprovalListView::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if(message==((CPSMApp*)AfxGetApp())->m_view_update)
	{
		if(wParam==APL_UPDATE_TREE_ITEM)
		{
			CaplTreeItem* item = (CaplTreeItem*)lParam;
			UpdateTreeItem(item);
		}
	}
	
	return CaplListView::WindowProc(message, wParam, lParam);
}
