// AutoExpandItems.cpp: implementation of the CAutoExpandItems class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "AutoExpandItems.h"
#include "SetupShowonExpand.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAutoExpandItems::CAutoExpandItems()
{
	m_showintree_prd = APL_SHOW_DOC|APL_SHOW_CHARACT;
	m_showintree_pdf = APL_SHOW_DOC|APL_SHOW_CHARACT;
	m_showintree_prdinst = APL_SHOW_DOC|APL_SHOW_CHARACT;
	m_showintree_doc = APL_SHOW_DOC|APL_SHOW_CHARACT;
	m_showintree_charact = APL_SHOW_DOC;
	m_showintree_change = APL_SHOW_DOC|APL_SHOW_CHARACT;
	m_showintree_bp = APL_SHOW_DOC|APL_SHOW_CHARACT;
	m_showintree_bpres = APL_SHOW_DOC|APL_SHOW_CHARACT;
	m_showintree_bpinst = APL_SHOW_DOC|APL_SHOW_CHARACT;
	m_showintree_categ = APL_SHOW_DOC|APL_SHOW_CHARACT;
	m_showintree_lot = APL_SHOW_DOC|APL_SHOW_CHARACT;
	m_showintree_project = APL_SHOW_DOC|APL_SHOW_CHARACT;
	m_showintree_org = APL_SHOW_DOC|APL_SHOW_CHARACT;
	m_showintree_official = APL_SHOW_DOC|APL_SHOW_CHARACT;
	m_showintree_person = APL_SHOW_DOC|APL_SHOW_CHARACT;
	m_showintree_classif_system = APL_SHOW_DOC|APL_SHOW_CHARACT;
	m_showintree_classif_level = APL_SHOW_DOC|APL_SHOW_CHARACT;
	m_showintree_requirement = APL_SHOW_CHARACT;
	m_showintree_classifier_system = 0;
	m_showintree_classifier_level = 0;

	LoadData();
}

CAutoExpandItems::~CAutoExpandItems()
{
	SaveData();
}

bool CAutoExpandItems::LoadData()
{
	m_showintree_prd =		(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("Prd"), m_showintree_prd);
	m_showintree_pdf =		(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("Pdf"), m_showintree_pdf);
	m_showintree_prdinst =	(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("PrdInst"), m_showintree_prdinst);
	m_showintree_doc =		(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("Doc"), m_showintree_doc);
	m_showintree_charact =	(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("Charact"), m_showintree_charact);
	m_showintree_change =	(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("Change"), m_showintree_change);
	m_showintree_bp =		(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("BP"), m_showintree_bp);
	m_showintree_bpres =	(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("BPRes"), m_showintree_bpres);
	m_showintree_bpinst =	(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("BPInst"), m_showintree_bpinst);
	m_showintree_categ =	(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("Categ"), m_showintree_categ);
	m_showintree_lot =		(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("Lot"), m_showintree_lot);
	m_showintree_project =	(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("Project"), m_showintree_project);
	m_showintree_org =		(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("Organization"), m_showintree_org);
	m_showintree_official = (UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("Official"), m_showintree_official);
	m_showintree_person =	(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("Person"), m_showintree_person);
	m_showintree_classif_system =	(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("ClassifierSystem"), m_showintree_classif_system);
	m_showintree_classif_level =	(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("ClassifierLevel"),m_showintree_classif_level);
	m_showintree_requirement =	(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("Requirement"),m_showintree_requirement);
	m_showintree_classifier_system = (UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("Classifier_system"),m_showintree_classifier_system);
	m_showintree_classifier_level =	(UINT)AfxGetApp()->GetProfileInt(_T("ShowItemsInTree"),_T("Classifier_level"),m_showintree_classifier_level);

	return true;
}

bool CAutoExpandItems::SaveData()
{
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("Prd"), m_showintree_prd);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("Pdf"), m_showintree_pdf);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("PrdInst"), m_showintree_prdinst);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("Doc"), m_showintree_doc);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("Charact"), m_showintree_charact);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("Change"), m_showintree_change);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("BP"), m_showintree_bp);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("BPRes"), m_showintree_bpres);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("BPInst"), m_showintree_bpinst);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("Categ"), m_showintree_categ);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("Lot"), m_showintree_lot);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("Project"), m_showintree_project);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("Organization"), m_showintree_org);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("Official"), m_showintree_official);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("Person"), m_showintree_person);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("ClassifierSystem"), m_showintree_classif_system);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("ClassifierLevel"),m_showintree_classif_level);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("Requirement"),m_showintree_requirement);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("Classifier_system"),m_showintree_classifier_system);
	AfxGetApp()->WriteProfileInt(_T("ShowItemsInTree"),_T("Classifier_level"),m_showintree_classifier_level);

	return true;
}

void CAutoExpandItems::Setup()
{
	CSetupShowonExpandDlg dlg;
	dlg.m_auto_expand_items = this;
	if(dlg.DoModal()==IDOK)
	{
		LoadData();
	}
}
