// ClipboardTreeItem.cpp: implementation of the CClipboardTreeItem class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "psm.h"
#include "ClipboardTreeItem.h"
#include <apl_api.h>
#include "PSMDoc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
#define _APL_TREE_ITEM_CHEK_PARAM \
		if(m_tree==0) return false;\
		if(m_doc==0) return false;

#define _APL_TREE_ITEM_CHEK_PARAM1 \
		if(m_tree==0) return;\
		if(m_doc==0) return;

CClipboardTreeItem::CClipboardTreeItem(CTreeCtrl *tree, CPSMDoc *doc)
{
	m_tree = tree;
	m_doc = doc;
	if(m_doc)
		m_doc->m_items.Add(this);
	m_expanded = false;
}

CClipboardTreeItem::~CClipboardTreeItem()
{

}

bool CClipboardTreeItem::GetName(CString &name)
{
	name =  APL_T(" ");
	return true;
}

bool CClipboardTreeItem::CreateTreeItem(HTREEITEM parent_item)
{
	_APL_TREE_ITEM_CHEK_PARAM
		CString buf;
	GetName(buf);
	InsetItem(buf, ICON_CLIPBOARD, parent_item);
	m_fictive_item = NULL;

	return 	true;
}

bool CClipboardTreeItem::RefreshItem()
{
	return true;
}
