#if !defined(AFX_IMPORTEFDLG_H__7F6695CA_AC7A_4078_82F7_9173E1DC01A7__INCLUDED_)
#define AFX_IMPORTEFDLG_H__7F6695CA_AC7A_4078_82F7_9173E1DC01A7__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ImportEfDlg.h : header file
//
#include <apl_api.h>
#include "afxwin.h"
class CaplAPI;
/////////////////////////////////////////////////////////////////////////////
// CImportEfDlg dialog
#define STATUS_UNKNOWN 0
#define STATUS_NEW 1
#define STATUS_EXIST 2
#define STATUS_CONFLICT 3
#define STATUS_UNALLOWED 4

class CImportEfDlg : public CaplTranslateDialog
{
	struct Str_Inst
	{
		CString str;
		CaplInstance *inst;
	};
	struct Tnauo_element
	{
		CaplInstance *relating;
		CaplInstance *related;
		CString pos;
		double count;
		CaplInstance *new_inst;
	};
// Construction
public:
	CImportEfDlg(CWnd* pParent = NULL);   // standard constructor

public:
	void PrepareDBSave();
	CaplStepData data;
	CString m_sFilePath; //    .

	CaplAPI *m_api;

	bool m_Normalize;
	bool m_Sincronize;

	bool m_ReloadFolder;

	CaplMap pc_map;
	CaplMap prd_map;
	CaplMap pd_map;

	CaplMap tree_map;
	CaplMap inst_stat_map;


	CString m_sTopFolderName; //     

	aplExtent m_extPdr4Delete; // ,     .

// Dialog Data
	//{{AFX_DATA(CImportEfDlg)
	enum { IDD = IDD_IMPORT_EF };
	CButton	m_create_folder_ctrl;
	CEdit	m_folder_name_ctrl;
	CButton	m_auto_normalize_btn;
	CButton	m_NormalizeBtn;
	CStatic	m_subaction;
	CProgressCtrl	m_progress1;
	CStatic	m_action;
	CProgressCtrl	m_progress;
	CButton	m_SaveDbBtn;
	CButton	m_SaveFileBtn;
	CButton	m_SinchonizeBtn;
	CTreeCtrl	m_tree;
	CEdit	m_FileName;
	BOOL	m_create_folder;
	BOOL	m_imp_category;
	BOOL	m_imp_geom;
	BOOL	m_imp_doc;
	BOOL	m_auto_asm_set;
	BOOL	m_set_new_rew_active;
	BOOL	m_dbl_click_edit;
	BOOL	m_replace_asm;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CImportEfDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	CImageList imagelist;

	void NormalizeCategory();
	void TranslateMappedItem();
	void ShowContentInTree();
	void SincronizePrd();
	void SincronizeCateg();

	void InsertCategoryInTree(CaplInstance *categ, HTREEITEM treeitem,
		aplExtent &ext_rel,CaplMap &map_cat_item);

	void InsertProductInTree(CaplInstance *pd, HTREEITEM treeitem,aplExtent &ext_rel);

	// Generated message map functions
	//{{AFX_MSG(CImportEfDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnSelectFile();
	afx_msg void OnSaveFile();
	afx_msg void OnNormalize();
	afx_msg void OnSinchronize();
	afx_msg void OnDblclkPrdTree(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSaveDb();
	afx_msg void OnKeydownPrdTree(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDel();
	afx_msg void OnEdit();
	afx_msg void OnDblClikEdit();	
	afx_msg void OnCreateFolder();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedAutoSetMade2();
	afx_msg void OnBnClickedAutoSetMade();
	CButton m_AutoSetMadeCtrl;
	CEdit m_MadeIdSubstrCtrl;
	CButton m_AutoSetBoughtCtrl;
	CButton m_AutoSetStdCtrl;
//	afx_msg void OnClose();
	virtual BOOL DestroyWindow();
	CButton m_autoParseStdNameCtrl;
	CButton m_create_folder_all_ctrl;
	CButton m_dbl_click_edit_ctrl;
	CButton m_DenyCreateStdCtrl;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_IMPORTEFDLG_H__7F6695CA_AC7A_4078_82F7_9173E1DC01A7__INCLUDED_)
