// PrdInstWhereUsedListView.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "PrdInstWhereUsedLV.h"
#include "PSMDoc.h"
#include "apl_prd_inst_item.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPrdInstWhereUsedListView

IMPLEMENT_DYNCREATE(CPrdInstWhereUsedListView, CListView)

CPrdInstWhereUsedListView::CPrdInstWhereUsedListView()
{
	SetUniqueName(_T("CPrdInstWhereUsedListView"));
}

CPrdInstWhereUsedListView::~CPrdInstWhereUsedListView()
{
}


BEGIN_MESSAGE_MAP(CPrdInstWhereUsedListView, CaplListView)
	//{{AFX_MSG_MAP(CPrdInstWhereUsedListView)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPrdInstWhereUsedListView drawing

void CPrdInstWhereUsedListView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CPrdInstWhereUsedListView diagnostics

#ifdef _DEBUG
void CPrdInstWhereUsedListView::AssertValid() const
{
	CaplListView::AssertValid();
}

void CPrdInstWhereUsedListView::Dump(CDumpContext& dc) const
{
	CaplListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPrdInstWhereUsedListView message handlers

int CPrdInstWhereUsedListView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CaplListView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
    ListView_SetExtendedListViewStyle(m_hWnd,
		ListView_GetExtendedListViewStyle(m_hWnd)
                | LVS_EX_FULLROWSELECT|/*LVS_EX_GRIDLINES|*/LVS_EX_INFOTIP);

	LIST.InsertColumn(0, APL_T("."),LVCFMT_LEFT,80);
	LIST.InsertColumn(1, APL_T(" "),LVCFMT_LEFT,80);
	LIST.InsertColumn(2, APL_T(" "),LVCFMT_LEFT,120);
	LIST.InsertColumn(3, APL_T(" "),LVCFMT_LEFT,140);
	LIST.InsertColumn(4, APL_T(" "),LVCFMT_LEFT,100);
	LIST.InsertColumn(5, APL_T(" "),LVCFMT_LEFT,100);
	LIST.InsertColumn(6, APL_T(""),LVCFMT_LEFT,200);
	LoadColumnWidths();

	SetColumnDate(4);
	SetColumnDate(5);	

	return 0;
}
//******************************************************************
void CPrdInstWhereUsedListView::UpdateTreeItem(CaplTreeItem *item)
{
	m_cur_item=item;
	GetListCtrl().DeleteAllItems();
	if(item==0) return;
	
	if(item->m_type!=APL_TREE_ITEM_PRDINST) return;
	CaplInstance *prd_inst=((CaplPrdInstTreeItem*)item)->m_inst; 
	if(prd_inst==0) return;

	CaplInstance *prd=0, *pdf=0, *inst, *rel;
	CString buf,ver;

	CaplAPI &m_api=item->m_doc->m_api;

	aplExtent ext,ext_rel;
	aplExtent rel_contexts;

	StartBusy();	
	m_api.m_prd_inst_mgr.WhereUsedPIinPI(prd_inst,ext_rel,ext);
	SetRedraw(FALSE);

	int show_history;
	m_api.m_options_mgr.GetOptionValueBN( APL_NO_T("   "),show_history,1);
	CString date_removed;
	for(int i=0;i<ext_rel.Size;i++)
	{
		rel=ext_rel[i];
		if(rel==0) continue;
		m_api.m_data.GetAttr(rel,m_api.m_prd_inst_mgr.a_prd_inst_rel_relating,inst);
		if(inst==0) continue;
		m_api.m_data.GetAttr(rel,m_api.m_prd_inst_mgr.a_prd_inst_rel_date_removed,date_removed);
		if(!show_history)
		{
			if(date_removed!=_T("")) continue;
		}
		int ico;
		if(m_api.m_data.IsKindOf(inst,m_api.m_prd_inst_mgr.e_prd_inst)) 
		{
			ico=ICON_PRD_INST+3;
		}
		else
		{
			ico=ICON_ORGANIZATION;
		}
		if(date_removed!=_T("")) ico++;

		if(m_api.m_data.IsKindOf(inst,m_api.m_prd_inst_mgr.e_prd_inst)) 
		{
			m_api.m_data.GetAttr(inst,m_api.m_prd_inst_mgr.a_prd_inst_id,buf);
		}
		else
		{
			m_api.m_data.GetAttr(inst,m_api.m_appr_mgr.a_org_id,buf);
		}

		int k=LIST.InsertItem(-1,buf,ico);
		LIST.SetItemData(k,(long)rel);

		if(m_api.m_data.IsKindOf(inst,m_api.m_prd_inst_mgr.e_prd_inst)) 
		{
			m_api.m_data.GetAttr(inst,m_api.m_prd_inst_mgr.a_prd_inst_sn,buf);
			LIST.SetItemText(k,1,buf);
			
			m_api.m_data.GetAttr(inst,m_api.m_prd_inst_mgr.a_prd_inst_pdf,pdf);
			if(pdf!=0)
			{
				m_api.m_data.GetAttr(pdf,m_api.m_prd_mgr.a_pdf_id,ver);
				m_api.m_data.GetAttr(pdf,m_api.m_prd_mgr.a_pdf_prd,prd);
				m_api.m_data.GetAttr(prd,m_api.m_prd_mgr.a_prd_id,buf);
				if(ver!=_T("")) {buf+=_T(" - "); buf+=ver;}
				LIST.SetItemText(k,2,buf);
				m_api.m_data.GetAttr(prd,m_api.m_prd_mgr.a_prd_name,buf);
				LIST.SetItemText(k,3,buf);
			}
		}
		else
		{
			m_api.m_data.GetAttr(inst,m_api.m_appr_mgr.a_org_name,buf);
			LIST.SetItemText(k,1,buf);
		}

		m_api.m_data.GetAttr(rel,m_api.m_prd_inst_mgr.a_prd_inst_rel_date_installed,buf);
		if(buf!=_T(""))
		{
			COleDateTime odt;
			aplString2Date(buf,odt);
			buf=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
			LIST.SetItemText(k,4,buf);
			
			if(date_removed!=_T(""))
			{
				aplString2Date(date_removed,odt);
				buf=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
				LIST.SetItemText(k,5,buf);
			}
		}
		m_api.m_data.GetAttr(rel,m_api.m_prd_inst_mgr.a_prd_inst_rel_frames_of_reference,rel_contexts);
		m_api.m_prd_inst_mgr.PrintItemContextInString(rel_contexts,buf);
		if(buf!=_T(""))
			LIST.SetItemText(k,6,buf);

	}
	
	SortColumn(m_aCombinedSortedColumns[0]);
	SortColumn(m_aCombinedSortedColumns[0]);
	SetRedraw(TRUE);
	StopBusy();
}
LRESULT CPrdInstWhereUsedListView::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if(message==((CPSMApp*)AfxGetApp())->m_view_update)
	{
		if(wParam==APL_UPDATE_TREE_ITEM)
		{
			CaplTreeItem* item = (CaplTreeItem*)lParam;
			UpdateTreeItem(item);
		}
	}
	
	return CaplListView::WindowProc(message, wParam, lParam);
}
