// aplClassifierTreeItem.cpp: implementation of the CaplClassifierTreeItem class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "aplTreeItem.h"

#include "NavigatorView.h"

#include "PSMDoc.h"
#include "resource.h"
//#include "HackDefence.h"

#include "TabView.h"
#include "aplTopLevelItem.h"

#include "TreeProductItem.h"
#include "aplClassifierTreeItem.h"
#include "ProductCategoryDlg.h"
#include "aplDocTreeItem.h"
#include "aplFolderTreeItem.h"
#include "apl_lot_item.h"
#include "apl_prd_inst_item.h"
#include "aplBPTreeItem.h"
#include "aplBPInstTreeItem.h"
#include "aplMessageTreeItem.h"
#include "Defence.h"
#include "aplQueryItem.h"
#include "aplChangeTreeItem.h"
#include "aplProjectTreeItem.h"
#include "aplOrganizationTreeItem.h"
#include "aplPersonTreeItem.h"
#include "aplTreeCharacteristicItem.h"
#include "aplCharacteristicGroupTreeItem.h"


const TCHAR CF_HTREEITEN_NAME[]=_T("CF_APL_H_TREE_ITEM");
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CaplClassifierTreeItem::CaplClassifierTreeItem(CTreeCtrl* tree, CPSMDoc* pDoc,
	CaplInstance* inst, CaplInstance* system, CaplInstance *folder)
{
	m_doc = pDoc;
	m_tree = tree;
	m_type = APL_TREE_ITEM_CLASSIFIERSYSTEM;
	m_inst = inst;
	m_system = system;
	m_folder=folder;
	m_classifier=0;
	if (m_doc)
	{
		m_doc->m_items.Add(this);
		if (inst !=
			0 &&
			m_doc_data.IsKindOf(inst,
						m_doc->m_api.m_classifier_mgr.e_apl_classifier_level))
		{
			m_type = APL_TREE_ITEM_CLASSIFIERLEVEL;
		}
	}
}

CaplClassifierTreeItem::~CaplClassifierTreeItem()
{
	RemoveFromParenContents(m_inst);
}
//****************************************************************************
bool CaplClassifierTreeItem::MoveClassifierLevel(CaplClassifierTreeItem* moved_item)
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL;
	if(moved_item==0 ) return false;

	int i;
	//  ,  
//	CaplInstance *parent_old,*system_moved,*system_tmp;
	CaplInstance* inst_moved = ((CaplClassifierTreeItem*) moved_item)->m_inst;
	if (inst_moved == 0)
		return false;

	HTREEITEM parent = m_tree->GetNextItem(moved_item->m_item,TVGN_PARENT);
	CaplTreeItem *parent_item = (CaplTreeItem*)m_tree->GetItemData(parent);
	if(parent_item==this){
		//    !
		return true;
	}

	if(moved_item->m_type==APL_TREE_ITEM_CLASSIFIERLEVEL){
		if(!m_doc->m_api.m_classifier_mgr.MoveClassifierLevel(inst_moved,m_inst)){
			return false;
		}
	}else if(moved_item->m_type==APL_TREE_ITEM_CLASSIFIERSYSTEM){
		if(!m_doc->m_api.m_classifier_mgr.MoveClassifierSystem(inst_moved,m_inst)){
			return false;
		}
	}else{
		return false;
	}

	//////////////////    -   !    !
	m_doc_data.NET_SaveChanges();	

	//////////////////    item-
	CaplClassifierTreeItem *c_item;
	//   CaplClassifierTreeItem -    .   -  
	if(parent_item->m_type== APL_TREE_ITEM_CLASSIFIERLEVEL || parent_item->m_type== APL_TREE_ITEM_CLASSIFIERSYSTEM)
	{
		i = m_doc->m_items.Find(moved_item);
		if (i != -1){
			m_doc->m_items.Remove(i);
		}
		parent_item->RefreshItem();
	}
	c_item=new CaplClassifierTreeItem(m_tree,m_doc,inst_moved,m_system);
	c_item->CreateTreeItem(m_item);
	m_contents.Add(inst_moved);

	ShowContents();
	MyExpand();
	RefreshItem();
	
	return true;
}
//****************************************************************
bool CaplClassifierTreeItem::PasteItem(CaplTreeItem* item, CPoint* point)
{
	//#ifdef _DEBUG
	//#endif
	if (item == 0)
		return false;
	if (m_tree == 0)
		return false;
	if (m_doc == 0)
		return false;
	if (m_inst != 0){
		if (m_inst->GetAccessmode() > aplRW)
		{
			AfxMessageBox( APL_T("     !"),
				MB_OK | MB_ICONERROR);
			return false;
		}
	}
	if(item->m_type == APL_TREE_ITEM_CLASSIFIERSYSTEM && m_doc->m_api.m_data.IsKindOf(m_inst,m_doc->m_api.m_classifier_mgr.e_apl_classifier_system))
	{
		if(IDYES==AfxMessageBox( APL_T("    ?"), MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2))
			MoveClassifierLevel((CaplClassifierTreeItem*)item);
		return true;
	}
	else if(item->m_type == APL_TREE_ITEM_CLASSIFIERLEVEL)
	{
		if(IDYES==AfxMessageBox( APL_T("     ?"), MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2))
			MoveClassifierLevel((CaplClassifierTreeItem*)item);
		return true;
	}

	CaplClassifierTreeItem* c_item=0;
	CaplInstance *inst=0;

	if (m_inst == 0)
		return false;
	
	// Product
	if (item->m_type == APL_TREE_ITEM_PRODUCT)
	{
		inst = ((CaplProductTreeItem*) item)->m_pdf;
		if (inst == 0)
			inst = ((CaplProductTreeItem *) item)->m_prd;
	}
	// Document
	else if (item->m_type == APL_TREE_ITEM_DOCUMENT)
	{
		inst = ((CaplDocTreeItem*) item)->m_inst;
	}
	else if (item->m_type == APL_TREE_ITEM_CATEGORIES)
	{
		inst = ((CaplCategoryTreeItem*) item)->m_inst;
	}
	else if (item->m_type == APL_TREE_ITEM_LOT)
	{
		inst = ((CaplLotTreeItem*) item)->m_lot;
	}
	else if (item->m_type == APL_TREE_ITEM_PRDINST)
	{
		inst = ((CaplPrdInstTreeItem*) item)->m_inst;
	}
	else if (item->m_type == APL_TREE_ITEM_BP)
	{
		inst = ((CaplBPTreeItem*) item)->m_inst;
	}
	else if (item->m_type == APL_TREE_ITEM_BPINST)
	{
		inst = ((CaplBPInstTreeItem*) item)->m_inst;
	}
	else if (item->m_type == APL_TREE_ITEM_PROJECT)
	{
		if (m_doc->m_bUseProject)
		{
			inst = ((CaplProjectTreeItem*) item)->m_inst;
		}
	}
	else if (item->m_type == APL_TREE_ITEM_ORGANIZATION)
	{
		if (m_doc->m_bUseProject)
		{
			inst = ((CaplOrganizationTreeItem*) item)->m_inst;
		}
	}
	else if (item->m_type == APL_TREE_ITEM_PERSON)
	{
		if (m_doc->m_bUseProject)
		{
			inst = ((CaplPersonTreeItem*) item)->m_person;
		}
	}
	else if (item->m_type == APL_TREE_ITEM_OFFICIAL)
	{
		if (m_doc->m_bUseProject)
		{
			inst = ((CaplPersonTreeItem*) item)->m_official;
		}
	}
	//	else if(item->m_type==APL_TREE_ITEM_MESSAGE)
	//	{
	//		CaplInstance  *mes, *sender, *recip, *folder;
	//		CaplInstance *person= m_doc_data.GetCurrUser();
	//		if(person)
	//			m_doc_data.GetAttrBN(person, _T("personality"), inst);
	//		if(inst)
	//			m_doc_data.GetAttrBN(inst, _T("the_person"), person);
	//		
	//		mes=((CaplMessageTreeItem*)item)->m_message;
	//		folder=((CaplMessageTreeItem*)item)->m_folder; 
	//		if(mes==0) return false;
	//		if(folder==m_inst) return true;
	//
	//		m_doc_data.GetAttr(mes, m_doc->m_api.m_message_mgr.a_message_sender, sender);
	//		m_doc_data.GetAttr(mes, m_doc->m_api.m_message_mgr.a_message_recipient, recip);
	//		
	//		//    ...
	//		if(person!=sender && person!=recip) return false;
	//
	//		bool bSave= false;
	//		CaplInstance* rec_folder, *send_folder;
	//		m_doc_data.GetAttr(mes, m_doc->m_api.m_message_mgr.a_message_recipient_folder, rec_folder);
	//		m_doc_data.GetAttr(mes, m_doc->m_api.m_message_mgr.a_message_sender_folder, send_folder);
	//		
	//		if(sender==person)//
	//		{
	//			//       
	//			if(send_folder && rec_folder!=folder)
	//			{
	//				m_doc->m_api.m_folder_mgr.RemoveFromFolder(send_folder, mes);
	//				//  
	//				CaplFolderTreeItem* fldOld= ((CaplMessageTreeItem*)item)->m_folderItem;
	//				int ind= fldOld->m_contents.Find(mes);
	//				fldOld->m_contents.Remove(ind);
	//			}
	//			else
	//			{
	//				m_doc->m_send_or_dr_messages.Remove(m_doc->m_send_or_dr_messages.Find(mes));
	//			}
	//
	//			m_doc->m_api.m_folder_mgr.AddToFolder(m_inst, mes);
	//			m_doc_data.PutAttr(mes, 
	//				m_doc->m_api.m_message_mgr.a_message_sender_folder, m_inst);		
	//			
	//			folder= send_folder;
	//
	//			bSave= true;
	//		}
	//		if(recip==person)//
	//		{
	//			//       
	//			if(rec_folder && send_folder!=folder)
	//			{
	//				m_doc->m_api.m_folder_mgr.RemoveFromFolder(folder, mes);
	//				//  
	//				((CaplMessageTreeItem*)item)->m_folderItem->m_contents.Remove(
	//					((CaplMessageTreeItem*)item)->m_folderItem->m_contents.Find(mes));
	//			}
	//			else
	//			{
	//				m_doc->m_incoming_messages.Remove(m_doc->m_incoming_messages.Find(mes));
	//			}
	//			
	//			m_doc->m_api.m_folder_mgr.AddToFolder(m_inst, mes);
	//			m_doc_data.PutAttr(mes, 
	//				m_doc->m_api.m_message_mgr.a_message_recipient_folder, m_inst);
	//			
	//			folder= rec_folder;
	//
	//			bSave= true;
	//		}
	//		if(bSave)
	//		{
	//			m_doc_data.NET_SaveChanges();
	//			
	//			//
	//			for(int j= 0; j<m_doc->m_items.GetSize(); j++)
	//			{
	//				if(m_doc->m_items[j]->m_type==APL_TREE_ITEM_MESSAGE
	//					&& mes==((CaplMessageTreeItem*)m_doc->m_items[j])->m_message
	//					&& folder==((CaplMessageTreeItem*)m_doc->m_items[j])->m_folder)
	//				{
	//					CaplFolderTreeItem* fldOld= ((CaplMessageTreeItem*)m_doc->m_items[j])->m_folderItem;
	//					if(fldOld)
	//						fldOld->m_contents.Remove(fldOld->m_contents.Find(mes));
	//
	//					m_doc->m_items.Remove(j);
	//					
	//					if(fldOld)fldOld->ShowContents();
	//					break;
	//				}
	//			}
	//
	//			// ...    
	////			((CaplMessageTreeItem*)item)->m_iShowPropertyEvent= APL_MESSAGE_DELETE_EVENT;
	////			((CaplMessageTreeItem*)item)->RefreshAllMessages(m_doc);				
	//		}
	//	}
	// Change
	else if(item->m_type == APL_TREE_ITEM_CHANGE)
	{
		inst = ((CaplChangeTreeItem*) item)->m_chng;
	}
	// Folder
	else if (item->m_type == APL_TREE_ITEM_FOLDER)
	{
		inst = ((CaplFolderTreeItem*) item)->m_inst;
	}
	else if (item->m_type == APL_TREE_ITEM_CLASSIFIERSYSTEM)
	{
		inst = ((CaplClassifierTreeItem*) item)->m_inst;
	}
	// Find
	//	else if(item->m_type==APL_TREE_ITEM_QUERY || item->m_type==APL_TREE_ITEM_QUERY_NIIAO ||
	//				item->m_type==APL_TREE_ITEM_FIND||item->m_type==APL_TREE_ITEM_COMBINED_TABLE)
	//	{
	//		aplExtent* contents=0;
	//		((CaplQueryTreeItem*)item)->LoadQueryResult();
	//		contents=&(((CaplQueryTreeItem*)item)->m_exec_result);
	//		inst=(((CaplQueryTreeItem*)item)->m_inst);
	//		CMenu menu;  gSetPsmResourceHandle();
	//		CMenu *pPopup;
	//		VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
	//		CaplMenu::Install(m_tree); 
	//		pPopup = menu.GetSubMenu(INDEX_PASTE_QUERY_MENU);
	//		if(pPopup==0) return false;
	//		if(inst==0){
	//			pPopup->EnableMenuItem(ID_QUERY_COPY_QUERY, MF_BYCOMMAND | MF_GRAYED);
	//		}else if(inst->GetTemporary()){
	//			pPopup->EnableMenuItem(ID_QUERY_COPY_QUERY, MF_BYCOMMAND | MF_GRAYED);
	//		}
	//		if(contents->GetSize()==0)
	//			pPopup->EnableMenuItem(ID_QUERY_COPY_CONTENT, MF_BYCOMMAND | MF_GRAYED);
	//		
	//		POINT pnt;
	//		if(point==0)
	//		{
	//			RECT rect;
	//			m_tree->GetItemRect(m_item,&rect,TRUE);
	//			m_tree->ClientToScreen(&rect);
	//			pnt.x=rect.right;
	//			pnt.y=rect.bottom;
	//		}
	//		else
	//		{
	//			pnt.x=point->x;
	//			pnt.y=point->y;
	//		}
	//		
	//		BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
	//			TPM_RIGHTBUTTON|TPM_RETURNCMD,pnt.x,pnt.y,m_tree);
	//		
	//		bool old_flag=m_doc->m_api.m_folder_mgr.m_AutoSave;
	//		m_doc->m_api.m_folder_mgr.m_AutoSave=false;
	//		switch (res)
	//		{
	//		case ID_QUERY_COPY_QUERY:
	//			m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
	//			break;
	//		case ID_QUERY_COPY_CONTENT:
	//			for(int i=0;i<contents->GetSize();i++){
	//				inst=contents->GetAt(i);
	//				if(inst==0) continue;
	//				m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
	//			}
	//			break;
	//		}
	//		m_doc->m_api.m_folder_mgr.m_AutoSave=old_flag;
	//		if(old_flag) m_doc_data.NET_SaveChanges();
	//	}
	//	else if(item->m_type==APL_TREE_ITEM_COMBINED_TABLE)
	//	{
	//		aplExtent* contents=0;
	//		((CaplQueryTreeItem*)item)->LoadQueryResult();
	//		contents=&(((CaplQueryTreeItem*)item)->m_exec_result);
	//		contents->Clear();
	//		inst=(((CaplQueryTreeItem*)item)->m_inst);
	//		CMenu menu;  gSetPsmResourceHandle();
	//		CMenu *pPopup;
	//		VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
	//		CaplMenu::Install(m_tree); 
	//		pPopup = menu.GetSubMenu(INDEX_PASTE_QUERY_MENU);
	//		if(pPopup==0) return false;
	//		if(inst==0){
	//			pPopup->EnableMenuItem(ID_QUERY_COPY_QUERY, MF_BYCOMMAND | MF_GRAYED);
	//		}else if(inst->GetTemporary()){
	//			pPopup->EnableMenuItem(ID_QUERY_COPY_QUERY, MF_BYCOMMAND | MF_GRAYED);
	//		}
	//		pPopup->ModifyMenu(ID_QUERY_COPY_QUERY,MF_BYCOMMAND,ID_QUERY_COPY_QUERY,APL_T("  "));
	//		if(contents->GetSize()==0)
	//			pPopup->EnableMenuItem(ID_QUERY_COPY_CONTENT, MF_BYCOMMAND | MF_GRAYED);
	//		
	//		POINT pnt;
	//		if(point==0)
	//		{
	//			RECT rect;
	//			m_tree->GetItemRect(m_item,&rect,TRUE);
	//			m_tree->ClientToScreen(&rect);
	//			pnt.x=rect.right;
	//			pnt.y=rect.bottom;
	//		}
	//		else
	//		{
	//			pnt.x=point->x;
	//			pnt.y=point->y;
	//		}
	//		
	//		BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
	//			TPM_RIGHTBUTTON|TPM_RETURNCMD,pnt.x,pnt.y,m_tree);
	//		
	//		bool old_flag=m_doc->m_api.m_folder_mgr.m_AutoSave;
	//		m_doc->m_api.m_folder_mgr.m_AutoSave=false;
	//		switch (res)
	//		{
	//		case ID_QUERY_COPY_QUERY:
	//			m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
	//			break;
	//		case ID_QUERY_COPY_CONTENT:
	//			for(int i=0;i<contents->GetSize();i++){
	//				inst=contents->GetAt(i);
	//				if(inst==0) continue;
	//				m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
	//			}
	//			break;
	//		}
	//		m_doc->m_api.m_folder_mgr.m_AutoSave=old_flag;
	//		if(old_flag) m_doc_data.NET_SaveChanges();
	//	}
//++***    
	else if(item->m_type == APL_TREE_ITEM_CHARACTERISTIC||item->m_type == APL_TREE_ITEM_CHARACTERISTICGROUP)
	{
		CMenu menu;  gSetPsmResourceHandle();
		CMenu *pPopup;
		VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
		// 		VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
		CaplMenu::Install(m_tree); // 		VERIFY(CaplMenu::Install(m_tree, ePopupMenu ));
		pPopup = menu.GetSubMenu(INDEX_CHARACTERISTIC_MENU);
		if(pPopup==0) return false;
		POINT pnt;
		if(point==0)
		{
			RECT rect;
			m_tree->GetItemRect(m_item,&rect,TRUE);
			m_tree->ClientToScreen(&rect);
			pnt.x=rect.right;
			pnt.y=rect.bottom;
		}
		else
		{
			pnt.x=point->x;
			pnt.y=point->y;
		}

		BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
			TPM_RIGHTBUTTON|TPM_RETURNCMD,pnt.x,pnt.y,m_tree);

		//  
		if (res == ID_CHARACTERISTIC_COPY)
		{
			if(item->m_type == APL_TREE_ITEM_CHARACTERISTIC)
			{
				CaplInstance *i_val=((CaplCharacteristicTreeItem *)item)->m_val;
				CreateCharacteristic(i_val);
			}
			else if(item->m_type == APL_TREE_ITEM_CHARACTERISTICGROUP)
			{
				CreateCharacteristicGroup(((CaplCharacteristicGroupTreeItem*)item)->m_group);
			}
		}
		m_tree->RedrawWindow();
	}
	if(inst!=0){
		int i;
		CaplTreeItem* parent_old_item;
		CaplInstance *level,*system;
		bool flag_break=false;
		if(m_doc->m_api.m_classifier_mgr.CreateClassifierAssociation(inst, m_inst)==0){
			return false;
		}
		m_doc_data.NET_SaveChanges();	
		CArray<CaplTreeItem*,CaplTreeItem*> refreshed_items; 

		//  item-   
		for(i=0;i<m_doc->m_items.Size;i++)
		{
			if(m_doc->m_items[i]!=this)
			{
				aplExtent ext1,ext2;
				CaplTreeItem *found_item=(CaplTreeItem*)m_doc->m_items[i];
				if(found_item==0) continue;
				if(m_doc->m_items[i]->m_type==item->m_type)
				{

					item->GetAccessedInstances(ext1);
					found_item->GetAccessedInstances(ext2);
					if(ext1[0]==ext2[0]){
						//    
						parent_old_item=GetParentItem(found_item);
						if(parent_old_item==0) continue;
						if(parent_old_item->m_type==_T("ClassifierLevel")){
							//     ?    -  
							level=((CaplClassifierTreeItem*)parent_old_item)->m_inst;
							m_doc_data.GetAttr(level,m_doc->m_api.m_classifier_mgr.a_apl_classifier_level_system,system);
							if(system==m_system){
								//          .   !
								flag_break=item==found_item;//     item -    
								m_doc->m_items.Remove(i);
								refreshed_items.Add(parent_old_item);
								i--;
								if(flag_break)break;
							}
						}
					}
				}
			}
		}

		//     
		InsertInstInTree(inst, m_item, m_doc, m_tree, m_contents,0,0,m_inst);
		ShowContents();
		MyExpand();

		for(i=0;i<refreshed_items.GetSize();i++)
		{
			refreshed_items[i]->RefreshItem();
		}

	}

	return true;
}
//++***    
void CaplClassifierTreeItem::CreateCharacteristic(CaplInstance *val)
{
	CaplInstance *item,*new_val=0;
	item=m_inst;

	if(0==item) return;
	if(item->GetType()==0) return;
	if(item->GetAccessmode()>aplRO) return;
	CaplTreeItem::CreateCharacteristic(item, val);
	/*
	if(m_doc->m_api.m_charact_mgr.CreateCharacteristic(item,val, &new_val,0,0,true))
	{
	if(CaplTreeItem::m_AutoUzurpireCharacteristic)
	{
	aplExtent ext; ext.Add(new_val);
	m_doc_data.NET_BecomeInstancesOwner(&ext);
	}

	CaplCharacteristicTreeItem *characteristic_item=
	new CaplCharacteristicTreeItem(m_tree,m_doc,new_val);
	characteristic_item->CreateTreeItem(m_item);
	m_all_caracteristic.Add(new_val);
	MyExpand();
	m_doc->ChangeItem(0);m_doc->ChangeItem(this);
	}*/
}
//++***    
//****************************************************************
void CaplClassifierTreeItem::CreateCharacteristicGroup(CaplInstance *group)
{
	CaplInstance *item,*new_ass=0, *new_val=0;
	item=m_inst;
	CaplTreeItem::CreateCharacteristicGroup(item, group);
	/*
	CaplInstance *group_new=0;
	if(m_doc->m_api.m_charact_mgr.CreateCharacteristicGroup(item,&group_new,group))
	{
	if(group!=0)
	{
	if(CaplTreeItem::m_AutoUzurpireCharacteristic)
	{
	aplExtent ext; ext.Add(group);
	m_doc_data.NET_BecomeInstancesOwner(&ext);
	}

	}
	CaplCharacteristicGroupTreeItem *characteristic_group_item=
	new CaplCharacteristicGroupTreeItem(m_tree,m_doc,group_new);
	characteristic_group_item->CreateTreeItem(m_item);
	m_all_caracteristic.Add(group_new);
	MyExpand();
	m_doc->ChangeItem(0);m_doc->ChangeItem(this);
	}*/
}
//****************************************************************
void GrayAllCreate(CMenu* pPopup)
{
	pPopup->EnableMenuItem(ID_CREATE_DOC, MF_BYCOMMAND | MF_GRAYED);
	pPopup->EnableMenuItem(ID_CREATE_BP, MF_BYCOMMAND | MF_GRAYED);
	pPopup->EnableMenuItem(ID_CREATE_BP_INST, MF_BYCOMMAND | MF_GRAYED);
	pPopup->EnableMenuItem(ID_CREATE_PRODUCT, MF_BYCOMMAND | MF_GRAYED);
	pPopup->EnableMenuItem(ID_CREATE_PRODUCT_BY_DOT, MF_BYCOMMAND | MF_GRAYED);
	pPopup->EnableMenuItem(ID_CREATE_PRODUCT_VERSION, MF_BYCOMMAND | MF_GRAYED);
	pPopup->EnableMenuItem(ID_CREATE_PRD_INST, MF_BYCOMMAND | MF_GRAYED);
	pPopup->EnableMenuItem(ID_CREATE_LOT, MF_BYCOMMAND | MF_GRAYED);
	pPopup->EnableMenuItem(ID_CREATE_CHANGE, MF_BYCOMMAND | MF_GRAYED);
	pPopup->EnableMenuItem(ID_CREATE_PROJECT, MF_BYCOMMAND | MF_GRAYED);
	pPopup->EnableMenuItem(ID_CREATE_WITH_FORM,MF_BYCOMMAND | MF_GRAYED);

}

//****************************************************************
bool CaplClassifierTreeItem::TrackPopupMenu(CWnd* wnd, CPoint& point, UINT view_mode)
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL

	if(!m_doc_data.IsConnected()) return false;
	CMenu menu;  gSetPsmResourceHandle();
	BOOL res;
	CaplInstance* inst=0,*parent=0;
	CaplClassifierTreeItem* item = 0;
	aplExtent ext;

	VERIFY(menu.LoadMenu(IDR_TREE_CONTEXT_MENU));
	CaplMenu::Install(wnd); //	VERIFY(CaplMenu::Install(wnd, ePopupMenu ));
	CMenu* pPopup;
	pPopup = menu.GetSubMenu(INDEX_CLASSIFIER_SYSTEM_MENU);
	ASSERT(pPopup != NULL);
	if (pPopup == 0)
		return false;
	int i;
	bool can_create_obj=true;
	
	bool is_object_type_control;CaplEntity *stored_entity;

	AppendAddIn((CMenu *) pPopup);
	UpdateMenu((CMenu**)&pPopup, view_mode);

	//      -    
	//	pPopup->EnableMenuItem(ID_VIEW_CONTENT_IN_TABLE, MF_BYCOMMAND | MF_GRAYED);
	//	pPopup->EnableMenuItem(ID_OPEN_ITEM_IN_NEW_WINDOW, MF_BYCOMMAND | MF_GRAYED);

	if(0==m_classifier)
	{
		pPopup->RemoveMenu(ID_REMOVE_FROM_CLASSIFIER,MF_BYCOMMAND);
	}

	if (m_inst == 0)
	{
		pPopup->EnableMenuItem(ID_SHOW_CONTAINED_FOLDER, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_CONTAINED_CLASSIFIER, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_PROPERTIES, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CLASSIFIER_SYSTEM_DELETE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CLASSIFIER_ELEMENT_CREATE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_OPEN_ITEM_IN_NEW_WINDOW, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_EDIT_COPY, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_EDIT_PASTE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_NOTE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_NOTES, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SET_INST_ACCSESS, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_FREZEE_INST, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SET_INST_OWNER, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SET_INST_ACCSESS_RECURSIVE,MF_BYCOMMAND | MF_GRAYED);

		pPopup->EnableMenuItem(ID_SHOW_PARENT_ELEMENT,MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_PARENT_SYSTEM,MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_CHARACTERISTIC,MF_BYCOMMAND | MF_GRAYED);
		
		GrayAllCreate(pPopup);

	}
	else if(m_inst->GetAccessmode() > aplRO || m_inst->GetType()==0)
	{
		pPopup->EnableMenuItem(ID_CLASSIFIER_SYSTEM_CREATE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_PROPERTIES, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CLASSIFIER_SYSTEM_DELETE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CLASSIFIER_ELEMENT_CREATE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_OPEN_ITEM_IN_NEW_WINDOW, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_EDIT_COPY, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_EDIT_PASTE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_NOTE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_NOTES, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SET_INST_ACCSESS, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_FREZEE_INST, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SET_INST_OWNER, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SET_INST_ACCSESS_RECURSIVE,MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_VIEW_CONTENT_IN_TABLE,MF_BYCOMMAND | MF_GRAYED);
		
		pPopup->EnableMenuItem(ID_SHOW_PARENT_ELEMENT,MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_PARENT_SYSTEM,MF_BYCOMMAND | MF_GRAYED);
		
		GrayAllCreate(pPopup);

		pPopup->EnableMenuItem(ID_SHOW_AS_REFERENCEBOOK, MF_GRAYED|MF_BYCOMMAND);
	}
	else
	{
		if (m_doc_data.IsKindOf(m_inst,
								m_doc->m_api.m_classifier_mgr.e_apl_classifier_system))
		{
			pPopup->ModifyMenu(ID_SET_INST_ACCSESS_RECURSIVE,MF_BYCOMMAND|MF_STRING,
				ID_SET_INST_ACCSESS_RECURSIVE, APL_T("  ..."));
			pPopup->ModifyMenu(ID_CLASSIFIER_SYSTEM_DELETE,MF_BYCOMMAND|MF_STRING,
				ID_CLASSIFIER_SYSTEM_DELETE, APL_T(" "));
			pPopup->EnableMenuItem(ID_SHOW_PARENT_ELEMENT,MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_SHOW_PARENT_SYSTEM,MF_BYCOMMAND | MF_GRAYED);

			GrayAllCreate(pPopup);

		}
		else if (m_doc_data.IsKindOf(m_inst,
								m_doc->m_api.m_classifier_mgr.e_apl_classifier_level))
		{
			pPopup->ModifyMenu(ID_SET_INST_ACCSESS_RECURSIVE,MF_BYCOMMAND|MF_STRING,
				ID_SET_INST_ACCSESS_RECURSIVE, APL_T("  ..."));
// 				ID_SET_INST_ACCSESS_RECURSIVE, APL_T("   ..."));
			pPopup->EnableMenuItem(ID_CLASSIFIER_SYSTEM_CREATE, MF_BYCOMMAND | MF_GRAYED);
			pPopup->ModifyMenu(ID_CLASSIFIER_SYSTEM_DELETE,MF_BYCOMMAND|MF_STRING,
				ID_CLASSIFIER_SYSTEM_DELETE, APL_T("  "));
			m_doc_data.GetAttr(m_inst,m_doc->m_api.m_classifier_mgr.a_apl_classifier_level_parent,parent);
			if(parent==0){
				pPopup->EnableMenuItem(ID_SHOW_PARENT_ELEMENT,MF_BYCOMMAND | MF_GRAYED);
			}
			if(m_system!=0){
				if (m_system->GetAccessmode() != aplOWN){
					pPopup->EnableMenuItem(ID_CLASSIFIER_SYSTEM_DELETE, MF_BYCOMMAND | MF_GRAYED);
				}
			}
			bool old_flag=m_doc->m_api.m_ModeInteractive;
			m_doc->m_api.m_ModeInteractive=false;
			can_create_obj= m_doc->m_api.m_classifier_mgr.TestObjectLevelOfLevel(m_inst);
			m_doc->m_api.m_ModeInteractive=old_flag;

			pPopup->EnableMenuItem(ID_SHOW_AS_REFERENCEBOOK, MF_GRAYED|MF_BYCOMMAND);
			//pPopup->EnableMenuItem(ID_SHOW_PARENT_SYSTEM,MF_BYCOMMAND | MF_GRAYED);

			m_doc->m_api.m_classifier_mgr.GetObjectTypeParameters(m_inst,is_object_type_control,&stored_entity);
			if(is_object_type_control && stored_entity!=0){
				GrayAllCreate(pPopup);
				if(stored_entity==m_doc->m_api.m_doc_mgr.e_apl_doc){
					pPopup->EnableMenuItem(ID_CREATE_DOC, MF_BYCOMMAND | MF_ENABLED);
				}else if(stored_entity==m_doc->m_api.m_prd_mgr.e_prd){
					pPopup->EnableMenuItem(ID_CREATE_PRODUCT, MF_BYCOMMAND | MF_ENABLED);
					pPopup->EnableMenuItem(ID_CREATE_PRODUCT_BY_DOT, MF_BYCOMMAND | MF_ENABLED);
				}else if(stored_entity==m_doc->m_api.m_prd_mgr.e_apl_pdf){
					pPopup->EnableMenuItem(ID_CREATE_PRODUCT_VERSION, MF_BYCOMMAND | MF_ENABLED);
				}else if(stored_entity==m_doc->m_api.m_prd_inst_mgr.e_prd_inst){
					pPopup->EnableMenuItem(ID_CREATE_PRD_INST, MF_BYCOMMAND | MF_ENABLED);
				}else if(stored_entity==m_doc->m_api.m_prd_inst_mgr.e_lot){
					pPopup->EnableMenuItem(ID_CREATE_LOT, MF_BYCOMMAND | MF_ENABLED);
				}else if(stored_entity==m_doc->m_api.m_change_mgr.e_chng){
					pPopup->EnableMenuItem(ID_CREATE_CHANGE, MF_BYCOMMAND | MF_ENABLED);
				}else if(stored_entity==m_doc->m_api.m_bp_mgr.e_bp){
					pPopup->EnableMenuItem(ID_CREATE_BP, MF_BYCOMMAND | MF_ENABLED);
				}else if(stored_entity==m_doc->m_api.m_bp_mgr.e_apl_bp_inst){
					pPopup->EnableMenuItem(ID_CREATE_BP_INST, MF_BYCOMMAND | MF_ENABLED);
				}else if(stored_entity==m_doc->m_api.m_project_mgr->e_project){
					pPopup->EnableMenuItem(ID_CREATE_PROJECT, MF_BYCOMMAND | MF_ENABLED);
				}
			}
			aplExtent ext_forms;
			CaplInstance *form=0;
			m_doc->m_api.m_classifier_mgr.GetClassifierForms(m_inst,ext_forms,true);
			if(ext_forms.GetSize()>0)form=ext_forms.GetAt(0);
			if(form==0){
				pPopup->EnableMenuItem(ID_CREATE_WITH_FORM,MF_BYCOMMAND | MF_GRAYED);
			}else{
				pPopup->EnableMenuItem(ID_CREATE_WITH_FORM,MF_BYCOMMAND | MF_ENABLED);
			}
		}
		if (m_inst->GetAccessmode() > aplOWN)
		{
			pPopup->EnableMenuItem(ID_CLASSIFIER_SYSTEM_DELETE, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_SET_INST_OWNER, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_FREZEE_INST, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_SET_INST_ACCSESS_RECURSIVE, MF_BYCOMMAND | MF_GRAYED);
			if (m_inst->GetAccessmode() == aplRO)
			{
				pPopup->EnableMenuItem(ID_CLASSIFIER_ELEMENT_CREATE, MF_BYCOMMAND | MF_GRAYED);
				pPopup->EnableMenuItem(ID_EDIT_PASTE, MF_BYCOMMAND | MF_GRAYED);
			}
		}
		if (m_inst->GetAccessmode() > aplRW || !can_create_obj)
		{
			GrayAllCreate(pPopup);
		}
		if (m_inst->GetAccessmode() > aplRW)
		{
			pPopup->EnableMenuItem(ID_CLASSIFIER_ELEMENT_CREATE, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_EDIT_PASTE, MF_BYCOMMAND | MF_GRAYED);
		}
	}

	if(m_folder!=0){
		if (m_folder->GetAccessmode() != aplOWN){
			pPopup->EnableMenuItem(ID_REMOVE_FROM_FOLDER, MF_BYCOMMAND | MF_GRAYED);
		}
	}else{
		pPopup->EnableMenuItem(ID_REMOVE_FROM_FOLDER, MF_BYCOMMAND | MF_GRAYED);
	}

	if(m_doc->m_api.m_prd_mgr.bNoCreateAndChangePDF)
	{
		pPopup->EnableMenuItem(ID_CREATE_PRODUCT, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_PRODUCT_VERSION, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_PRODUCT_BY_DOT, MF_BYCOMMAND | MF_GRAYED);
	}

	CString sVal;
	CString sRoleName;
	m_doc->m_api.m_options_mgr.GetOptionValueBN( APL_NO_T("\\   "), sVal, _T(""));
	if(!sVal.IsEmpty() && !m_doc->m_api.m_data.IsAdmin())
	{
		if(!m_doc->m_api.m_appr_mgr.CheckPersonRole(0,sVal))
			pPopup->EnableMenuItem(ID_CLASSIFIER_SYSTEM_CREATE, MF_BYCOMMAND | MF_GRAYED);
	}

	res = pPopup->TrackPopupMenu(TPM_LEFTALIGN |
					TPM_RIGHTBUTTON |
					TPM_RETURNCMD,
					point.x, point.y, wnd);

	switch (res)
	{
	case ID_SHOW_CONTAINED_FOLDER:
		ShowContainedFolder(m_inst);
		break;

	case ID_RECURSE_FIND_CLF_SYSTEM:
		m_dlg.SetTreeItem(this, m_inst);	
		break;

	case ID_CLASSIFIER_SYSTEM_CREATE:
		inst = m_doc->m_api.m_classifier_mgr.CreateClassifierSystem(m_inst);

		if (inst)
		{
			ShowContents();
			MyExpand();
			m_doc_data.NET_SaveChanges();
		}
		RefreshAllThisClassifierItem();

		break;
	case ID_REMOVE_FROM_CLASSIFIER:
		if(m_classifier!=0)
		{
			if(m_classifier->GetAccessmode()>aplRW)	{AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return true;}
			if(m_doc->m_api.m_classifier_mgr.DeleteClassifierAssociation(m_inst,m_classifier))
				m_doc->m_items.Remove(m_doc->m_items.Find(this));
		}
		break;
	case ID_CLASSIFIER_SYSTEM_DELETE:
		if(m_doc->m_api.m_classifier_mgr.DeleteClassifierItem(m_inst)){
			m_doc_data.NET_SaveChanges();
			RefreshAllThisClassifierItem(true);
			i = m_doc->m_items.Find(this);
			if (i != -1)
				m_doc->m_items.Remove(i);
		}
		break;	
	case ID_CLASSIFIER_ELEMENT_CREATE:
		if (m_doc_data.IsKindOf(m_inst,
						m_doc->m_api.m_classifier_mgr.e_apl_classifier_system))
		{
			inst = m_doc->m_api.m_classifier_mgr.CreateClassifierLevel(m_inst,0, NULL);
		}
		else if (m_doc_data.IsKindOf(m_inst,
								m_doc->m_api.m_classifier_mgr.e_apl_classifier_level))
		{
			inst = m_doc->m_api.m_classifier_mgr.CreateClassifierLevel(m_system,m_inst, NULL);
			RefreshItem();
		}
		ShowContents();
		RefreshAllThisClassifierItem();
		MyExpand();
		m_doc_data.NET_SaveChanges();
		break;
	case ID_SHOW_PARENT_SYSTEM:
		m_doc->m_api.LoadItemInfo(m_system);
		InsertInstInTree(m_system, m_item, m_doc, m_tree, m_contents);
		MyExpand();
		break;
	case ID_SHOW_PARENT_ELEMENT:
		m_doc->m_api.LoadItemInfo(parent);
		InsertInstInTree(parent, m_item, m_doc, m_tree, m_contents);
		MyExpand();
		break;
//	case ID_SET_ACCSESS_CONTENTS:
//		{
//			aplExtent ext_content, ext_rel;
//			m_doc->m_api.m_classifier_mgr.GetSubItems(m_inst, ext_content, 0);
//			if (ext_content.Size <= 0)
//				AfxMessageBox(APL_T("  !!!"));
//			else
//			{
//				m_doc_data.NET_SetInstancesAccess(&ext_content,
//							(CaplInstance *) 0, (aplAccessModeType) - 1);
//			}
//		}	
//		break;
	case ID_VIEW_CONTENT_IN_TABLE:
		{
			bool change_flag = false;
			m_doc->m_api.m_classifier_mgr.MakeTable(m_inst,true,&change_flag);
			if (change_flag)
			{
				Expand(1);
				ShowContents();
			}
		}
		break;

	case ID_SS_COPY_DOCDISK:
		{
			CString path = m_doc->m_folders_map[m_inst->GetId()];
			m_doc->m_api.m_folder_mgr.CopyDocOnDisk(m_inst, path);
			//RefreshAllDocs();
			Expand(1);
			ShowContents();
			Sort();
			m_doc->m_folders_map[m_inst->GetId()] = path;
		}
		break;
	case ID_OPEN_ITEM_IN_NEW_WINDOW:
		m_doc->OpenInstanceInNewWindow(m_inst);
		break;
	case ID_SHOW_PROPERTIES:
		ShowProperties();break;
		
	case ID_REMOVE_FROM_FOLDER:
		if(m_folder!=0)
		{
			if(m_doc->m_api.m_folder_mgr.RemoveFromFolder(m_folder,m_inst))
				m_doc->m_items.Remove(m_doc->m_items.Find(this));
		}
		break;

		//case ID_CREATE_DOC:   
	case ID_CREATE_BP:CreateBP();break;
	case ID_CREATE_BP_INST:CreateBPInst();break;
	case ID_CREATE_CHARACTERISTIC: CreateCharacteristic(); break;
	case ID_CREATE_PRODUCT:CreateProduct(0);break;
	case ID_CREATE_PRODUCT_VERSION:CreateProduct(0,true);break;
	case ID_CREATE_PRODUCT_BY_DOT:
		{
			aplExtent res;
			if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return true;}
			CaplInstance *instance = m_doc->m_api.m_prd_mgr.CreatePdfByDot(0, res);
			if(instance){
				m_doc->m_api.m_classifier_mgr.CreateClassifierAssociation(instance,m_inst);
				ShowContents();
				MyExpand();
			}
		}
		RefreshAllThisClassifierItem();
		break;
	case ID_CREATE_PRD_INST:
		{
			if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return true;}
			CaplInstance *prd_inst=m_doc->m_api.m_prd_inst_mgr.CreatePrdInst();
			if(prd_inst!=0)
			{
				m_doc->m_api.m_classifier_mgr.CreateClassifierAssociation(prd_inst,m_inst);
				ShowContents();
				MyExpand();
			}
		}
		RefreshAllThisClassifierItem();
		break;
	case ID_CREATE_LOT:
		{
			if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return true;}
			CaplInstance *lot=m_doc->m_api.m_prd_inst_mgr.CreateLot();
			if(lot!=0)
			{
				m_doc->m_api.m_classifier_mgr.CreateClassifierAssociation(lot,m_inst);
				ShowContents();
				MyExpand();
			}
		}
		RefreshAllThisClassifierItem();
		break;
	case ID_CREATE_CHANGE:CreateChange(); break;
	case ID_CREATE_PROJECT:CreateProject();break;

	case ID_CREATE_WITH_FORM:CreateWithForm();break;
		
		break;
	case ID_SHOW_AS_REFERENCEBOOK:
		{
			CString buf,buf1;
			if(m_inst){
				m_doc->m_api.m_data.GetAttr(m_inst, m_doc->m_api.m_classifier_mgr.a_apl_classifier_system_name, buf1);
				buf= APL_T(" \"")+buf1+_T("\"");
			}else{
				buf.Format( APL_T(""));
			}
			m_doc->m_api.m_classifier_mgr.SelectItem(NULL, m_inst, APL_CLASSIFIER_EDITOR, buf);
 			TestBufer();
			RefreshAllChildItem();
		}
		break;
	default:
		PrepareContextMenu(res); break;
	}
	return true;
}
//****************************************************************
void CaplClassifierTreeItem::GetAccessedInstances(aplExtent& ext)
{
	ext.Clear();
	if (m_inst != 0)
	{
		if(m_inst->GetType()!=0){
			m_doc->m_api.m_classifier_mgr.LoadClassifierInfo(m_inst);
			ext.Add(m_inst);
		}
	}
}
//****************************************************************
bool CaplClassifierTreeItem::GetName(CString& name)
{
	name =  APL_T("");

	_APL_TREE_ITEM_CHEK_PARAM_BOOL

	if (m_inst != 0){
		m_doc->m_api.GetItemName(m_inst, name);
	}
	return true;
}
//****************************************************************
bool CaplClassifierTreeItem::CreateTreeItem(HTREEITEM parent_item)
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	CString buf;
	GetName(buf);

	int ico = ICON_CLASSIFIER_SYSTEM;

	if (m_inst)
		ico = m_doc->m_api.GetInstIco(m_inst);

	InsetItem(buf, ico, parent_item);
	SetItemImage(ico, IDX_IL_TREE_ITEM);
	m_fictive_item = m_tree->InsertItem(_T("fictive"), 0, 0, m_item);
	m_expanded = false;
	return true;
}
//****************************************************************
bool CaplClassifierTreeItem::Expand(UINT action)
{
	// action = 2 ->  
	// action = 1 -> 
	_APL_TREE_ITEM_CHEK_PARAM_BOOL

	if (action == 2)
	{
		if (m_expanded)
			return true;
		if (m_hasSubItem)
			Expand(1);
		ShowContents();

		if(0!=m_inst)
		{
			if(m_type==APL_TREE_ITEM_CLASSIFIERLEVEL)
			{
				if(m_doc->m_auto_expand_items.m_showintree_classifier_level&APL_SHOW_CHARACT)
					ShowAllCharacteristic(false);
			}
			else if(m_type==APL_TREE_ITEM_CLASSIFIERSYSTEM)
			{
				if(m_doc->m_auto_expand_items.m_showintree_classifier_system&APL_SHOW_DOC)
					ShowAllDocs(false,false);

				if(m_doc->m_auto_expand_items.m_showintree_classifier_system&APL_SHOW_CHARACT)
					ShowAllCharacteristic(false);
			}
		}
		Sort();
	}
	else if (action == 1)
	{
		CollapseItem();
		m_contents.Clear();
	}
	return true;
}
//****************************************************************
bool CaplClassifierTreeItem::ShowContents()
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL

//	if (!m_doc_data.IsConnected())
//	{
//		m_tree->DeleteItem(m_fictive_item);
//		m_fictive_item = 0;
//		return false;
//	}
//
	int i;
	aplExtent ext;

	m_tree->SetRedraw(FALSE);
	if (m_fictive_item != 0)
	{
		m_tree->DeleteItem(m_fictive_item);
		m_fictive_item = 0;
	}


	StartBusy();

	if(m_type==APL_TREE_ITEM_CLASSIFIERLEVEL)
	{
		aplExtent ext;
		//m_doc_data.GetAttr(m_inst,m_doc->m_api.m_classifier_mgr.a_apl_classifier_level_childs,ext);
		m_doc->m_api.m_classifier_mgr.LoadSubClassifierLevels(m_inst,ext);

		for (i = 0; i < ext.Size; i++)
		{
			if(!ext[i]) continue;
			if(!ext[i]->GetType()) continue;
			if(ext[i]->GetAccessmode()>aplRO) continue;
			InsertInstInTree(ext[i], m_item, m_doc, m_tree, m_contents);
		}
		m_doc->m_api.m_classifier_mgr.GetSubItems(m_inst, ext, 0);
		for (i = 0; i < ext.Size; i++)
		{
			if(!ext[i]) continue;
			if(!ext[i]->GetType()) continue;
			if(ext[i]->GetAccessmode()>aplRO) continue;
			
			InsertInstInTree(ext[i], m_item, m_doc, m_tree, m_contents,0,0,m_inst);
		}
	}
	else if(m_type==APL_TREE_ITEM_CLASSIFIERSYSTEM)
	{
		aplExtent ext;
		m_doc->m_api.m_classifier_mgr.LoadSubClassifierSystems(m_inst,ext);
		for (i = 0; i < ext.Size; i++)
		{
			if(!ext[i]) continue;
			if(!ext[i]->GetType()) continue;
			if(ext[i]->GetAccessmode()>aplRO) continue;
			
			InsertInstInTree(ext[i], m_item, m_doc, m_tree, m_contents);
		}
		m_doc->m_api.m_classifier_mgr.LoadSubClassifierLevels(m_inst,ext);
		for (i = 0; i < ext.Size; i++)
		{
			if(!ext[i]) continue;
			if(!ext[i]->GetType()) continue;
			if(ext[i]->GetAccessmode()>aplRO) continue;

			InsertInstInTree(ext[i], m_item, m_doc, m_tree, m_contents);
		}
	}
	StopBusy();

	m_tree->SetRedraw(TRUE);
	return true;
}
//****************************************************************
bool CaplClassifierTreeItem::ShowInListCtrl(CListCtrl* list)
{
	if (list == 0) return false;
	CHECK_SHOW_LIST_CTRL_TOP(m_inst, APL_T(""));
	if (m_doc == 0) return false;
	//LoadProperties();

	CaplInstance* system;
	CString buf,tmp=_T("");
	int i,tab_line=0;
	bool bval,bval_tarjet;
	int LevelMax;
	int LevelMin;
	if (m_inst != 0)
	{
		if (m_type==APL_TREE_ITEM_CLASSIFIERLEVEL)
		{
			i = list->InsertItem(tab_line++,  APL_T(":"));
			m_doc_data.GetAttr(m_inst,
				m_doc->m_api.m_classifier_mgr.a_apl_classifier_level_id,
				buf);
			list->SetItemText(i, 1, buf);
			
			i = list->InsertItem(tab_line++,  APL_T(":"));
			m_doc_data.GetAttr(m_inst,
				m_doc->m_api.m_classifier_mgr.a_apl_classifier_level_name,
				buf);
			list->SetItemText(i, 1, buf);
			
			i = list->InsertItem(tab_line++,  APL_T(":"));
			m_doc_data.GetAttr(m_inst,
				m_doc->m_api.m_classifier_mgr.a_apl_classifier_level_descr,
				buf);
			list->SetItemText(i, 1, buf);
			tmp= APL_T(" ");
			system=m_system;
			if(system==0){
				i = list->InsertItem(tab_line++,  APL_T("!"));
				list->SetItemText(i,1, APL_T("  !"));
			}
			i = list->InsertItem(tab_line++,  APL_T(":"));
			m_doc_data.GetAttr(m_inst,
				m_doc->m_api.m_classifier_mgr.a_apl_classifier_level_code,
				buf);
			list->SetItemText(i, 1, buf);
		}else{
			system=m_inst;
		}
		if (system!=0)
		{
			i = list->InsertItem(tab_line++,  APL_T("")+tmp+_T(":"));
			m_doc_data.GetAttr(system,
				m_doc->m_api.m_classifier_mgr.a_apl_classifier_system_id,buf);
			list->SetItemText(i, 1, buf);

			i = list->InsertItem(tab_line++,  APL_T("")+tmp+_T(":"));
			m_doc_data.GetAttr(system,
				m_doc->m_api.m_classifier_mgr.a_apl_classifier_system_name,buf);
			list->SetItemText(i, 1, buf);

			i = list->InsertItem(tab_line++,  APL_T("")+tmp+_T(":"));
			m_doc_data.GetAttr(system,
				m_doc->m_api.m_classifier_mgr.a_apl_classifier_system_descr,buf);
			list->SetItemText(i, 1, buf);

			i = list->InsertItem(tab_line++, _T(""));
			i = list->InsertItem(tab_line++,  APL_T(":"));
			m_doc_data.GetAttr(system, m_doc->m_api.m_classifier_mgr.a_apl_classifier_system_can_store_object, bval_tarjet);
			if(bval_tarjet){
				buf= APL_T("   ");
			}else{
				buf= APL_T(" ");
			}
			list->SetItemText(i, 1, buf);
			i = list->InsertItem(tab_line++, _T(""));

			i = list->InsertItem(tab_line++, _T(""));
			list->SetItemText(i, 1,  APL_T("  "));
			//i = list->InsertItem(tab_line++, APL_T(" :"));
			i = list->InsertItem(tab_line++,  APL_T(" :"));
			m_doc_data.GetAttr(system, m_doc->m_api.m_classifier_mgr.a_apl_classifier_system_is_concept_level_control, bval);
			if(bval){
				buf= APL_T("");
				list->SetItemText(i, 1, buf);
				i = list->InsertItem(tab_line++,  APL_T(" :"));
				m_doc_data.GetAttr(system, m_doc->m_api.m_classifier_mgr.a_apl_classifier_system_is_concept_last_level, bval);
				if(bval){
					buf= APL_T(" ");
					list->SetItemText(i, 1, buf);
				}else{
					m_doc_data.GetAttr(system, m_doc->m_api.m_classifier_mgr.a_apl_classifier_system_concept_maxlevel, LevelMax);
					m_doc_data.GetAttr(system, m_doc->m_api.m_classifier_mgr.a_apl_classifier_system_concept_minlevel, LevelMin);
					buf.Format( APL_T("  %i  %i"),LevelMin,LevelMax);
					list->SetItemText(i, 1, buf);
				}
			}else{
				buf= APL_T("");
				list->SetItemText(i, 1, buf);
			}
			i = list->InsertItem(tab_line++, _T(""));

			if(bval_tarjet){
				i = list->InsertItem(tab_line++, _T(""));
				list->SetItemText(i, 1,  APL_T("  "));
				i = list->InsertItem(tab_line++,  APL_T(" :"));
				m_doc_data.GetAttr(system, m_doc->m_api.m_classifier_mgr.a_apl_classifier_system_is_object_level_control, bval);
				if(bval){
					buf= APL_T("");
					list->SetItemText(i, 1, buf);
					i = list->InsertItem(tab_line++,  APL_T(" :"));
					m_doc_data.GetAttr(system, m_doc->m_api.m_classifier_mgr.a_apl_classifier_system_is_object_last_level, bval);
					if(bval){
						buf= APL_T(" ");
						list->SetItemText(i, 1, buf);
					}else{
						m_doc_data.GetAttr(system, m_doc->m_api.m_classifier_mgr.a_apl_classifier_system_object_maxlevel, LevelMax);
						m_doc_data.GetAttr(system, m_doc->m_api.m_classifier_mgr.a_apl_classifier_system_object_minlevel, LevelMin);
						buf.Format( APL_T("  %i  %i"),LevelMin,LevelMax);
						list->SetItemText(i, 1, buf);
					}
				}else{
					buf= APL_T("");
					list->SetItemText(i, 1, buf);
				}

				i = list->InsertItem(tab_line++,  APL_T("  :"));
				m_doc_data.GetAttr(system, m_doc->m_api.m_classifier_mgr.a_apl_classifier_system_is_type_control, bval);
				if(bval){
					buf= APL_T("");
					list->SetItemText(i, 1, buf);
					i = list->InsertItem(tab_line++,  APL_T(" :"));
					m_doc_data.GetAttr(system, m_doc->m_api.m_classifier_mgr.a_apl_classifier_system_stored_entity, buf);
				}else{
					buf= APL_T("");
				}
				list->SetItemText(i, 1, buf);
			}

			
		}
	}
	aplExtent ext;

	list->InsertItem(tab_line++,_T(""));
	list->InsertItem(tab_line++,_T(""));
	if(m_inst!=0)
	{
		if (m_type==APL_TREE_ITEM_CLASSIFIERSYSTEM){
			i=list->InsertItem(tab_line++, APL_T("  :"));
			GetAccessName(m_inst,buf);
			list->SetItemText(i,1,buf);
		}
		if (m_type==APL_TREE_ITEM_CLASSIFIERLEVEL){
			i=list->InsertItem(tab_line++, APL_T("  :"));
			GetAccessName(m_inst,buf);
			list->SetItemText(i,1,buf);
			if(m_system!=0){
				i=list->InsertItem(tab_line++, APL_T("  :"));
				GetAccessName(m_system,buf);
				list->SetItemText(i,1,buf);
			}else{
				i=list->InsertItem(tab_line++, APL_T("  !"));
				list->SetItemText(i,1, APL_T("!"));
			}
		}
	}
	ext.Clear();

	CStringArray comment;

	if (m_inst != 0)
	{
		comment.Add(_T("m_inst"));
		ext.Add(m_inst);
	}

	if (m_system != 0)
	{
		comment.Add(_T("m_system"));
		ext.Add(m_system);
	}
	
	ShowInstanceInfoInListCtrl(ext, list, &comment);

	return true;
}

//****************************************************************
void CaplClassifierTreeItem::ShowProperties()
{
	m_doc->m_api.m_classifier_mgr.ShowClassifierProperties(m_inst);

	RefreshAllThisClassifierItem();
}

bool CaplClassifierTreeItem::RefreshAllThisClassifierItem(bool with_parent)
{
	int i;
	CaplTreeItem* parent=0;
	for(i=0;i<m_doc->m_items.Size;i++)
	{
		if(m_doc->m_items[i]!=this)
		{
			if(m_doc->m_items[i]->m_type==m_type)
			{
				CaplClassifierTreeItem *item=(CaplClassifierTreeItem*)m_doc->m_items[i];
				if(item->m_inst==m_inst){
					item->RefreshItem();
					if(with_parent){
//						parent=GetParentItem(item);
//						if(parent!=0)parent->RefreshItem();
					}
				}
			}
		}
	}
	RefreshItem();
	return true;
}


//****************************************************************
bool CaplClassifierTreeItem::RefreshItem()
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL Sort();
	CString name;
	GetName(name);

	m_tree->SetItemText(m_item, name);
	m_tree->RedrawWindow();

	if(m_inst){
		int ico = m_doc->m_api.GetInstIco(m_inst);
		SetItemImage(ico, IDX_IL_TREE_ITEM);
	}

	if (m_doc->m_tab_view->m_item_old == this)
		m_doc->ChangeItem(this);
	if(m_fictive_item == 0){
		ShowContents();
	}
	return true;
}

//****************************************************************
void CaplClassifierTreeItem::ShowCmd(long cmd)
{
	switch (cmd)
	{
	case ID_CREATE_CHARACTERISTIC: CreateCharacteristic(); break;
	case ID_CREATE_BP: CreateBP(); break;
	case ID_CREATE_PRODUCT: CreateProduct(0); break;
	case ID_CREATE_PRODUCT_VERSION: CreateProduct(0,true); break;
	case ID_CREATE_BP_INST: CreateBPInst();	break;
	case ID_SHOW_ALL_CONTENTS:  Expand(2); MyExpand(); break;
	case ID_EXPAND_ALL: {int i=1; ExpandAll(i);} break;
	default: PrepareContextMenu(cmd);break;
	}
}

//****************************************************************
BOOL CaplClassifierTreeItem::ShowToolBarButton(CCmdUI* pCmdUI)
{
	if(m_inst==0) return FALSE;
	if(m_inst->GetType()==0) return FALSE;

	if(pCmdUI->m_nID==ID_SET_INST_ACCSESS)
	{
		aplExtent instances;
		GetAccessedInstances(instances);
		if(instances.GetSize()>0)
		{
			if(instances[0]->GetAccessmode()==aplOWN) return TRUE;
		}
		return FALSE;
	}


	if(m_doc->m_api.m_prd_mgr.bNoCreateAndChangePDF)
	{
		if(ID_CREATE_PRODUCT==pCmdUI->m_nID)  return FALSE;
		if(ID_CREATE_PRODUCT_VERSION==pCmdUI->m_nID)  return FALSE;
	}
	
	switch(pCmdUI->m_nID)
	{
	case ID_CREATE_BP:
//	case ID_CREATE_APPROVAL:
	case ID_CREATE_PRODUCT:
	case ID_CREATE_PRODUCT_VERSION:
	case ID_CREATE_BP_INST:
	case ID_CREATE_DOC:
//	case ID_SHOW_ALL_DOCS:
	case ID_SHOW_ALL_CHARACTERISTIC:
//	case ID_SHOW_ALL_APPROVAL:
//	case ID_PRODUCT_SHOW_ALL_ZAGOTOV:
//	case ID_SHOW_ALL_LOT:
//	case ID_SHOW_ALL_PRD_INST:
//	case ID_SHOW_ALL_VERSION:
//	case ID_ITEM_CHECK_IN:
//	case ID_ITEM_CHECK_OUT:
//	case ID_ITEM_UNDO_CHECK_OUT:
	case ID_CREATE_CHARACTERISTIC:
	case ID_SHOW_ALL_CONTENTS:
	case ID_CREATE_NOTE:
	case ID_SHOW_NOTES:
		pCmdUI->Enable(TRUE); return TRUE; break;
	}
	return FALSE;
}

//****************************************************************
void CaplClassifierTreeItem::CreateBP()
{
	if(m_doc==0) return;
	if(m_tree==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	m_doc->m_api.m_classifier_mgr.LoadClassifierInfo(m_inst);
	if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}
	bool is_object_type_control;CaplEntity *stored_entity;
	m_doc->m_api.m_classifier_mgr.GetObjectTypeParameters(m_inst,is_object_type_control,&stored_entity);
	if(is_object_type_control && stored_entity!=0){
		if(stored_entity!=m_doc->m_api.m_bp_mgr.e_bp){
			AfxMessageBox( APL_T("      ,   !"),MB_OK|MB_ICONSTOP); return;
		}
	}
	CaplInstance *act_inst=m_doc->m_api.m_bp_mgr.CreateBP();
	if(act_inst!=0)
	{
		m_doc->m_api.m_classifier_mgr.CreateClassifierAssociation(act_inst,m_inst);
		ShowContents();
		MyExpand();
	}
	RefreshAllThisClassifierItem();
}
//****************************************************************
void CaplClassifierTreeItem::CreateBPInst()
{
	if(m_doc==0) return;
	if(m_tree==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	m_doc->m_api.m_classifier_mgr.LoadClassifierInfo(m_inst);
	if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}
	bool is_object_type_control;CaplEntity *stored_entity;
	m_doc->m_api.m_classifier_mgr.GetObjectTypeParameters(m_inst,is_object_type_control,&stored_entity);
	if(is_object_type_control && stored_entity!=0){
		if(stored_entity!=m_doc->m_api.m_bp_mgr.e_apl_bp_inst){
			AfxMessageBox( APL_T("      ,   !"),MB_OK|MB_ICONSTOP); return;
		}
	}
	CaplInstance *act_inst=m_doc->m_api.m_bp_mgr.CreateBPInst();
	if(act_inst!=0)
	{
		m_doc->m_api.m_classifier_mgr.CreateClassifierAssociation(act_inst,m_inst);
		ShowContents();
		MyExpand();
	}
	RefreshAllThisClassifierItem();
}
//****************************************************************
void CaplClassifierTreeItem::CreateProduct(CaplProductTreeItem *baseitem,bool return_pdf)
{
	if(m_doc==0) return;
	if(m_tree==0) return;
	if(m_inst==0) return;

	m_doc->m_api.m_classifier_mgr.LoadClassifierInfo(m_inst);
	if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}

	bool is_object_type_control;CaplEntity *stored_entity;
	m_doc->m_api.m_classifier_mgr.GetObjectTypeParameters(m_inst,is_object_type_control,&stored_entity);
	if(is_object_type_control && stored_entity!=0){
		if(stored_entity!=m_doc->m_api.m_prd_mgr.e_prd && !return_pdf){
			AfxMessageBox( APL_T("      ,   !"),MB_OK|MB_ICONSTOP); return;
		}
		if(stored_entity!=m_doc->m_api.m_prd_mgr.e_apl_pdf && return_pdf){
			AfxMessageBox( APL_T("      ,   !"),MB_OK|MB_ICONSTOP); return;
		}
	}

	 aplPrdDlgmode editMode;
	 if(return_pdf){
		 editMode = aplModeCreateVersion;
	 }else{
		editMode = aplModeCreateProduct;
	 }

	CaplInstance* tmp_inst = m_doc->m_api.m_prd_mgr.CreateProduct(baseitem!=0 ? baseitem->m_pdf:NULL, editMode);
	CaplInstance* tmp_pdr=0;
	if(tmp_inst!=0)
	{

		if(return_pdf){
			m_doc_data.GetAttr(tmp_inst,m_doc->m_api.m_prd_mgr.a_pdf_prd,tmp_pdr);
		}

		m_doc->m_api.m_classifier_mgr.CreateClassifierAssociation(tmp_inst, m_inst);
		
		ShowContents();
		MyExpand();
	}
	m_tree->RedrawWindow();
	RefreshAllThisClassifierItem();
}

//****************************************************************
void CaplClassifierTreeItem::CreateChange()
{
	if(m_doc==0) return;
	if(m_tree==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	
	if(m_inst->GetAccessmode()>aplRW)	{AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}
	m_doc->m_api.m_classifier_mgr.LoadClassifierInfo(m_inst);
	
	bool is_object_type_control;CaplEntity *stored_entity;
	m_doc->m_api.m_classifier_mgr.GetObjectTypeParameters(m_inst,is_object_type_control,&stored_entity);
	if(is_object_type_control && stored_entity!=0){
		if(stored_entity!=m_doc->m_api.m_change_mgr.e_chng){
			AfxMessageBox( APL_T("      ,   !"),MB_OK|MB_ICONSTOP); return;
		}
	}
	
	aplExtent ext;
	CaplInstance* change= m_doc->m_api.m_change_mgr.CreateChange(_T(""), _T(""), _T(""), _T(""), NULL, ext);
	
	if(change)
	{
		/*
		if(CaplTreeItem::m_AutoUzurpireChange)
		{
			aplExtent ext; ext.Add(change);
			m_doc_data.NET_BecomeInstancesOwner(&ext);
		}*/

		m_doc->m_api.m_classifier_mgr.CreateClassifierAssociation(change,m_inst);
		ShowContents();
		MyExpand();
	}
	RefreshAllThisClassifierItem();
}

//****************************************************************
void CaplClassifierTreeItem::CreateWithForm()
{
	if(m_doc==0) return;
	if(m_tree==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	
	m_doc->m_api.m_classifier_mgr.CreateObjectWithForm(m_inst);
				
}

//****************************************************************
void CaplClassifierTreeItem::CreateProject()
{
	if(m_doc==0) return;
	if(m_tree==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	m_doc->m_api.m_classifier_mgr.LoadClassifierInfo(m_inst);
	if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}
	
	bool is_object_type_control;CaplEntity *stored_entity;
	m_doc->m_api.m_classifier_mgr.GetObjectTypeParameters(m_inst,is_object_type_control,&stored_entity);
	if(is_object_type_control && stored_entity!=0){
		if(stored_entity!=m_doc->m_api.m_project_mgr->e_project){
			AfxMessageBox( APL_T("      ,   !"),MB_OK|MB_ICONSTOP); return;
		}
	}
	CaplInstance *act_inst=m_doc->m_project_mgr->CreateProject();
	if(act_inst!=0)
	{
		m_doc->m_api.m_classifier_mgr.CreateClassifierAssociation(act_inst,m_inst);
		ShowContents();
		MyExpand();
	}
	RefreshAllThisClassifierItem();
}

//****************************************************************
bool CaplClassifierTreeItem::PasteFile(LPCTSTR file, CPoint *point)
{
	if(file==0) return false;
	if(m_inst==0) return false;
	CreateDoc(0,file);
	return true;
}

bool CaplClassifierTreeItem::TestBufer()
{
	COleDataObject pDataObject;
	if(!pDataObject.AttachClipboard()) return false;
	UINT cf_hinst=RegisterClipboardFormat(APL_INSTANCE_CLIPBOARDFORMAT);
	if(pDataObject.IsDataAvailable(cf_hinst))
	{
		HGLOBAL hGlob=pDataObject.GetGlobalData(cf_hinst);
		if(hGlob==0)
		{
			AfxMessageBox( APL_T("     ."));
			return false;
		}
		BYTE *phItem=(BYTE*)GlobalLock(hGlob);
		if(phItem==0)
		{
			AfxMessageBox( APL_T("     ."));
			return false;
		}
		
		DWORD procid = GetCurrentProcessId();
		int ind = 0, id;
		DWORD PrcId = *(DWORD*)&phItem[ind];
		if(PrcId!=procid)
			return false;
		ind+=sizeof(DWORD);
		id = *(int*)&phItem[ind];
		CaplInstance *inst = m_doc->m_api.m_data.GetInstById(id);
		if(inst==NULL)
			return false;

		aplExtent ext;
		CaplTreeItem *pItem;
		m_tree->SetRedraw(FALSE);
		// 
		CaplTreeItem* pTmpItem = NULL;
		HTREEITEM htChild = m_tree->GetNextItem(m_doc->m_navigator->m_clipboard_item, TVGN_CHILD);
		while(htChild)
		{
			pTmpItem = (CaplTreeItem*)m_tree->GetItemData(htChild);
			if(pTmpItem) m_doc->m_items.Remove(m_doc->m_items.Find(pTmpItem));
			htChild = m_tree->GetNextItem(m_doc->m_navigator->m_clipboard_item, TVGN_NEXT);
		}
		
		if(InsertInstInTree(inst, m_doc->m_navigator->m_clipboard_item, m_doc, m_tree, ext, NULL, &pItem))
		{
			CMyOleDataSource *pDataSource = new CMyOleDataSource;

			HGLOBAL hMem;
			UINT cf_hinst=RegisterClipboardFormat(CF_HTREEITEN_NAME);	
			
			CString	text=m_tree->GetItemText(pItem->m_item);
			hMem=GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE|GMEM_ZEROINIT,(text.GetLength()+1)*sizeof(TCHAR));
			if (!hMem) return 0;
			TCHAR *xxx=(TCHAR*)GlobalLock(hMem);
			memcpy(xxx,LPCTSTR(text),(text.GetLength()+1)*sizeof(TCHAR));		
			GlobalUnlock(hMem);
			pDataSource->CacheGlobalData(CF_TEXT, hMem);
			if(pItem!=0)
			{
				hMem=GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE|GMEM_ZEROINIT,8);
				if (!hMem) return 0;
				DWORD procid=GetCurrentProcessId();
				
				int* phItem=(int*)GlobalLock(hMem);
				phItem[0]=procid;	
				phItem[1]=(DWORD)pItem;
				GlobalUnlock(hMem);
				pDataSource->CacheGlobalData(cf_hinst, hMem);
				
				pItem->CopyDataToDataSource(pDataSource);
			}

			pDataSource->SetClipboard();
		}
		m_tree->SetRedraw(TRUE);
	}
	return true;
}
