// aplQueryItem.cpp
#include "stdafx.h"
#include "resource.h"
#include "PSMDoc.h"
#include "TabView.h"
#include "aplTopLevelItem.h"
#include "TreeProductItem.h"
#include "aplDocTreeItem.h"
#include "aplBPTreeItem.h"
#include "apl_lot_item.h"
#include "apl_prd_inst_item.h"
#include "NavigatorView.h"
#include "aplQueryItem.h"
#include "aplFolderTreeItem.h"



int CaplQueryTreeItem::query_count=1;
//************************************************************************
CaplQueryTreeItem::CaplQueryTreeItem(CTreeCtrl *tree, CPSMDoc *doc,CaplInstance* inst,CaplInstance* folder,CString type)
{

	m_tree=tree;
	m_doc=doc;
	m_inst=inst;
	m_folder=folder;
	m_classifier=0;
	m_is_root=false;
	if(doc!=0)doc->m_items.Add(this);
	m_type=type;
	m_execute_state=_T("");
	m_executed=false;
}
//************************************************************************
bool CaplQueryTreeItem::CreateTreeItem(HTREEITEM parent_item)
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	m_queries_item=parent_item;
	int num_ico=ICON_QUERYES;

	CString buf; 
	bool is_text=false;
	if(m_inst!=0){
		if(m_inst->GetAccessmode()<aplNO){
			if(m_doc->m_api.m_data.IsKindOf(m_inst,m_doc->m_api.m_query_mgr.e_apl_ct)){
				m_type=APL_TREE_ITEM_COMBINED_TABLE;
			}else if(m_doc->m_api.m_data.IsKindOf(m_inst,m_doc->m_api.m_query_mgr.e_apl_query)){
				m_doc->m_api.m_query_mgr.UpdateTypeQuery(m_inst);
				m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_query_mgr.a_apl_query_mode,m_type);	
				m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_query_mgr.a_apl_query_is_text_query,is_text);	
			}
		}
	}
		
	if(parent_item==TVI_ROOT && m_inst==0){
		m_is_root=true;
	}
	if(m_inst!=0){
		m_execute_state= APL_T("  ");
	}
	
	GetName(buf);
	InsetItem(buf,num_ico,m_queries_item);
	SetItemImage(num_ico, IDX_IL_TREE_ITEM);
	m_fictive_item=m_tree->InsertItem(_T("fictive"),0,0,m_item);
	m_expanded=false;
	UpdateIcon();
	
	return true;
}


bool CaplQueryTreeItem::TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode)
{
	if(m_inst!=0){
		if(m_inst->GetType()==0)return false;
	}
	if(!m_doc->m_api.m_data.IsConnected()){
		return false;
	}

	CMenu menu;  gSetPsmResourceHandle();
	BOOL res;
	int size;
	
	VERIFY(menu.LoadMenu(IDR_TREE_CONTEXT_MENU));
//	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(wnd); //	VERIFY(CaplMenu::Install(wnd, ePopupMenu ));
    CMenu* pPopup;
	
	if(m_inst!=0){
		if(m_doc->m_api.m_data.IsKindOf(m_inst,m_doc->m_api.m_query_mgr.e_apl_ct)){
			pPopup = menu.GetSubMenu(INDEX_COMBINED_TABLE_MENU);
		}else{
			pPopup = menu.GetSubMenu(INDEX_QUERY_MENU);
		}
	}else{
		pPopup = menu.GetSubMenu(INDEX_QUERY_MENU);
	}
    ASSERT(pPopup != NULL);
	if(pPopup==0) return false;

	AppendAddIn((CMenu*)pPopup);
	UpdateMenu((CMenu**)&pPopup, view_mode);

	if(m_is_root){
		pPopup->EnableMenuItem(ID_SHOW_CONTAINED_FOLDER, MF_BYCOMMAND | MF_GRAYED);
		
		pPopup->EnableMenuItem(ID_PDF_PI_BP_ANALIZE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_QUERY_SAVE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->ModifyMenu(ID_QUERY_EXECUTE,MF_BYCOMMAND| MF_STRING,ID_QUERY_EXECUTE,  APL_T("   "));
		pPopup->InsertMenu(1,MF_BYPOSITION| MF_STRING,ID_FIND,  APL_T("    "));
		if(!m_doc->m_api.m_data.IsConnected()){
			pPopup->EnableMenuItem(ID_QUERY_EXECUTE, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_FIND, MF_BYCOMMAND | MF_GRAYED);
		}
		pPopup->EnableMenuItem(ID_SHOW_PROPERTIES, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_VIEW_RESULT_IN_TABLE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_COPY_QUERY_RESULT2CATEGORY, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_COPY_QUERY_RESULT2FOLDER, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_COPY_QUERY_RESULT2CLASSIFIER, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_EDIT_COPY, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_OPEN_ITEM_IN_NEW_WINDOW, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_COPY_QUERY_OBJ2FOLDER, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SET_INST_ACCSESS, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_FREZEE_INST, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SET_INST_OWNER, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SET_INST_ACCSESS_RECURSIVE, MF_BYCOMMAND | MF_GRAYED);
/*		pPopup->EnableMenuItem(ID_SET_INST_ACCSESS, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_FREZEE_INST, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SET_INST_OWNER, MF_BYCOMMAND | MF_GRAYED);*/
		pPopup->EnableMenuItem(ID_REMOVE_FROM_FOLDER, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_REMOVE_FROM_CLASSIFIER, MF_BYCOMMAND | MF_GRAYED);           
		pPopup->EnableMenuItem(ID_DELETE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_NOTE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_NOTES, MF_BYCOMMAND | MF_GRAYED);
		
		if(CPSMDoc::m_show_saved_query_in_tree==TRUE){
			pPopup->CheckMenuItem(ID_SHOW_SAVED_IN_TREE, MF_BYCOMMAND | MF_CHECKED );
		}else{
			pPopup->CheckMenuItem(ID_SHOW_SAVED_IN_TREE, MF_BYCOMMAND | MF_UNCHECKED );
		}

	}else{
		pPopup->EnableMenuItem(ID_SHOW_SAVED_IN_TREE, MF_BYCOMMAND | MF_GRAYED);
		size=m_exec_result.Size;
		if(m_inst!=0){
			if(m_type==APL_TREE_ITEM_QUERY_NIIAO || m_type==APL_TREE_ITEM_QUERY){
				res=m_doc->m_api.m_query_mgr.LoadQueryInfo(m_inst,false);
				if(!m_executed){
					m_doc_data.GetAttr(m_inst,m_doc->m_api.m_query_mgr.a_apl_query_execution_size,size);
				}
			}else if(m_type==APL_TREE_ITEM_COMBINED_TABLE){
				res=m_doc->m_api.m_query_mgr.LoadCombinedTableInfo(m_inst,false);
			}
		}
		
		if(size==0){
			pPopup->EnableMenuItem(ID_VIEW_RESULT_IN_TABLE, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_PDF_PI_BP_ANALIZE, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_COPY_QUERY_RESULT2CATEGORY, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_COPY_QUERY_RESULT2FOLDER, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_COPY_QUERY_RESULT2CLASSIFIER, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_SET_INST_ACCSESS_RECURSIVE, MF_BYCOMMAND | MF_GRAYED);
		}
		if(m_inst==0){
			pPopup->EnableMenuItem(ID_EDIT_COPY, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_OPEN_ITEM_IN_NEW_WINDOW, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_COPY_QUERY_OBJ2FOLDER, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_SET_INST_ACCSESS, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_FREZEE_INST, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_SET_INST_OWNER, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_CREATE_NOTE, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_SHOW_NOTES, MF_BYCOMMAND | MF_GRAYED);
		}else if(m_inst->GetTemporary()){
			pPopup->EnableMenuItem(ID_EDIT_COPY, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_COPY_QUERY_OBJ2FOLDER, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_SET_INST_ACCSESS, MF_BYCOMMAND | MF_GRAYED);
			//pPopup->EnableMenuItem(ID_SET_INST_ACCSESS_RECURSIVE, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_FREZEE_INST, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_SET_INST_OWNER, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_CREATE_NOTE, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_SHOW_NOTES, MF_BYCOMMAND | MF_GRAYED);
		}else{
			pPopup->EnableMenuItem(ID_QUERY_SAVE, MF_BYCOMMAND | MF_GRAYED);
		}
		if(m_type!=APL_TREE_ITEM_QUERY_NIIAO){
			pPopup->EnableMenuItem(ID_PDF_PI_BP_ANALIZE, MF_BYCOMMAND | MF_GRAYED);
		}
		if(m_type==APL_TREE_ITEM_COMBINED_TABLE){
		}
		if(m_type==APL_TREE_ITEM_FIND){
			//pPopup->EnableMenuItem(ID_QUERY_SAVE, MF_BYCOMMAND | MF_GRAYED);
		}

		if(m_folder==0){
			pPopup->EnableMenuItem(ID_REMOVE_FROM_FOLDER, MF_BYCOMMAND | MF_GRAYED);
		}
		if(m_classifier==0){pPopup->EnableMenuItem(ID_REMOVE_FROM_CLASSIFIER, MF_BYCOMMAND | MF_GRAYED);}
	}
	if(m_doc->m_b_show_categ==FALSE)pPopup->RemoveMenu(ID_COPY_QUERY_RESULT2CATEGORY, MF_BYCOMMAND | MF_GRAYED);


	CaplInstance* folder,*category,*classifier_lev,*inst1;
	CaplQueryTreeItem *item=0;
	CString name;
	bool flag=true;
	CaplAggr aggr;
	aplExtent ext;
	CString buf,buf1;
	res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
		TPM_RIGHTBUTTON|TPM_RETURNCMD,point.x, point.y,wnd);
	bool old_flag;

	switch(res){
	case ID_SHOW_CONTAINED_FOLDER:
		ShowContainedFolder(m_inst);
		break;
		
	case ID_SHOW_SAVED_IN_TREE:
		if(CPSMDoc::m_show_saved_query_in_tree==TRUE){
			CPSMDoc::m_show_saved_query_in_tree=FALSE;
			pPopup->CheckMenuItem(ID_SHOW_SAVED_IN_TREE, MF_BYCOMMAND | MF_CHECKED );
		}else{
			CPSMDoc::m_show_saved_query_in_tree=TRUE;
			pPopup->CheckMenuItem(ID_SHOW_SAVED_IN_TREE, MF_BYCOMMAND | MF_UNCHECKED );
		}
		Expand(1);
		Expand(2);
		break;
	case ID_QUERY_SAVE:
		//ShowProperties();
		SaveQuery();
		m_doc_data.NET_SaveChanges();
		UpdateIcon();
		break;
	case ID_SHOW_PROPERTIES:
		ShowProperties();
		m_doc_data.NET_SaveChanges();
		UpdateIcon();
		break;
	case ID_FIND:
		if(m_is_root){
			m_doc->OnDbFind();
		}
		m_doc_data.NET_SaveChanges();
		UpdateIcon();
		break;
	case ID_QUERY_EXECUTE:
		if(m_is_root){
			m_doc->OnDbQuery();
		}else{
			Run(false);
		}
		m_doc_data.NET_SaveChanges();
		UpdateIcon();
		break;
		
	case ID_DELETE:
		if(m_inst==0){
			int i=m_doc->m_items.Find(this);
			if(i!=-1)m_doc->m_items.Remove(i);
		}else{
			if(m_inst->GetAccessmode()>aplOWN){
				AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP);
				return false;
			}
			name=m_type==APL_TREE_ITEM_COMBINED_TABLE? APL_T(" "): APL_T("");
			if(AfxMessageBox( APL_T("    ")+name+_T(" ?"),MB_YESNO)==IDNO){
				return false;
			}
			if(m_doc->m_api.m_query_mgr.DeleteQuery(m_inst)){
				m_doc_data.NET_SaveChanges();
				int i=m_doc->m_items.Find(this);
				if(i!=-1)m_doc->m_items.Remove(i);
			}
		}
		break;
	case ID_REMOVE_FROM_FOLDER:
		if(m_folder==0)return false;
		if(m_folder->GetAccessmode()>aplOWN){
			AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP);
			return false;
		}
		name=m_type==APL_TREE_ITEM_COMBINED_TABLE? APL_T(" "): APL_T("");
		if(AfxMessageBox( APL_T("    ")+name+ APL_T("  ?"),MB_YESNO)==IDNO){
			return false;
		}
		if(m_doc->m_api.m_folder_mgr.RemoveFromFolder(m_folder,m_inst))
		{
			m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_query_mgr.a_apl_query_folder,folder);
			if(folder == m_folder)
			{
				folder = 0;
				m_doc->m_api.m_data.PutAttr(m_inst,m_doc->m_api.m_query_mgr.a_apl_query_folder,folder);
			}
			//  ,   item,   !
			m_doc_data.NET_SaveChanges();
			m_doc->m_items.Remove(m_doc->m_items.Find(this));
		}
		break;

	case ID_REMOVE_FROM_CLASSIFIER:
		if(m_classifier!=0)
		{
			if(m_classifier->GetAccessmode()>aplRW)	{AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return true;}
			if(m_doc->m_api.m_classifier_mgr.DeleteClassifierAssociation(m_inst,m_classifier))
				m_doc->m_items.Remove(m_doc->m_items.Find(this));
		}
		break;
	case ID_COPY_QUERY_RESULT2CLASSIFIER:
		old_flag=m_doc->m_api.m_classifier_mgr.m_AutoSave;
		m_doc->m_api.m_classifier_mgr.m_AutoSave=false;
		//  
		LoadQueryResult();

		while(true)
		{
			classifier_lev=m_doc->m_api.m_query_mgr.SelectInstance(APL_MODE_SELECT_CLASSIF_ELEMENT);
			if(classifier_lev==0)
				break;
			if(m_doc->m_api.m_classifier_mgr.CreateClassifierAssociation(m_exec_result,classifier_lev))
			{
				AfxMessageBox( APL_T("  "));
			}
			else
			{
				AfxMessageBox( APL_T(" "));
			}
			break;
		}

		m_doc->m_api.m_classifier_mgr.m_AutoSave=old_flag;
		if(m_doc->m_api.m_classifier_mgr.m_AutoSave)m_doc_data.NET_SaveChanges();
		break;
	case ID_COPY_QUERY_RESULT2FOLDER:
		old_flag=m_doc->m_api.m_folder_mgr.m_AutoSave;
		m_doc->m_api.m_folder_mgr.m_AutoSave=false;

		while(true){
			
			folder=m_doc->m_api.m_query_mgr.SelectInstance(APL_MODE_SELECT_FOLDER);
			if(folder==0)
				break;
			m_doc->m_api.m_data.GetAttr(folder,m_doc->m_api.m_folder_mgr.a_folder_content,aggr);
			if(aggr.GetSize()>0){
				if(AfxMessageBox( APL_T("     .\n     ?"),MB_YESNO)==IDNO)continue;
			}
			//  
			LoadQueryResult();
			
			for(int i=0;i<m_exec_result.GetSize();i++){
				aggr.Add(m_exec_result.GetAt(i));
			}
			m_doc->m_api.m_data.PutAttr(folder,m_doc->m_api.m_folder_mgr.a_folder_content,aggr);
			AfxMessageBox( APL_T("  "));
			break;
		}

		m_doc->m_api.m_folder_mgr.m_AutoSave=old_flag;
		if(m_doc->m_api.m_folder_mgr.m_AutoSave)m_doc_data.NET_SaveChanges();
		break;
	case ID_COPY_QUERY_RESULT2CATEGORY:
		old_flag=m_doc->m_api.m_folder_mgr.m_AutoSave;
		m_doc->m_api.m_folder_mgr.m_AutoSave=false;
		
		while(true){
			aplExtent pdf_s,products_categ;
			
			category=m_doc->m_api.m_query_mgr.SelectInstance(APL_MODE_SELECT_CATEGORY);
			if(category==0)
				break;
			flag=true;
			//  
			LoadQueryResult();
			res=TRUE;
			if(!m_doc->m_api.m_categ_mgr.CheckMyLock(category, false)){
				res=m_doc->m_api.m_categ_mgr.CheckOut(category);
			}
			CaplInstance *lock=m_doc->m_api.m_categ_mgr.CheckMyLock(category,true);

			if(lock!=0){
				m_doc->m_api.m_data.GetAttr(lock,m_doc->m_api.m_categ_mgr.a_categ_ver_products,products_categ);
				for(int i=0;i<m_exec_result.GetSize();i++){
					inst1=m_exec_result.GetAt(i);
					if(m_doc->m_api.m_data.IsKindOf(inst1,m_doc->m_api.m_prd_mgr.e_prd)){
						products_categ.Add(inst1);
					}else if(m_doc->m_api.m_data.IsKindOf(inst1,m_doc->m_api.m_prd_mgr.e_pdf)){
						pdf_s.Add(inst1);
					}else{
						AfxMessageBox( APL_T("     !"));
						flag=false;
						break;
					}
				}
				if(flag){
					if(pdf_s.GetSize()>0){
						m_doc->m_api.m_query_mgr.LoadExtentInfo(pdf_s);
						for(int i=0;i<pdf_s.GetSize();i++){
							m_doc->m_api.m_data.GetAttr(pdf_s.GetAt(i),m_doc->m_api.m_prd_mgr.a_pdf_prd,inst1);
							products_categ.Add(inst1);
						}

					}
					m_doc->m_api.m_data.PutAttr(lock,m_doc->m_api.m_categ_mgr.a_categ_ver_products,products_categ);
					m_doc->m_api.m_categ_mgr.CheckIn(category);
					AfxMessageBox( APL_T("  "));
				}else{
					m_doc->m_api.m_categ_mgr.UndoCheckOut(category);
				}
			}
			break;
		}
		
		m_doc->m_api.m_folder_mgr.m_AutoSave=old_flag;
		if(m_doc->m_api.m_folder_mgr.m_AutoSave)m_doc_data.NET_SaveChanges();
		break;
		
		
	case ID_COPY_QUERY_OBJ2FOLDER:
		old_flag=m_doc->m_api.m_folder_mgr.m_AutoSave;
		m_doc->m_api.m_folder_mgr.m_AutoSave=false;

		folder=m_doc->m_api.m_query_mgr.SelectInstance(APL_MODE_SELECT_FOLDER);
		if(folder==0)
			break;
		m_doc->m_api.m_data.GetAttr(folder,m_doc->m_api.m_folder_mgr.a_folder_content,aggr);
		aggr.Add(m_inst);
		m_doc->m_api.m_data.PutAttr(folder,m_doc->m_api.m_folder_mgr.a_folder_content,aggr);
		AfxMessageBox( APL_T(" "));
		
		m_doc->m_api.m_folder_mgr.m_AutoSave=old_flag;
		m_doc_data.NET_SaveChanges();
		break;		
		
	case ID_VIEW_RESULT_IN_TABLE:
		if(m_inst!=0 || m_is_root){
			res=m_doc->m_api.m_query_mgr.LoadQueryInfo(m_inst,true);
			if(!m_executed){
				m_doc->m_api.m_query_mgr.GetFindResult(m_inst,m_exec_result,m_exec_date);
			}
			m_doc->m_api.m_query_mgr.CheckRemoveLowLevelInstances(m_exec_result);
		}
		if(m_exec_result.Size>1000)
		{
			CString msg=APL_T("   (%i)  .\n");
			msg+=APL_T("       .\n");
			msg+=APL_T("  ?");

			buf.Format(msg, m_exec_result.Size);
			if(IDYES!=AfxMessageBox(buf,MB_YESNO|MB_ICONQUESTION))
			{
				m_execute_state= APL_T("  ");
				m_doc->m_tab_view->Update(this);
				break;
			}
		}
		
		StartBusy();
		//  
		res=m_doc->m_api.m_query_mgr.LoadExtentInfo(m_exec_result);
		StopBusy();
		
		MakeInstListTable(&(m_doc->m_api),&m_exec_result,true,0,false,0,0,m_doc->m_b_show_categ==TRUE);
		/*
		if(m_type==APL_TREE_ITEM_QUERY_NIIAO){
			MakeNIIAOFindResult(&(m_doc->m_api),&m_exec_result,true);
		}else{
			MakeInstListTable(&(m_doc->m_api),&m_exec_result,true);
		}
		*/
		break;
	case ID_PDF_PI_BP_ANALIZE:
		if(m_inst!=0 || m_is_root){
			res=m_doc->m_api.m_query_mgr.LoadQueryInfo(m_inst,true);
			if(!m_executed){
				m_doc->m_api.m_query_mgr.GetFindResult(m_inst,m_exec_result,m_exec_date);
			}
			m_doc->m_api.m_query_mgr.CheckRemoveLowLevelInstances(m_exec_result);
		}
		m_doc->m_api.m_query_mgr.GetName(m_inst,buf,buf1);
		buf1= APL_T("     ")+buf;
		inst1=m_doc->m_api.m_query_mgr.ShowCombinedTable(m_inst,buf1);

		item=new CaplQueryTreeItem(m_tree,m_doc,inst1,0,APL_TREE_ITEM_COMBINED_TABLE);
		
		item->CreateTreeItem(m_doc->m_navigator->m_queries_item->m_item);

		//AnalizeGroupInstances(&(m_doc->m_api),&m_exec_result);
		break;
	case ID_OPEN_ITEM_IN_NEW_WINDOW:
		m_doc->OpenInstanceInNewWindow(m_inst);
		break;
//	case ID_SET_ACCESS_QUERY_CONTENTS:
//		{
//			aplExtent ext;COleDateTime odt;
//			m_doc->m_api.m_query_mgr.LoadQueryInfo(m_inst,true);
//			m_doc->m_api.m_query_mgr.GetFindResult(m_inst,ext,odt);
//			if(ext.Size<=0) AfxMessageBox(APL_T("  !!!"));
//			else
//			{
//				m_doc_data.NET_SetInstancesAccess(&ext,(CaplInstance *)0,
//					(aplAccessModeType)-1);
//			}
//		}	
//		break;
	default: PrepareContextMenu(res); break;
	}
	return true;
}

bool CaplQueryTreeItem::Expand(UINT action)
{
	// action = 2 ->  
	// action = 1 -> 
	_APL_TREE_ITEM_CHEK_PARAM_BOOL

	if(action==2)
	{
		if(m_expanded) return true;
		if(m_hasSubItem)Expand(1);
		if(!ShowContents())
			return false;
	}
	else if(action==1)
	{
		CollapseItem();
		m_contents.Clear();
	}
	
	return true;
}
//****************************************************************
bool CaplQueryTreeItem::GetName(CString &name){
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	
	if(m_inst==0){
		name= APL_T("  ");
	}else{
		m_doc->m_api.GetItemName(m_inst,name);
	}
	return true;
}
//****************************************************************

bool CaplQueryTreeItem::Create(CString mode,bool old_style)
{
	CaplQueryTreeItem *item=new CaplQueryTreeItem(m_tree,m_doc,0,0,mode);
	
	//  ,   .       .
	Expand(2);
	item->CreateTreeItem(m_item);
	item->Expand(1);
	return item->Run(true,_T(""),_T(""),old_style);
}
//****************************************************************
void CaplQueryTreeItem::SaveQuery()
{
	CaplDataBuf* dbuf=0;
	if(m_inst!=0){
		if(m_inst->GetType()==0)return;
		
		if(m_inst->GetTemporary()){
			m_doc->m_api.m_query_mgr.SaveQuery(m_inst);
		}	
	}
}

//****************************************************************

void CaplQueryTreeItem::ShowProperties(){
	if(!m_is_root)Run();
}
//****************************************************************

bool CaplQueryTreeItem::Run(bool is_dlg,CString mode,CString predef_id,bool old_style)
{

	CString buf,buf1,name,name_const=_T("");
	CaplInstance* inst=0;
	bool is_new_window = false;

	if(m_tree==0) return true;
	if(m_doc==0)return true;
	if(m_doc->m_navigator==0)return true;;
	if(m_doc->m_navigator->m_queries_item==0)return true;

	if(old_style)
		m_doc->m_api.m_query_mgr.SetStyleDlg(1);
	else
		m_doc->m_api.m_query_mgr.SetStyleDlg(CPSMDoc::m_show_old_query_dlg);

	if(mode!=_T("") || predef_id!=_T("")){
		m_type=APL_TREE_ITEM_FIND;
	}
	if(m_inst!=0){
		if(m_inst->GetType()==0)return true;
		if(m_doc->m_api.m_data.IsKindOf(m_inst,m_doc->m_api.m_query_mgr.e_apl_ct)){
			m_type=APL_TREE_ITEM_COMBINED_TABLE;
		}else if(m_doc->m_api.m_data.IsKindOf(m_inst,m_doc->m_api.m_query_mgr.e_apl_query)){
			m_doc->m_api.m_query_mgr.UpdateTypeQuery(m_inst);
			m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_query_mgr.a_apl_query_mode,m_type);		
		}
	}
	if(m_type==_T("")){
		m_type=APL_TREE_ITEM_QUERY;
	}
	if(m_type==APL_TREE_ITEM_COMBINED_TABLE){
		name_const= APL_T("   ");
	}else{
		name_const= APL_T("  ");
	}
	if(m_inst==0){
		do{
			name.Format(name_const+_T("%.2i"),query_count);query_count++;
			if(!m_doc->m_api.m_query_mgr.TestNameQuery(name,0,false)){
				continue;
			}
			break;
		}while(true);
	}
	
	if(is_dlg || m_inst==0){
		if(m_type==APL_TREE_ITEM_QUERY){
			inst=m_doc->m_api.m_query_mgr.PrepareQuery(m_inst,name,false,true,true,false,m_type,0,_T(""),&is_new_window);
		}else if(m_type==APL_TREE_ITEM_QUERY_NIIAO){
			inst=m_doc->m_api.m_query_mgr.PrepareQuery(m_inst,name,false,true,true,false,m_type,0,_T(""),&is_new_window);
		}else if(m_type==APL_TREE_ITEM_COMBINED_TABLE){
			inst=m_doc->m_api.m_query_mgr.ShowCombinedTable(m_inst,name);
		}else if(m_type==APL_TREE_ITEM_FIND){
			inst=m_doc->m_api.m_query_mgr.PrepareFind(m_inst,mode,predef_id);
		}else{
			inst=0;
			AfxMessageBox( APL_T("  !"));
		}
	}else{
		inst=m_inst;
	}
	if(inst==0 && m_inst==0){
		//      ""
		//AfxMessageBox(APL_T("    !!!"),MB_OK|MB_SYSTEMMODAL);
		//   
		int i=m_doc->m_items.Find(this);
		if(i!=-1)m_doc->m_items.Remove(i);
	}
	if(inst==0){
		//  "" -    
		return !is_new_window;	
	}
	m_inst=inst;
	
	//        
	//    "..."
	RefreshAllThisQueryItem(true);
	
	bool res=false;
	
	int j=0;

	//      -  
	if(!is_new_window)
	{
		m_tree->SelectItem(m_item);
		m_tree->SelectDropTarget(m_item);
	}
	// --     (        )
	//        -   /      
	//m_doc->m_navigator->m_queries_item->Sort(false);

	//   
	if(!m_is_root){
		Expand(1);
		if(m_fictive_item!=0)
		{
			m_tree->DeleteItem(m_fictive_item);
			m_fictive_item=0;
		}
	}
	if(m_doc_data.IsKindOf(m_inst,m_doc->m_api.m_query_mgr.e_apl_query))
	{
		//   ShowInListCtrl       (     RW)
		m_exec_result.Clear();

		StartBusy();
		DWORD tick1=GetTickCount();
		if(m_type==APL_TREE_ITEM_QUERY || m_type==APL_TREE_ITEM_QUERY_NIIAO){
			res=m_doc->m_api.m_query_mgr.ExecuteQuery(m_inst,m_exec_result);
		}else if(m_type==APL_TREE_ITEM_FIND){
			res=m_doc->m_api.m_query_mgr.ExecuteFind(m_inst,m_exec_result);
		}
		DWORD ttr=GetTickCount()-tick1;
		float time_tick=(float)ttr/1000;
		StopBusy();
		m_executed=true;

		//         -   
		RefreshAllThisQueryItem(false);

		if(m_inst->GetAccessmode()>aplRW){
			m_doc_data.NET_GetServerDateTime(m_exec_date);
		}else{
			m_doc_data.GetAttr(m_inst,m_doc->m_api.m_query_mgr.a_apl_query_execution_date,buf1);
			aplString2Date(buf1,m_exec_date);
		}
		if(!res){
			m_execute_state= APL_T(" ");
			m_doc->m_tab_view->Update(this);
			return !is_new_window;
		}
		if(m_exec_result.GetSize()==0) {
			m_execute_state= APL_T("  ");
			AfxMessageBox( APL_T("   !!!"),MB_OK/*|MB_SYSTEMMODAL*/);
			m_doc->m_tab_view->Update(this);
		}
		else
		{
			buf1.Format( APL_T(" %i  %.3f .   ?"),m_exec_result.Size,time_tick);
			if(IDYES!=AfxMessageBox(buf1,MB_YESNO|MB_ICONQUESTION/*|MB_SYSTEMMODAL*/)){
				buf1.Format( APL_T(";  %i: "),m_exec_result.Size);
				m_execute_state= APL_T("  ");
				m_doc->m_tab_view->Update(this);
				return !is_new_window;
			}
		}
	
		if(is_new_window){m_doc->OpenInstanceInNewWindow(m_inst);return !is_new_window;}
		else{ShowContents(true);}
	}

	if(is_new_window)m_doc->m_navigator->m_queries_item->Expand(2);
	return !is_new_window;
}
//************************************************************************

bool CaplQueryTreeItem::ShowContents(bool is_run)
{
	m_expanded=true;
	CString name,buf1;
	int i,size;
	
	if(m_tree==0 || m_doc == 0){
		return false;
	}
	m_tree->SetRedraw(FALSE);
	if(m_fictive_item!=0)
	{
		m_tree->DeleteItem(m_fictive_item);
		m_fictive_item=0;
	}
	m_tree->SetRedraw(TRUE);
	if(m_inst!=0){
		if(m_inst->GetType()==0){
			return false;	
		}
	}
	bool res=true;

	
	GetName(name);
	m_tree->SetItemText(m_item,name);
	if(m_is_root){
		res=m_doc->m_api.m_query_mgr.LoadQueryInfo(m_inst,true);
	}else{
		size=0;
		if(m_inst!=0){
			res=m_doc->m_api.m_query_mgr.LoadQueryInfo(m_inst,false);
			if(m_executed){
				size=m_exec_result.Size;
			}else{
				m_doc_data.GetAttr(m_inst,m_doc->m_api.m_query_mgr.a_apl_query_execution_size,size);
			}
		}
		if(size>1000)
		{
			CString msg=APL_T("   (%i)  .\n");
			msg+=APL_T("       .\n");
			msg+=APL_T("  ?");

			buf1.Format(msg ,size);
			if(IDYES!=AfxMessageBox(buf1,MB_YESNO|MB_ICONQUESTION))
			{
				m_execute_state= APL_T("  ");
				m_doc->m_tab_view->Update(this);
				//Expand(1);
				return false;
			}
		}
	}
		
	res=LoadQueryResult();

	bool flag=false,flag_move=true;
	if(res){
		if(is_run && !m_is_root && m_inst!=0){
			m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_query_mgr.a_apl_query_make_table,flag);
			if(flag){
				MakeInstListTable(&(m_doc->m_api),&m_exec_result,false,&flag_move,false,0,0,m_doc->m_b_show_categ==TRUE);
				/*
				if(m_type==APL_TREE_ITEM_QUERY_NIIAO){
					MakeNIIAOFindResult(&(m_doc->m_api),&m_exec_result,false);
				}else{
					MakeInstListTable(&(m_doc->m_api),&m_exec_result,false,&flag_move);
				}
				*/
			}
		}
		m_tree->SetRedraw(FALSE);
		if(flag_move){
			m_contents.Clear();
			int num_err=0;
			for(i=0;i<m_exec_result.GetSize();i++)
			{
				if(m_exec_result[i]->GetAccessmode()==aplNO)continue;
				if(!InsertInstInTree(m_exec_result[i],m_item,m_doc,m_tree,m_contents,0)){
					num_err++;
				}
			}
			if(num_err==0){
				m_execute_state=( APL_T("  "));
			}else{
				m_execute_state.Format( APL_T("%i        \n    "),num_err);
				AfxMessageBox(m_execute_state,MB_OK |MB_ICONERROR);
			}
		}else{
			m_execute_state=( APL_T("  "));
		}
		m_tree->Select(m_item,TVGN_FIRSTVISIBLE);
		m_tree->SelectItem(m_item);

		m_tree->SetItemText(m_item,name);
		m_doc->m_tab_view->Update(this);
		m_tree->SetRedraw(TRUE);
	}
	m_tree->Expand(m_item,TVE_EXPAND);
	Sort();
	return true;
}
//************************************************************************

void CaplQueryTreeItem::ShowCmd(long cmd)
{
	switch (cmd)
	{
		case ID_EXPAND_ALL: {int i=1; ExpandAll(i);} break;
		case ID_SHOW_ALL_CONTENTS:  Expand(2); MyExpand(); break;
		default: PrepareContextMenu(cmd);break;
	}
}
//****************************************************************

bool CaplQueryTreeItem::ShowInListCtrl(CListCtrl *list)
{
	CString buf;
	int i,size;

	if(list==0) return false;
	if(m_doc==0)return false;
	if(m_inst==0){
		if(m_is_root){
			i=list->InsertItem(list->GetItemCount(), APL_T(" :"));
			buf.Format(_T("%i"),m_exec_result.GetSize());
			list->SetItemText(i,1,buf);
			
			i=list->InsertItem(list->GetItemCount(), APL_T(" :"));
			list->SetItemText(i,1,m_execute_state);
		}
		return false;
	}
	CHECK_SHOW_LIST_CTRL(m_inst);

	if(m_doc_data.IsKindOf(m_inst,m_doc->m_api.m_query_mgr.e_apl_query))
	{
		m_doc->m_api.m_query_mgr.LoadQueryInfo(m_inst,false,true);
		
		i=list->InsertItem(list->GetItemCount(), APL_T(":"));
		m_doc_data.GetAttrBN(m_inst,S::name,buf);
		list->SetItemText(i,1,buf);
			
		i=list->InsertItem(list->GetItemCount(), APL_T(":"));
		m_doc_data.GetAttrBN(m_inst,S::description,buf);
		list->SetItemText(i,1,buf);

		i=list->InsertItem(list->GetItemCount(), APL_T(" :"));
		m_doc_data.GetAttrBN(m_inst,_T("mode"),buf);
		list->SetItemText(i,1,buf);
		
		i=list->InsertItem(list->GetItemCount(), APL_T(":"));
		if(m_inst->GetTemporary()){buf= APL_T("   ");}else{buf= APL_T("  ");}
		list->SetItemText(i,1,buf);
		
		i=list->InsertItem(list->GetItemCount(),_T(""));
		
		if(m_executed){
			i=list->InsertItem(list->GetItemCount(), APL_T(" :"));
			buf.Format( APL_T(";  %i"),m_exec_result.GetSize());
			list->SetItemText(i,1,m_exec_date.Format( APL_T(" %d/%m/%Y  %H:%M:%S "))+buf);
		}
		if(m_inst->GetAccessmode()>aplRW || !m_executed){
			COleDateTime odt;

			m_doc_data.GetAttr(m_inst,m_doc->m_api.m_query_mgr.a_apl_query_execution_size,size);
			m_doc_data.GetAttr(m_inst,m_doc->m_api.m_query_mgr.a_apl_query_execution_date,buf);
			aplString2Date(buf,odt);

			i=list->InsertItem(list->GetItemCount(), APL_T(" :"));
			buf.Format( APL_T(";  %i"),size);
			list->SetItemText(i,1,odt.Format( APL_T(" %d/%m/%Y  %H:%M:%S "))+buf);
		}
			
		
		list->InsertItem(list->GetItemCount(),_T(""));
		
		i=list->InsertItem(list->GetItemCount(), APL_T("  :"));
		GetAccessName(m_inst,buf);
		list->SetItemText(i,1,buf);
		
		aplExtent ext;
		CStringArray  comment;
		comment.Add( APL_T(" "));
		ext.Add(m_inst);
		if(m_classifier!=0){
			CaplInstance* classif_ref;
			m_doc->m_api.m_classifier_mgr.TestClassifierAssociation(m_inst,m_classifier,&classif_ref);
			if(classif_ref!=0){
				comment.Add(_T("classifier association"));
				ext.Add(classif_ref);
			}
			comment.Add(_T("m_classifier"));
			ext.Add(m_classifier);
		}
		ShowInstanceInfoInListCtrl(ext,list,&comment);
	}
	else if(m_doc_data.IsKindOf(m_inst,m_doc->m_api.m_query_mgr.e_apl_ct))
	{
		m_doc->m_api.m_query_mgr.LoadCombinedTableInfo(m_inst,false,true);
		
		i=list->InsertItem(list->GetItemCount(), APL_T(":"));
		m_doc_data.GetAttrBN(m_inst,S::name,buf);
		list->SetItemText(i,1,buf);
		
		i=list->InsertItem(list->GetItemCount(), APL_T(":"));
		m_doc_data.GetAttrBN(m_inst,S::description,buf);
		list->SetItemText(i,1,buf);
		
		i=list->InsertItem(list->GetItemCount(), APL_T(":"));
		if(m_inst->GetTemporary()){buf= APL_T("   ");}else{buf= APL_T("  ");}
		list->SetItemText(i,1,buf);
		
		list->InsertItem(list->GetItemCount(),_T(""));
		
		i=list->InsertItem(list->GetItemCount(), APL_T("  :"));
		GetAccessName(m_inst,buf);
		list->SetItemText(i,1,buf);
		
		aplExtent ext;
		CStringArray  comment;
		comment.Add( APL_T("  "));
		ext.Add(m_inst);
		if(m_classifier!=0){
			CaplInstance* classif_ref;
			m_doc->m_api.m_classifier_mgr.TestClassifierAssociation(m_inst,m_classifier,&classif_ref);
			if(classif_ref!=0){
				comment.Add(_T("classifier association"));
				ext.Add(classif_ref);
			}
			comment.Add(_T("m_classifier"));
			ext.Add(m_classifier);
		}
		ShowInstanceInfoInListCtrl(ext,list,&comment);
	}
	
	return true;
}
//****************************************************************

void CaplQueryTreeItem::GetAccessedInstances(aplExtent &ext)
{
	ext.Clear();
	if(m_inst!=0)
	{
		if(m_inst->GetType()!=0){
			m_doc->m_api.m_query_mgr.LoadQueryInfo(m_inst);
			ext.Add(m_inst);
		}
	}
}
//****************************************************************

void CaplQueryTreeItem::UpdateIcon()
{
	int num_ico=ICON_FIND;
	bool is_text=false;
	if(m_inst==0){
		num_ico=ICON_QUERYES;
	}else{
		if(m_inst->GetAccessmode()<=aplRW){
			m_doc->m_api.m_query_mgr.UpdateTypeQuery(m_inst);
			m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_query_mgr.a_apl_query_mode,m_type);	
			m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_query_mgr.a_apl_query_is_text_query,is_text);	
		}
		if(m_is_root){
			num_ico=ICON_QUERYES;
		}else if(m_doc->m_api.m_data.IsKindOf(m_inst,m_doc->m_api.m_query_mgr.e_apl_ct)){
			if(m_inst->GetTemporary()){
				num_ico=ICON_COMB_TABLE;
			}else{
				num_ico=ICON_COMB_TABLE_SAVED;
			}
			m_type=APL_TREE_ITEM_COMBINED_TABLE;
		}else if(is_text && m_inst->GetTemporary()){
			num_ico=ICON_QUERY_Q;
		}else if(is_text && !m_inst->GetTemporary()){
			num_ico=ICON_QUERY_Q_SAVED;
		}else if(m_type==APL_TREE_ITEM_FIND && m_inst->GetTemporary()){
			num_ico=ICON_FIND;
		}else if(m_type==APL_TREE_ITEM_FIND && !m_inst->GetTemporary()){
			num_ico=ICON_FIND;
		}else if(m_type==APL_TREE_ITEM_QUERY_NIIAO && m_inst->GetTemporary()){
			num_ico=ICON_QUERY_N;
		}else if(m_type==APL_TREE_ITEM_QUERY_NIIAO && !m_inst->GetTemporary()){
			num_ico=ICON_QUERY_N_SAVED;
		}else if(m_type==APL_TREE_ITEM_QUERY && !m_inst->GetTemporary()){
			num_ico=ICON_QUERY_SAVED;
		}else{
			num_ico=ICON_QUERY;
		}
	}
	
	SetItemImage(num_ico, IDX_IL_TREE_ITEM);
}

//  
bool CaplQueryTreeItem::LoadQueryResult()
{
	bool res=TRUE;
	StartBusy();
	if(m_type==APL_TREE_ITEM_COMBINED_TABLE){
		res=m_doc->m_api.m_query_mgr.LoadCombinedTableInfo(m_inst,true);
	}else if(!m_executed){
		res=m_doc->m_api.m_query_mgr.LoadQueryInfo(m_inst,true);
		m_doc->m_api.m_query_mgr.GetFindResult(m_inst,m_exec_result,m_exec_date,
										CPSMDoc::m_show_saved_query_in_tree==FALSE);
	}
	m_doc->m_api.m_query_mgr.CheckRemoveLowLevelInstances(m_exec_result);
	res=m_doc->m_api.m_query_mgr.LoadExtentInfo(m_exec_result);
	StopBusy();
	return res;
}

BOOL CaplQueryTreeItem::ShowToolBarButton(CCmdUI* pCmdUI)
{
	if(m_inst==0)return FALSE;
	if(m_inst->GetType()==0)return FALSE;
	if(m_inst->GetTemporary())return FALSE;

	switch(pCmdUI->m_nID)
	{
	case ID_SHOW_NOTES:
	case ID_CREATE_NOTE:
		pCmdUI->Enable(TRUE); return TRUE; break;
	}
	return FALSE;
}

bool CaplQueryTreeItem::MoveQuery(CPSMDoc* doc, CaplQueryTreeItem* q_item, CaplTreeItem* from_item, CaplTreeItem* to_item)
{
	if(!q_item || !from_item || !to_item) return false;
	if(from_item==to_item) return false;//  

	CaplInstance *i_query = q_item->m_inst;// 
	CaplInstance *i_old_folder;

	aplExtent from_instance, to_instance;
	from_item->GetAccessedInstances(from_instance);
	to_item->GetAccessedInstances(to_instance);
	if(to_item->m_type!=APL_TREE_ITEM_FOLDER)
	{
		AfxMessageBox( APL_T("     !"));
		return false;
	}

	if(to_instance.GetSize()==0) return false;

	if(to_instance[0]->GetAccessmode()>aplRW)
	{
		AfxMessageBox( APL_T("    "));
		return false;
	}
	if(from_instance.GetSize()>0 && from_instance[0]->GetAccessmode()>aplRW)
	{
		AfxMessageBox( APL_T("   -"));
		return false;
	}

	// :    
	if(doc->m_api.m_data.IsKindOf(to_instance[0], doc->m_api.m_folder_mgr.e_folder))
	{
		if(doc->m_api.m_folder_mgr.AddToFolder(to_instance[0], i_query))
		{
			doc->m_api.m_data.GetAttr(i_query,doc->m_api.m_query_mgr.a_apl_query_folder,i_old_folder);
			if(i_old_folder!=0)//    
			{
				if(doc->m_api.m_folder_mgr.RemoveFromFolder(i_old_folder, i_query))
				{
					((CaplFolderTreeItem*)from_item)->m_contents.
						Remove(((CaplFolderTreeItem*)from_item)->m_contents.Find(i_query));
				}
			}
			doc->m_api.m_data.PutAttr(i_query,doc->m_api.m_query_mgr.a_apl_query_folder,to_instance[0]);
			((CaplFolderTreeItem*)to_item)->ShowContents();
			((CaplFolderTreeItem*)to_item)->MyExpand();
		}
		if(i_old_folder == 0)
		{
			//     

		}
	}
	else
	{
		AfxMessageBox( APL_T("     !"));
		return false;
	}


	doc->m_items.Remove(doc->m_items.Find(q_item));
	doc->m_api.m_data.NET_SaveChanges();	

	return true;
}

//        
bool CaplQueryTreeItem::RefreshAllThisQueryItem(bool executed)
{
	int i;
	CString buf;
	for(i=0;i<m_doc->m_items.Size;i++)
	{
//		    ,  ..    -     
// 		if(m_doc->m_items[i]!=this)
// 		{
// 		}
		if(m_doc->m_items[i]->m_type==m_type)
		{
			CaplQueryTreeItem *item=(CaplQueryTreeItem*)m_doc->m_items[i];
			if(item->m_inst==m_inst)
			{
				GetName(buf);
				if(executed && m_type!=APL_TREE_ITEM_COMBINED_TABLE)buf+= APL_T(";  ...");
				m_tree->SetItemText(item->m_item,buf);

				//    
				item->UpdateIcon();
			}
		}
	}
	return true;
}
