// aplTreeApprovalItem.cpp

#include "stdafx.h"
#include "PSMDoc.h"
#include "resource.h"
#include "aplTreeApprovalItem.h"
#include "TabView.h"

//****************************************************************
//****************************************************************
//****************************************************************

bool CaplApprovalTreeItem::m_ShowStatus=true;
bool CaplApprovalTreeItem::m_ShowPesonRole=true;
bool CaplApprovalTreeItem::m_ShowPerson=true;

bool CaplApprovalTreeItem::m_ShowOrgId=false;
bool CaplApprovalTreeItem::m_ShowOrgName=true;
bool CaplApprovalTreeItem::m_AutoFrezeApproval=false;

CaplApprovalTreeItem::CaplApprovalTreeItem(CTreeCtrl *tree, CPSMDoc *doc, 
										   CaplInstance *appr)
{ 
	m_type=APL_TREE_ITEM_APPROVAL;
	m_appr=appr;
	m_doc=doc;
	m_tree=tree;
	if(doc!=0) doc->m_items.Add(this);
}
//****************************************************************
bool CaplApprovalTreeItem::TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode)
{
	CMenu menu;  gSetPsmResourceHandle();
	VERIFY(menu.LoadMenu(IDR_TREE_CONTEXT_MENU));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(wnd); // 	VERIFY(CaplMenu::Install(wnd, ePopupMenu ));
    CMenu* pPopup = menu.GetSubMenu(INDEX_APPROVAL_MENU);
    ASSERT(pPopup != NULL);
	if(pPopup==0) return false;

	AppendAddIn((CMenu*)pPopup);
	UpdateMenu((CMenu**)&pPopup, view_mode);
	
	CString val;
	m_doc->m_api.m_data.GetAttr(this->m_appr,m_doc->m_api.m_appr_mgr.a_appr_revocation_date_time,val);
	if(val!=_T(""))
		pPopup->EnableMenuItem(ID_APPROVAL_ANUL, MF_BYCOMMAND|MF_GRAYED);
	if(m_appr->GetAccessmode()>=aplRO)
	{
		pPopup->EnableMenuItem(ID_APPROVAL_ANUL, MF_BYCOMMAND|MF_GRAYED);
		pPopup->EnableMenuItem(ID_DELETE, MF_BYCOMMAND|MF_GRAYED);
	}
	
	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
		TPM_RIGHTBUTTON|TPM_RETURNCMD,point.x, point.y,wnd);
	//if(res==ID_SHOW_PROPERTIES) ShowProperties();
	//else 
	if(res==ID_DELETE)
	{
		/*if(m_appr->GetAccessmode()>aplOWN)
		{
			AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP);return true;
		}*/
		//   
		if(!m_doc->m_bIsAdmin) //   
		{
			bool bAllowDelStatus=false;
		
			CString sRoleName;
			m_doc->m_api.m_options_mgr.GetOptionValueBN( APL_NO_T("\\    "), sRoleName, _T(""));
			if(sRoleName!=_T(""))
			{
				if(m_doc->m_api.m_appr_mgr.CheckPersonRole(0,sRoleName)) bAllowDelStatus=true;
			}

			if(!bAllowDelStatus)
			{
				int AllowDeleteStatus=0;
				m_doc->m_api.m_options_mgr.GetOptionValueBN( APL_NO_T("\\    ,   "),AllowDeleteStatus,0);

				if(1!=AllowDeleteStatus)
				{
					AfxMessageBox( APL_T("     !"),MB_OK|MB_ICONSTOP);
					return false;
				}

				CaplInstance *po=0,*pers=0,*user=0,*pers_cur=0,*item=0;
				m_doc_data.GetAttr(m_appr,m_doc->m_api.m_appr_mgr.a_appr_pers_org,po);
				if(po!=0)
				{
					if(m_doc->m_api.m_data.IsKindOf(po, m_doc->m_api.m_appr_mgr.e_pers_org))
						m_doc_data.GetAttrBN(po,_T("the_person"),pers);
					else if(m_doc->m_api.m_data.IsKindOf(po, m_doc->m_api.m_appr_mgr.e_person))
						pers= po;
				}

				pers_cur= m_doc->m_api.m_appr_mgr.GetCurrentPerson();

				if(pers_cur!=pers)
				{
					AfxMessageBox(APL_T("     !"),MB_OK|MB_ICONSTOP);
					return false;
				}

				m_doc_data.GetAttr(m_appr,m_doc->m_api.m_appr_mgr.a_appr_item,item);
				aplExtent ext_appr;
				m_doc->m_api.m_appr_mgr.LoadItemApproval(item,ext_appr,true);
				if(ext_appr.GetSize()>1)
				{
					AfxMessageBox(APL_T("     !"),MB_OK|MB_ICONSTOP);
					return false;
				}
			}
		}

		if(AfxMessageBox( APL_T("      ?"),MB_YESNO)==IDYES)
		{
			if(m_appr!=0)
			{
				if(m_doc->m_api.m_appr_mgr.DeleteApproval(m_appr))
				{
					for(int i=0;i<m_doc->m_items.Size;i++)
					{
						if(m_doc->m_items[i]!=this)
						{
							if(m_doc->m_items[i]->m_type==m_type)
							{
								CaplApprovalTreeItem *item1=
									(CaplApprovalTreeItem*)m_doc->m_items[i];
								{
									if(item1->m_appr==m_appr)
									{m_doc->m_items.Remove(i); i--;}
								}
							}
						}
					}
					m_doc->m_items.Remove(m_doc->m_items.Find(this));
				}
			}
		}
	}
	else if(res==ID_APPROVAL_ANUL)
	{
		//   
		if(!m_doc->m_bIsAdmin) //   
		{
			CaplInstance *po=0,*pers=0,*user=0,*pers_cur=0;

			m_doc_data.GetAttrBN(m_appr,_T("person_organization"),po);
			if(po!=0)
			{
				if(m_doc->m_api.m_data.IsKindOf(po, m_doc->m_api.m_appr_mgr.e_pers_org))
					m_doc_data.GetAttrBN(po,_T("the_person"),pers);
				else if(m_doc->m_api.m_data.IsKindOf(po, m_doc->m_api.m_appr_mgr.e_person))
					pers= po;
			}

			pers_cur= m_doc->m_api.m_appr_mgr.GetCurrentPerson();

			if(pers_cur!=pers)
			{
				AfxMessageBox( APL_T("     !"),MB_OK|MB_ICONSTOP);
				return false;
			}
		}		
		
		CaplInstance *inst, *inst1;
		m_doc->m_api.m_data.GetAttrBN(m_appr,_T("person_organization"),inst);
		inst1=m_doc->m_api.m_appr_mgr.GetCurrentPerson();
		COleDateTime time = COleDateTime::GetCurrentTime();
		m_doc->m_api.m_data.NET_GetServerDateTime(time);
		aplDate2String(time,val);
		m_doc->m_api.m_data.PutAttr(this->m_appr,m_doc->m_api.m_appr_mgr.a_appr_revocation_date_time,val);
		font_style|=APL_FONT_STRIKEOUT;
		color = RGB(128,128,128);

		if(m_doc->m_api.m_options_mgr.CheckInstallCode(_T("grpz")))
		{
			CaplInstance *item=0;
			m_doc_data.GetAttr(m_appr,m_doc->m_api.m_appr_mgr.a_appr_item,item);
			if(m_doc_data.IsKindOf(item,m_doc->m_api.m_change_mgr.e_chng))
			{
				CString sRoleName,sStatusName;
				m_doc_data.GetAttr(m_appr,m_doc->m_api.m_appr_mgr.a_appr_role,sRoleName);
				sRoleName.MakeLower();
				if(sRoleName.Find(_T("103")))
				{
					CaplInstance *iStatus;
					m_doc_data.GetAttr(m_appr,m_doc->m_api.m_appr_mgr.a_appr_status,iStatus);
					m_doc_data.GetAttr(iStatus,m_doc->m_api.m_appr_mgr.a_appr_status_name,sStatusName);
					sStatusName.MakeLower();
					if(sStatusName==APL_T(""))	m_doc_data.PutAttr(item, m_doc->m_api.m_change_mgr.a_chng_complect_num, _T(""));
				}
			}
		}
		m_doc->m_api.m_data.NET_SaveChanges();
	}
	else PrepareContextMenu(res); 

	return true;
}
//****************************************************************
bool CaplApprovalTreeItem::GetName(CString &name)
{
	name=_T("Approval");
	_APL_TREE_ITEM_CHEK_PARAM_BOOL

	return m_doc->m_api.GetItemName(m_appr,name);
}

void CaplApprovalTreeItem::GetAccessedInstances(aplExtent &ext)
{
	ext.Clear();
	if(m_appr!=0){if(m_appr->GetType()!=0)ext.Add(m_appr);}
}

//****************************************************************
bool CaplApprovalTreeItem::ShowInListCtrl(CListCtrl *list)
{
	if(m_doc==0) return false;
	if(m_doc->m_BShowInListCtrl==false) return true;
	
	CHECK_SHOW_LIST_CTRL(m_appr);
	//if(m_appr==0) return false;

	CaplInstance *inst;
	CString buf;
	int i;
	m_doc_data.GetAttr(m_appr,m_doc->m_api.m_appr_mgr.a_appr_status,inst);
		if(inst!=0) m_doc_data.GetAttr(inst,m_doc->m_api.m_appr_mgr.a_appr_status_name,buf);

	i=list->InsertItem(list->GetItemCount(), APL_T(":"));
	list->SetItemText(i,1,buf);


	m_doc_data.GetAttr(m_appr,m_doc->m_api.m_appr_mgr.a_appr_role,buf);
	i=list->InsertItem(list->GetItemCount(), APL_T(":"));
	list->SetItemText(i,1,buf);

	m_doc_data.GetAttr(m_appr,m_doc->m_api.m_appr_mgr.a_appr_notes,buf);
	i=list->InsertItem(list->GetItemCount(), APL_T(":"));
	list->SetItemText(i,1,buf);

	m_doc_data.GetAttr(m_appr,m_doc->m_api.m_appr_mgr.a_appr_pers_org, inst);
	if(inst)
	{
		if(m_doc->m_api.m_data.IsKindOf(inst, m_doc->m_api.m_appr_mgr.e_pers_org))
			m_doc_data.GetAttr(inst, m_doc->m_api.m_appr_mgr.a_po_the_pers, inst);
	}

	buf=_T("");
	if(inst!=0)
	{
		m_doc->m_api.m_appr_mgr.GetPersonName(inst, buf, false);

		CString sTmp,sBuf1;
		m_doc->m_api.m_data.GetAttr(inst,m_doc->m_api.m_appr_mgr.a_pers_phone,sTmp);
		if(sTmp!=_T("")){ sBuf1+=APL_T(" : "); sBuf1+=sTmp; sBuf1+=_T(" ");	}

		m_doc->m_api.m_data.GetAttr(inst,m_doc->m_api.m_appr_mgr.a_pers_e_mail,sTmp);
		if(sTmp!=_T("")){ sBuf1+=APL_T(" e-mail: "); sBuf1+=sTmp; sBuf1+=_T(" ");	}

		m_doc->m_api.m_data.GetAttr(inst,m_doc->m_api.m_appr_mgr.a_pers_actual_address,sTmp);
		if(sTmp!=_T("")){ sBuf1+=APL_T(" : "); sBuf1+=sTmp; sBuf1+=_T(" ");	}

		if(sBuf1!=_T("")) {buf+=_T(" ("); buf+=sBuf1; buf+=_T(" )");}

	}
	i=list->InsertItem(list->GetItemCount(), APL_T(":"));
	list->SetItemText(i,1,buf);

	i=list->InsertItem(list->GetItemCount(),_T(""));
	CString  s_dt;
	COleDateTime odt;
	i=list->InsertItem(list->GetItemCount(), APL_T(" :"));
	m_doc_data.GetAttr(m_appr,m_doc->m_api.m_appr_mgr.a_appr_appr_date_time_s,s_dt);
	if(aplString2Date(s_dt,odt))
		buf=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
	else buf=_T("");
		list->SetItemText(i,1,buf);
	i=list->InsertItem(list->GetItemCount(), APL_T(" :"));
	m_doc_data.GetAttrBN(m_appr,_T("revocation_date_time"),s_dt);
	if(aplString2Date(s_dt,odt))
		buf=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
	else buf=_T("");
		list->SetItemText(i,1,buf);

	i=list->InsertItem(list->GetItemCount(),_T(""));
	i=list->InsertItem(list->GetItemCount(), APL_T(":"));
	GetAccessName(m_appr,buf);
	list->SetItemText(i,1,buf);

	aplExtent ext;
	CStringArray comment;
	if(m_appr!=0){ comment.Add( APL_T("")); ext.Add(m_appr);}
	ShowInstanceInfoInListCtrl(ext,list,&comment);

	return true;
}
//****************************************************************
bool CaplApprovalTreeItem::CreateTreeItem(HTREEITEM parent_item)
{
//	_APL_TREE_ITEM_CHEK_PARAM
	CString buf;
	GetName(buf);
	int ico = ICON_PART;
	InsetItem(buf,ICON_PART,parent_item);
	SetItemImage(ico, IDX_IL_TREE_ITEM);
	
	RefreshItem();
	//m_fictive_item=m_tree->InsertItem(_T("fictive"),0,0,m_item);
	return true;
}

//****************************************************************
bool CaplApprovalTreeItem::RefreshItem()
{
	UINT ico=m_doc->m_api.GetInstIco(m_appr);
	if(m_tree!=0)
	{
		CString name,buf,buf1;
		GetName(name);

		CString sRevocDate;
		m_doc->m_api.m_data.GetAttr(this->m_appr,m_doc->m_api.m_appr_mgr.a_appr_revocation_date_time,sRevocDate);
		if(sRevocDate!=_T(""))  { color = RGB(128,128,128); font_style|=APL_FONT_STRIKEOUT;}
		else { color = RGB(0,0,0); font_style&=~APL_FONT_STRIKEOUT;}

		SetItemImage(ico, IDX_IL_TREE_ITEM);
		m_tree->SetItemText(m_item,name);
		
		Sort();
		m_tree->RedrawWindow();
	}
	if(m_doc->m_tab_view->m_item_old==this)m_doc->ChangeItem(this);
	return true;
}
//****************************************************************
void CaplApprovalTreeItem::ShowProperties()
{
	if(m_doc==0) return;
	if(m_doc->m_api.m_appr_mgr.ShowApproval(m_appr)) RefreshItem();
}

BOOL CaplApprovalTreeItem::ShowToolBarButton(CCmdUI *pCmdUI)
{
	switch(pCmdUI->m_nID)
	{
		case ID_SHOW_NOTES:
		case ID_CREATE_NOTE:
			pCmdUI->Enable(TRUE); return TRUE; break;
	}
	return FALSE;
}

//****************************************************************
void CaplApprovalTreeItem::ShowCmd(long cmd)
{
/*	switch (cmd)
	{
		default: PrepareContextMenu(cmd);break;
	}*/
	PrepareContextMenu(cmd);
}