// apl_prd_inst_item.cpp


#include "stdafx.h"
#include "PSMDoc.h"
#include "resource.h"
#include "aplTreeApprovalItem.h"
#include "apl_prd_inst_item.h"
#include "TreeProductItem.h"
#include "apl_lot_item.h"
#include "aplTreeCharacteristicItem.h"
#include "aplCharacteristicGroupTreeItem.h"
#include "aplDocTreeItem.h"
#include "aplTopLevelItem.h"
#include "aplBPTreeItem.h"
#include "aplBPInstTreeItem.h"
#include "aplProjectTreeItem.h"
#include "TabView.h"
#include "aplOrganizationTreeItem.h"
#include "CaplRefusalTreeItem.h"

//****************************************************************
//****************************************************************
//****************************************************************

CaplPrdInstTreeItem::CaplPrdInstTreeItem(CTreeCtrl *tree, CPSMDoc *doc,
		CaplInstance *inst)
{
	m_type=APL_TREE_ITEM_PRDINST;
	m_tree=tree;
	m_doc=doc;
	m_inst=inst;
	m_folder=0;
	m_classifier=0;
	m_lot=0;
	m_prd_inst_rel=0;
	m_used_inst_rel=0;
	m_project=0;
	if(doc!=0) doc->m_items.Add(this);
}
//****************************************************************
bool CaplPrdInstTreeItem::CreateTreeItem(HTREEITEM parent_item)
{
//	_APL_TREE_ITEM_CHEK_PARAM
	CString buf;
	GetName(buf);
	InsetItem(buf,ICON_PRD_INST,parent_item);
	RefreshItem();
	m_fictive_item=m_tree->InsertItem(_T("fictive"),0,0,m_item);
	return true;
}
//****************************************************************
bool CaplPrdInstTreeItem::GetName(CString &name)
{
	name=_T("?");
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	
	CString buf;
	if(m_doc!=0)
	{
		if(m_inst!=0)
		{
/*
			m_doc_data.GetAttr(m_inst,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_id,name);
			CaplInstance *pdf;
			m_doc_data.GetAttr(m_inst,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_pdf,pdf);
			if(pdf!=0)
			{
				m_doc->m_api.m_prd_inst_mgr.GetItemName(pdf,buf);
				if(buf!=_T(""))	{ name+=_T(" {"); name+=buf; name+=_T("}");}
			}
*/
			if(!m_doc->m_api.GetItemName(m_inst, name)){
				return false;
			}
		}
		if(m_prd_inst_rel!=0)
		{
			if(m_prd_inst_rel->GetType()==0)return true;
			m_doc_data.GetAttr(m_prd_inst_rel,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_date_installed,buf);
			if(buf!=_T(""))
			{
				name+=_T(" (");
				COleDateTime odt;
				aplString2Date(buf,odt);
				buf=odt.Format(_T("%d.%m.%Y"));
				name+=buf;
				
				m_doc_data.GetAttr(m_prd_inst_rel,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_date_removed,buf);
				if(buf!=_T(""))
				{
					aplString2Date(buf,odt);
					buf=odt.Format(_T(" - %d.%m.%Y"));
					name+=buf;
				}
				name+=_T(")");
			}
			aplExtent rel_contexts;
			m_doc_data.GetAttr(m_prd_inst_rel,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_frames_of_reference,rel_contexts);
			m_doc->m_api.m_prd_inst_mgr.PrintItemContextInString(rel_contexts,buf);
			if(buf!=_T(""))	{ name+=_T(" ["); name+=buf; name+=_T("]");}
		}

	}
	return true;
}
//****************************************************************
bool CaplPrdInstTreeItem::RefreshItem()
{
	CString buf;
	int ico=ICON_PRD_INST;

	if(m_prd_inst_rel!=0)
	{
		m_doc_data.GetAttr(m_prd_inst_rel,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_date_removed,buf);
		if(buf!=_T(""))
		{
			SetItemImage(ICO_EFF_NOT_USED, IDX_IL_TREE_EFF);
			color=RGB(128,128,128);
			font_style|=APL_FONT_STRIKEOUT;
		}
	}
	else if(m_used_inst_rel!=0)
	{
		SetItemImage(ICO_REL_WHERE_USED, IDX_IL_TREE_REL_TYPE);
		m_doc_data.GetAttr(m_used_inst_rel,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_date_removed,buf);
		if(buf!=_T(""))
			SetItemImage(ICO_EFF_NOT_USED, IDX_IL_TREE_EFF);
	}
	SetItemImage(ico, IDX_IL_TREE_ITEM);

	if(m_bWOForNote)
		SetItemImage(ICO_REL_WO_4NOTE, IDX_IL_TREE_REL_TYPE);

	GetName(buf);
	if(m_tree!=0) m_tree->SetItemText(m_item,buf);
	if(m_doc->m_tab_view->m_item_old==this) m_doc->ChangeItem(this);
	return true;
}

//****************************************************************
void CaplPrdInstTreeItem::ShowProperties()
{
	if(m_doc==0) return;
	if(m_inst==0) return;
	if(m_doc->m_api.m_prd_inst_mgr.ShowPrdInstProperties(m_inst,m_prd_inst_rel))RefreshItem();

}
//****************************************************************
bool CaplPrdInstTreeItem::Expand(UINT action)
{
	// action = 2 ->  
	// action = 1 -> 
	//_APL_TREE_ITEM_CHEK_PARAM

	if(action==2)
	{
		if(m_expanded) return true;
		m_tree->SetRedraw(FALSE);
		if(m_hasSubItem)Expand(1);
		if(m_fictive_item!=0)
		{
			m_tree->DeleteItem(m_fictive_item);
			m_fictive_item=0;
		}
		if(m_hasSubItem)Expand(1);

		if(m_ShowContentsOnExpand)
		{
			int show_history;
			m_doc->m_api.m_options_mgr.GetOptionValueBN( APL_NO_T("   "),show_history,1);
			CaplInstance *inst;
			aplExtent ext,ext_rel;
			m_doc->m_api.m_prd_inst_mgr.LoadInsertedInstances(m_inst,ext_rel,ext);
			CString date_removed;
			for(int i=0;i<ext_rel.Size;i++)
			{
				if(m_all_prd_instances.Find(ext_rel[i])>=0) continue ;

				if(!show_history)
				{
					m_doc_data.GetAttr(ext_rel[i],m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_date_removed,date_removed);
					if(date_removed!=_T("")) continue;
				}
				
				m_doc_data.GetAttr(ext_rel[i],m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_related,inst);

				if(m_doc_data.IsKindOf(inst,m_doc->m_api.m_prd_inst_mgr.e_prd_inst))
				{
					CaplPrdInstTreeItem *inst_item= new CaplPrdInstTreeItem(m_tree,m_doc,inst);
					inst_item->m_prd_inst_rel=ext_rel[i];
					inst_item->CreateTreeItem(m_item);
					m_all_prd_instances.Add(ext_rel[i]);
					inst_item->RefreshItem();
				}
				else if(m_doc_data.IsKindOf(inst,m_doc->m_api.m_prd_inst_mgr.e_lot))
				{
					CaplLotTreeItem *inst_item= new CaplLotTreeItem(m_tree,m_doc,inst);
					inst_item->m_prd_inst_rel=ext_rel[i];
					inst_item->CreateTreeItem(m_item);
					m_all_prd_instances.Add(ext_rel[i]);
					inst_item->RefreshItem();
				}
				else if(m_doc_data.IsKindOf(inst,m_doc->m_api.m_doc_mgr.e_apl_doc_rev))
				{
					m_doc->m_api.m_doc_mgr.LoadDocInfo(inst);
					CaplInstance* doc= NULL;
					m_doc->m_api.m_data.GetAttr(inst, m_doc->m_api.m_doc_mgr.a_apl_doc_rev_doc, doc);
					CaplDocTreeItem *inst_item= new CaplDocTreeItem(m_tree, m_doc,  doc, ext_rel[i], inst);
					inst_item->m_project= NULL;
					inst_item->CreateTreeItem(m_item);
					m_all_prd_instances.Add(ext_rel[i]);
					inst_item->RefreshItem();
				}
			}
		}
		if(m_doc->m_auto_expand_items.m_showintree_prdinst&APL_SHOW_DOC)
			ShowAllDocs(false,false);
		if(m_doc->m_auto_expand_items.m_showintree_prdinst&APL_SHOW_CHARACT)
			ShowAllCharacteristic(false);
		if(m_doc->m_auto_expand_items.m_showintree_prdinst&APL_SHOW_APPROVAL)
			ShowAllApproval(false);
		if(m_doc->m_auto_expand_items.m_showintree_prdinst&APL_SHOW_BP)
			ShowAllBPs(false);
		if(m_doc->m_auto_expand_items.m_showintree_prdinst&APL_SHOW_BPINST)
			ShowAllBPInst(false);
		if(m_doc->m_auto_expand_items.m_showintree_prdinst&APL_SHOW_REFUSAL)
			ShowAllResusal(false,false);

		Sort();
		m_tree->SetRedraw(TRUE);
		m_expanded=true;
	}
	else if(action==1)
	{
		CollapseItem();
		m_all_prd_instances.Clear();
		m_all_parent.Clear();
		m_all_parent_bps.Clear();
	}
	return true;
}
//****************************************************************
bool CaplPrdInstTreeItem::TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode)
{
	if(m_inst==0) return false;
	if(m_doc==0) return false;
	CMenu menu;  gSetPsmResourceHandle();
	VERIFY(menu.LoadMenu(IDR_TREE_CONTEXT_MENU));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(wnd); // 	VERIFY(CaplMenu::Install(wnd, ePopupMenu ));
    CMenu* pPopup = menu.GetSubMenu(INDEX_PRD_INST_MENU);
    ASSERT(pPopup != NULL);
	if(pPopup==0) return false;
	
	AppendAddIn((CMenu*)pPopup);
	UpdateMenu((CMenu**)&pPopup, view_mode);

	if(m_folder==0)pPopup->EnableMenuItem(ID_REMOVE_FROM_FOLDER, MF_BYCOMMAND | MF_GRAYED);
	if(m_classifier==0){pPopup->EnableMenuItem(ID_REMOVE_FROM_CLASSIFIER, MF_BYCOMMAND | MF_GRAYED);}
	CaplInstance *pdf;
	m_doc_data.GetAttr(m_inst,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_pdf,pdf);
	if(pdf==0)
		pPopup->EnableMenuItem(ID_SHOW_BASE_PDF, MF_BYCOMMAND | MF_GRAYED);
	if(m_lot==0) pPopup->EnableMenuItem(ID_REMOVE_FROM_LOT, MF_BYCOMMAND | MF_GRAYED);

	if(m_prd_inst_rel==0 && m_project==0) pPopup->EnableMenuItem(ID_PRODUCT_REMOVE_RELATION, MF_BYCOMMAND | MF_GRAYED);

	bool hide=true;
	HTREEITEM hitem=m_tree->GetParentItem(m_item);
	CaplTreeItem *treeitem=(CaplTreeItem *)m_tree->GetItemData(hitem);
	if(treeitem!=0)	{if(treeitem->m_type==APL_TREE_ITEM_CATEGORIES)hide=false;}
	if(hide) pPopup->EnableMenuItem(ID_PRODUCT_REMOVE_FROM_CAREGORY,MF_BYCOMMAND|MF_GRAYED);

	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|TPM_RIGHTBUTTON|TPM_RETURNCMD,point.x, point.y,wnd);

	switch(res)
	{
	case ID_SHOW_CONTAINED_PROJECTS:
		ShowContainedProjects(m_inst);
		break;
	case ID_SHOW_CONTAINED_PROCCESS:
		ShowContainedProccess(m_inst);
		break;
	case ID_SHOW_CONTAINED_FOLDER:
		ShowContainedFolder(m_inst);
		break;
	case ID_SHOW_CONTAINED_MESSAGE: ShowContainedMessage(m_inst); break;
	case ID_SHOW_CONTAINED_TASKS: ShowContainedTasks(m_inst); break;
	case ID_SHOW_CONTAINED_ALERT: ShowContainedAlert(m_inst); break;
	case ID_SHOW_CONTAINED_CLASSIFIER:
		ShowContainedClassifier(m_inst);
		break;
	case ID_REMOVE_FROM_FOLDER:
		if(m_folder!=0)
		{
			if(m_doc->m_api.m_folder_mgr.RemoveFromFolder(m_folder,m_inst))
				m_doc->m_items.Remove(m_doc->m_items.Find(this));
		}
		break;
	case ID_REMOVE_FROM_CLASSIFIER:
		if(m_classifier!=0)
		{
			if(m_classifier->GetAccessmode()>aplRW)	{AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return true;}
			if(m_doc->m_api.m_classifier_mgr.DeleteClassifierAssociation(m_inst,m_classifier))
				m_doc->m_items.Remove(m_doc->m_items.Find(this));
		}
		break;
	case ID_SHOW_BASE_PDF:
		if(m_inst!=0)
		{
			CaplInstance *pdf=0;
			m_doc_data.GetAttrBN(m_inst,S::formation,pdf);
			if(pdf!=0)
			{
				m_doc->m_api.m_prd_mgr.LoadPrdInfo(pdf);
				CaplProductTreeItem *product_item=
					new CaplProductTreeItem(m_tree,m_doc,0,pdf);
				product_item->LoadProperties();
				product_item->CreateTreeItem(m_item);
				MyExpand(false);
			}
		}
		break;
	case ID_CREATE_REFUSAL:
		CreateRefusal();
		break;
	case ID_SHOW_LOT4PI:
		if(m_inst!=0)
		{
			CaplInstance *lot=0;
			m_doc_data.GetAttr(m_inst,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_lot,lot);
			if(lot!=0)
			{
				if(m_all_prd_instances.Find(lot)>=0) AfxMessageBox(APL_T("  !"),MB_OK);
				else
				{
					m_doc->m_api.m_prd_mgr.LoadPrdInfo(lot);

					CaplLotTreeItem *inst_item= new CaplLotTreeItem(m_tree,m_doc,lot);
					inst_item->m_parent_prd_inst=m_inst;
					inst_item->CreateTreeItem(m_item);
					m_all_prd_instances.Add(lot);
					inst_item->RefreshItem();
					MyExpand(false);
					Sort();
				}
			}
		}
		break;

	case ID_DELETE:
		{
			if(m_inst->GetAccessmode()>aplOWN)
			{
				AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP);
				return true;
			}
			if(AfxMessageBox( APL_T("       ?"),MB_YESNO)==IDYES)
			{
				if(m_doc->m_api.m_prd_inst_mgr.DeletePrdInst(m_inst))
				{
					for(int i=0;i<m_doc->m_items.Size;i++)
					{
						if(m_doc->m_items[i]!=this)
						{
							if(m_doc->m_items[i]->m_type==m_type)
							{
								CaplPrdInstTreeItem *item1=
									(CaplPrdInstTreeItem*)m_doc->m_items[i];
								{
									if(item1->m_inst==m_inst)
									{m_doc->m_items.Remove(i); i--;}
								}
							}
						}
					}
					m_doc->m_items.Remove(m_doc->m_items.Find(this));
				}
			}
		}
		break;
	case ID_CREATE_BP: CreateBP(); break;
	case ID_CREATE_BP_INST: CreateBPInst(); break;
	case ID_SHOW_ALL_BP: ShowAllBPs(); break;
	case ID_SHOW_ALL_BP_INST: ShowAllBPInst(); break;
	case ID_SHOW_REFUSAL: ShowAllResusal(); 	break;
	case ID_SHOW_ALL_APPROVAL:ShowAllApproval(true); break;
	case ID_CREATE_CHARACTERISTIC: CreateCharacteristic(); break;
	case ID_CREATE_CHARACTERISTIC_GROUP: CreateCharacteristicGroup();break;
	case ID_REMOVE_FROM_LOT: 
		if(m_lot!=0)
		{
			if(m_inst->GetAccessmode()>aplRW)
			{
				AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP);
				return true;
			}
			m_doc_data.PutAttr(m_inst,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_lot,(CaplInstance*)0);
			m_doc_data.NET_SaveChanges();
			m_doc->m_items.Remove(m_doc->m_items.Find(this));
		}
		break;
	case ID_PRODUCT_REMOVE_FROM_CAREGORY: RemoveFromCategory();break;
	case ID_PRODUCT_REMOVE_RELATION:RemoveRelation();break;
	case ID_PRODUCT_WHERE_USED:
		{
			m_tree->SetRedraw(FALSE);
			if(m_fictive_item!=0)
			{
				m_tree->DeleteItem(m_fictive_item);
				m_fictive_item=0;
			}

			CaplInstance *inst;
			aplExtent ext,ext_rel;
			m_doc->m_api.m_prd_inst_mgr.WhereUsedPIinPI(m_inst,ext_rel,ext);
			int show_history;
			m_doc->m_api.m_options_mgr.GetOptionValueBN( APL_NO_T("   "),show_history,1);
			CString date_removed;
			for(int i=0;i<ext_rel.Size;i++)
			{
				//if(m_all_parent.Find(ext_rel[i])>=0) continue ;
				m_doc_data.GetAttr(ext_rel[i],m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_relating,inst);
				if(m_all_parent.Find(inst)>=0) continue ;
				if(!show_history)
				{
					m_doc_data.GetAttr(ext_rel[i],m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_date_removed,date_removed);
					if(date_removed!=_T("")) continue;
				}

				CaplTreeItem *new_tree_item=0;
				InsertInstInTree(inst,m_item,m_doc,m_tree,m_all_parent,0,&new_tree_item);
				if(0!=new_tree_item)
				{
					((CaplPrdInstTreeItem*)new_tree_item)->m_used_inst_rel=ext_rel[i];
					((CaplPrdInstTreeItem*)new_tree_item)->RefreshItem();
				}
//				if(m_doc_data.IsKindOf(inst,m_doc->m_api.m_prd_inst_mgr.e_prd_inst))
//				{
//					CaplPrdInstTreeItem *inst_item= new CaplPrdInstTreeItem(m_tree,m_doc,inst);
//					inst_item->m_used_inst_rel=ext_rel[i];
//					inst_item->CreateTreeItem(m_item);
//					//m_all_parent.Add(ext_rel[i]);
//					m_all_parent.Add(inst);
//					inst_item->RefreshItem();
//				}
//				else if(m_doc_data.IsKindOf(inst,m_doc->m_api.m_appr_mgr.e_org))
//				{
//					CaplOrganizationTreeItem *inst_item= new CaplOrganizationTreeItem(m_tree,m_doc,inst);
//					inst_item->m_used_inst_rel=ext_rel[i];
//					inst_item->CreateTreeItem(m_item);
//					//m_all_parent.Add(ext_rel[i]);
//					m_all_parent.Add(inst);
//					inst_item->RefreshItem();
//				}

			}
			//
			ShowAllProjects(m_inst,false);

			MyExpand(false);
			Sort();
			m_tree->SetRedraw(TRUE);
			m_expanded=true;
		}
		break;
	case ID_PRODUCT_WHERE_USED_AS_RES: ShowAllUsesBP();break;
	case ID_SHOW_PROJECTS: ShowAllProjects(m_inst); break;
	case ID_CREATE_PROJECT: CreateProject(); break;
	case ID_ASSOCIATE_BP_INST:
		{
			CaplInstance *i_act=((CaplBPInstTreeItem *)treeitem)->m_inst;

			CaplInstance *rel=m_doc->m_api.m_bp_mgr.CreateInstanceAssociation(m_inst,i_act);
			if(rel==0) return false;

			CaplBPInstTreeItem *new_item=0;
			InsertInstInTree(i_act,m_item,m_doc,m_tree,m_all_bp_inst,0,(CaplTreeItem **)(&new_item));
			if(new_item!=0)new_item->m_rel=rel;
			MyExpand();
			break;
		}
	case ID_BP_INST_COPY:
		{
			CaplInstance *i_act=((CaplBPInstTreeItem *)treeitem)->m_inst;
			if(i_act) CreateBPInstCopy(i_act);
		}	
	default: PrepareContextMenu(res); 
	}
	return true;
}
//****************************************************************
void CaplPrdInstTreeItem::GetAccessedInstances(aplExtent &ext)
{
	ext.Clear();
	if(m_inst!=0){if(m_inst->GetType()!=0)ext.Add(m_inst);}
	
}
//****************************************************************
bool CaplPrdInstTreeItem::ShowInListCtrl(CListCtrl *list)
{
	if(list==0) return false;
	CHECK_SHOW_LIST_CTRL(m_inst);
	if(m_doc==0)return false;

	CString buf,buf1,buf2;
	int i=list->InsertItem(0, APL_T(":"));
	m_doc_data.GetAttrBN(m_inst,S::id,buf);
	list->SetItemText(i,1,buf);

	i=list->InsertItem(1, APL_T(":"));
	m_doc_data.GetAttrBN(m_inst,S::description,buf);
	list->SetItemText(i,1,buf);

	i=list->InsertItem(2, APL_T(" :"));
	m_doc_data.GetAttr(m_inst,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_sn,buf);
	list->SetItemText(i,1,buf);

	CaplInstance *inst;
	m_doc_data.GetAttr(m_inst,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_lot,inst);
	if(inst!=0)
	{
		i=list->InsertItem(3, APL_T(":"));
		m_doc_data.GetAttrBN(inst,S::id,buf);
		list->SetItemText(i,1,buf);
	}

	m_doc_data.GetAttr(m_inst,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_state,buf);
	if(buf!=_T(""))
	{
		i=list->InsertItem(4, APL_T(":"));
		list->SetItemText(i,1,buf);
	}
	
	if(m_prd_inst_rel!=0)
	{
		i=list->InsertItem(5,_T(""));
		m_doc_data.GetAttr(m_prd_inst_rel,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_date_installed,buf);
		if(buf!=_T(""))
		{
			COleDateTime odt;
			aplString2Date(buf,odt);
			buf=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));

			i=list->InsertItem(6, APL_T(" :"));
			list->SetItemText(i,1,buf);
	
			m_doc_data.GetAttr(m_prd_inst_rel,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_date_removed,buf);
			if(buf!=_T(""))
			{
				aplString2Date(buf,odt);
				buf=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
				i=list->InsertItem(7, APL_T(" :"));
				list->SetItemText(i,1,buf);
			}
		}
	}

	list->InsertItem(8,_T(""));
	i=list->InsertItem(9, APL_T(":"));
	GetAccessName(m_inst,buf);
	list->SetItemText(i,1,buf);

	if(m_project)
	{
		CaplInstance *rel=m_doc->m_project_mgr->FindAssociation(m_project,m_inst);
		if(rel) 
		{
			CaplInstance *control_status=0;
			m_doc_data.GetAttr(rel,m_doc->m_project_mgr->a_project_ref_control_status,control_status);
			buf= APL_T(" ");
			if(control_status) buf= APL_T(" ");
			list->InsertItem(list->GetItemCount(),_T(""));
			i=list->InsertItem(list->GetItemCount(), APL_T(" :"));
			list->SetItemText(i,1,buf);
			if(control_status) 
			{
				i=list->InsertItem(list->GetItemCount(), APL_T(" :"));
				m_doc_data.GetAttr(control_status,m_doc->m_api.m_appr_mgr.a_appr_status_name,buf);
				list->SetItemText(i,1,buf);
			}
		}
	}
	
	aplExtent ext;
	CStringArray comment;
	if(m_inst!=0){ comment.Add( APL_T("")); ext.Add(m_inst);}
	if(m_lot!=0){ comment.Add( APL_T("")); ext.Add(m_lot);}
	if(m_prd_inst_rel!=0){ comment.Add(_T("m_prd_inst_rel")); ext.Add(m_prd_inst_rel);}
	if(m_classifier!=0){
		CaplInstance* classif_ref;
		m_doc->m_api.m_classifier_mgr.TestClassifierAssociation(m_lot,m_classifier,&classif_ref);
		if(classif_ref!=0){
			comment.Add(_T("classifier association"));
			ext.Add(classif_ref);
		}
		comment.Add(_T("m_classifier"));
		ext.Add(m_classifier);
	}
	ShowInstanceInfoInListCtrl(ext,list,&comment);

	return true;
}
//****************************************************************
void CaplPrdInstTreeItem::CreateCharacteristic(CaplInstance *val)
{
	CaplInstance *new_val=0;
	if(m_doc->m_api.m_charact_mgr.CreateCharacteristic(m_inst,val,&new_val,0,0,true))
	{
		/*
		if(CaplTreeItem::m_AutoUzurpireCharacteristic)
		{
			aplExtent ext; ext.Add(new_val);
			m_doc_data.NET_BecomeInstancesOwner(&ext);
		}*/

		CaplCharacteristicTreeItem *characteristic_item=
			new CaplCharacteristicTreeItem(m_tree,m_doc,new_val);
		characteristic_item->CreateTreeItem(m_item);
		m_all_caracteristic.Add(new_val);
		MyExpand();
		m_doc->ChangeItem(0);m_doc->ChangeItem(this);
	}
}
//****************************************************************
void CaplPrdInstTreeItem::ShowCmd(long cmd)
{
	switch (cmd)
	{
		case ID_CREATE_CHARACTERISTIC: CreateCharacteristic(); break;
		case ID_SHOW_ALL_BP: ShowAllBPs(); break;
		case ID_EXPAND_ALL: {int i=1; ExpandAll(i);} break;
		case ID_CREATE_BP: CreateBP();	break;
		case ID_CREATE_BP_INST: CreateBPInst();	break;
		case ID_SHOW_ALL_BP_INST: ShowAllBPInst();	break;
		default: PrepareContextMenu(cmd);break;
	}
}
BOOL CaplPrdInstTreeItem::ShowToolBarButton(CCmdUI* pCmdUI)
{
	if(pCmdUI->m_nID==ID_SET_INST_ACCSESS)
	{
		aplExtent instances;
		GetAccessedInstances(instances);
		if(instances.GetSize()>0)
		{
			if(instances[0]->GetAccessmode()==aplOWN) return TRUE;
		}
		return FALSE;
	}

	switch(pCmdUI->m_nID)
	{
	case ID_SHOW_ALL_DOCS:
	case ID_SHOW_ALL_CHARACTERISTIC:
	case ID_SHOW_ALL_APPROVAL:
//	case ID_PRODUCT_SHOW_ALL_ZAGOTOV:
//	case ID_SHOW_ALL_LOT:
//	case ID_SHOW_ALL_PRD_INST:
	case ID_CREATE_APPROVAL:
//	case ID_SHOW_ALL_VERSION:
//	case ID_CREATE_PRODUCT:
	case ID_CREATE_CHARACTERISTIC:
	case ID_CREATE_DOC:
	case ID_CREATE_BP:
	case ID_SHOW_ALL_BP:
	case ID_CREATE_BP_INST:
	case ID_SHOW_ALL_BP_INST:
	case ID_SHOW_NOTES:
	case ID_CREATE_NOTE:

		pCmdUI->Enable(TRUE); return TRUE; break;
	}
	return FALSE;
}
//****************************************************************
bool CaplPrdInstTreeItem::PasteItem(CaplTreeItem *item, CPoint *point)
{
	if(item==0) return false;
	if (item->m_type != APL_TREE_ITEM_DOCUMENT)
		if (item->m_type != APL_TREE_ITEM_CHARACTERISTIC)
			if (item->m_type != APL_TREE_ITEM_CHARACTERISTICGROUP)
				if (item->m_type != APL_TREE_ITEM_PRDINST)
					if (item->m_type != APL_TREE_ITEM_BP)
						if (item->m_type != APL_TREE_ITEM_LOT)
							if (item->m_type != APL_TREE_ITEM_BPINST)
								if(item->m_type!= APL_TREE_ITEM_PROJECT)
									return false;
	if(m_tree==0) return false;
	if(m_doc==0) return false;


	POINT pnt;
	if(point==0)
	{
		RECT rect;
		m_tree->GetItemRect(m_item,&rect,TRUE);
		m_tree->ClientToScreen(&rect);
		pnt.x=rect.right;
		pnt.y=rect.bottom;
	}
	else
	{
		pnt.x=point->x;
		pnt.y=point->y;
	}

	if (item->m_type == APL_TREE_ITEM_PRDINST)
	{
		CaplInstance *related=((CaplPrdInstTreeItem *)item)->m_inst;

		if(related==m_inst)
		{
			AfxMessageBox( APL_T("      \n")
				,MB_OK|MB_ICONSTOP);
			return true;
		}
		CaplInstance *my_pdf, *related_pdf;
		m_doc_data.GetAttr(related, m_doc->m_api.m_prd_inst_mgr.a_prd_inst_pdf,related_pdf);
		m_doc_data.GetAttr(m_inst, m_doc->m_api.m_prd_inst_mgr.a_prd_inst_pdf,my_pdf);
		
		CMenu menu;  gSetPsmResourceHandle();
		CMenu *pPopup;
		VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
// 		VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
		CaplMenu::Install(m_tree); // 		VERIFY(CaplMenu::Install(m_tree, ePopupMenu ));
		pPopup = menu.GetSubMenu(INDEX_PASTE_PRD_INST_MENU);

		if(related_pdf==my_pdf) pPopup->EnableMenuItem(ID_PRDINST_INSERT,MF_BYCOMMAND|MF_GRAYED);
		if(m_prd_inst_rel==0) pPopup->EnableMenuItem(ID_PRDINST_CHANGE,MF_BYCOMMAND|MF_GRAYED);
		
		BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
			TPM_RIGHTBUTTON|TPM_RETURNCMD,pnt.x,pnt.y,m_tree);

		if (res == ID_PRDINST_INSERT)
		{
			if(related_pdf==my_pdf)
			{
				AfxMessageBox( APL_T("    \n -  "),MB_OK|MB_ICONSTOP);
				return true;
			}		
			
			CaplInstance* comp=m_doc->m_api.m_prd_inst_mgr.InsertInPI(m_inst,related);
			if(comp==0) return true;;
					
			CaplPrdInstTreeItem *inst_item= new CaplPrdInstTreeItem(m_tree,m_doc,related);
			inst_item->m_prd_inst_rel=comp;
			inst_item->CreateTreeItem(m_item);
			m_all_prd_instances.Add(comp);
			inst_item->RefreshItem();
			Sort();
			return true;
		}
		else if (res == ID_PRDINST_CHANGE)
		{
			CaplInstance* chng=m_doc->m_api.m_prd_inst_mgr.ChangePIinPI(m_prd_inst_rel,related);
			if(chng!=0)
			{
				m_doc->RefreshAllItemsByType(m_type);

				CaplInstance *comp;
				m_doc_data.GetAttr(m_inst, m_doc->m_api.m_prd_inst_mgr.a_pi_subst_successor,comp);

				CaplPrdInstTreeItem *inst_item= new CaplPrdInstTreeItem(m_tree,m_doc,related);
				inst_item->m_prd_inst_rel=comp;
				inst_item->CreateTreeItem(m_tree->GetParentItem(m_item));
				m_all_prd_instances.Add(comp);
				inst_item->RefreshItem();
			}
		}
		return true;
	}
	if(item->m_type == APL_TREE_ITEM_LOT)
	{
		CaplInstance *related=((CaplLotTreeItem *)item)->m_lot;
		if(related==0) return false;
		CaplInstance *my_pdf, *lot_pdf;
		m_doc_data.GetAttr(related, m_doc->m_api.m_prd_inst_mgr.a_lot_pdf,lot_pdf);
		if(lot_pdf==0)
		{
			AfxMessageBox( APL_T("    \n     "),MB_OK|MB_ICONSTOP);
			return true;
		}
		m_doc_data.GetAttr(m_inst, m_doc->m_api.m_prd_inst_mgr.a_lot_pdf,my_pdf);
		if(lot_pdf==my_pdf)
		{
			AfxMessageBox( APL_T("    \n   -  "),MB_OK|MB_ICONSTOP);
			return true;
		}

		CaplInstance* comp=m_doc->m_api.m_prd_inst_mgr.InsertInPI(m_inst,related);
		if(comp==0) return true;;
				
		CaplLotTreeItem *inst_item= new CaplLotTreeItem(m_tree,m_doc,related);
		inst_item->m_prd_inst_rel=comp;
		inst_item->CreateTreeItem(m_item);
		m_all_prd_instances.Add(comp);
		inst_item->RefreshItem();
		
		Sort();
		return true;
	}
	else if(item->m_type == APL_TREE_ITEM_PROJECT)
	{
		CaplInstance *rel=0;
		CaplInstance *project=((CaplProjectTreeItem*)item)->m_inst;
		rel=m_doc->m_project_mgr->CreateAssociation(project,m_inst);
		if(rel)
		{
			CaplProjectTreeItem *new_item=0;
			InsertInstInTree(project,m_item,m_doc,m_tree,m_all_projects,0,(CaplTreeItem **)(&new_item));
			if(new_item!=0) new_item->m_rel=m_inst;
			MyExpand(false);
			return true;
		}
	}

	CMenu menu;  gSetPsmResourceHandle();
	CMenu *pPopup=0;
	VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(m_tree); // 	VERIFY(CaplMenu::Install(m_tree, ePopupMenu ));

	//if(item->m_type == APL_TREE_ITEM_PRODUCT)
	//	pPopup = menu.GetSubMenu(INDEX_PRODUCT_MENU);
	//else
	if(item->m_type == APL_TREE_ITEM_DOCUMENT)
	{
		aplExtent ext;
		item->GetAccessedInstances(ext);
		
		CString state;
		if(m_doc_data.IsKindOf(ext[0],m_doc->m_api.m_doc_mgr.e_apl_doc))
		{
			m_doc_data.GetAttr(ext[0],m_doc->m_api.m_doc_mgr.a_apl_doc_wf_state,state);
			if(state==_T("canceled")) return false;
			pPopup = menu.GetSubMenu(INDEX_DOCUMENT_MENU);
		}
		else if(m_doc_data.IsKindOf(ext[0],m_doc->m_api.m_doc_mgr.e_apl_doc_rev))
		{
			pPopup= menu.GetSubMenu(INDEX_PROJECT_PASTE_MENU+1);			
			pPopup->RemoveMenu(ID_DOCUMENT_REV_REPLACE, MF_BYCOMMAND);
		}
	}
	else if(item->m_type == APL_TREE_ITEM_CHARACTERISTIC)
		pPopup = menu.GetSubMenu(INDEX_CHARACTERISTIC_MENU);
	else if(item->m_type == APL_TREE_ITEM_CHARACTERISTICGROUP)
		pPopup = menu.GetSubMenu(INDEX_CHARACTERISTIC_MENU);
	else if (item->m_type == APL_TREE_ITEM_BP)
		pPopup = menu.GetSubMenu(INDEX_BP_MENU);
	else if (item->m_type == APL_TREE_ITEM_BPINST)
		pPopup = menu.GetSubMenu(INDEX_BP_INST_PASTE_MENU);

	if(pPopup!=0)
	{

		HTREEITEM parent = m_tree->GetNextItem(item->m_item,TVGN_PARENT);
		CaplTreeItem *parent_item = (CaplTreeItem*)m_tree->GetItemData(parent);
		if(parent_item && parent_item->m_type==APL_TREE_ITEM_QUERY)
		{
			pPopup->EnableMenuItem(ID_DOCUMENT_MOVE, MF_BYCOMMAND|MF_GRAYED);
		}

		BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
			TPM_RIGHTBUTTON|TPM_RETURNCMD,pnt.x,pnt.y,m_tree);

		//  
		if (res == ID_DOCUMENT_COPY)
		{
			CaplInstance *inst;
			CaplInstance *i_doc=((CaplDocTreeItem *)item)->m_inst;
			inst=m_inst;
			
			HTREEITEM ht = m_tree->GetNextItem(item->m_item,TVGN_PARENT);
			CaplTreeItem *Item = (CaplTreeItem*)m_tree->GetItemData(ht);
			aplAccessModeType access =aplOWN;
			if(Item)
			{
				aplExtent instances;
				Item->GetAccessedInstances(instances);
				access = instances.GetAt(0)->GetAccessmode();
			}
			
			if(m_inst->GetAccessmode()>aplRW || access>aplRO)
			{
				AfxMessageBox( APL_T("   "));
				return false;
			}

			if(CaplDocTreeItem::InsertDoc(m_doc,this,&m_all_documents,i_doc,inst, false))
				ShowCmd(ID_SHOW_ALL_DOCS);
		}
		//  
		else if(res == ID_DOCUMENT_BYDOT)
		{
			CaplInstance *inst;
			CaplInstance *i_doc = ((CaplDocTreeItem *)item)->m_inst;
			inst = m_inst;

			aplExtent instances;
			GetAccessedInstances(instances);
			if(m_doc->m_api.m_doc_mgr.CreateDocumentByDot(i_doc,instances[0]))
				ShowCmd(ID_SHOW_ALL_DOCS);
		}
		// 
		else if(res == ID_DOCUMENT_MOVE)
		{
			CaplDocTreeItem *d_item = (CaplDocTreeItem*)item;
			HTREEITEM parent = m_tree->GetNextItem(d_item->m_item,TVGN_PARENT);
			CaplTreeItem *parent_item = (CaplTreeItem*)m_tree->GetItemData(parent);
			
			CaplDocTreeItem::MoveDocument(m_doc, d_item, parent_item, this);
		}
		//  
		else if (res == ID_CHARACTERISTIC_COPY)
		{
			if(item->m_type == APL_TREE_ITEM_CHARACTERISTIC)
			{
				CaplInstance *i_val=((CaplCharacteristicTreeItem *)item)->m_val;
				CreateCharacteristic(i_val);
			}
			else if(item->m_type == APL_TREE_ITEM_CHARACTERISTICGROUP)
			{
				CreateCharacteristicGroup(((CaplCharacteristicGroupTreeItem*)item)->m_group);
			}
		}
		else if(res== ID_ASSOCIATE_BP)
		{
			CaplInstance *i_act=((CaplBPTreeItem *)item)->m_inst;

			CaplInstance *rel=m_doc->m_api.m_bp_mgr.CreateAssociation(m_inst,i_act);
			if(rel==0) return false;

			CaplBPTreeItem *new_item=0;
			InsertInstInTree(i_act,m_item,m_doc,m_tree,m_all_bp,0,(CaplTreeItem **)(&new_item));
			if(new_item!=0)new_item->m_rel=rel;
			MyExpand();
			return true;
		}
		else if(res== ID_BP_COPY)
		{
			CaplInstance *i_act=((CaplBPTreeItem *)item)->m_inst;
			if(i_act) CreateBPCopy(i_act);
		}
		else if(res== ID_ASSOCIATE_BP_INST)
		{
			CaplInstance *i_act=((CaplBPInstTreeItem *)item)->m_inst;

			CaplInstance *rel=m_doc->m_api.m_bp_mgr.CreateInstanceAssociation(m_inst,i_act);
			if(rel==0) return false;

			CaplBPInstTreeItem *new_item=0;
			InsertInstInTree(i_act,m_item,m_doc,m_tree,m_all_bp_inst,0,(CaplTreeItem **)(&new_item));
			if(new_item!=0)new_item->m_rel=rel;
			MyExpand();
			return true;
		}
		else if(res== ID_BP_INST_COPY)
		{
			CaplInstance *i_act=((CaplBPInstTreeItem *)item)->m_inst;
			if(i_act) CreateBPInstCopy(i_act);
		}
		else if(res==ID_DOCUMENT_REV_PAST)
		{
			aplExtent rels, ext;
			
			m_doc->m_api.m_prd_inst_mgr.LoadInsertedInstances(m_inst, rels, ext);
			
			CaplInstance* docInst= NULL, *docRevInst= NULL;

			bool bCanInstall= true;
			CString sDateRem;
			for(int i= 0; i<rels.GetSize() && bCanInstall; i++)
			{
				m_doc_data.GetAttr(rels[i], m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_related, docRevInst);
				if(!m_doc->m_api.m_data.IsKindOf(docRevInst, m_doc->m_api.m_doc_mgr.e_apl_doc_rev))
					continue;

				m_doc->m_api.m_data.GetAttr(docRevInst, m_doc->m_api.m_doc_mgr.a_apl_doc_rev_doc, docInst);
				if(!docInst)
				{
					m_doc->m_api.m_doc_mgr.LoadDocInfo(docRevInst);
					m_doc->m_api.m_data.GetAttr(docRevInst, m_doc->m_api.m_doc_mgr.a_apl_doc_rev_doc, docInst);
				}
				if(!docInst) continue; //-V581
				
				m_doc_data.GetAttr(rels[i], m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_date_removed, sDateRem);
				if(docInst==((CaplDocTreeItem *)item)->m_inst && sDateRem.IsEmpty())
				{
					//       
					bCanInstall= false;continue;
				}
			}

			if(bCanInstall)
			{
				CaplInstance *inst_rel= m_doc_data.CreateInstance(m_doc->m_api.m_prd_inst_mgr.e_apl_component);
				m_doc_data.PutAttr(inst_rel,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_relating, m_inst);
				m_doc_data.PutAttr(inst_rel,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_related, ((CaplDocTreeItem *)item)->m_rev);
				COleDateTime odt;
				CString sDate;
				m_doc->m_api.m_data.NET_GetServerDateTime(odt);
				aplDate2String(odt, sDate);
				m_doc_data.PutAttr(inst_rel, m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_date_installed, sDate);
	
				m_doc_data.NET_SaveChanges();	
				
				CaplDocTreeItem *inst_item= new CaplDocTreeItem(m_tree, m_doc, 
					((CaplDocTreeItem *)item)->m_inst, inst_rel, ((CaplDocTreeItem *)item)->m_rev);
				inst_item->m_project= NULL;
				inst_item->CreateTreeItem(m_item);
				m_all_prd_instances.Add(inst_rel);
				inst_item->RefreshItem();
			}
			MyExpand();
		}
	}
/*	if (item->m_type == APL_TREE_ITEM_BPINST)
	{
		CaplInstance *bp_inst=((CaplBPInstTreeItem *)item)->m_inst;
		CaplInstance *rel=m_doc->m_api.m_bp_mgr.CreateInstanceAssociation(m_inst,bp_inst);
		if(rel)
		{
			CaplBPInstTreeItem *new_item=0;
			InsertInstInTree(bp_inst,m_item,m_doc,m_tree,m_all_bp_inst,0,(CaplTreeItem **)(&new_item));
			if(new_item!=0)new_item->m_rel=rel;
			MyExpand();
		}
	}
	if (item->m_type == APL_TREE_ITEM_BP)
	{
		CaplInstance *i_act=((CaplBPTreeItem *)item)->m_inst;

		CaplInstance *rel=m_doc->m_api.m_bp_mgr.CreateAssociation(m_inst,i_act);
		if(rel==0) return false;

		CaplBPTreeItem *new_item=0;
		InsertInstInTree(i_act,m_item,m_doc,m_tree,m_all_bp,0,(CaplTreeItem **)(&new_item));
		if(new_item!=0)new_item->m_rel=rel;
		MyExpand();
		return true;
	}*/
	m_tree->RedrawWindow();
	return true;
}

//****************************************************************
bool CaplPrdInstTreeItem::PasteFile(LPCTSTR file, CPoint *point)
{
	if(file==0) return false;
	CreateDoc(m_inst,file);
	return true;
}
//****************************************************************
void CaplPrdInstTreeItem::CreateCharacteristicGroup(CaplInstance *group)
{
	CaplInstance *group_new=0;
	if(m_doc->m_api.m_charact_mgr.CreateCharacteristicGroup(m_inst,&group_new,group))
	{
		if(group!=0)
		{
			/*
			if(CaplTreeItem::m_AutoUzurpireCharacteristic)
			{
				aplExtent ext; ext.Add(group);
				m_doc_data.NET_BecomeInstancesOwner(&ext);
			}*/

		}
		CaplCharacteristicGroupTreeItem *characteristic_group_item=
			new CaplCharacteristicGroupTreeItem(m_tree,m_doc,group_new);
		characteristic_group_item->CreateTreeItem(m_item);
		m_all_caracteristic.Add(group_new);
		MyExpand();
		m_doc->ChangeItem(0);m_doc->ChangeItem(this);
	}
}
//****************************************************************
void CaplPrdInstTreeItem::CreateBP()
{
	if(m_doc==0) return;
	if(m_tree==0) return;

	m_doc->m_api.m_prd_inst_mgr.LoadPrdInstInfo(m_inst);

	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}

	CString str_id;
	TCHAR *id=0;
	m_doc_data.GetAttr(m_inst,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_id,str_id);
	id=(TCHAR*)LPCTSTR(str_id);

	CaplInstance *rel=0;
	CaplInstance *i_act=m_doc->m_api.m_bp_mgr.CreateBP(0,m_inst,id,0,0,APL_MODE_CREATE_BP,&rel,0);
	if(i_act && rel)
	{
		CaplBPTreeItem *new_item=0;
		InsertInstInTree(i_act,m_item,m_doc,m_tree,m_all_bp,0,(CaplTreeItem **)(&new_item));
		if(new_item!=0)new_item->m_rel=rel;
		MyExpand();
	}
}
//****************************************************************
void CaplPrdInstTreeItem::CreateBPInst()
{
	if(m_doc==0) return;
	if(m_tree==0) return;

	m_doc->m_api.m_prd_inst_mgr.LoadPrdInstInfo(m_inst);

	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}

	CString str_id;
	m_doc_data.GetAttr(m_inst,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_id,str_id);

	CaplInstance *rel=0;
	CaplInstance *i_act=m_doc->m_api.m_bp_mgr.CreateBPInst(0,str_id,0,0,0,m_inst,0,&rel);
	if(i_act && rel)
	{
		CaplBPInstTreeItem *new_item=0;
		InsertInstInTree(i_act,m_item,m_doc,m_tree,m_all_bp_inst,0,(CaplTreeItem **)(&new_item));
		if(new_item!=0)new_item->m_rel=rel;
		MyExpand();
	}
}
//****************************************************************
void CaplPrdInstTreeItem::CreateBPCopy(CaplInstance *base_bp)
{
	if(m_doc==0) return;
	if(m_tree==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	if(m_inst->GetAccessmode()>aplRO){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}
	CaplInstance *rel=0;
	CaplInstance *i_act=m_doc->m_api.m_bp_mgr.CreateBPCopy(base_bp,0,0,0,m_inst,0,&rel);
	if(i_act && rel)
	{
		CaplBPTreeItem *new_item=0;
		InsertInstInTree(i_act,m_item,m_doc,m_tree,m_all_bp,0,(CaplTreeItem **)(&new_item));
		if(new_item!=0)new_item->m_rel=rel;
		MyExpand();
	}
}
//****************************************************************
void CaplPrdInstTreeItem::CreateBPInstCopy(CaplInstance *base_bp_inst)
{
	if(m_doc==0) return;
	if(m_tree==0) return;

	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	if(m_inst->GetAccessmode()>aplRO){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}
	
	CaplInstance *rel=0;
	CaplInstance *i_act=m_doc->m_api.m_bp_mgr.CreateBPInstCopy(base_bp_inst,0,0,0,0,m_inst,0,&rel);
	if(i_act && rel)
	{
		CaplBPInstTreeItem *new_item=0;
		InsertInstInTree(i_act,m_item,m_doc,m_tree,m_all_bp_inst,0,(CaplTreeItem **)(&new_item));
		if(new_item!=0)new_item->m_rel=rel;
		MyExpand();
	}
}
//****************************************************************


void CaplPrdInstTreeItem::ShowAllUsesBP()
{
	int i;
	if(m_tree==0) return;
	if(m_doc==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	if(m_inst->GetAccessmode()>aplRO)	{AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}

	aplExtent ext_bp,ext_bp_inst;
	m_doc->m_api.m_bp_mgr.ItemWhereUsedAsResource(m_inst,ext_bp,ext_bp_inst);
	m_doc->m_api.m_bp_mgr.LoadBPInfo(ext_bp);
	m_doc->m_api.m_bp_mgr.LoadBPInstInfo(ext_bp_inst);
	for(i=0;i<ext_bp.GetSize();i++)
	{
		if(m_all_parent_bps.Find(ext_bp[i])>=0) continue;
		CaplBPTreeItem *act_item= new CaplBPTreeItem(m_tree,m_doc,ext_bp[i]);
		act_item->m_subitem=m_inst;
		act_item->CreateTreeItem(m_item);
		act_item->RefreshItem();
		m_all_parent_bps.Add(ext_bp[i]);
	}
	for(i=0;i<ext_bp_inst.GetSize();i++)
	{
		if(m_all_parent_bps.Find(ext_bp_inst[i])>=0) continue;
		CaplBPInstTreeItem *act_item= new CaplBPInstTreeItem(m_tree,m_doc,ext_bp_inst[i]);
		act_item->m_subitem=m_inst;
		act_item->CreateTreeItem(m_item);
		act_item->RefreshItem();
		m_all_parent_bps.Add(ext_bp_inst[i]);
	}
	MyExpand(false);
}

void CaplPrdInstTreeItem::ShowAllBPs(bool showMsg)
{
	if(m_doc==0) return;
	if(m_item==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	if(m_inst->GetAccessmode()>aplRO) {aplErrorMessage(S::NoAccessRight(),m_inst);return;};
	
	int i,k=m_all_bp.Size;
	CaplInstance *inst0;
	aplExtent ext, ext_rel;
	StartBusy();
	m_doc->m_api.m_bp_mgr.FindAssociatedBP(m_inst,ext,ext_rel,m_doc->m_cur_context);
	StopBusy();
	
	if(m_bShowNoFoundMessage) m_tree->SetRedraw(FALSE);
	for(i=0;i<ext_rel.Size;i++)
	{
		m_doc_data.GetAttr(ext_rel[i],m_doc->m_api.m_bp_mgr.a_bp_ref_process,inst0);
		if(inst0==0) continue;
		CaplBPTreeItem *new_item=0;
		InsertInstInTree(inst0,m_item,m_doc,m_tree,m_all_bp,0,(CaplTreeItem **)(&new_item));
		if(new_item!=0) new_item->m_rel=ext_rel[i];
	}
	if(m_bShowNoFoundMessage) m_tree->SetRedraw(TRUE);
		
	if(k>=m_all_bp.Size) 
	{
		if(m_bShowNoFoundMessage && showMsg) AfxMessageBox( APL_T(" -  "));
	}
	else MyExpand();

}
//****************************************************************
void CaplPrdInstTreeItem::ShowAllBPInst(bool showMsg)
{
	if(m_doc==0) return;
	if(m_item==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	if(m_inst->GetAccessmode()>aplRO) {aplErrorMessage(S::NoAccessRight(),m_inst);return;};
	
	int i,k=m_all_bp_inst.Size;
	CaplInstance *inst0;
	aplExtent ext, ext_rel;
	StartBusy();
	m_doc->m_api.m_bp_mgr.FindAssociatedBPInst(m_inst,ext,ext_rel,m_doc->m_cur_context);
	StopBusy();
	
	if(m_bShowNoFoundMessage) m_tree->SetRedraw(FALSE);
	for(i=0;i<ext_rel.Size;i++)
	{
		m_doc_data.GetAttr(ext_rel[i],m_doc->m_api.m_bp_mgr.a_bp_inst_ref_process,inst0);
		if(inst0==0) continue;
		CaplBPInstTreeItem *new_item=0;
		InsertInstInTree(inst0,m_item,m_doc,m_tree,m_all_bp_inst,0,(CaplTreeItem **)(&new_item));
		if(new_item!=0) new_item->m_rel=ext_rel[i];
	}
	if(m_bShowNoFoundMessage) m_tree->SetRedraw(TRUE);
		
	if(k>=m_all_bp_inst.Size) 
	{
		if(m_bShowNoFoundMessage && showMsg) AfxMessageBox( APL_T("  -  "));
	}
	else MyExpand();
}
//****************************************************************
void CaplPrdInstTreeItem::RemoveFromCategory()
{
	if(m_inst==0) return;

	HTREEITEM hitem=m_tree->GetParentItem(m_item);
	CaplTreeItem *treeitem=(CaplTreeItem *)m_tree->GetItemData(hitem);
	if(treeitem==0) return;
	if(treeitem->m_type!=APL_TREE_ITEM_CATEGORIES)return;

	if(m_inst->GetAccessmode()>aplOWN)
	{
		AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP);
		return;
	}
	
	int i;
	CaplInstance *inst0;
	CaplAggr aggr;
	if(AfxMessageBox( APL_T("  ?"),MB_YESNO|MB_DEFBUTTON2)!=IDYES) return;

	CaplInstance *instcateg=((CaplCategoryTreeItem*)treeitem)->m_inst;
	if(instcateg==0) return;
	if(instcateg->GetType()==0) return;

	if(!m_doc->m_api.m_categ_mgr.RemovePrdFromCategory(m_inst,instcateg)) return;

	for(i=0;i<m_doc->m_items.Size;i++)
	{
		if(m_doc->m_items[i]->m_type==APL_TREE_ITEM_PRDINST)
		{
			if(((CaplPrdInstTreeItem*)m_doc->m_items[i])->m_inst==m_inst)
			{
				hitem=m_tree->GetParentItem(((CaplProductTreeItem*)m_doc->m_items[i])->m_item);
				treeitem=(CaplTreeItem *)m_tree->GetItemData(hitem);
				if(treeitem!=0)
				{
					if(treeitem->m_type==APL_TREE_ITEM_CATEGORIES)
					{
						inst0=((CaplCategoryTreeItem*)treeitem)->m_inst;
						if(instcateg==inst0)
						{
							if(m_doc->m_items[i]!=this){m_doc->m_items.Remove(i);i--;}
						}
					}
				}
			}
		}
	}
	m_doc->m_items.Remove(m_doc->m_items.Find(this));
}

//****************************************************************
void CaplPrdInstTreeItem::RemoveRelation()
{
	if((m_prd_inst_rel==0)&&(m_project==0)) return;

	if(m_prd_inst_rel)
	{
		CaplInstance *parent;
		m_doc_data.GetAttr(m_prd_inst_rel,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_relating,parent);
		if(parent==0) return;
		if(parent->GetId()==0) return;
		if(parent->GetAccessmode()>aplRW)
		{
			AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP);
			return;
		}
		m_doc_data.DeleteInstance(m_prd_inst_rel);
	}
	else if(m_project)
	{
		if(!m_inst) return;
		if(AfxMessageBox( APL_T("  ?"),MB_YESNO|MB_DEFBUTTON2)!=IDYES) return;
		if(!m_doc->m_project_mgr->DeleteAssociation(m_project,m_inst)) return;
		CaplProjectTreeItem *prj_item=(CaplProjectTreeItem*)GetParentItem(this);
		if(prj_item) prj_item->m_all_items.Remove(prj_item->m_all_items.Find(m_inst));
	}
	m_doc->m_items.Remove(m_doc->m_items.Find(this));		
}


//****************************************************************
void CaplPrdInstTreeItem::CreateProject()
{
	if(m_doc==0) return;
	if(m_tree==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	if(m_inst->GetAccessmode()>aplRO){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}
	CaplInstance *rel=0;
	
	CaplInstance *project=m_doc->m_project_mgr->CreateProject(0,0,false,m_inst,&rel);
	if(project && rel)
	{
		CaplProjectTreeItem *new_item=0;
		InsertInstInTree(project,m_item,m_doc,m_tree,m_all_projects,0,(CaplTreeItem **)(&new_item));
		if(new_item!=0)new_item->m_rel=m_inst;
		MyExpand();
		m_doc->ChangeItem(0);m_doc->ChangeItem(this);
	}
}
//****************************************************************
void CaplPrdInstTreeItem::CreateRefusal()
{
	if(m_doc==0) return;
	if(m_tree==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;

	aplExtent ext,ext_doc;

	CaplInstance *refusal=m_doc->m_fault_mgr.CreateRefusal(0,ext,&ext_doc,0,m_inst);
	if(refusal!=0)
	{
		CaplRefusalTreeItem *new_item=0;
		InsertInstInTree(refusal,m_item,m_doc,m_tree,m_all_refusal,0,(CaplTreeItem **)(&new_item));
		MyExpand();
	}
}