// CTableContent.cpp
#include "stdafx.h"
#include "ReportDict.h"

CTableContent::CTableContent(CaplReportMgr* mgr)
{
	ASSERT(mgr);
	m_ReportMgr = mgr;
	m_inst = NULL;
}

CTableContent::~CTableContent()
{
	for(int i=0; i<m_Childs.GetSize();i++)
		delete m_Childs[i];
	m_Childs.RemoveAll();
}

void CTableContent::Update(bool bSet /* = true */)
{
	int i;
	if(bSet)//
	{
		if(m_inst==NULL)
			m_inst = m_ReportMgr->m_data->CreateInstance(m_ReportMgr->e_apl_table_content);
		ASSERT(m_inst);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_tc_title, m_Title);
		aplExtent sheets, childs;
		for(i=0; i<m_Childs.GetSize(); i++)
		{
			m_Childs.GetAt(i)->Update(bSet);
			childs.Add(m_Childs.GetAt(i)->m_inst);
		}
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_tc_childs, childs);
		for(i=0; i<m_sheets.GetSize(); i++)
		{
			if(m_sheets.GetAt(i)->m_inst==NULL)
				m_sheets.GetAt(i)->Update(bSet);
			sheets.Add(m_sheets.GetAt(i)->m_inst);
		}
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_tc_sheets, sheets);
	}
	else//
	{
		ASSERT(m_inst);
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_tc_title, m_Title);
		aplExtent sheets, childs;
		m_sheets.RemoveAll();
		for(i=0; i<m_Childs.GetSize(); i++)
			delete m_Childs.GetAt(i);
		m_Childs.RemoveAll();
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_tc_childs, childs);
		for(i=0; i<childs.GetSize(); i++)
		{
			CTableContent* tc = new CTableContent(m_ReportMgr);
			tc->m_inst = childs[i];
			tc->Update(bSet);
			m_Childs.Add(tc);
		}
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_tc_sheets, sheets);
		int cnt = m_ReportMgr->m_sheets.GetSize();
		for(i=0; i<sheets.GetSize(); i++)
		{
			for(int j=0; j<cnt; j++)
			{
				if(m_ReportMgr->m_sheets.GetAt(j)->m_inst==sheets[i])
					m_sheets.Add(m_ReportMgr->m_sheets.GetAt(j));
			}
		}
	}
}

int CTableContent::FindSheet(CReportSheet* Sheet)
{
	int cnt = m_sheets.GetSize();
	for(int i=0; i<cnt; i++)
		if(m_sheets[i]==Sheet) return i;
	return -1;
}

int CTableContent::AddSheet(CReportSheet* Sheet)
{
	int cnt = m_sheets.GetSize();
	for(int i=0; i<cnt; i++)
		if(m_sheets[i]==Sheet) return i;
	return m_sheets.Add(Sheet);
}

