// ConditionDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "ConditionDlg.h"
#include "SelectDSColumnDlg.h"
#include "ReportDict.h"
#include "Functions.h"
#include <AplGuiEx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConditionDlg dialog


CConditionDlg::CConditionDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CConditionDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConditionDlg)
	m_str_value = _T("");
	m_ds_column = _T("");
	m_cm_type = 0;
	//}}AFX_DATA_INIT
	m_condition = NULL;
	m_type = aplEQUAL;
	m_value_type = aplSTRING;
	m_ds_col = NULL;
	m_ReportMgr=NULL;
}


void CConditionDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConditionDlg)
	DDX_Control(pDX, IDC_STATIC_IMAGE, m_ImageCtrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Text(pDX, IDC_STR_VALUE, m_str_value);
	DDX_Text(pDX, IDC_COLUMN, m_ds_column);
	DDX_CBIndex(pDX, IDC_COMPARE_TYPE, m_cm_type);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConditionDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CConditionDlg)
	ON_BN_CLICKED(IDC_SELECT_DS_COLUMN, OnSelectDsColumn)
	ON_CBN_SELCHANGE(IDC_TYPE, OnSelchangeType)
	ON_CBN_SELCHANGE(IDC_VALUE_TYPE, OnSelchangeValueType)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConditionDlg message handlers

void CConditionDlg::OnSelectDsColumn() 
{
	UpdateData();
	do {
		CSelectDSColumnDlg dlg;
		dlg.m_ReportMgr = m_ReportMgr;
		dlg.m_selected = m_ds_col;
		if(dlg.DoModal()==IDOK)
		{
			if(dlg.m_selected==NULL)
			{
				AfxMessageBox(APL_T("    ."));
				continue;
			}
			m_ds_col = dlg.m_selected;
			m_ds_column = m_ds_col->m_name;
			break;
		}
		else break;
	} while(1);
	UpdateData(FALSE);
}

BOOL CConditionDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	ASSERT(m_ReportMgr);

	m_ok_btn.SetIcon(aplGetStdIco16(APL_STD_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(aplGetStdIco16(APL_STD_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	if(m_condition!=0)
	{
		m_ds_col = m_condition->m_column;
		m_ds_column = m_condition->m_column->m_name;
		m_type = m_condition->m_type;
		m_value_type = m_condition->m_value_type;
		m_str_value = m_condition->GetText();
		if(m_condition->m_flag&aplCOMPARE_OR)
			m_cm_type = 1;
	}
	CComboBox* cb = (CComboBox*)GetDlgItem(IDC_TYPE);
	cb->SetCurSel(m_type);
	cb = (CComboBox*)GetDlgItem(IDC_VALUE_TYPE);
	cb->SetCurSel(m_value_type-3);
	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CConditionDlg::OnSelchangeType() 
{
	CComboBox* cb = (CComboBox*)GetDlgItem(IDC_TYPE);
	m_type = cb->GetCurSel();
}

void CConditionDlg::OnSelchangeValueType() 
{
	CComboBox* cb = (CComboBox*)GetDlgItem(IDC_VALUE_TYPE);
	m_value_type = cb->GetCurSel()+3;
}

void CConditionDlg::OnOK() 
{
	UpdateData();
	if(m_ds_col==0) return;
	if(m_condition==0)
		m_condition = new CCondition(m_ReportMgr);
	//     
	if(!m_str_value.IsEmpty())
	{
		if(m_str_value[0]==_T('$'))
		{
			//        
			CString buf;
			buf = m_str_value.Right(m_str_value.GetLength()-1);
			if(buf.IsEmpty())
			{
				AfxMessageBox(APL_T("   !"));
				return;
			}
			int ind = m_ReportMgr->m_data_source.m_params.Find(buf);
			if(ind<0)
			{
				AfxMessageBox(APL_T("   !\n    ."));
				return;
			}
			m_condition->Set(m_type,m_str_value);
			CaplTranslateDialog::OnOK();
			return;
		}
	}
	if(m_value_type==aplINTEGER)
	{
		if(m_str_value.IsEmpty())
		{
			AfxMessageBox(APL_T("    !"));
			return;
		}
		if(!IsRealOrEmpty(m_str_value))
		{
			AfxMessageBox(APL_T("  "));
			return;
		}
		int val = _atoi(m_str_value);
		m_condition->Set(m_type,val);
	}
	else if(m_value_type==aplREAL)
	{
		if(m_str_value.IsEmpty())
		{
			AfxMessageBox(APL_T("    !"));
			return;
		}
		if(!IsRealOrEmpty(m_str_value))
		{
			AfxMessageBox(APL_T("  "));
			return;
		}
		double val = __atof(m_str_value);
		m_condition->Set(m_type,val);
	}
	else
		m_condition->Set(m_type,m_str_value);
	m_condition->m_column = m_ds_col;

	m_condition->m_flag = 0;
	if(m_cm_type==1)
		m_condition->m_flag = aplCOMPARE_OR;
	else
		m_condition->m_flag = aplCOMPARE_AND;
	
	CaplTranslateDialog::OnOK();
}
