// ConditionSetupDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "ReportDict.h"
#include "ConditionSetupDlg.h"
#include "ConditionDlg.h"
#include <AplGuiEx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConditionSetupDlg dialog

CConditionSetupDlg::CConditionSetupDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CConditionSetupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConditionSetupDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	types.Add(APL_T(""));
	types.Add(APL_T(" "));
	types.Add(APL_T(""));
	types.Add(APL_T(""));
}


void CConditionSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConditionSetupDlg)
	DDX_Control(pDX, IDC_STATIC_IMAGE, m_ImageCtrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConditionSetupDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CConditionSetupDlg)
	ON_WM_CONTEXTMENU()
	ON_NOTIFY(NM_DBLCLK, IDC_LIST, OnDblclkList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConditionSetupDlg message handlers

BOOL CConditionSetupDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_ok_btn.SetIcon(aplGetStdIco16(APL_STD_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(aplGetStdIco16(APL_STD_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	CListCtrl* wnd = (CListCtrl*)GetDlgItem(IDC_LIST);
	wnd->SetExtendedStyle(LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);
	wnd->InsertColumn(0,APL_T(""),LVCFMT_LEFT,100);
	wnd->InsertColumn(1,APL_T(""),LVCFMT_LEFT,100);
	wnd->InsertColumn(2,APL_T(""),LVCFMT_LEFT,200);
	int cnt = m_conditions->GetSize();
	for(int i=0; i<cnt;i++)
	{
		CCondition* cond = m_conditions->GetAt(i);
		int ind = wnd->InsertItem(wnd->GetItemCount(),cond->m_column->m_name);
		wnd->SetItemText(ind,1,types.GetAt(cond->m_type));
		wnd->SetItemText(ind,2,cond->GetText());
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CConditionSetupDlg::OnContextMenu(CWnd* pWnd, CPoint point) 
{
//	pWnd->ScreenToClient(&point);
	CListCtrl* lc = (CListCtrl*)GetDlgItem(IDC_LIST);
	int cur = lc->GetNextItem(-1,LVIS_SELECTED);
	CMenu menu;
	CMenu* pPopup;
	menu.LoadMenu(IDR_CONTEXT_MENU);
	pPopup = menu.GetSubMenu(3);
	pPopup->EnableMenuItem(ID_COPY,MF_BYCOMMAND|MF_GRAYED);
	if(cur<0)
	{
		pPopup->EnableMenuItem(ID_DELETE,MF_BYCOMMAND|MF_GRAYED);
		pPopup->EnableMenuItem(ID_PROPERTY,MF_BYCOMMAND|MF_GRAYED);
	}
	BOOL res = pPopup->TrackPopupMenu(TPM_RIGHTBUTTON|TPM_RETURNCMD|TPM_LEFTALIGN,point.x,point.y,pWnd);
	if(res==ID_ADD)
	{
		CConditionDlg dlg;
		dlg.m_ReportMgr = m_ReportMgr;
		if(dlg.DoModal()==IDOK)
		{
			m_conditions->Add(dlg.m_condition);
			int ind = lc->InsertItem(lc->GetItemCount(),dlg.m_condition->m_column->m_name);
			lc->SetItemText(ind,1,types.GetAt(dlg.m_condition->m_type));
			lc->SetItemText(ind,2,dlg.m_condition->GetText());
		}
	}
	else if(res == ID_DELETE)
	{
		if(AfxMessageBox(APL_T("     ?"),MB_YESNO|MB_ICONQUESTION|MB_DEFBUTTON2)==IDNO) return;
		m_conditions->RemoveAt(cur);
		lc->DeleteItem(cur);
	}
	else if(res==ID_PROPERTY)
	{
		CConditionDlg dlg;
		dlg.m_ReportMgr = m_ReportMgr;
		dlg.m_condition = m_conditions->GetAt(cur);
		if(dlg.DoModal()==IDOK)
		{
			lc->SetItemText(cur,0,m_conditions->GetAt(cur)->m_column->m_name);
			lc->SetItemText(cur,1,types.GetAt(m_conditions->GetAt(cur)->m_type));
			lc->SetItemText(cur,2,m_conditions->GetAt(cur)->GetText());
		}
	}
}

void CConditionSetupDlg::OnDblclkList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	CListCtrl* lc = (CListCtrl*)GetDlgItem(IDC_LIST);
	int cur = lc->GetNextItem(-1,LVIS_SELECTED);
	if(cur<0) return;
	CConditionDlg dlg;
	dlg.m_ReportMgr = m_ReportMgr;
	dlg.m_condition = m_conditions->GetAt(cur);
	if(dlg.DoModal()==IDOK)
	{
		lc->SetItemText(cur,0,m_conditions->GetAt(cur)->m_column->m_name);
		lc->SetItemText(cur,1,types.GetAt(m_conditions->GetAt(cur)->m_type));
		lc->SetItemText(cur,2,m_conditions->GetAt(cur)->GetText());
	}
	
	*pResult = 0;
}
