// CoordinatePropPage.cpp : implementation file
//

#include "stdafx.h"
#include "CoordinatePropPage.h"
#include "SelectDSColumnDlg.h"
#include "PropertyDlg.h"
#include <AplGuiEx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCoordinatePropPage dialog


CCoordinatePropPage::CCoordinatePropPage(CWnd* pParent /*=NULL*/)
	: CPageDialog(CCoordinatePropPage::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCoordinatePropPage)
	m_sXFontName = _T("");
	m_iXFontSize = 0;
	m_dXLineWidth = 0.0;
	m_sXName = _T("");
	m_sYName = _T("");
	m_XShowName = 0;
	m_YShowName = 0;
	m_sYFontName = _T("");
	m_iYFontSize = 0;
	m_dYLineWidth = 0.0;
	m_bProRataValues = FALSE;
	m_bHideXValues = FALSE;
	m_bShowXLines = FALSE;
	m_bShowYLines = FALSE;
	m_bShowXNameCycle = FALSE;
	m_bShowYNameCycle = FALSE;
	m_bShowYPercentCycle = FALSE;
	m_bAngleTextsValues = FALSE;
	//}}AFX_DATA_INIT

	m_pXLine = NULL;
	m_pYLine = NULL;

	m_pXColumn = NULL;
	m_pXParam = NULL;
	m_pYParam = NULL;

	m_ElemType = E_DIAGRAM;
}


void CCoordinatePropPage::DoDataExchange(CDataExchange* pDX)
{
	CPageDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCoordinatePropPage)
	DDX_Control(pDX, IDC_YLINE_COLORS, m_YLinesColorCtrl);
	DDX_Control(pDX, IDC_XLINE_COLORS, m_XLinesColorCtrl);
	DDX_Control(pDX, IDC_YLINE_COLOR, m_YLineColorCtrl);
	DDX_Control(pDX, IDC_YFONT_COLOR, m_YFontColorCtrl);
	DDX_Control(pDX, IDC_YPARAM_COMBO, m_YParamComboCtrl);
	DDX_Control(pDX, IDC_XPARAM_COMBO, m_XParamComboCtrl);
	DDX_Control(pDX, IDC_XFONT_COLOR, m_XFontColorCtrl);
	DDX_Control(pDX, IDC_XLINE_COLOR, m_XLineColorCtrl);
	DDX_Control(pDX, IDC_DS_COMBO, m_DSComboCtrl);
	DDX_Control(pDX, IDC_BROWSE_FONT_Y, m_browse_yfont_btn);
	DDX_Control(pDX, IDC_BROWSE_FONT_X, m_browse_xfont_btn);
	DDX_Control(pDX, IDC_BROWSE_DS_COLUMN, m_browse_dscolumn_btn);
	DDX_Text(pDX, IDC_X_FONT_NAME, m_sXFontName);
	DDX_Text(pDX, IDC_x_FONT_SIZE, m_iXFontSize);
	DDX_Text(pDX, IDC_X_LINE_WIDTH, m_dXLineWidth);
	DDX_Text(pDX, IDC_XNAME, m_sXName);
	DDX_Text(pDX, IDC_YNAME, m_sYName);
	DDX_Radio(pDX, IDC_X_NAME, m_XShowName);
	DDX_Radio(pDX, IDC_Y_NAME, m_YShowName);
	DDX_Text(pDX, IDC_Y_FONT_NAME, m_sYFontName);
	DDX_Text(pDX, IDC_Y_FONT_SIZE, m_iYFontSize);
	DDX_Text(pDX, IDC_Y_LINE_WIDTH, m_dYLineWidth);
	DDX_Check(pDX, IDC_PRORATA_VALUES, m_bProRataValues);
	DDX_Check(pDX, IDC_HIDE_XVALUES, m_bHideXValues);
	DDX_Check(pDX, IDC_SHOW_XLINES, m_bShowXLines);
	DDX_Check(pDX, IDC_SHOW_YLINES, m_bShowYLines);
	DDX_Check(pDX, IDC_SHOW_X_CYCLE, m_bShowXNameCycle);
	DDX_Check(pDX, IDC_SHOW_Y_CYCLE, m_bShowYNameCycle);
	DDX_Check(pDX, IDC_SHOW_Y_PERCENT_CYCLE, m_bShowYPercentCycle);
	DDX_Check(pDX, IDC_ANGLE_TEXTS_VALUES, m_bAngleTextsValues);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCoordinatePropPage, CPageDialog)
	//{{AFX_MSG_MAP(CCoordinatePropPage)
	ON_BN_CLICKED(IDC_BROWSE_DS_COLUMN, OnBrowseDsColumn)
	ON_BN_CLICKED(IDC_BROWSE_FONT_X, OnBrowseFontX)
	ON_BN_CLICKED(IDC_BROWSE_FONT_Y, OnBrowseFontY)
	ON_BN_CLICKED(IDC_X_NAME, OnXName)
	ON_BN_CLICKED(IDC_RADIO4, OnRadio4)
	ON_BN_CLICKED(IDC_Y_NAME, OnYName)
	ON_BN_CLICKED(IDC_RADIO6, OnRadio6)
	ON_BN_CLICKED(IDC_XLINE_COLOR, OnXlineColor)
	ON_BN_CLICKED(IDC_YLINE_COLOR, OnYlineColor)
	ON_BN_CLICKED(IDC_YLINE_COLORS, OnYlineColors)
	ON_BN_CLICKED(IDC_XLINE_COLORS, OnXlineColors)
	ON_WM_SHOWWINDOW()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCoordinatePropPage message handlers

void CCoordinatePropPage::OnBrowseDsColumn() 
{
	CSelectDSColumnDlg dlg;
	dlg.m_ReportMgr = m_pXLine->m_ReportMgr;
	dlg.m_bShowEmptyColumn = false;
	if(dlg.DoModal()==IDOK)
		SelectColumn(dlg.m_selected);
}

void CCoordinatePropPage::OnBrowseFontX() 
{
	UpdateData();
	CDC *pDC = GetDC();
	CFontDialog	dlg(&m_XLineFont);
	int old = m_XLineFont.lfHeight;
	m_XLineFont.lfHeight = -MulDiv(-old/10, ::GetDeviceCaps(pDC->m_hDC, LOGPIXELSY), 72);
	dlg.m_cf.Flags |=CF_INITTOLOGFONTSTRUCT|CF_LIMITSIZE;
	dlg.m_cf.nSizeMax = 1638;
	dlg.m_cf.nSizeMin = 1;
	dlg.m_cf.lpLogFont = &m_XLineFont;
	dlg.m_cf.rgbColors = m_XFontColor;
	if(dlg.DoModal()==IDOK)
	{
		m_iXFontSize = dlg.GetSize()/10;
		m_sXFontName = m_XLineFont.lfFaceName;
		m_XLineFont.lfHeight = dlg.GetSize();
		m_XFontColor = dlg.m_cf.rgbColors;
		m_XFontColorCtrl.SetBkColor(m_XFontColor);
		UpdateData(FALSE);
	}
	else
		m_XLineFont.lfHeight = old;
	
	ReleaseDC(pDC);
}

void CCoordinatePropPage::OnBrowseFontY() 
{
	UpdateData();
	CDC *pDC = GetDC();
	CFontDialog	dlg(&m_YLineFont);
	int old = m_YLineFont.lfHeight;
	m_YLineFont.lfHeight = -MulDiv(-old/10, ::GetDeviceCaps(pDC->m_hDC, LOGPIXELSY), 72);
	dlg.m_cf.Flags |=CF_INITTOLOGFONTSTRUCT|CF_LIMITSIZE;
	dlg.m_cf.nSizeMax = 1638;
	dlg.m_cf.nSizeMin = 1;
	dlg.m_cf.lpLogFont = &m_YLineFont;
	dlg.m_cf.rgbColors = m_YFontColor;
	if(dlg.DoModal()==IDOK)
	{
		m_iYFontSize = dlg.GetSize()/10;
		m_sYFontName = m_YLineFont.lfFaceName;
		m_YLineFont.lfHeight = dlg.GetSize();
		m_YFontColor = dlg.m_cf.rgbColors;
		m_YFontColorCtrl.SetBkColor(m_YFontColor);
		UpdateData(FALSE);
	}
	else
		m_YLineFont.lfHeight = old;
	
	ReleaseDC(pDC);
}

BOOL CCoordinatePropPage::OnInitDialog() 
{
	CPageDialog::OnInitDialog();
	
	if(m_pXLine==NULL || m_pYLine==NULL)
	{
		EndDialog(0);
		TRACE(APL_T("   XLine  YLine\n"));
		return FALSE;
	}

	m_browse_yfont_btn.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_browse_yfont_btn.SetWindowText(_T(""));
	m_browse_xfont_btn.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_browse_xfont_btn.SetWindowText(_T(""));

	m_browse_dscolumn_btn.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_browse_dscolumn_btn.SetWindowText(_T(""));

	m_sXName = m_pXLine->m_name;
	m_sYName = m_pYLine->m_name;

	m_XLineFont = m_pXLine->m_font;
	m_YLineFont = m_pYLine->m_font;
	m_XFontColor = m_pXLine->m_font_color;
	m_YFontColor = m_pYLine->m_font_color;
	
	m_XLineColor = m_pXLine->m_line_color;
	m_YLineColor = m_pYLine->m_line_color;

	m_XLinesColor = m_pXLine->m_lines_color;
	m_YLinesColor = m_pYLine->m_lines_color;

	m_iXFontSize = m_XLineFont.lfHeight/10;
	m_sXFontName = m_XLineFont.lfFaceName;
	m_iYFontSize = m_YLineFont.lfHeight/10;
	m_sYFontName = m_YLineFont.lfFaceName;

	m_dXLineWidth = (double)(m_pXLine->m_line_width)/10;
	m_dYLineWidth = (double)(m_pYLine->m_line_width)/10;

	int i;
	CString buf;
	
	for(i=0; i<m_pYLine->m_ReportMgr->m_header->GetSize(); i++)
		m_DSComboCtrl.SetItemData(m_DSComboCtrl.AddString(m_pYLine->m_ReportMgr->m_header->GetColumn(i)->GetName()), (DWORD)m_pYLine->m_ReportMgr->m_header->GetColumn(i));
	for(i=0; i<m_pYLine->m_ReportMgr->m_base_query->GetSize(); i++)
		m_DSComboCtrl.SetItemData(m_DSComboCtrl.AddString(m_pYLine->m_ReportMgr->m_base_query->GetColumn(i)->GetName()), (DWORD)m_pYLine->m_ReportMgr->m_base_query->GetColumn(i));

	//
	for(i=0; i<m_pXLine->m_ReportMgr->m_data_source.m_params.GetSize(); i++)
		m_XParamComboCtrl.SetItemData(m_XParamComboCtrl.AddString(m_pXLine->m_ReportMgr->m_data_source.m_params[i]->m_name), (DWORD)m_pXLine->m_ReportMgr->m_data_source.m_params[i]);
	for(i=0; i<m_pYLine->m_ReportMgr->m_data_source.m_params.GetSize(); i++)
		m_YParamComboCtrl.SetItemData(m_YParamComboCtrl.AddString(m_pYLine->m_ReportMgr->m_data_source.m_params[i]->m_name), (DWORD)m_pYLine->m_ReportMgr->m_data_source.m_params[i]);
	
	if (m_pXLine->m_pParam==NULL)
		m_XShowName = 0;
	else
	{
		int cur(-1);
		for(int i=0; i<m_XParamComboCtrl.GetCount(); ++i)
		{
			CReportParam *pParam = reinterpret_cast<CReportParam*>(m_XParamComboCtrl.GetItemData(i));
			if (pParam==m_pXLine->m_pParam)
			{
				cur = i;
				break;
			}
		}

		if (cur>-1)
		{
			m_XShowName = 1;
			m_XParamComboCtrl.SetCurSel(cur);
		}
		else
			m_XShowName = 0;
	}

	if (m_pYLine->m_pParam==NULL)
		m_YShowName = 0;
	else
	{
		int cur(-1);
		for(int i=0; i<m_YParamComboCtrl.GetCount(); ++i)
		{
			CReportParam *pParam = reinterpret_cast<CReportParam*>(m_YParamComboCtrl.GetItemData(i));
			if (pParam==m_pYLine->m_pParam)
			{
				cur = i;
				break;
			}
		}

		if (cur>-1)
		{
			m_YShowName = 1;
			m_YParamComboCtrl.SetCurSel(cur);
		}
		else
			m_YShowName = 0;
	}

	GetDlgItem(IDC_XNAME)->EnableWindow(m_XShowName==0?TRUE:FALSE);
	GetDlgItem(IDC_XPARAM_COMBO)->EnableWindow(m_XShowName==1?TRUE:FALSE);
	GetDlgItem(IDC_YNAME)->EnableWindow(m_YShowName==0?TRUE:FALSE);
	GetDlgItem(IDC_YPARAM_COMBO)->EnableWindow(m_YShowName==1?TRUE:FALSE);

	m_XFontColorCtrl.SetBkColor(m_XFontColor);
	m_XLineColorCtrl.SetBkColor(m_XLineColor);
	m_YFontColorCtrl.SetBkColor(m_YFontColor);
	m_YLineColorCtrl.SetBkColor(m_YLineColor);

	m_XLinesColorCtrl.SetBkColor(m_XLinesColor);
	m_YLinesColorCtrl.SetBkColor(m_YLinesColor);

	m_bProRataValues = m_pXLine->m_bProRata?TRUE:FALSE;
	m_bHideXValues = m_pXLine->m_bHideValues?TRUE:FALSE;
	m_bShowXLines = m_pXLine->m_bShowLines?TRUE:FALSE;
	m_bShowYLines = m_pYLine->m_bShowLines?TRUE:FALSE;

	m_bShowXNameCycle = m_pXLine->m_bShowNames?TRUE:FALSE;
	m_bShowYNameCycle = m_pYLine->m_bShowNames?TRUE:FALSE;
	m_bShowYPercentCycle = m_pYLine->m_bShowPercents?TRUE:FALSE;

	m_bAngleTextsValues = m_pXLine->m_TextVector==aplText_Angle?TRUE:FALSE;

	SelectColumn(m_pXLine->m_pDSColumn);

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CCoordinatePropPage::OnShowWindow(BOOL bShow, UINT nStatus)
{
	__super::OnShowWindow(bShow, nStatus);

	if(bShow)
	{
		bool bSetCyclogram = false;
		bool bTimeLine = false;
		if(m_ElemType==E_GISTOGRAM)
		{
			if(m_PropDlg && ::IsWindow(m_PropDlg->m_gistogram_prop))
			{
				//   
				if(m_PropDlg->m_gistogram_prop.m_cycle_btn.GetCheck())
				{
					GetDlgItem(IDC_X_GROUP_NAME)->SetWindowText(APL_T("   "));
					GetDlgItem(IDC_Y_GROUP_NAME)->SetWindowText(APL_T("   "));
					GetDlgItem(IDC_SHOW_XLINES)->ShowWindow(FALSE);
					GetDlgItem(IDC_XLINE_COLORS)->ShowWindow(FALSE);
					GetDlgItem(IDC_PRORATA_VALUES)->ShowWindow(FALSE);
					GetDlgItem(IDC_HIDE_XVALUES)->ShowWindow(FALSE);
					GetDlgItem(IDC_SHOW_YLINES)->ShowWindow(FALSE);
					GetDlgItem(IDC_YLINE_COLORS)->ShowWindow(FALSE);
					GetDlgItem(IDC_ANGLE_TEXTS_VALUES)->ShowWindow(FALSE);
					GetDlgItem(IDC_SHOW_X_CYCLE)->ShowWindow(TRUE);
					GetDlgItem(IDC_SHOW_Y_CYCLE)->ShowWindow(TRUE);
					GetDlgItem(IDC_SHOW_Y_PERCENT_CYCLE)->ShowWindow(TRUE);

					bSetCyclogram = true;
				}
				//   
				if(m_PropDlg->m_gistogram_prop.m_timeline_btn.GetCheck())
					bTimeLine = true;
			}
		}

		if(bSetCyclogram==false)
		{
			GetDlgItem(IDC_X_GROUP_NAME)->SetWindowText(APL_T("   "));
			GetDlgItem(IDC_Y_GROUP_NAME)->SetWindowText(APL_T("  Y "));
			GetDlgItem(IDC_SHOW_XLINES)->ShowWindow(TRUE);
			GetDlgItem(IDC_XLINE_COLORS)->ShowWindow(TRUE);
			GetDlgItem(IDC_PRORATA_VALUES)->ShowWindow(!bTimeLine);
			GetDlgItem(IDC_HIDE_XVALUES)->ShowWindow(bTimeLine);
			GetDlgItem(IDC_SHOW_YLINES)->ShowWindow(TRUE);
			GetDlgItem(IDC_YLINE_COLORS)->ShowWindow(TRUE);
			GetDlgItem(IDC_ANGLE_TEXTS_VALUES)->ShowWindow(TRUE);
			GetDlgItem(IDC_SHOW_X_CYCLE)->ShowWindow(FALSE);
			GetDlgItem(IDC_SHOW_Y_CYCLE)->ShowWindow(FALSE);
			GetDlgItem(IDC_SHOW_Y_PERCENT_CYCLE)->ShowWindow(FALSE);
		}
	}
}

void CCoordinatePropPage::SelectColumn(CHeaderColumn *pColumn)
{
	int i;
	for(i=0; i<m_DSComboCtrl.GetCount(); i++)
	{
		if(m_DSComboCtrl.GetItemData(i)==(DWORD)pColumn)
		{
			m_DSComboCtrl.SetCurSel(i);
			return;
		}
	}
	m_DSComboCtrl.SetCurSel(0);
}

void CCoordinatePropPage::OnXName() 
{
	UpdateData();
	GetDlgItem(IDC_XNAME)->EnableWindow(m_XShowName==0?TRUE:FALSE);
	GetDlgItem(IDC_XPARAM_COMBO)->EnableWindow(m_XShowName==1?TRUE:FALSE);
}

void CCoordinatePropPage::OnRadio4() 
{
	UpdateData();
	GetDlgItem(IDC_XNAME)->EnableWindow(m_XShowName==0?TRUE:FALSE);
	GetDlgItem(IDC_XPARAM_COMBO)->EnableWindow(m_XShowName==1?TRUE:FALSE);
}

void CCoordinatePropPage::OnYName() 
{
	UpdateData();
	GetDlgItem(IDC_YNAME)->EnableWindow(m_YShowName==0?TRUE:FALSE);
	GetDlgItem(IDC_YPARAM_COMBO)->EnableWindow(m_YShowName==1?TRUE:FALSE);
}

void CCoordinatePropPage::OnRadio6() 
{
	UpdateData();
	GetDlgItem(IDC_YNAME)->EnableWindow(m_YShowName==0?TRUE:FALSE);
	GetDlgItem(IDC_YPARAM_COMBO)->EnableWindow(m_YShowName==1?TRUE:FALSE);
}

void CCoordinatePropPage::OnXlineColor() 
{
	CColorDialog dlg(m_XLineColor);
	if(dlg.DoModal()==IDOK)
	{
		m_XLineColor = dlg.GetColor();
		m_XLineColorCtrl.SetBkColor(m_XLineColor);
	}
}

void CCoordinatePropPage::OnYlineColor() 
{
	CColorDialog dlg(m_YLineColor);
	if(dlg.DoModal()==IDOK)
	{
		m_YLineColor = dlg.GetColor();
		m_YLineColorCtrl.SetBkColor(m_YLineColor);
	}
}

bool CCoordinatePropPage::UpdateDlg()
{
	if(!UpdateData()) return false;

	int cur;
	CHeaderColumn* pColumn = NULL;
	CReportParam *pXParam = NULL;
	CReportParam *pYParam = NULL;

	cur = m_DSComboCtrl.GetCurSel();
	if(cur>-1)
		pColumn = (CHeaderColumn*)m_DSComboCtrl.GetItemData(cur);
	if(pColumn==NULL)
	{
		AfxMessageBox(APL_T("  ,     !"), MB_ICONINFORMATION|MB_OK);
		return false;
	}

	if(m_XShowName==1)
	{
		cur = m_XParamComboCtrl.GetCurSel();
		if(cur>-1)
			pXParam = (CReportParam*)m_XParamComboCtrl.GetItemData(cur);
		if(pXParam==NULL)
		{
			AfxMessageBox(APL_T("  ,    X!"), MB_ICONINFORMATION|MB_OK);
			return false;
		}
	}
	if(m_YShowName==1)
	{
		cur = m_YParamComboCtrl.GetCurSel();
		if(cur>-1)
			pYParam = (CReportParam*)m_YParamComboCtrl.GetItemData(cur);
		if(pYParam==NULL)
		{
			AfxMessageBox(APL_T("  ,    Y!"), MB_ICONINFORMATION|MB_OK);
			return false;
		}
	}

	m_pXLine->m_font = m_XLineFont;
	m_pXLine->m_font_color = m_XFontColor;
	m_pXLine->m_line_color = m_XLineColor;
	m_pXLine->m_line_width = (int)(m_dXLineWidth*10);
	m_pXLine->m_pParam = pXParam;
	m_pXLine->m_name = m_sXName;
	m_pXLine->m_pDSColumn = pColumn;
	m_pXLine->m_bShowLines = m_bShowXLines==TRUE;
	if(m_PropDlg->m_gistogram_prop.m_timeline_btn.GetCheck()) //   
		m_pXLine->m_bProRata = false;
	else
		m_pXLine->m_bProRata = m_bProRataValues==TRUE;
	if(m_PropDlg->m_gistogram_prop.m_timeline_btn.GetCheck()) //   
		m_pXLine->m_bHideValues = m_bHideXValues==TRUE;
	else
		m_pXLine->m_bHideValues = false;
	m_pXLine->m_lines_color = m_XLinesColor;
	m_pXLine->m_bShowNames = m_bShowXNameCycle==TRUE;
	m_pXLine->m_TextVector = (m_bAngleTextsValues==TRUE)?aplText_Angle:aplText_Horz;

	m_pYLine->m_font = m_YLineFont;
	m_pYLine->m_font_color = m_YFontColor;
	m_pYLine->m_line_color = m_YLineColor;
	m_pYLine->m_line_width = (int)(m_dYLineWidth*10);
	m_pYLine->m_pParam = pYParam;
	m_pYLine->m_name = m_sYName;
	m_pYLine->m_bShowLines = m_bShowYLines==TRUE;
	m_pYLine->m_lines_color = m_YLinesColor;
	m_pYLine->m_bShowNames = m_bShowYNameCycle==TRUE;
	m_pYLine->m_bShowPercents = m_bShowYPercentCycle==TRUE;

	return true;
}

void CCoordinatePropPage::OnYlineColors() 
{
	CColorDialog dlg(m_YLinesColor);
	if(dlg.DoModal()==IDOK)
	{
		m_YLinesColor = dlg.GetColor();
		m_YLinesColorCtrl.SetBkColor(m_YLinesColor);
	}
}

void CCoordinatePropPage::OnXlineColors() 
{
	CColorDialog dlg(m_XLinesColor);
	if(dlg.DoModal()==IDOK)
	{
		m_XLinesColor = dlg.GetColor();
		m_XLinesColorCtrl.SetBkColor(m_XLinesColor);
	}
}

bool CCoordinatePropPage::TestUpdate()
{
	if(!UpdateData()) return false;
	
	int cur;
	CHeaderColumn* pColumn = NULL;
	CReportParam *pXParam = NULL;
	CReportParam *pYParam = NULL;
	
	cur = m_DSComboCtrl.GetCurSel();
	if(cur>-1)
		pColumn = (CHeaderColumn*)m_DSComboCtrl.GetItemData(cur);
	if(pColumn==NULL)
	{
		AfxMessageBox(APL_T("  ,     !"), MB_ICONINFORMATION|MB_OK);
		return false;
	}
	
	if(m_XShowName==1)
	{
		cur = m_XParamComboCtrl.GetCurSel();
		if(cur>-1)
			pXParam = (CReportParam*)m_XParamComboCtrl.GetItemData(cur);
		if(pXParam==NULL)
		{
			AfxMessageBox(APL_T("  ,    X!"), MB_ICONINFORMATION|MB_OK);
			return false;
		}
	}
	if(m_YShowName==1)
	{
		cur = m_YParamComboCtrl.GetCurSel();
		if(cur>-1)
			pYParam = (CReportParam*)m_YParamComboCtrl.GetItemData(cur);
		if(pYParam==NULL)
		{
			AfxMessageBox(APL_T("  ,    Y!"), MB_ICONINFORMATION|MB_OK);
			return false;
		}
	}

	return true;
}
