#include "stdafx.h"
#include "ReportDict.h"

CDiagramItem::CDiagramItem(CaplReportMgr *ReportMgr)
{
	ASSERT(ReportMgr);

	m_ReportMgr = ReportMgr;

	m_line_width = AfxGetApp()->GetProfileInt(_T("DefaultSettings"), _T("LineWidth"), 1);
	m_color = 0;
	m_pDSColumn = NULL;
	
	m_inst = NULL;
}

CDiagramItem::~CDiagramItem()
{
}

void CDiagramItem::Update(bool set)
{
	if(m_ReportMgr==NULL) return;

	if(set) //
	{
		if(m_inst==NULL)
			m_inst = m_ReportMgr->m_data->CreateInstance(m_ReportMgr->e_apl_diagram_item);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_diagram_item_color, (int)m_color);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_diagram_item_line_width, m_line_width);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_diagram_item_show_mode, m_show_mode);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_diagram_item_title, m_name);
		if(m_pDSColumn)
		{
			if(m_pDSColumn->m_inst==NULL)
			{
				m_ReportMgr->m_base_query->Update(true);
				m_ReportMgr->m_header->Update(true);
			}
			m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_diagram_item_ds_column, m_pDSColumn->m_inst);
		}
		else
			m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_diagram_item_ds_column, (CaplInstance*)NULL);
	}
	else
	{
		if(m_inst==NULL) return;
		int tmpInt;
		CaplInstance *Inst;
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_diagram_item_color, tmpInt);
		m_color = (COLORREF)tmpInt;
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_diagram_item_line_width, m_line_width);
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_diagram_item_show_mode, tmpInt);
		m_show_mode = (TShowValueType)tmpInt;
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_diagram_item_ds_column, Inst);
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_diagram_item_title, m_name);
		if(Inst)
		{
			m_pDSColumn = m_ReportMgr->FindColumnByInst(Inst);
			if(m_pDSColumn==NULL)
				TRACE_TO_FILE(APL_T("      c !"));
		}
	}
}

bool CDiagramItem::LoadDataFromMem(BYTE *pByte, int &ind)
{
	return true;
}

void CDiagramItem::CopyToMem(BYTE* pByte, int &ind)
{

}

int CDiagramItem::GetMemSize()
{
	return 0;
}

void CDiagramItem::Delete()
{
	if(m_inst==NULL) return;
	if(m_ReportMgr==NULL) return;

	m_ReportMgr->m_data->DeleteInstance(m_inst);
}

CString CDiagramItem::GetColumnName()
{
	CString buf;
	buf.Empty();
	if(m_show_mode==aplShowCount)
		buf = _T("_Count");
	else if(m_show_mode==aplShowSumm)
		buf = _T("_Summ");
	else if(m_show_mode==aplShowAverage)
		buf = _T("_Average");
	return m_pDSColumn->GetName()+buf;
}

bool CDiagramItem::NeedDraw(CDataSource *pDataSource)
{
	int ind(pDataSource->GetHeader()->Find(GetColumnName()));
	if(ind<0) false;

	int rows(pDataSource->GetRows());
	CString sTmpVal;
	int start_ind=0;
	do 
	{
		pDataSource->GetAt(start_ind++, ind, sTmpVal);
		if(!sTmpVal.IsEmpty()) return true;
	}while(start_ind<rows);

	return !m_name.IsEmpty();
}