// PapamPropDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "PapamPropDlg.h"
#include "ReportDict.h"
#include <AplGuiEx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CParamPropDlg dialog


CParamPropDlg::CParamPropDlg(CaplReportMgr *ReportMgr, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CParamPropDlg::IDD, pParent)
{
	ASSERT(ReportMgr);
	m_ReportMgr = ReportMgr;
	//{{AFX_DATA_INIT(CParamPropDlg)
	m_name = _T("");
	m_type = 0;
	//}}AFX_DATA_INIT
	m_param = NULL;
}


void CParamPropDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CParamPropDlg)
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Text(pDX, IDC_NAME, m_name);
	DDX_CBIndex(pDX, IDC_TYPE, m_type);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CParamPropDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CParamPropDlg)
	ON_COMMAND(IDOK,OnOK)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CParamPropDlg message handlers

BOOL CParamPropDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_ok_btn.SetIcon(aplGetStdIco16(APL_STD_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(aplGetStdIco16(APL_STD_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	if(m_param!=NULL)
	{
		m_name = m_param->m_name;
		m_type = m_param->GetType();
	}
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CParamPropDlg::OnOK()
{
	if(!UpdateData()) return;

	if(!m_ReportMgr->m_data_source.m_params.IsUnique(m_name,m_param)) 
	{
		AfxMessageBox(APL_T("   ."),MB_OK|MB_ICONINFORMATION);
		return;
	}

	if(m_param==NULL)
	{
		m_param = new CReportParam(m_ReportMgr);
	}
	m_param->m_name = m_name;
	m_param->SetType((TParamTypes)m_type);

	CaplTranslateDialog::OnOK();
}