// ReportDict.cpp: implementation of the CaplReportMgr class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <WinSpool.h>
#include "ReportDict.h"
#include "resource.h"
#include "CommonQuery.h"
#include "PapamPropDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CaplReportMgr::CaplReportMgr()
{
	m_data = NULL;
	m_base_query = new CHeader(this);//  
	m_header = new CHeader(this, false);//  
	ASSERT(m_header);
	ASSERT(m_base_query);
	m_dot_sheet = NULL;
	m_pReport = NULL;
	m_TableContents.RemoveAll();
	
	m_bFillBackground = false;
	m_bReportOneSheetOnly = false;
	m_bMergeMultiRow = false;
	m_bFitToPage = true;

	m_nLastReportRow = -1;

	Gdiplus::GdiplusStartup(&m_gdiplusToken, &m_gdiplusStartupInput, NULL);
}

CaplReportMgr::~CaplReportMgr()
{
	Detach();

	Gdiplus::GdiplusShutdown(m_gdiplusToken);
}

void CaplReportMgr::Detach()
{
	if(m_data)//  
	{
		RemoveAllSheets();
	}

	int cnt = m_TableContents.GetSize();
	for(int i=0; i<cnt; i++)
		delete m_TableContents.GetAt(i);
	m_TableContents.RemoveAll();

	if(m_header)
	{
		m_header->RemoveAll();
		DELETE_OBJECT(m_header);
	}
	if(m_base_query) 
	{
		m_base_query->RemoveAll();
		DELETE_OBJECT(m_base_query);
	}

	m_header = NULL;
	m_base_query = NULL;

	m_data = NULL;
	m_pReport = NULL;

	e_apl_condition = NULL;
	a_apl_condition_type = NULL;
	a_apl_condition_ds_column = NULL;
	a_apl_condition_value_type = NULL;
	a_apl_condition_value = NULL;

	e_apl_select = NULL; 
	a_apl_sel_cols = NULL;
	e_apl_result_select = NULL;
	a_apl_res_sel_cols = NULL;

	e_apl_data_src_col = NULL;
	a_apl_col_name = NULL;
	a_apl_col_type = NULL;
	a_apl_col_type_col = NULL;

	e_apl_report = NULL;
	a_apl_report_fit_to_page = NULL;
	a_rep_name = NULL;
	a_rep_version = NULL;
	a_rep_sheets = NULL;
	a_rep_params = NULL;
	a_rep_mode = NULL;
	a_apl_report_def_ro_access = NULL;
	a_rep_binding = NULL;


	e_apl_report_sheet = NULL;
	a_apl_report_sheet_top_offset = NULL;
	a_apl_report_sheet_bottom_offset = NULL;
	a_apl_report_sheet_left_offset = NULL;
	a_apl_report_sheet_right_offset = NULL;
	e_report_sheet_elem = NULL;

	e_report_rect = NULL;
	e_report_line = NULL;

	a_rect_elem_flags = NULL;
	
	e_report_section = NULL;
	a_apl_rep_section_conditions = NULL;
	a_apl_rep_section_show_es = NULL;

	e_report_table = NULL;

	e_report_map = NULL;
	a_map_src = NULL;

	e_apl_point = NULL;
	a_point_x = NULL;
	a_point_y = NULL;

	a_rep_sheet_type = NULL;
	a_rep_sheet_els = NULL;

	a_elem_name  = NULL;
	a_elem_org_pt  = NULL;
	a_elem_size = NULL;
	a_elem_text_val = NULL;
	a_elem_line_width = NULL;
	a_elem_fixed = NULL;
	a_elem_dsfcol = NULL;
	a_elem_dsfrow = NULL;
	a_elem_textcolor = NULL;
	a_elem_backgroundcolor = NULL;
	a_elem_create_tc = NULL;
	a_elem_flags = NULL;
	a_elem_id = NULL;
	
	e_param = NULL;
	a_param_name = NULL;
	a_param_type = NULL;
	a_param_expr = NULL;
	a_param_parent = NULL;
	a_param_inst_type = NULL;
	a_param_value = NULL;

	e_apl_column = NULL;
	a_apl_column_name = NULL;
	a_apl_column_width = NULL;
	a_apl_column_ds_col = NULL;
	a_apl_column_align = NULL;
	a_apl_column_border = NULL;
	a_apl_column_level = NULL;
	a_apl_column_type = NULL;
	a_apl_column_text_const = NULL;
	a_apl_column_rows = NULL;
	a_apl_column_space_para = NULL;
	a_apl_column_fit_text = NULL;
	a_apl_column_height = NULL;
	a_apl_column_params = NULL;
	a_apl_column_condition = NULL;

	e_level = NULL;
	a_level_name = NULL;
	a_level_cols = NULL;
	a_level_flag = NULL;
	a_level_height = NULL;
	a_level_spacepara = NULL;
	a_level_min_rows = NULL;
	a_level_row_color = NULL;

	a_section_data_src = NULL;
	a_section_data_rel = NULL;
	a_section_name = NULL;
	a_section_title = NULL;
	a_section_row_height = NULL;
	a_section_title_height = NULL;
	a_section_title_col = NULL;
	a_section_levels = NULL;
	a_section_sort = NULL;
	a_section_groups = NULL;
	a_section_title_font = NULL;

	a_table_sections = NULL;
	a_table_row_height = NULL;
	a_table_row_font = NULL;

	e_font = NULL;
	a_font_name = NULL;
	a_font_height = NULL;
	a_font_weight = NULL;
	a_font_italic = NULL;
	a_font_charset = NULL;
	a_font_strikeout =  NULL;
	a_font_underline =  NULL;

	e_value = NULL;
	a_val_inst = NULL;
	a_val_type = NULL;
	a_val_text = NULL;
	a_val_orient = NULL;
	a_val_font = NULL;
	a_val_color = NULL;
	a_val_align = NULL;
	a_val_border_state = NULL;
	a_val_space_para = NULL;
	a_val_text_params = NULL;

	e_apl_group_col = NULL;
	a_apl_gr_font = NULL;
	a_apl_gr_col = NULL;
	a_apl_gr_sortasstring = NULL;
	a_apl_gr_flags = NULL;
	a_apl_gr_row = NULL;
	a_apl_gr_last_row = NULL;
	a_apl_gr_one_row = NULL;
	a_apl_gr_show_fr = NULL;
	a_apl_gr_conditions = NULL;

	e_apl_rect = NULL;
	a_apl_rect_top = NULL;
	a_apl_rect_left = NULL;
	a_apl_rect_bottom = NULL;
	a_apl_rect_right = NULL;

	e_apl_user = NULL;
	a_apl_user_name = NULL;
	a_apl_user_password = NULL;
	a_apl_user_access_mode = NULL;

	e_apl_table_content	= NULL;
	a_apl_tc_sheets				= NULL;
	a_apl_tc_childs				= NULL;
	a_apl_tc_title				= NULL;

	e_apl_table_content_title	= NULL;
	a_apl_tct_levels			= NULL;

	e_apl_table_content_title_level	= NULL;
	a_apl_tctl_paradelta			=  NULL;
	a_apl_tctl_font				= NULL;

	e_apl_table_content_element	= NULL;
	a_apl_tce_tct = NULL;
	a_apl_tce_title	= NULL;
	a_apl_tce_font = NULL;
	a_apl_tce_pWidth = NULL;
	a_apl_tce_pTWidth = NULL;
	a_apl_tce_height = NULL;
	
	a_apl_gr_name = NULL;
	a_apl_gr_sort_direction = NULL;

	e_apl_sort_column = NULL;
	a_apl_sc_column = NULL;
	a_apl_sc_sort_as_string = NULL;
	a_apl_sc_sort_direction = NULL;

	e_report_pic = NULL;
	a_pic_picture = NULL;
	a_pic_mode = NULL;

	e_apl_reference_element = NULL;
	a_apl_ref_elem_element =NULL;

	e_apl_diagram_element = NULL;
	a_apl_diagram_element_elements = NULL;
	a_apl_diagram_element_xline = NULL;
	a_apl_diagram_element_yline = NULL;
	a_apl_diagram_element_legend = NULL;
	a_apl_diagram_element_group_column = NULL;
	a_apl_diagram_element_data_source = NULL;
	a_apl_diagram_element_sort_type = NULL;
	
	e_apl_diagram_item = NULL;
	a_apl_diagram_item_title = NULL;
	a_apl_diagram_item_color = NULL;
	a_apl_diagram_item_line_width = NULL;
	a_apl_diagram_item_ds_column = NULL;
	a_apl_diagram_item_show_mode = NULL;
	
	e_apl_legend = NULL;
	a_apl_legend_position = NULL;
	a_apl_legend_mode = NULL;
	a_apl_legend_font = NULL;
	a_apl_legend_font_color = NULL;
	
	e_apl_gistogram_element = NULL;
	a_apl_gistogram_element_legend = NULL;
	a_apl_gistogram_element_elements = NULL;
	a_apl_gistogram_element_xline = NULL;
	a_apl_gistogram_element_yline = NULL;
	a_apl_gistogram_element_group_column = NULL;
	a_apl_gistogram_element_data_source = NULL;
	a_apl_gistogram_element_volume = NULL;
	a_apl_gistogram_element_angel = NULL;
	a_apl_gistogram_element_sort_type = NULL;
	a_apl_gistogram_element_view_type = NULL;

	e_apl_coordinate_line = NULL;
	a_apl_coordinate_line_name = NULL;
	a_apl_coordinate_line_line_width = NULL;
	a_apl_coordinate_line_line_color = NULL;
	a_apl_coordinate_line_font = NULL;
	a_apl_coordinate_line_font_color = NULL;
	a_apl_coordinate_line_parametr = NULL;
	a_apl_coordinate_line_ds_column = NULL;
	a_apl_coordinate_line_lines_color = NULL;
	a_apl_coordinate_line_flags = NULL;

	e_apl_data_source = NULL;
	a_apl_ds_columns = NULL;
	
	e_apl_data_source_column = NULL;
	a_apl_ds_column_name = NULL;
	a_apl_ds_column_values = NULL;
	
	e_apl_data_source_real_value = NULL;
	a_apl_dsrv_value = NULL;
	e_apl_data_source_string_value = NULL;
	a_apl_dssv_value = NULL;
}

void CaplReportMgr::Attach(CaplStepDataWithFile *data, LPCTSTR dict_path)
{
	if(!data)
		return;

	m_dict_path = dict_path;
	m_data = data;

	if(m_base_query==NULL)
		m_base_query = new CHeader(this);//  
	else
		m_base_query->RemoveAll();
	if(m_header==NULL)
		m_header = new CHeader(this, false);//  
	else
		m_header->RemoveAll();

	e_apl_condition = data->GetEntityBN(_T("apl_condition"));
	a_apl_condition_type = data->GetAttrDefinition(e_apl_condition,_T("type"));
	a_apl_condition_ds_column = data->GetAttrDefinition(e_apl_condition,_T("column"));
	a_apl_condition_value_type = data->GetAttrDefinition(e_apl_condition,_T("value_type"));
	a_apl_condition_value = data->GetAttrDefinition(e_apl_condition,_T("value"));

	e_apl_select = data->GetEntityBN(_T("apl_select")); 
	a_apl_sel_cols = data->GetAttrDefinition(e_apl_select,_T("column"));
	e_apl_result_select = data->GetEntityBN(_T("apl_result_select")); 
	a_apl_res_sel_cols = data->GetAttrDefinition(e_apl_result_select,_T("column"));

	e_apl_data_src_col = data->GetEntityBN(_T("apl_col"));
	a_apl_col_name = data->GetAttrDefinition(e_apl_data_src_col,_T("name"));
	a_apl_col_type = data->GetAttrDefinition(e_apl_data_src_col,_T("type"));
	a_apl_col_type_col = data->GetAttrDefinition(e_apl_data_src_col,_T("col_type"));

	e_apl_report = data->GetEntityBN(_T("apl_report"));
	a_apl_report_fit_to_page = data->GetAttrDefinition(e_apl_report,_T("fit_to_page"));
	a_rep_name = data->GetAttrDefinition(e_apl_report,_T("name"));
	a_rep_version = data->GetAttrDefinition(e_apl_report,_T("version"));
	a_rep_sheets = data->GetAttrDefinition(e_apl_report,_T("sheets"));
	a_rep_params = data->GetAttrDefinition(e_apl_report,_T("params"));
	a_rep_mode = data->GetAttrDefinition(e_apl_report,_T("mode"));
	a_apl_report_def_ro_access = data->GetAttrDefinition(e_apl_report, _T("def_ro_access"));
	a_rep_binding = data->GetAttrDefinition(e_apl_report,_T("binding"));

	e_apl_report_sheet = data->GetEntityBN(_T("apl_report_sheet"));
	a_apl_report_sheet_top_offset = data->GetAttrDefinition(e_apl_report_sheet, _T("top_offset"));
	a_apl_report_sheet_bottom_offset = data->GetAttrDefinition(e_apl_report_sheet, _T("bottom_offset"));
	a_apl_report_sheet_left_offset = data->GetAttrDefinition(e_apl_report_sheet, _T("left_offset"));
	a_apl_report_sheet_right_offset = data->GetAttrDefinition(e_apl_report_sheet, _T("right_offset"));

	e_report_sheet_elem = data->GetEntityBN(_T("apl_report_sheet_element"));

	e_report_rect = data->GetEntityBN(_T("apl_report_rect"));
	e_report_line = data->GetEntityBN(_T("apl_report_line"));	
	e_report_table = data->GetEntityBN(_T("apl_report_table"));

	a_rect_elem_flags = data->GetAttrDefinition(e_report_rect,_T("flags_ex"));
	
	e_report_section = data->GetEntityBN(_T("apl_report_section"));
	a_apl_rep_section_conditions = data->GetAttrDefinition(e_report_section,_T("conditions"));
	a_apl_rep_section_show_es = data->GetAttrDefinition(e_report_section,_T("show_es"));

	e_report_map = data->GetEntityBN(_T("apl_report_map"));
	a_map_src = data->GetAttrDefinition(e_report_map,_T("src"));

	e_apl_point = data->GetEntityBN(_T("apl_point"));
	a_point_x = data->GetAttrDefinition(e_apl_point,_T("x"));
	a_point_y = data->GetAttrDefinition(e_apl_point,_T("y"));

	a_rep_sheet_type = data->GetAttrDefinition(e_apl_report_sheet,_T("type"));
	a_rep_sheet_els = data->GetAttrDefinition(e_apl_report_sheet,_T("elems"));

	a_elem_name  = data->GetAttrDefinition(e_report_sheet_elem,_T("name"));
	a_elem_org_pt  = data->GetAttrDefinition(e_report_sheet_elem,_T("org_pt"));
	a_elem_size = data->GetAttrDefinition(e_report_sheet_elem,_T("size"));
	a_elem_text_val = data->GetAttrDefinition(e_report_sheet_elem,_T("text_value"));
	a_elem_line_width = data->GetAttrDefinition(e_report_sheet_elem,_T("line_width"));
	a_elem_fixed = data->GetAttrDefinition(e_report_sheet_elem,_T("fixed"));
	a_elem_dsfcol = data->GetAttrDefinition(e_report_sheet_elem,_T("dsf_col"));
	a_elem_dsfrow = data->GetAttrDefinition(e_report_sheet_elem,_T("dsf_row"));
	a_elem_textcolor = data->GetAttrDefinition(e_report_sheet_elem,_T("text_color"));
	a_elem_backgroundcolor = data->GetAttrDefinition(e_report_sheet_elem,_T("background_color"));
	a_elem_create_tc = data->GetAttrDefinition(e_report_sheet_elem,_T("create_tc"));
	a_elem_flags = data->GetAttrDefinition(e_report_sheet_elem,_T("flags"));
	a_elem_id = data->GetAttrDefinition(e_report_sheet_elem, _T("id"));
	
	e_param = data->GetEntityBN(_T("apl_report_param"));
	a_param_name = data->GetAttrDefinition(e_param, _T("name"));
	a_param_type = data->GetAttrDefinition(e_param, _T("type"));
	a_param_expr = data->GetAttrDefinition(e_param, _T("expr"));
	a_param_parent = data->GetAttrDefinition(e_param, _T("parent"));
	a_param_inst_type = data->GetAttrDefinition(e_param, _T("inst_type"));
	a_param_value = data->GetAttrDefinition(e_param, _T("value"));


	e_apl_column = data->GetEntityBN(_T("apl_column"));
	a_apl_column_name = data->GetAttrDefinition(e_apl_column,_T("name"));
	a_apl_column_width = data->GetAttrDefinition(e_apl_column,_T("width"));
	a_apl_column_ds_col = data->GetAttrDefinition(e_apl_column,_T("query_column"));
	a_apl_column_fit_text = data->GetAttrDefinition(e_apl_column,_T("fit_text"));
	a_apl_column_align = data->GetAttrDefinition(e_apl_column,_T("align"));
	a_apl_column_border = data->GetAttrDefinition(e_apl_column,_T("border"));
	a_apl_column_level = data->GetAttrDefinition(e_apl_column,_T("level"));
	a_apl_column_type = data->GetAttrDefinition(e_apl_column,_T("type"));
	a_apl_column_text_const = data->GetAttrDefinition(e_apl_column,_T("text_const"));
	a_apl_column_rows = data->GetAttrDefinition(e_apl_column,_T("rows_count"));
	a_apl_column_space_para = data->GetAttrDefinition(e_apl_column, _T("space_para"));
	a_apl_column_params = data->GetAttrDefinition(e_apl_column, _T("params"));
	a_apl_column_condition = data->GetAttrDefinition(e_apl_column, _T("condition"));

	e_level = data->GetEntityBN(_T("apl_level"));
	a_level_name = data->GetAttrDefinition(e_level,_T("name"));
	a_level_cols = data->GetAttrDefinition(e_level,_T("cols"));
	a_level_flag = data->GetAttrDefinition(e_level,_T("flag"));
	a_level_height = data->GetAttrDefinition(e_level,_T("height"));
	a_level_spacepara = data->GetAttrDefinition(e_level,_T("space_para"));
	a_level_min_rows = data->GetAttrDefinition(e_level,_T("min_rows"));
	a_level_row_color = data->GetAttrDefinition(e_level,_T("row_color"));

	a_section_data_src = data->GetAttrDefinition(e_report_section,_T("data_src"));
	a_section_data_rel = data->GetAttrDefinition(e_report_section,_T("data_rel"));
	a_section_name = data->GetAttrDefinition(e_report_section,_T("name"));
	a_section_title = data->GetAttrDefinition(e_report_section,_T("title"));
	a_section_row_height = data->GetAttrDefinition(e_report_section,_T("row_height"));
	a_section_title_height = data->GetAttrDefinition(e_report_section,_T("title_height"));
	a_section_title_col = data->GetAttrDefinition(e_report_section,_T("title_col"));
	a_section_levels = data->GetAttrDefinition(e_report_section,_T("levels"));
	a_section_sort = data->GetAttrDefinition(e_report_section,_T("sorts"));
	a_section_groups = data->GetAttrDefinition(e_report_section,_T("groups"));

	a_table_sections = data->GetAttrDefinition(e_report_table,_T("sections"));
	a_table_row_height = data->GetAttrDefinition(e_report_table,_T("row_height"));
	a_table_row_font = data->GetAttrDefinition(e_report_table,_T("row_font")); 

	e_font = data->GetEntityBN(_T("apl_font"));
	a_font_name = data->GetAttrDefinition(e_font, _T("font_name"));
	a_font_height = data->GetAttrDefinition(e_font, _T("height"));
	a_font_weight = data->GetAttrDefinition(e_font, _T("weight"));
	a_font_italic = data->GetAttrDefinition(e_font, _T("italic"));
	a_font_charset = data->GetAttrDefinition(e_font, _T("char_set"));
	a_font_strikeout =  data->GetAttrDefinition(e_font, _T("strikeout"));
	a_font_underline =  data->GetAttrDefinition(e_font, _T("underline"));

	e_value = data->GetEntityBN(_T("apl_value"));
	a_val_inst = data->GetAttrDefinition(e_value,_T("inst"));
	a_val_type = data->GetAttrDefinition(e_value,_T("type"));
	a_val_text = data->GetAttrDefinition(e_value,_T("text"));
	a_val_orient = data->GetAttrDefinition(e_value,_T("orient"));
	a_val_font = data->GetAttrDefinition(e_value,_T("font"));
	a_val_color = data->GetAttrDefinition(e_value,_T("color"));
	a_val_align = data->GetAttrDefinition(e_value,_T("align"));
	a_val_border_state = data->GetAttrDefinition(e_value,_T("border"));
	a_val_text_params = data->GetAttrDefinition(e_value,_T("text_params"));
	a_val_space_para = data->GetAttrDefinition(e_value, _T("space_para"));

	e_report_pic = data->GetEntityBN(_T("apl_report_pic"));
	a_pic_picture = data->GetAttrDefinition(e_report_pic,_T("picture"));
	a_pic_mode = data->GetAttrDefinition(e_report_pic,_T("draw_mode"));
	
	e_apl_group_col = data->GetEntityBN(_T("apl_group_col"));
	a_apl_gr_font = data->GetAttrDefinition(e_apl_group_col,_T("font"));
	a_apl_gr_sortasstring = data->GetAttrDefinition(e_apl_group_col,_T("paragraph"));
	a_apl_gr_col = data->GetAttrDefinition(e_apl_group_col,_T("column"));
	a_apl_gr_row = data->GetAttrDefinition(e_apl_group_col,_T("row"));
	a_apl_gr_last_row = data->GetAttrDefinition(e_apl_group_col,_T("last_row"));
	a_apl_gr_one_row = data->GetAttrDefinition(e_apl_group_col,_T("one_row"));
	a_apl_gr_show_fr = data->GetAttrDefinition(e_apl_group_col,_T("show_fr"));
	a_apl_gr_conditions = data->GetAttrDefinition(e_apl_group_col,_T("conditions"));
	a_apl_gr_name = data->GetAttrDefinition(e_apl_group_col,_T("name"));
	a_apl_gr_sort_direction = data->GetAttrDefinition(e_apl_group_col,_T("sort_direction"));
	a_apl_gr_flags = data->GetAttrDefinition(e_apl_group_col, _T("flags"));

	e_apl_rect = data->GetEntityBN(_T("apl_rect"));
	a_apl_rect_top = data->GetAttrDefinition(e_apl_rect,_T("top"));
	a_apl_rect_left = data->GetAttrDefinition(e_apl_rect,_T("left"));
	a_apl_rect_bottom = data->GetAttrDefinition(e_apl_rect,_T("bottom"));
	a_apl_rect_right = data->GetAttrDefinition(e_apl_rect,_T("right"));
	
	e_apl_user =				data->GetEntityBN(_T("apl_user"));
	a_apl_user_name =			data->GetAttrDefinition(e_apl_user, _T("name"));
	a_apl_user_password =		data->GetAttrDefinition(e_apl_user, _T("password"));
	a_apl_user_access_mode =	data->GetAttrDefinition(e_apl_user, _T("access_mode"));

	e_apl_table_content			= data->GetEntityBN(_T("apl_table_content"));
	a_apl_tc_sheets				= data->GetAttrDefinition(e_apl_table_content, _T("sheets"));
	a_apl_tc_childs				= data->GetAttrDefinition(e_apl_table_content, _T("childs"));
	a_apl_tc_title				= data->GetAttrDefinition(e_apl_table_content, _T("title"));

	e_apl_table_content_title	= data->GetEntityBN(_T("apl_table_content_title"));
	a_apl_tct_levels			= data->GetAttrDefinition(e_apl_table_content_title, _T("levels"));

	e_apl_table_content_title_level	= data->GetEntityBN(_T("apl_table_content_title_level"));
	a_apl_tctl_paradelta			= data->GetAttrDefinition(e_apl_table_content_title_level, _T("para_delta"));
	a_apl_tctl_font				= data->GetAttrDefinition(e_apl_table_content_title_level, _T("font"));

	e_apl_table_content_element	= data->GetEntityBN(_T("apl_table_content_element"));
	a_apl_tce_tct				= data->GetAttrDefinition(e_apl_table_content_element, _T("table_content_title"));
	a_apl_tce_pWidth			= data->GetAttrDefinition(e_apl_table_content_element, _T("width"));
	a_apl_tce_title				= data->GetAttrDefinition(e_apl_table_content_element, _T("title"));
	a_apl_tce_font				= data->GetAttrDefinition(e_apl_table_content_element, _T("font"));
	a_apl_tce_pTWidth			= data->GetAttrDefinition(e_apl_table_content_element, _T("text_width"));
	a_apl_tce_height			= data->GetAttrDefinition(e_apl_table_content_element, _T("height"));

	e_apl_reference_element = data->GetEntityBN(_T("apl_reference_element"));
	a_apl_ref_elem_element = data->GetAttrDefinition(e_apl_reference_element, _T("element"));

	e_apl_sort_column				= data->GetEntityBN(_T("apl_sort_column"));
	a_apl_sc_column					= data->GetAttrDefinition(e_apl_sort_column, _T("column"));
	a_apl_sc_sort_as_string			= data->GetAttrDefinition(e_apl_sort_column, _T("sort_as_string"));
	a_apl_sc_sort_direction			= data->GetAttrDefinition(e_apl_sort_column, _T("sort_direction"));

	e_apl_diagram_element				= data->GetEntityBN(_T("apl_diagram_element"));
	a_apl_diagram_element_elements		= data->GetAttrDefinition(e_apl_diagram_element, _T("elements"));
	a_apl_diagram_element_xline			= data->GetAttrDefinition(e_apl_diagram_element, _T("x_line"));
	a_apl_diagram_element_yline			= data->GetAttrDefinition(e_apl_diagram_element, _T("y_line"));
	a_apl_diagram_element_legend		= data->GetAttrDefinition(e_apl_diagram_element, _T("legend"));
	a_apl_diagram_element_group_column	= data->GetAttrDefinition(e_apl_diagram_element, _T("group_column"));
	a_apl_diagram_element_data_source	= data->GetAttrDefinition(e_apl_diagram_element, _T("data_source"));
	a_apl_diagram_element_sort_type		= data->GetAttrDefinition(e_apl_diagram_element, _T("sort_type"));
	
	e_apl_diagram_item				= data->GetEntityBN(_T("apl_diagram_item"));
	a_apl_diagram_item_title		= data->GetAttrDefinition(e_apl_diagram_item, _T("title"));
	a_apl_diagram_item_color		= data->GetAttrDefinition(e_apl_diagram_item, _T("color"));
	a_apl_diagram_item_line_width	= data->GetAttrDefinition(e_apl_diagram_item, _T("line_width"));
	a_apl_diagram_item_ds_column	= data->GetAttrDefinition(e_apl_diagram_item, _T("data_source_column"));
	a_apl_diagram_item_show_mode	= data->GetAttrDefinition(e_apl_diagram_item, _T("show_mode"));
	
	e_apl_legend					= data->GetEntityBN(_T("apl_legend"));
	a_apl_legend_position			= data->GetAttrDefinition(e_apl_legend, _T("position"));
	a_apl_legend_mode				= data->GetAttrDefinition(e_apl_legend, _T("mode"));
	a_apl_legend_font				= data->GetAttrDefinition(e_apl_legend, _T("font"));
	a_apl_legend_font_color			= data->GetAttrDefinition(e_apl_legend, _T("text_color"));
	
	e_apl_gistogram_element					= data->GetEntityBN(_T("apl_gistogram_element"));
	a_apl_gistogram_element_legend			= data->GetAttrDefinition(e_apl_gistogram_element, _T("legend"));
	a_apl_gistogram_element_elements		= data->GetAttrDefinition(e_apl_gistogram_element, _T("elements"));
	a_apl_gistogram_element_xline			= data->GetAttrDefinition(e_apl_gistogram_element, _T("x_line"));
	a_apl_gistogram_element_yline			= data->GetAttrDefinition(e_apl_gistogram_element, _T("y_line"));
	a_apl_gistogram_element_group_column	= data->GetAttrDefinition(e_apl_gistogram_element, _T("group_col"));
	a_apl_gistogram_element_data_source		= data->GetAttrDefinition(e_apl_gistogram_element, _T("data_source"));
	a_apl_gistogram_element_volume			= data->GetAttrDefinition(e_apl_gistogram_element, _T("volume"));
	a_apl_gistogram_element_angel			= data->GetAttrDefinition(e_apl_gistogram_element, _T("angel"));
	a_apl_gistogram_element_sort_type		= data->GetAttrDefinition(e_apl_gistogram_element, _T("sort_type"));
	a_apl_gistogram_element_view_type		= data->GetAttrDefinition(e_apl_gistogram_element, _T("view_type"));

	e_apl_coordinate_line				= data->GetEntityBN(_T("apl_coordinate_line"));
	a_apl_coordinate_line_name			= data->GetAttrDefinition(e_apl_coordinate_line, _T("name"));
	a_apl_coordinate_line_line_width	= data->GetAttrDefinition(e_apl_coordinate_line, _T("line_width"));
	a_apl_coordinate_line_line_color	= data->GetAttrDefinition(e_apl_coordinate_line, _T("line_color"));
	a_apl_coordinate_line_font			= data->GetAttrDefinition(e_apl_coordinate_line, _T("font"));
	a_apl_coordinate_line_font_color	= data->GetAttrDefinition(e_apl_coordinate_line, _T("font_color"));
	a_apl_coordinate_line_parametr		= data->GetAttrDefinition(e_apl_coordinate_line, _T("parametr"));
	a_apl_coordinate_line_ds_column		= data->GetAttrDefinition(e_apl_coordinate_line, _T("ds_column"));
	a_apl_coordinate_line_lines_color	= data->GetAttrDefinition(e_apl_coordinate_line, _T("lines_color"));
	a_apl_coordinate_line_flags			= data->GetAttrDefinition(e_apl_coordinate_line, _T("flags"));

	e_apl_data_source					= data->GetEntityBN(_T("apl_data_source"));
	a_apl_ds_columns					= data->GetAttrDefinition(e_apl_data_source, _T("columns"));
	
	e_apl_data_source_column			= data->GetEntityBN(_T("apl_ds_column"));
	a_apl_ds_column_name				= data->GetAttrDefinition(e_apl_data_source_column, _T("name"));
	a_apl_ds_column_values				= data->GetAttrDefinition(e_apl_data_source_column, _T("values"));
	
	e_apl_data_source_real_value		= data->GetEntityBN(_T("apl_real_value"));
	a_apl_dsrv_value					= data->GetAttrDefinition(e_apl_data_source_real_value, _T("value"));
	e_apl_data_source_string_value		= data->GetEntityBN(_T("apl_string_value"));
	a_apl_dssv_value					= data->GetAttrDefinition(e_apl_data_source_string_value, _T("value"));
}

int CaplReportMgr::PutPoint(CaplInstance *inst,CaplAttr *attr, CPoint pt)
{
	CaplInstance * pt_inst = NULL;
	m_data->GetAttr(inst,attr,pt_inst);
	if(!pt_inst)
	{
		pt_inst = m_data->CreateInstance(e_apl_point);
		m_data->PutAttr(pt_inst,a_point_x,pt.x);
		m_data->PutAttr(pt_inst,a_point_y,pt.y);
	}
	else
	{
		m_data->PutAttr(pt_inst,a_point_x,pt.x);
		m_data->PutAttr(pt_inst,a_point_y,pt.y);
	}
	m_data->PutAttr(inst,attr,pt_inst);
	return true;
}


int CaplReportMgr::GetPoint(CaplInstance *inst, CaplAttr *attr, CPoint &pt)
{
	CaplInstance * pt_inst = NULL;
	int tmp;

	m_data->GetAttr(inst,attr,pt_inst);
	if(!pt_inst) 
	{
		pt = CPoint(0,0);
		return false;
	}

	m_data->GetAttr(pt_inst,a_point_x,tmp);
	pt.x = tmp;
	m_data->GetAttr(pt_inst,a_point_y,tmp);
	pt.y = tmp;

	return true;

}

CReportElement * CaplReportMgr::CreateElemObj(CaplInstance *inst,CReportSheet* owner_sheet)
{
	if(inst==0) return NULL;
	CString str;
	CPoint pt;
	
	ASSERT(owner_sheet);
	
	CReportElement * elem = NULL;
		
	if(inst->GetType() == e_report_table)
	{
		int cnt = m_tables.GetSize();
		for(int i=0; i<cnt;i++)
			if(m_tables.GetAt(i)->m_inst==inst) 
			{
				if(owner_sheet!=0)
					owner_sheet->Add(m_tables.GetAt(i));
				return m_tables.GetAt(i);
			}
		elem = new CTableElement(this);
		m_tables.Add((CTableElement*)elem);
	}
	else if(inst->GetType() == e_report_map)
		elem = new CTableMapElement(this);
	else if(inst->GetType() == e_report_pic)
		elem = new CPictureElement(this);
	else if(inst->GetType() == e_apl_table_content_element)
		elem = new CTableContentElement(this);
	else if(inst->GetType() == e_apl_reference_element)
		elem = new CPageReferenceElement(this);
	else if(inst->GetType() == e_apl_diagram_element)
		elem = new CDiagramElement(this);
	else if(inst->GetType() == e_apl_gistogram_element)
		elem = new CGistogramElement(this);
	else
	{
		if(inst->GetType() == e_report_line)
			elem = new CLineReportElement(this);
		else if(inst->GetType() == e_report_rect)
			elem = new CRectReportElement(this);
	}
	elem->m_inst = inst;	
	owner_sheet->Add(elem);

	return elem;
}

void CaplReportMgr::GetFontValue(CaplInstance *font_inst, LOGFONT &lf)
{
	lf = GetFontValue(font_inst);
}

void CaplReportMgr::SetFontValue(CaplInstance *inst, LOGFONT lf)
{
	m_data->PutAttr(inst,a_font_charset,lf.lfCharSet);
	m_data->PutAttr(inst,a_font_name,lf.lfFaceName);
	m_data->PutAttr(inst,a_font_height,lf.lfHeight);
	m_data->PutAttr(inst,a_font_weight,lf.lfWeight);
	m_data->PutAttr(inst,a_font_italic,lf.lfItalic);
	m_data->PutAttr(inst,a_font_strikeout,lf.lfStrikeOut);
	m_data->PutAttr(inst,a_font_underline,lf.lfUnderline);
}

LOGFONT CaplReportMgr::GetFontValue(CaplInstance* inst)
{
	LOGFONT lf;
	memset(&lf,0,sizeof(LOGFONT));
	int tmp;
	CString str;
	m_data->GetAttr(inst,a_font_charset,tmp);
	lf.lfCharSet = tmp;
	m_data->GetAttr(inst,a_font_name,str);
	_strcpy(lf.lfFaceName, str);
	m_data->GetAttr(inst,a_font_height,tmp);
	lf.lfHeight = tmp;
	m_data->GetAttr(inst,a_font_weight,tmp);
	if(tmp>FW_HEAVY ||tmp<0) tmp=FW_NORMAL;
	lf.lfWeight = tmp;
	m_data->GetAttr(inst,a_font_italic,tmp);
	lf.lfItalic = tmp;
	m_data->GetAttr(inst,a_font_strikeout,tmp);
	lf.lfStrikeOut = tmp;
	m_data->GetAttr(inst,a_font_underline,tmp);
	lf.lfUnderline = tmp;

	lf.lfOutPrecision = OUT_DEFAULT_PRECIS;
	lf.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	lf.lfQuality = DEFAULT_QUALITY;
	lf.lfPitchAndFamily = DEFAULT_PITCH;
	return lf;
}

int CaplReportMgr::GetPoint(CaplInstance *inst, CaplAttr *attr, CSize &size)
{
	CPoint pt;
	int res = GetPoint(inst,attr,pt);
	size = pt;
	return res;
}

CTableElement* CaplReportMgr::FindTable(CaplInstance *inst)
{
	if(inst==0) return NULL;
	for(int i=0; i<m_tables.GetSize();i++)
	{
		if(m_tables.GetAt(i)->GetType()!=E_TABLE) continue;
		CTableElement* table = (CTableElement*)m_tables.GetAt(i);
		if(table->m_inst==inst) return table;
	}
	return NULL;
}

CReportSheet* CaplReportMgr::CloneSheet(CReportSheet *sheet, int ind)
{
	CReportSheet* new_sheet = new CReportSheet(this);
	sheet->Update();
	for(int i=0; i<sheet->m_els.GetSize();i++)
		new_sheet->Add(sheet->m_els.GetAt(i)->CreateClon());
	if(ind==-1)
	{
		m_sheets.Add(new_sheet);
		new_sheet->m_name.Format(APL_T("%d"),m_sheets.GetSize());
	}
	else if(ind>-1)
	{
		m_sheets.InsertAt(ind, new_sheet);
		new_sheet->m_name.Format(APL_T("%d"),ind+1);
		for(int i=ind; i<m_sheets.GetSize(); i++)
			new_sheet->m_name.Format(APL_T("%d"),i+1);
	}
	new_sheet->m_size = sheet->m_size;
	new_sheet->Update();
	new_sheet->LoadElementsFromFile();
	if(ind!=-2)
		new_sheet->FreeElements();
	return new_sheet;
}

void CaplReportMgr::RemoveAllSheets()
{
	int i;
	int cnt = m_sheets.GetSize();
	for(i=0; i<cnt;i++)
		delete m_sheets.GetAt(i);
	m_sheets.RemoveAll();
	cnt =  m_tables.GetSize();
	for(i=0; i<cnt; i++)
		delete  m_tables[i];
	m_tables.RemoveAll();
	m_non_create_table_maps.RemoveAll();

	cnt = m_TableContents.GetSize();
	for(i=0; i<cnt; i++)
		delete m_TableContents.GetAt(i);
	m_TableContents.RemoveAll();
	m_UpdateReference.RemoveAll();//     
}

bool CaplReportMgr::Init()
{
	if(m_base_query==NULL)
		m_base_query = new CHeader(this);//  
	else
		m_base_query->RemoveAll();
	if(m_header==NULL)
		m_header = new CHeader(this, false);//  
	else
		m_header->RemoveAll();

	m_data_source.RemoveAll();
	m_dot_sheet = NULL;
	RemoveAllSheets();

	CReportParam *par = new CReportParam(this);
	par->m_name = _T("CRC32");
	par->SetType(CRC32_PARAM);

	return true;
}

CHeaderColumn* CaplReportMgr::FindColumnByInst(CaplInstance *inst)
{
	if(inst==0) return NULL;
	int i;
	for(i=0; i<m_base_query->GetSize();i++)
		if(m_base_query->GetColumn(i)->m_inst==inst) return m_base_query->GetColumn(i);
	for(i=0; i<m_header->GetSize();i++)
		if(m_header->GetColumn(i)->m_inst==inst) return m_header->GetColumn(i);
	return NULL;
}

void CaplReportMgr::UpdateSheets()
{
	int cnt = m_sheets.GetSize();
	for(int i=0; i<cnt;i++)
		m_sheets.GetAt(i)->m_name.Format(APL_T("%d"),i+1);
}


CString CaplReportMgr::GetDictPath()
{
	return m_dict_path;
}

bool CaplReportMgr::GetRect(CaplInstance* inst, CaplAttr *attr, CRect &rect)
{
	if(inst==NULL) return false;
	if(m_data==NULL) return false;
	if(attr==NULL) return false;
	CaplInstance* tmp_inst = NULL;
	m_data->GetAttr(inst,attr,tmp_inst);
	if(tmp_inst==NULL) return false;
	int top, left, bottom, right;
	m_data->GetAttr(tmp_inst,a_apl_rect_top,top);
	m_data->GetAttr(tmp_inst,a_apl_rect_left,left);
	m_data->GetAttr(tmp_inst,a_apl_rect_bottom,bottom);
	m_data->GetAttr(tmp_inst,a_apl_rect_right,right);
	rect = CRect(left,top,right,bottom);
	return true;
}

CRect CaplReportMgr::GetRect(CaplInstance* inst, CaplAttr *attr)
{
	CRect rect(0,0,0,0);
	if(inst==NULL) return rect;
	if(m_data==NULL) return rect;
	if(attr==NULL) return rect;

	CaplInstance* tmp_inst = NULL;
	m_data->GetAttr(inst,attr,tmp_inst);
	if(tmp_inst==NULL) return false;
	int top, left, bottom, right;
	m_data->GetAttr(tmp_inst,a_apl_rect_top,top);
	m_data->GetAttr(tmp_inst,a_apl_rect_left,left);
	m_data->GetAttr(tmp_inst,a_apl_rect_bottom,bottom);
	m_data->GetAttr(tmp_inst,a_apl_rect_right,right);
	rect = CRect(top,left,bottom,right);
	return rect;
}

bool CaplReportMgr::SetRect(CaplInstance* inst, CaplAttr *attr, CRect rect)
{
	if(inst==NULL) return false;
	if(m_data==NULL) return false;
	if(attr==NULL) return false;

	CaplInstance* tmp_inst = NULL;
	m_data->GetAttr(inst,attr,tmp_inst);
	if(tmp_inst==NULL)
	{
		tmp_inst = m_data->CreateInstance(e_apl_rect);
		m_data->PutAttr(inst,attr,tmp_inst);
	}
	int top, left, bottom, right;
	top = rect.top;
	left = rect.left;
	bottom = rect.bottom;
	right = rect.right;
	m_data->PutAttr(tmp_inst,a_apl_rect_top,top);
	m_data->PutAttr(tmp_inst,a_apl_rect_left,left);
	m_data->PutAttr(tmp_inst,a_apl_rect_bottom,bottom);
	m_data->PutAttr(tmp_inst,a_apl_rect_right,right);
	return true;
}

void CConditionArray::Delete()
{
	int cnt = m_data.GetSize();
	for(int i=0; i<cnt; i++)
	{
		m_data.GetAt(i)->Delete(m_report_mgr);
		DELETE_OBJECT(m_data.GetAt(i));
	}
	m_data.RemoveAll();
}

int CaplReportMgr::FindSheetInd(CReportSheet *sheet)
{
	int cnt = m_sheets.GetSize();
	for(int i=0; i<cnt; i++)
		if(m_sheets[i]==sheet) return i;
	return -1;
}

bool CaplReportMgr::Update(bool bSet)
{
	int cnt = m_TableContents.GetSize();
	for(int i=0; i<cnt; i++)
		m_TableContents.GetAt(i)->Update(bSet);
	
	return true;
}

bool CaplReportMgr::LoadTableContents()
{
	if(m_data==NULL) return false;
	aplExtent ext, ext1, ext2;
	m_data->GetEntityExtent(e_apl_table_content, ext);
	int i;
	for(i=0; i<ext.Size;i++)
	{
		m_data->GetAttr(ext[i], a_apl_tc_childs, ext2);
		ext1.Append(ext2);
	}
	for(i=0; i<ext.Size; i++)
	{
		if(ext1.Find(ext[i])>-1)
		{
			ext.Remove(i);
			i--;
		}
	}
	for(i=0; i<ext.Size;i++)
	{
		CTableContent* tc = new CTableContent(this);
		tc->m_inst = ext[i];
		tc->Update(false);
		m_TableContents.Add(tc);
	}
	return true;
}

bool CaplReportMgr::LoadFromFile(LPCTSTR lpszFileName)
{
	if(m_data==NULL) return false;

	CaplStepDataWithFile *tmp_data = m_data;

	m_data->ClearData();
	m_data->ClearDict();
	Detach();

	m_data = tmp_data;

	m_data_source.m_params.RemoveAll();
	
	if(!m_data->LoadFromFile(lpszFileName))
		return false;
	
	Attach(m_data, NULL);

	Init();

	int i;
	int tmp_int;
	CString name;
	aplExtent sheets, els;
	aplExtent ext, params;
	CReportSheet* pSheet = NULL;
	CReportParam* pParam = NULL;
	CHeaderColumn* pCol = NULL;
	CaplInstance *query_inst, *header_inst;

	//
	bool bFindCrc32Param = false;
	m_data->GetEntityExtent(e_param, params);
	for(i=0; i<params.GetSize();i++)
	{
		pParam = new CReportParam(this);
		pParam->m_inst = params.GetAt(i);
		pParam->Update(false);
		if(pParam->GetType()==CRC32_PARAM) bFindCrc32Param = true;
	}
	if(!bFindCrc32Param)
	{
		pParam = new CReportParam(this);
		pParam->m_name = _T("CRC32");
		pParam->SetType(CRC32_PARAM);
	}
	// 
	m_data->GetEntityExtent(e_apl_select, ext);
	if(ext.Size>0)
		query_inst = ext[0];
	else 
		query_inst = NULL;
	m_data->GetEntityExtent(e_apl_result_select, ext);
	if(ext.Size>0)
		header_inst = ext[0];
	else 
		header_inst = NULL;
	m_base_query->m_inst = query_inst;
	m_base_query->Update(false);
	m_header->m_inst = header_inst;
	m_header->Update(false);

	//   
	aplExtent reports;
	m_data->GetEntityExtent(e_apl_report, reports);
	if(reports.Size<0) return false;

	m_pReport = reports[0];
	if (m_pReport==NULL)
		return false;

	m_data->GetAttr(m_pReport, a_rep_sheets, sheets);
	m_data->GetAttr(m_pReport, a_apl_report_fit_to_page, tmp_int);
	m_bFitToPage = tmp_int!=0;
	m_data->GetAttr(m_pReport, a_rep_mode, tmp_int);
	m_bSplitPageToA4 = tmp_int>0;
	if(sheets.GetSize()==0) return false;
	for(i=0; i<sheets.GetSize(); i++)
	{
		pSheet = new CReportSheet(this);
		pSheet->m_inst = sheets[i];
		m_sheets.Add(pSheet);
		name.Format(APL_T("%d"),i+1);
		pSheet->m_name = name;
		m_data->GetAttr(pSheet->m_inst, a_rep_sheet_els, els);
		pSheet->LoadElementsFromFile();
	}
	
	return true;
}

CReportParam* CaplReportMgr::CreateParam()
{
	if(m_data==NULL) return NULL;
	if(!m_data->IsDictLoad()) return NULL;

	HINSTANCE hCurInst = AfxGetResourceHandle();
	AfxSetResourceHandle(dllInst);
	CParamPropDlg dlg(this);
	dlg.DoModal();
	AfxSetResourceHandle(hCurInst);
	return dlg.m_param;
}

CString CaplReportMgr::GetReportName() const
{
	CString sValue = _T("");
	if (m_pReport!=NULL)
		m_data->GetAttr(m_pReport, a_rep_name, sValue);

	return sValue;
}

void CaplReportMgr::SetReportName(const CString& sValue)
{
	if (m_pReport!=NULL)
		m_data->PutAttr(m_pReport, a_rep_name, sValue);
}

int CaplReportMgr::GetReportVersion() const
{
	int iValue(0);
	if (m_pReport!=NULL)
		m_data->GetAttr(m_pReport, a_rep_version, iValue);

	return iValue;
}

void CaplReportMgr::SetReportVersion(int iValue)
{
	if (m_pReport!=NULL)
		m_data->PutAttr(m_pReport, a_rep_version, iValue);
}

CString CaplReportMgr::GetDefaultPrinterName()
{
	DWORD size = 0;
	::GetDefaultPrinter(NULL, &size);

	if(size > 0)
	{
		TCHAR *name = new TCHAR[size+1];
		::GetDefaultPrinter(name, &size);

		CString sName(name);
		delete [] name;

		return sName;
	}

	return _T("");
}	

CString CaplReportMgr::GetPdfPrinterName()
{
	DWORD dwPrtRet1, dwBytesNeeded;
	LPPRINTER_INFO_1 pPrtInfo1 = NULL ;
	BOOL bReturn = TRUE;

	// get BYTE count needed for buffer, alloc buffer, the enum the printers
	EnumPrinters ( PRINTER_ENUM_LOCAL 
		, NULL , 1 , (LPBYTE) pPrtInfo1 , 0 , &dwBytesNeeded , &dwPrtRet1);

	// (simple error checking, if these work assume rest will too)
	pPrtInfo1 = (LPPRINTER_INFO_1) LocalAlloc (LPTR, dwBytesNeeded) ;
	if ( !pPrtInfo1 )
	{
		bReturn = FALSE;
		LocalFree (LocalHandle (pPrtInfo1));
		AfxMessageBox(APL_T("   "), MB_ICONSTOP);

		return _T("");
	}

	if ( !EnumPrinters ( PRINTER_ENUM_LOCAL 
		, NULL, 1, (LPBYTE) pPrtInfo1, dwBytesNeeded, &dwBytesNeeded, &dwPrtRet1))
	{
		LPVOID lpMsgBuf ;
		FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
			NULL,GetLastError(),MAKELANGID(LANG_NEUTRAL,SUBLANG_DEFAULT), //Default language
			(LPTSTR)&lpMsgBuf, 0,NULL );

		//Display the string.
		AfxMessageBox( (LPCTSTR)lpMsgBuf );
		// Free the buffer.
		LocalFree( lpMsgBuf );
		bReturn = FALSE;
		LocalFree (LocalHandle (pPrtInfo1));
		AfxMessageBox(APL_T("   "), MB_ICONSTOP);

		return _T("");
	}

	for ( DWORD i = 0 ; i < dwPrtRet1 ; i++ )
	{
		CString sPrinterName(pPrtInfo1[i].pName);
		sPrinterName.MakeLower();

		if(-1 != sPrinterName.Find(_T("pdf")))
		{
			LocalFree (LocalHandle (pPrtInfo1));
			return sPrinterName;
		}
	}

	LocalFree (LocalHandle (pPrtInfo1));
	return _T("");
}

bool CaplReportMgr::ExportToPdf( LPCTSTR fileName )
{	
	CString sDefaultPrinterName = GetDefaultPrinterName();
	CString sPdfPrinterName = GetPdfPrinterName();

	//MessageBoxA(0,_T("123"), _T("ExportToPdf"), MB_OK);
	//AfxMessageBox(APL_T("CaplReportMgr::ExportToPdf"), MB_ICONINFORMATION);

	if(sPdfPrinterName.IsEmpty())
	{
		AfxMessageBox(APL_T(" pdf  ."), MB_ICONINFORMATION);
		return false;
	}

	//    PDF
	this->SetupDefaultPrinter(sPdfPrinterName);

	// 
	UINT exitCode = 0;
	SHELLEXECUTEINFO ShExecInfo = {0};
	ShExecInfo.cbSize = sizeof(SHELLEXECUTEINFO);
	ShExecInfo.fMask = SEE_MASK_NOASYNC | SEE_MASK_NOCLOSEPROCESS ;
	ShExecInfo.hwnd = NULL;
	ShExecInfo.lpVerb = _T("print");
	ShExecInfo.lpFile = fileName;        
	ShExecInfo.lpParameters = NULL;
	ShExecInfo.lpDirectory = NULL;
	ShExecInfo.nShow = SW_HIDE;
	ShExecInfo.hInstApp = NULL; 
	ShellExecuteEx(&ShExecInfo);

	//     
	SetupDefaultPrinter(sDefaultPrinterName);		
	AfxGetApp()->m_pMainWnd->SendMessage(WM_CLOSE);

	return true;
}

void CaplReportMgr::SetupDefaultPrinter(CString &sPrinterName)
{
	DWORD size = 0;
	while(true)
	{
		::SetDefaultPrinter(sPrinterName.GetBuffer());
		::GetDefaultPrinter(NULL, &size);

		if(size > 0)
		{	
			TCHAR *defPrinterName = new TCHAR[size+1];
			::GetDefaultPrinter(defPrinterName, &size);

			if(0 == sPrinterName.CompareNoCase(defPrinterName))
			{
				delete [] defPrinterName;
				break;
			}

			delete [] defPrinterName;
		}				
	}
}


