#if !defined(AFX_REPORTVIEW_H__51E9DF95_9BA7_455F_AEC7_8AEE8110C5EA__INCLUDED_)
#define AFX_REPORTVIEW_H__51E9DF95_9BA7_455F_AEC7_8AEE8110C5EA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ReportView.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CReportView view
#include "ReportDict.h"

class CLASS_DECL_APL_REPORTMGR CReportView : public CScrollView
{
	DECLARE_DYNCREATE(CReportView)
protected:
	CReportView();           // protected constructor used by dynamic creation

protected:
	// Attributes
	CStringArray		m_TmpFiles;
	CStringArray		m_LastDotsFiles;
	
	bool				m_bFitToClient;
	
public:
	CaplStepDataWithFile	m_data;
	CaplReportMgr			m_ReportMgr;
	CDataSource				m_DataSource;
	int						m_CurSheet;
	bool					m_bUseEdit;

// Operations
public:
	virtual bool CloseReport();
	virtual bool RV_GenerateReport(CStringArray &Templates, CDataSource *pDataSource);
	virtual bool Regen();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CReportView)
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual void OnInitialUpdate();     // first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CReportView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
	//{{AFX_MSG(CReportView)
	afx_msg void OnFilePrint();
	afx_msg void OnFilePrintDirect();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnPaint();
	afx_msg void OnUpdateFilePrint(CCmdUI* pCmdUI);
	afx_msg void OnFirstPage();
	afx_msg void OnUpdateFirstPage(CCmdUI* pCmdUI);
	afx_msg void OnPrevPage();
	afx_msg void OnUpdatePrevPage(CCmdUI* pCmdUI);
	afx_msg void OnNextPage();
	afx_msg void OnUpdateNextPage(CCmdUI* pCmdUI);
	afx_msg void OnLastPage();
	afx_msg void OnUpdateLastPage(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.
#endif // !defined(AFX_REPORTVIEW_H__51E9DF95_9BA7_455F_AEC7_8AEE8110C5EA__INCLUDED_)
