// SectionLevel.cpp: implementation of the CSectionLevel class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ReportDict.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSectionLevel::CSectionLevel(CaplReportMgr* dict):m_columns(dict)
{
	ASSERT(dict);
	m_ReportMgr = dict;

	m_columns.RemoveAll();
	m_inst = NULL;
	m_name = _T("");
	m_ReportMgr = dict;
	m_height = 80;
	m_flag = 0;

	m_MinRows =1;		//        

	m_space_para = aplSpacePara15;

	m_row_color = RGB(200, 200, 200);
}

CSectionLevel::~CSectionLevel()
{
	m_columns.RemoveAll();
}

CSectionLevel& CSectionLevel::operator = (CSectionLevel& SecLevel)
{
	m_ReportMgr = SecLevel.m_ReportMgr;
	m_inst = SecLevel.m_inst;
	m_name = SecLevel.m_name;
	m_columns = SecLevel.m_columns;
	m_height = SecLevel.m_height;
	m_flag = SecLevel.m_flag;
	m_space_para = SecLevel.m_space_para;
	m_MinRows = SecLevel.m_MinRows;
	m_row_color = SecLevel.m_row_color;

	return *this;
}

bool CSectionLevel::Update(bool set)
{
	if(set)
	{
		if(m_inst==0)
			m_inst = m_ReportMgr->m_data->CreateInstance(m_ReportMgr->e_level);
		ASSERT(m_inst);
		CaplStepDataWithFile* data = m_ReportMgr->m_data;
		aplExtent ext;
		data->PutAttr(m_inst,m_ReportMgr->a_level_name,m_name);
		m_columns.Update(set);
		m_columns.GetExtent(ext);
		data->PutAttr(m_inst,m_ReportMgr->a_level_cols,ext);
		data->PutAttr(m_inst,m_ReportMgr->a_level_flag, m_flag);
		data->PutAttr(m_inst,m_ReportMgr->a_level_height, m_height);
		data->PutAttr(m_inst,m_ReportMgr->a_level_spacepara, m_space_para);
		data->PutAttr(m_inst,m_ReportMgr->a_level_min_rows, m_MinRows);
		data->PutAttr(m_inst, m_ReportMgr->a_level_row_color, (int)m_row_color);
	}
	else
	{
		if(m_inst==0) return false;
		aplExtent ext;
		int tmp_int;
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_level_name,m_name);
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_level_cols,ext);
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_level_flag, m_flag);
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_level_height, m_height);
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_level_spacepara, m_space_para);
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_level_min_rows, m_MinRows);
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_level_row_color, (int)tmp_int);
		m_row_color = (COLORREF)tmp_int;
		m_MinRows = m_MinRows>0?m_MinRows:1;
		m_columns.RemoveAll();
		for(int i=0; i<ext.Size;i++)
		{
			CColumn* col = new CColumn(m_ReportMgr);
			col->m_inst = ext[i];
			col->Update(set);
			m_columns.Add(col);
		}
	}
	return true;
}

CSectionLevel* CSectionLevel::CreateClon()
{
/*	CSectionLevel* lev = new CSectionLevel(m_ReportMgr);
	lev->m_name = m_name;
	for(int i=0; i<m_columns.GetSize();i++)
		lev->m_columns.Add(m_columns.GetAt(i));
	return lev;*/
	return NULL;
}

int CSectionLevel::GetMemSize(bool bIncludeDSCol)
{
	int size=m_columns.GetMemSize(bIncludeDSCol);

	size+=sizeof(int);//- 
	size+=m_name.GetLength()*sizeof(TCHAR);//
	size+=sizeof(int);//flag
	size+=sizeof(int);// 
	size+=sizeof(int);// 
	size+=sizeof(int);// 

	return size;
}

void CSectionLevel::CopyToMem(BYTE *pByte, int &ind, bool bIncludeDSCol)
{
	int* pInt = NULL;
	TCHAR* pCh = NULL;

	pInt = (int*)&pByte[ind];//  
	*pInt = m_height;
	ind+=sizeof(int);

	pInt = (int*)&pByte[ind];// flag
	*pInt = m_flag;
	ind+=sizeof(int);

	pInt = (int*)&pByte[ind];//  
	*pInt = m_space_para;
	ind+=sizeof(int);

	pInt = (int*)&pByte[ind];//  
	*pInt = m_name.GetLength();
	ind+=sizeof(int);
	for(int i=0; i<m_name.GetLength();i++)
	{
		pCh = (TCHAR*)&pByte[ind];
		*pCh = m_name[i];
		ind+=sizeof(TCHAR);
	}
	pInt = (int*)&pByte[ind]; 
	*pInt = m_columns.GetSize();
	ind+=sizeof(int);
	
	m_columns.CopyToMem(pByte, ind, bIncludeDSCol);
}

bool CSectionLevel::LoadDataFromMem(BYTE *pByte, int &ind)
{
	int i;
	int* pInt = NULL;
	TCHAR* pCh = NULL;

	pInt = (int*)&pByte[ind];//  
	m_height = *pInt;
	ind+=sizeof(int);

	pInt = (int*)&pByte[ind];//  
	m_flag = *pInt;
	ind+=sizeof(int);

	pInt = (int*)&pByte[ind];//  
	m_space_para = *pInt;
	ind+=sizeof(int);

	pInt = (int*)&pByte[ind];//  
	int cnt = *pInt;
	ind+=sizeof(int);
	for(i=0; i<cnt;i++)
	{
		pCh = (TCHAR*)&pByte[ind];
		m_name+=*pCh;
		ind+=sizeof(TCHAR);
	}

	pInt = (int*)&pByte[ind]; 
	cnt = *pInt;
	ind+=sizeof(int);
	m_columns.RemoveAll();
	for(i=0; i<cnt;i++)
	{
		CColumn* col = new CColumn(m_ReportMgr);
		m_columns.Add(col);
	}
	m_columns.LoadDataFromMem(pByte,ind);
	return true;
}

void CSectionLevel::Delete()
{
	int cnt = m_columns.GetSize();
	for(int i=0; i<cnt;i++)
	{
		if(m_columns.GetAt(i)->m_inst!=0)
		{
			if(m_columns.GetAt(i)->m_inst->GetType()!=0)
				m_ReportMgr->m_data->DeleteInstance(m_columns.GetAt(i)->m_inst);
		}
	}
	if(m_inst!=0)
	{
		if(m_inst->GetType()!=0)
			m_ReportMgr->m_data->DeleteInstance(m_inst);
	}
}
