// SelectTableDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "SelectTableDlg.h"
#include "ReportDict.h"
#include <AplGuiEx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelectTableDlg dialog


CSelectTableDlg::CSelectTableDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CSelectTableDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSelectTableDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_ReportMgr = NULL;
	m_table = NULL;
}


void CSelectTableDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectTableDlg)
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_TABLES, m_tables_ctrl);
	DDX_Control(pDX, IDC_PAGE, m_page_ctrl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelectTableDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CSelectTableDlg)
	ON_CBN_SELCHANGE(IDC_PAGE, OnSelchangePage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelectTableDlg message handlers

void CSelectTableDlg::OnSelchangePage() 
{
	m_tables_ctrl.ResetContent();
	int cur = m_page_ctrl.GetCurSel();
	if(cur<0) return;
	CReportSheet* sheet = (CReportSheet*)m_page_ctrl.GetItemData(cur);
	for(int i=0; i<sheet->m_els.GetSize();i++)
	{
		CReportElement* elem = sheet->m_els.GetAt(i);
		if(elem->GetType()==E_TABLE) 
		{
			int ind = m_tables_ctrl.AddString(elem->m_name);
			m_tables_ctrl.SetItemData(ind,DWORD(elem));
		}
	}
}

BOOL CSelectTableDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_ok_btn.SetIcon(aplGetStdIco16(APL_STD_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(aplGetStdIco16(APL_STD_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	if(m_ReportMgr==NULL)
	{
		EndDialog(0);
		return FALSE;
	}
	//  
	for(int i=0; i<m_ReportMgr->m_sheets.GetSize();i++)
	{
		CReportSheet* sheet = m_ReportMgr->m_sheets.GetAt(i);
		int ind = m_page_ctrl.AddString(sheet->m_name);
		m_page_ctrl.SetItemData(ind,DWORD(sheet));
	}
	m_page_ctrl.SetCurSel(0);
	OnSelchangePage();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSelectTableDlg::OnOK() 
{
	int cur = m_tables_ctrl.GetCurSel();
	CReportElement* elem = (CReportElement*)m_tables_ctrl.GetItemData(cur);
	if(elem==0 || cur<0) 
	{
		AfxMessageBox(APL_T("  ."));
		return;
	}
	m_table = (CTableElement*)elem;
	
	CaplTranslateDialog::OnOK();
}
