// SetupvisiblecolumnsPage.cpp : implementation file
//

#include "stdafx.h"
#include "SetupvisiblecolumnsPage.h"
#include <AplGuiEx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSetupvisiblecolumnsPage dialog


CSetupvisiblecolumnsPage::CSetupvisiblecolumnsPage(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CSetupvisiblecolumnsPage::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetupvisiblecolumnsPage)
	//}}AFX_DATA_INIT
	m_pHeader = NULL;
}


void CSetupvisiblecolumnsPage::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetupvisiblecolumnsPage)
	DDX_Control(pDX, IDC_DEL_ALL, m_delall_btn);
	DDX_Control(pDX, IDC_ADD_ALL, m_addall_btn);
	DDX_Control(pDX, IDC_DEL, m_del_btn);
	DDX_Control(pDX, IDC_ADD, m_add_btn);
	DDX_Control(pDX, IDC_POSSIBLE_COLUMNS, m_PossibleColumns_ListCtrl);
	DDX_Control(pDX, IDC_VISIBLE_COLUMNS, m_VisibleColumns_ListCtrl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetupvisiblecolumnsPage, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CSetupvisiblecolumnsPage)
	ON_LBN_DBLCLK(IDC_POSSIBLE_COLUMNS, OnDblclkPossibleColumns)
	ON_LBN_DBLCLK(IDC_VISIBLE_COLUMNS, OnDblclkVisibleColumns)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_BN_CLICKED(IDC_DEL, OnDel)
	ON_BN_CLICKED(IDC_ADD_ALL, OnAddAll)
	ON_BN_CLICKED(IDC_DEL_ALL, OnDelAll)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetupvisiblecolumnsPage message handlers

void CSetupvisiblecolumnsPage::OnOK() 
{
	// TODO: Add extra validation here
	
//	CaplTranslateDialog::OnOK();
}

void CSetupvisiblecolumnsPage::OnCancel() 
{
	// TODO: Add extra cleanup here
	
//	CaplTranslateDialog::OnCancel();
}

bool CSetupvisiblecolumnsPage::UpdateLists()
{
	m_PossibleColumns_ListCtrl.ResetContent();
	m_VisibleColumns_ListCtrl.ResetContent();
	if(m_pHeader==NULL) return true;

	int i;
	CString buf;
	CHeaderColumn* pColumn;
	for(i=0; i<m_pHeader->GetSize(); i++)
	{
		pColumn = m_pHeader->GetColumn(i);
		buf = pColumn->GetName();
		m_VisibleColumns_ListCtrl.SetItemData(m_VisibleColumns_ListCtrl.AddString(buf), (DWORD)pColumn);
		//m_PossibleColumns_ListCtrl.SetItemData(m_PossibleColumns_ListCtrl.AddString(buf), (DWORD)pColumn);
	}
	return true;
}

void CSetupvisiblecolumnsPage::OnDblclkPossibleColumns() 
{
	OnAdd();
}

void CSetupvisiblecolumnsPage::OnDblclkVisibleColumns() 
{
	OnDel();
}

void CSetupvisiblecolumnsPage::OnAdd() 
{
	int cur;
	CHeaderColumn* pCol = NULL;
	cur = m_PossibleColumns_ListCtrl.GetCurSel();
	if(cur<0) return;
	pCol = (CHeaderColumn*)m_PossibleColumns_ListCtrl.GetItemData(cur);
	m_PossibleColumns_ListCtrl.DeleteString(cur);
	m_VisibleColumns_ListCtrl.SetItemData(m_VisibleColumns_ListCtrl.AddString(pCol->GetName()), (DWORD)pCol);

	if(cur>-1 && m_PossibleColumns_ListCtrl.GetCount()>0)
		m_PossibleColumns_ListCtrl.SetCurSel(cur>=m_PossibleColumns_ListCtrl.GetCount()?m_PossibleColumns_ListCtrl.GetCount()-1:cur);
}

void CSetupvisiblecolumnsPage::OnDel() 
{
	int cur;
	CHeaderColumn* pCol = NULL;
	cur = m_VisibleColumns_ListCtrl.GetCurSel();
	if(cur<0) return;
	pCol = (CHeaderColumn*)m_VisibleColumns_ListCtrl.GetItemData(cur);
	m_VisibleColumns_ListCtrl.DeleteString(cur);
	m_PossibleColumns_ListCtrl.SetItemData(m_PossibleColumns_ListCtrl.AddString(pCol->GetName()), (DWORD)pCol);

	if(cur>-1 && m_VisibleColumns_ListCtrl.GetCount()>0)
		m_VisibleColumns_ListCtrl.SetCurSel(cur>=m_VisibleColumns_ListCtrl.GetCount()?m_VisibleColumns_ListCtrl.GetCount()-1:--cur);
}

void CSetupvisiblecolumnsPage::OnAddAll() 
{
	m_PossibleColumns_ListCtrl.ResetContent();
	m_VisibleColumns_ListCtrl.ResetContent();
	if(m_pHeader==NULL) return;
	
	int i;
	CString buf;
	CHeaderColumn* pColumn;
	for(i=0; i<m_pHeader->GetSize(); i++)
	{
		pColumn = m_pHeader->GetColumn(i);
		buf = pColumn->GetName();
		m_VisibleColumns_ListCtrl.SetItemData(m_VisibleColumns_ListCtrl.AddString(buf), (DWORD)pColumn);
	}
}

void CSetupvisiblecolumnsPage::OnDelAll() 
{
	m_PossibleColumns_ListCtrl.ResetContent();
	m_VisibleColumns_ListCtrl.ResetContent();
	if(m_pHeader==NULL) return;
	
	int i;
	CString buf;
	CHeaderColumn* pColumn;
	for(i=0; i<m_pHeader->GetSize(); i++)
	{
		pColumn = m_pHeader->GetColumn(i);
		buf = pColumn->GetName();
		m_PossibleColumns_ListCtrl.SetItemData(m_PossibleColumns_ListCtrl.AddString(buf), (DWORD)pColumn);
	}
}

bool CSetupvisiblecolumnsPage::TestUpdate()
{
	if(m_VisibleColumns_ListCtrl.GetCount()==0)
	{
		AfxMessageBox(APL_T("   !"), MB_ICONINFORMATION|MB_OK);
		return false;
	}
	return true;
}

bool CSetupvisiblecolumnsPage::GetVisibleHeader(CHeader *pHeader)
{
	if(pHeader==NULL) return false;
	pHeader->RemoveAll();
	int i;
	CHeaderColumn* pCol, *nCol;;
	for(i=0; i<m_VisibleColumns_ListCtrl.GetCount(); i++)
	{
		pCol = (CHeaderColumn*)m_VisibleColumns_ListCtrl.GetItemData(i);
		nCol = new CHeaderColumn(NULL);
		*nCol = *pCol;
		pHeader->AddColumn(nCol);
	}
	return true;
}

BOOL CSetupvisiblecolumnsPage::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_add_btn.SetIcon(GetAplStdIco16(APL_STD_24RIGHT));
	m_add_btn.SetWindowText(_T(""));
	m_addall_btn.SetIcon(GetAplStdIco16(APL_STD_24RIGHTALL));
	m_addall_btn.SetWindowText(_T(""));
	m_del_btn.SetIcon(GetAplStdIco16(APL_STD_24LEFT));
	m_del_btn.SetWindowText(_T(""));
	m_delall_btn.SetIcon(GetAplStdIco16(APL_STD_24LEFTALL));
	m_delall_btn.SetWindowText(_T(""));
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
