// SimplDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "ReportDict.h"
#include "SimplDlg.h"
#include "SelectDSColumnDlg.h"
#include "TextDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSimplDlg dialog


CSimplDlg::CSimplDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CSimplDlg::IDD, pParent)
	, m_bShowAsTime(FALSE)
	, m_bShowTopLine(FALSE)
{
	//{{AFX_DATA_INIT(CSimplDlg)
	m_text = _T("");
	m_width = 0;
	m_line_width = float(0.1);
	m_fit_to_rect = FALSE;
	m_strDS_Column = _T("");
	m_iStrCount = 1;
	m_ShowValue = -1;
	m_bShowasDate = FALSE;
	m_bNotShowZero = FALSE;
	//}}AFX_DATA_INIT
	m_title = APL_T(" ");
	m_show = APL_FULL_MODE;
	m_ReportMgr = NULL;
	m_ds_column=NULL;
	m_align = AT_VCENTER|AT_LEFT;
	m_SpacePara = aplSpacePara15;
	m_mode = 0;
	m_line_width = float(AfxGetApp()->GetProfileInt(_T("DefaultSettings"),_T("LineWidth"),1))/10;
	m_IsGroup = false;
	m_ColumnType = aplVALUE;
	m_column_text.Empty();
}


void CSimplDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSimplDlg)
	DDX_Control(pDX, IDC_CONDITION_SETUP, m_conditions_setup_btn);
	DDX_Control(pDX, IDC_STATIC_IMAGE, m_ImageCtrl);
	DDX_Control(pDX, IDC_COMBO_SPACE_PARA, m_SpaceParaCtrl);
	DDX_Control(pDX, IDC_TOPRIGHT, m_tr_btn);
	DDX_Control(pDX, IDC_TOPLEFT, m_tl_btn);
	DDX_Control(pDX, IDC_TOPCENTER, m_tc_btn);
	DDX_Control(pDX, IDC_CENTERRIGHT, m_cr_btn);
	DDX_Control(pDX, IDC_CENTERLEFT, m_cl_btn);
	DDX_Control(pDX, IDC_VHCENTER, m_center_btn);
	DDX_Control(pDX, IDC_BOTTOMLEFT, m_bl_btn);
	DDX_Control(pDX, IDC_BOTTOMCENTER, m_bc_btn);
	DDX_Control(pDX, IDC_BOTTEMRIGHT, m_br_btn);
	DDX_Control(pDX, IDC_STR_COUNT, m_StrCountCtrl);
	DDX_Control(pDX, IDC_COMBO_TYPES, m_Types_ctrl);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Text(pDX, IDC_EDIT, m_text);
	DDX_Text(pDX, IDC_EDIT_WIDTH, m_width);
	DDX_Text(pDX, IDC_LINE_WIDTH, m_line_width);
	DDX_Check(pDX, IDC_FIT_TO_ELEM, m_fit_to_rect);
	DDX_Text(pDX, IDC_DS_COLUMN, m_strDS_Column);
	DDX_Text(pDX, IDC_STR_COUNT, m_iStrCount);
	DDV_MinMaxInt(pDX, m_iStrCount, 1, 10);
	DDX_Radio(pDX, IDC_SHOW_VALUE, m_ShowValue);
	DDX_Check(pDX, IDC_SHOW_AS_DATE, m_bShowasDate);
	DDX_Check(pDX, IDC_NOT_SHOW_ZERO, m_bNotShowZero);
	//}}AFX_DATA_MAP
	DDX_Check(pDX, IDC_SHOW_AS_DATE2, m_bShowAsTime);
	DDX_Check(pDX, IDC_SHOW_TOP_LINE, m_bShowTopLine);
	DDX_Control(pDX, IDC_USE_EVEN_CHECK, m_use_even_check);
	DDX_Control(pDX, IDC_USE_EVEN_COMBO, m_use_even_combo);
}


BEGIN_MESSAGE_MAP(CSimplDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CSimplDlg)
	ON_BN_CLICKED(IDC_SELECT_DS_COLUMN, OnSelectDsColumn)
	ON_BN_CLICKED(IDC_LEVEL, OnLevel)
	ON_BN_CLICKED(IDC_FIT_TO_ELEM, OnFitToElem)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_TOPLEFT, OnTopleft)
	ON_BN_CLICKED(IDC_TOPCENTER, OnTopcenter)
	ON_BN_CLICKED(IDC_BOTTOMCENTER, OnBottomcenter)
	ON_BN_CLICKED(IDC_BOTTOMLEFT, OnBottomleft)
	ON_BN_CLICKED(IDC_CENTERLEFT, OnCenterleft)
	ON_BN_CLICKED(IDC_CENTERRIGHT, OnCenterright)
	ON_BN_CLICKED(IDC_TOPRIGHT, OnTopright)
	ON_BN_CLICKED(IDC_VHCENTER, OnVhcenter)
	ON_BN_CLICKED(IDC_RADIO2, OnRadio2)
	ON_BN_CLICKED(IDC_SHOW_VALUE, OnShowValue)
	ON_BN_CLICKED(IDC_BOTTEMRIGHT, OnBottemright)
	ON_BN_CLICKED(IDC_CONDITION_SETUP, OnConditionSetup)
	ON_CBN_SELCHANGE(IDC_COMBO_TYPES, OnSelchangeComboTypes)
	ON_CBN_EDITCHANGE(IDC_COMBO_TYPES, OnEditchangeComboTypes)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_USE_EVEN_CHECK, &CSimplDlg::OnBnClickedUseEvenCheck)
	ON_CBN_SELCHANGE(IDC_USE_EVEN_COMBO, &CSimplDlg::OnCbnSelchangeUseEvenCombo)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSimplDlg message handlers

BOOL CSimplDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_ok_btn.SetIcon(aplGetStdIco16(APL_STD_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(aplGetStdIco16(APL_STD_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	CBitmap bm;
	bm.LoadBitmap(IDB_TEXT_FORMAT);
	m_Buttons_il.Create(16, 16, ILC_COLOR24|ILC_MASK, 0, 100);
	m_Buttons_il.Add(&bm, RGB(192,192,192));
	
	m_tl_btn.SetIcon(m_Buttons_il.ExtractIcon(0));
	m_tl_btn.SetWindowText(_T(""));
	
	m_tc_btn.SetIcon(m_Buttons_il.ExtractIcon(1));
	m_tc_btn.SetWindowText(_T(""));
	
	m_tr_btn.SetIcon(m_Buttons_il.ExtractIcon(2));
	m_tr_btn.SetWindowText(_T(""));
	
	m_cr_btn.SetIcon(m_Buttons_il.ExtractIcon(5));
	m_cr_btn.SetWindowText(_T(""));
	
	m_cl_btn.SetIcon(m_Buttons_il.ExtractIcon(3));
	m_cl_btn.SetWindowText(_T(""));
	
	m_center_btn.SetIcon(m_Buttons_il.ExtractIcon(4));
	m_center_btn.SetWindowText(_T(""));
	
	m_bl_btn.SetIcon(m_Buttons_il.ExtractIcon(6));
	m_bl_btn.SetWindowText(_T(""));
	
	m_bc_btn.SetIcon(m_Buttons_il.ExtractIcon(7));
	m_bc_btn.SetWindowText(_T(""));
	
	m_br_btn.SetIcon(m_Buttons_il.ExtractIcon(8));
	m_br_btn.SetWindowText(_T(""));


	m_width = m_width/10;
	SetWindowText(m_title);

	m_use_even_combo.AddString(ID_STRING_EVEN);
	m_use_even_combo.AddString(ID_STRING_ODD);

	m_use_even_combo.SelectString(0,ID_STRING_EVEN);
	m_use_even_check.SetCheck((m_align&AT_USE_EVEN)!=0);
	m_use_even_combo.EnableWindow((m_align&AT_USE_EVEN)!=0);

	SetCheck(m_align,false);

	int ind = m_SpaceParaCtrl.AddString(APL_T(""));
	m_SpaceParaCtrl.SetItemData(ind, aplSpacePara1);
	ind = m_SpaceParaCtrl.AddString(APL_T(""));
	m_SpaceParaCtrl.SetItemData(ind, aplSpacePara15);
	ind = m_SpaceParaCtrl.AddString(APL_T(""));
	m_SpaceParaCtrl.SetItemData(ind, aplSpacePara2);

	SetSpacePara(m_SpacePara);

	m_ShowValue = m_show_flag;
	if(m_show_flag>0)
	{
		CWnd* wnd;
		wnd = GetDlgItem(IDC_SELECT_DS_COLUMN);
		wnd->EnableWindow(FALSE);			
		m_Types_ctrl.EnableWindow(FALSE);
	}
	HICON hIcon = aplGetStdIco16(APL_STD_COLUMN);
	SetIcon(hIcon, TRUE);
	::DestroyIcon(hIcon);

	if(m_show==APL_FULL_MODE)
	{
		m_Types_ctrl.EnableWindow(FALSE);
		GetDlgItem(IDC_CONDITION_SETUP)->EnableWindow(FALSE);
		GetDlgItem(IDC_NOT_SHOW_ZERO)->EnableWindow(FALSE);
	}

	if(m_ReportMgr==0)
	{
		CWnd* wnd = GetDlgItem(IDC_SELECT_DS_COLUMN);
		wnd->ShowWindow(SW_HIDE);
	}
	if(m_ds_column!=0)
		m_strDS_Column = m_ds_column->GetName();
	//  
	ind = m_Types_ctrl.AddString(APL_T(" "));
	m_Types_ctrl.SetItemData(ind, aplVALUE);
	if(m_ColumnType==aplVALUE)
		m_Types_ctrl.SetCurSel(ind);
	ind = m_Types_ctrl.AddString(APL_T("  "));
	m_Types_ctrl.SetItemData(ind, aplSUMM);
	if(m_ColumnType==aplSUMM)
		m_Types_ctrl.SetCurSel(ind);
	ind = m_Types_ctrl.AddString(APL_T("  "));
	m_Types_ctrl.SetItemData(ind, aplAVERANGE);
	if(m_ColumnType==aplAVERANGE)
		m_Types_ctrl.SetCurSel(ind);
	ind = m_Types_ctrl.AddString(APL_T("   "));
	m_Types_ctrl.SetItemData(ind, aplCOUNT);
	if(m_ColumnType==aplCOUNT)
		m_Types_ctrl.SetCurSel(ind);
	if(m_ColumnType==aplSTRCONST)
		m_Types_ctrl.SetWindowText(m_column_text);

	UpdateData(FALSE);

	OnSelchangeComboTypes();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSimplDlg::OnOK() 
{
	if(!UpdateData()) return;
	if(m_text==_T("") && m_mode==0)
	{
		AfxMessageBox(APL_T("   !"));
		return;
	}
	m_show_flag = m_ShowValue;
	int SelInd = m_Types_ctrl.GetCurSel();
	if(SelInd>-1)
		m_ColumnType = m_Types_ctrl.GetItemData(SelInd);
	else
	{
		m_ColumnType = aplSTRCONST;
		m_Types_ctrl.GetWindowText(m_column_text);
	}

	int cur = m_SpaceParaCtrl.GetCurSel();
	if(cur>-1)
		m_SpacePara = m_SpaceParaCtrl.GetItemData(cur);
	else
		m_SpacePara = aplSpacePara15;

	if(!m_IsGroup)
	{
		m_ColumnType=aplVALUE;
		m_bNotShowZero = FALSE;
		m_sConditions.Empty();
	}

	CaplTranslateDialog::OnOK();
}

void CSimplDlg::OnSelectDsColumn() 
{
	UpdateData();
	CSelectDSColumnDlg dlg;
	dlg.m_ReportMgr = m_ReportMgr;
	if(dlg.DoModal()==IDOK)
	{
		m_ds_column = dlg.m_selected;
		m_strDS_Column.Empty();
		if(m_ds_column)
			m_strDS_Column = m_text = m_ds_column->GetName();
	}
	UpdateData(FALSE);
}


void CSimplDlg::OnLevel() 
{
	CButton* btn =  (CButton*)GetDlgItem(IDC_LEVEL);
	int i = btn->GetCheck();
	if(i==0)
	{
		btn->SetCheck(1);
		CWnd* wnd = GetDlgItem(IDC_DS_COLUMN);
		wnd->SetWindowText(APL_T(" "));
		wnd = GetDlgItem(IDC_SELECT_DS_COLUMN);
		wnd->EnableWindow(FALSE);			
	}
	else
	{
		btn->SetCheck(0);
		CWnd* wnd = GetDlgItem(IDC_DS_COLUMN);
		CString str=_T("");
		if(m_ds_column)
			str = m_ds_column->m_name;
		wnd->SetWindowText(str);
		wnd = GetDlgItem(IDC_SELECT_DS_COLUMN);
		wnd->EnableWindow(TRUE);			
	}
}

void CSimplDlg::OnFitToElem() 
{
	if(UpdateData())
	{
		
	}
}

void CSimplDlg::OnDestroy() 
{
	CaplTranslateDialog::OnDestroy();
	
	m_Buttons_il.DeleteImageList();
}

void CSimplDlg::SetCheck(UINT align, bool bChange)
{
	CString sEven;
	BOOL bCheck;
	BOOL bEven;
	m_tl_btn.SetState(0);
	m_tc_btn.SetState(0);
	m_tr_btn.SetState(0);
	m_cl_btn.SetState(0);
	m_center_btn.SetState(0);
	m_cr_btn.SetState(0);
	m_bl_btn.SetState(0);
	m_bc_btn.SetState(0);
	m_br_btn.SetState(0);
	m_use_even_combo.GetWindowText(sEven);
	bCheck = m_use_even_check.GetCheck();
	bEven = sEven.CompareNoCase(ID_STRING_EVEN);

	m_align&=07777;
	if(bCheck)
		m_align|=010000;

	if (bChange)
	{
		if (bEven)
		{
			m_align&=010077;
			m_align|=align<<6;
		}
		else
		{
			m_align&=017700;
			m_align|=align;
		}
	}
	else
	{
		if (bEven)
			align = m_align>>6;
		else
			align = m_align;
	}

	if(align&AT_TOP && align&AT_LEFT)
		m_tl_btn.SetState(1);
	else if(align&AT_TOP && align&AT_CENTER)
		m_tc_btn.SetState(1);
	else if(align&AT_TOP && align&AT_RIGHT)
		m_tr_btn.SetState(1);
	else if(align&AT_VCENTER && align&AT_LEFT)
		m_cl_btn.SetState(1);
	else if(align&AT_VCENTER && align&AT_CENTER)
		m_center_btn.SetState(1);
	else if(align&AT_VCENTER && align&AT_RIGHT)
		m_cr_btn.SetState(1);
	else if(align&AT_BOTTOM&& align&AT_LEFT)
		m_bl_btn.SetState(1);
	else if(align&AT_BOTTOM&& align&AT_CENTER)
		m_bc_btn.SetState(1);
	else if(align&AT_BOTTOM&& align&AT_RIGHT)
		m_br_btn.SetState(1);
}

void CSimplDlg::OnTopleft() 
{
	SetCheck(AT_TOP|AT_LEFT);
}

void CSimplDlg::OnTopcenter() 
{
	SetCheck(AT_TOP|AT_CENTER);
}

void CSimplDlg::OnBottomcenter() 
{
	SetCheck(AT_BOTTOM|AT_CENTER);
}

void CSimplDlg::OnBottomleft() 
{
	SetCheck(AT_BOTTOM|AT_LEFT);
}

void CSimplDlg::OnCenterleft() 
{
	SetCheck(AT_VCENTER|AT_LEFT);
}

void CSimplDlg::OnCenterright() 
{
	SetCheck(AT_VCENTER|AT_RIGHT);
}

void CSimplDlg::OnTopright() 
{
	SetCheck(AT_TOP|AT_RIGHT);
}

void CSimplDlg::OnVhcenter() 
{
	SetCheck(AT_VCENTER|AT_CENTER);
}

void CSimplDlg::OnSpacePara1() 
{
	m_SpacePara = aplSpacePara1;
	SetSpacePara(m_SpacePara);
}

void CSimplDlg::OnSpacePara15() 
{
	m_SpacePara = aplSpacePara15;
	SetSpacePara(m_SpacePara);
}

void CSimplDlg::OnSpacePara2() 
{
	m_SpacePara = aplSpacePara2;
	SetSpacePara(m_SpacePara);
}

void CSimplDlg::SetSpacePara(int para)
{
	for(int i=0; i<m_SpaceParaCtrl.GetCount(); i++)
	{
		if(m_SpaceParaCtrl.GetItemData(i)==(DWORD)para)
		{
			m_SpaceParaCtrl.SetCurSel(i);
			return;
		}
	}
}

void CSimplDlg::OnRadio2() 
{
	CWnd* wnd;
	wnd = GetDlgItem(IDC_SELECT_DS_COLUMN);
	wnd->EnableWindow(FALSE);			
	m_Types_ctrl.EnableWindow(FALSE);
}

void CSimplDlg::OnShowValue() 
{
	CWnd* wnd;
	wnd = GetDlgItem(IDC_SELECT_DS_COLUMN);
	wnd->EnableWindow(TRUE);			
	if(m_show==APL_FULL_EX_MODE)
		m_Types_ctrl.EnableWindow(TRUE);
}

void CSimplDlg::OnBottemright() 
{
	SetCheck(AT_BOTTOM|AT_RIGHT);
}

void CSimplDlg::OnConditionSetup() 
{
	if(m_ds_column==NULL) return;
	int cur;
	cur = m_Types_ctrl.GetCurSel();
	if(cur<0) return;
	DWORD dw = m_Types_ctrl.GetItemData(cur);
	if(dw!=aplCOUNT) return;

	CString tmp_val;
	CTextDlg dlg;
	dlg.m_sTitle = APL_T("");
	if(m_sConditions.IsEmpty())
		dlg.m_sText = m_ds_column->GetName();
	else
		dlg.m_sText = m_sConditions;
	bool bOk = false;
	do
	{
		if(dlg.DoModal()==IDOK)
		{
			if(CDataSource::ParseCondition(dlg.m_sText, NULL, m_ReportMgr->m_base_query, &m_ReportMgr->m_data_source.m_params) || 
				CDataSource::ParseCondition(dlg.m_sText, NULL, m_ReportMgr->m_header, &m_ReportMgr->m_data_source.m_params))
			{
				m_sConditions = dlg.m_sText;
				bOk = true;
			}
		}
		else
			bOk = true;
	}while(!bOk);
}

void CSimplDlg::OnSelchangeComboTypes() 
{
	int cur = m_Types_ctrl.GetCurSel();
	DWORD data = aplVALUE;
	if(cur>0)
		data = m_Types_ctrl.GetItemData(cur);
	if(data==aplCOUNT)
	{
		GetDlgItem(IDC_NOT_SHOW_ZERO)->EnableWindow(TRUE);
		GetDlgItem(IDC_NOT_SHOW_ZERO)->SetWindowText(APL_T("  \"0\""));
		GetDlgItem(IDC_NOT_SHOW_ZERO)->ShowWindow(SW_SHOW);
	}
	else if(data==aplSUMM)
	{
		GetDlgItem(IDC_NOT_SHOW_ZERO)->EnableWindow(TRUE);
		GetDlgItem(IDC_NOT_SHOW_ZERO)->SetWindowText(APL_T("    "));
		GetDlgItem(IDC_NOT_SHOW_ZERO)->ShowWindow(SW_SHOW);
	}
	else
		GetDlgItem(IDC_NOT_SHOW_ZERO)->ShowWindow(SW_HIDE);
}

void CSimplDlg::OnEditchangeComboTypes() 
{
	GetDlgItem(IDC_NOT_SHOW_ZERO)->EnableWindow(FALSE);
}

void CSimplDlg::OnBnClickedUseEvenCheck()
{
	m_use_even_combo.EnableWindow(m_use_even_check.GetCheck());
	m_use_even_combo.SelectString(0,ID_STRING_EVEN);
	m_align&=01000777;
	SetCheck(m_align,false);
}

void CSimplDlg::OnCbnSelchangeUseEvenCombo()
{
	SetCheck(m_align,false);	
}
