// aplPSS.h: interface for the CaplPSS class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_APLPSS_H__1BCD9B6A_A09F_4BEF_9ED8_B797C6050EAA__INCLUDED_)
#define AFX_APLPSS_H__1BCD9B6A_A09F_4BEF_9ED8_B797C6050EAA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <apl_api.h>

typedef CaplTAggr <CaplTreeItemData*, CaplTreeItemData*, APLAGGR_LIST|APLAGGR_AUTOKILLREF> aplTIArray;

class CaplAPI;
class CaplTreeItemData;

/*  Toolbar' PSS*/

/**/
#define APLCMD_SHOW_ALL				0x00000001
#define APLCMD_SHOW_ALL_DOCS		0x00000002
#define APLCMD_SHOW_ALL_CHARACTS	0x00000003
#define APLCMD_SHOW_ALL_BPS			0x00000004
#define APLCMD_SHOW_ALL_REVISION	0x00000005
#define APLCMD_SHOW_ALL_APPOVALS	0x00000006
#define APLCMD_SHOW_ALL_MATERIALS	0x00000007
#define APLCMD_SHOW_ALL_INSTANCES	0x00000008
#define APLCMD_SHOW_ALL_LOTS		0x00000009
#define APLCMD_SHOW_ALL_RESOURCES		0x0000000A
#define APLCMD_SHOW_ALL_BP_INSTANCES	0x0000000B
#define APLCMD_SHOW_ALL_NOTES			0x0000000C

/**/
#define APLCMD_CREATE_APPROVAL		0x0000000D
#define APLCMD_CREATE_PRODUCT		0x0000000E
#define APLCMD_CREATE_DOCUMENT		0x0000000F
#define APLCMD_CREATE_CHARACTERISTIC	0x00000010
#define APLCMD_CREATE_CHARACTERISTIC_GROUP 	0x00000011
#define APLCMD_CREATE_BP			0x00000012
#define APLCMD_CREATE_BP_INSTANCE	0x00000013
#define APLCMD_CREATE_NOTE			0x00000014

/*   */
#define APLCMD_CHECKOUT		0x00000015
#define APLCMD_CHECKIN		0x00000016
#define APLCMD_UNDO_CHECKOUT	0x00000017

/* */
#define APLCMD_PROPERTIES	0x00000019
#define APLCMD_COPY			0x0000001A
#define APLCMD_PAST			0x0000001B

/**/
#define APLCMD_CHANGE_WFS		0x0000001C		
#define APLCMD_SHOW_WFS_HISTORY	0x0000001D		

/**/
#define APLCMD_DELETE		0x00000018
#define APLCMD_DELETE_FROM_FOLDER 0x0000001E

/*   */
#define APLCMD_DOC_VIEW					0x0000001F
#define APLCMD_DOC_EDIT					0x00000020
#define APLCMD_DOC_LAST_REVISION		0x00000021
#define APLCMD_DOC_SHOW_CHANGES			0x00000022
#define APLCMD_DOC_SHOW_ACCOCIATIONS	0x00000023
#define APLCMD_DOC_SHOW_DEPENDENCES		0x00000024
#define APLCMD_DOC_REV_MAKE_ACTIVE		0x00000025
#define APLCMD_DOC_DELETE_RELATION		0x00000026
#define APLCMD_DOC_EDIT_SUBSCRIPTION	0x00000027

/*  */
#define APLCMD_MES_CREATE 				0x00000028
#define APLCMD_MES_READ					0x00000029
#define APLCMD_MES_REPLY				0x0000002A
#define APLCMD_MES_FORWARD				0x0000002B
#define APLCMD_MES_SEND					0x0000002C
#define APLCMD_MES_SHOW_ITEMS			0x0000002D
#define APLCMD_MES_SHOW_HISTORY			0x0000002E
#define APLCMD_MES_SHOW_SUBSCRIBE_STATE	0x0000002F

/*
#define APLCMD_			0x0000
#define APLCMD_			0x0000
#define APLCMD_			0x0000
#define APLCMD_			0x0000
#define APLCMD_			0x0000
#define APLCMD_			0x0000
*/

class AFX_CLASS_EXPORT CaplPSSApp  
{
public:
	CaplPSSApp();
	
	bool RefreshCurrentItem();
	bool RefreshAllItems();
	bool CollapseItem(CaplTreeItemData* item= NULL);
	bool ExpandItem(CaplTreeItemData* item= NULL);
	bool GetChilds(aplTIArray &childs);
	CaplTreeItemData* GetParent();
	
	void CommandExecute(long cmd);

	CaplTreeItemData* m_cur_tree_item;
	CaplAPI* m_api;

private:
	long MapCmd(long cmd);
	void __refreshChildsItems(CTreeCtrl* tree, HTREEITEM item= TVI_ROOT);
};

#endif // !defined(AFX_APLPSS_H__1BCD9B6A_A09F_4BEF_9ED8_B797C6050EAA__INCLUDED_)
