#pragma once
#include "afxwin.h"
#include <apl_api.h>
#include "resource.h"
#include "aplProjectMgr.h"
#include "afxdtctl.h"
#include "apl_gui.h"

// CCreatePrjCopyDlg dialog

class CCreatePrjCopyDlg : public CaplTranslateDialog
{
	DECLARE_DYNAMIC(CCreatePrjCopyDlg)

public:
	CCreatePrjCopyDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CCreatePrjCopyDlg();

	CaplAPI *m_api;
	CaplProjectManager *m_prj_mgr;
	CaplInstance *m_src_prj;

	CaplInstance *m_new_prj;
	CaplInstance *m_parent;

	bool Init();
	
	// iSetTimeMode 0-  , -1 -   +1 - 
	
	CaplInstance *CreatePrjCopy(CaplInstance *prj, LPCTSTR src_str, LPCTSTR dst_str, CString &src_num_str, CString &dst_num_str, 
		COleDateTime &odt_base, COleDateTime &odt_new,
			bool b_copy_executors, bool b_copy_coexecutors, bool b_copy_cocustomers, bool b_copy_kurator, bool b_copy_customer);


	bool CreateDocCopy(CaplInstance *old_prj, CaplInstance *new_prj, LPCTSTR src_str, LPCTSTR dst_str);

// Dialog Data
	enum { IDD = IDD_CREATE_PRJ_COPY };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
public:
	CEdit m_src_prj_name_ctrl;
	CEdit m_src_prj_id_ctrl;
	CEdit m_dst_prj_id_ctrl;
	CEdit m_src_str_ctrl;
	CEdit m_dst_str_ctrl;
	afx_msg void OnBnClickedSelSrcPrj();
	afx_msg void OnEnChangeSrcStr();
	afx_msg void OnEnChangeDstStr();
	afx_msg void OnBnClickedOk();
	virtual BOOL OnInitDialog();
	CButton m_set_new_date_btn;
	CDateTimeCtrl m_new_date_ctrl;
	CButton m_create_new_docs_btn;
	CEdit m_folder_ctrl;
	afx_msg void OnBnClickedSelFolder();
	CComboBox m_date_type_ctrl;
	CEdit m_src_prj_num_ctrl;
	CEdit m_dst_prj_num_ctrl;
	CEdit m_src_num_str_ctrl;
	CEdit m_dst_num_str_ctrl;
	afx_msg void OnEnChangeSrcNumSubstr();
	afx_msg void OnEnChangeDstNumSubstr();
	CaplButton m_ok_btn;
	CaplButton m_cancel_btn;
	afx_msg void OnBnClickedSetNewDate();
	CButton m_copy_executors_btn;
	CButton m_copy_coexecutors_btn;
	CButton m_copy_cocustomers_btn;
	CButton m_copy_access_btn;
	CButton m_sel_perent_prj_btn;
	CButton m_copy_kurator_btn;
	CButton m_copy_owner_btn;
	CButton m_copy_customer_btn;
};
