#if !defined(AFX_GANTTVIEW_H__3CDFD84F_A091_40D6_A29F_A969D40E040A__INCLUDED_)
#define AFX_GANTTVIEW_H__3CDFD84F_A091_40D6_A29F_A969D40E040A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// GanttView.h : header file
//
#include "resource.h"
#include <apl_gui.h>


#ifdef APL_PROGECT_MGR

#include "GanttCtrl.h"
#else
#include <GanttCtrl.h>
#endif


#ifdef APL_PROGECT_MGR
#define APL_PM_CLASS_EXPORT		_declspec(dllexport)
#else
#define APL_PM_CLASS_EXPORT		_declspec(dllimport)
#endif



/////////////////////////////////////////////////////////////////////////////
// CGanttView view

class APL_PM_CLASS_EXPORT CGanttView : public CView
{
protected:
	CGanttView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CGanttView)

// Attributes
public:
	CaplTreeListCtrlView *m_tree_view;
	CGanttCtrl m_gantt;
	CScrollBar m_horScrollBar;
	bool m_bShrinkToFit;
	bool m_bShowPrognoz;    //    
	bool m_bShowRelations;  //    
	bool m_bShowFact;       //   

	CaplTAggr <CGanttItem*,CGanttItem*,APLAGGR_LIST|APLAGGR_AUTOKILLREF> m_items;

// Operations
public:
	bool ZoomOut(int step=0);
	bool ZoomIn(int step=0);
	void Initialize();
	void Update(bool bUpdateCalendar=false);
	void ResetScrollBar();

	BOOL VerticalScrollVisible();
	BOOL HorizontalScrollVisible();

	int StretchWidth(int m_nWidth, int m_nMeasure);


	void ReloadItemInfo(CGanttItem *item);
	void UpdateGanttView(bool bUpdateCalendar,bool renum=false);	


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CGanttView)
	public:
	virtual void OnInitialUpdate();
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	//}}AFX_VIRTUAL

// Implementation
protected:
	BOOL m_TLInitialized;	
	virtual ~CGanttView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CGanttView)
	afx_msg int OnMouseActivate( CWnd* pDesktopWnd,UINT nHitTest,UINT message);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_GANTTVIEW_H__3CDFD84F_A091_40D6_A29F_A969D40E040A__INCLUDED_)
