// SetupDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SetupDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSetupDlg dialog


CSetupDlg::CSetupDlg(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CSetupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetupDlg)
	//}}AFX_DATA_INIT
	m_setup=0;
}


void CSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetupDlg)
	DDX_Control(pDX, IDC_SEL_OUTBOUNDS, m_sel_outOfBounds_ctrl);
	DDX_Control(pDX, IDC_SEL_RPOJECTS_COL_DAYS, m_col_days_ctrl);
	DDX_Control(pDX, IDC_SEL_PROJECTS, m_sel_projects_ctrl);
	DDX_Control(pDX, IDC_COLUMNS, m_columns_ctrl);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetupDlg, CaplResizableDialog)
	//{{AFX_MSG_MAP(CSetupDlg)
	ON_BN_CLICKED(IDC_SEL_PROJECTS, OnSelProjects)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetupDlg message handlers

BOOL CSetupDlg::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();

	ListView_SetExtendedListViewStyle(m_columns_ctrl.m_hWnd,
		ListView_GetExtendedListViewStyle(m_columns_ctrl.m_hWnd)
			|LVS_EX_CHECKBOXES |LVS_EX_UNDERLINECOLD|LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);

	m_columns_ctrl.InsertColumn(0,_T(""),LVCFMT_LEFT,20);	
	m_columns_ctrl.InsertColumn(1,APL_T(""),LVCFMT_LEFT,170);	
	
	int i;
	for(i=0;i<m_setup->m_cols.GetSize();i++)
	{
		int	num=m_columns_ctrl.InsertItem(i,_T(""));
		m_columns_ctrl.SetItemText(num,1,m_setup->m_cols[i].name);
		if(m_setup->m_cols[i].value) m_columns_ctrl.SetCheck(num,true);
	}

	m_col_days_ctrl.SetWindowText(_T("0"));
	if(m_setup->m_bSelectProjects) 
	{
		m_sel_projects_ctrl.SetCheck(1);
		CString buf;
		buf.Format(_T("%d"),m_setup->m_colDays);
		m_col_days_ctrl.SetWindowText(buf);
		m_col_days_ctrl.EnableWindow(true);
	}
	if(m_setup->m_bSelectOutOfBoundsProjects) 
	{
		m_sel_outOfBounds_ctrl.SetCheck(1);
	}
	
	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
	
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void CSetupDlg::OnOK() 
{
	// TODO: Add extra validation here
	int i,count=0;
	for(i=0;i<m_columns_ctrl.GetItemCount();i++)
	{
		if(m_columns_ctrl.GetCheck(i))	count++;
	}
	if(!count) {AfxMessageBox(APL_T("       !"));return;}

/*	for(i=0;i<m_setup->m_bCheckValues.GetSize();i++)
	{
		*m_setup->m_bCheckValues[i]=0;
		if(m_columns_ctrl.GetCheck(i)) 
			*m_setup->m_bCheckValues[i]=1;
	}*/
	for(i=0;i<m_setup->m_cols.GetSize();i++)
	{
		m_setup->m_cols[i].value=0;
		if(m_columns_ctrl.GetCheck(i)) 
			m_setup->m_cols[i].value=1;
	}


	if(m_sel_projects_ctrl.GetCheck()==1)
	{
		m_setup->m_bSelectProjects=1;
		CString buf;
		m_col_days_ctrl.GetWindowText(buf);
		m_setup->m_colDays=_atoi(buf);
	}
	else
	{
		m_setup->m_bSelectProjects=0;
		m_setup->m_colDays=0;
	}
	if(m_sel_outOfBounds_ctrl.GetCheck()==1)
	{
		m_setup->m_bSelectOutOfBoundsProjects=1;
	}
	else
	{
		m_setup->m_bSelectOutOfBoundsProjects=0;
	}

	CaplResizableDialog::OnOK();
}

void CSetupDlg::OnSelProjects() 
{
	if(m_sel_projects_ctrl.GetCheck()==1) m_col_days_ctrl.EnableWindow(true);
	else m_col_days_ctrl.EnableWindow(false);	
}


