#pragma once

class CaplComplectMgr
{
public:
	CaplComplectMgr(CaplAPI *api);
	~CaplComplectMgr(void);

	//     
	CaplInstance* GenerateComplectByPdf(CaplInstance *order, CaplInstance *pdf);

protected:
	//      
	void Disassembly(aplExtent &parentPdfs);

	//  ,   edItem  
	void FilterByRasc(std::vector<CString> &rascVec);		

	//   
	bool ShowRelationsWithoutShop();

	//    occurence's  
	CaplInstance* CreateComplect(CaplInstance *order, CaplInstance *komplect, CaplInstance *pdf);

	void ParseRasc(CString& csInRasc,CString csDepotSep,CString csGrpSep,
		CStringArray* csapOutDepots,CStringArray* csapOutGrps, bool bErasePokrAndTermo);

	//   shopchain  apl_cnf_komplect_occurrence
	CString GetShopChain(std::map<CString, double> &valueByShop);

	//  ,    
	void FindClassifiers();

	//      
	double GetTotalPdfCount(CaplInstance *item);

	//     
	CaplInstance* FindExistingKomplect(CaplInstance *order);

	//      ,   
	CString GetShopFromRasc(CaplInstance *ingItem);

	//  
	CString GetOrderId(CaplInstance *order);

	//      
	void GetExistingOccurrences(	CaplInstance *komplect,
									std::map<CaplInstance*, CaplInstance*> &komplectOccurrences,
									std::map<std::pair<CaplInstance*, CaplInstance*>, CaplInstance*> &bomOccurrences);
	
protected:
	CaplAPI *m_api;	

	// ,   edItem
	std::map<CaplInstance*, std::vector<CaplInstance*>> m_relationsByEd;	

	//      
	std::map<CaplInstance*, CaplInstance*> m_pdfsRasc;

	// : -
	std::map<CaplInstance*, CaplInstance*> m_pkiClassifiers;

	//    
	std::map<CaplInstance*, std::vector<CaplInstance*>> m_allPdfs;
};
