// CategoryDiffDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CategoryDiffDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCategoryDiffDlg dialog


CCategoryDiffDlg::CCategoryDiffDlg(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CCategoryDiffDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCategoryDiffDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_api=NULL;
	m_inst=NULL;
	m_ListCategoryDiff.SetUniqueName(_T("apl_psm_addin_list_category_diff"));


	cColNames[ColProductId]		= (TCHAR*)APL_T("");
	cColNames[ColProductName]	= (TCHAR*)APL_T("");
	cColNames[ColInsAuthor]		= (TCHAR*)APL_T("");
	cColNames[ColInsDate]		= (TCHAR*)APL_T(" ");
	cColNames[ColInsVersionNo]	= (TCHAR*)APL_T("");
	cColNames[ColDelAuthor]		= (TCHAR*)APL_T("");
	cColNames[ColDelDate]		= (TCHAR*)APL_T(" ");
	cColNames[ColDelVersionNo]	= (TCHAR*)APL_T("");

	iColSizes[0]=100;
	iColSizes[1]=100;
	iColSizes[2]=80;
	iColSizes[3]=120;
	iColSizes[4]=50;
	iColSizes[5]=50;
	iColSizes[6]=100;
	iColSizes[7]=50;
}


void CCategoryDiffDlg::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCategoryDiffDlg)
	DDX_Control(pDX, IDC_LIST_FRAME, m_ListFrame);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCategoryDiffDlg, CResizableDialog)
	//{{AFX_MSG_MAP(CCategoryDiffDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCategoryDiffDlg message handlers

BOOL CCategoryDiffDlg::OnInitDialog()
{
	CResizableDialog::OnInitDialog();
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   
	
	// TODO: Add extra initialization here
	SetControlsPositions();
	SetControlsAnchors();

	AddListColumns();
	FillTable();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CCategoryDiffDlg::SetControlsPositions()
{
	RECT rect={5,5,10,10};
	
	m_ListCategoryDiff.Create
							(
								WS_VISIBLE|WS_CHILD|WS_BORDER|LVS_SORTASCENDING,
								rect,
								this,
								IDC_LIST_CAT_CTRL
							);

	m_ListFrame.GetWindowRect(&rect);
	ScreenToClient(&rect);
	m_ListCategoryDiff.MoveWindow(&rect);

	return TRUE;

}

BOOL CCategoryDiffDlg::SetControlsAnchors()
{
	AddAnchor(IDOK, BOTTOM_RIGHT);
	AddAnchor(IDC_LIST_CAT_CTRL, TOP_LEFT,BOTTOM_RIGHT);

	return TRUE;
}

BOOL CCategoryDiffDlg::AddListColumns()
{
	int iColNo=0;

	for(iColNo=ColFirstColumn;iColNo<=ColLastColumn;iColNo++)
	{
		m_ListCategoryDiff.InsertColumn
										(
											iColNo,
											cColNames[iColNo],
											LVCFMT_LEFT,
											iColSizes[iColNo]
										);
	}

	return TRUE;
}

BOOL CCategoryDiffDlg::FillTable()
{

	if(!m_api->m_data.IsKindOf(m_inst,m_api->m_categ_mgr.e_categ))
		return FALSE;

	//	   
	aplExtent		aeUnsortedVersions;
	//	      
	aplExtent		aeSortedVersions;

	//	    
	aplExtent		aeCurrVersionProducts;
	//	    
	aplExtent		aePrevVersionProducts;

	int i=0,j=0,k=0,iRowNo=0;

	
	//	      
	m_api->m_categ_mgr.GetAllCategoryVersion(m_inst,aeUnsortedVersions);
	//	    .   - ,  - 
	SortVersions(aeUnsortedVersions,aeSortedVersions);
	//	   
	m_api->m_categ_mgr.LoadCategoryInfo(aeSortedVersions,TRUE);

	//	    
	for(i=0;i<aeSortedVersions.GetSize();i++)
	{
		//	     
		m_api->m_data.GetAttr
							(
								aeSortedVersions[i],
								m_api->m_categ_mgr.a_categ_ver_products,
								aeCurrVersionProducts
							);
		//	     
		for(j=0;j<aeCurrVersionProducts.GetSize();j++)
		{
			//	       ( )
			if(0==i)
			{
				AddProductId(	aeCurrVersionProducts[j],	iRowNo);
				AddProductName(	aeCurrVersionProducts[j],	iRowNo);
				AddInsVersionNo(aeSortedVersions[i],		iRowNo);
				AddInsAuthor(	aeSortedVersions[i],		iRowNo);
				AddInsDate(		aeSortedVersions[i],		iRowNo);
				//	- 
				m_ListCategoryDiff.SetItemData(iRowNo,(DWORD)aeCurrVersionProducts[j]);
				//	       
				aePrevVersionProducts.Add(aeCurrVersionProducts[j]);
			}
			//	        (  )
			else
			{
				//	,       
				//	   -  
				if(-1==aePrevVersionProducts.Find(aeCurrVersionProducts[j]))
				{
					AddProductId(	aeCurrVersionProducts[j],	iRowNo);
					AddProductName(	aeCurrVersionProducts[j],	iRowNo);
					AddInsVersionNo(aeSortedVersions[i],		iRowNo);
					AddInsAuthor(	aeSortedVersions[i],		iRowNo);
					AddInsDate(		aeSortedVersions[i],		iRowNo);
					//	- 
					m_ListCategoryDiff.SetItemData(iRowNo,(DWORD)aeCurrVersionProducts[j]);
				}
			}
		}
		//	      
		for(k=0;k<aePrevVersionProducts.GetSize();k++)
		{
			//	         
			//	  -     
			if(-1==aeCurrVersionProducts.Find(aePrevVersionProducts[k]))
			{
				int itItemIndex=0,ii=0;

				for(ii=0;ii<m_ListCategoryDiff.GetItemCount();ii++)
				{
					if(aePrevVersionProducts[k]==(CaplInstance*)m_ListCategoryDiff.GetItemData(ii))
						itItemIndex=ii;
				}
				AddDelAuthor(	aeSortedVersions[i],	itItemIndex);
				AddDelVersionNo(aeSortedVersions[i],	itItemIndex);
				AddDelDate(		aeSortedVersions[i],	itItemIndex);
			}
		}

		if(0!=i)
		{
			int t=0;
			aePrevVersionProducts.Clear();
			for(t=0;t<aeCurrVersionProducts.GetSize();t++)
				aePrevVersionProducts.Add(aeCurrVersionProducts[t]);
		}
	}
/*
     i  
		     
		 j    
			      (  ):
				   
				     
				     
			     :
				,      
					   -  .
						   
						     
					  -    (  )
				           
					  -   
					  -    .
						     
				        
*/
	return TRUE;
}

BOOL CCategoryDiffDlg::SortVersions(aplExtent &aplUnsorted, aplExtent &aplSorted)
{
	//	     ( )
	CaplInstance*	ciCurrVersion=NULL;
	//	     ( )
	CaplInstance*	ciPrevVersion=NULL;

	int i=0;
	//	         aeSortedVersions
	while(TRUE)
	{
		//	    
		BOOL	bIsConditionWorked=FALSE;
		//	    
		for(i=0;i<aplUnsorted.GetSize();i++)
		{
			//	        
			m_api->m_data.GetAttr
								(
									aplUnsorted[i],
									m_api->m_categ_mgr.a_categ_ver_prev,
									ciPrevVersion
								);
			//	          - 
			//	      ,
			//	     ,
			//	     
			//	    "for".
			//	         NULL!
			if(ciCurrVersion==ciPrevVersion)
			{
				ciCurrVersion=aplUnsorted[i];
				aplSorted.Add(ciCurrVersion);
				bIsConditionWorked=TRUE;
				break;
			}
		}
		//	   -  
		if(TRUE==bIsConditionWorked)
		{
			i=0;
			continue;
		}
		//	  -      .
		//	 .
		else
			break;
	}
/*
	TRACE("***********************************************\n");
	TRACE("unsorted elements %d\n",aplUnsorted.GetSize());
	TRACE("sorted elements %d\n",aplSorted.GetSize());
	TRACE("***********************************************\n");
*/
	return TRUE;
}


BOOL CCategoryDiffDlg::AddProductId(CaplInstance* caplIns, int& iRow)
{
	CString			csOutTextField;
	//	  
	m_api->m_data.GetAttr
						(
							caplIns,
							m_api->m_prd_mgr.a_prd_id,
							csOutTextField
						);
	//	  
	iRow=m_ListCategoryDiff.InsertItem(iRow,csOutTextField);

	return TRUE;
}

BOOL CCategoryDiffDlg::AddProductName(CaplInstance* caplIns, int& iRow)
{
	CString			csOutTextField;
	//	  
	m_api->m_data.GetAttr
						(
							caplIns,
							m_api->m_prd_mgr.a_prd_name,
							csOutTextField
						);
	//	  
	m_ListCategoryDiff.SetItemText(iRow,ColProductName,csOutTextField);


	return TRUE;
}

BOOL CCategoryDiffDlg::AddInsVersionNo(CaplInstance* caplIns, int& iRow)
{
	CString			csOutTextField;
	//	  
	m_api->m_data.GetAttr
						(
							caplIns,
							m_api->m_categ_mgr.a_categ_ver_num,
							csOutTextField
						);
	//	   (  )
	m_ListCategoryDiff.SetItemText(iRow,ColInsVersionNo,csOutTextField);

	return TRUE;
}

BOOL CCategoryDiffDlg::AddInsAuthor(CaplInstance* caplIns, int& iRow)
{
	CaplInstance*	ciChangeAuthor=NULL;
	CString			csOutTextField;
	//	   ()
	m_api->m_data.GetAttr
						(
							caplIns,
							m_api->m_categ_mgr.a_categ_ver_author,
							ciChangeAuthor
						);
	m_api->m_appr_mgr.GetPersonName(ciChangeAuthor,csOutTextField);
	//	  
	m_ListCategoryDiff.SetItemText(iRow,ColInsAuthor,csOutTextField);

	return TRUE;
}

BOOL CCategoryDiffDlg::AddInsDate(CaplInstance* caplIns, int& iRow)
{
	CString			csOutTextField;
	COleDateTime	codtDate;
	//	   ()
	m_api->m_data.GetAttr
						(
							caplIns,
							m_api->m_categ_mgr.a_categ_ver_end,
							csOutTextField
						);
	//	   
	aplString2Date(csOutTextField,codtDate);
	//	    
	csOutTextField=codtDate.Format(_T("%d:%m:%Y %H:%M:%S"));
	//	  
	m_ListCategoryDiff.SetItemText(iRow,ColInsDate,csOutTextField);


	return TRUE;
}

BOOL CCategoryDiffDlg::AddDelAuthor(CaplInstance* caplIns, int& iRow)
{
	CaplInstance*	ciChangeAuthor=NULL;
	CString			csOutTextField;
	//	   ()
	m_api->m_data.GetAttr
						(
							caplIns,
							m_api->m_categ_mgr.a_categ_ver_author,
							ciChangeAuthor
						);
	m_api->m_appr_mgr.GetPersonName(ciChangeAuthor,csOutTextField);
	//	  
	m_ListCategoryDiff.SetItemText(iRow,ColDelAuthor,csOutTextField);

	return TRUE;
}

BOOL CCategoryDiffDlg::AddDelDate(CaplInstance* caplIns, int& iRow)
{
	CString			csOutTextField;
	COleDateTime	codtDate;
	//	   ()
	m_api->m_data.GetAttr
						(
							caplIns,
							m_api->m_categ_mgr.a_categ_ver_end,
							csOutTextField
						);
	//	   
	aplString2Date(csOutTextField,codtDate);
	//	    
	csOutTextField=codtDate.Format(_T("%d:%m:%Y %H:%M:%S"));
	//	  
	m_ListCategoryDiff.SetItemText(iRow,ColDelDate,csOutTextField);

	return TRUE;
}

BOOL CCategoryDiffDlg::AddDelVersionNo(CaplInstance* caplIns, int& iRow)
{
	CString			csOutTextField;
	//	  
	m_api->m_data.GetAttr
						(
							caplIns,
							m_api->m_categ_mgr.a_categ_ver_num,
							csOutTextField
						);

	//	   (  )
	m_ListCategoryDiff.SetItemText(iRow,ColDelVersionNo,csOutTextField);

	return TRUE;
}
