// Dlg_pdf_dot.cpp : implementation file
//

#include "stdafx.h"
#include "ChangeMkStateDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChangeMkStateDlg dialog


CChangeMkStateDlg::CChangeMkStateDlg(CaplAPI *api, aplExtent &pdfs, CWnd* pParent)
	: CaplResizableDialog(CChangeMkStateDlg::IDD, pParent), m_api(api), m_pdfs(pdfs)
{	
}

void CChangeMkStateDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);	

	DDX_Control(pDX, IDOK, m_okBtn);
	DDX_Control(pDX, IDCANCEL, m_cancelBtn);
	DDX_Control(pDX, IDC_DATA_INPUT, m_dataInputBtn);
	DDX_Control(pDX, IDC_DATA_CHECK, m_dataCheckBtn);
	DDX_Control(pDX, IDC_DATA_LIMIT, m_dataLimitBtn);
	DDX_Control(pDX, IDC_NULL_STATE, m_nullStateBtn);
}

BEGIN_MESSAGE_MAP(CChangeMkStateDlg, CaplResizableDialog)			
	ON_BN_CLICKED(IDC_NULL_STATE, OnBnClickedState)	
	ON_BN_CLICKED(IDC_DATA_INPUT, OnBnClickedState)	
	ON_BN_CLICKED(IDC_DATA_CHECK, OnBnClickedState)	
	ON_BN_CLICKED(IDC_DATA_LIMIT, OnBnClickedState)	
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChangeMkStateDlg message handlers

void CChangeMkStateDlg::OnOK() 
{
	CaplAdminModeProvider adminmode(&(m_api->m_data),-1, -1,DEF_SOURCE);

	CString state;
	for(std::map<CButton*, CString>::iterator it=m_btnToState.begin(); it!=m_btnToState.end(); ++it)
	{
		if(it->first->GetCheck() == BST_CHECKED)
		{
			state = it->second;
			break;
		}
	}

	for(int i=0; i<m_pdfs.Size; ++i)
		m_api->m_data.PutAttr(m_pdfs[i], m_api->m_prd_mgr.a_apl_pdf_additional_data, state);
	m_api->SaveChanges();

	adminmode.ExitAdminMode();

	__super::OnOK();
}

BOOL CChangeMkStateDlg::OnInitDialog() 
{
	BOOL ret = __super::OnInitDialog();				
	if(m_api==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));

	InitOkCancelButton(m_okBtn, m_cancelBtn);

	m_btnToState[&m_nullStateBtn] = _T("");
	m_btnToState[&m_dataInputBtn] = _T("need_data_input");
	m_btnToState[&m_dataCheckBtn] = _T("need_data_check");
	m_btnToState[&m_dataLimitBtn] = _T("need_data_limits");

	CString state;
	for(int i=0; i<m_pdfs.Size; ++i)
	{		
		m_api->m_data.GetAttr(m_pdfs[i], m_api->m_prd_mgr.a_apl_pdf_additional_data, state);

		for(std::map<CButton*, CString>::iterator it=m_btnToState.begin(); it!=m_btnToState.end(); ++it)
		{
			if(state == it->second)
			{
				it->first->SetCheck(BST_CHECKED);
				break;
			}
		}

		break;
	}

	SetEnable();
	return ret;
}

void CChangeMkStateDlg::CanChangeMkState()
{
	for(std::map<CButton*, CString>::iterator it=m_btnToState.begin(); it!=m_btnToState.end(); ++it)
	{
		if(it->first->GetCheck() == BST_CHECKED && it->first->IsWindowEnabled() == FALSE)
		{
			m_okBtn.EnableWindow(FALSE);
			return;
		}
	}
}

void CChangeMkStateDlg::SetEnable()
{
	bool bShopTech = m_api->m_appr_mgr.CheckPersonRole(m_api->m_appr_mgr.GetCurrentPerson(), APL_T(" "));
	bool bBrtpTech = m_api->m_appr_mgr.CheckPersonRole(m_api->m_appr_mgr.GetCurrentPerson(), APL_T(" "));

	if(m_api->m_data.IsAdmin() || (bShopTech && bBrtpTech))
		return;

	if(bShopTech)
	{
		m_dataCheckBtn.EnableWindow(FALSE);				
		return;
	}

	if(bBrtpTech)
	{
		m_dataInputBtn.EnableWindow(FALSE);
		m_nullStateBtn.EnableWindow(FALSE);
		m_dataLimitBtn.EnableWindow(FALSE);
		return;
	}	
}

void CChangeMkStateDlg::OnBnClickedState()
{
	for(std::map<CButton*, CString>::iterator it=m_btnToState.begin(); it!=m_btnToState.end(); ++it)
	{
		if(it->first->GetCheck() == BST_CHECKED && it->first->IsWindowEnabled() == FALSE)
		{
			it->first->SetCheck(BST_UNCHECKED)	;
		}
	}
}
