// ChangeProductAttrsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ChangeProductAttrsDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChangeProductAttrsDlg dialog


CChangeProductAttrsDlg::CChangeProductAttrsDlg(CaplAPI* api, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CChangeProductAttrsDlg::IDD, pParent)
{
	m_api = NULL;
	m_Item = NULL;
	m_Person = NULL;
	m_CreatedInst = NULL;
	//{{AFX_DATA_INIT(CChangeProductAttrsDlg)
	m_dtDate = COleDateTime::GetCurrentTime();
	m_sNewCode = _T("");
	m_sNewId = _T("");
	m_sNewName = _T("");
	m_sOldCode = _T("");
	m_sOldId = _T("");
	m_sPerson = _T("");
	m_sOldName = _T("");
	//}}AFX_DATA_INIT
}


void CChangeProductAttrsDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CChangeProductAttrsDlg)
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_DateTimeCtrl(pDX, IDC_DATETIME, m_dtDate);
	DDX_Text(pDX, IDC_NEW_CODE, m_sNewCode);
	DDX_Text(pDX, IDC_NEW_ID, m_sNewId);
	DDX_Text(pDX, IDC_NEW_NAME, m_sNewName);
	DDX_Text(pDX, IDC_OLD_CODE, m_sOldCode);
	DDX_Text(pDX, IDC_OLD_ID, m_sOldId);
	DDX_Text(pDX, IDC_PERSON_NAME, m_sPerson);
	DDX_Text(pDX, IDC_OLD_NAME, m_sOldName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CChangeProductAttrsDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CChangeProductAttrsDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChangeProductAttrsDlg message handlers

void CChangeProductAttrsDlg::OnOK() 
{
	if(!UpdateData()) return;

	m_sNewId.TrimLeft(); m_sNewId.TrimRight();
	m_sNewName.TrimLeft(); m_sNewName.TrimRight();
	m_sNewCode.TrimLeft(); m_sNewCode.TrimRight();
	
	if(m_sOldId==m_sNewId && m_sOldName==m_sNewName && m_sOldCode==m_sNewCode)
	{
		AfxMessageBox( APL_T("   !"), MB_OK|MB_ICONSTOP);
		return;
	}
	
	CaplAttrValue tst_val;
	tst_val.value.Set(m_sNewId);
	if(m_api->m_data.IsKindOf(m_Item, m_api->m_prd_mgr.e_prd))
	{
		tst_val.attr = m_api->m_prd_mgr.a_prd_id;
		if(!m_api->m_data.NET_TestUniqueAttrValues(m_Item->GetType(), m_Item, 1, &tst_val, false))
		{
			AfxMessageBox( APL_T("       !"), MB_OK|MB_ICONWARNING);
			return;
		}
	}
	else if(m_api->m_data.IsKindOf(m_Item, m_api->m_prd_mgr.e_apl_export_product))
	{
		tst_val.attr = m_api->m_prd_mgr.a_apl_export_product_id;
		if(!m_api->m_data.NET_TestUniqueAttrValues(m_Item->GetType(), m_Item, 1, &tst_val, false))
		{
			AfxMessageBox( APL_T("       !"), MB_OK|MB_ICONWARNING);
			return;
		}
	}

	CString buf;
	aplDate2String(m_dtDate, buf);
	CaplInstance *nInst = m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_apl_product_attrs_change);
	ASSERT(nInst);
	
	m_api->m_data.PutAttr(nInst, m_api->m_prd_mgr.a_apl_product_attrs_change_code, m_sOldCode);
	m_api->m_data.PutAttr(nInst, m_api->m_prd_mgr.a_apl_product_attrs_change_name, m_sOldName);
	m_api->m_data.PutAttr(nInst, m_api->m_prd_mgr.a_apl_product_attrs_change_id, m_sOldId);
	m_api->m_data.PutAttr(nInst, m_api->m_prd_mgr.a_apl_product_attrs_change_person, m_Person);
	m_api->m_data.PutAttr(nInst, m_api->m_prd_mgr.a_apl_product_attrs_change_item, m_Item);
	m_api->m_data.PutAttr(nInst, m_api->m_prd_mgr.a_apl_product_attrs_change_datetime, buf);
	m_api->m_data.PutAttr(nInst, m_api->m_prd_mgr.a_apl_product_attrs_change_next, m_api->m_prd_mgr.FindLastestAttrChange(m_Item, true));
	
	if(m_api->m_data.IsKindOf(m_Item, m_api->m_prd_mgr.e_prd))
	{
		m_api->m_data.PutAttr(m_Item, m_api->m_prd_mgr.a_prd_id, m_sNewId);
		m_api->m_data.PutAttr(m_Item, m_api->m_prd_mgr.a_prd_name, m_sNewName);
		m_api->m_data.PutAttr(m_Item, m_api->m_prd_mgr.a_prd_code, m_sNewCode);
	}
	else if(m_api->m_data.IsKindOf(m_Item, m_api->m_prd_mgr.e_apl_export_product))
	{
		m_api->m_data.PutAttr(m_Item, m_api->m_prd_mgr.a_apl_export_product_id, m_sNewId);
		m_api->m_data.PutAttr(m_Item, m_api->m_prd_mgr.a_apl_export_product_name, m_sNewName);
		m_api->m_data.PutAttr(m_Item, m_api->m_prd_mgr.a_apl_export_product_code, m_sNewCode);
	}
	
	m_api->m_prd_mgr.ChangeWFState(nInst, _T("approved"));
	
	m_api->SaveChanges();

	CaplTranslateDialog::OnOK();
}

BOOL CChangeProductAttrsDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	
	if(m_Item==NULL)
	{
		EndDialog(0);
		return FALSE;
	}
	if(m_api->m_data.IsKindOf(m_Item, m_api->m_prd_mgr.e_prd))
	{
		m_api->m_data.GetAttr(m_Item, m_api->m_prd_mgr.a_prd_id, m_sOldId);
		m_api->m_data.GetAttr(m_Item, m_api->m_prd_mgr.a_prd_name, m_sOldName);
		m_api->m_data.GetAttr(m_Item, m_api->m_prd_mgr.a_prd_code, m_sOldCode);
	}
	else if(m_api->m_data.IsKindOf(m_Item, m_api->m_prd_mgr.e_apl_export_product))
	{
		m_api->m_data.GetAttr(m_Item, m_api->m_prd_mgr.a_apl_export_product_id, m_sOldId);
		m_api->m_data.GetAttr(m_Item, m_api->m_prd_mgr.a_apl_export_product_name, m_sOldName);
		m_api->m_data.GetAttr(m_Item, m_api->m_prd_mgr.a_apl_export_product_code, m_sOldCode);
	}

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
