// ClassifierSystemDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "ClassifierSystemDlg.h"
//#include "CharacterysticTypeForced.h"
#include "apl_gui.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define my_mgr m_api->m_classifier_mgr
int count_inst_dlg=-1;

extern HINSTANCE CaplFormManagerDlgDLL;
/////////////////////////////////////////////////////////////////////////////
// CClassifierSystemDlg dialog


CClassifierSystemDlg::CClassifierSystemDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CClassifierSystemDlg::IDD, pParent)
	, m_IsMultiObject(FALSE)
{
	count_inst_dlg++;
	//{{AFX_DATA_INIT(CClassifierSystemDlg)
	m_sDescr = _T("");
	m_sId = _T("");
	m_sName = _T("");
	m_iConceptLevelMin = 0;
	m_iConceptLevelMax = 0;	
	m_iObjectLevelMin = 0;	
	m_iObjectLevelMax = 0;	
	m_SystemName = _T("");
	//}}AFX_DATA_INIT

	m_bSystem = true;
	m_readonly=false;
	m_can_object=true;

	m_DeleteEsquisse=false;

	m_item=0;
	m_api=0;
	m_system=0;
	m_parent=0;
	m_selected_char=0;
	m_ListCharact.SetUniqueName(_T("apl_psm_list_charact_and_type"));

	m_NameNewEsquisse=_T("");

	m_tab_levels=0;
	m_tab_edited_chars=1;
	m_tab_esquisse=0;
	m_tab_forms=0;

	m_EsquisseDescr=_T("");
	m_FormDescr=_T("");
	m_CurrNameEntity=_T("");
	m_FormManagerDlg=0;
	
}

CClassifierSystemDlg::~CClassifierSystemDlg()
{
	count_inst_dlg--;
}

void CClassifierSystemDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CClassifierSystemDlg)
	DDX_Control(pDX, IDC_EDIT_PICT_PROPERTIES, m_EdtPictProro);
	DDX_Control(pDX, IDC_PICTURE, m_CtrlPicture);
	DDX_Control(pDX, IDC_STATIC_TAB_SIZE, m_StaticTabSize);
	DDX_Control(pDX, IDC_TAB_SELECT, m_TabSelect);
	DDX_Control(pDX, IDC_STATIC_CHARACT_GROUP, m_StaticCharactGroup);
	DDX_Control(pDX, IDC_BUTTON_REMOVE, m_BtnCharRemove);
	DDX_Control(pDX, IDC_BUTTON_PROPERTY, m_BtnCharProp);
	DDX_Control(pDX, IDC_BUTTON_ADD, m_BtnCharAdd);
	DDX_Control(pDX, IDC_ST_CLASSIFIER_NAME, m_StaticClassifierName);
	DDX_Control(pDX, IDC_STATIC_IDENTIF, m_StaticIdentif);
	DDX_Control(pDX, IDC_STATIC_SYSTEM, m_StaticSystem);
	DDX_Control(pDX, IDC_STATIC_LEVEL, m_StaticLevel);
	DDX_Control(pDX, IDC_STATIC_CONCEPT_GROUP, m_StaticConceptGroup);
	DDX_Control(pDX, IDC_STATIC_IS_CONCEPT_LEVEL_CONTROL, m_StaticIsConceptLevelControl);
	DDX_Control(pDX, IDC_BUTTON_SHOW_PARENT_CONCEPT_SETTING, m_BtnParentConceptControl);
	DDX_Control(pDX, IDC_STATIC_CONCEPT_LEVEL_SWITCH, m_StaticConceptLevelSwitch);
	DDX_Control(pDX, IDC_STATIC_CONCEPT_LEVEL_MIN, m_StaticConceptLevelMin);
	DDX_Control(pDX, IDC_STATIC_CONCEPT_LEVEL_MAX, m_StaticConceptLevelMax);
	DDX_Control(pDX, IDC_STATIC_OBJECT_GROUP, m_StaticObjectGroup);
	DDX_Control(pDX, IDC_STATIC_IS_OBJECT, m_StaticIsObject);
	DDX_Control(pDX, IDC_STATIC_IS_OBJECT_LEVEL_CONTROL, m_StaticIsObjectLevelControl);
	DDX_Control(pDX, IDC_BUTTON_SHOW_PARENT_OBJECT_SETTING, m_BtnParentObjectControl);
	DDX_Control(pDX, IDC_STATIC_OBJECT_LEVEL_SWITCH, m_StaticObjectLevelSwitch);
	DDX_Control(pDX, IDC_STATIC_OBJECT_LEVEL_MIN, m_StaticObjectLevelMin);
	DDX_Control(pDX, IDC_STATIC_OBJECT_LEVEL_MAX, m_StaticObjectLevelMax);
	DDX_Control(pDX, IDC_STATIC_OBJECT_TYPE_GROUP, m_StaticObjectTypeGroup);
	DDX_Control(pDX, IDC_STATIC_IS_TYPE_CONTROL, m_StaticIsTypeControl);
	DDX_Control(pDX, IDC_STATIC_LIST_TYPE_CONTROL, m_StaticListTypeControl);
	DDX_Control(pDX, IDC_STATIC_CODE, m_StaticCode);
	DDX_Control(pDX, IDC_COMBO_IS_TYPE_CONTROL, m_CmbxIsTypeControl);
	DDX_Control(pDX, IDC_BUTTON_SHOW_PARENT_OBJECT_TYPE_SETTING, m_BtnParentObjectTypeControl);
	DDX_Control(pDX, IDC_COMBO_TYPE_CONTROL, m_CmbxTypeControl);
	DDX_Control(pDX, IDC_COMBO_IS_CONCEPT_LEVEL_CONTROL, m_CmbxIsConceptLevelControl);
	DDX_Control(pDX, IDC_COMBO_CONCEPT_LEVEL_SWITCH, m_CmbxConceptLevelSwitch);
	DDX_Control(pDX, IDC_COMBO_IS_OBJECT, m_CmbxIsObject);
	DDX_Control(pDX, IDC_COMBO_IS_OBJECT_LEVEL_CONTROL, m_CmbxIsObjectLevelControl);
	DDX_Control(pDX, IDC_COMBO_OBJECT_LEVEL_SWITCH, m_CmbxObjectLevelSwitch);
	DDX_Control(pDX, IDC_EDIT_CONCEPT_LEVEL_MIN, m_EditConceptLevelMin);
	DDX_Control(pDX, IDC_EDIT_CONCEPT_LEVEL_MAX, m_EditConceptLevelMax);
	DDX_Control(pDX, IDC_EDIT_OBJECT_LEVEL_MIN, m_EditObjectLevelMin);
	DDX_Control(pDX, IDC_EDIT_OBJECT_LEVEL_MAX, m_EditObjectLevelMax);
	DDX_Text(pDX, IDC_EDIT_CONCEPT_LEVEL_MIN, m_iConceptLevelMin);
	DDV_MinMaxInt(pDX, m_iConceptLevelMin, -1, 1000);
	DDX_Text(pDX, IDC_EDIT_CONCEPT_LEVEL_MAX, m_iConceptLevelMax);
	DDV_MinMaxInt(pDX, m_iConceptLevelMax, -1, 1000);
	DDX_Text(pDX, IDC_EDIT_OBJECT_LEVEL_MIN, m_iObjectLevelMin);
	DDV_MinMaxInt(pDX, m_iObjectLevelMin, -1, 1000);
	DDX_Text(pDX, IDC_EDIT_OBJECT_LEVEL_MAX, m_iObjectLevelMax);
	DDV_MinMaxInt(pDX, m_iObjectLevelMax, -1, 1000);
	DDX_Control(pDX, IDC_EDIT_SYSTEM, m_EditSystem);
	DDX_Control(pDX, IDC_EDIT_LEVEL, m_EditLevel);
	DDX_Control(pDX, IDC_NAME, m_EditName);
	DDX_Control(pDX, IDC_ID, m_EditId);
	DDX_Control(pDX, IDC_CODE, m_EditCode);
	DDX_Control(pDX, IDC_DESCRIPTION, m_EditDescr);
	DDX_Control(pDX, IDOK, m_BtnOk);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	DDX_Text(pDX, IDC_DESCRIPTION, m_sDescr);
	DDX_Text(pDX, IDC_ID, m_sId);
	DDX_Text(pDX, IDC_CODE, m_sCode);
	DDX_Text(pDX, IDC_NAME, m_sName);
	DDX_Text(pDX, IDC_EDIT_SYSTEM, m_SystemName);
	DDX_Text(pDX, IDC_EDIT_LEVEL, m_LevelName);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_CHECK_MULTI_OBJECT, m_CtrlMultiObject);
	DDX_Check(pDX, IDC_CHECK_MULTI_OBJECT, m_IsMultiObject);
}


BEGIN_MESSAGE_MAP(CClassifierSystemDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CClassifierSystemDlg)
	ON_CBN_SELCHANGE(IDC_COMBO_IS_CONCEPT_LEVEL_CONTROL, OnEditchangeCombo)
	ON_BN_CLICKED(IDC_BUTTON_SHOW_PARENT_CONCEPT_SETTING, OnButtonShowParentConceptSetting)
	ON_BN_CLICKED(IDC_BUTTON_SHOW_PARENT_OBJECT_SETTING, OnButtonShowParentObjectSetting)
	ON_BN_CLICKED(IDC_BUTTON_SHOW_PARENT_OBJECT_TYPE_SETTING, OnButtonShowParentObjectTypeSetting)
	ON_BN_CLICKED(IDC_BUTTON_ADD, OnButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_PROPERTY, OnButtonProperty)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE, OnButtonRemove)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_SELECT, OnSelchangeTabSelect)
	ON_CBN_SELCHANGE(IDC_COMBO_CONCEPT_LEVEL_SWITCH, OnEditchangeCombo)
	ON_CBN_SELCHANGE(IDC_COMBO_IS_OBJECT_LEVEL_CONTROL, OnEditchangeCombo)
	ON_CBN_SELCHANGE(IDC_COMBO_IS_OBJECT, OnEditchangeCombo)
	ON_CBN_SELCHANGE(IDC_COMBO_OBJECT_LEVEL_SWITCH, OnEditchangeCombo)
	ON_CBN_SELCHANGE(IDC_COMBO_IS_TYPE_CONTROL, OnEditchangeCombo)
	ON_CBN_SELCHANGE(IDC_COMBO_TYPE_CONTROL, OnEditchangeCombo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CClassifierSystemDlg message handlers



BOOL CClassifierSystemDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	if(m_api==0) return FALSE;

	m_CmbxIsObject.ResetContent();
	m_CmbxIsObject.InsertString(0,APL_T(" "));
	m_CmbxIsObject.InsertString(1,APL_T("   "));

	m_CmbxIsConceptLevelControl.ResetContent();
	m_CmbxIsConceptLevelControl.InsertString(0,APL_T(" "));
	m_CmbxIsConceptLevelControl.InsertString(1,APL_T(""));

	m_CmbxConceptLevelSwitch.ResetContent();
	m_CmbxConceptLevelSwitch.InsertString(0,APL_T(""));
	m_CmbxConceptLevelSwitch.InsertString(1,APL_T(""));

	m_CmbxIsObjectLevelControl.ResetContent();
	m_CmbxIsObjectLevelControl.InsertString(0,APL_T(" "));
	m_CmbxIsObjectLevelControl.InsertString(1,APL_T(""));

	m_CmbxObjectLevelSwitch.ResetContent();
	m_CmbxObjectLevelSwitch.InsertString(0,APL_T(""));
	m_CmbxObjectLevelSwitch.InsertString(1,APL_T(""));

	m_CmbxIsTypeControl.ResetContent();
	m_CmbxIsTypeControl.InsertString(0,APL_T(""));
	m_CmbxIsTypeControl.InsertString(1,APL_T(""));

	
	m_BtnCancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_BtnCancel.SetFlat(FALSE);
	m_BtnOk.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_BtnOk.SetFlat(FALSE);
	m_BtnParentConceptControl.SetFlat(FALSE);
	m_BtnParentObjectControl.SetFlat(FALSE);
	m_BtnParentObjectTypeControl.SetFlat(FALSE);


	m_BtnCharAdd.SetFlat(FALSE);
	m_BtnCharAdd.SetIcon(GetAplTableIco(APL_TABLE_NEW));
	m_BtnCharProp.SetFlat(FALSE);
	m_BtnCharProp.SetIcon(GetAplTableIco(APL_TABLE_PROP));
	m_BtnCharRemove.SetFlat(FALSE);
	m_BtnCharRemove.SetIcon(GetAplTableIco(APL_TABLE_DEL));

	m_CmbxIsConceptLevelControl.SetCurSel(0);
	m_CmbxConceptLevelSwitch.SetCurSel(0);
	m_CmbxIsObject.SetCurSel(0);
	m_CmbxIsObjectLevelControl.SetCurSel(0);
	m_CmbxObjectLevelSwitch.SetCurSel(0);
	m_CmbxIsTypeControl.SetCurSel(0);
	bool bval,bval1;
//	CaplInstance* inst;
	int pos;
	int i_level;

	if(m_item!=0){
		//     RO -   
		m_readonly=(m_readonly)?m_readonly:(m_item->GetAccessmode()>aplRW);
		if(m_api->m_data.IsKindOf(m_item, my_mgr.e_apl_classifier_system))
		{
			m_bSystem=true;
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_id, m_sId);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_name, m_sName);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_descr, m_sDescr);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_parent , m_parent);
			if(m_parent!=0){
				m_api->GetItemName(m_parent,m_SystemName);
			}
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_is_concept_level_control, bval);
			m_CmbxIsConceptLevelControl.SetCurSel(bval?1:0);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_is_concept_last_level, bval);
			m_CmbxConceptLevelSwitch.SetCurSel(bval?0:1);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_concept_maxlevel, m_iConceptLevelMax);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_concept_minlevel, m_iConceptLevelMin);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_can_store_object, bval);
			m_CmbxIsObject.SetCurSel(bval?1:0);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_is_object_level_control, bval);
			m_CmbxIsObjectLevelControl.SetCurSel(bval?1:0);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_is_object_last_level, bval);
			m_CmbxObjectLevelSwitch.SetCurSel(bval?0:1);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_object_maxlevel, m_iObjectLevelMax);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_object_minlevel, m_iObjectLevelMin);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_is_type_control, bval);
			m_CmbxIsTypeControl.SetCurSel(bval?1:0);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_is_multi_object, bval);
			m_IsMultiObject=(bval?1:0);
			m_OldTypeControl=bval;
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_forms, m_ext_forms);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_list_characteristics, m_list_charact_current);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_template, m_LevelName);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_system_stored_entity, m_CurrNameEntity);
			
			CRect rect1,rect2;
			m_EditCode.GetWindowRect(&rect2);
			m_EditId.GetWindowRect(&rect1);
			ScreenToClient(&rect1);
			ScreenToClient(&rect2);
			rect1.right = rect2.right;
			m_EditId.MoveWindow(rect1);
			m_EditCode.ShowWindow(SW_HIDE);
			m_StaticCode.ShowWindow(SW_HIDE);

		}
		else if(m_api->m_data.IsKindOf(m_item, my_mgr.e_apl_classifier_level))
		{
			m_bSystem=false;
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_level_id, m_sId);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_level_code, m_sCode);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_level_name, m_sName);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_level_descr, m_sDescr);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_level_system, m_system);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_level_parent, m_parent);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_level_forms, m_ext_forms);
			m_api->m_data.GetAttr(m_item, my_mgr.a_apl_classifier_level_list_characteristics, m_list_charact_current);
			my_mgr.GetClassifierCharacteristic(m_parent!=0?m_parent:m_system,m_list_charact_parent,true);

			if(m_system==0){
				AfxMessageBox( APL_T("      !    !"),MB_OK|MB_ICONERROR);
			}else{
			}
		}
	}else{
		if(!m_bSystem){
			if(m_system==0){
				AfxMessageBox( APL_T("      !  !"),MB_OK|MB_ICONERROR);
				return FALSE;
			}
			//   .    
			my_mgr.GetClassifierCharacteristic(m_system,m_list_charact_parent,true);
		}
	}
	ShowEsquisse();
	ShowForm();

	if(m_readonly){
		m_EditName.SetReadOnly(TRUE);
		m_EditId.SetReadOnly(TRUE);
		m_EditDescr.SetReadOnly(TRUE);
		m_BtnOk.EnableWindow(FALSE);

		m_CmbxIsConceptLevelControl.EnableWindow(FALSE);
		m_CmbxConceptLevelSwitch.EnableWindow(FALSE);
		m_CmbxIsObject.EnableWindow(FALSE);
		m_CmbxIsObjectLevelControl.EnableWindow(FALSE);
		m_CmbxObjectLevelSwitch.EnableWindow(FALSE);
		m_EditConceptLevelMin.SetReadOnly(TRUE);
		m_EditConceptLevelMax.SetReadOnly(TRUE);
		m_EditObjectLevelMin.SetReadOnly(TRUE);
		m_EditObjectLevelMax.SetReadOnly(TRUE);

		m_CmbxIsTypeControl.EnableWindow(FALSE);
		m_CtrlMultiObject.EnableWindow(FALSE);
		m_CmbxTypeControl.EnableWindow(FALSE);

	}

	m_TabSelect.InsertItem(0, APL_T(" "));

	if(m_bSystem)
	{
		m_TabSelect.InsertItem(1, APL_T(""));
		m_tab_esquisse=2;
		m_tab_forms=3;
	}else{
		m_TabSelect.InsertItem(1, APL_T("-  "));
		m_TabSelect.InsertItem(2, APL_T(" -"));
		m_tab_esquisse=3;
		m_tab_forms=4;
	}
	m_TabSelect.InsertItem(m_tab_esquisse, APL_T(""));
	m_TabSelect.InsertItem(m_tab_forms, APL_T(""));
	
	COLORMAP cm1;
	cm1.from=RGB(192, 192, 192);
	cm1.to=GetSysColor(COLOR_BTNFACE);
	if(m_bSystem)
	{
		SetWindowText( APL_T(""));
		m_StaticSystem.SetWindowText( APL_T(" :"));
		
		m_EditLevel.SetReadOnly(m_readonly?TRUE:FALSE);
		m_StaticLevel.SetWindowText( APL_T(""));

		//if(aplGetBitPerPixel(this)>8) m_logo_bmp.LoadMappedBitmap(IDB_CLASSIFIER_SYSTEM, 0, &cm1, 1);
		//else m_logo_bmp.LoadMappedBitmap(IDB_CLASSIFIER_SYSTEM_16, 0, &cm1, 1);		
		aplLoadMappedBitmap(m_logo_bmp,IDB_CLASSIFIER_SYSTEM,RGB(0,0,0),GetSysColor(COLOR_BTNFACE),50);

		m_BtnParentObjectTypeControl.EnableWindow(FALSE);
		m_CmbxTypeControl.EnableWindow(FALSE);
		m_CmbxIsTypeControl.EnableWindow(FALSE);
		m_CtrlMultiObject.EnableWindow(FALSE);
		
	}else{
		SetWindowText( APL_T("  "));
		m_StaticSystem.SetWindowText( APL_T(":"));
		if(m_system!=0){
			bool is_multi_object;
			m_api->GetItemName(m_system,m_SystemName);
			// ,     
			my_mgr.GetConceptLevelParameters(m_system,bval,bval1,m_iConceptLevelMin,m_iConceptLevelMax);
			m_CmbxIsConceptLevelControl.SetCurSel(bval?1:0);
			m_CmbxConceptLevelSwitch.SetCurSel(bval1?0:1);
			my_mgr.GetObjectLevelParameters(m_system,m_can_object,bval,bval1,m_iObjectLevelMin,m_iObjectLevelMax,is_multi_object);
			m_IsMultiObject = is_multi_object?TRUE:FALSE;
			m_CmbxIsObject.SetCurSel(m_can_object?1:0);
			m_CmbxIsObjectLevelControl.SetCurSel(bval?1:0);
			m_CmbxObjectLevelSwitch.SetCurSel(bval1?0:1);
			CaplEntity* ent=0;
			my_mgr.GetObjectTypeParameters(m_system,bval,&ent,true);
			m_CmbxIsTypeControl.SetCurSel(bval?1:0);
			if(ent!=0){
				m_CurrNameEntity=ent->name;
			}
		}
		if(m_item!=0){
			i_level=my_mgr.GetLevelClassifierLevel(m_item);
		}else{
			if(m_parent==0){
				i_level=1;
			}else{
				i_level=my_mgr.GetLevelClassifierLevel(m_parent)+1;
			}
		}
		m_LevelName.Format(_T("%i"),i_level);

		m_CmbxIsConceptLevelControl.EnableWindow(FALSE);
		m_CmbxConceptLevelSwitch.EnableWindow(FALSE);
		m_CmbxIsObject.EnableWindow(FALSE);
		m_CmbxIsObjectLevelControl.EnableWindow(FALSE);
		m_CmbxObjectLevelSwitch.EnableWindow(FALSE);
		m_EditConceptLevelMin.EnableWindow(FALSE);
		m_EditConceptLevelMax.EnableWindow(FALSE);
		m_EditObjectLevelMin.EnableWindow(FALSE);
		m_EditObjectLevelMax.EnableWindow(FALSE);
		m_CmbxIsConceptLevelControl.EnableWindow(FALSE);
		m_BtnParentObjectTypeControl.EnableWindow(FALSE);
		m_CmbxTypeControl.EnableWindow(FALSE);
		m_CmbxIsTypeControl.EnableWindow(FALSE);

		//if(aplGetBitPerPixel(this)>8) m_logo_bmp.LoadMappedBitmap(IDB_CLASSIFIER_ELEMENT, 0, &cm1, 1);
		//else m_logo_bmp.LoadMappedBitmap(IDB_CLASSIFIER_ELEMENT_16, 0, &cm1, 1);	
		aplLoadMappedBitmap(m_logo_bmp,IDB_CLASSIFIER_ELEMENT,RGB(0,0,0),GetSysColor(COLOR_BTNFACE),50);

		
	}

	//////////////////////////////////////////////////////////////////////////
	//						!!!!!!!!!!!!!!!!!!!								//
	//////////////////////////////////////////////////////////////////////////
	//																		//
	//      						//
	//   CClassifierTableItemsView::OnFindAdd()			//
	//   SelectInstance!!!!!!!							//
	//     									//
	//          		//	
	//    !												//
	//																		//
	//////////////////////////////////////////////////////////////////////////
	//																		//
	InsertObjectString( APL_T(""),m_api->m_prd_mgr.e_prd);					//
	m_CmbxTypeControl.SetCurSel(0);											//
	InsertObjectString( APL_T(" "),m_api->m_prd_mgr.e_apl_pdf);		//
	InsertObjectString( APL_T(""),m_api->m_doc_mgr.e_apl_doc);				//
	InsertObjectString( APL_T(" "),m_api->m_prd_inst_mgr.e_lot);		//
	InsertObjectString( APL_T(" "),m_api->m_prd_inst_mgr.e_prd_inst);//
	InsertObjectString( APL_T("-"),m_api->m_bp_mgr.e_bp);				//
	InsertObjectString( APL_T(" -"),m_api->m_bp_mgr.e_apl_bp_inst);
//	InsertObjectString(APL_T(""),m_api->m_categ_mgr.e_categ);				//    !
//	InsertObjectString(APL_T(""),m_api->m_folder_mgr.e_folder);				//    !
	InsertObjectString(APL_T(""),m_api->m_project_mgr->e_project);			//    !
//	InsertObjectString(APL_T(""),m_api->m_appr_mgr.e_person);				// 
	InsertObjectString(APL_T(" "),m_api->m_appr_mgr.e_org);			//    !
//	InsertObjectString(APL_T(""),m_api->m_change_mgr.e_chng);				//    !
	//		InsertObjectString(APL_T("")),m_api->m_);							//
	//																		//
	//////////////////////////////////////////////////////////////////////////
	

	HBITMAP hBmpOld=m_StaticClassifierName.SetBitmap(HBITMAP(m_logo_bmp));
	::DeleteObject(hBmpOld);

	m_api->m_form_mgr.LoadData();
	m_api->m_data.GetEntityExtent(m_api->m_form_mgr.e_form,m_all_forms);

	//    
	CRect rect,rect2;
	//   Tab -     ,     
	//   
	m_StaticTabSize.GetWindowRect(&rect);
	ScreenToClient(&rect);
	m_TabSelect.MoveWindow(rect);
	
	//     
 	m_StaticConceptGroup.GetWindowRect(&rect);
	ScreenToClient(&rect);
	m_StaticObjectTypeGroup.GetWindowRect(&rect2);
	ScreenToClient(&rect2);
	rect.bottom=rect2.bottom;
	m_StaticCharactGroup.MoveWindow(rect);

	//  
	m_StaticConceptLevelSwitch.GetWindowRect(&rect);
	m_CmbxTypeControl.GetWindowRect(&rect2);
	ScreenToClient(&rect);
	m_EditConceptLevelMax.GetWindowRect(&rect2);
	ScreenToClient(&rect2);
	rect.right=rect2.right;
	m_StaticListTypeControl.GetWindowRect(&rect2);
	ScreenToClient(&rect2);
	rect.bottom=rect2.bottom;
	m_ListCharact.Create(WS_VISIBLE|WS_CHILD|WS_BORDER|WS_TABSTOP|LVS_SHOWSELALWAYS|LVS_SINGLESEL,rect,this,IDC_LIST_CHARACT);
	m_ListCharact.SetWindowPos(&wndTop,rect.left,rect.top,rect.Width(),rect.Height(),SWP_SHOWWINDOW);
	HWND hWnd = ::GetDlgItem(m_hWnd, IDC_LIST_CHARACT);
	ListView_SetExtendedListViewStyle(hWnd, 
		ListView_GetExtendedListViewStyle(hWnd) | LVS_EX_FULLROWSELECT /*| LVS_EX_GRIDLINES */);
	
	m_CtrlPicture.SetWindowPos(&wndTop,rect.left,rect.top,rect.Width(),rect.Height(),SWP_SHOWWINDOW);

	//     
	m_ListCharact.GetWindowRect(&rect);
	m_ListCharact.InsertColumn(0, APL_T(""),LVCFMT_LEFT,(rect.Width()*5)/10);
	m_ListCharact.InsertColumn(1, APL_T(""),LVCFMT_LEFT,(rect.Width()*5)/20);
	m_ListCharact.InsertColumn(2, APL_T(""),LVCFMT_LEFT,(rect.Width()*5)/20);

	// / +
	int pos_add,pos_del,pos_prop,interval=1;
	m_BtnParentConceptControl.GetWindowRect(&rect);
	ScreenToClient(&rect);
	m_BtnCharAdd.GetWindowRect(&rect2);
	pos_prop=rect.right-rect2.Width();
	pos_del=pos_prop-interval-rect2.Width();
	pos_add=pos_del-interval-rect2.Width();

	rect.left=pos_prop;rect.right=pos_prop+rect2.Width();
	m_RectProp=rect;
	//m_BtnCharProp.MoveWindow(rect);
	rect.left=pos_del;rect.right=pos_del+rect2.Width();
	m_RectDel=rect;
	//m_BtnCharRemove.MoveWindow(rect);
	rect.left=pos_add;rect.right=pos_add+rect2.Width();
	m_RectAdd=rect;
	//m_BtnCharAdd.MoveWindow(rect);
	m_StaticIsConceptLevelControl.GetWindowRect(&rect);
	ScreenToClient(&rect);
//	m_CmbxIsConceptLevelControl.GetWindowRect(&rect2);
//	ScreenToClient(&rect2);
//	rect.right=rect2.right;
	rect.bottom=rect.top+m_RectAdd.Height();
	m_RectEdt1=rect;m_RectEdt1.right=m_RectAdd.left-interval;
	m_RectEdt2=rect;m_RectEdt2.right=m_RectDel.left-interval;

	UpdateData(FALSE);
	OnEditchangeCombo();
	DrawInTab();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}



void CClassifierSystemDlg::OnOK() 
{
	if(!UpdateData()) return;
	
	m_sId.TrimRight();
	m_sId.TrimLeft();
	m_sName.TrimRight();
	m_sName.TrimLeft();
	m_sCode.TrimRight();
	m_sCode.TrimLeft();
	m_sDescr.TrimRight();
	m_sDescr.TrimLeft();
	if(m_sId.IsEmpty())
	{
		AfxMessageBox( APL_T("    !"));
		return;
	}
	int state0,state1,state2;
	bool	is_concept_level_control=false;
	bool	is_concept_last_level=false;
	int		concept_maxlevel=1;
	int		concept_minlevel=1;
	bool	can_store_object=false; 
	bool	is_object_level_control=false; 
	bool	is_object_last_level=false;
	int		object_maxlevel=1;
	int		object_minlevel=1;
	bool	is_type_control=false;
	bool	is_multi_object=false;
	
	if(m_bSystem){
		//    
		state1=m_CmbxIsConceptLevelControl.GetCurSel();
		is_concept_level_control=state1!=0;
		state2=m_CmbxConceptLevelSwitch.GetCurSel();
		is_concept_last_level=state2==0;
		concept_minlevel=m_iConceptLevelMin;
		concept_maxlevel=m_iConceptLevelMax;
		if(is_concept_level_control && !is_concept_last_level && concept_minlevel>concept_maxlevel){
			AfxMessageBox( APL_T("         !"));
			return;
		}
		//    
		state0=m_CmbxIsObject.GetCurSel();
		can_store_object=state0!=0;
		state1=m_CmbxIsObjectLevelControl.GetCurSel();
		is_object_level_control=state1!=0;
		state2=m_CmbxObjectLevelSwitch.GetCurSel();
		is_object_last_level=state2==0;
		object_minlevel=m_iObjectLevelMin;
		object_maxlevel=m_iObjectLevelMax;
		if(can_store_object && is_object_level_control && !is_object_last_level && object_minlevel>object_maxlevel){
			AfxMessageBox( APL_T("         !"));
			return;
		}
	}
	//   
	state0=m_CmbxIsTypeControl.GetCurSel();
	if(state0==0){
		is_type_control=false;
	}else{
		is_type_control=true;
	}
	is_multi_object = m_IsMultiObject==TRUE;

	bool ok;
	int pos,i;

	if(m_bSystem){
		//  
		CaplAttrValue tst_val;
		tst_val.attr = my_mgr.a_apl_classifier_system_id;
		tst_val.value.Set(m_sId);
		ok = !m_api->m_data.NET_TestUniqueAttrValues(my_mgr.e_apl_classifier_system, m_item, 1, &tst_val, false);
		if(ok){
			AfxMessageBox( APL_T("    !"));
			return;
		}
		if(m_item==0){
			m_item=m_api->m_data.CreateInstance(my_mgr.e_apl_classifier_system);
		}
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_id, m_sId);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_name, m_sName);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_descr, m_sDescr);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_parent , m_parent);
		if(m_parent!=0)
		{
			aplExtent childs;
			m_api->m_data.GetAttr(m_parent, my_mgr.a_apl_classifier_system_childs, childs);
			childs.Add(m_item);
			m_api->m_data.PutAttr(m_parent, my_mgr.a_apl_classifier_system_childs, childs);
		}

		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_is_concept_level_control, is_concept_level_control);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_is_concept_last_level, is_concept_last_level);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_concept_maxlevel, concept_maxlevel);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_concept_minlevel, concept_minlevel);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_can_store_object, can_store_object);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_is_object_level_control, is_object_level_control);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_is_object_last_level, is_object_last_level);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_object_maxlevel, object_maxlevel);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_object_minlevel, object_minlevel);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_is_type_control, is_type_control);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_is_multi_object, is_multi_object);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_forms, m_ext_forms);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_list_characteristics, m_list_charact_current);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_template, m_LevelName);

		pos=m_CmbxTypeControl.GetCurSel();
		CaplEntity* ent=(CaplEntity*)m_CmbxTypeControl.GetItemData(pos);

		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_system_stored_entity, ent->name);

	}
	else
	{
		//  
		CaplAttrValue tst_val[2];
		tst_val[0].attr = my_mgr.a_apl_classifier_level_id;
		tst_val[0].value.Set(m_sId);
		tst_val[1].attr = my_mgr.a_apl_classifier_level_system;
		tst_val[1].value.Set(m_system);
		ok = !m_api->m_data.NET_TestUniqueAttrValues(my_mgr.e_apl_classifier_level, m_item, 2, &tst_val[0], false);
		if(ok){
			AfxMessageBox( APL_T("      !"));
			return;
		}
		if(m_item==0){
			m_item=m_api->m_data.CreateInstance(my_mgr.e_apl_classifier_level);
		}
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_level_id, m_sId);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_level_code, m_sCode);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_level_name, m_sName);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_level_descr, m_sDescr);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_level_system, m_system);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_level_parent, m_parent);
		if(m_parent!=0)
		{
			aplExtent childs;
			m_api->m_data.GetAttr(m_parent, my_mgr.a_apl_classifier_level_childs, childs);
			childs.Add(m_item);
			m_api->m_data.PutAttr(m_parent, my_mgr.a_apl_classifier_level_childs, childs);
		}
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_level_forms, m_ext_forms);
		m_api->m_data.PutAttr(m_item, my_mgr.a_apl_classifier_level_list_characteristics, m_list_charact_current);
	}
	for(i=0;i<m_list_deleted.GetSize();i++){
		m_api->m_data.DeleteInstance(m_list_deleted[i]);
	}


	if(m_NameNewEsquisse!=_T(""))
	{
		my_mgr.PutClassifierEsquisse(m_item,m_NameNewEsquisse);
	}
	else if(m_DeleteEsquisse)
	{
		my_mgr.DelClassifierEsquisse(m_item);
	}
	m_api->m_data.NET_SaveChanges();

	CaplTranslateDialog::OnOK();
}

void CClassifierSystemDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	//    -    
	for(int i=0;i<m_list_created.GetSize();i++){
		m_api->m_data.DeleteInstance(m_list_created[i]);
	}
	
	CaplTranslateDialog::OnCancel();
}

void CClassifierSystemDlg::OnEditchangeCombo() 
{
	// TODO: Add your control notification handler code here
	int state0,state1,state2;
	BOOL used0,used1,used2,used3;
	//    
	state1=m_CmbxIsConceptLevelControl.GetCurSel();
	if(m_bSystem){
		if(state1==0){
			used1=FALSE;
			used2=FALSE;
			used3=TRUE;
		}else{
			used1=TRUE;
			state2=m_CmbxConceptLevelSwitch.GetCurSel();
			if(state2==0){used2=FALSE;}else{used2=TRUE;}
			used3=FALSE;
		}
	}else{
		used1=FALSE;used2=FALSE;used3=FALSE;
	}
	if(m_readonly){used1=FALSE;used2=FALSE;used3=FALSE;};
	m_CmbxConceptLevelSwitch.EnableWindow(used1);
	m_EditConceptLevelMax.EnableWindow(used2);
	m_EditConceptLevelMin.EnableWindow(used2);
	m_BtnParentConceptControl.EnableWindow(used3);


	//    
	state0=m_CmbxIsObject.GetCurSel();
	if(m_bSystem){
		if(state0==0){
			m_can_object=false;
			used0=FALSE;
			used1=FALSE;
			used2=FALSE;
			used3=FALSE;
		}else{
			m_can_object=true;
			used0=TRUE;
			state1=m_CmbxIsObjectLevelControl.GetCurSel();
			if(state1==0){
				used1=FALSE;
				used2=FALSE;
				used3=TRUE;
			}else{
				used1=TRUE;
				state2=m_CmbxObjectLevelSwitch.GetCurSel();
				if(state2==0){used2=FALSE;}else{used2=TRUE;}
				used3=FALSE;
			}
		}	
	}else{
		used0=FALSE;used1=FALSE;used2=FALSE;used3=FALSE;
	}
	if(m_readonly){used0=FALSE;used1=FALSE;used2=FALSE;used3=FALSE;};
	m_CtrlMultiObject.EnableWindow(used0);
	m_CmbxIsObjectLevelControl.EnableWindow(used0);
	m_CmbxObjectLevelSwitch.EnableWindow(used1);
	m_EditObjectLevelMax.EnableWindow(used2);
	m_EditObjectLevelMin.EnableWindow(used2);
	m_BtnParentObjectControl.EnableWindow(used3);
	//           
	if(state0==0){used0=FALSE;}else{used0=TRUE;}
	m_BtnCharAdd.EnableWindow(used0);
	m_BtnCharProp.EnableWindow(used0);
	m_BtnCharRemove.EnableWindow(used0);
	m_ListCharact.EnableWindow(used0);
	
	//   
	if(m_bSystem){
		if(m_can_object){
			bool change=true;
			used1=TRUE;
			state0=m_CmbxIsTypeControl.GetCurSel();
			if(state0==0){
				used0=FALSE;used3=TRUE;
				m_OldTypeControl=false;
			}else{
				int pos=m_CmbxTypeControl.GetCurSel();
				CaplEntity *ent_curr;
				ent_curr=(CaplEntity*)m_CmbxTypeControl.GetItemData(pos);
				if(ent_curr->name!=m_CurrNameEntity || !m_OldTypeControl){
					//    .   ,     
					//m_FormManagerDlg.SelectForm(m_api,)
					CaplInstance *curr_forma;
					aplExtent finstances;
					CString name_form_ent;
					curr_forma=m_ext_forms.GetAt(0);
					if(curr_forma!=0 && !m_api->m_form_mgr.TestFormCompatible(curr_forma,ent_curr)){
						if(AfxMessageBox( APL_T("  ,   ,     ! \n     ?"),
							MB_YESNO)==IDYES)
						{
							m_ext_forms.Clear();
							ShowForm();
						}
					}
					m_CurrNameEntity=ent_curr->name;

				}
				used0=TRUE;used3=FALSE;
				m_OldTypeControl=true;
			}
		}else{
			m_CmbxIsTypeControl.EnableWindow(FALSE);
			used0=FALSE;used1=FALSE;used3=FALSE;
		}
	}else{
		used0=FALSE;used1=FALSE;used2=FALSE;used3=FALSE;
	}
	if(m_readonly){used0=FALSE;used1=FALSE;used2=FALSE;used3=FALSE;};
	m_CmbxIsTypeControl.EnableWindow(used1);
	m_CmbxTypeControl.EnableWindow(used0);
	//m_EditTypeControl.EnableWindow(used0);
	m_BtnParentObjectTypeControl.EnableWindow(used3);
}


void CClassifierSystemDlg::OnButtonShowParentConceptSetting() 
{
	// TODO: Add your control notification handler code here
	bool is_concept_control,is_last_level;
	int min_level,max_level;
	CaplInstance* parent=0;
	CaplInstance* tested_inst=0;
	tested_inst=(m_item==0)?m_parent:m_item;
	parent=my_mgr.GetConceptLevelParameters(tested_inst,is_concept_control,is_last_level,min_level,max_level);
	if(parent==0){
		AfxMessageBox( APL_T("      "));
	}else{
		CClassifierSystemDlg dlg;
		dlg.m_item=parent;
		dlg.m_api=m_api;
		dlg.m_readonly=true;
		dlg.DoModal();
	}
}

void CClassifierSystemDlg::OnButtonShowParentObjectSetting() 
{
	// TODO: Add your control notification handler code here
	CaplInstance* parent=0;
	bool can_object,is_multi_object,is_object_control,is_last_level;
	int min_level,max_level;
	CaplInstance* tested_inst=0;
	tested_inst=(m_item==0)?m_parent:m_item;
	parent=my_mgr.GetObjectLevelParameters(tested_inst,can_object,is_object_control,is_last_level,min_level,max_level,is_multi_object);
	if(parent==0){
		AfxMessageBox( APL_T("      "));
	}else{
		CClassifierSystemDlg dlg;
		dlg.m_item=parent;
		dlg.m_api=m_api;
		dlg.m_readonly=true;
		dlg.DoModal();
	}
	
}

void CClassifierSystemDlg::OnButtonShowParentObjectTypeSetting() 
{
	// TODO: Add your control notification handler code here
	CaplInstance* parent=0;
	bool is_object_type_control;
//	aplExtent forms;
	CaplEntity *entity;
	CaplInstance* tested_inst=0;
	tested_inst=(m_item==0)?m_parent:m_item;
	parent=my_mgr.GetObjectTypeParameters(tested_inst,is_object_type_control,&entity,true);
	if(parent==0){
		AfxMessageBox( APL_T("       "));
	}else{
		CClassifierSystemDlg dlg;
		dlg.m_item=parent;
		dlg.m_api=m_api;
		dlg.m_readonly=true;
		dlg.DoModal();
	}
}

void CClassifierSystemDlg::OnButtonAdd() 
{
	// TODO: Add your control notification handler code here
	if(m_readonly)return;
	int pos=m_TabSelect.GetCurSel();
	int i;
	int res;
	if(m_tab_forms==pos){
		
		int (*FSelectForm)(CaplAPI* pApi,CaplInstance*& ciSelectedForm,CaplEntity* ceFilterEnt,aplExtent* aeInForms);
		FSelectForm=0;
		CaplInstance *form=0;

		
		if(CaplFormManagerDlgDLL!=0){
			(FARPROC&)FSelectForm= GetProcAddress(CaplFormManagerDlgDLL,"_SelectForm");
		}
		if(FSelectForm!=0){
			if(m_CmbxIsTypeControl.GetCurSel()!=0){
				res=FSelectForm(m_api,form,m_api->m_data.GetEntityBN(m_CurrNameEntity),0);
			}else{
				res=FSelectForm(m_api,form,0,0);
			}
		}else{
			DWORD err=GetLastError();
			CString form_name;
			CString form_ent_name;
			CaplMenu menu;
			aplExtent all_forms;
			BOOL res;
			m_api->m_data.GetEntityExtent(m_api->m_form_mgr.e_form,all_forms);

			res=menu.CreatePopupMenu();
			
			for(i=0;i<all_forms.GetSize();i++)
			{
				form=all_forms.GetAt(i);
				if(form!=0){
					m_api->m_data.GetAttr(form,m_api->m_form_mgr.a_form_name,form_name);
				}else{
					form_name=_T("");
				}
				res=menu.InsertMenu(i,MF_BYPOSITION| MF_STRING ,WM_USER+i,form_name);
				m_api->m_form_mgr.GetFormEntityName(form,form_ent_name);
				if(!m_CurrNameEntity.IsEmpty() && m_CmbxIsTypeControl.GetCurSel()!=0){
					if(!m_api->m_form_mgr.TestFormCompatible(form,m_CurrNameEntity)){
						menu.EnableMenuItem(i,MF_DISABLED | MF_GRAYED |MF_BYPOSITION );
					}
				}

			}
//			CRect rect;
//			m_BtnCharAdd.GetWindowRect(&rect);
//			CPoint mouseclick(rect.left, rect.bottom);
//			ClientToScreen(&mouseclick);

			const MSG* msg;
			CPoint mouseclick;
			msg=GetCurrentMessage();
			//mouseclick -   
			mouseclick=msg->pt;
			
			res=menu.TrackPopupMenu(TPM_LEFTALIGN|TPM_NONOTIFY|
				TPM_RIGHTBUTTON|TPM_RETURNCMD,msg->pt.x, msg->pt.y,this);
			if(res>=WM_USER && res<WM_USER+all_forms.GetSize()){
				i=res-WM_USER;
				form=all_forms.GetAt(i);
			}
		}
		if(form!=0){
			m_ext_forms.Clear();
			m_ext_forms.Add(form);
		}
		ShowForm();


	}else if(m_tab_esquisse==pos){
		// 
		TCHAR* filter= (TCHAR*)APL_T("  (*.bmp; *.jpg; *.jpeg; *.gif; *.png; *.ico; *.tiff; *.tif)|*.bmp; *.jpg; *.jpeg; *.gif; *.png; *.ico; *.tiff; *.tif||");
		CFileDialog dlg(TRUE,NULL,m_NameNewEsquisse, OFN_FILEMUSTEXIST |OFN_ENABLESIZING|OFN_EXPLORER,
			filter,0);
		if(dlg.DoModal()==IDOK){
			m_NameNewEsquisse=dlg.GetPathName();
			ShowEsquisse();
			return;
		};
	}else{
		// 
		m_selected_char= m_api->m_charact_mgr.CreateCharacteristicAndType(0,0,m_item,false,false,&m_list_charact_current);
		if(m_selected_char!=0){
			m_list_created.Add(m_selected_char);
			m_list_charact_current.Add(m_selected_char);
			FillCharacteristikList();
		}
	}
}

void CClassifierSystemDlg::OnButtonProperty() 
{
	// TODO: Add your control notification handler code here
	int pos=m_TabSelect.GetCurSel();
	if(m_tab_forms==pos){
	}else if(m_tab_esquisse==pos){
		//      ,    
	}else{
		// 
		int num_curr= m_ListCharact.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
		if( num_curr== -1){
			AfxMessageBox( APL_T("  !"));
			return;
		}
		m_selected_char=(CaplInstance*)m_ListCharact.GetItemData(num_curr);
		if(m_selected_char==0){
			AfxMessageBox( APL_T("  !   "));
			FillCharacteristikList(); 
			return;
		}
		int tab_pos=m_TabSelect.GetCurSel();

		if(m_api->m_charact_mgr.CharacteristicAndTypeProperties(m_selected_char,m_readonly || tab_pos==2 /* || (!m_bSystem && )*/))
		{
			m_api->m_data.PutAttr(m_selected_char,m_api->m_charact_mgr.a_apl_characteristic_and_type_base_item,m_system);
			FillCharacteristikList();
		}

	}
}

void CClassifierSystemDlg::OnButtonRemove() 
{
	// TODO: Add your control notification handler code here
	if(m_readonly)return;
	int pos=m_TabSelect.GetCurSel();
	if(m_tab_forms==pos){
		if(m_ext_forms.GetSize()>0){
			if(AfxMessageBox( APL_T("    ?"),MB_YESNO)==IDYES){
				m_ext_forms.Clear();
				ShowForm();
			}
		}
	}else if(m_tab_esquisse==pos){
		// 
		if(m_CtrlPicture.HasImage()){
			if(AfxMessageBox( APL_T("    ?"),MB_YESNO)==IDYES){
				m_CtrlPicture.Clear();
				m_DeleteEsquisse=true;
				m_NameNewEsquisse=_T("");
				ShowEsquisse();
			}
		}
	}else{
		// 
		int num_curr= m_ListCharact.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
		if( num_curr== -1){
			AfxMessageBox( APL_T("  !"));
			return;
		}
		m_selected_char=(CaplInstance*)m_ListCharact.GetItemData(num_curr);
		if(m_selected_char==0){
			AfxMessageBox( APL_T("  !   "));
			FillCharacteristikList(); 
			return;
		}
		CaplInstance *charact,*type;
		bool required;
		m_api->m_data.GetAttr(m_selected_char,m_api->m_charact_mgr.a_apl_characteristic_and_type_characteristic,charact);
		m_api->m_data.GetAttr(m_selected_char,m_api->m_charact_mgr.a_apl_characteristic_and_type_type,type);
		m_api->m_data.GetAttr(m_selected_char,m_api->m_charact_mgr.a_apl_characteristic_and_type_required,required);
		CString buf,buf1;
		int i;
		buf1=(required? APL_T(""):_T(""));
		buf= APL_T("    ")+buf1+ APL_T("  \"");
		m_api->GetItemName(charact,buf1);
		buf+=buf1+ APL_T("\"   \"");
		m_api->GetItemName(type,buf1);
		buf+=buf1+_T("\" ?");
		if(AfxMessageBox(buf,MB_YESNO)==IDYES){
			for(i=0;i<m_list_charact_current.GetSize();i++){
				if(m_list_charact_current[i]==m_selected_char){
					m_list_charact_current.Remove(i);break;
				}
			}
			m_list_deleted.Add(m_selected_char);
			m_selected_char=0;
			FillCharacteristikList();
		}	
	}

	
}

void CClassifierSystemDlg::ShowEsquisse()
{
	CString name=_T("");
	CSize size;
	bool is_renew=false;
	m_EsquisseDescr= APL_T("  ");
	if(m_NameNewEsquisse!=_T(""))
	{
		m_CtrlPicture.LoadFromFile(m_NameNewEsquisse);
		name=m_NameNewEsquisse;
		is_renew=true;
	}
	else if(!m_CtrlPicture.HasImage() && !m_DeleteEsquisse)
	{
		CString name_file=_T("");
		if(my_mgr.GetClassifierEsquisse(m_item,name_file,&name) && name_file!=_T(""))
		{
			BeginWaitCursor();
			m_CtrlPicture.LoadFromFile(name_file);
			is_renew=true;
			DeleteFile(name_file);
			EndWaitCursor();
		}
	}
	if(is_renew){
		m_CtrlPicture.GetDimensions(size);
		m_EsquisseDescr.Format( APL_T(" %ix%i; : \""),size.cx,size.cy);
		m_EsquisseDescr+=name+_T("\"");
	}
	m_EdtPictProro.SetWindowText(m_EsquisseDescr);
	m_CtrlPicture.Invalidate();
}

void CClassifierSystemDlg::ShowForm()
{
	m_FormDescr=_T("");
	CaplInstance *curr_form=m_ext_forms.GetAt(0);
	if(curr_form!=0 && m_CmbxIsTypeControl.GetCurSel()!=0){
		if(!m_api->m_form_mgr.TestFormCompatible(curr_form,m_CurrNameEntity)){
			if(AfxMessageBox( APL_T(",   ,     !\n    ?"),
				MB_YESNO)==IDYES)
			{
				m_ext_forms.Clear();
				curr_form=0;
			}
		}
	}
	if(curr_form!=0){
		m_api->m_data.GetAttr(curr_form,m_api->m_form_mgr.a_form_name,m_FormDescr);
	}
	m_EdtPictProro.SetWindowText(m_FormDescr);
}

void CClassifierSystemDlg::OnSelchangeTabSelect(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
	DrawInTab();
}

void CClassifierSystemDlg::HideSecondControls()
{
	m_StaticCharactGroup.ShowWindow(SW_HIDE);
	m_BtnCharProp.ShowWindow(SW_HIDE);
	m_ListCharact.ShowWindow(SW_HIDE);
	m_CtrlPicture.ShowWindow(SW_HIDE);
	m_EdtPictProro.ShowWindow(SW_HIDE);
	m_BtnCharRemove.ShowWindow(SW_HIDE);
	m_BtnCharAdd.ShowWindow(SW_HIDE);
	m_BtnCharRemove.EnableWindow(TRUE);
	m_BtnCharAdd.EnableWindow(TRUE);
}

void CClassifierSystemDlg::DrawInTab()
{
	//      
	int pos=m_TabSelect.GetCurSel();
	bool show_cre_del=(pos==m_tab_esquisse || pos==m_tab_forms || pos==m_tab_edited_chars);
	int state2;

	
	ShowGroupControl(pos==m_tab_levels);
	HideSecondControls();
	
//	ShowGroupCharactImage(pos,show_img,show_prop,show_cre_del);

	if(m_tab_levels==pos){
		// 
	}else if(m_tab_esquisse==pos){
		m_StaticCharactGroup.SetWindowText( APL_T(""));
		m_StaticCharactGroup.ShowWindow(SW_SHOW);
		m_CtrlPicture.ShowWindow(SW_SHOW);
		m_EdtPictProro.SetWindowText(m_EsquisseDescr);
		m_EdtPictProro.ShowWindow(SW_SHOW);
		m_BtnCharRemove.ShowWindow(SW_SHOW);
		m_BtnCharAdd.ShowWindow(SW_SHOW);

		m_BtnCharRemove.MoveWindow(m_RectProp);
		m_BtnCharAdd.MoveWindow(m_RectDel);
		m_EdtPictProro.MoveWindow(m_RectEdt2);

	}else if(m_tab_forms==pos){
		ShowForm();
		m_StaticCharactGroup.SetWindowText( APL_T(""));
		m_StaticCharactGroup.ShowWindow(SW_SHOW);
		m_BtnCharRemove.ShowWindow(SW_SHOW);
		m_BtnCharAdd.ShowWindow(SW_SHOW);
		m_EdtPictProro.ShowWindow(SW_SHOW);
		m_EdtPictProro.SetWindowText(m_FormDescr);

		m_BtnCharRemove.MoveWindow(m_RectProp);
		m_BtnCharAdd.MoveWindow(m_RectDel);
		m_EdtPictProro.MoveWindow(m_RectEdt2);
		state2=m_CmbxIsObject.GetCurSel();
		m_BtnCharAdd.EnableWindow(state2==0?FALSE:TRUE);
		m_BtnCharRemove.EnableWindow(state2==0?FALSE:TRUE);
	}else{
		m_StaticCharactGroup.SetWindowText( APL_T(""));
		m_StaticCharactGroup.ShowWindow(SW_SHOW);
		if(pos==m_tab_edited_chars){
			m_BtnCharRemove.ShowWindow(SW_SHOW);
			m_BtnCharAdd.ShowWindow(SW_SHOW);
			m_BtnCharProp.ShowWindow(SW_SHOW);
		}
		if(!m_can_object){
			m_BtnCharRemove.EnableWindow(FALSE);
			m_BtnCharAdd.EnableWindow(FALSE);
		}
		m_ListCharact.ShowWindow(SW_SHOW);

		m_BtnCharRemove.MoveWindow(m_RectDel);
		m_BtnCharAdd.MoveWindow(m_RectAdd);
		m_BtnCharProp.MoveWindow(m_RectProp);
	}

	if(m_readonly){
		m_BtnCharRemove.EnableWindow(FALSE);
		m_BtnCharAdd.EnableWindow(FALSE);
	}
	
	
	FillCharacteristikList();
}

//void CClassifierSystemDlg::ShowGroupCharactImage(int tab_pos,bool show_img,bool show_prop,bool show_cre_del)
//{
//	if(m_tab_esquisse==tab_pos){
//		m_BtnCharRemove.MoveWindow(m_RectProp);
//		m_BtnCharAdd.MoveWindow(m_RectDel);
//		m_BtnCharProp.ShowWindow(SW_HIDE);
//		m_StaticCharactGroup.SetWindowText(APL_T(""));
//		m_EdtPictProro.MoveWindow(m_RectEdt2);
//	}else if(m_tab_forms==tab_pos){
//		m_BtnCharRemove.MoveWindow(m_RectProp);
//		m_BtnCharAdd.MoveWindow(m_RectDel);
//		m_BtnCharProp.ShowWindow(SW_HIDE);
//		m_StaticCharactGroup.SetWindowText(APL_T(""));
//		m_EdtPictProro.MoveWindow(m_RectEdt2);
//	}else{
//		m_StaticCharactGroup.SetWindowText(APL_T(""));
//		m_BtnCharRemove.MoveWindow(m_RectDel);
//		m_BtnCharAdd.MoveWindow(m_RectAdd);
//		m_BtnCharProp.MoveWindow(m_RectProp);
//		m_BtnCharProp.ShowWindow(show_prop?SW_SHOW:SW_HIDE);
//		m_EdtPictProro.MoveWindow(m_RectEdt1);
//	}
//	
//}




void CClassifierSystemDlg::FillCharacteristikList()
{
	int i,pos;
	CaplInstance *char_and_type,*charact,*type;
	int tab_pos=m_TabSelect.GetCurSel();
	bool required;
	CString buf;
	m_ListCharact.DeleteAllItems();
	aplExtent ext_char;
	ext_char.Append(m_list_charact_current);
	if(tab_pos==2){my_mgr.AddIfNotFound(ext_char,m_list_charact_parent);}
	for(i=0;i<ext_char.GetSize();i++){
		char_and_type=ext_char.GetAt(i);
		m_api->m_data.GetAttr(char_and_type, m_api->m_charact_mgr.a_apl_characteristic_and_type_characteristic, charact);
		m_api->m_data.GetAttr(char_and_type, m_api->m_charact_mgr.a_apl_characteristic_and_type_type, type);
		m_api->m_data.GetAttr(char_and_type, m_api->m_charact_mgr.a_apl_characteristic_and_type_required, required);
		m_api->GetItemName(charact,buf);
		pos=m_ListCharact.InsertItem(i,buf);
		m_ListCharact.SetItemData(pos,(DWORD)char_and_type);
		if(m_selected_char==char_and_type){
			m_ListCharact.SetSelectionMark(pos);
		}
		if(type!=0){m_api->GetItemName(type,buf);}else{buf=_T("");}
		m_ListCharact.SetItemText(pos,1,buf);
		buf=required? APL_T(""):_T("");
		m_ListCharact.SetItemText(pos,2,buf);
	}
}

void CClassifierSystemDlg::ShowGroupControl(bool is_show)
{
	int cmd=is_show?SW_SHOW:SW_HIDE;
//	int cmd_btn=(is_show &&!m_bSystem)?SW_SHOW:SW_HIDE;
	int cmd_btn=SW_HIDE;
	m_StaticConceptGroup.ShowWindow(cmd);
	m_StaticIsConceptLevelControl.ShowWindow(cmd);
	m_StaticConceptLevelSwitch.ShowWindow(cmd);
	m_StaticConceptLevelMin.ShowWindow(cmd);
	m_StaticConceptLevelMax.ShowWindow(cmd);
	m_StaticObjectGroup.ShowWindow(cmd);
//	m_StaticIsObject.ShowWindow(cmd);
	m_StaticIsObjectLevelControl.ShowWindow(cmd);
	m_StaticObjectLevelSwitch.ShowWindow(cmd);
	m_StaticObjectLevelMin.ShowWindow(cmd);
	m_StaticObjectLevelMax.ShowWindow(cmd);
	m_StaticObjectTypeGroup.ShowWindow(cmd);
	m_StaticIsTypeControl.ShowWindow(cmd);
	m_StaticListTypeControl.ShowWindow(cmd);
	m_CmbxIsTypeControl.ShowWindow(cmd);
	m_CmbxTypeControl.ShowWindow(cmd);
	m_CmbxIsConceptLevelControl.ShowWindow(cmd);
	m_CmbxConceptLevelSwitch.ShowWindow(cmd);
//	m_CmbxIsObject.ShowWindow(cmd);
	m_CmbxIsObjectLevelControl.ShowWindow(cmd);
	m_CmbxObjectLevelSwitch.ShowWindow(cmd);
	m_EditConceptLevelMin.ShowWindow(cmd);
	m_EditConceptLevelMax.ShowWindow(cmd);
	m_EditObjectLevelMin.ShowWindow(cmd);
	m_EditObjectLevelMax.ShowWindow(cmd);

	m_BtnParentObjectTypeControl.ShowWindow(cmd_btn);
	m_BtnParentConceptControl.ShowWindow(cmd_btn);
	m_BtnParentObjectControl.ShowWindow(cmd_btn);


}





