// CommonCertInfoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CommonCertInfoDlg.h"

HICON aplLoadIconFromBitmap(UINT idbmp, COLORREF fon)
{
	if(idbmp==0) return 0;
	CBitmap tmpbmp;
	if(!tmpbmp.LoadBitmap(idbmp)) return 0;

	BITMAP bm;
	tmpbmp.GetBitmap(&bm);
	if(bm.bmWidth<1 || bm.bmHeight<1) return 0;

	CImageList il;
	il.Create(bm.bmWidth, bm.bmHeight, ILC_COLOR24 | ILC_MASK, 1, 1);
	il.SetImageCount(0);
	il.Add(&tmpbmp, fon);

	return il.ExtractIcon(0);
}

// CCommonCertInfoDlg dialog

IMPLEMENT_DYNAMIC(CCommonCertInfoDlg, CaplTranslateDialog)

CCommonCertInfoDlg::CCommonCertInfoDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CCommonCertInfoDlg::IDD, pParent)
{
	m_pParent = (CaplCertificateDlg*)pParent;
}

CCommonCertInfoDlg::~CCommonCertInfoDlg()
{
}

void CCommonCertInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_WIN_SHOW, m_show_win);
	DDX_Control(pDX, IDC_STATIC_IMAGE, m_picture);
}


BEGIN_MESSAGE_MAP(CCommonCertInfoDlg, CaplTranslateDialog)
	ON_BN_CLICKED(IDC_WIN_SHOW, &CCommonCertInfoDlg::OnBnClickedWinShow)
END_MESSAGE_MAP()

BOOL CCommonCertInfoDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	ShowCertImage();

	m_show_win.SetFlat(FALSE);
	m_show_win.SetIcon(GetAplStdIco24(APL_STD_24PROPERTIES));

	GetDlgItem(IDC_SN)->SetWindowText(m_pParent->m_sSN);
	GetDlgItem(IDC_ALGORITHM)->SetWindowText(m_pParent->m_sAlgorithm);

	GetDlgItem(IDC_BEFORE)->SetWindowText(m_pParent->m_sNotBefor);
	GetDlgItem(IDC_AFTER)->SetWindowText(m_pParent->m_sNotAfter);

	return TRUE;
}

bool CCommonCertInfoDlg::ShowCertImage()
{
	if(!m_pParent->m_ciCert) return false;

	CString str = _T("");
	int IDB = IDB_CERT_OK;
	CString sRevocationDate, sBefore, sAfter, sCurrent;

	if(m_pParent->m_sSubject == m_pParent->m_sIssuer)
		str =  APL_T("  . ");
	else 
		str =  APL_T(" . ");


	if(m_pParent->m_api->m_data.IsKindOf(m_pParent->m_ciCert,m_pParent->m_api->m_appr_mgr.e_apl_digital_sign_open_key))
	{
		m_pParent->m_api->m_data.GetAttr(m_pParent->m_ciCert, m_pParent->m_api->m_appr_mgr.a_apl_digital_sign_open_revocation_date, sRevocationDate);
		m_pParent->m_api->m_data.GetAttr(m_pParent->m_ciCert, m_pParent->m_api->m_appr_mgr.a_apl_digital_sign_open_not_after, sAfter);
		m_pParent->m_api->m_data.GetAttr(m_pParent->m_ciCert, m_pParent->m_api->m_appr_mgr.a_apl_digital_sign_open_not_before, sBefore);
	}
	else
	{
		aplDate2String(m_pParent->m_dtNotAfter, sAfter);
		aplDate2String(m_pParent->m_dtNotBefor, sBefore);
	}
	
	aplDate2String(COleDateTime::GetCurrentTime(), sCurrent);

	if(!sRevocationDate.IsEmpty())
	{
		IDB = IDB_CERT_BAD;
		str +=  APL_T(" .  .");
	}
	else
	{
		if(!(sBefore<=sCurrent && sAfter>=sCurrent))
		{
			if(sBefore > sCurrent)
				str +=  APL_T(" .      .");
			else if(sCurrent > sAfter)
				str +=  APL_T(" .    .");

			IDB = IDB_CERT_BAD;
		}
		else
		{
			str +=  APL_T(" .");
		}
	}

	COLORMAP  cm;
	cm.from= RGB(192, 192, 192);
	cm.to= GetSysColor(COLOR_BTNFACE);

	HICON ico = aplLoadIconFromBitmap(IDB, RGB(192,192,192));
	if(ico)
	{
		HICON hBmpOld = m_picture.SetIcon(ico);	
		::DeleteObject(hBmpOld);
	}

	GetDlgItem(IDC_STATIC_INFO)->SetWindowText(str);
	return true;
}



// CCommonCertInfoDlg message handlers

void CCommonCertInfoDlg::OnBnClickedWinShow()
{
	aplShellExecute(AfxGetMainWnd()->GetSafeHwnd(), _T("open"), m_pParent->m_sFile, _T(""), _T(""), SW_SHOW);	
}

void CCommonCertInfoDlg::OnOK()
{

}

void CCommonCertInfoDlg::OnCancel()
{

}