// ContextsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "apl_api.h"

#include "ContextsDlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CContextsDlg dialog


CContextsDlg::CContextsDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CContextsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CContextsDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_mgr=0;
	m_aggr=0;
	m_contexts.SetUniqueName(_T("contects_select_list"));
}


void CContextsDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CContextsDlg)
	DDX_Control(pDX, IDC_ALL_CONTEXT, m_all_context);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CContextsDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CContextsDlg)
	ON_BN_CLICKED(IDC_ALL_CONTEXT, OnAllContext)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CContextsDlg message handlers

BOOL CContextsDlg::OnInitDialog() 
{

	RECT rect={5,180,600,365};
	CWnd* wnd=GetDlgItem( IDC_CONTEXTS1 ) ;
	if(wnd!=0)
	{
		wnd->GetWindowRect(&rect);
		ScreenToClient(&rect);
	}
	m_contexts.Create(WS_VISIBLE|WS_CHILD|WS_BORDER|LVS_SINGLESEL|LVS_SORTASCENDING,rect,this,IDC_CHANGES);

	CaplTranslateDialog::OnInitDialog();
	
	DWORD sw=m_contexts.GetExtendedStyle( );
	sw|=LVS_EX_CHECKBOXES;
	m_contexts.SetExtendedStyle(sw);

/*	AddAnchor(IDC_OBJ_TREE,TOP_LEFT, BOTTOM_RIGHT);
	AddAnchor(IDC_CREATE_FOLDER,BOTTOM_LEFT);
	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);*/
		
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	if(m_mgr==0||m_aggr==0)m_ok_btn.EnableWindow(FALSE);
	else
	{
		// TODO: Add extra initialization here
		m_contexts.InsertColumn(0, APL_T(""),LVCFMT_LEFT,200);
		m_contexts.InsertColumn(1, APL_T("  "),LVCFMT_LEFT,150);

		int i,j;
		long l;
		CString buf;
		CaplInstance *inst;
		m_mgr->m_data->GetEntityExtent(m_mgr->e_pd_context,m_ext_contexts);
		for(i=0;i<m_ext_contexts.Size;i++)
		{
			m_mgr->m_data->GetAttr(m_ext_contexts[i],m_mgr->a_pd_context_name,buf);
			j=m_contexts.InsertItem(i,buf);
			m_mgr->m_data->GetAttr(m_ext_contexts[i],m_mgr->a_pd_context_life_cycle_stage,buf);
			m_contexts.SetItemText(j,1,buf);
			m_contexts.SetItemData(j,(long)m_ext_contexts[i]);
		}
		m_contexts.AutoSizeAllColumns();

		if(m_aggr->GetSize()==0)
		{
			m_all_context.SetCheck(1);
			m_contexts.EnableWindow(FALSE);
		}
		else
		{
			for(i=0;i<m_aggr->GetSize();i++)
			{
				inst=m_aggr->GetAt(i);
				if(inst!=0) 
				{
					for(j=0;j<m_contexts.GetItemCount();j++)
					{
						l=m_contexts.GetItemData(j);
						if(l==(long) inst) {
							m_contexts.SetCheck(j);
							break;
						}
					}
				}
			}
		}
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CContextsDlg::OnOK() 
{
	// TODO: Add extra validation here
	if(m_all_context.GetCheck()==1)m_aggr->Clear();
	else
	{
		int i,j=0,k;
		CaplInstance *inst;
		k=m_contexts.GetItemCount();
		m_aggr->Clear();

		for(i=0;i<k;i++)
		{
			if(m_contexts.GetCheck(i))
			{
				inst=(CaplInstance*)m_contexts.GetItemData(i);
				if(inst!=0) m_aggr->Add(inst);
				j++;
			}
		}
		if(j==k)m_aggr->Clear();
		if(j==0)
		{
			if(IDYES==AfxMessageBox( APL_T("     ,     !!!\n\n       ?"),
				MB_YESNO|MB_ICONQUESTION))
			m_aggr->Clear();
			else return;
		}
	}
	CaplTranslateDialog::OnOK();
}

void CContextsDlg::OnAllContext() 
{
	if(m_all_context.GetCheck()==1)
	{
		for(int i=0;i<m_contexts.GetItemCount();i++) m_contexts.SetCheck(i,FALSE);
		m_contexts.EnableWindow(FALSE);
	}
	else m_contexts.EnableWindow(TRUE);
	
}
