// DispMessageDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DispMessageDlg.h"
#include "apl_api.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CDispMessageDlg dialog


CDispMessageDlg::CDispMessageDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CDispMessageDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDispMessageDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_api= NULL;
	m_message= NULL;
}


void CDispMessageDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDispMessageDlg)
	DDX_Control(pDX, IDOK, m_okBtn);
	DDX_Control(pDX, IDC_MESSAGE_LIST, m_listCtrl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDispMessageDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CDispMessageDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDispMessageDlg message handlers

BOOL CDispMessageDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_listCtrl.InsertColumn(0,  APL_T(""), LVCFMT_LEFT, 220);
	m_listCtrl.InsertColumn(1,  APL_T(" "), LVCFMT_LEFT, 100);
	m_listCtrl.InsertColumn(2,  APL_T(" "), LVCFMT_LEFT, 200);
	m_listCtrl.SetImageList(aplGetInstImageList(), LVSIL_SMALL);

	m_okBtn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_okBtn.SetFlat(FALSE);

	COleDateTime odt;
	CString buf,name;
	
	if(m_api && apidata.IsConnected() && m_message)
	{	
		aplExtent ext;
		apidata.GetEntityExtent(m_api->m_message_mgr.e_message, ext);
		
		int k= -1;

		for(int i= 0; i<ext.GetSize(); i++)
		{
			if(!ext[i]) continue;
			
			name=_T("");

			CaplInstance* inst= NULL;
			apidata.GetAttr(ext[i], m_api->m_message_mgr.a_message_copy, inst);
			if(inst==m_message/* || ext[i]==m_message*/)
			{
				m_api->m_message_mgr.LoadMessageInfo(ext[i]);
				apidata.GetAttr(ext[i], m_api->m_message_mgr.a_message_rec_offisial, inst);
				if(inst)
				{
					m_api->m_appr_mgr.GetPersonName(inst, name);
				}
				apidata.GetAttr(ext[i], m_api->m_message_mgr.a_message_recipient, inst);
				if(inst)
				{
					if(!name.IsEmpty())
						name+= APL_T(" : ");

					m_api->m_appr_mgr.GetPersonName(inst, buf);
					name+=buf;

				}
				
				m_listCtrl.InsertItem(++k, name, m_api->GetInstIco(ext[i]));
				
				bool bSt;
				apidata.GetAttr(ext[i], m_api->m_message_mgr.a_message_recipient_kill, bSt);
				if(bSt)
					name=  APL_T("");
				else
				{
					apidata.GetAttr(ext[i], m_api->m_message_mgr.a_message_status, buf);
					if(buf==_T("replyed"))
						name=  APL_T(" ");
					else if(buf==_T("readed"))
						name=  APL_T("");
					else if(buf==_T("draft"))
						name=  APL_T(" ");
					else
					{
						apidata.GetAttr(ext[i], m_api->m_message_mgr.a_message_date_received, buf);
						if(buf.IsEmpty())
							name=  APL_T(" ");
						else
							name=  APL_T("");
					}
				}
				m_listCtrl.SetItemText(k, 1, name);

				apidata.GetAttr(ext[i], m_api->m_message_mgr.a_message_date_received, buf);
				if(buf!=_T(""))
				{
					aplString2Date(buf, odt);	
					buf= odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
					m_listCtrl.SetItemText(k, 2, buf);
				}
			}
		}
	}
		
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
