// DlgADProperies.cpp : implementation file
//

#include "stdafx.h"
//#include "APLSAM.h"
#include "DlgADProperies.h"
#include "DlgEditStrParam.h"
#include <aplBaseLib.h>
#include <CaplLDAP.h>

// CDlgADProperies dialog

TCHAR* ad_name_options_servers = (TCHAR*)APL_NO_T("AD\\ ");
TCHAR* ad_name_options_enable_autocreate = (TCHAR*)APL_NO_T("AD\\    ");
TCHAR* ad_name_options_user4data_login = (TCHAR*)APL_NO_T("AD\\    \\");
TCHAR* ad_name_options_user4data_pass = (TCHAR*)APL_NO_T("AD\\    \\");
TCHAR* ad_name_options_domain_groupe = (TCHAR*)APL_NO_T("AD\\ -");
TCHAR* ad_name_options_PSS_user_groupe = (TCHAR*)APL_NO_T("AD\\  PSS");
TCHAR* ad_name_options_PSS_org = (TCHAR*)APL_NO_T("AD\\  PSS");


IMPLEMENT_DYNAMIC(CDlgADProperies, CaplTranslateDialog)

CDlgADProperies::CDlgADProperies(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CDlgADProperies::IDD, pParent)
	, m_AutoCreateUser(FALSE)
	, m_OrgName4Create(_T(""))
	, m_UserNameGroup4Create(_T(""))
{
	m_api =0;
	m_org4create= 0;
	m_userGroup4create=0;
	m_PwdChanged = false;
}

CDlgADProperies::~CDlgADProperies()
{
}

void CDlgADProperies::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_SERVERS, m_CtrlListDomainServers);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_SERVERS_ADD, m_add_btn);
	DDX_Control(pDX, IDC_SERVERS_EDIT, m_edit_btn);
	DDX_Control(pDX, IDC_SERVERS_DEL, m_del_btn);
	DDX_Check(pDX, IDC_CHK_AUTO_CREATE_USER, m_AutoCreateUser);
	DDX_Text(pDX, IDC_PSS_ORG, m_OrgName4Create);
	DDX_Text(pDX, IDC_PSS_USERGROUP, m_UserNameGroup4Create);
	DDX_Control(pDX, IDC_USER, m_CtrlDomainUser);
	DDX_Control(pDX, IDC_PASSWORD, m_CtrlDomainPwd);
	DDX_Control(pDX, IDC_DOMAIN_GROUP, m_CtrlDomainGroupe);
	DDX_Control(pDX, IDC_SEL_USERGROUP, m_BtnSelUserGroup);
	DDX_Control(pDX, IDC_DEL_USERGROUP, m_BtnDelUserGroup);
	DDX_Control(pDX, IDC_DEL_ORG, m_BtnDelOrg);
	DDX_Control(pDX, IDC_SEL_ORG, m_BtnSelOrg);
}


BEGIN_MESSAGE_MAP(CDlgADProperies, CaplTranslateDialog)
	ON_BN_CLICKED(IDC_SERVERS_ADD, &CDlgADProperies::OnBnClickedServersAdd)
	ON_BN_CLICKED(IDC_SERVERS_DEL, &CDlgADProperies::OnBnClickedServersDel)
	ON_BN_CLICKED(IDC_SERVERS_EDIT, &CDlgADProperies::OnBnClickedServersEdit)
	ON_BN_CLICKED(IDOK, &CDlgADProperies::OnBnClickedOk)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_SERVERS, &CDlgADProperies::OnNMDblclkListServers)
	ON_BN_CLICKED(IDC_SEL_ORG, &CDlgADProperies::OnBnClickedSelOrg)
	ON_BN_CLICKED(IDC_DEL_ORG, &CDlgADProperies::OnBnClickedDelOrg)
	ON_BN_CLICKED(IDC_SEL_USERGROUP, &CDlgADProperies::OnBnClickedSelUsergroup)
	ON_BN_CLICKED(IDC_DEL_USERGROUP, &CDlgADProperies::OnBnClickedDelUsergroup)
	ON_BN_CLICKED(IDC_CHK_AUTO_CREATE_USER, &CDlgADProperies::OnBnClickedChkAutoCreateUser)
	ON_EN_CHANGE(IDC_PASSWORD, &CDlgADProperies::OnEnChangePassword)
	ON_BN_CLICKED(IDC_TEST_DOMAIN_USER, &CDlgADProperies::OnBnClickedTestDomainUser)
END_MESSAGE_MAP()


// CDlgADProperies message handlers

BOOL CDlgADProperies::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	if(m_api==0) return FALSE;

	// TODO:  Add extra initialization here

	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	m_add_btn.SetIcon(GetAplStdIco16(APLSTDICO_PLUS));
	m_add_btn.SetFlat(FALSE);
	m_del_btn.SetIcon(GetAplStdIco16(APLSTDICO_DELETE));
	m_del_btn.SetFlat(FALSE);
	m_edit_btn.SetIcon(GetAplStdIco16(APLSTDICO_PROPERTIES));
	m_edit_btn.SetFlat(FALSE);


	CRect rect;
	m_CtrlListDomainServers.GetWindowRect(rect);
	m_CtrlListDomainServers.InsertColumn(0,APL_T(" "),LVCFMT_LEFT,rect.Width()/2-2);
	m_CtrlListDomainServers.InsertColumn(1,APL_T(" "),LVCFMT_LEFT,rect.Width()/2-2);

	HWND hWnd;
	hWnd = ::GetDlgItem(m_hWnd, IDC_LIST_SERVERS);
	ListView_SetExtendedListViewStyle(hWnd,ListView_GetExtendedListViewStyle(hWnd) | LVS_EX_FULLROWSELECT /*| LVS_EX_GRIDLINES */);

	CString str_list,server,domain;
	int pos0=0,pos1,pos2;
	m_api->m_options_mgr.GetOptionValueBN(ad_name_options_servers,str_list);
	
	do{
		pos1 = str_list.Find(_T('%'),pos0);
		pos2 = str_list.Find(_T(';'),pos0);
		if(pos1==-1 || pos2==-1) break;
		domain = str_list.Mid(pos0,pos1-pos0);
		server = str_list.Mid(pos1+1,pos2-pos1-1);
		m_listDomainServer.Add(domain,server);
		pos0 = pos2+1;
	} while (true);

	MakeList();

	int i_param=0;
	m_api->m_options_mgr.GetOptionValueBN(ad_name_options_enable_autocreate,i_param);
	m_AutoCreateUser = i_param==1?TRUE:FALSE;


	CString sDomainUser4Access, str;
	m_api->m_options_mgr.GetOptionValueBN(ad_name_options_user4data_login,sDomainUser4Access);
	m_CtrlDomainUser.SetWindowText(sDomainUser4Access);
	m_api->m_options_mgr.GetOptionValueBN(ad_name_options_user4data_pass, str);
	if(!str.IsEmpty())
		m_CtrlDomainPwd.SetWindowText(_T("************"));

	CString sDomainGroupSource;
	m_api->m_options_mgr.GetOptionValueBN(ad_name_options_domain_groupe,sDomainGroupSource);
	m_CtrlDomainGroupe.SetWindowText(sDomainGroupSource);
	m_api->m_options_mgr.GetOptionValueBN(ad_name_options_PSS_user_groupe,i_param);
	m_userGroup4create = m_api->m_data.GetInstById(i_param);
	m_api->m_options_mgr.GetOptionValueBN(ad_name_options_PSS_org,i_param);
	m_org4create = m_api->m_data.GetInstById(i_param);

	CString sID,sName;
	if(m_org4create!=0)
	{
		m_api->m_data.GetAttr(m_org4create, m_api->m_appr_mgr.a_org_id, sID);
		m_api->m_data.GetAttr(m_org4create, m_api->m_appr_mgr.a_org_name, sName);
		m_OrgName4Create = sID + _T("/") + sName;
	}
	
	if(m_userGroup4create!=0)
	{
		m_api->m_data.GetAttr(m_userGroup4create, m_api->m_appr_mgr.a_apl_user_name, m_UserNameGroup4Create);
	}

	UpdateData(FALSE);
	CheckControls();

	m_PwdChanged=false;

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgADProperies::MakeList()
{
	//UpdateData(TRUE);
	int i,indx;
	CString server,domain;

	m_CtrlListDomainServers.DeleteAllItems();

	for(i=0;i<m_listDomainServer.GetSize();i++)
	{
		domain = m_listDomainServer.GetAt(i)->str;
		server = m_listDomainServer.GetAt(i)->val;
		indx = m_CtrlListDomainServers.InsertItem(i,domain);
		m_CtrlListDomainServers.SetItemText(indx,1,server);
	}
}

void CDlgADProperies::OnBnClickedServersAdd()
{
	// TODO: Add your control notification handler code here
	CDlgEditStrParam dlg;
	dlg.m_NameParam = APL_T(" :");
	dlg.m_NameValue = APL_T(" :");
	dlg.m_Titul = APL_T(" ");
	if(dlg.DoModal()==IDOK)
	{
		m_listDomainServer.Add(dlg.m_Param,dlg.m_Value);
		MakeList();
	}
}

void CDlgADProperies::OnBnClickedServersDel()
{
	// TODO: Add your control notification handler code here
	int indx;
	CString server,domain;
	indx=m_CtrlListDomainServers.GetNextItem( -1 , LVNI_ALL| LVNI_SELECTED );
	if(indx==-1 || indx >= m_listDomainServer.GetSize())return;
	
	domain = m_listDomainServer.GetAt(indx)->str;
	//server = m_listDomainServer.GetAt(i)->val;
	if(AfxMessageBox(APL_T("    \"")+domain+_T("\"?"),MB_YESNO)==IDYES)
	{
		m_listDomainServer.Remove(indx);
		MakeList();
	}
}

void CDlgADProperies::OnBnClickedServersEdit()
{
	// TODO: Add your control notification handler code here
	CDlgEditStrParam dlg;
	int indx;
	indx=m_CtrlListDomainServers.GetNextItem( -1 , LVNI_ALL| LVNI_SELECTED );
	if(indx==-1 || indx >= m_listDomainServer.GetSize())return;

	dlg.m_NameParam = APL_T(" :");
	dlg.m_NameValue = APL_T(" :");
	dlg.m_Titul = APL_T(" ");

	dlg.m_Param = m_listDomainServer.GetAt(indx)->str;
	dlg.m_Value = m_listDomainServer.GetAt(indx)->val;

	if(dlg.DoModal()==IDOK)
	{
		m_listDomainServer.Remove(indx);
		m_listDomainServer.Add(dlg.m_Param,dlg.m_Value);
		MakeList();
	}
}

void CDlgADProperies::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	
	CString sDomainUser4Access,sDomainPassword4Access;

	if(m_AutoCreateUser==TRUE)
	{
		m_CtrlDomainUser.GetWindowText(sDomainUser4Access); sDomainUser4Access.TrimRight(); sDomainUser4Access.TrimLeft();
		m_CtrlDomainPwd.GetWindowText(sDomainPassword4Access); sDomainPassword4Access.TrimRight(); sDomainPassword4Access.TrimLeft();

		if(sDomainUser4Access.IsEmpty()){AfxMessageBox(APL_T("      "), MB_ICONEXCLAMATION); return;}
		if(sDomainPassword4Access.IsEmpty()){AfxMessageBox(APL_T("       "), MB_ICONEXCLAMATION); return;}
		if(m_userGroup4create==0){AfxMessageBox(APL_T("      "), MB_ICONEXCLAMATION); return;}
		// ILS      .
		//if(m_org4create==0){AfxMessageBox(APL_T("      "), MB_ICONEXCLAMATION); return;}
	}

	OnOK();	

	CString server,domain,str_list=_T("");
	int i;

	for(i=0;i<m_listDomainServer.GetSize();i++)
	{
		domain = m_listDomainServer.GetAt(i)->str;
		server = m_listDomainServer.GetAt(i)->val;
		str_list+=domain+_T("%")+server+_T(";");
	}

	m_api->m_options_mgr.CreateOption(ad_name_options_servers,str_list);
	

	int i_param;

	i_param = m_AutoCreateUser==TRUE?1:0;
	m_api->m_options_mgr.CreateOption(ad_name_options_enable_autocreate,i_param);

	m_api->m_options_mgr.CreateOption(ad_name_options_user4data_login,sDomainUser4Access);

	if(m_PwdChanged)
	{
		//       ,              .
		if(sDomainPassword4Access.IsEmpty()){str_list.Empty();}else{ aplTranslateK(sDomainPassword4Access,str_list);}
		m_api->m_options_mgr.CreateOption(ad_name_options_user4data_pass,str_list);
	}

	CString sDomainGroupSource;
	m_CtrlDomainGroupe.GetWindowText(sDomainGroupSource); sDomainGroupSource.TrimRight(); sDomainGroupSource.TrimLeft();

	m_api->m_options_mgr.CreateOption(ad_name_options_domain_groupe,sDomainGroupSource);

	if(m_userGroup4create==0)i_param =0; else i_param = m_userGroup4create->GetId();
	m_api->m_options_mgr.CreateOption(ad_name_options_PSS_user_groupe,i_param);

	if(m_org4create==0)i_param =0; else i_param = m_org4create->GetId();
	m_api->m_options_mgr.CreateOption(ad_name_options_PSS_org,i_param);

}


void CDlgADProperies::OnNMDblclkListServers(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;
	OnBnClickedServersEdit();

}

void CDlgADProperies::OnBnClickedSelOrg()
{
	// TODO: Add your control notification handler code here
	CString sID,sName;
	aplExtent ext;
	CaplInstance *inst;
	UpdateData(TRUE);
	inst= m_api->m_appr_mgr.SelectPersonOrOrganization(APL_MODE_SELECT_ORG,ext,APL_T("  "), APL_T("     "));
	if(inst!=0)
	{
		m_org4create = inst;
		m_api->m_data.GetAttr(m_org4create, m_api->m_appr_mgr.a_org_id, sID);
		m_api->m_data.GetAttr(m_org4create, m_api->m_appr_mgr.a_org_name, sName);
		m_OrgName4Create = sID + _T("/") + sName;
	}
	UpdateData(FALSE);
}

void CDlgADProperies::OnBnClickedDelOrg()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	m_org4create=0;
	m_OrgName4Create = _T("");
	UpdateData(FALSE);
}

void CDlgADProperies::OnBnClickedSelUsergroup()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	CaplInstance *inst = m_api->m_appr_mgr.SelectAplUserOrGroup(APL_MODE_SELECT_USER_GROUP,APL_T("  "), APL_T("     "));
	if(inst!=0)
	{
		m_userGroup4create= inst;
		m_api->m_data.GetAttr(m_userGroup4create, m_api->m_appr_mgr.a_apl_user_name, m_UserNameGroup4Create);
	}
	UpdateData(FALSE);
}

void CDlgADProperies::OnBnClickedDelUsergroup()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	m_userGroup4create=0;
	m_UserNameGroup4Create=_T("");
	UpdateData(FALSE);
}

void CDlgADProperies::OnBnClickedChkAutoCreateUser()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	CheckControls();
}

void CDlgADProperies::CheckControls()
{
	m_CtrlDomainUser.EnableWindow(m_AutoCreateUser);
	m_CtrlDomainPwd.EnableWindow(m_AutoCreateUser);
	m_CtrlDomainGroupe.EnableWindow(m_AutoCreateUser);
	m_BtnSelUserGroup.EnableWindow(m_AutoCreateUser);
	m_BtnDelUserGroup.EnableWindow(m_AutoCreateUser);
	m_BtnDelOrg.EnableWindow(m_AutoCreateUser);
	m_BtnSelOrg.EnableWindow(m_AutoCreateUser);
}
void CDlgADProperies::OnEnChangePassword()
{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.

	m_PwdChanged = true;
}

void CDlgADProperies::OnBnClickedTestDomainUser()
{
	if(0==m_CtrlListDomainServers.GetItemCount()) {AfxMessageBox(_T("   .")); return;}
	
	int indx=0;
	if(m_CtrlListDomainServers.GetItemCount()>1) indx=m_CtrlListDomainServers.GetNextItem( -1 , LVNI_ALL| LVNI_SELECTED );
	if(indx==-1 || indx >= m_listDomainServer.GetSize()) {AfxMessageBox(_T("    ."),MB_ICONWARNING);return;}

	CString sDomain= m_CtrlListDomainServers.GetItemText(indx,0);
	CString sDomainIP= m_CtrlListDomainServers.GetItemText(indx,1);

	CString sDomainUser, sDomainUserPwd, sBuf;
	m_CtrlDomainUser.GetWindowText(sDomainUser); sDomainUser.TrimRight(); sDomainUser.TrimLeft();
	if(sDomainUser.IsEmpty())  {AfxMessageBox(_T("   "),MB_ICONSTOP); m_CtrlDomainUser.SetFocus(); return;}

	m_CtrlDomainPwd.GetWindowText(sDomainUserPwd); sDomainUserPwd.TrimRight(); sDomainUserPwd.TrimLeft();
	if(sDomainUserPwd.IsEmpty())  {AfxMessageBox(_T("    "),MB_ICONSTOP); m_CtrlDomainUser.SetFocus(); return;}

	if(sDomainUserPwd==_T("************"))
	{
		m_CtrlDomainPwd.SetWindowText(_T("")); m_CtrlDomainPwd.SetFocus();
		AfxMessageBox(_T("    "),MB_ICONWARNING); 
		return;
	}

	CaplLDAP ldap;
	if(!ldap.Init(sDomain,sDomainIP)) {AfxMessageBox(APL_T("    !"),MB_ICONSTOP|MB_OK); return;}
	if(!ldap.Connect(sDomainUser,sDomainUserPwd)) {AfxMessageBox(APL_T("  .    !"),MB_ICONSTOP|MB_OK); return;}

	//if(!ldap.GetUserInfo(sDomainUser,sBuf)) {AfxMessageBox(APL_T("    .\n\n,       !"),MB_ICONSTOP|MB_OK); return;}
	if(!ldap.FindUser(sDomainUser)) {AfxMessageBox(APL_T(" c  (FindUser).\n\n,       !"),MB_ICONSTOP|MB_OK); return;}

	CString sAttrVal;
	if(!ldap.GetObjectAttr(_T("su"),sAttrVal)) {AfxMessageBox(APL_T("    ( 'su').\n\n,       !"),MB_ICONSTOP|MB_OK); return;}
	if(!ldap.GetObjectAttr(_T("memberOf"),sAttrVal)) {AfxMessageBox(APL_T("    ( 'memberOf').\n\n,       !"),MB_ICONSTOP|MB_OK); return;}

	AfxMessageBox(APL_T("  !"),MB_ICONINFORMATION|MB_OK);
	
}
