// DocCopyFilterDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DocCopyFilterDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDocCopyFilterDlg dialog


CDocCopyFilterDlg::CDocCopyFilterDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CDocCopyFilterDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDocCopyFilterDlg)
	m_check_begin_date = FALSE;
	m_check_end_date = FALSE;
	m_check_doc = FALSE;
	m_check_out_of_order = FALSE;
	m_check_owner = FALSE;
	m_check_place_of_use = FALSE;
	m_check_state = FALSE;
	m_date_begin = COleDateTime::GetCurrentTime();
	m_date_end = COleDateTime::GetCurrentTime();
	m_doc_name = _T("");
	m_owner_name = _T("");
	m_place_of_use_name = _T("");
	m_state = _T("");
	m_check_id = FALSE;
	m_id = _T("");
	//}}AFX_DATA_INIT
	m_api=0;
	m_filter=0;
	m_owner=0;
	m_place_of_use=0;
	m_doc=0;
}


void CDocCopyFilterDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDocCopyFilterDlg)
	DDX_Control(pDX, IDC_ID, m_id_ctrl);
	DDX_Control(pDX, IDC_DOC_BTN, m_select_doc_btn);
	DDX_Control(pDX, IDC_STATE, m_state_ctrl);
	DDX_Control(pDX, IDC_DATE_END, m_date_end_ctrl);
	DDX_Control(pDX, IDC_DATE_BEGIN, m_date_begin_ctrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_PLACE_OF_USE_BTN, m_select_place_of_use_btn);
	DDX_Control(pDX, IDC_OWNER_BTN, m_select_owner_btn);
	DDX_Check(pDX, IDC_CHECK_DATE_BEGIN, m_check_begin_date);
	DDX_Check(pDX, IDC_CHECK_DATE_END, m_check_end_date);
	DDX_Check(pDX, IDC_CHECK_DOC, m_check_doc);
	DDX_Check(pDX, IDC_CHECK_OUT_OF_ORDER, m_check_out_of_order);
	DDX_Check(pDX, IDC_CHECK_OWNER, m_check_owner);
	DDX_Check(pDX, IDC_CHECK_PLACE_OF_USE, m_check_place_of_use);
	DDX_Check(pDX, IDC_CHECK_STATE, m_check_state);
	DDX_DateTimeCtrl(pDX, IDC_DATE_BEGIN, m_date_begin);
	DDX_DateTimeCtrl(pDX, IDC_DATE_END, m_date_end);
	DDX_Text(pDX, IDC_DOC, m_doc_name);
	DDX_Text(pDX, IDC_OWNER, m_owner_name);
	DDX_Text(pDX, IDC_PLACE_OF_USE, m_place_of_use_name);
	DDX_CBString(pDX, IDC_STATE, m_state);
	DDX_Check(pDX, IDC_CHECK_ID, m_check_id);
	DDX_Text(pDX, IDC_ID, m_id);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDocCopyFilterDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CDocCopyFilterDlg)
	ON_BN_CLICKED(IDC_CHECK_DOC, OnCheckDoc)
	ON_BN_CLICKED(IDC_CHECK_OWNER, OnCheckOwner)
	ON_BN_CLICKED(IDC_CHECK_PLACE_OF_USE, OnCheckPlaceOfUse)
	ON_BN_CLICKED(IDC_CHECK_STATE, OnCheckState)
	ON_BN_CLICKED(IDC_CHECK_DATE_BEGIN, OnCheckDateBegin)
	ON_BN_CLICKED(IDC_CHECK_DATE_END, OnCheckDateEnd)
	ON_BN_CLICKED(IDC_DOC_BTN, OnSelectDocBtn)
	ON_BN_CLICKED(IDC_OWNER_BTN, OnSelectOwnerBtn)
	ON_BN_CLICKED(IDC_PLACE_OF_USE_BTN, OnSelectPlaceOfUseBtn)
	ON_BN_CLICKED(IDC_CHECK_ID, OnCheckId)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDocCopyFilterDlg message handlers


BOOL CDocCopyFilterDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	if(!m_filter || !m_api) return FALSE;
	m_id=m_filter->m_id;
	if(m_id!=_T(""))
	{
		m_check_id=true;
		m_id_ctrl.SetReadOnly(FALSE);
	}
	m_owner=m_filter->m_owner;
	if(m_owner)
	{
		m_api->m_appr_mgr.GetPersonName(m_owner,m_owner_name);
		m_check_owner=true;
		m_select_owner_btn.EnableWindow(TRUE);
	}
	m_place_of_use=m_filter->m_place_of_use;
	if(m_place_of_use)
	{
		m_api->m_data.GetAttr(m_place_of_use,m_api->m_appr_mgr.a_org_name,m_place_of_use_name); 
		m_check_place_of_use=true;
		m_select_place_of_use_btn.EnableWindow(TRUE);
	}
	m_doc=m_filter->m_doc;
	if(m_doc)
	{
		m_api->GetItemName(m_doc,m_doc_name);
		m_check_doc=true;
		m_select_doc_btn.EnableWindow(TRUE);
	}
	if(m_filter->m_date_begin!=_T(""))
	{
		aplString2Date(m_filter->m_date_begin,m_date_begin);
		m_check_begin_date=true;
		m_date_begin_ctrl.EnableWindow(TRUE);
	}
	if(m_filter->m_date_end!=_T(""))
	{
		aplString2Date(m_filter->m_date_end,m_date_end);
		m_check_end_date=true;
		m_date_end_ctrl.EnableWindow(TRUE);
	}
	m_check_out_of_order=m_filter->m_b_only_out_of_order;
	if(m_filter->m_state!=_T(""))
	{
		m_state=m_filter->m_state;
		int i=m_state_ctrl.SelectString(-1,m_filter->m_state);
		if(i>-1)
		{
			m_check_state=true;
			m_state_ctrl.EnableWindow(TRUE);
		}
	}

	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDocCopyFilterDlg::OnCheckDoc() 
{
	UpdateData(TRUE);
	if(m_check_doc)
	{
		m_select_doc_btn.EnableWindow(TRUE);
		if(!m_doc) OnSelectDocBtn();
	}
	else
	{
		m_select_doc_btn.EnableWindow(FALSE);
	}
}

void CDocCopyFilterDlg::OnCheckOwner() 
{
	UpdateData(TRUE);
	if(m_check_owner)
	{
		m_select_owner_btn.EnableWindow(TRUE);
		if(!m_owner) OnSelectOwnerBtn();
	}
	else
	{
		m_select_owner_btn.EnableWindow(FALSE);
	}
	
}

void CDocCopyFilterDlg::OnCheckPlaceOfUse() 
{
	UpdateData(TRUE);
	if(m_check_place_of_use)
	{
		m_select_place_of_use_btn.EnableWindow(TRUE);
		if(!m_place_of_use) OnSelectPlaceOfUseBtn();
	}
	else
	{
		m_select_place_of_use_btn.EnableWindow(FALSE);
	}
	
}

void CDocCopyFilterDlg::OnCheckState() 
{
	UpdateData(TRUE);
	if(m_check_state)
	{
		m_state_ctrl.EnableWindow(TRUE);
	}
	else
	{
		m_state_ctrl.EnableWindow(FALSE);
	}
	
}

void CDocCopyFilterDlg::OnCheckDateBegin() 
{
	UpdateData(TRUE);
	if(m_check_begin_date)
	{
		m_date_begin_ctrl.EnableWindow(TRUE);
	}
	else
	{
		m_date_begin_ctrl.EnableWindow(FALSE);
	}
}

void CDocCopyFilterDlg::OnCheckDateEnd() 
{
	UpdateData(TRUE);
	if(m_check_end_date)
	{
		m_date_end_ctrl.EnableWindow(TRUE);
	}
	else
	{
		m_date_end_ctrl.EnableWindow(FALSE);
	}
	
}

void CDocCopyFilterDlg::OnSelectDocBtn() 
{
	CaplInstance *doc=m_api->m_doc_mgr.SelectInstance(APL_MODE_SELECT_DOC, APL_T(" "));
	if(doc)
	{
		m_doc=doc;
		m_api->GetItemName(m_doc,m_doc_name);
		UpdateData(FALSE);
	}

	
}

void CDocCopyFilterDlg::OnSelectOwnerBtn() 
{
	aplExtent ext;
	CaplInstance *inst=m_api->m_appr_mgr.SelectPersonOrOrganization(APL_MODE_SELECT_PERSON, ext,  APL_T("    "),  APL_T("    "));
	if(inst)
	{
		m_owner=inst;
		m_api->m_appr_mgr.GetPersonName(m_owner,m_owner_name);
		UpdateData(FALSE);
	}
	
}

void CDocCopyFilterDlg::OnSelectPlaceOfUseBtn() 
{
	aplExtent ext;
	CaplInstance *inst=m_api->m_appr_mgr.SelectPersonOrOrganization(APL_MODE_SELECT_ORG, ext,  APL_T("  "),  APL_T("    "));
	if(inst)
	{
		m_place_of_use=inst;
		m_api->m_data.GetAttr(m_place_of_use,m_api->m_appr_mgr.a_org_name,m_place_of_use_name); 
		UpdateData(FALSE);
	}
	
}

void CDocCopyFilterDlg::OnOK() 
{
	// TODO: Add extra validation here
	UpdateData(TRUE);
	if(m_check_begin_date && m_check_end_date)
	{
		if(m_date_begin>m_date_end)
		{
			AfxMessageBox( APL_T("        !"));
			return;
		}
	}
	m_filter->m_id=_T("");
	if(m_check_id) m_filter->m_id=m_id;
	m_filter->m_doc=0;
	if(m_check_doc) m_filter->m_doc=m_doc;
	m_filter->m_owner=0;
	if(m_check_owner) m_filter->m_owner=m_owner;
	m_filter->m_place_of_use=0;
	if(m_check_place_of_use) m_filter->m_place_of_use=m_place_of_use;
	m_filter->m_state=_T("");
	if(m_check_state) m_filter->m_state=m_state;
	m_filter->m_date_begin=_T("");
	if(m_check_begin_date) 
	{
		m_date_begin.SetDateTime(m_date_begin.GetYear(),m_date_begin.GetMonth(),m_date_begin.GetDay(),0,0,0);
		aplDate2String(m_date_begin,m_filter->m_date_begin);
	}
	m_filter->m_date_end=_T("");
	if(m_check_end_date) 
	{
		m_date_end.SetDateTime(m_date_end.GetYear(),m_date_end.GetMonth(),m_date_end.GetDay(),23,59,59);
		aplDate2String(m_date_end,m_filter->m_date_end);
	}
	m_filter->m_b_only_out_of_order=m_check_out_of_order;
	CaplTranslateDialog::OnOK();
}

void CDocCopyFilterDlg::OnCheckId() 
{
	UpdateData(TRUE);
	if(m_check_id)
	{
		m_id_ctrl.SetReadOnly(FALSE);
	}
	else
	{
		m_id_ctrl.SetReadOnly(TRUE);
	}
	
}
