// DocCreateDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "DocCreateDlg.h"
#include "DocFormatListsDlg.h"

#include "apl_api.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDocCreateDlg dialog

CDocCreateDlg::CDocCreateDlg(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CDocCreateDlg::IDD, pParent)
	, m_dt_rev_date(COleDateTime::GetCurrentTime())
	, m_sRevDate(_T(""))
	, m_sOfListsA4(_T(""))
{
	//{{AFX_DATA_INIT(CDocCreateDlg)
	m_del_from_disk=FALSE;
	m_save_to_db = FALSE;
	m_set_ro = FALSE;
	m_doc_descr = _T("");
	m_doc_id = _T("");
	m_doc_name = _T("");
	m_doc_rel_src = _T("");
	m_doc_rev_descr = _T("");
	m_doc_rev_file = _T("");
	m_doc_rev_id = _T("");
	m_file_size_str = _T("");
	m_label = _T("");
	m_format = _T("");
	//}}AFX_DATA_INIT
	m_api=0;
	m_doc=0; m_rev=0; m_dt=0;
	m_show_contexts=false;
	m_context_changed=false;
	m_doc_ref_ro=false;
	m_bWFstateReadOnly = false;
	
	m_doc= NULL;
	m_rev= NULL;
	m_dt= NULL;	
	m_pEntryView = NULL;

	m_csAccessString	=_T("");
	m_nInclude = 1;
	m_nGroup = 0;

	m_doc_po_from=0;
}

void CDocCreateDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDocCreateDlg)
	DDX_Control(pDX, IDC_FORMAT, m_format_ctrl);
	DDX_Control(pDX, IDC_DOC_NAME_CHANGE, m_doc_name_chg_btn);
	DDX_Control(pDX, IDC_DOC_ID_CHANGE, m_doc_id_chg_btn);
	DDX_Control(pDX, IDC_B_PROPS_PROPS, m_bPropsProps);
	DDX_Control(pDX, IDC_B_PROPS_DEL, m_bPropsDel);
	DDX_Control(pDX, IDC_B_PROPS_ADD, m_bPropsAdd);
	DDX_Control(pDX, IDC_TAB1, m_Tab);
	DDX_Check(pDX, IDC_SAVE_TO_DB, m_save_to_db);
	DDX_Check(pDX, IDC_SET_READ_ONLY, m_set_ro);
	DDX_Check(pDX, IDC_DEL_FROM_DISK, m_del_from_disk);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_DOC_ID, m_doc_id_ctrl);
	DDX_Control(pDX, IDC_BROWSE_FILE, m_browse_file_btn);
	DDX_Control(pDX, IDC_SEL_CONTEXT, m_context_sel);
	DDX_Control(pDX, IDC_SAVE_TO_DB, m_save_to_db_ctrl);
	DDX_Control(pDX, IDC_SET_READ_ONLY, m_set_ro_btn);
	DDX_Control(pDX, IDC_SEL_DOC_TYPE, m_doc_type_ctrl);
	DDX_Control(pDX, IDC_NAMES_CONTEXTS, m_context_names);
	DDX_Control(pDX, IDC_DOC_DESCR, m_doc_descr_ctrl);
	DDX_Control(pDX, IDC_DOC_NAME, m_doc_name_ctrl);
	DDX_Control(pDX, IDC_DOC_REL_SRC, m_doc_rel_src_ctrl);
	DDX_Control(pDX, IDC_DOC_REV_DESCR, m_doc_rev_descr_ctrl);
	DDX_Control(pDX, IDC_DOC_REV_FILE, m_doc_rev_file_ctrl);
	DDX_Control(pDX, IDC_DOC_TYPE_TEXT, m_dt_text);
	DDX_Control(pDX, IDC_FILESIZE, m_file_size_ctrl);
	DDX_Control(pDX, IDC_LABEL, m_label_ctrl);
	DDX_Control(pDX, IDC_ST_CONTEXTS, m_st_contexts);
	DDX_Control(pDX, IDC_ST_NAME, m_st_name);
	DDX_Control(pDX, IDC_ST_REL_SOURCE, m_st_rel_src);
	DDX_Control(pDX, IDC_DOC_REV_ID, m_edit_rev_id);

	DDX_Control(pDX, IDC_DKVD, m_dkvd);
	DDX_Control(pDX, IDC_KDVZOHI, m_kdvzohi);
	DDX_Control(pDX, IDC_OF_LIST, m_of_list);
	DDX_Control(pDX, IDC_OF_LISTS, m_of_lists);
	DDX_Control(pDX, IDC_AUTENT, m_autent);
	DDX_Control(pDX, IDC_STRUCT_KIND, m_struct_kind);
	DDX_Text(pDX, IDC_DOC_PART, m_sPart);

	//

	//DDX_Control(pDX, IDC_DOC_SHEETS, m_doc_sheets);
	//DDX_Control(pDX, IDC_DOC_TOTAL_SHEETS, m_doc_total_sheets);
	//DDX_Control(pDX, IDC_DOC_FORMAT, m_doc_format);
	//DDX_Control(pDX, IDC_DOC_LITERA, m_doc_litera);

	//DDX_Text(pDX, IDC_DOC_SHEETS, m_sDocSheets);
	//DDX_Text(pDX, IDC_DOC_TOTAL_SHEETS, m_sDocTotalSheets);
	//DDX_Text(pDX, IDC_DOC_LITERA, m_sDocLitera);
	//DDX_Text(pDX, IDC_DOC_FORMAT, m_sDocFormat);	

	//

	DDX_Text(pDX, IDC_DKVD, m_sDkvd);
	DDX_Text(pDX, IDC_KDVZOHI, m_sKdvzohi);
	DDX_Text(pDX, IDC_OF_LIST, m_sOfList);
	DDX_Text(pDX, IDC_OF_LISTS, m_sOfLists);
	DDX_Text(pDX, IDC_OF_LISTS_A4, m_sOfListsA4);
	DDX_Check(pDX, IDC_AUTENT, m_nAutent);
	DDX_Check(pDX, IDC_INCLUDE, m_nInclude);
	DDX_Check(pDX, IDC_GROUP, m_nGroup);
	DDX_Text(pDX, IDC_STRUCT_KIND, m_sStructKind);

	DDX_Text(pDX, IDC_DOC_DESCR, m_doc_descr);
	DDX_Text(pDX, IDC_DOC_ID, m_doc_id);
	DDX_Text(pDX, IDC_DOC_NAME, m_doc_name);
	DDX_Text(pDX, IDC_DOC_REL_SRC, m_doc_rel_src);
	DDX_Text(pDX, IDC_DOC_REV_DESCR, m_doc_rev_descr);
	DDX_Text(pDX, IDC_DOC_REV_FILE, m_doc_rev_file);
	DDX_Text(pDX, IDC_DOC_REV_ID, m_doc_rev_id);
	DDX_Text(pDX, IDC_FILESIZE, m_file_size_str);
	DDX_Text(pDX, IDC_LABEL, m_label);
	DDX_Text(pDX, IDC_LITERA, m_litera);
	DDX_CBString(pDX, IDC_FORMAT, m_format);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_REV_DATETIMEPICKER, m_rev_date_ctrl);
	DDX_DateTimeCtrl(pDX, IDC_REV_DATETIMEPICKER, m_dt_rev_date);
	DDX_Control(pDX, IDC_FILECRC, m_crc_ctrl);
	DDX_Control(pDX, IDC_CRC_CHECK, m_crc_check_btn);
	DDX_Control(pDX, IDC_OF_LISTS_A4, m_lists_a4_ctrl);
	DDX_Control(pDX, IDC_DOC_REG_NUM, m_inv_num_ctrl);
	DDX_Control(pDX, IDC_DOC_FROM, m_from_ctrl);
	DDX_Control(pDX, IDC_DOC_TO, m_to_ctrl);
	DDX_Control(pDX, IDC_SEL_DOC_FROM, m_sel_fom_ctrl);
	DDX_Control(pDX, IDC_SEL_DOC_TO, m_sel_to_ctrl);
	DDX_Control(pDX, IDC_DOC_DATE_TREB, m_doc_date_treb_ctrl);
	DDX_Control(pDX, IDC_DOC_SROCHN, m_doc_srocn_ctrl);
	DDX_Control(pDX, IDC_DOC_DATE_ISP_PLAN, m_doc_date_isp_plan_ctrl);
	DDX_Control(pDX, IDC_DOC_DATE_ISP_FACT, m_doc_date_isp_fact_ctrl);
	DDX_Control(pDX, IDC_DEL_DOC_FROM, m_del_fom_ctrl);
	DDX_Control(pDX, IDC_DOC_DATE, m_doc_date_ctrl);
	DDX_Control(pDX, IDC_LITERA, m_litera_ctrl);
	DDX_Control(pDX, IDC_OF_LISTS_SELECT, m_lists_select_btn);
	DDX_Control(pDX, IDC_DOC_VIEW, m_view_btn);
	DDX_Control(pDX, IDC_STATIC_OF_LISTS, m_statis_of_list);
	DDX_Control(pDX, IDC_DEL_FROM_DISK, m_del_from_disk_btn);
	DDX_Control(pDX, IDC_GROUP, m_group_ctrl);
}


BEGIN_MESSAGE_MAP(CDocCreateDlg, CaplResizableDialog)
	//{{AFX_MSG_MAP(CDocCreateDlg)
	ON_BN_CLICKED(IDC_BROWSE_FILE, OnBrowseFile)
	ON_BN_CLICKED(IDC_ST_NAME, OnStName)
	ON_BN_CLICKED(IDC_SEL_CONTEXT, OnSelContext)
	ON_BN_CLICKED(IDC_SEL_DOC_TYPE, OnSelDocType)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB1, OnSelchangeTab1)
	ON_BN_CLICKED(IDC_B_PROPS_ADD, OnBPropsAdd)
	ON_BN_CLICKED(IDC_B_PROPS_DEL, OnBPropsDel)
	ON_BN_CLICKED(IDC_B_PROPS_PROPS, OnBPropsProps)
	ON_BN_CLICKED(IDC_DOC_ID_CHANGE, OnDocIdChange)
	ON_BN_CLICKED(IDC_DOC_NAME_CHANGE, OnDocNameChange)
	//}}AFX_MSG_MAP
	ON_STN_CLICKED(IDC_T_DOC_TYPE, OnStnClickedTDocType)
	ON_EN_CHANGE(IDC_LABEL, OnEnChangeLabel)
	ON_CBN_SELCHANGE(IDC_KDVZOHI, OnCbnSelchangeKdvzohi) 		
	ON_EN_CHANGE(IDC_OF_LIST, OnEnChangeOfList)
	ON_EN_CHANGE(IDC_OF_LISTS, OnEnChangeOfLists)
	ON_EN_CHANGE(IDC_LITERA, OnEnChangeLitera)
	ON_BN_CLICKED(IDC_CRC_CHECK, &CDocCreateDlg::OnBnClickedCrcCheck)
	ON_CBN_SELCHANGE(IDC_FORMAT, OnCbnSelchangeFormat)
	ON_CBN_EDITUPDATE(IDC_FORMAT, OnCbnSelchangedFormat)
	ON_CBN_EDITCHANGE(IDC_FORMAT, OnCbnEditchangeFormat)
	ON_BN_CLICKED(IDC_SEL_DOC_FROM, &CDocCreateDlg::OnBnClickedSelDocFrom)
	ON_BN_CLICKED(IDC_SEL_DOC_TO, &CDocCreateDlg::OnBnClickedSelDocTo)
	ON_BN_CLICKED(IDC_DEL_DOC_FROM, &CDocCreateDlg::OnBnClickedDelDocFrom)
	ON_BN_CLICKED(IDC_OF_LISTS_SELECT, &CDocCreateDlg::OnBnClickedOfListsSelect)
	ON_BN_CLICKED(IDC_DOC_VIEW, &CDocCreateDlg::OnBnClickedDocView)
	ON_BN_CLICKED(IDC_SAVE_TO_DB, &CDocCreateDlg::OnBnClickedSaveToDb)
	ON_WM_DROPFILES()
END_MESSAGE_MAP()


BOOL CDocCreateDlg::SetAnchors(void)
{
	AddAnchor(IDC_TAB1,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_ST_NAME,TOP_CENTER);

	AddAnchor(IDC_B_PROPS_ADD,TOP_RIGHT);
	AddAnchor(IDC_B_PROPS_DEL,TOP_RIGHT);
	AddAnchor(IDC_B_PROPS_PROPS,TOP_RIGHT);

	//AddAnchor(IDC_T_VIEW_FRAME,TOP_LEFT,BOTTOM_RIGHT);

	AddAnchor(IDC_T_DOC_ID,TOP_LEFT);
	AddAnchor(IDC_DOC_ID,TOP_LEFT,TOP_RIGHT);
	AddAnchor(IDC_T_DOC_NAME,TOP_LEFT);
	AddAnchor(IDC_DOC_NAME,TOP_LEFT,TOP_RIGHT);
	AddAnchor(IDC_T_DOC_TYPE,TOP_LEFT);
	AddAnchor(IDC_DOC_TYPE_TEXT,TOP_LEFT,TOP_RIGHT);

	AddAnchor(IDC_SEL_DOC_TYPE,TOP_RIGHT);
	AddAnchor(IDC_DOC_ID_CHANGE,TOP_RIGHT);
	AddAnchor(IDC_DOC_NAME_CHANGE,TOP_RIGHT);

	AddAnchor(IDC_T_DKVD,TOP_RIGHT);
	AddAnchor(IDC_DKVD,TOP_RIGHT);

	AddAnchor(IDC_STATIC_PART,TOP_RIGHT);
	AddAnchor(IDC_DOC_PART,TOP_RIGHT);

	AddAnchor(IDC_T_DOC_DESCR,TOP_LEFT);
	AddAnchor(IDC_DOC_DESCR,TOP_LEFT,TOP_RIGHT);

	AddAnchor(IDC_GRP_DOC_REV,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_T_DOC_REV_ID,TOP_LEFT);
	AddAnchor(IDC_DOC_REV_ID,TOP_LEFT);
	AddAnchor(IDC_T_DOC_REV_LABEL,TOP_LEFT);
	//AddAnchor(IDC_LABEL,TOP_LEFT,TOP_RIGHT);
	//AddAnchor(IDC_T_DOC_REV_LITERA,TOP_RIGHT);
	//AddAnchor(IDC_LITERA,TOP_RIGHT);
	AddAnchor(IDC_T_DOC_REV_DESCR,TOP_LEFT);
	AddAnchor(IDC_DOC_REV_DESCR,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_T_DOC_REV_FILE,BOTTOM_LEFT);
	AddAnchor(IDC_DOC_REV_FILE,BOTTOM_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_BROWSE_FILE,BOTTOM_RIGHT);
	AddAnchor(IDC_SAVE_TO_DB,BOTTOM_LEFT);
	AddAnchor(IDC_DEL_FROM_DISK,BOTTOM_LEFT);
	AddAnchor(IDC_T_DOC_REV_SIZE,BOTTOM_RIGHT);
	AddAnchor(IDC_FILESIZE,BOTTOM_RIGHT);
	AddAnchor(IDC_T_DOC_REV_SIZE2,BOTTOM_RIGHT);
	AddAnchor(IDC_CRC_CHECK,BOTTOM_RIGHT);
	AddAnchor(IDC_FILECRC,BOTTOM_RIGHT);

	AddAnchor(IDC_SET_READ_ONLY,BOTTOM_LEFT);

	AddAnchor(IDC_ST_REL_SOURCE,BOTTOM_LEFT);
	AddAnchor(IDC_DOC_REL_SRC,BOTTOM_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_ST_CONTEXTS,BOTTOM_LEFT);
	AddAnchor(IDC_NAMES_CONTEXTS,BOTTOM_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_SEL_CONTEXT,BOTTOM_RIGHT);

	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
	AddAnchor(IDC_DOC_VIEW,BOTTOM_LEFT);

	//   
	AddAnchor(IDC_T_REG_NUM,TOP_RIGHT);
	AddAnchor(IDC_DOC_REG_NUM,TOP_RIGHT);
	AddAnchor(IDC_T_DOC_FROM ,TOP_RIGHT);
	AddAnchor(IDC_DOC_FROM,TOP_RIGHT);
	AddAnchor(IDC_SEL_DOC_FROM,TOP_RIGHT);
	AddAnchor(IDC_DEL_DOC_FROM,TOP_RIGHT);
	AddAnchor(IDC_T_DOC_TO ,TOP_RIGHT);
	AddAnchor(IDC_DOC_TO,TOP_RIGHT);
	AddAnchor(IDC_SEL_DOC_TO,TOP_RIGHT);
	AddAnchor(IDC_T_DOC_DATE,TOP_RIGHT);
	AddAnchor(IDC_T_DOC_DATE_TREB,TOP_RIGHT);
	AddAnchor(IDC_DOC_DATE,TOP_RIGHT);
	AddAnchor(IDC_DOC_DATE_TREB,TOP_RIGHT);
	AddAnchor(IDC_T_DOC_SROCHN,TOP_RIGHT);
	AddAnchor(IDC_DOC_SROCHN,TOP_RIGHT);
	AddAnchor(IDC_T_DOC_DATE_ISP_PLAN,TOP_RIGHT);
	AddAnchor(IDC_DOC_DATE_ISP_PLAN,TOP_RIGHT);
	AddAnchor(IDC_T_DOC_DATE_ISP_FACT,TOP_RIGHT);
	AddAnchor(IDC_DOC_DATE_ISP_FACT,TOP_RIGHT);

	return TRUE;
}

BOOL CDocCreateDlg::ValidateData(void)
{
	m_doc_id.TrimLeft();
	m_doc_id.TrimRight();
	m_doc_id_ctrl.SetWindowText(m_doc_id);
	m_doc_name.TrimLeft();
	m_doc_name.TrimRight();
	m_doc_name_ctrl.SetWindowText(m_doc_name);
	m_doc_rev_file.TrimLeft();
	m_doc_rev_file.TrimRight();
	m_doc_rev_file_ctrl.SetWindowText(m_doc_rev_file);
	//  
	if(_T("")==m_doc_id)
	{
		AfxMessageBox( APL_T(" \"\"   !"));
		return FALSE;
	}

//	if(_T("")==m_doc_name)
//	{
//		AfxMessageBox(APL_T(" \"\"   !"));
//		return FALSE;
//	}

	if(_T("")==m_doc_rev_file)
	{
		if(NULL==m_rev)
		{
			AfxMessageBox( APL_T(" \"\"   !"));
			return FALSE;
		}
	}

	if(NULL!=m_api)
	{
		//   
		
		/*  21.06.2022    
		if(m_api->m_options_mgr.CheckInstallCode(APL_NO_T("")))
		{
			CaplAttrValue tst_values[5];
			tst_values[0].value.Set((LPCTSTR)m_doc_id);
			tst_values[0].attr=m_api->m_doc_mgr.a_doc_id;

			if(!apidata.NET_TestUniqueAttrValues(m_api->m_doc_mgr.e_doc,m_doc,1,&tst_values[0],false))
			{
				AfxMessageBox( APL_T("   !"), MB_ICONSTOP);
				//AfxMessageBox(APL_T("          !!!"));
				return FALSE;
			}
		}
		else */
		{
			CaplAttrValue tst_values[5];
			tst_values[0].value.Set((LPCTSTR)m_doc_id);
			tst_values[0].attr=m_api->m_doc_mgr.a_doc_id;

			tst_values[1].value.Set(m_dt);
			tst_values[1].attr=m_api->m_doc_mgr.a_doc_kind;

			tst_values[2].value.Set(m_sDkvd);
			tst_values[2].attr=m_api->m_doc_mgr.a_doc_add_dt_code;

			CString t_str; if(!m_sKdvzohi.IsEmpty()) t_str = m_sKdvzohi[0];
			tst_values[3].value.Set(t_str);
			tst_values[3].attr=m_api->m_doc_mgr.a_doc_code_depend_desp;

			CString sPart;
			tst_values[4].value.Set(m_sPart);
			tst_values[4].attr=m_api->m_doc_mgr.a_doc_part;

			if(!apidata.NET_TestUniqueAttrValues(m_api->m_doc_mgr.e_doc,m_doc,5,&tst_values[0],false))
			{
				AfxMessageBox( APL_T("  .  : \"\", \" \", \"  \", \"\""), MB_ICONSTOP);
				//AfxMessageBox(APL_T("          !!!"));
				return FALSE;
			}
		}
	}

	//       
	if(m_dt!=0 && m_dt->GetAccessmode()!=aplNO)
	{
		CString sCode;
		m_api->m_data.GetAttr(m_dt, m_api->m_doc_mgr.a_dt_id, sCode);


		CaplInstance* pOpt = m_api->m_options_mgr.FindOptionBN(APL_NO_T("      "));
		if (!pOpt)
		{
			pOpt = m_api->m_options_mgr.CreateOption(APL_NO_T("      "),1);
		}

		int iOptValue ;
		m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("      "), iOptValue);

		if (iOptValue == 1)
		{
			if(!sCode.IsEmpty() && m_doc_id.Find(sCode) == -1)
			{
				if(AfxMessageBox( APL_T("     . ?"), MB_ICONWARNING|MB_YESNO) == IDNO)
					return FALSE;
			}
		}
	}

	return TRUE;
}

BOOL CDocCreateDlg::SaveData(void)
{
	CWnd*			pwnd		=NULL;
	CaplAccessView*	pAccView	=NULL;

	CaplInstance*	cit			=NULL;
	bool			bAut = false, bTmp = false;
	CString			cst, t_str, s_kdvzohi;

	int				i;

	aplDate2String(m_dt_rev_date, m_sRevDate);

	if(m_api!=0)
	{
		//  
		if(0==m_doc) m_doc=apidata.CreateInstance(m_api->m_doc_mgr.e_apl_doc);

		apidata.GetAttr(m_doc,m_api->m_doc_mgr.a_doc_id,cst);
		if(cst!=m_doc_id) 
			apidata.PutAttr(m_doc,m_api->m_doc_mgr.a_doc_id,m_doc_id);
		apidata.GetAttr(m_doc,m_api->m_doc_mgr.a_doc_name,cst);
		if(cst!=m_doc_name) 
			apidata.PutAttr(m_doc,m_api->m_doc_mgr.a_doc_name,m_doc_name);
		apidata.GetAttr(m_doc,m_api->m_doc_mgr.a_doc_descr,cst);
		if(cst!=m_doc_descr) 
			apidata.PutAttr(m_doc,m_api->m_doc_mgr.a_doc_descr,m_doc_descr);

		apidata.GetAttr(m_doc,m_api->m_doc_mgr.a_doc_kind,cit);
		if(cit!=m_dt) 
			apidata.PutAttr(m_doc,m_api->m_doc_mgr.a_doc_kind,m_dt);

		
		//    
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_add_dt_code, t_str);
		if(m_sDkvd != t_str) apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_add_dt_code, m_sDkvd);

		//   
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_struct_kind, t_str);
		if(m_sStructKind != t_str) apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_struct_kind, m_sStructKind);

		// 
		if(!m_sKdvzohi.IsEmpty()) s_kdvzohi = m_sKdvzohi[0];
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_code_depend_desp, t_str);
		if(s_kdvzohi != t_str) apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_code_depend_desp, s_kdvzohi);

		// 
		m_nAutent ? bTmp = true : bTmp = false;
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_authentic, bAut);
		if(bTmp != bAut) apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_authentic, bTmp);		

		//   
		m_nInclude ? bTmp = true : bTmp = false;
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_incl_in_doc, bAut);
		if(bTmp != bAut) apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_incl_in_doc, bTmp);

		//
		m_nGroup ? bTmp = true : bTmp = false;
		bool bGroup;
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_group, bGroup);
		if(bTmp != bGroup) apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_group, bTmp);

		// c
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_part, t_str);
		if(m_sPart != t_str) apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_part, m_sPart);


		CString buf;

		// . 
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_inv_num, t_str);
		m_inv_num_ctrl.GetWindowText(buf);
		if(buf!=t_str)	apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_inv_num, buf);

		//
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_urgency, t_str);
		m_doc_srocn_ctrl.GetWindowText(buf);
		if(buf!=_T("") && CaplTranslate::IsNeedTranslate())
		{
			if(buf==APL_T("")) buf=APL_NO_T("");
			else if(buf==APL_T("")) buf=APL_NO_T("");
			else if(buf==APL_T("")) buf=APL_NO_T("");
		}
		if(buf!=t_str)	apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_urgency, buf);

		CaplInstance *po_from_old;
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_from, po_from_old);	
		if(po_from_old!=m_doc_po_from)
		{
			apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_from, m_doc_po_from);	
		}

		aplExtent recipients_old;
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_to, recipients_old);	
		if(!aplExtentIsEqual(recipients_old,m_doc_recitients))
		{
			apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_recipients, m_doc_recitients);	
		}

		COleDateTime odt;
		
		// 

		m_doc_date_ctrl.GetTime(odt);
		aplDate2String(odt,buf);
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_date, t_str);
		if(buf!=t_str) apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_date, buf);

		m_doc_date_treb_ctrl.GetTime(odt);
		aplDate2String(odt,buf);
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_date_of_execution_required, t_str);
		if(buf!=t_str) apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_date_of_execution_required, buf);

		m_doc_date_isp_plan_ctrl.GetTime(odt);
		aplDate2String(odt,buf);
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_of_execution_planned, t_str);
		if(buf!=t_str) apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_of_execution_planned, buf);

		m_doc_date_isp_fact_ctrl.GetTime(odt);
		aplDate2String(odt,buf);
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_of_execution_fact, t_str);
		if(buf!=t_str) apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_of_execution_fact, buf);

//     
/*
		//  
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_format, t_str);
		if(m_sDocFormat != t_str) apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_format, m_sDocFormat);

		//  
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_litera, t_str);
		if(m_sDocLitera != t_str) apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_litera, m_sDocLitera);

		//  
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_sheets, t_str);
		if(m_sDocSheets != t_str) apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_sheets, m_sDocSheets);

		//  
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_total_sheets_count, t_str);
		if(m_sDocTotalSheets != t_str) apidata.PutAttr(m_doc, m_api->m_doc_mgr.a_doc_total_sheets_count, m_sDocTotalSheets);
*/

		if(0==m_rev)
		{
			m_rev=apidata.CreateInstance(m_api->m_doc_mgr.e_apl_digital_document);
			apidata.PutAttr(m_doc,m_api->m_doc_mgr.a_apl_doc_active,m_rev);
			apidata.PutAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_id,_T("0"));
		}

		apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_id,cst);
		if(cst!=m_doc_rev_id) 
			apidata.PutAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_id,m_doc_rev_id);
		apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_descr,cst);
		if(cst!=m_doc_rev_descr) 
			apidata.PutAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_descr,m_doc_rev_descr);

		apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_litera,cst);
		if(cst!=m_litera) 
			apidata.PutAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_litera,m_litera);

		apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_format,cst);
		if(cst!=m_format) 
			apidata.PutAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_format,m_format);

		apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_label,cst);
		if(cst!=m_label) 
			apidata.PutAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_label,m_label);

		apidata.GetAttr(m_rev, m_api->m_doc_mgr.a_apl_doc_rev_sheets, t_str);
		if(t_str != m_sOfList) apidata.PutAttr(m_rev, m_api->m_doc_mgr.a_apl_doc_rev_sheets, m_sOfList);

		apidata.GetAttr(m_rev, m_api->m_doc_mgr.a_apl_doc_rev_total_sheets_count_a4, t_str);
		if(t_str != m_sOfListsA4) apidata.PutAttr(m_rev, m_api->m_doc_mgr.a_apl_doc_rev_total_sheets_count_a4, m_sOfListsA4);

		apidata.GetAttr(m_rev, m_api->m_doc_mgr.a_apl_doc_rev_total_sheets, t_str);
		if(m_format==_T("*"))
		{
			CString buf;
			SMapListDescr* list_descr=0;
			m_sOfLists = _T("");
			for(i=0;i<m_list_num_lists.Size;i++)
			{
				list_descr = m_list_num_lists[i];
				if(list_descr==0) continue;
				if(list_descr->count==0) continue; //   ,     
				if(m_sOfLists!=_T(""))m_sOfLists+=_T(",");
				buf.Format(_T("A%i=%i*%i"),list_descr->format,list_descr->count,list_descr->multipl); // A - ,    InsertFormats()
				m_sOfLists+=buf;
			}
			//                putattr
			//     OnOK      
			m_of_lists.SetWindowText(m_sOfLists);		
		}
		if(t_str != m_sOfLists) apidata.PutAttr(m_rev, m_api->m_doc_mgr.a_apl_doc_rev_total_sheets, m_sOfLists);


		apidata.GetAttr(m_rev, m_api->m_doc_mgr.a_apl_doc_rev_src_date, t_str);
		if (t_str!= m_sRevDate) apidata.PutAttr(m_rev, m_api->m_doc_mgr.a_apl_doc_rev_src_date, m_sRevDate);


		for(i=0;i<m_Tab.GetItemCount();i++)
		{
			m_Tab.GetTabView(i,pwnd);
			if(pwnd!=NULL)
				if(pwnd->IsKindOf(RUNTIME_CLASS(CaplAccessView)))
				{
					pAccView=(CaplAccessView*)pwnd;
					pAccView->GetAccessString(m_csAccessString);
				}
		}
	}

	return TRUE;
}

BOOL CDocCreateDlg::InitViews(void)
{
	CaplCharactView*	pCharView	=NULL;
	CaplApprovalView*	pApprView	=NULL;
	CaplDocsView*		pDocsView	=NULL;
	CaplAccessView*		pAccView	=NULL;
	CaplEntryView*		pEntryView	=NULL;

	CWnd*				pWnd		=NULL;

	CArray<int,int>		caExcludes;

	CRect				rt;

	DWORD				dwStyles=WS_CHILD|WS_BORDER;

	CaplInstance*		ciDoc=m_doc;
	CaplInstance*		ciRev=m_rev;

	m_Tab.SetImageList(aplGetTabCtrlImageList());

	m_Tab.InsertItem(0, APL_T(""),0);
	m_Tab.AddTab(0,NULL);	
	m_Tab.SetCurSel(0);

//	if(NULL==m_doc)
//	{
//		ChangeViewBtnsState(TRUE,TRUE);
//		return TRUE;
//	}

	caExcludes.Add(IDC_ST_NAME);
	caExcludes.Add(IDC_B_PROPS_ADD);
	caExcludes.Add(IDC_B_PROPS_DEL);
	caExcludes.Add(IDC_B_PROPS_PROPS);
	m_Tab.AddExcludeIDs(caExcludes);

	//pWnd=GetDlgItem(IDC_T_VIEW_FRAME);
	//pWnd->GetClientRect(rt);
	//pWnd->ClientToScreen(rt);
	m_Tab.GetWindowRect(rt);
	rt.DeflateRect(8,30,8,8);
	ScreenToClient(rt);

	m_nEntryTabPos = 1;

	//if(NULL==m_doc)
	//	m_nEntryTabPos = 2;
		
	m_Tab.InsertItem(m_nEntryTabPos, APL_T(""),14);
	pEntryView=(CaplEntryView*)(RUNTIME_CLASS(CaplEntryView)->CreateObject());
	pEntryView->Create(NULL,NULL,dwStyles,rt,this,0);
	pEntryView->m_inst=ciRev;
	pEntryView->m_api=m_api;
	pEntryView->m_pParent = this;		
	
	pEntryView->SetBtnsHandles(&m_bPropsAdd,&m_bPropsDel,&m_bPropsProps);
	pEntryView->OnInitialUpdate();
	
	m_Tab.AddTab(m_nEntryTabPos,pEntryView);
	AddAnchor(pEntryView->m_hWnd,TOP_LEFT,BOTTOM_RIGHT);		
	
	m_pEntryView = pEntryView;	
	
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

	if(NULL!=m_doc)
	{	
		m_Tab.InsertItem(m_nEntryTabPos+1, APL_T(" "),3);
		pApprView=(CaplApprovalView*)(RUNTIME_CLASS(CaplApprovalView)->CreateObject());
		pApprView->Create(NULL,NULL,dwStyles,rt,this,0);
		pApprView->m_inst=ciRev;
		pApprView->m_api=m_api;

		pApprView->SetBtnsHandles(&m_bPropsAdd,&m_bPropsDel,&m_bPropsProps);
		pApprView->OnInitialUpdate();
		m_Tab.AddTab(m_nEntryTabPos+1,pApprView);
		AddAnchor(pApprView->m_hWnd,TOP_LEFT,BOTTOM_RIGHT);

		m_Tab.InsertItem(m_nEntryTabPos+2, APL_T(""),1);
		pCharView=(CaplCharactView*)(RUNTIME_CLASS(CaplCharactView)->CreateObject());
		pCharView->Create(NULL,NULL,dwStyles,rt,this,0);
		pCharView->m_inst=ciDoc;
		pCharView->m_api=m_api;

		pCharView->SetBtnsHandles(&m_bPropsAdd,&m_bPropsDel,&m_bPropsProps);
		pCharView->OnInitialUpdate();
		m_Tab.AddTab(m_nEntryTabPos+2,pCharView);
		AddAnchor(pCharView->m_hWnd,TOP_LEFT,BOTTOM_RIGHT);

		m_Tab.InsertItem(m_nEntryTabPos+3, APL_T(""),2);
		pDocsView=(CaplDocsView*)(RUNTIME_CLASS(CaplDocsView)->CreateObject());
		pDocsView->Create(NULL,NULL,dwStyles,rt,this,0);
		pDocsView->m_inst=ciDoc;
		pDocsView->m_api=m_api;

		pDocsView->SetBtnsHandles(&m_bPropsAdd,&m_bPropsDel,&m_bPropsProps);
		pDocsView->OnInitialUpdate();
		m_Tab.AddTab(m_nEntryTabPos+3,pDocsView);
		AddAnchor(pDocsView->m_hWnd,TOP_LEFT,BOTTOM_RIGHT);		
	}

	if(NULL==m_doc)
		m_Tab.InsertItem(2, APL_T(""),17);
	else
		m_Tab.InsertItem(5, APL_T(""),17);

	pAccView=(CaplAccessView*)(RUNTIME_CLASS(CaplAccessView)->CreateObject());
	pAccView->Create(NULL,NULL,dwStyles|LVS_NOSORTHEADER,rt,this,0);
	pAccView->m_inst=ciDoc;
	pAccView->m_api=m_api;

	pAccView->SetBtnsHandles(&m_bPropsAdd,&m_bPropsDel,&m_bPropsProps);
	pAccView->OnInitialUpdate();
	if(NULL==m_doc)
	{
		CString	csAccPatName;

		m_Tab.AddTab(2,pAccView);
		if(true==m_api->m_doc_mgr.m_AutoUsurpire)
			if(TRUE==m_api->m_options_mgr.GetDefTmplName(m_api->m_doc_mgr.e_apl_doc,csAccPatName))
				pAccView->SetDefaultTemplate(csAccPatName);
	}
	else
		m_Tab.AddTab(5,pAccView);

	AddAnchor(pAccView->m_hWnd,TOP_LEFT,BOTTOM_RIGHT);	

	//   
	if(pEntryView)
	{
		pEntryView->InitView();
		m_pEntryView->CreateEditBox();	//  CEdit  
	}

	return TRUE;
}

void CDocCreateDlg::ChangeViewBtnsState(BOOL bDis,BOOL bHide)
{
	CWnd*	pwnd	=NULL;

	int		iIDs[]={IDC_B_PROPS_ADD,IDC_B_PROPS_DEL,IDC_B_PROPS_PROPS};
	int		iShow=SW_SHOW;
	int		i;

	if(TRUE==bHide)
		iShow=SW_HIDE;

	for(i=0;i<sizeof(iIDs)/sizeof(int);i++)
	{
		pwnd=GetDlgItem(iIDs[i]);
		pwnd->EnableWindow(bDis);
		pwnd->ShowWindow(iShow);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CDocCreateDlg message handlers

void CDocCreateDlg::OnBrowseFile() 
{
	CString buf;
	m_doc_rev_file_ctrl.GetWindowText(buf);
	CFileDialog dlg(TRUE,0,LPCTSTR(buf),OFN_FILEMUSTEXIST|OFN_HIDEREADONLY,
		_T("All Files (*.*)|*.*||"));
	if(dlg.DoModal()!=IDOK) return;
	m_doc_rev_file_ctrl.SetWindowText(dlg.GetPathName());

	long size=-1;
	CFileStatus status;
	if(CFile::GetStatus(dlg.GetPathName(),status)) size=(long)status.m_size;
	if(size>=0) FormatFileSize(size); 
	else m_file_size_str=_T("");

	m_file_size_ctrl.SetWindowText(m_file_size_str);
}
//***************************************************************************
void CDocCreateDlg::InsertFormats()
{
	m_format_ctrl.ResetContent();
	m_format_ctrl.AddString(_T(""));

	bool bInserted=false;

	if(m_dt!=0)
	{
		int i;
		CString buf;
		aplExtent enties;
		apidata.GetAttr(m_dt,m_api->m_doc_mgr.a_dt_entries,enties);
		for(i=0;i<enties.GetSize();i++)
		{
			CaplInstance *entry;
			apidata.GetAttr(enties[i],m_api->m_doc_mgr.a_dt_entry_entry,entry);
			if(0==entry) continue;
			apidata.GetAttr(entry,m_api->m_doc_mgr.a_entry_card_field,buf);
			buf.MakeLower();
			if(buf==APL_T(""))
			{
				CaplAggr values;
				apidata.GetAttr(entry,m_api->m_doc_mgr.a_entry_val,values);
				int j;
				for(j=0;j<values.GetSize();j++)
				{
					bInserted=true;
					values.GetByIndex(j,buf);
					m_format_ctrl.AddString(buf);
				}
				break;
			}
		}
	}

	if(!bInserted)
	{
		
		m_format_ctrl.AddString(_T("*"));
		m_format_ctrl.AddString(_T("A0"));
		m_format_ctrl.AddString(_T("A1"));
		m_format_ctrl.AddString(_T("A2"));
		m_format_ctrl.AddString(_T("A3"));
		m_format_ctrl.AddString(_T("A4"));
		m_format_ctrl.AddString(_T("A5"));
		m_format_ctrl.AddString(_T("-"));
	}

}

//***************************************************************************

BOOL CDocCreateDlg::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();
	if(m_api==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));

	CString buf;

	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   
	ShowSizeGrip(FALSE);

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	m_bPropsAdd.SetIcon(GetAplStdIco16(APLSTDICO_PLUS));
	m_bPropsAdd.SetFlat(FALSE);
	m_bPropsDel.SetIcon(GetAplStdIco16(APLSTDICO_MINUS));
	m_bPropsDel.SetFlat(FALSE);
	m_bPropsProps.SetIcon(GetAplTableIco(APL_TABLE_PROP));
	m_bPropsProps.SetFlat(FALSE);

	m_view_btn.SetIcon(GetAplTableIco(APL_TABLE_VIEW));
	m_view_btn.SetFlat(FALSE); 

	COleDateTime odt_null; odt_null.SetStatus(COleDateTime::null);
	m_doc_date_ctrl.SetTime(odt_null);
	m_doc_date_treb_ctrl.SetTime(odt_null);
	m_doc_date_isp_plan_ctrl.SetTime(odt_null);
	m_doc_date_isp_fact_ctrl.SetTime(odt_null);

	m_dkvd.ResetContent();
	m_dkvd.InsertString(0,APL_T(""));
	m_dkvd.InsertString(1,APL_T("2D"));
	m_dkvd.InsertString(2,APL_T("3D"));
	m_dkvd.InsertString(3,APL_T(""));
	m_dkvd.InsertString(4,APL_T(""));
	m_dkvd.InsertString(5,APL_T(""));

	 //;0 - ;1 - ;2 - ;3 - ;4 - ;
	 m_kdvzohi.InsertString(0,_T(""));
	 m_kdvzohi.InsertString(1,APL_T("0 - "));
	 m_kdvzohi.InsertString(2,APL_T("1 - "));
	 m_kdvzohi.InsertString(3,APL_T("2 - "));
	 m_kdvzohi.InsertString(4,APL_T("3 - "));
	 m_kdvzohi.InsertString(5,APL_T("4 - "));

	 //;;;
	 m_doc_srocn_ctrl.InsertString(0,_T(""));
	 m_doc_srocn_ctrl.InsertString(1,APL_T(""));
	 m_doc_srocn_ctrl.InsertString(2,APL_T(""));
	 m_doc_srocn_ctrl.InsertString(3,APL_T(""));


	 // !!!      XML,   
	 // ;T;;O1;;;1;;;
	 m_litera_ctrl.ResetContent();
	 m_litera_ctrl.InsertString(0,_T(""));
	 m_litera_ctrl.InsertString(1,_T(""));
	 m_litera_ctrl.InsertString(2,_T("T"));
	 m_litera_ctrl.InsertString(3,_T(""));
	 m_litera_ctrl.InsertString(4,_T("O1"));
	 m_litera_ctrl.InsertString(5,_T(""));
	 m_litera_ctrl.InsertString(6,_T(""));
	 m_litera_ctrl.InsertString(7,_T("1"));
	 m_litera_ctrl.InsertString(8,_T(""));


	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T(" \\    "),buf,0);
	if(buf!=_T(""))
	{
		CaplInstance *system = m_api->m_classifier_mgr.GetClassifierSystemById(buf,true);
		if(0==system) 
			AfxMessageBox(APL_T("     :\n ' \\    '!!!"));
		else
		{
			int i;
			for (i = m_dkvd.GetCount() - 1; i >= 0; i--) m_dkvd.DeleteString(i);

			aplExtent ext_levels;
			m_api->m_classifier_mgr.LoadSubClassifierLevels(system,ext_levels,true,true);

			for(i=0;i<ext_levels.GetSize();i++)
			{
				CaplInstance *level=ext_levels[i];
				if(0==level) continue;
				if(level->IsDeleted() || level->GetAccessmode()>aplRO) continue;
				m_api->m_data.GetAttr(level,m_api->m_classifier_mgr.a_apl_classifier_level_id,buf);
				m_dkvd.AddString(buf);
			}
		}
	}


	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T(" \\    "),buf,0);
	if(buf!=_T(""))
	{
		if(!m_api->m_appr_mgr.CheckPersonRole(0,buf))
			m_inv_num_ctrl.SetReadOnly();
	}

	m_of_lists.m_parent = this;
	m_lists_a4_ctrl.m_parent = this;

	//  
	LoadEntriesInfo();

	if(m_fItemAttrBuild!=0)
	{
		CString buf;
		//   
		if(m_fItemAttrBuild(true,m_api,m_api->m_doc_mgr.a_doc_id,m_doc,buf,this))  m_doc_id_chg_btn.EnableWindow(TRUE);
		if(m_fItemAttrBuild(true,m_api,m_api->m_doc_mgr.a_doc_name,m_doc,buf,this))  m_doc_name_chg_btn.EnableWindow(TRUE);
	}


	COleDateTime dt;

	{	//  Tab-   
		CRect rectTab,rectCancel;
		m_Tab.GetWindowRect(rectTab);
		m_cancel_btn.GetWindowRect(rectCancel);
		rectTab.bottom=rectCancel.top-5;
		rectTab.right=rectCancel.right;
		ScreenToClient(rectTab);
		m_Tab.MoveWindow(rectTab);
	}

	InitViews();

	if(m_show_contexts==false)
	{
		int cy=55;
		RECT rect1;

		m_cancel_btn.GetWindowRect(&rect1);
		rect1.top-=cy;
		rect1.bottom-=cy;
		ScreenToClient(&rect1);
		m_cancel_btn.MoveWindow(&rect1);

		m_ok_btn.GetWindowRect(&rect1);
		rect1.top-=cy;
		rect1.bottom-=cy;
		ScreenToClient(&rect1);
		m_ok_btn.MoveWindow(&rect1);

		m_view_btn.GetWindowRect(&rect1);
		rect1.top-=cy;
		rect1.bottom-=cy;
		ScreenToClient(&rect1);
		m_view_btn.MoveWindow(&rect1);

		GetWindowRect(&rect1);
		rect1.bottom-=cy;

		CSize sz(rect1.right-rect1.left,rect1.bottom-rect1.top);
		SetMinTrackSize(sz);

		MoveWindow(&rect1);

		m_Tab.GetWindowRect(&rect1);
		ScreenToClient(&rect1);
		rect1.bottom-=cy;
		m_Tab.MoveWindow(&rect1);


		m_context_sel.ShowWindow(SW_HIDE);
		m_context_names.ShowWindow(SW_HIDE);
		m_st_contexts.ShowWindow(SW_HIDE);
		m_doc_rel_src_ctrl.ShowWindow(SW_HIDE);
		m_st_rel_src.ShowWindow(SW_HIDE);

	}
	else
	{
		m_api->m_doc_mgr.PrintItemContextInString(m_rel_contexts,buf);
		m_context_names.SetWindowText(buf);

		if(m_doc_ref_ro)
		{
			m_doc_rel_src_ctrl.SetReadOnly(TRUE);
			m_context_sel.EnableWindow(FALSE);
		}
	}

	m_Tab.InitStates();

	SetAnchors();

	COLORMAP  cm;
	cm.from=RGB(192,192,192);
	cm.to=GetSysColor(COLOR_BTNFACE);

	if(aplGetBitPerPixel(this)>8)
		m_name_bmp.LoadMappedBitmap(IDB_DOC_NAME,0,&cm,1);
	else 
		m_name_bmp.LoadMappedBitmap(IDB_DOC_NAME_16,0,&cm,1);
	
	HBITMAP hBmpOld=m_st_name.SetBitmap(HBITMAP(m_name_bmp));	
	::DeleteObject(hBmpOld);

	if(m_doc_rev_file!=_T(""))
	{
		long size=-1;
		CFileStatus status;
		if(CFile::GetStatus(m_doc_rev_file,status)) size=(long)status.m_size;
		if(size>=0) FormatFileSize(size);
		else m_file_size_str = _T("");
	}
	
	if(m_api==0) return FALSE;
	
	bool bAutent = false, bIncl = false, bGroup=false;
	aplExtent ext;

	InsertFormats();

	if(m_doc==0)
	{
		m_del_from_disk_btn.ShowWindow(SW_SHOW);

		if(m_doc_rev_file!=_T(""))
		{
			if(_T('*')==m_doc_rev_file[0])
			{
				m_doc_rev_file_ctrl.SetReadOnly(TRUE);
				m_browse_file_btn.EnableWindow(FALSE);
			}
		}
	}
	else
	{
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_id,m_doc_id);
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_name,m_doc_name);
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_descr,m_doc_descr);
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_kind,m_dt);

		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_add_dt_code, m_sDkvd);
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_code_depend_desp, m_sKdvzohi);
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_struct_kind, m_sStructKind);
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_authentic, bAutent);	
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_incl_in_doc, bIncl);
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_group, bGroup);
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_part, m_sPart);	


		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_inv_num, buf);
		m_inv_num_ctrl.SetWindowText(buf);

		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_urgency , buf);
		if(buf!=_T(""))
		{
			if(CaplTranslate::IsNeedTranslate()) m_doc_srocn_ctrl.SelectString(-1,CaplTranslate::Translate(buf));
			else m_doc_srocn_ctrl.SelectString(-1,buf);
		}

		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_from, m_doc_po_from);	
		if(0!=m_doc_po_from)
		{
			m_api->m_appr_mgr.GetItemName(m_doc_po_from,buf);
			m_from_ctrl.SetWindowText(buf);
		}
		else m_from_ctrl.SetWindowText(_T(""));

		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_recipients, m_doc_recitients);	
		if(0!=m_doc_recitients.GetSize())
		{
			CString sRecipients;
			int j;
			for(j=0;j<m_doc_recitients.GetSize();j++)
			{
				CaplInstance *po=m_doc_recitients[j];
				if(m_api->m_data.IsKindOf(po,m_api->m_appr_mgr.e_org))
					m_api->m_data.GetAttr(po, m_api->m_appr_mgr.a_org_id, buf);	
				else m_api->m_appr_mgr.GetItemName(po,buf);
				
				if(sRecipients!=_T("")) sRecipients+=_T(", ");
				sRecipients+=buf;
			}
			m_to_ctrl.SetWindowText(sRecipients);
		}
		else m_to_ctrl.SetWindowText(_T("")); 

		CString sDate;
		COleDateTime odt;
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_date, sDate);	
		if(sDate!=_T(""))
		{
			aplString2Date(sDate,odt);
			m_doc_date_ctrl.SetTime(odt);
		}

		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_date_of_execution_required, sDate);	
		if(sDate!=_T(""))
		{
			aplString2Date(sDate,odt);
			m_doc_date_treb_ctrl.SetTime(odt);
		}

		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_of_execution_planned, sDate);	
		if(sDate!=_T(""))
		{
			aplString2Date(sDate,odt);
			m_doc_date_isp_plan_ctrl.SetTime(odt);
		}

		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_of_execution_fact, sDate);	
		if(sDate!=_T(""))
		{
			aplString2Date(sDate,odt);
			m_doc_date_isp_fact_ctrl.SetTime(odt);
		}




//    
/*
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_format, m_sDocFormat);
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_litera, m_sDocLitera);
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_sheets, m_sDocSheets);
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_doc_total_sheets_count, m_sDocTotalSheets);
*/

// 		InsertFormats();
		m_struct_kind.SelectString(-1, m_sStructKind);
		if(!m_sKdvzohi.IsEmpty()) m_kdvzohi.SetCurSel(_atoi(m_sKdvzohi)+1);

		if(bAutent) m_nAutent = 1;
		else m_nAutent = 0;

		if(bIncl) m_nInclude = 1;
		else m_nInclude = 0;

		if(bGroup) m_nGroup = 1;
		else m_nGroup = 0;

		//   
		m_sOldId = m_doc_id;
		m_sOldName = m_doc_name;
		m_sOldDescr = m_doc_descr;
		m_ciOldType = m_dt;
	}

	m_of_list.GetWindowRect(m_rect_of_listB);ScreenToClient(m_rect_of_listB);
	m_statis_of_list.GetWindowRect(m_rect_statis_of_listB);ScreenToClient(m_rect_statis_of_listB);
	m_of_lists.GetWindowRect(m_rect_of_listsB);ScreenToClient(m_rect_of_listsB);

	int delta = 250;
	m_rect_of_listM = m_rect_of_listB;
	m_rect_of_listM.right -= delta;
	m_rect_statis_of_listM = m_rect_statis_of_listB;
	m_rect_statis_of_listM.left -= delta;
	m_rect_statis_of_listM.right -= delta;
	m_rect_of_listsM = m_rect_of_listsB;
	m_rect_of_listsM.left -= delta;

	if(m_rev!=0 && m_rev->GetAccessmode()<=aplRO)
	{
		// ,      (  )
		CaplInstance *ciDoc = NULL, *ciActive = NULL;
		apidata.GetAttr(m_rev, m_api->m_doc_mgr.a_apl_doc_rev_doc, ciDoc);
		if(ciDoc) apidata.GetAttr(ciDoc, m_api->m_doc_mgr.a_apl_doc_active, ciActive);

//    
/*
		if(ciActive && m_rev==ciActive)
		{
			apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_litera, m_sDocLitera);
			apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_format, m_sDocFormat);
			apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_sheets, m_sDocSheets);
			apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_total_sheets, m_sDocTotalSheets);
		}
*/

		apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_id,m_doc_rev_id);
		apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_descr,m_doc_rev_descr);
	
		apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_litera,m_litera);
		apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_format,m_format);
		apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_label,m_label);

		apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_sheets, m_sOfList);
		apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_total_sheets, m_sOfLists);
		apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_total_sheets_count_a4, m_sOfListsA4);

		m_api->m_doc_mgr.GetFullFileName(m_rev,m_doc_rev_file);

		if(TestMultiFormat())
		{
			int pos1=0,pos2,pos3,pos4;
			CString format_str,num_str,multipl_str;
			SMapListDescr* list_descr=0;
			do{
				pos2=m_sOfLists.Find(_T('='),pos1);
				pos3=m_sOfLists.Find(_T('*'),pos1);
				pos4=m_sOfLists.Find(_T(','),pos1);
				if(pos2 > 0)
				{	
					if(pos4==-1) pos4=m_sOfLists.GetLength();
				}
				else break;
				format_str = m_sOfLists.Mid(pos1,pos2-pos1);
				if(pos3==-1 || pos3 > pos4)
				{
					num_str = m_sOfLists.Mid(pos2+1,pos4-pos2-1);
					multipl_str = _T("1");
				}
				else
				{
					num_str = m_sOfLists.Mid(pos2+1,pos3-pos2-1);
					multipl_str = m_sOfLists.Mid(pos3+1,pos4-pos3-1);;
				}
				if(format_str[0]!=_T('A')) // A - ,    InsertFormats()
					break;
				format_str.Remove(_T('A'));
				list_descr = new SMapListDescr(_atoi(format_str),_atoi(num_str),_atoi(multipl_str));
				m_list_num_lists.Add(list_descr);

				pos1=pos4+1;
			}while(pos2 > 0);
			CalcMultiFormatsA4SheetsCount();
		}

		CaplInstance *inst;
		apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_access_form,inst);
		
		__int64 size=-1;

		if(0!=inst)
		{
			if(apidata.IsKindOf(inst,m_api->m_doc_mgr.e_apl_stored_document))
			{
				m_save_to_db=TRUE;
				apidata.NET_GetBlobSize(inst,m_api->m_doc_mgr.a_apl_stored_document_source,size);
			}
			else
			{
				m_save_to_db=FALSE;
				apidata.GetAttr(inst,m_api->m_doc_mgr.a_apl_assigned_document_location_path,buf);
				CFileStatus status;
				if(CFile::GetStatus(buf,status)) size=(long)status.m_size;
			}
		}
		if(size>=0) FormatFileSize(size);	
		else m_file_size_str = _T("");

		m_crc_check_btn.EnableWindow(TRUE);
		int crc;
		apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_crc,crc);
		buf.Format(_T("%08X"),crc);
		m_crc_ctrl.SetWindowText(buf);

		apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_src_date,m_sRevDate);
		aplString2Date(m_sRevDate, m_dt_rev_date);
	}
	//  , ..     ,           
	//if(m_rev && m_rev->GetAccessmode()>aplRW)
	//	m_ok_btn.EnableWindow(FALSE);


	if(m_dt!=0)
	{
		if(m_dt->GetAccessmode()<aplNO)
		{
			CString sDocType;
			apidata.GetAttr(m_dt, m_api->m_doc_mgr.a_dt_pdt, sDocType);
			m_dt_text.SetWindowText(sDocType);
		}
		else
		{
			m_dt_text.SetWindowText( APL_T("!     !"));
		}
	}
		
	if((m_doc!=0)||(m_rev!=0))
	{
		m_doc_rev_file_ctrl.SetReadOnly(TRUE);
		m_browse_file_btn.EnableWindow(FALSE);
		m_save_to_db_ctrl.EnableWindow(FALSE);
		m_set_ro_btn.EnableWindow(FALSE);
	}
	if(m_doc!=0)
	{				
		if(m_doc->GetAccessmode()>=aplRO || m_bWFstateReadOnly)
		{
			m_doc_id_ctrl.SetReadOnly(TRUE);
			m_doc_name_ctrl.SetReadOnly(TRUE);
			m_doc_descr_ctrl.SetReadOnly(TRUE);
			m_doc_type_ctrl.EnableWindow(FALSE);
			m_kdvzohi.EnableWindow(FALSE);
			m_dkvd.EnableWindow(FALSE);
			m_autent.EnableWindow(FALSE);
			m_group_ctrl.EnableWindow(FALSE);

			m_inv_num_ctrl.SetReadOnly();  
			m_sel_fom_ctrl.EnableWindow(FALSE);
			m_sel_to_ctrl.EnableWindow(FALSE);
			m_del_fom_ctrl.EnableWindow(FALSE);

			m_doc_date_ctrl.EnableWindow(FALSE);
			m_doc_date_treb_ctrl.EnableWindow(FALSE);
			m_doc_srocn_ctrl.EnableWindow(FALSE);

			m_doc_date_isp_plan_ctrl.EnableWindow(FALSE);
			m_doc_date_isp_fact_ctrl.EnableWindow(FALSE);

			CWnd*wnd=GetDlgItem(IDC_DOC_PART);
			if(wnd!=0) ((CEdit*)wnd)->SetReadOnly(TRUE);

			wnd=GetDlgItem(IDC_INCLUDE);
			if(wnd!=0) wnd->EnableWindow(FALSE);

			wnd=GetDlgItem(IDC_GROUP);
			if(wnd!=0) wnd->EnableWindow(FALSE);
		}
	}
	if(m_rev!=0)
	{
		if(m_rev->GetAccessmode()>=aplRO || m_bWFstateReadOnly)
		{
			bool bDizableAttr=true;

			if(m_rev->GetAccessmode()<=aplRW)
			{
				int opt_val=0;
				m_api->m_options_mgr.GetOptionValueBN(APL_NO_T(" \\     "),opt_val,0);
				if(opt_val>0) bDizableAttr=false;
			}

			if(bDizableAttr)
			{
				//m_doc_rel_src_ctrl.SetReadOnly(TRUE);
				m_doc_rev_descr_ctrl.SetReadOnly(TRUE);
				m_doc_rev_descr_ctrl.SetReadOnly(TRUE);
				m_label_ctrl.SetReadOnly(TRUE);
				m_format_ctrl.EnableWindow(FALSE);
				m_lists_a4_ctrl.SetReadOnly(TRUE);
				m_litera_ctrl.EnableWindow(FALSE);
				m_of_list.SetReadOnly(TRUE);
				m_of_lists.SetReadOnly(TRUE);
				m_bPropsAdd.EnableWindow(FALSE);
				m_rev_date_ctrl.EnableWindow(FALSE);
				m_lists_select_btn.EnableWindow(FALSE);
			}
		}
	}
	
	//  :       
	int iVal;
	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T(" \\   "), iVal, 0);
	if(0!=iVal)
	{
		m_save_to_db_ctrl.EnableWindow(FALSE);		
		m_save_to_db= TRUE;
	}

	UpdateData(FALSE);
	KDVZOHIandAut();

	m_prev_format_pos = m_format_ctrl.GetCurSel();
	
	if(m_doc_id!=_T("")) m_doc_id_ctrl.SetWindowText(m_doc_id);

	if(m_rev!=0) m_view_btn.ShowWindow(SW_SHOW);
	else  m_view_btn.ShowWindow(SW_HIDE);
	
	/*if(m_api->m_bModeIntegration==true)	BringWindowToTop( );*/

	//  
	//     SetWindowPos(&CWnd::wndTop,0,0,0,0,SWP_SHOWWINDOW|SWP_NOMOVE|SWP_NOSIZE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
//***************************************************************************
void CDocCreateDlg::FormatFileSize(__int64 size)
{
	m_file_size_str.Format(_T("%I64i"),size);

	//    4 555 631 343
	int nPos = m_file_size_str.GetLength(), nX3 = 1;
	while(nPos >= 0)
	{
		if( (nX3/3)*3 == nX3) m_file_size_str.Insert(nPos-1, _T(' '));
		nX3++; nPos--;
	}

	m_file_size_str.TrimLeft(_T(' '));
	m_file_size_str +=  APL_T(" ");
}

bool CDocCreateDlg::LoadEntriesInfo()
{
	/*   ATTACH DOC_MGR
	long dID = aplStartWaitDlg( APL_T(" ..."));

	bool bResult;
	aplExtent aeEntries;
	CString sSql, t_str;

	sSql = _T("SELECT Ext_1 FROM Ext_1 { apl_document_entry.name LIKE '' } END_SELECT");
	bResult = m_api->m_data.NET_QueryEditParse(sSql, false, &t_str);
	if(bResult)
	{
		m_api->m_data.NET_QueryExecute(aeEntries);
		m_api->LoadExtentInfo(aeEntries);	
	}

	aplEndWaitDlg(dID);
	return bResult;
	*/

	return true;
}
//***************************************************************************
void CDocCreateDlg::CutSpaceBeforCode(int nFindPos)
{
	//     
	if(nFindPos-1>= 0)
	{
		while(m_doc_id[nFindPos-1]==_T(' '))
		{
			m_doc_id.Delete(nFindPos-1);
			nFindPos--;

			if(nFindPos-1< 0) break; 
		}		
	}
}



void CDocCreateDlg::OnOK() 
{
	CString sBuf;
	int doc_id=0, doc_rev=0, dt=0;
	if(0!=m_doc) doc_id=m_doc->GetId();
	if(0!=m_rev) doc_rev=m_rev->GetId();
	if(0!=m_dt) dt=m_dt->GetId();
	sBuf.Format(_T("\n\nCDocCreateDlg::OnOK() Start  doc = %i  rev = %i  dt = %i"), doc_id, doc_rev, dt);

	m_api->m_data.WriteLocalLog(aplLogModeParanoid, sBuf);
	//       
	if(m_Tab.GetCurSel() == m_nEntryTabPos)
		m_pEntryView->HideEditBox();

	m_api->m_data.WriteLocalLog(aplLogModeParanoid,_T("CDocCreateDlg::OnOK() 2"));

	//   
	UpdateData(TRUE);

	m_api->m_data.WriteLocalLog(aplLogModeParanoid,_T("CDocCreateDlg::OnOK() 3"));

	//     
	/*if(m_dt)
	{
		CString sCode;
		m_api->m_data.GetAttr(m_dt, m_api->m_doc_mgr.a_dt_id, sCode);		
		CutSpaceBeforCode(m_doc_id.Find(sCode));
	}*/

	int b_NoCreateWithoutType=0;
	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T(" \\    "), b_NoCreateWithoutType, 0);
	if(b_NoCreateWithoutType==1 && 0==m_dt)
	{
		AfxMessageBox( APL_T("   "),MB_OK|MB_ICONSTOP);
		m_api->m_data.WriteLocalLog(aplLogModeParanoid, _T("CDocCreateDlg::OnOK() Exit 1"));
		return;
	}

	m_api->m_data.WriteLocalLog(aplLogModeParanoid, _T("CDocCreateDlg::OnOK() CheckFileFormat Start"));

	//  
	if(0!=m_dt && m_dt->GetAccessmode()!=aplNO)
	{
		CString fname,formats,ext;
		m_doc_rev_file_ctrl.GetWindowText(fname);
		if(fname!=_T("") && fname[0]!=_T('*'))
		{
			m_api->m_data.GetAttr(m_dt,m_api->m_doc_mgr.a_dt_auth_formats, formats);
			if(formats!=_T(""))
			{
				formats.MakeLower();
				int i=fname.ReverseFind(_T('.'));
				if(i>1) 
				{
					ext=fname.Right(fname.GetLength()-i-1);
					if(ext!=_T(""))
					{
						ext.MakeLower();
						if(formats.Find(ext)<0) 
						{
							ext= APL_T("  !\n\n : ");
							ext+=formats;
							AfxMessageBox(ext,MB_OK|MB_ICONSTOP);
							m_api->m_data.WriteLocalLog(aplLogModeParanoid, _T("CDocCreateDlg::OnOK() CheckFileFormat Exit"));
							return;
						}
					}
				}
			}
		}
	}

	m_api->m_data.WriteLocalLog(aplLogModeParanoid, _T("CDocCreateDlg::OnOK() CheckFileFormat End"));

	//   


	if(m_rev==0  && (TRUE==m_save_to_db) )  //  "    "    
	{
		m_api->m_data.WriteLocalLog(aplLogModeParanoid, _T("CDocCreateDlg::OnOK() CheckFileSize Start"));

		int iMaxFileSize=0;
		m_api->m_options_mgr.GetOptionValueBN( APL_NO_T(" \\   "), iMaxFileSize, (int)0);
		if(iMaxFileSize>0)
		{
			CString fname;
			m_doc_rev_file_ctrl.GetWindowText(fname);
			if(fname!=_T("") && fname[0]!=_T('*'))
			{
				CFileStatus rStatus;
				if(CFile::GetStatus(fname,rStatus))
				{
					if(rStatus.m_size>iMaxFileSize)
					{
						bool bEnableCreate=false;
						CString sRole;

						m_api->m_options_mgr.GetOptionValueBN( APL_NO_T(" \\     "), sRole, _T(""));
						if(sRole!=_T("")){if(m_api->m_appr_mgr.CheckPersonRole(0,sRole)) bEnableCreate=true;}

						if(!bEnableCreate)
						{
							CString buf;
							buf.Format( APL_T("   (%i)   (%i)!\n\n    ."),
								(int)rStatus.m_size,iMaxFileSize);
							AfxMessageBox(buf,MB_OK|MB_ICONSTOP);
							m_api->m_data.WriteLocalLog(aplLogModeParanoid, _T("CDocCreateDlg::OnOK() CheckFileSize Exit"));
							return;
						}
					}
				}
			}
		}

		m_api->m_data.WriteLocalLog(aplLogModeParanoid, _T("CDocCreateDlg::OnOK() CheckFileSize End"));
	}

	//   
	if(m_sKdvzohi == _T(" ")) m_sKdvzohi=_T("");

	//    
	CaplInstance *cit = NULL;
	//UpdateData(TRUE);


	m_api->m_data.WriteLocalLog(aplLogModeParanoid, _T("CDocCreateDlg::OnOK() ChangeDocEntries Start"));
	if(FALSE==ChangeDocEntries(true))
	{
		m_api->m_data.WriteLocalLog(aplLogModeParanoid, _T("CDocCreateDlg::OnOK() ChangeDocEntries Exit"));
		return;
	}
	m_api->m_data.WriteLocalLog(aplLogModeParanoid, _T("CDocCreateDlg::OnOK() ChangeDocEntries End"));

	m_api->m_data.WriteLocalLog(aplLogModeParanoid, _T("CDocCreateDlg::OnOK() ValidateData Start"));
	if(FALSE==ValidateData())
	{
		m_api->m_data.WriteLocalLog(aplLogModeParanoid, _T("CDocCreateDlg::OnOK() ValidateData Exit"));
		return;
	}
	m_api->m_data.WriteLocalLog(aplLogModeParanoid, _T("CDocCreateDlg::OnOK() ValidateData End"));


	m_api->m_data.WriteLocalLog(aplLogModeParanoid, _T("CDocCreateDlg::OnOK() ValidateData Start"));
	if(FALSE==SaveData())
	{
		m_api->m_data.WriteLocalLog(aplLogModeParanoid, _T("CDocCreateDlg::OnOK() ValidateData Exit"));
		return;		
	}
	m_api->m_data.WriteLocalLog(aplLogModeParanoid, _T("CDocCreateDlg::OnOK() ValidateData End"));

	m_api->m_data.WriteLocalLog(aplLogModeParanoid, _T("CDocCreateDlg::OnOK() End\n\n"));

	CaplResizableDialog::OnOK();
}

bool CDocCreateDlg::CheckEntry(aplExtent &aeEntriesVal, CaplInstance *ciRev)
{
	/*
	bool bChange = false;
	CString t_str, sValue, sCardFiled;
	CaplInstance *cit = NULL;

	for(int i=0; i<aeEntriesVal.GetSize(); i++)
	{
		bChange = false;
			
		apidata.GetAttr(aeEntriesVal[i], m_api->m_doc_mgr.a_doc_entry_val_entry, cit);
		if(!cit) continue;

		apidata.GetAttr(cit, m_api->m_doc_mgr.a_entry_card_field, t_str);
		sCardFiled = t_str; t_str.MakeLower();
		
		if(!t_str.Compare(APL_T("")) && m_MassCheck.bCheckId)
		{
			m_MassCheck.bCheckId = false;
			bChange = true;
			sValue = m_doc_id;			
		}
		else if(!t_str.Compare(APL_T("")) && m_MassCheck.bCheckName)
		{
			m_MassCheck.bCheckName = false;
			bChange = true;	
			sValue = m_doc_name;			
		}
		else if(!t_str.Compare(APL_T(" ")) && m_MassCheck.bCheckType) 
		{
			m_MassCheck.bCheckType = false;
			bChange = true;
			m_dt_text.GetWindowText(sValue);			
		}
		else if(!t_str.Compare(APL_T("  ")) && m_MassCheck.bCheckCodeType) 
		{
			m_MassCheck.bCheckCodeType = false;
			bChange = true;
			m_api->m_data.GetAttr(m_dt, m_api->m_doc_mgr.a_dt_id, sValue);
		}
		else if(!t_str.Compare(APL_T("")) && m_MassCheck.bCheckLiter) 
		{			
			m_MassCheck.bCheckLiter = false;
			bChange = true;
			m_litera_ctrl.GetWindowText(sValue);			
		}
		else if(!t_str.Compare(APL_T("")) && m_MassCheck.bCheckFormat) 
		{					
			m_MassCheck.bCheckFormat = false;
			bChange = true;
			m_format_ctrl.GetWindowText(sValue);			
		}	
		else if(!t_str.Compare(APL_T(" ")) && m_MassCheck.bCheckFileName)
		{
			m_MassCheck.bCheckFileName = false;
			bChange = true;
			m_doc_rev_file_ctrl.GetWindowText(sValue);
		}
		else if(!t_str.Compare(APL_T(" ")) && m_MassCheck.bCheckVer)
		{
			m_MassCheck.bCheckVer = false;
			bChange = true;
			m_edit_rev_id.GetWindowText(sValue);
		}
		else if(!t_str.Compare(APL_T("  ")) && m_MassCheck.bCheckList) 
		{
			m_MassCheck.bCheckList = false;
			bChange = true;
			
			apidata.GetAttr(aeEntriesVal[i], m_api->m_doc_mgr.a_doc_entry_val_val, sValue);			
		}
		else if(!t_str.Compare(APL_T("   ")) && m_MassCheck.bCheckLists) 
		{
			m_MassCheck.bCheckLists = false;
			bChange = true;
			
			apidata.GetAttr(aeEntriesVal[i], m_api->m_doc_mgr.a_doc_entry_val_val, sValue);			
		}
		
		//       , 
		if(t_str.IsEmpty()) continue;
		
		//   
		if(bChange)
		{
			PutEntryVal(aeEntriesVal[i], ciRev, sValue, sCardFiled, cit);
		}
	}
	*/

	return true;
}

BOOL CDocCreateDlg::ChangeDocEntries(bool bOkFunc)
{	
	bool bAccessDoc = true, bAccessRev = true;
	CaplInstance *ciActiveDocRev = NULL;
	CString sValue, sFileName, sRevName, sDTCode,sInvNum;

	aplDate2String(m_dt_rev_date, m_sRevDate);

	//CaplInstance *ciEntryVal = NULL, *ciEntryLastVal = NULL;

	m_dt_text.GetWindowText(sValue);
	m_doc_rev_file_ctrl.GetWindowText(sFileName);
	m_edit_rev_id.GetWindowText(sRevName);
	m_inv_num_ctrl.GetWindowText(sInvNum);

	if(m_dt!=0 && m_dt->GetAccessmode()!=aplNO)	m_api->m_data.GetAttr(m_dt, m_api->m_doc_mgr.a_dt_id, sDTCode);
	
	if(m_doc)
		if(m_doc->GetAccessmode()>=aplRO)
			bAccessDoc = false;

	if(m_rev)
		if(m_rev->GetAccessmode()>=aplRO)
			bAccessRev = false;

	//  ,    
	//if(/*m_doc && */m_doc->GetAccessmode()<aplRO)
	if(bAccessDoc && bAccessRev)
	{
		CreateEntryVal( APL_NO_T(""), m_doc_id);
		CreateEntryVal( APL_NO_T(""), m_doc_name);
		CreateEntryVal( APL_NO_T(" "), sValue);
		CreateEntryVal( APL_NO_T(" "), sFileName);
		CreateEntryVal( APL_NO_T("  "), sDTCode);		
		CreateEntryVal( APL_NO_T("   "), m_sDkvd);
		CreateEntryVal( APL_NO_T("      "), !m_sKdvzohi.IsEmpty() ? m_sKdvzohi.GetAt(0) : m_sKdvzohi);
		CreateEntryVal( APL_NO_T(" "), sInvNum);
		CreateEntryVal( APL_NO_T("  "), m_autent.GetCheck()?_T("1"):_T("0"));
	}

	/***************************************************************************************************/
	/***************************************************************************************************/
	/***************************************************************************************************/

	//  ,     
	if(bAccessRev)
	{		
		CreateEntryVal( APL_T(""), m_litera);
		CreateEntryVal( APL_T(""), m_format);
		CreateEntryVal( APL_T(""), m_label);
		CreateEntryVal( APL_T(" "), sRevName);
		CreateEntryVal( APL_T(""), m_sOfList);
		CreateEntryVal( APL_T(""), m_sOfLists);
		CreateEntryVal( APL_T(" "), m_sRevDate);
	}
	
	m_api->SaveChanges();
	return TRUE;
}

CaplInstance* CDocCreateDlg::GetLastEntryVal(CaplInstance *ciRev, CString sCardField)
{
	//   ,     sCardField
	aplExtent ext;
	CString t_str;
	CaplInstance *cit = NULL, *ciLastValue = NULL;

	apidata.GetAttr(ciRev, m_api->m_doc_mgr.a_apl_doc_rev_entries, ext);

	for(int i=0; i<ext.GetSize(); i++)
	{
		apidata.GetAttr(ext[i], m_api->m_doc_mgr.a_doc_entry_val_entry, cit);
		if(!cit) continue;

		apidata.GetAttr(cit, m_api->m_doc_mgr.a_entry_card_field, t_str);

		if(!t_str.CompareNoCase(sCardField))
			ciLastValue = ext[i];
	}

	return ciLastValue;
}

CaplInstance* CDocCreateDlg::PutEntryVal(CaplInstance *ciRev, CaplInstance *ciEntryVal, CString sValue, CString sCardField, CaplInstance *ciEntry)
{
	CaplInstance *ciResultEntryVal = NULL;

	bool bStored = true;
	if(ciEntryVal) apidata.GetAttr(ciEntryVal, m_api->m_doc_mgr.a_doc_entry_val_stored, bStored);

	if(bStored == false)	//  
	{
		apidata.PutAttr(ciEntryVal, m_api->m_doc_mgr.a_doc_entry_val_val, sValue);
		ciResultEntryVal = ciEntryVal;
	}
	else					//  
	{
		CString sTemp;
		CaplInstance *ciEntryLastVal = NULL;

		//   ,   apl_document_rev_entry  
		if(m_rev) 
		{
			ciEntryLastVal = GetLastEntryVal(ciRev, sCardField);
			if(ciEntryLastVal) 
			{
				apidata.GetAttr(ciEntryLastVal, m_api->m_doc_mgr.a_doc_entry_val_val, sTemp);
				if(!sTemp.Compare(sValue)) return NULL;
			}
		}

		//   
		aplExtent ext;
		ciResultEntryVal = m_api->m_data.CreateInstance(m_api->m_doc_mgr.e_doc_entry_val);				

		apidata.PutAttr(ciResultEntryVal, m_api->m_doc_mgr.a_doc_entry_val_stored, ciEntryVal?true:false);
		apidata.PutAttr(ciResultEntryVal, m_api->m_doc_mgr.a_doc_entry_val_val, sValue);
		apidata.PutAttr(ciResultEntryVal, m_api->m_doc_mgr.a_doc_entry_val_prev, ciEntryLastVal);
		apidata.PutAttr(ciResultEntryVal, m_api->m_doc_mgr.a_doc_entry_val_entry, ciEntry);

		if(ciRev)
		{
			apidata.GetAttr(ciRev, m_api->m_doc_mgr.a_apl_doc_rev_entries, ext);
			ext.Add(ciResultEntryVal);
			apidata.PutAttr(ciRev, m_api->m_doc_mgr.a_apl_doc_rev_entries, ext);
		}
		else
		{
			m_aeEntryToCreate.Add(ciResultEntryVal);
		}
	}


	return ciResultEntryVal;
}

void CDocCreateDlg::CreateEntryVal(CString sCardField, CString sValue)
{
	CString t_str, sName;
	CaplInstance *cit = NULL, *ciRev = 0;
	aplExtent ext, aeEntriesVal, aeDTEntry;
	CaplInstance *ciEntry = NULL, *ciDocRevAct = NULL, *ciEtalonEntry = NULL, *ciEntryVal = NULL;	

	if(m_dt == NULL) return;
	if(m_dt->GetAccessmode()==aplNO) return;
	sCardField.MakeLower();
	apidata.GetAttr(m_dt, m_api->m_doc_mgr.a_dt_entries, aeDTEntry);
	
	// ,    ,         
	m_api->LoadExtentInfo(aeDTEntry);
	for(int i=0; i<aeDTEntry.GetSize(); i++)
	{
		apidata.GetAttr(aeDTEntry[i], m_api->m_doc_mgr.a_dt_entry_entry, ciEtalonEntry);
		if(!ciEtalonEntry) continue;
		
		apidata.GetAttr(ciEtalonEntry, m_api->m_doc_mgr.a_entry_card_field, t_str);
		t_str.MakeLower();

		if(!t_str.CompareNoCase(sCardField))
		{
			ciEntryVal = NULL;

			//    ,  ,    ,   
			if(m_rev) 
			{
				apidata.GetAttr(ciEtalonEntry, m_api->m_doc_mgr.a_entry_name, sName);
				sName.MakeLower();

				if(m_api->m_doc_mgr.EntryForDocumentVersion(ciEtalonEntry))
				{
					m_api->m_data.GetAttr(m_rev, m_api->m_doc_mgr.a_apl_doc_rev_entries, aeEntriesVal);
					ciRev = m_rev;
				}
				else
				{
					m_api->m_data.GetAttr(m_rev, m_api->m_doc_mgr.a_apl_doc_rev_doc, ciDocRevAct);
					m_api->m_data.GetAttr(ciDocRevAct, m_api->m_doc_mgr.a_apl_doc_active, ciDocRevAct);

					m_api->m_data.GetAttr(ciDocRevAct, m_api->m_doc_mgr.a_apl_doc_rev_entries, aeEntriesVal);
					ciRev = ciDocRevAct;
				}
			}
			else
			{
				aeEntriesVal.Append(m_aeEntryToCreate);
			}

			for(int i=0; i<aeEntriesVal.GetSize(); i++)
			{
				if(!aeEntriesVal[i]) continue;
				if(!aeEntriesVal[i]->GetType()) continue;

				apidata.GetAttr(aeEntriesVal[i], m_api->m_doc_mgr.a_doc_entry_val_entry, ciEntry);

				if(!ciEntry) continue;
				if(ciEntry != ciEtalonEntry) continue;

				apidata.GetAttr(ciEntry, m_api->m_doc_mgr.a_entry_card_field, t_str);
				t_str.MakeLower();
				if(t_str.CompareNoCase(sCardField)) continue;

				//  ,  
				ciEntryVal = PutEntryVal(ciRev, aeEntriesVal[i], sValue, sCardField, ciEntry);
				break;
			}

			if(!ciEntryVal) PutEntryVal(ciRev, NULL, sValue, sCardField, ciEtalonEntry);
		}
	}
}

void CDocCreateDlg::OnStName() 
{
	CString text,buf;
//	if(((GetKeyState(VK_LMENU) & 0xff00)!=0)&&((GetKeyState(VK_RMENU) & 0xff00)!=0)){
	if(((GetKeyState(VK_LMENU) )!=0)&&((GetKeyState(VK_RMENU) )!=0)){
		text.Format(_T("\n"));
		if(m_doc!=0){buf.Format(_T("m_doc->id %i;\n"),m_doc->GetId());text+=buf;}else{buf.Format(_T("m_doc==0;\n"));}
		if(m_rev!=0){buf.Format(_T("m_rev->id %i;\n"),m_rev->GetId());text+=buf;}else{buf.Format(_T("m_rev==0;\n"));}
		if(m_dt!=0){buf.Format(_T("m_dt->id %i;\n"),m_dt->GetId());text+=buf;}else{buf.Format(_T("m_dt==0;\n"));}

		AfxMessageBox(text);
	}	
}

void CDocCreateDlg::OnSelContext() 
{
	if(m_api->m_doc_mgr.ChangeItemContext(m_rel_contexts))
	{
		CString buf;
		m_api->m_doc_mgr.PrintItemContextInString(m_rel_contexts,buf);
		m_context_names.SetWindowText(buf);
		m_context_changed=true;
	}	
}


void CDocCreateDlg::OnSelDocType() 
{
	UpdateData();

	int i=0;
	CString sOldCode, sNewCode;
	if(m_dt && m_dt->GetAccessmode()!=aplNO) m_api->m_data.GetAttr(m_dt, m_api->m_doc_mgr.a_dt_id, sOldCode);
	

	CaplInstance * inst = m_api->m_doc_mgr.SelectDocType(m_dt);
	if(inst!=NULL)
	{
		//   ,      
		if(!RebuildEntryList(inst)) return;

		CString buf;
		m_dt = inst;
		apidata.GetAttr(m_dt,m_api->m_doc_mgr.a_dt_pdt,buf);
		m_dt_text.SetWindowText(buf);

		//      
		m_api->m_data.GetAttr(inst, m_api->m_doc_mgr.a_dt_id, sNewCode);
		if(sOldCode.IsEmpty()) sOldCode = sNewCode;

		//       
		int nFindPos = m_doc_id.Find(sOldCode); //Find(m_doc_id, sOldCode);
		if(sOldCode.IsEmpty()) nFindPos = -1;

		//       
		if(nFindPos==-1)
		{
			nFindPos = m_doc_id.GetLength() + 1;
			m_doc_id += sNewCode;	
			CutSpaceBeforCode(nFindPos);
		}
		//    
		else if(nFindPos+sOldCode.GetLength() == m_doc_id.GetLength())
		{
			m_doc_id.Replace(sOldCode, sNewCode);			
			CutSpaceBeforCode(nFindPos);		
		}
		//  ,    
		else
		{
			m_doc_id.Replace(sOldCode, sNewCode);			
		}

		InsertFormats();
	}

	UpdateData(FALSE);
}

bool CDocCreateDlg::RebuildEntryList(CaplInstance *ciDocType)
{
	if(ciDocType == NULL) return false;
	if(m_pEntryView == NULL) return true;

	CString sName, t_str;
	aplExtent aeDTEntries, aeCurrValEntries;
	CaplInstance *cit = NULL, *ciActiv = NULL;

	//    

	apidata.GetAttr(ciDocType, m_api->m_doc_mgr.a_dt_entries, aeDTEntries);
	m_api->LoadExtentInfo(aeDTEntries);

	//     

	if(m_doc)
	{
		apidata.GetAttr(m_doc, m_api->m_doc_mgr.a_apl_doc_active, ciActiv);
		apidata.GetAttr(ciActiv, m_api->m_doc_mgr.a_apl_doc_rev_entries, aeCurrValEntries);
	}
	else
	{
		aeCurrValEntries.Append(m_aeEntryToCreate);
	}

	//   ,        ,   

	for(int i=0; i<aeDTEntries.Size; i++)
	{
		apidata.GetAttr(aeDTEntries[i], m_api->m_doc_mgr.a_dt_entry_entry, cit);
		if(!cit) continue;

		if(!cit->attrs) m_api->LoadItemInfo(cit);
		apidata.GetAttr(cit, m_api->m_doc_mgr.a_entry_name, sName);
				
		for(int j=0; j<aeCurrValEntries.Size; j++)
		{
			apidata.GetAttr(aeCurrValEntries[j], m_api->m_doc_mgr.a_doc_entry_val_entry, cit);
			apidata.GetAttr(cit, m_api->m_doc_mgr.a_entry_name, t_str);

			t_str.MakeLower(); sName.MakeLower();
			if(t_str == sName)
			{
				aeCurrValEntries.Remove(j);				 
				break;
			}
		}
	}

	//  - ,         
	// .         

	if(aeCurrValEntries.Size)
	{
		if(AfxMessageBox( APL_T("      ,     . ?"), MB_ICONINFORMATION|MB_YESNO) == IDNO)
		{
			return false;
		}
		else
		{
			for(int i=0; i<aeCurrValEntries.Size; i++)
			{
				if(!m_doc)
				{
					for(int j=0; j<m_aeEntryToCreate.Size; j++)
					{
						if(m_aeEntryToCreate[j] == aeCurrValEntries[i])
						{ 
							m_aeEntryToCreate.Remove(j);
							break;
						}
					}
				}

				apidata.DeleteInstance(aeCurrValEntries[i]);
			}
		}
	}

	return true;
}

void CDocCreateDlg::OnSelchangeTab1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CaplPropsView* pView	=NULL;
	
	BOOL	bDis	=TRUE;
	BOOL	bHide	=FALSE;

	if(0==m_Tab.GetCurSel())
		bDis=FALSE;
//	if(NULL==m_doc)
//		bHide=TRUE;

	ChangeViewBtnsState(bDis,!bDis);

	//    "" (   )
	if(m_Tab.GetCurSel() == m_nEntryTabPos)
	{
		
		UpdateData();

		ChangeViewBtnsState(bDis,bDis);
		ChangeDocEntries(false);
		
		m_pEntryView->LoadData();
		m_pEntryView->FillList();
	}
	else
	{
		//  EditBox        
		m_pEntryView->HideEditBox();
	}

	m_Tab.GetTabView(m_Tab.GetCurSel(),(CWnd*&)pView);
	if(NULL!=pView)
	{
		pView->InitView();		
		pView->ChangeCtrlsState();				
	}	

	if(m_Tab.GetCurSel() == 0) KDVZOHIandAut();
	if(m_bWFstateReadOnly == true) m_bPropsAdd.EnableWindow(FALSE);
		
	*pResult = 0;
}

void CDocCreateDlg::OnBPropsAdd() 
{
	CaplPropsView* pView	=NULL;

	if(0==m_Tab.GetCurSel())
		return;

	m_Tab.GetTabView(m_Tab.GetCurSel(),(CWnd*&)pView);
	pView->OnBAdd();
}

void CDocCreateDlg::OnBPropsDel() 
{
	CaplPropsView* pView	=NULL;

	if(0==m_Tab.GetCurSel())
		return;

	m_Tab.GetTabView(m_Tab.GetCurSel(),(CWnd*&)pView);
	pView->OnBDel();
}

void CDocCreateDlg::OnBPropsProps() 
{
	CaplPropsView* pView	=NULL;

	if(0==m_Tab.GetCurSel())
		return;

	m_Tab.GetTabView(m_Tab.GetCurSel(),(CWnd*&)pView);
	pView->OnBProps();
}

void CDocCreateDlg::OnDocIdChange() 
{
	if(m_fItemAttrBuild==0) return;
	CString buf;
	m_doc_id_ctrl.GetWindowText(buf);
	if(m_fItemAttrBuild(false,m_api,m_api->m_doc_mgr.a_doc_id,m_doc,buf,this)) m_doc_id_ctrl.SetWindowText(buf);
}

void CDocCreateDlg::OnDocNameChange() 
{
	if(m_fItemAttrBuild==0) return;
	CString buf;
	m_doc_name_ctrl.GetWindowText(buf);
	if(m_fItemAttrBuild(false,m_api,m_api->m_doc_mgr.a_doc_name,m_doc,buf,this)) m_doc_name_ctrl.SetWindowText(buf);
}

void CDocCreateDlg::OnCancel() 
{
	if(m_rev == NULL)
	{
		for(int i=0; i<m_aeEntryToCreate.Size; i++)
			apidata.DeleteInstance(m_aeEntryToCreate[i]);
	}

	ChangeDocEntries(true);
	CaplResizableDialog::OnCancel();
}

void CDocCreateDlg::OnStnClickedTDocType()
{
	// TODO: Add your control notification handler code here
}

void CDocCreateDlg::OnEnChangeLabel()
{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CaplResizableDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.

	// TODO:  Add your control notification handler code here
}

void CDocCreateDlg::OnCbnSelchangeKdvzohi()
{
	//   - ,     
	KDVZOHIandAut();
}

void CDocCreateDlg::KDVZOHIandAut()
{
	int nCurSel = m_kdvzohi.GetCurSel();
	if(nCurSel == 3)
	{
		m_autent.SetCheck(FALSE);
		m_autent.ShowWindow(SW_HIDE);				
	}
	else
	{
		m_autent.ShowWindow(SW_SHOW);
	}

	UpdateData();
}


void CDocCreateDlg::OnEnChangeOfList()
{
	//         

	/*
	if(!VerIsActive()) return;
	CString t_str;

	m_of_list.GetWindowText(t_str);
	m_doc_sheets.SetWindowText(t_str);
	*/
}

void CDocCreateDlg::CalcA4SheetsCount()
{
	CString sCount,sA4Count,format_prev=m_format,buf;
	int num=0;
	m_format_ctrl.GetWindowText(m_format);

	//    
	buf=m_format; 	buf.TrimLeft(); buf.TrimRight();
	if(buf!=m_format) {m_format=buf;  m_format_ctrl.SetWindowText(m_format);}

	m_of_lists.GetWindowText(sCount);
	bool to_single = m_format!=_T("*") && format_prev==_T("*");
	bool to_none =  m_format==_T("-") && format_prev!=_T("-");
	SMapListDescr* list_descr=0;
	if(to_single || to_none)
	{
		for(int i=m_list_num_lists.Size-1;i>=0;i--)
		{
			list_descr = m_list_num_lists[i];
			if(list_descr==0)m_list_num_lists.Remove(i);
			if(list_descr->count==0)m_list_num_lists.Remove(i);
		}
		if(sCount !=_T("") )
		{
			if(AfxMessageBox(APL_T("      \n .  ?"),MB_YESNO)==IDNO)
			{
				m_format = format_prev;
				m_format_ctrl.SetCurSel(m_prev_format_pos);
				return;
			}
			if(to_single)
			{
				num=0;
				buf=m_format;
				buf.Remove(_T('A'));
				for(int i=0;i<m_list_num_lists.Size;i++)
				{
					list_descr = m_list_num_lists[i];
					if(list_descr->format==_atoi(buf))
					{
						num = list_descr->count;
					}
				}
				if(num==-1)num=0;
				m_list_num_lists.Clear();
			}
		}
		if(num==0){sCount=_T("");}else{sCount.Format(_T("%i"),num);}
		m_of_lists.SetWindowText(sCount);
	}
	m_prev_format_pos = m_format_ctrl.GetCurSel();

	if(format_prev!=_T("*") && m_format==_T("*"))
	{
		m_list_num_lists.Clear();
		format_prev.Remove(_T('A'));
		list_descr=new SMapListDescr(_atoi(format_prev), _atoi(sCount), 1);
		m_list_num_lists.Add(list_descr);
	}
	if(!TestMultiFormat())
	{
		m_api->m_doc_mgr.CalcA4SheetsCount(m_format,sCount,sA4Count);
		m_lists_a4_ctrl.SetWindowText(sA4Count);
	}
}

bool CDocCreateDlg::TestMultiFormat()
{
	if(m_format==_T("*") || m_format==_T("-"))
	{
		m_of_lists.SetReadOnly(TRUE);
		m_lists_a4_ctrl.SetReadOnly(TRUE);

	}
	else
	{
		m_of_lists.SetReadOnly(FALSE);
		m_lists_a4_ctrl.SetReadOnly(FALSE);
	}
	if(m_format==_T("*"))
	{
		m_lists_select_btn.EnableWindow(TRUE);
		m_of_list.MoveWindow(m_rect_of_listM);
		m_statis_of_list.MoveWindow(m_rect_statis_of_listM);
		m_of_lists.MoveWindow(m_rect_of_listsM);
		return true;
	}
	else
	{
		m_lists_select_btn.EnableWindow(FALSE);
		m_of_list.MoveWindow(m_rect_of_listB);
		m_statis_of_list.MoveWindow(m_rect_statis_of_listB);
		m_of_lists.MoveWindow(m_rect_of_listsB);
	}

	return false;
}

void CDocCreateDlg::OnEnChangeOfLists()
{
	CalcA4SheetsCount();
	//         

	/*
	if(!VerIsActive()) return;
	CString t_str;

	m_of_lists.GetWindowText(t_str);
	m_doc_total_sheets.SetWindowText(t_str);
	*/
}

void CDocCreateDlg::OnCbnEditchangeFormat()
{

	CalcA4SheetsCount();
}


void CDocCreateDlg::OnCbnSelchangedFormat()
{
	//         

	/*
	if(!VerIsActive()) return;
	CString t_str;

	m_format_ctrl.GetWindowText(t_str);
	m_doc_format.SetWindowText(t_str);
	*/
}

void CDocCreateDlg::OnCbnSelchangeFormat()
{
	int i=m_format_ctrl.GetCurSel();
	if(i>=0)
	{
		CString sFormat;
		m_format_ctrl.GetLBText(i,sFormat);
		m_format_ctrl.SetWindowText(sFormat);
	}
	CalcA4SheetsCount();
	//         

	/*
	if(!VerIsActive()) return;
	CString t_str;

	m_format_ctrl.GetLBText(m_format_ctrl.GetCurSel(), t_str);
	m_doc_format.SetWindowText(t_str);		
	*/
}

void CDocCreateDlg::OnEnChangeLitera()
{
	//         

	/*
	if(!VerIsActive()) return;
	CString t_str;

	m_litera_ctrl.GetWindowText(t_str);
	m_doc_litera.SetWindowText(t_str);
	*/
}

bool CDocCreateDlg::VerIsActive()
{
	if(!m_rev) return true;

	CaplInstance *ciDoc = NULL, *ciActive = NULL;
	apidata.GetAttr(m_rev, m_api->m_doc_mgr.a_apl_doc_rev_doc, ciDoc);

	if(ciDoc) apidata.GetAttr(ciDoc, m_api->m_doc_mgr.a_apl_doc_active, ciActive);
	if(ciActive && m_rev==ciActive) return true;

	return false;
}




void CDocCreateDlg::OnBnClickedCrcCheck()
{
	if(!m_rev) return;

	int crc;
	apidata.GetAttr(m_rev,m_api->m_doc_mgr.a_apl_doc_rev_crc,crc);
	CString path; 
	aplGetTempPath(path);
	path+=_T("apl_check.crc");

	CFileFind ff;
	if(ff.FindFile(path))
	{
		SetFileAttributes(path,FILE_ATTRIBUTE_NORMAL);
		DeleteFile(path);
	}
	long dID = aplStartWaitDlg( APL_T("   ..."));
	m_api->m_doc_mgr.LoadRevision(m_rev,path);
	aplEndWaitDlg(dID);
	aplSetTextWaitDlg(dID,_T(" CRC32"));
	int crc_f=GetFileCRC32(path);
	aplEndWaitDlg(dID);
	SetFileAttributes(path,FILE_ATTRIBUTE_NORMAL);
	DeleteFile(path);

	if(crc_f==crc) AfxMessageBox(APL_T("  !"),MB_ICONINFORMATION|MB_OK);
	else AfxMessageBox(APL_T("  !\n\n     !"),MB_ICONSTOP|MB_OK);
}



void CDocCreateDlg::OnBnClickedSelDocFrom()
{
	if(m_doc!=0) {if(m_doc->GetAccessmode()>aplRW) AfxMessageBox(APL_T("    !"),MB_OK|MB_ICONSTOP);	}

	aplExtent ext;
	CaplInstance *po=m_api->m_appr_mgr.SelectPersonOrOrganization(APL_MODE_SELECT_PERSON|APL_MODE_SELECT_ORG,ext);
	if(0==po) return;

	CString buf;
	m_doc_po_from=po;
	m_api->m_appr_mgr.GetItemName(m_doc_po_from,buf);
	m_from_ctrl.SetWindowText(buf);
}

void CDocCreateDlg::OnBnClickedSelDocTo()
{
	if(m_doc!=0) {if(m_doc->GetAccessmode()>aplRW) AfxMessageBox(APL_T("    !"),MB_OK|MB_ICONSTOP);	}

	aplExtent ext;
	ext=m_doc_recitients;
	if(!m_api->m_appr_mgr.SelectPersonsOrganizations(APL_MODE_SELECT_PERSON|APL_MODE_SELECT_ORG,ext,true,false)) return;


	m_doc_recitients=ext;

	CString buf,sRecipients;
	int j;
	for(j=0;j<m_doc_recitients.GetSize();j++)
	{
		CaplInstance *po=m_doc_recitients[j];
		if(m_api->m_data.IsKindOf(po,m_api->m_appr_mgr.e_org))
			m_api->m_data.GetAttr(po, m_api->m_appr_mgr.a_org_id, buf);	
		else m_api->m_appr_mgr.GetItemName(po,buf);
		if(sRecipients!=_T("")) sRecipients+=_T(", ");
		sRecipients+=buf;
	}
	m_to_ctrl.SetWindowText(sRecipients);	
}


void CDocCreateDlg::OnBnClickedDelDocFrom()
{
	m_doc_po_from=0;
	m_from_ctrl.SetWindowText(_T(""));
}

void CDocCreateDlg::CalcMultiFormatsA4SheetsCount()
{
	m_sOfListsA4 = _T("");
	m_sOfLists = _T("");
	int countA4=0,count_all=0;
	SMapListDescr* list_descr=0;
	CString formats = _T(""),tmp;

	for(int i=0;i<m_list_num_lists.Size;i++)
	{
		double k;
		list_descr = m_list_num_lists[i];
		if(list_descr==0) continue;
		switch(list_descr->format)
		{
		case 0: k=16;break;
		case 1: k=8;break;
		case 2: k=4;break;
		case 3: k=2;break;
		case 4: k=1;break;
		case 5: k=0.5;break;
		default:
			continue;
		}
		countA4 += (int)(0.5 + list_descr->count * list_descr->multipl * k);
		count_all += list_descr->count;
//		         ...  CaplDocManager::CalcAllSheetsFromMultiFormats
// 		if(list_descr->multipl > 1)
// 			tmp.Format(APL_T("A%ix%i - %i "),list_descr->format,list_descr->multipl,list_descr->count);
// 		else
// 			tmp.Format(APL_T("A%i - %i "),list_descr->format,list_descr->count);
// 		div_t div_res_100 = div(list_descr->count,100);
// 		div_t div_res_10 = div(list_descr->count,10);
// 		if( div_res_100.rem > 9 && div_res_100.rem < 20 ) tmp += APL_T("");
// 		else if( div_res_10.rem == 0 || div_res_10.rem > 4 ) tmp += APL_T("");
// 		else if( div_res_10.rem > 1 ) tmp += APL_T("");
// 
// 		if(formats != _T("")) formats+=_T(" + ");
// 		formats += tmp;
		//   -   
		if(list_descr->count == 0) continue;
		if(formats != _T("")) formats+=_T(", ");
		tmp.Format(_T("A%i"),list_descr->format);
 		formats += tmp;
	}
	
	if(countA4 > 0) m_sOfListsA4.Format(_T("%i"),countA4);
	//if(count_all > 0)m_sOfLists.Format(_T("%i"),count_all);
	if(count_all > 0)
	{
		//m_sOfLists = formats;
		m_sOfLists.Format(_T("%i"),count_all);
		if(formats!=_T("")){m_sOfLists+=APL_T(" (: ");		m_sOfLists+=formats; m_sOfLists+=_T(")");}
	}
}


//     
void CDocCreateDlg::DblclkListsFormats() 
{
// 	if(m_doc!=0)
// 	{				
// 		if(m_doc->GetAccessmode()>=aplRO || m_bWFstateReadOnly)
// 		{
// 			return;
// 		}
// 	}
	if(m_rev!=0)
	{
		//     ,    
		bool bFormatComboDisabled= 0!=(WS_DISABLED & m_format_ctrl.GetStyle());

		if(m_rev->GetAccessmode()>=aplRO || bFormatComboDisabled)
		{
			return;
		}
	}
	if(m_format!=_T("*")) return;

	CDocFormatListsDlg dlg;
	SMapListDescr* list_descr=0;
	int i;
	
	dlg.m_list_num_lists.Clear();
	for(i=0;i<m_list_num_lists.Size;i++)
	{
		list_descr=new SMapListDescr(m_list_num_lists[i]);
		dlg.m_list_num_lists.Add(list_descr);
	}

	if(dlg.DoModal()==IDOK)
	{
		UpdateData(TRUE);
		m_list_num_lists.Clear();
		for(i=0;i<dlg.m_list_num_lists.Size;i++)
		{
			list_descr=new SMapListDescr(dlg.m_list_num_lists[i]);
			m_list_num_lists.Add(list_descr);
		}
		CalcMultiFormatsA4SheetsCount();
		UpdateData(FALSE);
	}
}

void CDocCreateDlg::OnBnClickedOfListsSelect()
{
	DblclkListsFormats();
}


IMPLEMENT_DYNCREATE(CaplDblclickEdit, CEdit)

BEGIN_MESSAGE_MAP(CaplDblclickEdit, CEdit)
	//{{AFX_MSG_MAP(CaplDblclickEdit)
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CaplDblclickEdit::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	if(m_parent!=0)
		m_parent->DblclkListsFormats();
}


void CDocCreateDlg::OnBnClickedDocView()
{
	if(0==m_rev) return;
	m_api->m_doc_mgr.View(m_rev);
}

void CDocCreateDlg::OnBnClickedSaveToDb()
{
	if(m_save_to_db_ctrl.GetCheck()>0) m_del_from_disk_btn.EnableWindow(TRUE);
	else m_del_from_disk_btn.EnableWindow(FALSE);
}

void CDocCreateDlg::OnDropFiles(HDROP hDropInfo)
{
	if(m_doc_rev_file_ctrl.GetStyle() & ES_READONLY) return;

	const UINT n=DragQueryFile(hDropInfo,-1,NULL,0);//   
	if(n>0)
	{
		CString strFile;
		DragQueryFile(hDropInfo,0,strFile.GetBufferSetLength(MAX_PATH+1),MAX_PATH);
		strFile.ReleaseBuffer();
		m_doc_rev_file_ctrl.SetWindowText(strFile);
	}
	DragFinish(hDropInfo);

	//CaplResizableDialog::OnDropFiles(hDropInfo);
}
