// FindAdjustUserDateDlg.cpp : implementation file
//

#include "stdafx.h"
#include "apl_api.h"
#include "FindAdjustUserDateDlg.h"


// CFindAdjustUserDateDlg dialog

IMPLEMENT_DYNAMIC(CFindAdjustUserDateDlg, CaplTranslateDialog)

CFindAdjustUserDateDlg::CFindAdjustUserDateDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CFindAdjustUserDateDlg::IDD, pParent)
	, m_NameUserCreate(_T(""))
	, m_NameUserUpdate(_T(""))
	, m_IsUserCreate(FALSE)
	, m_IsUserUpdate(FALSE)
	, m_IsDateCreate(FALSE)
	, m_IsDateUpdate(FALSE)
{
	m_user_create=0;
	m_user_update=0;
	m_api=0;
	m_read_only=false;

}

CFindAdjustUserDateDlg::~CFindAdjustUserDateDlg()
{
}

void CFindAdjustUserDateDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BUTTON_USER_CREATE, m_BtnSelectUserCreate);
	DDX_Control(pDX, IDC_BUTTON_USER_UPDATE, m_BtnSelectUserUpdate);
	DDX_Text(pDX, IDC_EDIT_USER_CREATE, m_NameUserCreate);
	DDX_Text(pDX, IDC_EDIT_USER_UPDATE, m_NameUserUpdate);
	DDX_Control(pDX, IDC_DATETIMEPICKER_CREATE, m_CtrlDateCreate);
	DDX_Control(pDX, IDC_DATETIMEPICKER_UPDATE, m_CtrlDateUpdate);
	DDX_Check(pDX, IDC_CHECK_USER_CREATE, m_IsUserCreate);
	DDX_Check(pDX, IDC_CHECK_USER_UPDATE, m_IsUserUpdate);
	DDX_Check(pDX, IDC_CHECK_DATE_CREATE, m_IsDateCreate);
	DDX_Check(pDX, IDC_CHECK_DATE_UPDATE, m_IsDateUpdate);
	DDX_Control(pDX, IDC_CHECK_USER_CREATE, m_ChkUserCreate);
	DDX_Control(pDX, IDC_CHECK_USER_UPDATE, m_ChkUserUpdate);
	DDX_Control(pDX, IDC_CHECK_DATE_CREATE, m_ChkDateCreate);
	DDX_Control(pDX, IDC_CHECK_DATE_UPDATE, m_ChkDateUpdate);
}


BEGIN_MESSAGE_MAP(CFindAdjustUserDateDlg, CaplTranslateDialog)
	ON_BN_CLICKED(IDC_BUTTON_USER_CREATE, OnBnClickedButtonUserCreate)
	ON_BN_CLICKED(IDC_BUTTON_USER_UPDATE, OnBnClickedButtonUserUpdate)
	ON_BN_CLICKED(IDC_CHECK_USER_CREATE, OnBnClickedCheck)
	ON_BN_CLICKED(IDC_CHECK_USER_UPDATE, OnBnClickedCheck)
	ON_BN_CLICKED(IDC_CHECK_DATE_CREATE, OnBnClickedCheck)
	ON_BN_CLICKED(IDC_CHECK_DATE_UPDATE, OnBnClickedCheck)
END_MESSAGE_MAP()


// CFindAdjustUserDateDlg message handlers

void CFindAdjustUserDateDlg::OnBnClickedButtonUserCreate()
{
	// TODO: Add your control notification handler code here
	aplExtent ext;
	CaplInstance *pers,*pers_org;
	
	pers=m_api->m_appr_mgr.SelectPersonOrOrganization
		(APL_MODE_SELECT_PERSON,ext, APL_T(" "), APL_T("   "));

	if(pers!=0)
	{
		m_api->m_appr_mgr.GetUserByPerson(pers,&m_user_create,&pers_org);
		if(m_user_create!=0)
		{
			m_api->m_appr_mgr.GetPersonName(m_user_create,m_NameUserCreate);
		}else{
			m_NameUserCreate=_T("");
		}
	}else{
		m_NameUserCreate=_T("");
	}

	UpdateData(FALSE);

}

void CFindAdjustUserDateDlg::OnBnClickedButtonUserUpdate()
{
	// TODO: Add your control notification handler code here
}

void CFindAdjustUserDateDlg::OnBnClickedCheck()
{
	// TODO: Add your control notification handler code here
	CheckControls();
}

void CFindAdjustUserDateDlg::CheckControls()
{
	UpdateData(TRUE);
	m_ChkUserCreate.EnableWindow(m_read_only?FALSE:TRUE);
	m_ChkUserUpdate.EnableWindow(m_read_only?FALSE:TRUE);
	m_ChkDateCreate.EnableWindow(m_read_only?FALSE:TRUE);
	m_ChkDateUpdate.EnableWindow(m_read_only?FALSE:TRUE);

	m_BtnSelectUserCreate.EnableWindow(m_read_only?FALSE:m_IsUserCreate);
	m_BtnSelectUserUpdate.EnableWindow(m_read_only?FALSE:m_IsUserUpdate);
	m_CtrlDateCreate.EnableWindow(m_read_only?FALSE:m_IsDateCreate);
	m_CtrlDateUpdate.EnableWindow(m_read_only?FALSE:m_IsDateUpdate);
}

BOOL CFindAdjustUserDateDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	CheckControls();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}
