// FindObjectDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FindPKIDlgEx.h"
#include "resource.h"
#include "resource.h"

// CFindPKIDlgEx dialog

IMPLEMENT_DYNAMIC(CFindPKIDlgEx, CaplResizableDialog)

CFindPKIDlgEx::CFindPKIDlgEx(CaplAPI *api, CString sTitle, CWnd* pParent /*=NULL*/)
: CaplResizableDialog(CFindPKIDlgEx::IDD, pParent)
{
	m_api = api;
	m_sTitle = sTitle;

	m_bClearPrdInstList = true;
	m_bPrdInstOnly = false;
	m_bDisableLot = false;
	m_bDisablePrdInst = false;
	m_bProcessItemChange = true;

	m_ciItem = 0;
	m_ciLot = 0;

	m_bNoShowSprav=true;

	m_bShowFindCount=true;
}

BOOL CFindPKIDlgEx::m_bShowSpravCheck=TRUE;


CFindPKIDlgEx::~CFindPKIDlgEx()
{
}

void CFindPKIDlgEx::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);

	DDX_Text(pDX, IDC_PRD_ID, m_sPrdId);
	DDX_Text(pDX, IDC_PRD_NAME, m_sPrdName);
	DDX_Text(pDX, IDC_SN, m_sSN);
	DDX_Text(pDX, IDC_LOT_ID, m_sLotId);

	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);

	DDX_Control(pDX, IDC_SEARCH_PDF, m_btn_search_pdf);
	DDX_Control(pDX, IDC_SEARCH_PRD_INST, m_btn_search_prd_inst);
	DDX_Control(pDX, IDC_SEARCH_LOT, m_btn_search_lot);

	DDX_Control(pDX, IDC_CREATE_PDF, m_btn_create_pdf);
	DDX_Control(pDX, IDC_CREATE_PRD_INST, m_btn_create_prd_inst);
	DDX_Control(pDX, IDC_CREATE_LOT, m_btn_create_lot);

	DDX_Control(pDX, IDC_LIST_PDF, m_list_pdf);
	DDX_Control(pDX, IDC_LIST_PRD_INST, m_list_prd_inst);
	DDX_Control(pDX, IDC_LIST_LOT, m_list_lot);

	DDX_Control(pDX, IDC_PDF_PROP, m_btn_pdf_prop);
	DDX_Control(pDX, IDC_PRD_INST_PROP, m_btn_prd_inst_prop);
	DDX_Control(pDX, IDC_LOT_PROP, m_btn_lot_prop);
	DDX_Control(pDX, IDC_PRD_CLASSIFIERS, m_prd_classif_ctrl);
	DDX_Control(pDX, IDC_CHECK_SHOW_SPRAV, m_prd_classif_check);
	DDX_Control(pDX, IDC_CHECK_FIND_ONLY_IN_SPRAV, m_find_only_in_strav_check);
}


BEGIN_MESSAGE_MAP(CFindPKIDlgEx, CaplResizableDialog)
	ON_BN_CLICKED(IDC_SEARCH_PDF, OnSearchPdf)
	ON_BN_CLICKED(IDC_SEARCH_PRD_INST, OnSearchPrdInst)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST_PDF, &CFindPKIDlgEx::OnLvnItemchangedListPdf)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST_PRD_INST, &CFindPKIDlgEx::OnLvnItemchangedListPrdInst)
	ON_BN_CLICKED(IDC_SEARCH_LOT, &CFindPKIDlgEx::OnBnClickedSearchLot)
	ON_BN_CLICKED(IDC_CREATE_PDF, &CFindPKIDlgEx::OnBnClickedCreatePdf)
	ON_BN_CLICKED(IDC_CREATE_PRD_INST, &CFindPKIDlgEx::OnBnClickedCreatePrdInst)
	ON_BN_CLICKED(IDC_CREATE_LOT, &CFindPKIDlgEx::OnBnClickedCreateLot)
	ON_BN_CLICKED(IDOK, &CFindPKIDlgEx::OnBnClickedOk)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_PDF, &CFindPKIDlgEx::OnNMDblclkListPdf)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_PRD_INST, &CFindPKIDlgEx::OnNMDblclkListPrdInst)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_LOT, &CFindPKIDlgEx::OnNMDblclkListLot)
	ON_BN_CLICKED(IDC_PDF_PROP, &CFindPKIDlgEx::OnBnClickedPdfProp)
	ON_BN_CLICKED(IDC_PRD_INST_PROP, &CFindPKIDlgEx::OnBnClickedPrdInstProp)
	ON_BN_CLICKED(IDC_LOT_PROP, &CFindPKIDlgEx::OnBnClickedLotProp)
	ON_NOTIFY(NM_CLICK, IDC_LIST_PDF, &CFindPKIDlgEx::OnNMClickListPdf)
	ON_BN_CLICKED(IDC_SELFROM_CLASSIF, &CFindPKIDlgEx::OnBnClickedSelfromClassif)
	ON_BN_CLICKED(IDC_CHECK_SHOW_SPRAV, &CFindPKIDlgEx::OnBnClickedCheckShowSprav)
END_MESSAGE_MAP()


void CFindPKIDlgEx::SetAnhors()
{

	{ //    CaplResizableDialog->OnInitDialog
		UpdateGripPos();

		// gets the template size as the min track size
		CRect rc;
		GetWindowRect(&rc);
		SetMinTrackSize(CSize( rc.Width(),rc.Height()));
		//m_ptMinTrackSize.x = rc.Width();
		//m_ptMinTrackSize.y = rc.Height();

		SetInitDone();

		DWORD dwStyle(GetStyle());
		bResizebleStyle = (dwStyle&WS_THICKFRAME)!=0;
	}

	AddAnchor(IDOK, BOTTOM_RIGHT);	
	AddAnchor(IDCANCEL, BOTTOM_RIGHT);
	AddAnchor(IDC_PRD_CLASSIFIERS, BOTTOM_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_CHECK_SHOW_SPRAV, BOTTOM_LEFT);

	int k=33;
	if(m_bDisablePrdInst) k=100;
	else if(m_bDisableLot) k=50;

	CSize s21(k,0);
	CSize s22(k,100);
	CSize s31(2*k,0);
	CSize s32(2*k,100);
	
	AddAnchor(IDC_STATIC_PDF, TOP_LEFT, s22);
	AddAnchor(IDC_LIST_PDF, TOP_LEFT, s22);
	AddAnchor(IDC_PRD_NAME,   TOP_LEFT, s21);	
	AddAnchor(IDC_SEARCH_PDF, s21);	
	AddAnchor(IDC_SELFROM_CLASSIF, BOTTOM_LEFT);	
	AddAnchor(IDC_CREATE_PDF, s22);	
	AddAnchor(IDC_PDF_PROP, s22);	

	//if(m_bDisablePrdInst && m_bDisableLot) return;
	
	AddAnchor(IDC_STATIC_PI, s21,s32);
	AddAnchor(IDC_LIST_PRD_INST, s21,s32);
	AddAnchor(IDC_SN, s21,s31);

	AddAnchor(IDC_STATIC_SN, s21);
	AddAnchor(IDC_SEARCH_PRD_INST, s31);
	AddAnchor(IDC_PRD_INST_PROP, s32);
	AddAnchor(IDC_CREATE_PRD_INST, s32);


	AddAnchor(IDC_STATIC_LOT, s31,BOTTOM_RIGHT);
	AddAnchor(IDC_LIST_LOT, s31, BOTTOM_RIGHT);	
	AddAnchor(IDC_LOT_ID, s31,TOP_RIGHT);	

	AddAnchor(IDC_LOT_PROP, BOTTOM_RIGHT);	
	AddAnchor(IDC_CREATE_LOT, BOTTOM_RIGHT);	
	AddAnchor(IDC_SEARCH_LOT, TOP_RIGHT);	
	AddAnchor(IDC_STATIC_LOT_NUM, s31);	
}

BOOL CFindPKIDlgEx::OnInitDialog()
{
	CDialog::OnInitDialog();
	if(m_api==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));

	InitBtns();
	InitLists();
	if(m_bDisableLot || m_bDisablePrdInst) DisableLot();
	if(m_bDisablePrdInst) DisablePrdInst();
	SetAnhors();

	if(!m_sTitle.IsEmpty()) SetWindowText(m_sTitle);

	if(m_sSpravId!=_T(""))
	{
		CStringArray sSystems;
		m_api->m_options_mgr.DivideStringOptions(m_sSpravId,sSystems);

		int i;
		for(i=0;i<sSystems.GetSize();i++)
		{
			CaplInstance *classif=m_api->m_classifier_mgr.GetClassifierSystemById(sSystems[i],true);
			if(0!=classif) m_base_classifiers.Add(classif);
			else
			{
				CString buf;
				buf.Format(APL_T("   \"%s\"!"),LPCTSTR(sSystems[i]));
				AfxMessageBox(buf,MB_ICONWARNING|MB_OK);
			}
		}

		if(0==m_base_classifiers.GetSize()) AfxMessageBox(APL_T("       !"),MB_ICONWARNING|MB_OK);
		else m_btn_create_pdf.ShowWindow(SW_HIDE);

		 m_find_only_in_strav_check.SetCheck(1);
	}

	if(0!=m_base_classifiers.GetSize())
	{
		m_find_only_in_strav_check.SetCheck(1);
		m_find_only_in_strav_check.EnableWindow(TRUE);
	}


	m_prd_classif_check.SetCheck(m_bShowSpravCheck);


	if(0!=m_ciItem)
	{
		CaplInstance *pdf=0,*prd=0,*pi=0;

		if(m_api->m_data.IsKindOf(m_ciItem,m_api->m_prd_inst_mgr.e_prd_inst)) {pi=m_ciItem;}
		else if(m_api->m_data.IsKindOf(m_ciItem,m_api->m_prd_mgr.e_pdf)) {pdf=m_ciItem;}

		if(0!=pi)
		{
			m_api->m_data.GetAttr(pi,m_api->m_prd_inst_mgr.a_prd_inst_pdf,pdf);
			m_api->m_data.GetAttr(pi,m_api->m_prd_inst_mgr.a_prd_inst_sn,m_sSN);
		}

		if(0!=pdf) m_api->m_data.GetAttr(pdf,m_api->m_prd_mgr.a_pdf_prd,prd);

		if(0!=prd)
		{
			m_api->m_data.GetAttr(prd,m_api->m_prd_mgr.a_prd_id,m_sPrdId);
			m_api->m_data.GetAttr(prd,m_api->m_prd_mgr.a_prd_name,m_sPrdName);
		}

		if(0!=m_ciLot) m_api->m_data.GetAttr(m_ciLot,m_api->m_prd_inst_mgr.a_lot_id,m_sLotId);


		UpdateData(FALSE);


		m_bShowFindCount=false;

		if(0!=pdf) OnSearchPdf();
		if(0!=pi) OnSearchPrdInst();
		if(0!=m_ciLot) OnBnClickedSearchLot();

		m_bShowFindCount=true;
	}

	return TRUE;
}

void CFindPKIDlgEx::InitBtns()
{
	// , 
	m_ok_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_cancel_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));

	//  
	m_btn_search_pdf.SetFlat(FALSE);
	m_btn_search_pdf.SetIcon(aplGetButtonIco(APL_24_FIND));
	m_btn_search_prd_inst.SetFlat(FALSE);
	m_btn_search_prd_inst.SetIcon(aplGetButtonIco(APL_24_FIND));
	m_btn_search_lot.SetFlat(FALSE);
	m_btn_search_lot.SetIcon(aplGetButtonIco(APL_24_FIND));

	//  
	m_btn_create_pdf.SetFlat(FALSE);
	m_btn_create_pdf.SetIcon(aplGetButtonIco(APL_24_PLUS));
	m_btn_create_prd_inst.SetFlat(FALSE);
	m_btn_create_prd_inst.SetIcon(aplGetButtonIco(APL_24_PLUS));
	m_btn_create_lot.SetFlat(FALSE);
	m_btn_create_lot.SetIcon(aplGetButtonIco(APL_24_PLUS));

	//  
	m_btn_pdf_prop.SetFlat(FALSE);
	m_btn_pdf_prop.SetIcon(aplGetButtonIco(APL_24_PROPERTIES));
	m_btn_prd_inst_prop.SetFlat(FALSE);
	m_btn_prd_inst_prop.SetIcon(aplGetButtonIco(APL_24_PROPERTIES));
	m_btn_lot_prop.SetFlat(FALSE);
	m_btn_lot_prop.SetIcon(aplGetButtonIco(APL_24_PROPERTIES));
}

void CFindPKIDlgEx::InitLists()
{
	CRect clientRect;

	//  
	m_list_pdf.GetClientRect(clientRect);
	m_list_pdf.InsertColumn(0,  APL_T(""),		LVCFMT_LEFT, (int)(clientRect.right*0.2));
	m_list_pdf.InsertColumn(1,  APL_T(""),		LVCFMT_LEFT, (int)(clientRect.right*0.6));
	m_list_pdf.InsertColumn(2,  APL_T("/"), LVCFMT_LEFT, (int)(clientRect.right*0.2));
	m_list_pdf.SetImageList(aplGetInstImageList(), LVSIL_SMALL);

	//  
	m_list_prd_inst.GetClientRect(clientRect);
	m_list_prd_inst.InsertColumn(0,  APL_T(""),				LVCFMT_LEFT, (int)(clientRect.right*0.2));
	m_list_prd_inst.InsertColumn(1,  APL_T(" "),	LVCFMT_LEFT, (int)(clientRect.right*0.2));
	m_list_prd_inst.InsertColumn(2,  APL_T(""),			LVCFMT_LEFT, (int)(clientRect.right*0.5));
	m_list_prd_inst.InsertColumn(3,  APL_T(""),			LVCFMT_LEFT, (int)(clientRect.right*1.5));
	m_list_prd_inst.SetImageList(aplGetInstImageList(), LVSIL_SMALL);

	//  
	m_list_lot.GetClientRect(clientRect);
	m_list_lot.InsertColumn(0,  APL_T(""),				LVCFMT_LEFT, (int)(clientRect.right*0.2));
	m_list_lot.InsertColumn(1,  APL_T(""),					LVCFMT_LEFT, (int)(clientRect.right*0.8));
	m_list_lot.SetImageList(aplGetInstImageList(), LVSIL_SMALL);
}

void CFindPKIDlgEx::AddPdf(CaplInstance *ciPdf, int nInsertAt, bool bSelect)
{
	if(!ciPdf) return;
	if(ciPdf->GetAccessmode() > aplRO) return;

	// 27.02.2010 
	//         
	//      ,  
	/*CString sType;
	m_api->m_data.GetAttr(ciPdf, m_api->m_prd_mgr.a_apl_pdf_type, sType);
	if( !(sType==_T("part") || sType==_T("assembly")) ) return;*/

	CString buf;
	CaplInstance *ciPrd;

	m_api->m_data.GetAttr(ciPdf, m_api->m_prd_mgr.a_pdf_prd, ciPrd);
	if(!ciPrd) return;
	if(ciPrd->GetAccessmode() > aplRO) return;

	if(nInsertAt == -1) nInsertAt = m_list_pdf.GetItemCount();
	int nIndex = m_list_pdf.InsertItem(nInsertAt, _T(""), m_api->GetInstIco(ciPdf));

	m_api->m_data.GetAttr(ciPrd, m_api->m_prd_mgr.a_prd_id, buf);
	m_list_pdf.SetItemText(nIndex, 0, buf);

	m_api->m_data.GetAttr(ciPrd, m_api->m_prd_mgr.a_prd_name, buf);
	m_list_pdf.SetItemText(nIndex, 1, buf);

	m_api->m_data.GetAttr(ciPdf, m_api->m_prd_mgr.a_pdf_id, buf);
	m_list_pdf.SetItemText(nIndex, 2, buf);

	m_list_pdf.SetItemData(nIndex, (DWORD)ciPdf);

	if(bSelect)m_list_pdf.SetItemState(nIndex, LVIS_SELECTED, -1);
}

void CFindPKIDlgEx::OnSearchPdf()
{
	UpdateData();

	if(m_sPrdId.IsEmpty() && m_sPrdName.IsEmpty())
		if(MessageBox( APL_T("      .      ?"),  APL_T(""), MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2) == IDNO)
			return;

	aplExtent aePdf;	
	CString sSql, buf;

	BOOL bFindInSprav=FALSE;
	if(0!=m_base_classifiers.GetSize()) bFindInSprav=m_find_only_in_strav_check.GetCheck();

	//     
	long dID = aplStartWaitDlg( APL_T(" ..."));
	if(0==m_base_classifiers.GetSize() || (0==bFindInSprav))
	{
		sSql.Format(_T("SELECT Ext_1 FROM Ext_1 { apl_product_definition_formation.of_product->product(.id LIKE '%s' AND .name LIKE '%s') } END_SELECT"), m_sPrdId, m_sPrdName);
	}
	else
	{
		CString buf,sQClassif;
		int i;
		for(i=0;i<m_base_classifiers.GetSize();i++)
		{
			buf.Format(_T(" .system=#%i"),m_base_classifiers[i]->GetId());
			if(sQClassif!=_T("")) sQClassif+=_T(" OR");
			sQClassif+=buf;
		}


		sSql.Format(_T("SELECT Ext_1 FROM Ext_1 { apl_classifier_association((.item->apl_product_definition_formation.of_product->product(.id LIKE '%s' AND .name LIKE '%s'))")
			_T("AND (%s))}.item END_SELECT"), m_sPrdId, m_sPrdName,sQClassif);
	}
	if(!m_api->m_data.NET_QueryEditParse(sSql, false))
	{
		aplEndWaitDlg(dID);
		MessageBox( APL_T("   "),  APL_T(""), MB_ICONERROR);
		return ;
	}
	m_api->m_data.NET_QueryExecute(aePdf);
	m_api->LoadExtentInfo(aePdf);
	aplEndWaitDlg(dID);

	m_bNoShowSprav=true;

	//  
	m_bProcessItemChange = false;
	dID = aplStartWaitDlg( APL_T(" ..."));
	m_list_pdf.DeleteAllItems();

	for(int i=0; i<aePdf.Size; i++)
		AddPdf(aePdf[i]);

	m_bNoShowSprav=false;

	aplEndWaitDlg(dID);
	m_bProcessItemChange = true;

	m_list_pdf.Invalidate();

	if(0==aePdf.GetSize()) MessageBox(APL_T("  !"),  APL_T(""), MB_ICONINFORMATION);
	else
	{
		if(m_bShowFindCount)
		{
			if(!m_api->m_options_mgr.CheckInstallCode(APL_NO_T(""))) 
			{
				buf.Format( APL_T("  : %d"), m_list_pdf.GetItemCount());
				MessageBox(buf,  APL_T(""), MB_ICONINFORMATION);
			}
		}
	}
}

bool CFindPKIDlgEx::IsSystem(CaplInstance *PrdInst)
{
	CString buf;
	CaplInstance* pdf;

	if(PrdInst->attrs==NULL) 
		m_api->LoadItemInfo(PrdInst);
	if(m_api->m_data.IsKindOf(PrdInst, m_api->m_prd_inst_mgr.e_prd_inst))
		m_api->m_data.GetAttr(PrdInst, m_api->m_prd_inst_mgr.a_prd_inst_pdf, pdf);
	else 
		pdf = PrdInst;

	if(pdf==NULL) return false;
	m_api->m_data.GetAttr(pdf, m_api->m_prd_mgr.a_apl_pdf_type, buf);

	return (buf.CompareNoCase(_T("system"))==0);
}

void CFindPKIDlgEx::AddPrdInst(CaplInstance *ciPrdInst, int nInsertAt)
{
	if(!ciPrdInst) return;

	CString buf;
	CaplInstance *ciPrd, *ciPdf;

	if(IsSystem(ciPrdInst)) return;

	m_api->m_data.GetAttr(ciPrdInst, m_api->m_prd_inst_mgr.a_prd_inst_pdf, ciPdf);
	if(!ciPdf) return;
	m_api->m_data.GetAttr(ciPdf, m_api->m_prd_mgr.a_pdf_prd, ciPrd);
	if(!ciPrd) return;

	if(nInsertAt == -1) nInsertAt = m_list_prd_inst.GetItemCount();
	int nIndex = m_list_prd_inst.InsertItem(nInsertAt, _T(""), m_api->GetInstIco(ciPrdInst));

	m_api->m_data.GetAttr(ciPrdInst, m_api->m_prd_inst_mgr.a_prd_inst_id, buf);
	m_list_prd_inst.SetItemText(nIndex, 0, buf);

	m_api->m_data.GetAttr(ciPrdInst, m_api->m_prd_inst_mgr.a_prd_inst_sn, buf);
	m_list_prd_inst.SetItemText(nIndex, 1, buf);

	m_api->m_data.GetAttr(ciPrdInst, m_api->m_prd_inst_mgr.a_prd_inst_descr, buf);
	buf.Replace(_T("\r\n"), _T(" "));
	m_list_prd_inst.SetItemText(nIndex, 2, buf);

	CaplInstance *pdf;
	m_api->m_data.GetAttr(ciPrdInst, m_api->m_prd_inst_mgr.a_prd_inst_pdf, pdf);
	m_api->m_prd_mgr.GetItemName(pdf,buf);
	m_list_prd_inst.SetItemText(nIndex, 3, buf);

	m_list_prd_inst.SetItemData(nIndex, (DWORD)ciPrdInst);
}

void CFindPKIDlgEx::OnSearchPrdInst()
{
	UpdateData();
	//UpdateDataByPdfList();

	if(m_sPrdId.IsEmpty() && m_sPrdName.IsEmpty() && m_sSN.IsEmpty())
		if(MessageBox( APL_T("      .      ?"),  APL_T(""), MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2) == IDNO)
			return;

	CString sSql, buf;
	aplExtent aePrdInst;	

	//   
	long dID = aplStartWaitDlg( APL_T("  ..."));
	m_list_prd_inst.DeleteAllItems();
	sSql.Format(_T("SELECT Ext_1 FROM Ext_1 { apl_product_instance(.formation->apl_product_definition_formation.of_product->product(.id LIKE '%s' AND .name LIKE '%s') AND .serial_number LIKE '%s') } END_SELECT"), m_sPrdId, m_sPrdName, m_sSN);
	if(!m_api->m_data.NET_QueryEditParse(sSql, false))
	{
		MessageBox( APL_T("   "),  APL_T(""), MB_ICONERROR);
		return ;
	}
	m_api->m_data.NET_QueryExecute(aePrdInst);
	m_api->LoadExtentInfo(aePrdInst);
	aplEndWaitDlg(dID);

	//   
	dID = aplStartWaitDlg( APL_T(" ..."));
	for(int i=0; i<aePrdInst.Size; i++)
		AddPrdInst(aePrdInst[i]);
	aplEndWaitDlg(dID);

	m_list_prd_inst.Invalidate();

	if(m_bShowFindCount)
	{
		buf.Format( APL_T("   : %d"), m_list_prd_inst.GetItemCount());
		MessageBox(buf,  APL_T(""), MB_ICONINFORMATION);
	}
}

void CFindPKIDlgEx::UpdateDataByPdfList()
{	
	/*
	CaplInstance *ciPrd = 0, *ciPdf = 0;
	int nIndex = m_list_pdf.GetNextItem(-1, LVIS_SELECTED);

	if(nIndex == -1)
	{
	m_sPrdId_Inst = m_sPrdId;
	m_sPrdName_Inst = m_sPrdName;
	}
	else
	{
	ciPdf = (CaplInstance*)m_list_pdf.GetItemData(nIndex);
	m_api->m_data.GetAttr(ciPdf, m_api->m_prd_mgr.a_pdf_prd, ciPrd);
	m_api->m_data.GetAttr(ciPrd, m_api->m_prd_mgr.a_prd_id, m_sPrdId_Inst);
	m_api->m_data.GetAttr(ciPrd, m_api->m_prd_mgr.a_prd_name, m_sPrdName_Inst);
	}
	*/
}

void CFindPKIDlgEx::GetPrdNameAndId(int nIndex)
{
	if(nIndex == -1) return;
	CaplInstance *ciPrd = 0, *ciPdf = (CaplInstance*)m_list_pdf.GetItemData(nIndex);

	if(0==ciPdf) return;

	UpdateData();
	m_api->m_data.GetAttr(ciPdf, m_api->m_prd_mgr.a_pdf_prd, ciPrd);
	m_api->m_data.GetAttr(ciPrd, m_api->m_prd_mgr.a_prd_id, m_sPrdId);
	m_api->m_data.GetAttr(ciPrd, m_api->m_prd_mgr.a_prd_name, m_sPrdName);	
	UpdateData(FALSE);
}

void CFindPKIDlgEx::OnLvnItemchangedListPdf(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);

	m_prd_classif_ctrl.SetWindowText(_T(""));

	if(false == m_list_pdf.IsSortingEx())
	{
		if(m_bClearPrdInstList)
		{
			m_list_prd_inst.DeleteAllItems();
			m_list_lot.DeleteAllItems();
		}

		if(m_bProcessItemChange)
			GetPrdNameAndId(pNMLV->iItem);

		if(true) //  
		{
			CaplInstance *ciPdf = (CaplInstance*)m_list_pdf.GetItemData(pNMLV->iItem);
			if(0!=ciPdf  && m_bNoShowSprav==false)
			{
				if((!ciPdf->IsDeleted()) && ciPdf->GetAccessmode()<=aplRO && (pNMLV->uNewState&LVIS_SELECTED) && m_bShowSpravCheck)
				{
					CString buf,buf1;
					m_prd_classif_ctrl.SetWindowText(buf);
					aplExtent classifiers;
					m_api->m_classifier_mgr.FindClassifiersContained(ciPdf, classifiers);
					int i;
					for(i=0;i<classifiers.GetSize();i++)
					{
						CaplInstance *sys;
						m_api->m_data.GetAttr(classifiers[i],m_api->m_classifier_mgr.a_apl_classifier_level_system,sys);
						m_api->m_data.GetAttr(sys,m_api->m_classifier_mgr.a_apl_classifier_system_name,buf1);
						if(buf!=_T("")) buf+=_T(", ");
						buf+=buf1;
					}
					m_prd_classif_ctrl.SetWindowText(buf);
				}
			}
		}
	}
	*pResult = 0;
}

void CFindPKIDlgEx::OnOK()
{

}

void CFindPKIDlgEx::OnLvnItemchangedListPrdInst(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);

	if(false == m_list_prd_inst.IsSortingEx())
	{
		int nIndex = m_list_prd_inst.GetNextItem(-1, LVIS_SELECTED);
		if(nIndex == -1)
		{
			m_list_lot.DeleteAllItems(); 
		}
		else
		{
			aplExtent aeLot;
			CaplInstance *ciLot = 0, *ciPrdInst = (CaplInstance*)m_list_prd_inst.GetItemData(nIndex);

			m_api->m_data.GetAttr(ciPrdInst, m_api->m_prd_inst_mgr.a_prd_inst_lot, ciLot);			
			if(ciLot) AddLot(ciLot);

			m_bClearPrdInstList = false;
			DeselectPdfList();
			CaplInstance *pdf;
			m_api->m_data.GetAttr(ciPrdInst, m_api->m_prd_inst_mgr.a_prd_inst_pdf, pdf);		
			SelectInPdfList(pdf);
			m_bClearPrdInstList = true;
		}
	}

	*pResult = 0;
}

void CFindPKIDlgEx::SelectInPdfList(CaplInstance *pdf)
{
	int i;
	bool old_m_bProcessItemChange=m_bProcessItemChange;
	m_bProcessItemChange=false;
	for(i=0;i<m_list_pdf.GetItemCount();i++)
	{
		CaplInstance *inst=(CaplInstance *)m_list_pdf.GetItemData(i);
		if(inst==pdf)
		{
			m_list_pdf.SetItemState(i, LVIS_SELECTED|LVIS_FOCUSED|LVIS_DROPHILITED,1);
			m_list_pdf.SetSelectionMark(i);
			m_list_pdf.EnsureVisible(i,FALSE);
			break;

		}
	}
	m_bProcessItemChange=old_m_bProcessItemChange;


}

void CFindPKIDlgEx::DeselectPdfList()
{
	int nIndex = m_list_pdf.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex == -1) return;

	m_list_pdf.SetItemState(nIndex, 0, LVIS_SELECTED|LVIS_FOCUSED);
}

void CFindPKIDlgEx::AddLot(CaplInstance *ciLot, int nInsertAt)
{
	CString buf;

	if(nInsertAt == -1) nInsertAt  = m_list_lot.GetItemCount();
	int nIndex = m_list_lot.InsertItem(nInsertAt, _T(""), m_api->GetInstIco(ciLot));

	m_api->m_data.GetAttr(ciLot, m_api->m_prd_inst_mgr.a_lot_id, buf);
	m_list_lot.SetItemText(nIndex, 0, buf);

	m_api->m_data.GetAttr(ciLot, m_api->m_prd_inst_mgr.a_lot_descr, buf);
	buf.Replace(_T("\r\n"), _T(" "));
	m_list_lot.SetItemText(nIndex, 1, buf);

	m_list_lot.SetItemData(nIndex, (DWORD)ciLot);
}

void CFindPKIDlgEx::OnBnClickedSearchLot()
{
	UpdateData();

	if(m_sLotId.IsEmpty())
		if(MessageBox( APL_T("      .      ?"),  APL_T(""), MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2) == IDNO)
			return;

	aplExtent aeLot;	
	CString sSql, buf;

	//     
	long dID = aplStartWaitDlg( APL_T(" ..."));
	sSql.Format(_T("SELECT Ext_1 FROM Ext_1 { apl_lot.id LIKE '%s' } END_SELECT"), m_sLotId);
	if(!m_api->m_data.NET_QueryEditParse(sSql, false))
	{
		MessageBox( APL_T("   "),  APL_T(""), MB_ICONERROR);
		return ;
	}
	m_api->m_data.NET_QueryExecute(aeLot);
	m_api->LoadExtentInfo(aeLot);
	aplEndWaitDlg(dID);

	//  
	dID = aplStartWaitDlg( APL_T(" ..."));
	m_list_lot.DeleteAllItems();
	for(int i=0; i<aeLot.Size; i++)
		AddLot(aeLot[i]);
	aplEndWaitDlg(dID);

	m_list_lot.Invalidate();

	if(m_bShowFindCount)
	{
		buf.Format( APL_T("  : %d"), aeLot.Size);
		MessageBox(buf,  APL_T(""), MB_ICONINFORMATION);
	}
}

void CFindPKIDlgEx::OnBnClickedCreatePdf()
{
	CString role;
	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\   "),role,_T(""));
	if(role!=_T(""))
	{
		if(!m_api->m_appr_mgr.CheckPersonRole(0,role))	{AfxMessageBox(APL_T("    !"));	return;	}
	}

	CaplInstance *ciNewPdf = m_api->m_prd_mgr.CreateProduct();
	if(ciNewPdf) 
	{
		AddPdf(ciNewPdf);
		m_api->SaveChanges();
	}
}

void CFindPKIDlgEx::OnBnClickedCreatePrdInst()
{
	CString role;
	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\    "),role,_T(""));
	if(role!=_T(""))
	{
		if(!m_api->m_appr_mgr.CheckPersonRole(0,role))	{AfxMessageBox(APL_T("    !"));	return;	}
	}

	CaplInstance *ciPdf = 0;
	int nIndex = m_list_pdf.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex != -1) ciPdf = (CaplInstance*)m_list_pdf.GetItemData(nIndex);

	CaplInstance *ciNewprdInst = m_api->m_prd_inst_mgr.CreatePrdInst(ciPdf);
	if(ciNewprdInst)
	{
		AddPrdInst(ciNewprdInst);
		m_api->SaveChanges();
	}
}

void CFindPKIDlgEx::OnBnClickedCreateLot()
{
	CString role;
	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\    "),role,_T(""));
	if(role!=_T(""))
	{
		if(!m_api->m_appr_mgr.CheckPersonRole(0,role))	{AfxMessageBox(APL_T("    !"));	return;	}
	}

	CaplInstance *ciPdf = 0, *ciPrdInst = 0;
	int nIndex = m_list_pdf.GetNextItem(-1, LVIS_SELECTED);

	if(nIndex != -1) ciPdf = (CaplInstance*)m_list_pdf.GetItemData(nIndex);
	else
	{
		nIndex = m_list_prd_inst.GetNextItem(-1, LVIS_SELECTED);
		if(nIndex != -1)
		{
			ciPrdInst = (CaplInstance*)m_list_prd_inst.GetItemData(nIndex);
			if(ciPrdInst) m_api->m_data.GetAttr(ciPrdInst, m_api->m_prd_inst_mgr.a_prd_inst_pdf, ciPdf);			
		}
	}

	CaplInstance *ciNewLot = m_api->m_prd_inst_mgr.CreateLot(ciPdf);
	if(ciNewLot)
	{
		AddLot(ciNewLot);
		m_api->SaveChanges();
	}
}

void CFindPKIDlgEx::OnBnClickedOk()
{
	int nIndex = -1;

	//  
	nIndex = m_list_lot.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex != -1) m_ciLot = (CaplInstance*)m_list_lot.GetItemData(nIndex);

	//   :   
	nIndex = m_list_pdf.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex != -1)
	{
		if(m_bPrdInstOnly)
		{
			MessageBox( APL_T("   ."),  APL_T(" "), MB_ICONINFORMATION);
			return;
		}

		m_ciItem = (CaplInstance*)m_list_pdf.GetItemData(nIndex);		
	}
	else
	{
		nIndex = m_list_prd_inst.GetNextItem(-1, LVIS_SELECTED);
		if(nIndex != -1) m_ciItem = (CaplInstance*)m_list_prd_inst.GetItemData(nIndex);
		else
		{
			MessageBox( APL_T("  ."),  APL_T(" "), MB_ICONINFORMATION);
			return;
		}
	}

	CaplResizableDialog::OnOK();
}

void CFindPKIDlgEx::OnNMDblclkListPdf(NMHDR *pNMHDR, LRESULT *pResult)
{
	OnBnClickedPdfProp();
	*pResult = 0;
}

void CFindPKIDlgEx::OnNMDblclkListPrdInst(NMHDR *pNMHDR, LRESULT *pResult)
{
	OnBnClickedPrdInstProp();
	*pResult = 0;
}

void CFindPKIDlgEx::OnNMDblclkListLot(NMHDR *pNMHDR, LRESULT *pResult)
{
	OnBnClickedLotProp();	
	*pResult = 0;
}

void CFindPKIDlgEx::OnBnClickedPdfProp()
{
	int nIndex = m_list_pdf.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex == -1) return;

	CaplInstance *ciPdf = (CaplInstance*)m_list_pdf.GetItemData(nIndex);
	if(m_api->m_prd_mgr.ShowProperties(ciPdf))
	{
		m_list_pdf.DeleteItem(nIndex);
		AddPdf(ciPdf, nIndex);
	}
}

void CFindPKIDlgEx::OnBnClickedPrdInstProp()
{
	int nIndex = m_list_prd_inst.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex == -1) return;

	CaplInstance *ciPrdInst = (CaplInstance*)m_list_prd_inst.GetItemData(nIndex);
	if(m_api->m_prd_inst_mgr.ShowPrdInstProperties(ciPrdInst))
	{
		m_list_prd_inst.DeleteItem(nIndex);
		AddPrdInst(ciPrdInst, nIndex);
	}
}

void CFindPKIDlgEx::OnBnClickedLotProp()
{
	int nIndex = m_list_lot.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex == -1) return;

	CaplInstance *ciLot = (CaplInstance*)m_list_lot.GetItemData(nIndex);
	if(m_api->m_prd_inst_mgr.ShowLotProperties(ciLot))
	{
		m_list_lot.DeleteItem(nIndex);
		AddLot(ciLot, nIndex);
	}
}

void CFindPKIDlgEx::DisablePrdInst()
{
	// 
	m_btn_create_prd_inst.EnableWindow(FALSE);
	m_btn_search_prd_inst.EnableWindow(FALSE);
	m_list_prd_inst.EnableWindow(FALSE);
	m_btn_prd_inst_prop.EnableWindow(FALSE);
	GetDlgItem(IDC_SN)->EnableWindow(FALSE);

	// 
	CRect rect;
	int delta = 315;

	GetWindowRect(rect);
	ScreenToClient(rect);
	rect.right -= delta;
	MoveWindow(rect);
	CenterWindow();

	//   /
	MoveOKCancelBtn(delta);
}

void CFindPKIDlgEx::DisableLot()
{
	// 
	m_btn_create_lot.EnableWindow(FALSE);
	m_btn_search_lot.EnableWindow(FALSE);
	m_list_lot.EnableWindow(FALSE);
	m_btn_lot_prop.EnableWindow(FALSE);
	GetDlgItem(IDC_LOT_ID)->EnableWindow(FALSE);

	// 
	CRect rect;
	int delta = 310;

	GetWindowRect(rect);
	//ScreenToClient(rect);
	rect.right -= delta;
	MoveWindow(rect);
	CenterWindow();

	//   /
	MoveOKCancelBtn(delta);
}

void CFindPKIDlgEx::MoveOKCancelBtn(int delta)
{
	CRect rect;

	m_ok_btn.GetWindowRect(rect);
	ScreenToClient(rect);
	rect.left -= delta; 
	rect.right -= delta;
	m_ok_btn.MoveWindow(rect);

	m_cancel_btn.GetWindowRect(rect);
	ScreenToClient(rect);
	rect.left -= delta; 
	rect.right -= delta;
	m_cancel_btn.MoveWindow(rect);

	m_prd_classif_ctrl.GetWindowRect(rect);
	ScreenToClient(rect);
	//rect.left -= delta;      
	rect.right -= delta;
	m_prd_classif_ctrl.MoveWindow(rect);
}

void CFindPKIDlgEx::OnNMClickListPdf(NMHDR *pNMHDR, LRESULT *pResult)
{
	GetPrdNameAndId(m_list_pdf.GetNextItem(-1, LVIS_SELECTED));
	*pResult = 0;
}

void CFindPKIDlgEx::OnBnClickedSelfromClassif()
{
	CaplInstance *pInst=0;
	m_api->m_classifier_mgr.SelectItem(&pInst,m_base_classifiers,APL_SELECT_CLASSIFIER_ITEM);

	if(0==pInst) return;
	m_list_pdf.DeleteAllItems();
	AddPdf(pInst,0,true);
	return;

}

void CFindPKIDlgEx::OnBnClickedCheckShowSprav()
{
	m_bShowSpravCheck = m_prd_classif_check.GetCheck();
}
