// FindQueryDlgEx.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "FindQueryDlgEx.h"
#include "FindAdjustApprDlg.h"
#include "FindAdjustDocDlg.h"
#include "FindAdjustCharactDlg.h"
#include "FindAdjustResourceDlg.h"
#include "CFindAdjustClassifDlg.h"
#include "FindAdjustBlobDlg.h"
#include "FindAdjustUserDateDlg.h"
#include "apl_api.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*
#ifdef _DEBUG
//    -    
QBS QPE2QBS(QPE el){return (QBS)el;}
QBS QGO2QBS(QGO el){return (QBS)el;}
QBS QF2QBS (QF  el){return (QBS)el;}

QPE QBS2QPE(QBS el){return (QPE)el;}
QGO QBS2QGO(QBS el){return (QGO)el;}
QF  QBS2QF (QBS el){return (QF )el;}
#endif
*/

#define SelectStringInCombo(ctrl,val) for(int indx_a=0;indx_a<ctrl.GetCount();indx_a++)\
{if(val==(CaplQLQuery::aplQLLogRelation)ctrl.GetItemData(indx_a)){ctrl.SetCurSel(indx_a);break;}}

bool CType2ValuesArray::IsExist(TypeFOAttr type)
{
	int i;
	for(i=0;i<attr_log_vals.GetSize();i++)
	{
		if(attr_log_vals.GetAt(i)->type==type) return true;
	}
	return false;
}

bool CType2ValuesArray::Add(TypeFOAttr type,CaplQLQuery::aplQLLogRelation val_log_rel,CaplValue &value,CaplValue &value2)
{
	int i;

	for(i=0;i<attr_log_vals.GetSize();i++)
	{
		if(attr_log_vals.GetAt(i)->type==type)
		{
			attr_log_vals.GetAt(i)->log_rel = val_log_rel;
			attr_log_vals.GetAt(i)->value.Set(value);
			attr_log_vals.GetAt(i)->value2.Set(value2);
			return true;
		}
	}
	attr_log_vals.Add(new STypeLogRelVal(type,val_log_rel,value,value2));
	return true;
}

bool CType2ValuesArray::Set(TypeFOAttr type,CaplQLQuery::aplQLLogRelation val_log_rel)
{
	int i;
	for(i=0;i<attr_log_vals.GetSize();i++)
	{
		if(attr_log_vals.GetAt(i)->type==type)
		{
			attr_log_vals.GetAt(i)->log_rel = val_log_rel;
			//attr_log_vals.GetAt(i)->value.Set(value);
			return true;
		}
	}
	return false;
}

bool CType2ValuesArray::Set(TypeFOAttr type,CaplValue &value,CaplValue &value2)
{
	int i;
	for(i=0;i<attr_log_vals.GetSize();i++)
	{
		if(attr_log_vals.GetAt(i)->type==type)
		{
			//attr_log_vals.GetAt(i)->log_rel = val_log_rel;
			attr_log_vals.GetAt(i)->value.Set(value);
			attr_log_vals.GetAt(i)->value2.Set(value2);
			return true;
		}
	}
	return false;
}


bool CType2ValuesArray::Get(TypeFOAttr type,CaplQLQuery::aplQLLogRelation &val_log_rel,CaplValue &value,CaplValue &value2)
{
	int i;
	val_log_rel = CaplQLQuery::aplNOLOGREL;
	value.Clear();

	for(i=0;i<attr_log_vals.GetSize();i++)
	{
		if(attr_log_vals.GetAt(i)->type==type)
		{
			val_log_rel = attr_log_vals.GetAt(i)->log_rel;
			value.Set(attr_log_vals.GetAt(i)->value);
			value2.Set(attr_log_vals.GetAt(i)->value2);
			return true;
		}
	}
	return false;
}

bool CType2ValuesArray::Del(TypeFOAttr type)
{
	int i;
	for(i=0;i<attr_log_vals.GetSize();i++)
	{
		if(attr_log_vals.GetAt(i)->type==type)
		{
			attr_log_vals.Remove(i);
		}
	}
	return true;
}


bool CType2ValuesArray::Clear()
{
	attr_log_vals.Clear();
	return true;
}

bool CType2ValuesArray::CopyFrom(CType2ValuesArray &source)
{
	int i;
	TypeFOAttr type; //  
	CaplQLQuery::aplQLLogRelation log_rel; //  
	CaplValue value,value2; //  
	Clear();
	for(i=0;i<source.attr_log_vals.GetSize();i++)
	{
		type = source.attr_log_vals.GetAt(i)->type;
		log_rel = source.attr_log_vals.GetAt(i)->log_rel;
		value.Set(source.attr_log_vals.GetAt(i)->value);
		value2.Set(source.attr_log_vals.GetAt(i)->value2);

		attr_log_vals.Add(new STypeLogRelVal(type,log_rel,value,value2));
	}
	return true;
}


bool CType2LogRels::Add(TypeFOAttr type,CaplQLQuery::aplQLLogRelation log_rel,bool def)
{
	int i,pos=0;
	STypeLogRelations* tlrs = 0;

	for(i=0;i<type2log_rels.GetSize();i++)
	{
		if(type2log_rels.GetAt(i)->type==type)
		{
			tlrs = type2log_rels.GetAt(i);
			break;
		}
	}
	if(tlrs == 0)
	{
		tlrs = new STypeLogRelations();
		tlrs->type = type;
		type2log_rels.Add(tlrs);
	}
	pos = tlrs->log_rels.Add(log_rel);
	if(def)tlrs->def = pos;

	return true;
}

bool CType2LogRels::Is(TypeFOAttr type)
{
	int i;
	for(i=0;i<type2log_rels.GetSize();i++)
	{
		if(type2log_rels.GetAt(i)->type==type)
		{
			return true;
		}
	}
	return false;
}

bool CType2LogRels::Get(TypeFOAttr type,CUIntArray &log_rels,int &def)
{
	int i,j;
	CUIntArray *arr;
	log_rels.RemoveAll();
	def = 0;

	for(i=0;i<type2log_rels.GetSize();i++)
	{
		if(type2log_rels.GetAt(i)->type==type)
		{
			arr = &(type2log_rels.GetAt(i)->log_rels);
			for(j=0;j<arr->GetSize();j++)
			{
				log_rels.Add(arr->GetAt(j));
			}
			def = type2log_rels.GetAt(i)->def;
		}
	}
	return true;
}

bool CType2LogRels::Clear()
{
	type2log_rels.Clear();
	return true;
}


IMPLEMENT_DYNAMIC(CMyComboBox, CComboBox)

BEGIN_MESSAGE_MAP(CMyComboBox, CComboBox)
	//{{AFX_MSG_MAP(CMyComboBox)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CMyComboBox::SetWindowPos(const CWnd* pWndInsertAfter, int x, int y, int cx, int cy, UINT nFlags)
{
	m_rect_draw.SetRect(x, y, x + cx, y + cy);
	return CWnd::SetWindowPos(pWndInsertAfter, x, y, cx, cy, nFlags);
}

void CMyComboBox::OnPaint() 
{
	CRect rect;
	GetWindowRect(&rect);

	GetParent()->ScreenToClient(&rect);

//	RedrawWindow(&m_rect_draw);
//	InvalidateRect(&m_rect_draw);

	CComboBox::OnPaint();

}




/////////////////////////////////////////////////////////////////////////////
// CFindQueryDlgEx dialog

CFindQueryDlgEx::CFindQueryDlgEx(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CFindQueryDlgEx::IDD, pParent)
	, m_IsNewWindow(FALSE)
	, m_IsSubstring(FALSE)
	, m_IsBrackets(FALSE)
	, m_is_or_char(false)
	, m_is_or_doc(false)
	, m_is_or_approval(false)
	, m_is_or_res(false)
	, m_is_or_blob(false)
	, m_is_or_class(false)
	, m_IsMatchCase(FALSE)
{
	//{{AFX_DATA_INIT(CFindQueryDlgEx)
	m_IsMakeTableResult = FALSE;
	m_StateSaveQuery = FALSE;
	//}}AFX_DATA_INIT
	m_QL_query=_T("");
	m_mode=FindObject_NDef;
	m_curr_type_descr = 0;
	m_curr_combo4edit = TSC_NonEdit;
	m_ActiveCtrl=0;
	m_hwndEditInComboItem=0;
	m_edit2date=false;

	m_mode_text=_T("");
	m_cur_ext_num=0;
	m_extents=_T("");
	m_fields=_T("");
	m_is_load_bmp=false;
	m_vis_mode=0;
	m_is_adjustment=false;
	m_can_make_table=true;
	m_can_save=true;
	m_read_only=false;
	m_mode_slave=false;

	m_StringSource=_T("");
	m_StringType=_T("");
	m_dbuf=0;
	
	m_api=0;
	m_instance=0;
	m_changed=false;
	m_single_mode=false;

	m_indx_of_zero_approval=-1;

	m_adj_add_icon=0;
	m_adj_del_icon=0;
	m_adj_edit_icon=0;

	m_is_new_window = 0;

	m_Date4Edit = COleDateTime::GetCurrentTime();
	m_Date4Edit2 = COleDateTime::GetCurrentTime();
}

CFindQueryDlgEx::~CFindQueryDlgEx()
{
	::DestroyIcon(m_adj_add_icon);
	::DestroyIcon(m_adj_del_icon);
	::DestroyIcon(m_adj_edit_icon);
	if(m_dbuf!=0)delete m_dbuf;
}

void CFindQueryDlgEx::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFindQueryDlgEx)
	DDX_Control(pDX, IDC_COMBO_4_EDIT, m_Cmbx4Edit);
	DDX_Control(pDX, IDC_COMBOEDIT_4_EDIT, m_CmbxEdit4Edit);
	DDX_Control(pDX, IDC_EDIT_4_EDIT, m_Edit4Edit);
	DDX_Control(pDX, IDC_DATE_4_EDIT, m_CtrlDate4Edit);
	DDX_Control(pDX, IDC_DATE_4_EDIT2, m_CtrlDate4Edit2);
	DDX_DateTimeCtrl(pDX, IDC_DATE_4_EDIT, m_Date4Edit);
	DDX_DateTimeCtrl(pDX, IDC_DATE_4_EDIT2, m_Date4Edit2);

	DDX_Control(pDX, IDC_STATIC_HEADER, m_st_header);
	DDX_Control(pDX, IDC_EDIT_NAME_QUERY, m_edt_name_query);
	DDX_Control(pDX, IDC_SELECT_FIND_TYPE, m_SelectFindType);
	DDX_Control(pDX, IDC_CHK_FIND_VERSION, m_ctrl_find_version);
	DDX_Control(pDX, IDC_LIST_ATTRIBUTES, m_ListAttributes);
	DDX_Control(pDX, IDC_BTN_ATTR_EDIT, m_BtnAttrEdit);
	DDX_Control(pDX, IDC_BTN_ATTR_DEL, m_BtnAttrDel);
	DDX_Control(pDX, IDC_BTN_ATTR_ADD, m_BtnAttrAdd);

	//D
	// 	DDX_Control(pDX, IDC_BTN_TYPE, m_BtnType);
	// 	DDX_Control(pDX, IDC_COMBO_STATE_ID, m_CmbxStId);
	// 	DDX_Control(pDX, IDC_COMBO_STATE_NAME, m_CmbxStName);
	// 	DDX_Control(pDX, IDC_COMBO_STATE_DESCR, m_CmbxStDescr);
	// 	DDX_Control(pDX, IDC_COMBO_STATE_TYPE, m_CmbxStType);
	// 	DDX_Control(pDX, IDC_COMBO_STATE_CODE_VER, m_CmbxStCodeVer);
	// 	DDX_Control(pDX, IDC_COMBO_STATE_CODE_VER1, m_CmbxStCodeVer1);
	// 	DDX_Control(pDX, IDC_COMBO_STATE_CODE_VER2, m_CmbxStCodeVer2);
	// 	DDX_Control(pDX, IDC_COMBO_STATE_CODE_IZD, m_CmbxStCodeIzd);
	// 	DDX_Control(pDX, IDC_COMBO_STATE_SOURCE, m_CmbxStSource);
	// 	DDX_Control(pDX, IDC_COMBO_STATE_VER, m_CmbxStVer);
	// 	DDX_Control(pDX, IDC_EDIT_ID, m_EditId);
	// 	DDX_Control(pDX, IDC_EDIT_NAME, m_EditName);
	// 	DDX_Control(pDX, IDC_EDIT_DESCR, m_EditDescr);
	// 	DDX_Control(pDX, IDC_COMBO_TYPE, m_EditType);
	// 	DDX_Control(pDX, IDC_EDIT_CODE_VER, m_EditCodeVer);
	// 	DDX_Control(pDX, IDC_EDIT_CODE_VER1, m_EditCodeVer1);
	// 	DDX_Control(pDX, IDC_EDIT_CODE_VER2, m_EditCodeVer2);
	// 	DDX_Control(pDX, IDC_EDIT_CODE_IZD, m_EditCodeIzd);
	// 	DDX_Control(pDX, IDC_COMBO_SOURCE, m_EditSource);
	// 	DDX_Control(pDX, IDC_EDIT_VER, m_EditVer);
	// 	DDX_CBIndex(pDX, IDC_COMBO_SOURCE, m_int_source);
	// 	DDX_CBIndex(pDX, IDC_COMBO_TYPE, m_int_type);
	// 	DDX_Control(pDX, IDC_CHK_ST_ID, m_Chk_StId);
	// 	DDX_Control(pDX, IDC_CHK_ST_NAME, m_Chk_StName);
	// 	DDX_Control(pDX, IDC_CHK_ST_DESCR, m_Chk_StDescr);
	// 	DDX_Control(pDX, IDC_CHK_ST_TYPE, m_Chk_StType);
	// 	DDX_Control(pDX, IDC_CHK_ST_CODE_VER, m_Chk_StCodeVer);
	// 	DDX_Control(pDX, IDC_CHK_ST_CODE_VER1, m_Chk_StCodeVer1);
	// 	DDX_Control(pDX, IDC_CHK_ST_CODE_VER2, m_Chk_StCodeVer2);
	// 	DDX_Control(pDX, IDC_CHK_ST_CODE_IZD, m_Chk_StCodeIzd);
	// 	DDX_Control(pDX, IDC_CHK_ST_SOURCE, m_Chk_StSource);
	// 	DDX_Control(pDX, IDC_CHK_ST_VER, m_Chk_StVer);


	DDX_Control(pDX, ID_ADJUST_EDIT, m_BtnAdjEdit);
	DDX_Control(pDX, ID_ADJUST_DEL, m_BtnAdjDel);
	DDX_Control(pDX, ID_ADJUST_ADD, m_BtnAdjAdd);
	DDX_Control(pDX, IDC_LIST_ADJUST, m_ListAdjust);
	DDX_Control(pDX, IDC_TAB_ADJUST, m_TabAdjust);
	DDX_Control(pDX, IDC_CHK_SAVE_QUERY, m_ChkSaveQuery);
	DDX_Control(pDX, ID_EXECUTE_FIND, m_BtnFind);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	DDX_Control(pDX, ID_SHOW_STEPQL, m_BtnShowStepQl);
	DDX_Control(pDX, IDC_CHK_MAKE_TABLE_RESULT, m_CtrlMakeTableResult);
	DDX_Check(pDX, IDC_CHK_MAKE_TABLE_RESULT, m_IsMakeTableResult);
	DDX_Text(pDX, IDC_EDIT_NAME_QUERY, m_StringNameQuery);
	DDX_Check(pDX, IDC_CHK_SAVE_QUERY, m_StateSaveQuery);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_CHK_MAKE_NEW_WINDOW, m_CtrlMakeNewWindow);
	DDX_Check(pDX, IDC_CHK_MAKE_NEW_WINDOW, m_IsNewWindow);
	DDX_Check(pDX, IDC_CHK_SUBSTRING, m_IsSubstring);
	DDX_Control(pDX, IDC_CHK_SUBSTRING, m_CtrlChkSubstring);
	DDX_Check(pDX, IDC_CHK_BRACKETS, m_IsBrackets);
	DDX_Control(pDX, IDC_CHK_BRACKETS, m_CtrlChkBrackets);
	DDX_Control(pDX, IDC_CHK_MATCH_CASE, m_CtrlMatchCase);
	DDX_Control(pDX, IDC_RADIO_AND, m_CtrlRadioAnd);
	DDX_Control(pDX, IDC_RADIO_OR, m_CtrlRadioOr);
	DDX_Control(pDX, IDC_ST_TAB_CONDITION, m_st_tab_cond_ctrl);
	DDX_Check(pDX, IDC_CHK_MATCH_CASE, m_IsMatchCase);
}


BEGIN_MESSAGE_MAP(CFindQueryDlgEx, CResizableDialog)
	//{{AFX_MSG_MAP(CFindQueryDlgEx)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_ADJUST, OnSelchangeTabAdjust)
	ON_CBN_SELCHANGE(IDC_SELECT_FIND_TYPE, OnSelchangeSelectFindType)
	ON_BN_CLICKED(ID_ADJUST_ADD, OnAdjustAdd)
	ON_BN_CLICKED(ID_ADJUST_DEL, OnAdjustDel)
	ON_BN_CLICKED(ID_ADJUST_EDIT, OnAdjustEdit)
	ON_BN_CLICKED(IDC_CHK_FIND_VERSION, OnChkFindVersion)
	ON_BN_CLICKED(ID_EXECUTE_FIND, OnExecuteFind)
	ON_BN_CLICKED(ID_SHOW_STEPQL, OnShowStepql)
	ON_BN_CLICKED(IDC_CHK_SAVE_QUERY, OnChkSaveQuery)
	ON_EN_CHANGE(IDC_EDIT_ID, OnChangeEdit)
	ON_EN_CHANGE(IDC_EDIT_NAME_QUERY, OnChangeEditNameQuery)

	ON_EN_CHANGE(IDC_EDIT_NAME, OnChangeEdit)
	ON_EN_CHANGE(IDC_EDIT_DESCR, OnChangeEdit)
	ON_EN_CHANGE(IDC_EDIT_CODE_VER, OnChangeEdit)
	ON_EN_CHANGE(IDC_EDIT_CODE_VER1, OnChangeEdit)
	ON_EN_CHANGE(IDC_EDIT_CODE_VER2, OnChangeEdit)
	ON_EN_CHANGE(IDC_EDIT_CODE_IZD, OnChangeEdit)
	ON_EN_CHANGE(IDC_EDIT_VER, OnChangeEdit)
	ON_CBN_SELCHANGE(IDC_COMBO_TYPE, OnChangeEdit)
	ON_CBN_SELCHANGE(IDC_COMBO_SOURCE, OnChangeEdit)
	//}}AFX_MSG_MAP
	//ON_NOTIFY_EX(TTN_NEEDTEXT, 0, OnToolTipShow)
	ON_BN_CLICKED(IDC_BTN_ATTR_ADD, &CFindQueryDlgEx::OnBnClickedBtnAttrAdd)
	ON_BN_CLICKED(IDC_BTN_ATTR_DEL, &CFindQueryDlgEx::OnBnClickedBtnAttrDel)
	ON_BN_CLICKED(IDC_BTN_ATTR_EDIT, &CFindQueryDlgEx::OnBnClickedBtnAttrEdit)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_ADJUST, OnDblclkListAdjust)
	ON_NOTIFY(NM_RCLICK, IDC_LIST_ADJUST, OnRclickListAdjust)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_ATTRIBUTES, OnDblclkListAttributes)
	ON_NOTIFY(NM_RCLICK, IDC_LIST_ATTRIBUTES, OnRclickListAttributes)
//	ON_BN_CLICKED(, 0, &CFindQueryDlgEx::OnHdnItemdblclickListAttributes)
ON_BN_CLICKED(IDC_CHK_SUBSTRING, &CFindQueryDlgEx::OnBnClickedChkSubstring)
ON_BN_CLICKED(IDC_CHK_MAKE_NEW_WINDOW, &CFindQueryDlgEx::OnBnClickedChkMakeNewWindow)
ON_BN_CLICKED(IDC_CHK_MAKE_TABLE_RESULT, &CFindQueryDlgEx::OnBnClickedChkMakeTableResult)
ON_WM_SIZE()
ON_BN_CLICKED(IDC_CHK_BRACKETS, &CFindQueryDlgEx::OnBnClickedChkBrackets)
ON_BN_CLICKED(IDC_RADIO_AND, &CFindQueryDlgEx::OnBnClickedRadioAndOr)
ON_BN_CLICKED(IDC_RADIO_OR, &CFindQueryDlgEx::OnBnClickedRadioAndOr)
ON_BN_CLICKED(IDC_CHK_MATCH_CASE, &CFindQueryDlgEx::OnBnClickedChkMatchCase)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFindQueryDlgEx message handlers
//   /     

BOOL CFindQueryDlgEx::OnInitDialog() 
{
	CResizableDialog::OnInitDialog();
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   
	EnableToolTips(TRUE);
	if(m_api==0) return FALSE;
	
	m_BtnFind.SetIcon(GetAplStdIco16(APLSTDICO_PLAY));
	m_BtnFind.SetFlat(FALSE);
	m_BtnCancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_BtnCancel.SetFlat(FALSE);
	m_BtnShowStepQl.SetIcon(GetAplStdIco16(APLSTDICO_STQL));
	m_BtnShowStepQl.SetFlat(FALSE);
	
	COLORMAP  cm;
	cm.from=RGB(192,192,192);
	cm.to=GetSysColor(COLOR_BTNFACE);

	if(!m_is_load_bmp)
	{
		if(aplGetBitPerPixel(this)>8)
			m_name_bmp.LoadMappedBitmap(IDB_FIND_NAME,0,&cm,1);
		else 
			m_name_bmp.LoadMappedBitmap(IDB_FIND_NAME_16,0,&cm,1);
		
		//imagelist_tab.Create(IDR_ICONS,16,2,cm.from);
		imagelist_tab.Create(IDR_ICONS,16,2,cm.from);
		imagelist_but.Create(IDR_MENU_ICONS,20,2,cm.from);
		imagelist_list_attr.Create(1,19,ILC_COLOR,1,1);
		m_is_load_bmp=true;
	}
	HBITMAP hBmpOld=m_st_header.SetBitmap(HBITMAP(m_name_bmp));
	::DeleteObject(hBmpOld);
	m_TabAdjust.SetImageList(&imagelist_tab);

	m_adj_add_icon=imagelist_but.ExtractIcon(0);
	m_adj_del_icon=imagelist_but.ExtractIcon(1);
	m_adj_edit_icon=imagelist_but.ExtractIcon(7);
	
	m_BtnAdjAdd.SetIcon( m_adj_add_icon);
	m_BtnAdjDel.SetIcon( m_adj_del_icon);
	m_BtnAdjEdit.SetIcon(m_adj_edit_icon);

	m_BtnAttrAdd.SetIcon( m_adj_add_icon);
	m_BtnAttrDel.SetIcon( m_adj_del_icon);
	m_BtnAttrEdit.SetIcon(m_adj_edit_icon);

	m_ListAttributes.SetImageList(&imagelist_list_attr,LVSIL_STATE);
/**/
	
	HWND hWnd;
	//    
	//hWnd = ::GetDlgItem(m_hWnd, IDC_LIST_ATTRIBUTES);
	//ListView_SetExtendedListViewStyle(hWnd, ListView_GetExtendedListViewStyle(hWnd) | LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES);

	RECT rect;
	//        
	m_Cmbx4Edit.SetParent(&m_ListAttributes);
	m_CmbxEdit4Edit.SetParent(&m_ListAttributes);
		
	m_Edit4Edit.SetParent(&m_ListAttributes);

	m_ListAttributes.GetWindowRect(&rect);
	int width=rect.right-rect.left-1;
	int delt;
	delt=div(width,20).quot;
	m_ListAttributes.InsertColumn(0, APL_T(" "),LVCFMT_LEFT,delt*7);
	m_ListAttributes.InsertColumn(1, APL_T(""),LVCFMT_LEFT,delt*3);
	m_ListAttributes.InsertColumn(2, APL_T(""),LVCFMT_LEFT,delt*10);


	//    
	m_list_project_types.Clear();
	apidata.GetEntityExtent(m_api->m_project_mgr->e_project_type,m_list_project_types);


	//    
	hWnd = ::GetDlgItem(m_hWnd, IDC_LIST_ADJUST);
	ListView_SetExtendedListViewStyle(hWnd, ListView_GetExtendedListViewStyle(hWnd) | LVS_EX_FULLROWSELECT /*| LVS_EX_GRIDLINES */);

	//    
	TCITEM TabCtrlItem;
	TabCtrlItem.mask = TCIF_TEXT | TCIF_PARAM;
	int is_APPROVAL=-1, is_CHARACTER=-1, is_DOCUMENTS=-1, is_RESOURCES=-1, is_BLOBS=-1, is_CLASSIF=-1;
	InsertTabAjust(0,APPROVAL);
	InsertTabAjust(1,CHARACTER);
	InsertTabAjust(2,DOCUMENTS);
	InsertTabAjust(3,CLASSIF);
// 	InsertTabAjust(4,RESOURCES);
// 	InsertTabAjust(5,BLOBS);

	LoadDataFromBuf();

	//     
	//   ,   
	//if(m_IsSubstring == TRUE)CheckSubStringCtrl();

	UpdateData(FALSE);

	if(m_mode_slave)
	{
		m_BtnShowStepQl.EnableWindow(FALSE);
		m_BtnFind.SetWindowText(_T("OK"));
		m_BtnFind.SetIcon(GetAplStdIco16(APLSTDICO_OK));
		m_edt_name_query.EnableWindow(false);
	}

	PrepareListFindOjects();

	m_CtrlMakeTableResult.EnableWindow(m_can_make_table);
	m_ChkSaveQuery.EnableWindow(m_can_save);

	m_page_num=adj_appr;
	m_TabAdjust.SetCurSel((int)m_page_num);
	
	//DrawTabPage();
	OnSelchangeSelectFindType();
	
	if(m_read_only)
	{
		m_edt_name_query.EnableWindow(FALSE);
		m_SelectFindType.EnableWindow(FALSE);
		m_ListAttributes.EnableWindow(FALSE);
		m_BtnAttrAdd.EnableWindow(FALSE);m_BtnAttrDel.EnableWindow(FALSE);m_BtnAttrEdit.EnableWindow(FALSE);
		m_BtnAdjAdd.EnableWindow(FALSE);m_BtnAdjDel.EnableWindow(FALSE);
		m_CtrlMakeTableResult.EnableWindow(FALSE);

	}
	m_changed=false;

	if(m_is_new_window != 0) m_CtrlMakeNewWindow.EnableWindow(TRUE);

 	AddAnchor(IDC_STATIC_FORM, TOP_LEFT, TOP_RIGHT);
 	AddAnchor(IDC_CHK_SUBSTRING, TOP_LEFT, TOP_LEFT);
 	AddAnchor(IDC_CHK_BRACKETS, TOP_LEFT, TOP_LEFT);
 	AddAnchor(IDC_CHK_MATCH_CASE, TOP_LEFT, TOP_LEFT);

	AddAnchor(IDC_BTN_ATTR_ADD, TOP_RIGHT, TOP_RIGHT);
	AddAnchor(IDC_BTN_ATTR_DEL, TOP_RIGHT, TOP_RIGHT);
	AddAnchor(IDC_BTN_ATTR_EDIT, TOP_RIGHT, TOP_RIGHT);
	AddAnchor(IDC_LIST_ATTRIBUTES, TOP_LEFT, MIDDLE_RIGHT);

	AddAnchor(IDC_TAB_ADJUST, MIDDLE_LEFT, MIDDLE_RIGHT);
	AddAnchor(IDC_LIST_ADJUST, MIDDLE_LEFT, BOTTOM_RIGHT);

	AddAnchor(ID_ADJUST_ADD, MIDDLE_RIGHT, MIDDLE_RIGHT);
	AddAnchor(ID_ADJUST_DEL, MIDDLE_RIGHT, MIDDLE_RIGHT);
	AddAnchor(ID_ADJUST_EDIT, MIDDLE_RIGHT, MIDDLE_RIGHT);
				
	AddAnchor(IDC_CHK_MAKE_TABLE_RESULT, BOTTOM_LEFT, BOTTOM_LEFT);
	AddAnchor(IDC_CHK_MAKE_NEW_WINDOW, BOTTOM_LEFT, BOTTOM_LEFT);

	AddAnchor(ID_EXECUTE_FIND, BOTTOM_RIGHT, BOTTOM_RIGHT);
	AddAnchor(ID_SHOW_STEPQL, BOTTOM_RIGHT, BOTTOM_RIGHT);
	AddAnchor(IDCANCEL, BOTTOM_RIGHT, BOTTOM_RIGHT);

	AddAnchor(IDC_STATIC_GROUPE_AND_OR, MIDDLE_LEFT, BOTTOM_RIGHT);
	AddAnchor(IDC_ST_TAB_CONDITION, MIDDLE_LEFT);
	AddAnchor(IDC_RADIO_AND, MIDDLE_LEFT);
	AddAnchor(IDC_RADIO_OR, MIDDLE_LEFT);
				
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

// :    CaplTranslateDialog
/*BOOL CFindQueryDlgEx::OnToolTipShow( UINT id, NMHDR * pNMHDR, LRESULT * pResult )
{
	TOOLTIPTEXT *pTTT = (TOOLTIPTEXT *)pNMHDR;
	UINT nID = pNMHDR->idFrom;
	CString buf;
	
	if (pTTT->uFlags & TTF_IDISHWND){
		nID = ::GetDlgCtrlID((HWND)nID);
// 		CString tooltip_text;
// 		tooltip_text.LoadString(nID);
		//		if(nID==IDC_CHK_NAME){m_ChkName.GetWindowText(buf);tooltip_text+=buf;}
		//pTTT->lpszText = _tcsdup(tooltip_text);
		pTTT->lpszText = (TCHAR*)nID;
		pTTT->hinst = AfxGetResourceHandle();
		return(true);
	}
	return false;
}*/

#define FO_INSERT_TYPE(user_name4type,type4type,ent_p) \
	last_f_type = new SFindObjectDef(user_name4type,type4type,ent_p);m_all_find_ojects.Add(last_f_type);\
	i=m_SelectFindType.InsertString(i, user_name4type);m_SelectFindType.SetItemData(i,(DWORD) type4type);\
	if(m_mode==FindObject_NDef){m_mode=type4type;}if(m_mode==type4type){pos=i;}i++;

#define FO_INSERT_ATTR_IN_TYPE(user_name4attr,attr_type,attr_p) \
	attr_def = new SFindAttrDef(user_name4attr,attr_type);last_f_type->list_attrs.Add(attr_def);attr_def->attr_path = new CFindAttrPath(attr_p,_T(""));attr_def->path_length=1;

#define FO_INSERT_ATTR_IN_TYPE_2(user_name4attr,attr_type,attr_p_1,ent_p_2,attr_p_2) \
	attr_def = new SFindAttrDef(user_name4attr,attr_type);last_f_type->list_attrs.Add(attr_def);attr_def->attr_path = new CFindAttrPath(attr_p_1,ent_p_2);\
	attr_def->attr_path->next_step = new CFindAttrPath(attr_p_2,_T(""));attr_def->path_length=2;

#define FO_INSERT_ATTR_IN_TYPE_3(user_name4attr,attr_type,attr_p_1,ent_p_2,attr_p_2,ent_p_3,attr_p_3) \
	attr_def = new SFindAttrDef(user_name4attr,attr_type);last_f_type->list_attrs.Add(attr_def);attr_def->attr_path = new CFindAttrPath(attr_p_1,ent_p_2);\
	attr_def->attr_path->next_step = new CFindAttrPath(attr_p_2,ent_p_3);\
	attr_def->attr_path->next_step->next_step = new CFindAttrPath(attr_p_3,_T(""));attr_def->path_length=3;

#define FO_INSERT_ATTR_IN_TYPE_TOP(user_name4attr,attr_type,attr_p,entity_top_parent,attr_top_ref) \
	attr_def = new SFindAttrDef(user_name4attr,attr_type);last_f_type->list_attrs.Add(attr_def);attr_def->attr_path = new CFindAttrPath(attr_p,_T(""));\
	attr_def->e_top_parent = entity_top_parent; attr_def->a_top_parent_ref = attr_top_ref;attr_def->path_length=1;

#define FO_INSERT_ATTR_IN_TYPE_STATE \
	FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_State,S::state); \
	attr_def->AddSelectedString(_T("")); \
	attr_def->AddSelectedString(CaplStepManager::GetWFStateName(_T("working")), _T("working")); \
	attr_def->AddSelectedString(CaplStepManager::GetWFStateName(_T("approving")), _T("approving")); \
	attr_def->AddSelectedString(CaplStepManager::GetWFStateName(_T("approved")), _T("approved")); \
	attr_def->AddSelectedString(CaplStepManager::GetWFStateName(_T("changing")), _T("changing")); \
	attr_def->AddSelectedString(CaplStepManager::GetWFStateName(_T("approving_change")), _T("approving_change")); \
	attr_def->AddSelectedString(CaplStepManager::GetWFStateName(_T("must_revision")), _T("must_revision")); \
	attr_def->AddSelectedString(CaplStepManager::GetWFStateName(_T("canceled")), _T("canceled")); \
	attr_def->AddSelectedString(CaplStepManager::GetWFStateName(_T("released")), _T("released"));



//     
void CFindQueryDlgEx::PrepareListFindOjects()
{
	int pos=-1;
	int i=0,j;
	SFindObjectDef* last_f_type=0;
	SFindAttrDef* attr_def=0;

	m_all_find_ojects.Clear();
	m_attr_types2log_rel.Clear();

	//          
	//       

	if((m_vis_mode&APL_MODE_SELECT_PRD)>0 || m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T(""),FindObject_Product,_T("product"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Id,_T(".id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Name,_T(".name"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Descr,_T(".description"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_CodeIzd,_T(".code"));
	}

	if((m_vis_mode&APL_MODE_SELECT_PDF)>0 || m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T(" "),FindObject_ProductVer,_T("apl_product_definition_formation"));

		FO_INSERT_ATTR_IN_TYPE_2(APL_T(" "),TFO_Id,_T(".of_product"),_T("product"),_T(".id"));
		FO_INSERT_ATTR_IN_TYPE_2(APL_T(" "),TFO_Name,_T(".of_product"),_T("product"),_T(".name"));
		FO_INSERT_ATTR_IN_TYPE_2(APL_T(" "),TFO_Descr,_T(".of_product"),_T("product"),_T(".description"));
		FO_INSERT_ATTR_IN_TYPE_2(APL_T(" "),TFO_CodeIzd,_T(".of_product"),_T("product"),_T(".code"));
		
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Ver,_T(".id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_VerDescr,_T(".description"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Type,_T(".formation_type"));
		FO_INSERT_ATTR_IN_TYPE(APL_T("  "),TFO_Code,_T(".code"));
		FO_INSERT_ATTR_IN_TYPE(APL_T("   1"),TFO_CodeVer1,_T(".code1"));
		FO_INSERT_ATTR_IN_TYPE(APL_T("   2"),TFO_CodeVer2,_T(".code2"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Source,_T(".make_or_buy"));
			attr_def->AddSelectedString(APL_T(" "));
			attr_def->AddSelectedString( APL_T(""));
			attr_def->AddSelectedString( APL_T(""));
			attr_def->AddSelectedString( APL_T(" "));
			attr_def->AddSelectedString( APL_T(""));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Standart,_T(".is_standard_part"));
			attr_def->AddSelectedString(APL_T(""));
			attr_def->AddSelectedString(APL_T(""));
 		FO_INSERT_ATTR_IN_TYPE_TOP(APL_T(""), TFO_RelContext, _T(".apl_frames_of_reference"), m_api->m_prd_mgr.e_pdr, m_api->m_prd_mgr.a_pdr_r_ted);

		FO_INSERT_ATTR_IN_TYPE_STATE

// 		FO_INSERT_ATTR_IN_TYPE_TOP(APL_T(": "), TFO_RelPos, _T(".id"), m_api->m_prd_mgr.e_pdr, m_api->m_prd_mgr.a_pdr_r_ted);
// 		FO_INSERT_ATTR_IN_TYPE_TOP(APL_T(":  "), TFO_RelPosId, _T(".reference_designator"),  m_api->m_prd_mgr.e_pdr, m_api->m_prd_mgr.a_pdr_r_ted);
// 		FO_INSERT_ATTR_IN_TYPE_TOP(APL_T(": "), TFO_RelName, _T(".name"),  m_api->m_prd_mgr.e_pdr, m_api->m_prd_mgr.a_pdr_r_ted);
// 		FO_INSERT_ATTR_IN_TYPE_TOP(APL_T(": "), TFO_RelDescr, _T(".description"),  m_api->m_prd_mgr.e_pdr, m_api->m_prd_mgr.a_pdr_r_ted);
	}
	if((m_vis_mode&APL_MODE_SELECT_DOC)>0 || m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T(""),FindObject_Document,_T("apl_document_revision.of_document->apl_document"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Id,_T(".id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Name,_T(".name"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Descr,_T(".description"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Part,_T(".part"));
		//FO_INSERT_ATTR_IN_TYPE_2(APL_T(" "),TFO_Type,_T(".kind"),_T("document_type"),_T(".product_data_type"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Type,_T(".kind"));
		FO_INSERT_ATTR_IN_TYPE(APL_T("ooe o a oea"),TFO_DocCode1,_T(".add_document_type_code"));
			attr_def->AddSelectedString( APL_T("2D"));
			attr_def->AddSelectedString( APL_T("3D"));
			attr_def->AddSelectedString( APL_T(""));
			attr_def->AddSelectedString( APL_T(""));
			attr_def->AddSelectedString( APL_T(""));
			attr_def->AddSelectedString( APL_T(""));

		FO_INSERT_ATTR_IN_TYPE(APL_T("o o-a  ac. o xapa. co"),TFO_DocCode2,_T(".code_doc_in_depending_of_disposition"));
			attr_def->AddSelectedString(APL_T("0 - "),_T("0"));
			attr_def->AddSelectedString(APL_T("1 - "),_T("1"));
			attr_def->AddSelectedString(APL_T("2 - "),_T("2"));
			attr_def->AddSelectedString(APL_T("3 - "),_T("3"));
			attr_def->AddSelectedString(APL_T("4 - "),_T("4"));

		FO_INSERT_ATTR_IN_TYPE(APL_T("   "),TFO_Standart,_T(".incl_in_doc"));
			attr_def->AddSelectedString(APL_T(""));
			attr_def->AddSelectedString(APL_T(" "));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Groupe,_T(".group"));
			attr_def->AddSelectedString(APL_T(""));
			attr_def->AddSelectedString(APL_T(""));

		FO_INSERT_ATTR_IN_TYPE(APL_T(". "),TFO_CodeVer1,_T(".inv_num")); // string
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_ProjKurator,_T(".from")); // select
			attr_def->SetFuncParam(TSI_Persorg,0,APL_T("  "));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_ProjExecutors,_T(".recipients")); // select TFO_ProjCustomer
			attr_def->SetFuncParam(TSI_Persorg,0,APL_T("  "));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_DocUrgency,_T(".urgency")); // string -    
			attr_def->AddSelectedString(APL_T(""));
			attr_def->AddSelectedString(APL_T(""));
			attr_def->AddSelectedString(APL_T(""));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Date2,_T(".date_of_execution_required")); // string - 
		FO_INSERT_ATTR_IN_TYPE(APL_T(" . ."),TFO_Date3,_T(".date_of_execution_planned")); // string - 
		FO_INSERT_ATTR_IN_TYPE(APL_T(" . ."),TFO_Date4,_T(".date_of_execution_fact")); // string - 

		FO_INSERT_ATTR_IN_TYPE_2(APL_T(" "),TFO_Ver,_T(".active"),_T("apl_digital_document"),_T(".revision_id"));
		FO_INSERT_ATTR_IN_TYPE_2(APL_T("  "),TFO_VerDescr,_T(".active"),_T("apl_digital_document"),_T(".description"));
		FO_INSERT_ATTR_IN_TYPE_2(APL_T(""),TFO_Label,_T(".active"),_T("apl_digital_document"),_T(".label_name"));//  - 
		FO_INSERT_ATTR_IN_TYPE_2(APL_T(""),TFO_Date1,_T(".active"),_T("apl_digital_document"),_T(".src_date"));  //  -  
		FO_INSERT_ATTR_IN_TYPE_2(APL_T(""),TFO_VerList,_T(".active"),_T("apl_digital_document"),_T(".sheets"));  //  - 
		FO_INSERT_ATTR_IN_TYPE_2(APL_T(""),TFO_VerLists,_T(".active"),_T("apl_digital_document"),_T(".total_sheets_count"));//  - 
		FO_INSERT_ATTR_IN_TYPE_2(APL_T(""),TFO_VerFormat,_T(".active"),_T("apl_digital_document"),_T(".format"));//  - 
			attr_def->AddSelectedString( APL_T("A1"));
			attr_def->AddSelectedString( APL_T("A2"));
			attr_def->AddSelectedString( APL_T("A3"));
			attr_def->AddSelectedString( APL_T("A4"));
			attr_def->AddSelectedString( APL_T("A5"));
			attr_def->AddSelectedString( APL_T("A6"));
			attr_def->AddSelectedString( APL_T("A7"));

		FO_INSERT_ATTR_IN_TYPE_2(APL_T(""),TFO_VerLitera,_T(".active"),_T("apl_digital_document"),_T(".litera"));//  - 

		FO_INSERT_ATTR_IN_TYPE_3(APL_T("  "),TFO_CodeIzd,_T(".active"),_T("apl_document_revision"),_T(".access_form"),_T("apl_stored_document"),_T(".file_name"));
		
		FO_INSERT_ATTR_IN_TYPE_TOP(APL_T(""), TFO_RelContext, _T(".apl_frames_of_reference"), m_api->m_doc_mgr.e_apl_doc_ref, m_api->m_doc_mgr.a_apl_doc_ref_doc);

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_DocMaillist,_T(".mail_list")); // string - 

		FO_INSERT_ATTR_IN_TYPE_STATE

	}

	if((m_vis_mode&APL_MODE_SELECT_LOT)>0 || m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T(" "),FindObject_Lot,_T("apl_lot"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Id,_T(".id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Descr,_T(".description"));

	}

	if((m_vis_mode&APL_MODE_SELECT_PRDINST)>0 || m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T(" "),FindObject_ProductInst,_T("apl_product_instance"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Id,_T(".id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Name,_T(".serial_number"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Descr,_T(".description"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Date1,_T(".date_time"));

		FO_INSERT_ATTR_IN_TYPE_3(APL_T(" "),TFO_Code,_T(".formation"),_T("apl_product_definition_formation"),_T(".of_product"),_T("product"),_T(".id"));
		FO_INSERT_ATTR_IN_TYPE_3(APL_T(" "),TFO_CodeVer1,_T(".formation"),_T("apl_product_definition_formation"),_T(".of_product"),_T("product"),_T(".name"));
		FO_INSERT_ATTR_IN_TYPE_3(APL_T(" "),TFO_CodeVer2,_T(".formation"),_T("apl_product_definition_formation"),_T(".of_product"),_T("product"),_T(".description"));
		FO_INSERT_ATTR_IN_TYPE_3(APL_T(" "),TFO_CodeIzd,_T(".formation"),_T("apl_product_definition_formation"),_T(".of_product"),_T("product"),_T(".code"));
	}
	if((m_vis_mode&APL_MODE_SELECT_BP)>0 || m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T("-"),FindObject_BP,_T("apl_business_process_version.process->apl_business_process"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Id,_T(".id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Name,_T(".name"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Descr,_T(".description"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Code,_T(".code"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Label,_T(".label"));
		//FO_INSERT_ATTR_IN_TYPE_2(APL_T(" "),TFO_Type,_T(".type"),_T("apl_business_process_type"),_T(".name"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Type,_T(".type"));

		FO_INSERT_ATTR_IN_TYPE_STATE
	}
	if((m_vis_mode&APL_MODE_SELECT_BPINST)>0 || m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T(" -"),FindObject_BPInst,_T("apl_business_process_instance"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Id,_T(".id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Name,_T(".name"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Descr,_T(".description"));		
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Date1,_T(".date_time"));		
	}
	if((m_vis_mode&APL_MODE_SELECT_CATEGORY)>0 || m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T(""),FindObject_Category,_T("product_related_product_category"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Id,_T(".id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Name,_T(".name"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Descr,_T(".description"));		
	}
	if((m_vis_mode&APL_MODE_SELECT_FOLDER)>0 || m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T(""),FindObject_Folder,_T("apl_folder"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Name,_T(".name"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Descr,".description");
	}
	if((m_vis_mode&APL_MODE_SELECT_PROJECT)>0 || m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T(""),FindObject_Project,_T("apl_project"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Id,_T(".id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Name,_T(".name"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Descr,_T(".description"));		
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Type,_T(".type"));	

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_VerFormat,_T(".state"));	
			attr_def->AddSelectedString( APL_T(""));
			attr_def->AddSelectedString( APL_T(" "));
			attr_def->AddSelectedString( APL_T(""));
			attr_def->AddSelectedString( APL_T(""));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Code,_T(".number"));	
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_DocCode1,_T(".control_type"));	
			attr_def->AddSelectedString( APL_T(" "));
			attr_def->AddSelectedString( APL_T("  "));
			attr_def->AddSelectedString( APL_T(" "));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_ProjCustomer,_T(".customer"));	
			attr_def->SetFuncParam(TSI_Persorg,0,APL_T("  "));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_ProjKurator,_T(".kurator"));	
			attr_def->SetFuncParam(TSI_Persorg,0,APL_T("  "));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_ProjExecutors,_T(".executors"));	
			attr_def->SetFuncParam(TSI_Persorg,0,APL_T("  "));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_ProjCoexecutors,_T(".co_executors"));	
			attr_def->SetFuncParam(TSI_Persorg,0,APL_T("  "));

		FO_INSERT_ATTR_IN_TYPE(APL_T("  -  "),TFO_Date1,_T(".date_planned_begin"));
		FO_INSERT_ATTR_IN_TYPE(APL_T("  -  "),TFO_Date2,_T(".date_actual_begin"));
		FO_INSERT_ATTR_IN_TYPE(APL_T("  -  "),TFO_Date3,_T(".date_planned_end"));
		FO_INSERT_ATTR_IN_TYPE(APL_T("  -  "),TFO_Date4,_T(".date_actual_end"));

	}

	//        -     :-(
	//        " "
	if((m_vis_mode==0 )&& m_api->m_data.GetEntityBN(_T("apl_action"))!=0)
	{

		///////////////	 
		FO_INSERT_TYPE(APL_T(""),FindObject_Task,_T("apl_task"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Id,_T(".id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Name,_T(".name"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Descr,_T(".description"));		

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_ProjCustomer,_T(".manager"));	
			attr_def->SetFuncParam(TSI_Persorg,0,APL_T("  "));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_ProjKurator,_T(".performer"));	
			attr_def->SetFuncParam(TSI_Persorg,0,APL_T("  "));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Date1,_T(".start_date"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Date2,_T(".finish_date"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Date3,_T(".end_date"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_DocCode1,_T(".priority"));
			attr_def->AddSelectedString( APL_T(""),_T("low"));
			attr_def->AddSelectedString( APL_T(""),_T("medium"));
			attr_def->AddSelectedString( APL_T(""),_T("hight"));

		FO_INSERT_ATTR_IN_TYPE_2(APL_T(" "),TFO_ProcTemplate,_T(".of_process"),_T("apl_process"),_T(".of_process_template"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" ( )"),TFO_ProcActivity,_T(".of_activity"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_DocCode2,_T(".state"));
			attr_def->AddSelectedString( APL_T(""),_T("complete"));
			attr_def->AddSelectedString( APL_T(""),_T("cancel"));
			attr_def->AddSelectedString( APL_T(""),_T("suspend"));
			attr_def->AddSelectedString( APL_T(""),_T("work"));
			attr_def->AddSelectedString( APL_T(""),_T("active"));

		FO_INSERT_ATTR_IN_TYPE(APL_T("  ?"),TFO_ProcTaskExpired,_T(".finish_date"));
			attr_def->AddSelectedString(APL_T(""));
			attr_def->AddSelectedString(APL_T(""));

		FO_INSERT_ATTR_IN_TYPE(APL_T("   "),TFO_ProcTaskExpiredNDays,_T(".finish_date"));



		///////////////	
		FO_INSERT_TYPE(APL_T(""),FindObject_Process,_T("apl_process"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Id,_T(".id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Name,_T(".name"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Descr,_T(".description"));		

		CaplEntity *e_apl_task = m_api->m_data.GetEntityBN(_T("apl_task"));
		CaplAttr *a_apl_task__of_process = m_api->m_data.GetAttrDefinition(e_apl_task,_T("of_process"));

		if(e_apl_task!=0 && a_apl_task__of_process!=0)
		{
			FO_INSERT_ATTR_IN_TYPE_TOP(APL_T("  "),TFO_ProcTaskId,_T(".id"),e_apl_task,a_apl_task__of_process);
			FO_INSERT_ATTR_IN_TYPE_TOP(APL_T("  "),TFO_ProcTaskName,_T(".name"),e_apl_task,a_apl_task__of_process);
			FO_INSERT_ATTR_IN_TYPE_TOP(APL_T("  "),TFO_ProcTaskPerformer,_T(".performer"),e_apl_task,a_apl_task__of_process);
				attr_def->SetFuncParam(TSI_Persorg,0,APL_T(" "));

			FO_INSERT_ATTR_IN_TYPE_TOP(APL_T("  ( )"),TFO_ProcActivity,_T(".of_activity"),e_apl_task,a_apl_task__of_process);


			FO_INSERT_ATTR_IN_TYPE_TOP(APL_T("  ?"),TFO_ProcTaskExpired,_T(".finish_date"),e_apl_task,a_apl_task__of_process);
				attr_def->AddSelectedString(APL_T(""));
				attr_def->AddSelectedString(APL_T(""));

			FO_INSERT_ATTR_IN_TYPE_TOP(APL_T("     "),TFO_ProcTaskExpiredNDays,_T(".finish_date"),e_apl_task,a_apl_task__of_process);

		}
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_ProcTemplate,_T(".of_process_template"));		

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_ProcState,_T(".state"));
			attr_def->AddSelectedString( APL_T(""),_T("initiated"));
			attr_def->AddSelectedString( APL_T(""),_T("running"));
			attr_def->AddSelectedString( APL_T(""),_T("suspended"));
			attr_def->AddSelectedString( APL_T(""),_T("terminated"));
			attr_def->AddSelectedString( APL_T(""),_T("completed"));
			attr_def->AddSelectedString( APL_T(""),_T("jammed"));

		FO_INSERT_ATTR_IN_TYPE_3(APL_T(" "),TFO_ProcRefusalCulprit,_T(".work_objects"),_T("apl_work_object"),_T(".object"),_T("apl_refusal"),_T(".culprit"));
			attr_def->SetFuncParam(TSI_Persorg,0,APL_T(" "));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_ProcOwner,_T(".owner"));
			attr_def->SetFuncParam(TSI_Persorg,0,APL_T(" "));


		///////////////	
		FO_INSERT_TYPE(APL_T(""),FindObject_Refusal,_T("apl_refusal"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Type,_T(".refusal_type"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_RefDocType,_T(".doc_type"));
			attr_def->AddSelectedString(APL_T(""));
			attr_def->AddSelectedString(APL_T(" "));
			attr_def->AddSelectedString(APL_T(""));		
			attr_def->AddSelectedString(APL_T(""));		
			attr_def->AddSelectedString(APL_T("  "));		
			attr_def->AddSelectedString(APL_T(""));		


		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_RefDocNum,_T(".doc_num"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Date1,_T(".doc_date"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_RefState,_T(".state"));
			attr_def->AddSelectedString(APL_T(""));
			attr_def->AddSelectedString(APL_T(""));
			attr_def->AddSelectedString(APL_T(" "));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Descr,_T(".description"));	

		FO_INSERT_ATTR_IN_TYPE(APL_T(",   "),TFO_RefOrg,_T(".org"));	//--- &CaplFaultMgr::SelectOrg; 
			attr_def->SetFuncParam(TSI_Org,0,APL_T(" ,   "));
		
		FO_INSERT_ATTR_IN_TYPE(APL_T(",   "),TFO_RefSector,_T(".sector"));	//--- &CaplFaultMgr::SelectOrg; 
			attr_def->SetFuncParam(TSI_Org,0,APL_T(" ,   "));
		
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_RefStage,_T(".stage"));	//!!!! CaplFaultMgr::SelectClassifier 
			attr_def->SetFuncParam(TSI_ClassifierLevel,m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_STAGE_CLASSIFIER_LVL), REFUSAL_STAGE_CLASSIFIER_LVL);

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Date2,_T(".date_detection"));	//---  
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Date3,_T(".date_removal"));	//---  
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_VerDescr,_T(".ext_view"));	//---  
		FO_INSERT_ATTR_IN_TYPE_2(APL_T(" "),TFO_RefMainPDF,_T(".planer"),_T("apl_product_instance"),_T(".formation"));	//!!!! CaplFaultMgr::SelectMainPdf 
			attr_def->SetFuncParam(TSI_Pdf,0,_T(""));
		FO_INSERT_ATTR_IN_TYPE(APL_T("  "),TFO_RefMainItem,_T(".planer"));	//!!!! CaplFaultMgr::SelectItem 
			attr_def->SetFuncParam(TSI_Item,0,_T(""));

// 		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_RefSystem,_T(".system"));	//!!!! CaplFaultMgr::SelectSystem 
// 			attr_def->SetFuncParam(TSI_System,0,_T(""));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" ()"),TFO_RefFailedItem,_T(".item"));	//!!!! CaplFaultMgr::SelectItem 
			attr_def->SetFuncParam(TSI_Item,0,_T(""));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_RefFailedPart,_T(".part"));	//!!!! CaplFaultMgr::SelectItem 
			attr_def->SetFuncParam(TSI_Item,0,_T(""));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_RefConditions,_T(".conditions"));	//!!!!  
			attr_def->SetFuncParam(TSI_ClassifierLevel,m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_CONDITIONS_CLASSIFIER_LVL),REFUSAL_CONDITIONS_CLASSIFIER_LVL);

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_RefDof,_T(".dof"));	//!!!!  
			attr_def->SetFuncParam(TSI_ClassifierLevel,m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_DOF_CLASSIFIER_LVL),REFUSAL_DOF_CLASSIFIER_LVL);

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_RefFaultReason,_T(".faultreason"));	//!!!!  
			attr_def->SetFuncParam(TSI_ClassifierLevel,m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_REASON_CLASSIFIER_LVL),REFUSAL_REASON_CLASSIFIER_LVL);

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_RefMethod,_T(".method"));	//!!!!  
			attr_def->SetFuncParam(TSI_ClassifierLevel,m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_METHOD_CLASSIFIER_LVL),REFUSAL_METHOD_CLASSIFIER_LVL);

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_RefConsequence,_T(".consequences"));	//!!!!  
			attr_def->SetFuncParam(TSI_ClassifierLevel,m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_CONSEQ_CLASSIFIER_LVL),REFUSAL_CONSEQ_CLASSIFIER_LVL);

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_RefCulprit,_T(".culprit"));	//---  CaplFaultMgr::SelectOrg
			attr_def->SetFuncParam(TSI_Org,0,APL_T("  "));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_RefManif,_T(".manifestation"));	//!!!!  
			attr_def->SetFuncParam(TSI_ClassifierLevel,m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_MANIF_CLASSIFIER_LVL),REFUSAL_MANIF_CLASSIFIER_LVL);

		FO_INSERT_ATTR_IN_TYPE(APL_T("  "),TFO_RefManifDescr,_T(".manif_str"));	//!!!!  

	}
	if((m_vis_mode&APL_MODE_SELECT_PERSON)>0 || m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T(""),FindObject_Person,_T("person"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Id,_T(".id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Name,_T(".last_name"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Descr,_T(".first_name"));		
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Ver,_T(".middle_names"));	
	}
	if((m_vis_mode&APL_MODE_SELECT_ORG)>0 || m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T(" "),FindObject_Organization,_T("organization"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Id,_T(".id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Name,_T(".name"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Descr,_T(".description"));		
	}

	if((m_vis_mode&APL_MODE_SELECT_CHANGE)>0 || m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T(""),FindObject_Change,_T("apl_change"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Id,_T(".id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Name,_T(".name"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Type,_T(".type"));
			attr_def->AddSelectedString(APL_T(""));
			attr_def->AddSelectedString(APL_T(""));
			attr_def->AddSelectedString(APL_T(""));
			attr_def->AddSelectedString(APL_T(""));


		//FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_ProjCustomer,_T(".id"));
		//attr_def->SetFuncParam(TSI_Persorg,0,APL_T("  "));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_ProjKurator,_T(".create_autor"));
			attr_def->SetFuncParam(TSI_Persorg,0,APL_T("  "));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Ver,_T(".doc_id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Date1,_T(".apply_date"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_CodeVer1,_T(".org_code"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_CodeVer2,_T(".grp_num"));
		FO_INSERT_ATTR_IN_TYPE(APL_T("  "),TFO_Code,_T(".basis_code"));
		FO_INSERT_ATTR_IN_TYPE(APL_T("  "),TFO_VerDescr,_T(".basis"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Part,_T(".usage"));
		FO_INSERT_ATTR_IN_TYPE(APL_T("  "),TFO_Label,_T(".complect_num"));
		// FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_,_T(".list"));
		FO_INSERT_ATTR_IN_TYPE(APL_T("  "),TFO_VerList,_T(".stock"));
		FO_INSERT_ATTR_IN_TYPE(APL_T("  "),TFO_VerLists,_T(".stock_introd"));

		FO_INSERT_ATTR_IN_TYPE(APL_T("  "),TFO_CodeIzd,_T(".to_date"));
		FO_INSERT_ATTR_IN_TYPE(APL_T("   "),TFO_VerLitera,_T(".otd_date"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_StrExt,_T(".critical_date"));

		FO_INSERT_ATTR_IN_TYPE(APL_T("  "),TFO_Date2,_T(".validity_pi_date"));
		if(m_api->m_options_mgr.CheckInstallCode(APL_NO_T(""))) 
		{
			FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_InAggr,_T(".dependent_items"));
			CString sSprav;
			CaplInstance *sprav=0;
			TypeSelectInstance type_select = TSI_AllTypes;
			m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\  "), sSprav);
			if(sSprav!=_T(""))
			{
				sprav=m_api->m_classifier_mgr.GetClassifierSystemById(sSprav);
				//if(0==sprav) AfxMessageBox(APL_NO_T("      '\\  '!!!"));
				if(0!=sprav)type_select = TSI_ClassifierItem;
			}
			attr_def->SetFuncParam(type_select,sprav,APL_T("  "));
		}

	}
	if( m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T(""),FindObject_Find,_T("apl_query"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Name,_T(".name"));
	}
	if( m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T(" "),FindObject_CombinedTable,_T("apl_combined_table"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(" "),TFO_Name,_T(".name"));
	}

	if((m_vis_mode&APL_MODE_SELECT_CLASSIF_SYSTEM)>0 || m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T(""),FindObject_ClassifSystem,_T("apl_classifier_system"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Id,_T(".id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Name,_T(".name"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Descr,_T(".description"));		
	}
	if((m_vis_mode&APL_MODE_SELECT_CLASSIF_ELEMENT)>0 || m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T("  "),FindObject_ClassifLevel,_T("apl_classifier_level"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Id,_T(".id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Name,_T(".name"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Descr,_T(".description"));		
	}
	if((m_vis_mode&APL_MODE_SELECT_REQUIREMENT)>0 || m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T(""),FindObject_Requirement,_T("apl_requirement"));

		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Id,_T(".id"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Name,_T(".name"));
		FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Descr,_T(".description"));		

		FO_INSERT_ATTR_IN_TYPE_STATE
	}
	if( m_vis_mode==0)
	{
		FO_INSERT_TYPE(APL_T("  "),FindObject_All,_T(""));
	}

// 
// 	FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Id,);
// 	FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Name,);
// 	FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Descr,);		
// 	FO_INSERT_ATTR_IN_TYPE(APL_T(""),TFO_Descr,);		
// 

	if(pos==-1)pos=0;
	//  
	m_SelectFindType.SetCurSel(pos);
	if(i==1){
		//     
		m_SelectFindType.EnableWindow(FALSE);
		m_single_mode=true;
	}

	
	//        
	//       ,    
	m_attr_types2log_rel.Add(TFO_Id,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_Id,CaplQLQuery::aplLIKE,true);
	m_attr_types2log_rel.Add(TFO_Id,CaplQLQuery::aplLIKELEFT);
	m_attr_types2log_rel.Add(TFO_Id,CaplQLQuery::aplLIKERIGHT);
	m_attr_types2log_rel.Add(TFO_Id,CaplQLQuery::aplNOTEQUAL);
	m_attr_types2log_rel.Add(TFO_Id,CaplQLQuery::aplNOTLIKE);
	m_attr_types2log_rel.Add(TFO_Id,CaplQLQuery::aplNOTLIKELEFT);
	m_attr_types2log_rel.Add(TFO_Id,CaplQLQuery::aplNOTLIKERIGHT);
//	m_attr_types2log_rel.Add(TFO_Id,CaplQLQuery::aplLOGICAL);

	m_attr_types2log_rel.Add(TFO_Name,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_Name,CaplQLQuery::aplLIKE,true);
	m_attr_types2log_rel.Add(TFO_Name,CaplQLQuery::aplLIKELEFT);
	m_attr_types2log_rel.Add(TFO_Name,CaplQLQuery::aplLIKERIGHT);
	m_attr_types2log_rel.Add(TFO_Name,CaplQLQuery::aplNOTEQUAL);
	m_attr_types2log_rel.Add(TFO_Name,CaplQLQuery::aplNOTLIKE);
	m_attr_types2log_rel.Add(TFO_Name,CaplQLQuery::aplNOTLIKELEFT);
	m_attr_types2log_rel.Add(TFO_Name,CaplQLQuery::aplNOTLIKERIGHT);
//	m_attr_types2log_rel.Add(TFO_Name,CaplQLQuery::aplLOGICAL);

	m_attr_types2log_rel.Add(TFO_Type,CaplQLQuery::aplEQUAL,true);
	m_attr_types2log_rel.Add(TFO_Type,CaplQLQuery::aplNOTEQUAL);
	m_attr_types2log_rel.Add(TFO_Type,CaplQLQuery::aplNOLOGREL);
//?	pos_added=m_CmbxStType.AddString( APL_T(" "));m_CmbxStType.SetItemData(pos_added,CaplQLQuery::aplNOTEXIST);

	m_attr_types2log_rel.Add(TFO_Source,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_Source,CaplQLQuery::aplNOTEQUAL);

	m_attr_types2log_rel.Add(TFO_Standart,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_Groupe,CaplQLQuery::aplEQUAL);

	m_attr_types2log_rel.Add(TFO_InAggr,CaplQLQuery::aplLIKE);

	m_attr_types2log_rel.Add(TFO_VerFormat,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_VerFormat,CaplQLQuery::aplNOTEQUAL);

	m_attr_types2log_rel.Add(TFO_DocCode1,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_DocCode1,CaplQLQuery::aplNOTEQUAL);

	m_attr_types2log_rel.Add(TFO_DocCode2,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_DocCode2,CaplQLQuery::aplNOTEQUAL);

	m_attr_types2log_rel.Add(TFO_RelContext,CaplQLQuery::aplIN);

	m_attr_types2log_rel.Add(TFO_ProjCustomer,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_ProjCustomer,CaplQLQuery::aplNOTEQUAL);
	m_attr_types2log_rel.Add(TFO_ProjKurator,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_ProjKurator,CaplQLQuery::aplNOTEQUAL);

	m_attr_types2log_rel.Add(TFO_ProjExecutors,CaplQLQuery::aplLIKE);
	m_attr_types2log_rel.Add(TFO_ProjCoexecutors,CaplQLQuery::aplLIKE);

	m_attr_types2log_rel.Add(TFO_Date1,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_Date1,CaplQLQuery::aplNOTEQUAL);
	m_attr_types2log_rel.Add(TFO_Date1,CaplQLQuery::aplSMALL);
	m_attr_types2log_rel.Add(TFO_Date1,CaplQLQuery::aplBIG);
	m_attr_types2log_rel.Add(TFO_Date1,CaplQLQuery::aplSMALLEQUAL);
	m_attr_types2log_rel.Add(TFO_Date1,CaplQLQuery::aplBIGEQUAL);
	m_attr_types2log_rel.Add(TFO_Date1,CaplQLQuery::aplINDIAPAZON);
	m_attr_types2log_rel.Add(TFO_Date1,CaplQLQuery::aplNOLOGREL);

	m_attr_types2log_rel.Add(TFO_Date2,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_Date2,CaplQLQuery::aplNOTEQUAL);
	m_attr_types2log_rel.Add(TFO_Date2,CaplQLQuery::aplSMALL);
	m_attr_types2log_rel.Add(TFO_Date2,CaplQLQuery::aplBIG);
	m_attr_types2log_rel.Add(TFO_Date2,CaplQLQuery::aplSMALLEQUAL);
	m_attr_types2log_rel.Add(TFO_Date2,CaplQLQuery::aplBIGEQUAL);
	m_attr_types2log_rel.Add(TFO_Date2,CaplQLQuery::aplINDIAPAZON);
	m_attr_types2log_rel.Add(TFO_Date2,CaplQLQuery::aplNOLOGREL);

	m_attr_types2log_rel.Add(TFO_Date3,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_Date3,CaplQLQuery::aplNOTEQUAL);
	m_attr_types2log_rel.Add(TFO_Date3,CaplQLQuery::aplSMALL);
	m_attr_types2log_rel.Add(TFO_Date3,CaplQLQuery::aplBIG);
	m_attr_types2log_rel.Add(TFO_Date3,CaplQLQuery::aplSMALLEQUAL);
	m_attr_types2log_rel.Add(TFO_Date3,CaplQLQuery::aplBIGEQUAL);
	m_attr_types2log_rel.Add(TFO_Date3,CaplQLQuery::aplINDIAPAZON);
	m_attr_types2log_rel.Add(TFO_Date3,CaplQLQuery::aplNOLOGREL);

	m_attr_types2log_rel.Add(TFO_Date4,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_Date4,CaplQLQuery::aplNOTEQUAL);
	m_attr_types2log_rel.Add(TFO_Date4,CaplQLQuery::aplSMALL);
	m_attr_types2log_rel.Add(TFO_Date4,CaplQLQuery::aplBIG);
	m_attr_types2log_rel.Add(TFO_Date4,CaplQLQuery::aplSMALLEQUAL);
	m_attr_types2log_rel.Add(TFO_Date4,CaplQLQuery::aplBIGEQUAL);
	m_attr_types2log_rel.Add(TFO_Date4,CaplQLQuery::aplINDIAPAZON);
	m_attr_types2log_rel.Add(TFO_Date4,CaplQLQuery::aplNOLOGREL);

	m_attr_types2log_rel.Add(TFO_DocUrgency,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_DocUrgency,CaplQLQuery::aplNOTEQUAL);

	m_attr_types2log_rel.Add(TFO_RefDocType,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_RefDocType,CaplQLQuery::aplNOTEQUAL);

	m_attr_types2log_rel.Add(TFO_RefState,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_RefState,CaplQLQuery::aplNOTEQUAL);

	m_attr_types2log_rel.Add(TFO_RefOrg,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_RefOrg,CaplQLQuery::aplNOTEQUAL);

	m_attr_types2log_rel.Add(TFO_RefSector,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_RefSector,CaplQLQuery::aplNOTEQUAL);

	m_attr_types2log_rel.Add(TFO_RefCulprit,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_RefCulprit,CaplQLQuery::aplNOTEQUAL);
	
	m_attr_types2log_rel.Add(TFO_RefStage,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_RefStage,CaplQLQuery::aplNOTEQUAL);
	
	m_attr_types2log_rel.Add(TFO_RefMainPDF,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_RefMainPDF,CaplQLQuery::aplNOTEQUAL);
	
	m_attr_types2log_rel.Add(TFO_RefMainItem,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_RefMainItem,CaplQLQuery::aplNOTEQUAL);
	
// 	m_attr_types2log_rel.Add(TFO_RefSystem,CaplQLQuery::aplEQUAL);
// 	m_attr_types2log_rel.Add(TFO_RefSystem,CaplQLQuery::aplNOTEQUAL);
	
	m_attr_types2log_rel.Add(TFO_RefFailedItem,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_RefFailedItem,CaplQLQuery::aplNOTEQUAL);
	
	m_attr_types2log_rel.Add(TFO_RefFailedPart,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_RefFailedPart,CaplQLQuery::aplNOTEQUAL);
	
	m_attr_types2log_rel.Add(TFO_RefConditions,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_RefConditions,CaplQLQuery::aplNOTEQUAL);
	
	m_attr_types2log_rel.Add(TFO_RefDof,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_RefDof,CaplQLQuery::aplNOTEQUAL);
	
	m_attr_types2log_rel.Add(TFO_RefFaultReason,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_RefFaultReason,CaplQLQuery::aplNOTEQUAL);
	
	m_attr_types2log_rel.Add(TFO_RefMethod,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_RefMethod,CaplQLQuery::aplNOTEQUAL);
	
	m_attr_types2log_rel.Add(TFO_RefConsequence,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_RefConsequence,CaplQLQuery::aplNOTEQUAL);
	
	m_attr_types2log_rel.Add(TFO_RefManif,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_RefManif,CaplQLQuery::aplNOTEQUAL);

	m_attr_types2log_rel.Add(TFO_ProcState,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_ProcState,CaplQLQuery::aplNOTEQUAL);

	m_attr_types2log_rel.Add(TFO_ProcTemplate,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_ProcTemplate,CaplQLQuery::aplNOTEQUAL);

	m_attr_types2log_rel.Add(TFO_ProcActivity,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_ProcActivity,CaplQLQuery::aplNOTEQUAL);

	m_attr_types2log_rel.Add(TFO_ProcTaskPerformer,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_ProcTaskPerformer,CaplQLQuery::aplNOTEQUAL);

	m_attr_types2log_rel.Add(TFO_ProcTaskExpired,CaplQLQuery::aplEQUAL);

	m_attr_types2log_rel.Add(TFO_ProcTaskExpiredNDays,CaplQLQuery::aplSMALLEQUAL);
	m_attr_types2log_rel.Add(TFO_ProcTaskExpiredNDays,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_ProcTaskExpiredNDays,CaplQLQuery::aplBIGEQUAL);

	m_attr_types2log_rel.Add(TFO_ProcRefusalCulprit,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_ProcRefusalCulprit,CaplQLQuery::aplNOTEQUAL);

	m_attr_types2log_rel.Add(TFO_ProcOwner,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_ProcOwner,CaplQLQuery::aplNOTEQUAL);

	m_attr_types2log_rel.Add(TFO_DocMaillist,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_DocMaillist,CaplQLQuery::aplLIKE);

	m_attr_types2log_rel.Add(TFO_State,CaplQLQuery::aplEQUAL);
	m_attr_types2log_rel.Add(TFO_State,CaplQLQuery::aplNOTEQUAL);


	//    ,        -   
	for(i=0;i<m_all_find_ojects.Size;i++)
	{
		last_f_type = m_all_find_ojects.GetAt(i);
		if(last_f_type == 0) continue;
		for(j=0;j<last_f_type->list_attrs.Size;j++)
		{
			attr_def = last_f_type->list_attrs.GetAt(j);
			if(attr_def == 0) continue;
			if(!m_attr_types2log_rel.Is(attr_def->type))
			{
				m_attr_types2log_rel.Add(attr_def->type,CaplQLQuery::aplEQUAL);
				m_attr_types2log_rel.Add(attr_def->type,CaplQLQuery::aplLIKE,true);
				m_attr_types2log_rel.Add(attr_def->type,CaplQLQuery::aplLIKELEFT);
				m_attr_types2log_rel.Add(attr_def->type,CaplQLQuery::aplLIKERIGHT);
				m_attr_types2log_rel.Add(attr_def->type,CaplQLQuery::aplNOTEQUAL);
				m_attr_types2log_rel.Add(attr_def->type,CaplQLQuery::aplNOTLIKE);
			}
		}
	}

// 	m_attr_types2log_rel.Add(,
// 	m_attr_types2log_rel.Add(,
// 	m_attr_types2log_rel.Add(,
// 	m_attr_types2log_rel.Add(,


}


void CFindQueryDlgEx::OnChkSaveQuery() 
{
	// TODO: Add your control notification handler code here
	m_changed=true;
	//m_edt_name_query.EnableWindow(m_ChkSaveQuery.GetCheck());
	//m_edt_descr_query.EnableWindow(m_ChkSaveQuery.GetCheck());
}

void CFindQueryDlgEx::OnChkFindVersion() 
{
	// TODO: Add your control notification handler code here
	m_changed=true;
	OnSelchangeSelectFindType();
}

void CFindQueryDlgEx::PrintDateValues(bool edit2date,CString &str_val)
{
	if( edit2date )
	{
		str_val = m_Date4Edit.Format(APL_T(" %d.%m.%Y  ")) + m_Date4Edit2.Format(_T("%d.%m.%Y"));
	}
	else
	{
		str_val = m_Date4Edit.Format(_T("%d.%m.%Y"));
	}
}


//    -      
void CFindQueryDlgEx::OnSelchangeSelectFindType() 
{
	// TODO: Add your control notification handler code here
	m_changed=true;
	TypeFindObject old_mode=m_mode;
	CString str_val;
	CaplInstance *curr_type_inst;
	SFindAttrDef *attr_def=0;
	CaplValue value,value2;
	aplExtent ext;
	CaplInstance* inst;
	CaplQLQuery::aplQLLogRelation val_log_rel = CaplQLQuery::aplNOLOGREL;
	int i,k,int_val;
	i=m_SelectFindType.GetCurSel();

	if(!m_single_mode)
	{
		m_mode=(TypeFindObject)m_SelectFindType.GetItemData(i);
	}

	m_curr_type_descr = 0;
	for(i=0;i<m_all_find_ojects.Size;i++)
	{
		if(m_all_find_ojects.GetAt(i)->type == m_mode)
		{
			m_curr_type_descr = m_all_find_ojects.GetAt(i);
		}
	}
	if(m_curr_type_descr == 0)
	{
		AfxMessageBox(APL_T("      !"));
		return;
	}

	m_ctrl_find_version.ShowWindow(SW_HIDE);
	m_CtrlMakeTableResult.EnableWindow(m_can_make_table);


	switch(m_mode)
	{
	case FindObject_Document: // Doc
		m_ctrl_find_version.ShowWindow(SW_NORMAL);
		m_ctrl_find_version.SetWindowText( APL_T("    "));
		m_ctrl_find_version.EnableWindow(TRUE);
		break;
	case FindObject_BP: // Action
		m_ctrl_find_version.ShowWindow(SW_NORMAL);
		m_ctrl_find_version.SetWindowText( APL_T("    "));
		m_ctrl_find_version.SetCheck(1);
		m_ctrl_find_version.EnableWindow(FALSE);
		break;
	case FindObject_Person: // Doc
		m_ctrl_find_version.ShowWindow(SW_NORMAL);
		m_ctrl_find_version.SetWindowText( APL_T(" "));
		if(old_mode != m_mode)
		{
			m_ctrl_find_version.SetCheck(1);
		}
		m_ctrl_find_version.EnableWindow(TRUE);
		break;
	}

	SetTabPagesActive(old_mode);
	DrawTabPage();

	//      
	m_attr_values_history[old_mode].CopyFrom(m_attr_values);

	//        
	m_attr_values.CopyFrom(m_attr_values_history[m_mode]);

	//   ,      ,       
	m_ListAttributes.DeleteAllItems();
	k = 0;


	for(i=0;i<m_curr_type_descr->list_attrs.Size;i++)
	{
		str_val = _T("");
		attr_def = m_curr_type_descr->list_attrs.GetAt(i);
		if(attr_def==0) continue;
		if(m_attr_values.Get(attr_def->type,val_log_rel,value,value2))
		{
			k = m_ListAttributes.InsertItem(k+1,attr_def->name4user);
			m_ListAttributes.SetItemData(k,(DWORD)attr_def);
			m_ListAttributes.SetItemText(k,1,CaplQLQuery::LogOp2String(val_log_rel));
			switch(attr_def->type)
			{
			case TFO_Id:  // -  
			case TFO_Name:  // -   (   )
			case TFO_Descr:  // -  
			case TFO_Code:  // -      
			case TFO_Ver:  // -   
			case TFO_VerDescr:  // -   
			case TFO_CodeVer1:  // -    1,
			case TFO_CodeVer2:  // -    2
			case TFO_CodeIzd:	// -   
			case TFO_Source:  // - 
// 			case TFO_RelPos:
// 			case TFO_RelPosId:
// 			case TFO_RelName:
// 			case TFO_RelDescr:
			case TFO_Standart:	// -   -   . :    
			case TFO_Groupe:	// -  -   
			case TFO_Part:		//  
			case TFO_Label:		//  - 
			case TFO_VerList:	//  - 
			case TFO_VerLists:	//  - 
			case TFO_VerFormat:	//  - ,  - 
			case TFO_VerLitera:	//  - 
			case TFO_DocUrgency:  // -  - 
			case TFO_StrExt:  //   
			case TFO_RefDocType: //  -  
			case TFO_RefState: //  - 
			case TFO_RefDocNum: //  -  
			case TFO_DocCode1:	//  ,  - 
			case TFO_DocCode2:	//  - ,  - 
			case TFO_RefManifDescr: //  
			case TFO_ProcTaskId: //  -  
			case TFO_ProcTaskName: //  -  
			case TFO_ProcTaskExpired:	//  -  
			case TFO_ProcState:	//  - 
			case TFO_DocMaillist: //  -  
			case TFO_State:	//   , , -      "".

				value.Get(str_val);
				//     -      
				if(str_val != _T(""))
				{
					int indx_map = attr_def->m_list_selected_string.FindByOut(str_val);
					if(indx_map!=-1)str_val = attr_def->m_list_selected_string.GetAt(indx_map)->str;
				}
				break;

			case TFO_ProcTaskExpiredNDays:	//  -     N 
				value.Get(int_val);
				if(int_val==0)int_val=3;
				str_val.Format(_T("%i"),int_val);
				break;

			case TFO_RelContext:		// , 
				//  
				value.Get(ext);
				m_api->m_prd_mgr.PrintItemContextInString(ext,str_val);
				break;

			case TFO_ProjCustomer:		// - ,  - 
			case TFO_ProjKurator:		// - ,  - ,  - 
			case TFO_ProjExecutors:		// - ,  - 
			case TFO_ProjCoexecutors:	// - 
			case TFO_ProcTaskPerformer:	//  -  
			case TFO_ProcRefusalCulprit:
			case TFO_ProcOwner:

				value.Get(inst);
				if(inst == 0)
				{
					str_val = _T("");
				}
				else
				{
					if(m_api->m_data.IsKindOf(inst, m_api->m_appr_mgr.e_person)) m_api->m_appr_mgr.GetPersonName(inst,str_val);
					else if(m_api->m_data.IsKindOf(inst, m_api->m_appr_mgr.e_org)) m_api->m_data.GetAttr(inst,m_api->m_appr_mgr.a_org_name,str_val); 
				}
				break;

			case TFO_InAggr:	//     
			case TFO_RefOrg: 
			case TFO_RefSector:	
			case TFO_RefCulprit:	
			case TFO_RefStage:	
			case TFO_RefMainPDF:	 
			case TFO_RefMainItem:	 
			case TFO_RefSystem:	 
			case TFO_RefFailedItem:	 
			case TFO_RefFailedPart:	 
			case TFO_RefConditions:	 
			case TFO_RefDof:		 
			case TFO_RefFaultReason:
			case TFO_RefMethod:		 
			case TFO_RefConsequence:
			case TFO_RefManif:		 
			case TFO_ProcTemplate:		 
			case TFO_ProcActivity:		 

				value.Get(inst);
				if(inst == 0)
				{
					str_val = _T("");
				}
				else
				{
					str_val = m_api->GetItemName(inst);
				}
				break;
			case TFO_Date1:  //  -    ;   -  
			case TFO_Date2:  //  -    ,  -  
			case TFO_Date3:  //  -    ,  -  . .
			case TFO_Date4:  //  -    ,  -  . .
				value.Get(str_val);
				aplString2Date(str_val,m_Date4Edit);
				value2.Get(str_val);
				aplString2Date(str_val,m_Date4Edit2);
				PrintDateValues(val_log_rel==CaplQLQuery::aplINDIAPAZON,str_val);
				break;

			case TFO_Type:  // -  
				//    ,     -    
				switch(m_mode)
				{
				case FindObject_ProductVer:
					value.Get(str_val);
					break;
				case FindObject_Change:
					value.Get(str_val);
					break;
				case FindObject_Document:
					value.Get(curr_type_inst);
					if(curr_type_inst != 0)apidata.GetAttr(curr_type_inst,m_api->m_doc_mgr.a_dt_pdt,str_val);
					break;
				case FindObject_BP:
					//     .          
					value.Get(curr_type_inst);
					if(curr_type_inst != 0)apidata.GetAttr(curr_type_inst,m_api->m_bp_mgr.a_bp_type_name,str_val);
					break;
				case FindObject_Project:
					value.Get(curr_type_inst);
					if(curr_type_inst != 0)apidata.GetAttr(curr_type_inst,m_api->m_project_mgr->a_project_type_name,str_val);
					break;
				case FindObject_Refusal:
					value.Get(curr_type_inst);
					if(curr_type_inst != 0)apidata.GetAttr(curr_type_inst,m_api->m_classifier_mgr.a_apl_classifier_level_name,str_val);
					break;
				default:
					AfxMessageBox(APL_T("      \"\"!!!"));
					return;
				}
				break;

			default:
				AfxMessageBox(APL_T("       !"));
				return;
			}
			m_ListAttributes.SetItemText(k,2,str_val);
		}
	}
}




/////////////////////////////////////////////////////////////////////////////
// CFindQueryDlgEx  -  

//  ()     
void CFindQueryDlgEx::SetTabPagesActive(TypeFindObject old_mode)
{
	int is_APPROVAL=-1, is_CHARACTER=-1, is_DOCUMENTS=-1, is_RESOURCES=-1, is_BLOBS=-1, is_CLASSIF=-1;
	TCITEM TabCtrlItem;
	TabCtrlItem.mask = TCIF_PARAM;
	int i, count=m_TabAdjust.GetItemCount();
	for(i=0;i<count;i++)
	{
		m_TabAdjust.GetItem(i,&TabCtrlItem);
		switch(TabCtrlItem.lParam)
		{
		case TAB_ADJ_TYPE_APPROVAL:
			is_APPROVAL=i;
			break;
		case TAB_ADJ_TYPE_CHARACTER:
			is_CHARACTER=i;
			break;
		case TAB_ADJ_TYPE_DOCUMENTS:
			is_DOCUMENTS=i;
			break;
		case TAB_ADJ_TYPE_RESOURCES:
			is_RESOURCES=i;
			break;
		case TAB_ADJ_TYPE_BLOBS:
			is_BLOBS=i;
			break;
		case TAB_ADJ_TYPE_CLASSIF:
			is_CLASSIF=i;
			break;
		}
	}

	if(is_APPROVAL==-1)InsertTabAjust(0,APPROVAL);
	if(is_CHARACTER==-1)InsertTabAjust(1,CHARACTER);
	if(is_DOCUMENTS==-1) InsertTabAjust(2,DOCUMENTS);

	SetTabPagesEnable(TRUE);
	switch(m_mode)
	{
	case FindObject_Product: // Product
	case FindObject_ProductVer: // Product Version
	case FindObject_Lot: // Lot
	case FindObject_ProductInst: // Product Inst
	case FindObject_Project: // Project
	case FindObject_All: //     
		break;
	case FindObject_Document: // Doc
		//if(is_BLOBS==-1)InsertTabAjust(5,BLOBS);
		break;
	case FindObject_BP: // 
	case FindObject_BPInst: // 
		//    InsertTabAjust(4,RESOURCES);
		break;
	case FindObject_Category:
	case FindObject_Person:
	case FindObject_Organization:
		if(is_APPROVAL!=-1) m_TabAdjust.DeleteItem(is_APPROVAL);
		if(m_page_num==adj_appr){
			m_page_num=adj_char;
			m_TabAdjust.SetCurSel(0);
		}
		break;
	case FindObject_Change:
		if(is_CHARACTER!=-1)m_TabAdjust.DeleteItem(is_CHARACTER);
		if(m_page_num==adj_char){
			m_page_num=adj_appr;
			m_TabAdjust.SetCurSel(0);
		}
		break;
	case FindObject_Requirement:
		if(is_CHARACTER!=-1)m_TabAdjust.DeleteItem(is_CHARACTER);
		if(is_APPROVAL!=-1) m_TabAdjust.DeleteItem(is_APPROVAL);
		if(m_page_num==adj_char || m_page_num==adj_appr){
			m_page_num=adj_doc;
			m_TabAdjust.SetCurSel(0);
		}
		break;
	case FindObject_Folder:
	case FindObject_Find:
	case FindObject_CombinedTable:
	case FindObject_ClassifSystem:
	case FindObject_ClassifLevel:
	case FindObject_Process:
	case FindObject_Task:
		SetTabPagesEnable(FALSE);
		break;
	}
	SetHiglight();
}

void CFindQueryDlgEx::SetHiglight()
{
	TCITEM TabCtrlItem;
	TabCtrlItem.mask=TCIF_IMAGE | TCIF_PARAM;

	int i, count=m_TabAdjust.GetItemCount();
	for(i=0;i<count;i++)
	{
		m_TabAdjust.GetItem(i,&TabCtrlItem);

		switch(TabCtrlItem.lParam)
		{
		case TAB_ADJ_TYPE_APPROVAL:
			// approval
			if(m_list_approval.Size>0){TabCtrlItem.iImage=3;}else{TabCtrlItem.iImage=2;}
			break;
		case TAB_ADJ_TYPE_CHARACTER:
			// 
			if(m_list_char.Size>0){TabCtrlItem.iImage=5;}else{TabCtrlItem.iImage=4;}
			break;
		case TAB_ADJ_TYPE_DOCUMENTS:
			// 
			if(m_list_doc.Size>0){TabCtrlItem.iImage=7;}else{TabCtrlItem.iImage=6;}
			break;
		case TAB_ADJ_TYPE_RESOURCES:
			// 
			if(m_list_res.Size>0){TabCtrlItem.iImage=9;}else{TabCtrlItem.iImage=8;}
			break;
		case TAB_ADJ_TYPE_BLOBS:
			//   
			if(m_list_blob.Size>0){TabCtrlItem.iImage=11;}else{TabCtrlItem.iImage=10;}
			break;
		case TAB_ADJ_TYPE_CLASSIF:
			// 
			if(m_list_class.Size>0){TabCtrlItem.iImage=13;}else{TabCtrlItem.iImage=12;}
			break;
		}
		m_TabAdjust.SetItem(i, &TabCtrlItem);
	}



}

void CFindQueryDlgEx::SetTabPagesEnable(BOOL mode)
{
	m_TabAdjust.EnableWindow(mode);
	if(!m_read_only){
		m_BtnAdjAdd.EnableWindow(mode);
		m_BtnAdjDel.EnableWindow(mode);
	}
	m_BtnAdjEdit.EnableWindow(mode);
	m_ListAdjust.EnableWindow(mode);
}

//    
void CFindQueryDlgEx::OnSelchangeTabAdjust(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	int pos=m_TabAdjust.GetCurSel();
/*	  
	if(m_mode==FindObject_Category || m_mode==FindObject_Person || m_mode==FindObject_Organization){
		m_page_num=(TypeAdj)(pos+1);
	}else{
		m_page_num=(TypeAdj)pos;
	}
*/
	CString str;
	TCITEM TabCtrlItem;
	TabCtrlItem.mask=TCIF_PARAM;
	m_TabAdjust.GetItem(pos,&TabCtrlItem);
	if     (TabCtrlItem.lParam==TAB_ADJ_TYPE_APPROVAL ){m_page_num=adj_appr;
	}else if(TabCtrlItem.lParam==TAB_ADJ_TYPE_CHARACTER){m_page_num=adj_char;
	}else if(TabCtrlItem.lParam==TAB_ADJ_TYPE_DOCUMENTS){m_page_num=adj_doc;
	}else if(TabCtrlItem.lParam==TAB_ADJ_TYPE_RESOURCES){m_page_num=adj_res;
	//}else if(TabCtrlItem.lParam==TAB_ADJ_TYPE_BLOBS){m_page_num=adj_blob;
	}else if(TabCtrlItem.lParam==TAB_ADJ_TYPE_CLASSIF){m_page_num=adj_class;
	}else{
		return;
	}
	DrawTabPage();
	*pResult = 0;
}

//     -      
void CFindQueryDlgEx::DrawTabPage()
{
	RECT rect;
	int i;
	//  
	int nColumnCount = m_ListAdjust.GetHeaderCtrl()->GetItemCount();
	for (i=0;i < nColumnCount;i++){
		m_ListAdjust.DeleteColumn(0);
	}
	//        
	m_ListAdjust.GetWindowRect(&rect);
	int width=rect.right-rect.left;
	int delt;
	if(!m_read_only){
		m_BtnAdjAdd.EnableWindow(TRUE);
		m_BtnAdjDel.EnableWindow(TRUE);
	}
	m_BtnAdjEdit.EnableWindow(TRUE);
	m_CtrlRadioAnd.EnableWindow(TRUE);
	m_CtrlRadioOr.EnableWindow(TRUE);
	if(m_page_num==adj_appr)
	{
		// 
		delt=div(width,20).quot;
		m_ListAdjust.InsertColumn(CT_APPR_IS_EXIST, APL_T(""),LVCFMT_LEFT,delt*2);
		m_ListAdjust.InsertColumn(CT_APPR_IS_APPR, APL_T(""),LVCFMT_LEFT,delt*3);
		m_ListAdjust.InsertColumn(CT_APPR_IS_DESCR, APL_T(""),LVCFMT_LEFT,delt*3);
		m_ListAdjust.InsertColumn(CT_APPR_IS_PERSON, APL_T(""),LVCFMT_LEFT,delt*3);
		m_ListAdjust.InsertColumn(CT_APPR_IS_ROLE, APL_T(""),LVCFMT_LEFT,delt*2);
		m_ListAdjust.InsertColumn(CT_APPR_IS_DATE, APL_T(""),LVCFMT_LEFT,delt*3);
		m_ListAdjust.InsertColumn(CT_APPR_IS_REVOC_DATE, APL_T(" ."),LVCFMT_LEFT,delt*3);
		m_ListAdjust.InsertColumn(CT_APPR_IS_IS_DIG_SIGN, APL_T(""),LVCFMT_LEFT,delt*1);
		m_st_tab_cond_ctrl.SetWindowText(APL_T("   :"));
		//m_CtrlRadioAnd.SetWindowText(_T("  "));
		//m_CtrlRadioOr.SetWindowText(_T("  "));
	}
	else if(m_page_num==adj_char)
	{
		// 
		delt=div(width,20).quot;
		m_ListAdjust.InsertColumn(CT_CHAR_IS_EXIST, APL_T(""),LVCFMT_LEFT,delt*3);
		m_ListAdjust.InsertColumn(CT_CHAR_NAME, APL_T(""),LVCFMT_LEFT,delt*6);
		m_ListAdjust.InsertColumn(CT_CHAR_TYPE, APL_T(""),LVCFMT_LEFT,delt*4);
		m_ListAdjust.InsertColumn(CT_CHAR_RELATION, APL_T(""),LVCFMT_LEFT,delt*3);
		m_ListAdjust.InsertColumn(CT_CHAR_VALUE, APL_T(""),LVCFMT_LEFT,delt*4);
		m_st_tab_cond_ctrl.SetWindowText(APL_T("   :"));
		//m_CtrlRadioAnd.SetWindowText(_T("  "));
		//m_CtrlRadioOr.SetWindowText(_T("  "));
	}
	else if(m_page_num==adj_doc)
	{
		// 
		delt=div(width,20).quot;
		m_ListAdjust.InsertColumn(CT_DOC_IS_EXIST, APL_T(""),LVCFMT_LEFT,delt*3);
		m_ListAdjust.InsertColumn(CT_DOC_ID, APL_T(""),LVCFMT_LEFT,delt*6);
		m_ListAdjust.InsertColumn(CT_DOC_NAME, APL_T(""),LVCFMT_LEFT,delt*6);
		m_ListAdjust.InsertColumn(CT_DOC_KIND, APL_T(" "),LVCFMT_LEFT,delt*5);
/*
		m_adj_add.EnableWindow(FALSE);
		m_adj_del.EnableWindow(FALSE);
		m_adj_edit.EnableWindow(FALSE);
*/
		m_st_tab_cond_ctrl.SetWindowText(APL_T("   :"));
		//m_CtrlRadioAnd.SetWindowText(_T("  "));
		//m_CtrlRadioOr.SetWindowText(_T("  "));
	}
	else if(m_page_num==adj_res)
	{
		// 
		delt=div(width,20).quot;
		m_ListAdjust.InsertColumn(CT_RES_IS_EXIST, APL_T(""),LVCFMT_LEFT,delt*3);
		m_ListAdjust.InsertColumn(CT_RES_ID_R, APL_T(" "),LVCFMT_LEFT,delt*6);
		m_ListAdjust.InsertColumn(CT_RES_NAME_R, APL_T(" "),LVCFMT_LEFT,delt*6);
		m_ListAdjust.InsertColumn(CT_RES_TYPE_R, APL_T(" "),LVCFMT_LEFT,delt*5);
		m_ListAdjust.InsertColumn(CT_RES_ID_O, APL_T(" "),LVCFMT_LEFT,delt*6);
		m_ListAdjust.InsertColumn(CT_RES_NAME_O, APL_T(" "),LVCFMT_LEFT,delt*6);
		m_ListAdjust.InsertColumn(CT_RES_TYPE_O, APL_T(" "),LVCFMT_LEFT,delt*5);
		m_st_tab_cond_ctrl.SetWindowText(APL_T("   :"));
		//m_CtrlRadioAnd.SetWindowText(_T("  "));
		//m_CtrlRadioOr.SetWindowText(_T("  "));
	}
	else if(m_page_num==adj_blob)
	{
		delt=div(width,20).quot;
		if(m_api->m_data.CanFindInBLOB()){
			m_ListAdjust.InsertColumn(CT_BLOB_IS_EXIST, APL_T(" "),LVCFMT_LEFT,delt*3);
			m_ListAdjust.InsertColumn(CT_BLOB_CONTENT, APL_T(" "),LVCFMT_LEFT,delt*16);
		}else{
			m_ListAdjust.InsertColumn(CT_BLOB_IS_EXIST,_T("..."),LVCFMT_LEFT,delt*18);
			m_BtnAdjAdd.EnableWindow(FALSE);
			m_BtnAdjDel.EnableWindow(FALSE);
			m_BtnAdjEdit.EnableWindow(FALSE);
		}
		m_CtrlRadioAnd.EnableWindow(FALSE);
		m_CtrlRadioOr.EnableWindow(FALSE);
		m_st_tab_cond_ctrl.SetWindowText(APL_T(" blob-  :"));
		m_CtrlRadioAnd.SetWindowText(APL_T(""));
		m_CtrlRadioOr.SetWindowText(APL_T(""));
	}
	else if(m_page_num==adj_class)
	{
		// 
		delt=div(width,40).quot;
		m_ListAdjust.InsertColumn(CT_CLS_TYPE, APL_T(""),LVCFMT_LEFT,delt*11);
		m_ListAdjust.InsertColumn(CT_CLS_ID, APL_T(""),LVCFMT_LEFT,delt*12);
		m_ListAdjust.InsertColumn(CT_CLS_NAME, APL_T(""),LVCFMT_LEFT,delt*12);
		m_ListAdjust.InsertColumn(CT_CLS_LVL, APL_T(""),LVCFMT_LEFT,delt*4);
		m_st_tab_cond_ctrl.SetWindowText(APL_T("   :"));
		//m_CtrlRadioAnd.SetWindowText(_T("     "));
		//m_CtrlRadioOr.SetWindowText(_T("  "));
	}
	FillTabAdjust();
}


void CFindQueryDlgEx::FillTabAdjustCharact()
{
	ElValChar* el_ch;
	COleDateTime odt;
	CString buf,buf1;
	CaplInstance *unit;
	CString str_type,str_is;
	int i,item_num;//,iY,iM,iD;
	//	double rval;
	m_ListAdjust.DeleteAllItems();


	for(i=0;i<m_list_char.Size;i++){
		el_ch=m_list_char.GetAt(i);
		if(el_ch==0){
			::MessageBox(0, APL_T("  !"),_T("Error"),MB_OK|MB_ICONERROR);
			return;
		}
		if(el_ch->apl_char!=0){
			apidata.GetAttrBN(el_ch->apl_char,_T("name"),buf);
		}else{
			::MessageBox(0, APL_T(" -   !"),_T("Error"),MB_OK|MB_ICONERROR);
			return;
		}

		apidata.GetAttrBN(el_ch->apl_char,_T("unit"),unit);
		if(el_ch->is_exist){str_is= APL_T("");}else{str_is= APL_T("");}
		if(el_ch->type){apidata.GetAttrBN(el_ch->type,_T("name"),str_type);}else{str_type=_T("");}
		
		item_num=m_ListAdjust.InsertItem(i,str_is,0);
		m_ListAdjust.SetItemData(item_num,(DWORD)i);

		if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_step_unit))
		{
			if(!el_ch->b_val && !el_ch->b_max && !el_ch->b_min)
			{
				m_ListAdjust.SetItemText(item_num,CT_CHAR_NAME,buf);
				m_ListAdjust.SetItemText(item_num,CT_CHAR_TYPE,str_type);
			}
			if(el_ch->b_val)
			{
				buf1.Format( APL_T("%s:"),buf);
				m_ListAdjust.SetItemText(item_num,CT_CHAR_NAME,buf1);
				m_ListAdjust.SetItemText(item_num,CT_CHAR_TYPE,str_type);
				m_ListAdjust.SetItemText(item_num,CT_CHAR_RELATION,CaplQLQuery::LogOp2String(el_ch->log_relation));
				buf1=el_ch->val;
				m_ListAdjust.SetItemText(item_num,CT_CHAR_VALUE,buf1);
			}
			if(el_ch->b_max)
			{
				buf1.Format( APL_T("%s: "),buf);
				m_ListAdjust.SetItemText(item_num,CT_CHAR_NAME,buf1);
				m_ListAdjust.SetItemText(item_num,CT_CHAR_TYPE,str_type);
				m_ListAdjust.SetItemText(item_num,CT_CHAR_RELATION,CaplQLQuery::LogOp2String(el_ch->log_relation_max));
				buf1=el_ch->val_max;
				m_ListAdjust.SetItemText(item_num,CT_CHAR_VALUE,buf1);
			}
			if(el_ch->b_min)
			{
				buf1.Format( APL_T("%s: "),buf);
				m_ListAdjust.SetItemText(item_num,CT_CHAR_NAME,buf1);
				m_ListAdjust.SetItemText(item_num,CT_CHAR_TYPE,str_type);
				m_ListAdjust.SetItemText(item_num,CT_CHAR_RELATION,CaplQLQuery::LogOp2String(el_ch->log_relation_min));
				buf1=el_ch->val_min;
				m_ListAdjust.SetItemText(item_num,CT_CHAR_VALUE,buf1);
			}
		}
		else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_descript_unit)||
			apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_enum_unit) )
		{
			m_ListAdjust.SetItemText(item_num,CT_CHAR_NAME,buf);
			m_ListAdjust.SetItemText(item_num,CT_CHAR_TYPE,str_type);
			if(el_ch->b_val)
			{
				m_ListAdjust.SetItemText(item_num,CT_CHAR_RELATION,CaplQLQuery::LogOp2String(el_ch->log_relation));
				buf1=el_ch->val;
				m_ListAdjust.SetItemText(item_num,CT_CHAR_VALUE,buf1);
			}
		}
		else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_monetary_unit))
		{
			m_ListAdjust.SetItemText(item_num,CT_CHAR_NAME,buf);
			m_ListAdjust.SetItemText(item_num,CT_CHAR_TYPE,str_type);
			if(el_ch->b_val)
			{
				m_ListAdjust.SetItemText(item_num,CT_CHAR_RELATION,CaplQLQuery::LogOp2String(el_ch->log_relation));
				buf1=el_ch->val;
				m_ListAdjust.SetItemText(item_num,CT_CHAR_VALUE,buf1);
			}
		}
		else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_time_unit))
		{
			m_ListAdjust.SetItemText(item_num,CT_CHAR_NAME,buf);
			m_ListAdjust.SetItemText(item_num,CT_CHAR_TYPE,str_type);
			if(el_ch->b_val)
			{
				m_ListAdjust.SetItemText(item_num,CT_CHAR_RELATION,CaplQLQuery::LogOp2String(el_ch->log_relation));
				//buf1.Format(_T("%02s:%02s:%s"),el_ch->val_min,el_ch->val_max,el_ch->val);
				if(el_ch->dtt!=0){
					buf1=el_ch->dtt->Format(_T("%d.%m.%Y %H:%M:%S"));
				}else{
					buf1=APL_T(" ");
				}
				m_ListAdjust.SetItemText(item_num,CT_CHAR_VALUE,buf1);
			}
		}
		else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_reference_unit))
		{
			m_ListAdjust.SetItemText(item_num,CT_CHAR_NAME,buf);
			m_ListAdjust.SetItemText(item_num,CT_CHAR_TYPE,str_type);
			if(el_ch->b_val)
			{
				m_ListAdjust.SetItemText(item_num,CT_CHAR_RELATION,CaplQLQuery::LogOp2String(el_ch->log_relation));
				m_api->m_charact_mgr.GetItemName(el_ch->m_cur_ref_val,buf1);
				m_ListAdjust.SetItemText(item_num,CT_CHAR_VALUE,buf1);
			}
		}
		else
		{//       ""
			m_ListAdjust.SetItemText(item_num,CT_CHAR_NAME,buf);
			m_ListAdjust.SetItemText(item_num,CT_CHAR_TYPE,str_type);
			m_ListAdjust.SetItemText(item_num,CT_CHAR_RELATION,CaplQLQuery::LogOp2String(el_ch->log_relation));
		}
	}
}

//     .  
void CFindQueryDlgEx::FillTabAdjust()
{
	ElValDoc* el_doc;
	ElValApproval* el_apr;
	ElValRes* el_res;
	ElValBLOB* el_blob;
	ElValClass* el_class;
	CaplInstance* inst;
	COleDateTime odt;
	CString buf,buf1;
	CString str_type,str_is;
	int i,item_num;//,iY,iM,iD;
//	double rval;
	m_ListAdjust.DeleteAllItems();

	if(m_page_num==adj_appr)
	{
		// 
		SetAdjAndOr(m_is_or_approval);

		if(m_indx_of_zero_approval != -1)
		{
			el_apr=m_list_approval.GetAt(m_indx_of_zero_approval);
			if(el_apr==0){
				MessageBox( APL_T("  !"),_T("Error"),MB_OK|MB_ICONERROR);
				return;
			}
			if(el_apr->is_exist){buf= APL_T("");}else{buf= APL_T("");}
			item_num=m_ListAdjust.InsertItem(0,buf,0);
			buf= APL_T(" ");
			m_ListAdjust.SetItemText(item_num,CT_APPR_IS_APPR,buf);
			m_ListAdjust.SetItemData(item_num,(DWORD)m_indx_of_zero_approval);
		}
		else
		{
			for(i=0;i<m_list_approval.Size;i++)
			{
				el_apr=m_list_approval.GetAt(i);
				if(el_apr==0){
					MessageBox( APL_T("  !"),_T("Error"),MB_OK|MB_ICONERROR);
					return;
				}
				if(el_apr->is_exist){buf= APL_T("");}else{buf= APL_T("");}
				item_num=m_ListAdjust.InsertItem(i,buf,0);
				m_ListAdjust.SetItemData(item_num,(DWORD)i);
				if(el_apr->status!=0){
					apidata.GetAttr(el_apr->status,m_api->m_appr_mgr.a_appr_status_name,buf);
				}else{
					buf=_T("");
				}
				m_ListAdjust.SetItemText(item_num,CT_APPR_IS_APPR,buf);
				if(el_apr->descr!=_T(""))
				{
					m_ListAdjust.SetItemText(item_num,CT_APPR_IS_DESCR,el_apr->descr);
				}
				if(el_apr->person!=0)
				{
					if(apidata.IsKindOf(el_apr->person,m_api->m_appr_mgr.e_pers_org))
					{
						apidata.GetAttr(el_apr->person,m_api->m_appr_mgr.a_po_the_pers,inst);
					}
					else if(apidata.IsKindOf(el_apr->person,m_api->m_appr_mgr.e_person))
					{
						inst = el_apr->person;
					}
					else
					{
						MessageBox( APL_T("    !"),_T("Error"),MB_OK|MB_ICONERROR);
						return;
					}
					apidata.GetAttr(inst,m_api->m_appr_mgr.a_pers_last_name,buf);
				}
				else
				{
					buf=_T("");
				}
				m_ListAdjust.SetItemText(item_num,CT_APPR_IS_PERSON,buf);
				buf=el_apr->pers_org_role;
				m_ListAdjust.SetItemText(item_num,CT_APPR_IS_ROLE,buf);
				buf=_T("");
				if(el_apr->is_single_date){
					if(el_apr->date_time_beg!=0){
	//					m_date_mgr.Get(el_apr->date_time_beg,odt);
	//					buf=odt.Format(_T("%d.%m.%Y"));
						buf=el_apr->date_time_beg->Format(_T("%d.%m.%Y %H:%M:%S"));
					}
				}else{
					buf=_T("");
					if(el_apr->date_time_beg!=0){
	//					m_date_mgr.Get(el_apr->date_time_beg,odt);
	//					buf1=odt.Format(_T("c %d.%m.%Y"));
						buf1=el_apr->date_time_beg->Format( APL_T(" %d.%m.%Y %H:%M:%S"));
						buf+=buf1;
					}
					if(el_apr->date_time_end!=0){
	//					m_date_mgr.Get(el_apr->date_time_end,odt);
	//					buf1=odt.Format(APL_T(" %d.%m.%Y"));
						buf1=el_apr->date_time_end->Format( APL_T("  %d.%m.%Y %H:%M:%S"));
						buf+=buf1;
					}
				}
				m_ListAdjust.SetItemText(item_num,CT_APPR_IS_DATE,buf);
				buf=_T("");
				if(el_apr->revoc_date_time_beg!=0){
					buf1=el_apr->revoc_date_time_beg->Format( APL_T(" %d.%m.%Y %H:%M:%S"));
					buf+=buf1;
				}
				if(el_apr->revoc_date_time_end!=0){
					buf1=el_apr->revoc_date_time_end->Format( APL_T("  %d.%m.%Y %H:%M:%S"));
					buf+=buf1;
				}		
				m_ListAdjust.SetItemText(item_num,CT_APPR_IS_REVOC_DATE,buf);
				if(el_apr->is_dig_sign==0){buf= APL_T("");}
				else if(el_apr->is_dig_sign==1){buf= APL_T("");}
				else {buf=_T("");}
				m_ListAdjust.SetItemText(item_num,CT_APPR_IS_IS_DIG_SIGN,buf);
			}
		}

	}
	else if(m_page_num==adj_char)
	{
		// 
		SetAdjAndOr(m_is_or_char);

		FillTabAdjustCharact();

	}
	else if(m_page_num==adj_doc)
	{
		// 
		SetAdjAndOr(m_is_or_doc);

		for(i=0;i<m_list_doc.Size;i++){
			el_doc=m_list_doc.GetAt(i);

			if(el_doc==0){
				MessageBox( APL_T("  !"),_T("Error"),MB_OK|MB_ICONERROR);
				return;
			}
			if(el_doc->is_exist){buf= APL_T("");}else{buf= APL_T("");}
			item_num=m_ListAdjust.InsertItem(i,buf,0);
			m_ListAdjust.SetItemData(item_num,(DWORD)i);
			m_ListAdjust.SetItemText(item_num,CT_DOC_ID,el_doc->id);
			m_ListAdjust.SetItemText(item_num,CT_DOC_NAME,el_doc->name);
			if(el_doc->type!=0){
				apidata.GetAttr(el_doc->type,m_api->m_doc_mgr.a_dt_pdt,buf);
			}else{
				buf=_T("");
			}
 			m_ListAdjust.SetItemText(item_num,CT_DOC_KIND,buf);
		}
	}
	else if(m_page_num==adj_res)
	{
		// 
		SetAdjAndOr(m_is_or_res);

		for(i=0;i<m_list_res.Size;i++)
		{
			el_res=m_list_res.GetAt(i);

			if(el_res==0){
				MessageBox( APL_T("  !"),_T("Error"),MB_OK|MB_ICONERROR);
				return;
			}
			if(el_res->is_exist){buf= APL_T("");}else{buf= APL_T("");}

			item_num=m_ListAdjust.InsertItem(i,buf,0);
			m_ListAdjust.SetItemData(item_num,(DWORD)i);
			m_ListAdjust.SetItemText(item_num,CT_RES_ID_R,el_res->id_res);
			m_ListAdjust.SetItemText(item_num,CT_RES_NAME_R,el_res->name_res);
			if(el_res->type_res!=0){
				apidata.GetAttr(el_res->type_res,m_api->m_bp_mgr.a_bp_type_name,buf);
			}else{
				buf=_T("");
			}
			m_ListAdjust.SetItemText(item_num,CT_RES_TYPE_R,buf);
			m_ListAdjust.SetItemText(item_num,CT_RES_ID_O,el_res->id_obj);
			m_ListAdjust.SetItemText(item_num,CT_RES_NAME_O,el_res->name_obj);
			switch(el_res->type_obj)
			{
			case ElValRes::TROProduct:buf= APL_T("");break;
			case ElValRes::TROPerson:buf= APL_T("");break;
			case ElValRes::TROOrg:buf= APL_T(" ");break;
			case ElValRes::TRONoType:
			default:buf= APL_T(" ");break;
			}
			m_ListAdjust.SetItemText(item_num,CT_RES_TYPE_O,buf);
		}
	}
	else if(m_page_num==adj_blob)
	{
		if(m_api->m_data.CanFindInBLOB())
		{
			SetAdjAndOr(m_is_or_blob);

			for(i=0;i<m_list_blob.Size;i++){
				el_blob=m_list_blob.GetAt(i);
				if(el_blob==0){
					MessageBox( APL_T("  !"),_T("Error"),MB_OK|MB_ICONERROR);
					return;
				}
				if(el_blob->is_equal){buf= APL_T("  ");}else{buf=_T("");}
				
				item_num=m_ListAdjust.InsertItem(i,buf,0);
				m_ListAdjust.SetItemData(item_num,(DWORD)i);
				m_ListAdjust.SetItemText(item_num,CT_BLOB_CONTENT,el_blob->word);
			}
		}else{
			item_num=m_ListAdjust.InsertItem(0, APL_T("        ORACLE   interMedia Text"),0);
		}
	}
	else if(m_page_num==adj_class)
	{
		// 
		SetAdjAndOr(m_is_or_class);

		CString name,id,type,level=_T("");
		for(i=0;i<m_list_class.Size;i++)
		{
			el_class=m_list_class.GetAt(i);
			if(el_class==0)
			{
				MessageBox( APL_T("  !"),_T("Error"),MB_OK|MB_ICONERROR);
				return;
			}
			if(el_class->is_exist)
				type = APL_T("  ");
			else
				type = APL_T("   ");

			if(m_api->m_data.IsKindOf(el_class->classif, m_api->m_classifier_mgr.e_apl_classifier_level))
			{
				type += APL_T("  ");
				m_api->m_data.GetAttr(el_class->classif, m_api->m_classifier_mgr.a_apl_classifier_level_id, id);
				m_api->m_data.GetAttr(el_class->classif, m_api->m_classifier_mgr.a_apl_classifier_level_name, name);
				level.Format(_T(" : (%i)"),m_api->m_classifier_mgr.GetLevelClassifierLevel(el_class->classif));
			}
			else
			{
				type += APL_T("");
				m_api->m_data.GetAttr(el_class->classif, m_api->m_classifier_mgr.a_apl_classifier_system_id, id);
				m_api->m_data.GetAttr(el_class->classif, m_api->m_classifier_mgr.a_apl_classifier_system_name, name);
				level = _T("");
			}
			item_num=m_ListAdjust.InsertItem(i,type,0);
			m_ListAdjust.SetItemData(item_num,(DWORD)i);
			m_ListAdjust.SetItemText(item_num,CT_CLS_ID,id);
			m_ListAdjust.SetItemText(item_num,CT_CLS_NAME,name);
			m_ListAdjust.SetItemText(item_num,CT_CLS_LVL,level);
		}
	}
	SetHiglight();
}

void CFindQueryDlgEx::OnRclickListAttributes(NMHDR* pNMHDR, LRESULT* pResult) 
{
	*pResult = 0;

	const MSG* msg;
	CPoint mouseclick;
	
	LPNMHEADER phdr = reinterpret_cast<LPNMHEADER>(pNMHDR);
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);

	msg=GetCurrentMessage();
	//mouseclick -   
	mouseclick=msg->pt;
	CaplMenu menu;
	CMenu* pPopup =0;
	//  
	VERIFY(menu.LoadMenu(IDR_CONTEXT_MENU));
	pPopup = menu.GetSubMenu(0);
	int num_curr = 0;
	int num_selected = -1;
	do{
		num_selected++;
		num_curr=m_ListAttributes.GetNextItem( num_curr , LVNI_ALL | LVNI_SELECTED );
	}while(num_curr!=-1);


	num_curr= m_ListAttributes.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if(m_read_only)
	{
		pPopup->EnableMenuItem(IDC_DELETE,MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(IDC_ADD,MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(IDC_CHANGE,MF_BYCOMMAND | MF_GRAYED);
		//pPopup->ModifyMenu(0,MF_BYPOSITION,IDC_CHANGE, APL_T(""));
	}
	else
	{
		if(num_curr== -1)
		{
			pPopup->EnableMenuItem(IDC_CHANGE,MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(IDC_DELETE,MF_BYCOMMAND | MF_GRAYED);
		}
		else if( num_selected > 1)
		{
			pPopup->EnableMenuItem(IDC_CHANGE,MF_BYCOMMAND | MF_GRAYED);
		}
		else
		{
			pPopup->SetDefaultItem(IDC_CHANGE,MF_BYCOMMAND | MF_GRAYED);
		}
	}

	CaplMenu::Install(this); 

	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
		TPM_RIGHTBUTTON|TPM_RETURNCMD,msg->pt.x, msg->pt.y,this);
	//       :
	switch (res)
	{
	case IDC_ADD: AttributesAdd();      break;
	case IDC_DELETE:AttributesDel();	break;
	case IDC_CHANGE:
		if(pNMLV->iItem == -1)
		{
			/*AttributesAdd();*/
		}
		else if(pNMLV->iSubItem == 0)
		{
			BeginEditAttrDef();
		}
		else if(pNMLV->iSubItem == 1)
		{
			BeginEditAttrRel();
		}
		else if(pNMLV->iSubItem == 2)
		{
			BeginEditAttrVal();
		}

		break;
	default:break;
	}
}

void CFindQueryDlgEx::OnRclickListAdjust(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	*pResult = 0;
	
	const MSG* msg;
	CPoint mouseclick;
	msg=GetCurrentMessage();
	//mouseclick -   
	mouseclick=msg->pt;
	CaplMenu menu;
	CMenu* pPopup =0;
	//  
	VERIFY(menu.LoadMenu(IDR_CONTEXT_MENU));
	pPopup = menu.GetSubMenu(0);
	int num_curr = 0;
	int num_selected = -1;
	do{
		num_selected++;
		num_curr=m_ListAdjust.GetNextItem( num_curr , LVNI_ALL | LVNI_SELECTED );
	}while(num_curr!=-1);

	num_curr= m_ListAdjust.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );

	if(m_read_only)
	{
		pPopup->EnableMenuItem(IDC_DELETE,MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(IDC_ADD,MF_BYCOMMAND | MF_GRAYED);
		pPopup->ModifyMenu(0,MF_BYPOSITION,IDC_CHANGE, APL_T(""));
	}
	else if(m_page_num==adj_blob && !m_api->m_data.CanFindInBLOB())
	{
		pPopup->EnableMenuItem(IDC_DELETE,MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(IDC_ADD,MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(IDC_CHANGE,MF_BYCOMMAND | MF_GRAYED);
	}
	else
	{
		if(num_curr== -1)
		{
			pPopup->EnableMenuItem(IDC_CHANGE,MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(IDC_DELETE,MF_BYCOMMAND | MF_GRAYED);
		}
		else if(num_selected > 1)
		{
			pPopup->EnableMenuItem(IDC_CHANGE,MF_BYCOMMAND | MF_GRAYED);
		}
		else
		{
			pPopup->SetDefaultItem(IDC_CHANGE,MF_BYCOMMAND | MF_GRAYED);
		}
	}
	if(m_indx_of_zero_approval!=-1)
	{
		pPopup->EnableMenuItem(IDC_ADD,MF_BYCOMMAND | MF_GRAYED);
	}

	CaplMenu::Install(this); 
	
	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
		TPM_RIGHTBUTTON|TPM_RETURNCMD,msg->pt.x, msg->pt.y,this);
	//       :
	switch (res)
	{
	case IDC_ADD: OnAdjustAdd();      break;
	case IDC_DELETE:OnAdjustDel();	break;
	case IDC_CHANGE:OnAdjustEdit();	break;
	default:break;
	}
}


//    ""
void CFindQueryDlgEx::OnAdjustAdd() 
{
	// TODO: Add your control notification handler code here
	CFindAdjustDocDlg doc_dlg;
	CFindAdjustApprDlg appr_dlg;
	CFindAdjustCharactDlg char_dlg;
	CFindAdjustResourceDlg res_dlg;
	CFindAdjustBlobDlg blob_dlg;
	CFindAdjustUserDateDlg user_date_dlg;
	CFindAdjustClassifDlg classif_dlg;
	if(m_read_only)return;

	if(m_indx_of_zero_approval != -1)
	{
		return;
	}

	appr_dlg.m_api=m_api;
	appr_dlg.m_mode_slave=m_mode_slave;
	doc_dlg.m_api=m_api;
	char_dlg.m_api=m_api;
	res_dlg.m_api=m_api;
	blob_dlg.m_api=m_api;
	user_date_dlg.m_api=m_api;
	classif_dlg.m_api=m_api;


	if(m_page_num==adj_appr)
	{
		if(appr_dlg.DoModal()==IDOK && appr_dlg.m_el!=0)
		{
			if(!appr_dlg.m_el->IsEmpty())
			{
				m_changed=true;
				m_list_approval.Add(appr_dlg.m_el);
			}
			else if(m_mode_slave)
			{
				if(m_indx_of_zero_approval==-1)
				{
					m_indx_of_zero_approval=m_list_approval.Add(appr_dlg.m_el);
					m_changed=true;
				}
				else
				{
					delete appr_dlg.m_el;
				}
			}
			else
			{
				delete appr_dlg.m_el;
			}
		}
	}
	else if(m_page_num==adj_char)
	{
		if(char_dlg.DoModal()==IDOK && char_dlg.m_el!=0)
		{
			if(char_dlg.m_el->apl_char)
			{
				m_changed=true;
				m_list_char.Add(char_dlg.m_el);
			}else{
				delete char_dlg.m_el;
			}
		}
	}
	else if(m_page_num==adj_doc)
	{
		if(doc_dlg.DoModal()==IDOK && doc_dlg.m_el!=0)
		{
			m_changed=true;
			m_list_doc.Add(doc_dlg.m_el);
		}
	}
	else if(m_page_num==adj_res)
	{
		if(res_dlg.DoModal()==IDOK && res_dlg.m_el!=0)
		{
			m_changed=true;
			m_list_res.Add(res_dlg.m_el);
		}
	}
	else if(m_page_num==adj_blob)
	{
		if(!m_api->m_data.CanFindInBLOB()){return;}
		if(blob_dlg.DoModal()==IDOK && blob_dlg.m_el!=0)
		{
			m_changed=true;
			m_list_blob.Add(blob_dlg.m_el);
		}
	}
	else if(m_page_num==adj_class)
	{
		if(classif_dlg.DoModal()==IDOK && classif_dlg.m_el!=0)
		{
			m_changed=true;
			m_list_class.Add(classif_dlg.m_el);
		}
	}
	FillTabAdjust();
}

//    ""
void CFindQueryDlgEx::OnAdjustDel() 
{
	// TODO: Add your control notification handler code here
	if(m_read_only)return;

	int num_curr= m_ListAdjust.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if( num_curr== -1){
		AfxMessageBox( APL_T("  !"));
		return;
	}
	num_curr=m_ListAdjust.GetItemData(num_curr);
	if(m_page_num==adj_appr){
		m_changed=true;
		m_list_approval.Remove(num_curr);
	}else if(m_page_num==adj_char){
		m_changed=true;
		m_list_char.Remove(num_curr);
	}else if(m_page_num==adj_doc){
		m_changed=true;
		m_list_doc.Remove(num_curr);
	}else if(m_page_num==adj_res){
		m_changed=true;
		m_list_res.Remove(num_curr);
	}else if(m_page_num==adj_blob){
		if(!m_api->m_data.CanFindInBLOB()){return;}
		m_changed=true;
		m_list_blob.Remove(num_curr);	
	}else if(m_page_num==adj_class){
		m_changed=true;
		m_list_class.Remove(num_curr);
	}
	FillTabAdjust();
	
}

//     
void CFindQueryDlgEx::OnDblclkListAdjust(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	int num_curr= m_ListAdjust.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if( num_curr== -1)
	{
		OnAdjustAdd();
	}
	else
	{
		OnAdjustEdit();
	}

	*pResult = 0;
}

//    ""
void CFindQueryDlgEx::OnAdjustEdit() 
{
	// TODO: Add your control notification handler code here
	CFindAdjustDocDlg doc_dlg;
	CFindAdjustApprDlg appr_dlg;
	CFindAdjustCharactDlg char_dlg;
	CFindAdjustResourceDlg res_dlg;
	CFindAdjustBlobDlg blob_dlg;
	CFindAdjustUserDateDlg user_date_dlg;
	CFindAdjustClassifDlg classif_dlg;

	ElValApproval* el_appr=0;
	ElValDoc* el_doc=0;
	ElValChar* el_char=0;
	ElValRes* el_res=0;
	ElValBLOB* el_blob=0;
	ElValClass* el_classif=0;
	
	appr_dlg.m_api=m_api;appr_dlg.m_read_only=m_read_only;appr_dlg.m_mode_slave=m_mode_slave;
	doc_dlg.m_api=m_api;doc_dlg.m_read_only=m_read_only;
	char_dlg.m_api=m_api;char_dlg.m_read_only=m_read_only;
	res_dlg.m_api=m_api;res_dlg.m_read_only=m_read_only;
	blob_dlg.m_api=m_api;blob_dlg.m_read_only=m_read_only;
	user_date_dlg.m_api=m_api;user_date_dlg.m_read_only=m_read_only;
	classif_dlg.m_api=m_api;classif_dlg.m_read_only=m_read_only;

	
	int num_curr= m_ListAdjust.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if( num_curr== -1)
	{
		AfxMessageBox( APL_T("  !"));
		return;
	}
	
	if(m_page_num==adj_appr)
	{
		int indx_appr=m_ListAdjust.GetItemData(num_curr);
		if(m_indx_of_zero_approval != -1 && m_indx_of_zero_approval != indx_appr)
			return;

		appr_dlg.m_el = m_list_approval.GetAt(indx_appr);
		el_appr=new ElValApproval(appr_dlg.m_el);
		if(appr_dlg.DoModal()==IDOK && !el_appr->Compare(appr_dlg.m_el))	
			m_changed=true;
		delete el_appr;
		if(appr_dlg.m_el->IsEmpty())
		{
			m_indx_of_zero_approval = indx_appr;
		}
		else if(m_indx_of_zero_approval == indx_appr)
		{
			m_indx_of_zero_approval = -1;
		}
	}
	else if(m_page_num==adj_char)
	{
		char_dlg.m_el=m_list_char.GetAt(m_ListAdjust.GetItemData(num_curr));
		el_char= new ElValChar(char_dlg.m_el);
		if(char_dlg.DoModal()==IDOK && !el_char->Compare(char_dlg.m_el))	
			m_changed=true;
		delete el_char;
	}
	else if(m_page_num==adj_doc)
	{
		doc_dlg.m_el=m_list_doc.GetAt(m_ListAdjust.GetItemData(num_curr));
		el_doc= new ElValDoc(doc_dlg.m_el);
		if(doc_dlg.DoModal()==IDOK && !el_doc->Compare(doc_dlg.m_el))
			m_changed=true;
		delete el_doc;
	}
	else if(m_page_num==adj_res)
	{
		res_dlg.m_el=m_list_res.GetAt(m_ListAdjust.GetItemData(num_curr));
		el_res= new ElValRes(res_dlg.m_el);
		if(res_dlg.DoModal()==IDOK && !el_res->Compare(res_dlg.m_el))
			m_changed=true;
		delete el_res;

	}
	else if(m_page_num==adj_blob)
	{
		if(!m_api->m_data.CanFindInBLOB()){return;}
		blob_dlg.m_el=m_list_blob.GetAt(m_ListAdjust.GetItemData(num_curr));
		el_blob= new ElValBLOB(blob_dlg.m_el);
		if(blob_dlg.DoModal()==IDOK && !el_blob->Compare(blob_dlg.m_el))
			m_changed=true;
		delete el_blob;
	}
	else if(m_page_num==adj_class)
	{
		classif_dlg.m_el = m_list_class.GetAt(m_ListAdjust.GetItemData(num_curr));
		el_classif = new ElValClass(classif_dlg.m_el);
		if(classif_dlg.DoModal()==IDOK && !el_classif->Compare(classif_dlg.m_el))
			m_changed=true;
		delete el_classif;
	}
	FillTabAdjust();
	
}



/////////////////////////////////////////////////////////////////////////////////////
//   

bool CFindQueryDlgEx::TestNameQuery() 
{
	CString name;
	if(!m_can_save)
		return true;
	//if(m_ChkSaveQuery.GetCheck()!=1)return true;
	if(m_api==0)return true;
	if(m_StringNameQuery==_T("")){
		AfxMessageBox( APL_T("     !"),MB_ICONERROR);
		return false;
	}
	CaplAttrValue tst_values[1];
	aplExtent ext;
	bool flag=false;
	tst_values[0].value.Set(m_StringNameQuery);
	tst_values[0].attr=m_api->m_query_mgr.a_apl_query_name;
	if(m_api->m_data.NET_FindInstancesWithAttrValues(
		m_api->m_query_mgr.e_apl_query,1,&tst_values[0],ext,false)>0)
	{
		if(ext.Size>1 || ext[0]!=m_instance){
			AfxMessageBox( APL_T("   !"),MB_ICONERROR);
			return false;
		}
	}
	return true;
}


void CFindQueryDlgEx::OnExecuteFind() 
{
	UpdateData(TRUE);
	if(m_curr_type_descr == 0) return;
	if(!TestNameQuery())return;
	m_can_make_table=m_CtrlMakeTableResult.IsWindowEnabled()==1;
	SaveDataToBuf();
	if(GenerateStepQL())
	{
		CResizableDialog::OnOK();
	}
};

void CFindQueryDlgEx::OnShowStepql() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if(m_curr_type_descr == 0) return;
	if(!TestNameQuery())return;
	m_can_make_table=m_CtrlMakeTableResult.IsWindowEnabled()==1;
	SaveDataToBuf();
	if(GenerateStepQL(false))
	{
		EndDialog(ID_SHOW_STEPQL);
	}
}

bool CFindQueryDlgEx::GenerateStepQL(bool show_message)
{
	// TODO: Add your control notification handler code here
	int name_num=0;
	int i,count=0;

	SFindAttrDef* attr_def;
	CaplQLQuery::aplQLLogRelation log_rel = CaplQLQuery::aplNOLOGREL;
	CaplValue value;
	CaplValue value2;

	m_AttrsWithLongPerform.RemoveAll();

	m_cur_ext_num=0;
	m_fields = _T("");/*m_fields_pdf=_T("");*/m_extents=_T("");
	m_mode_text = m_curr_type_descr->name4user;
	m_descrtiption = _T("");
	m_blob_query = _T("");
	CString buf;
	if(m_api == 0) return false;

	if(m_is_new_window != 0){*m_is_new_window = m_IsNewWindow==TRUE;}

	for(i=0;i<m_curr_type_descr->list_attrs.Size;i++)
	{
		attr_def = m_curr_type_descr->list_attrs.GetAt(i);
		if(attr_def == 0) continue;
		if(m_attr_values.Get(attr_def->type,log_rel,value,value2))
		{
			if(log_rel == CaplQLQuery::aplNOLOGREL)
			{
				if((m_curr_type_descr->type == FindObject_Document || 
					m_curr_type_descr->type == FindObject_BP || 
					m_curr_type_descr->type == FindObject_Project || 
					m_curr_type_descr->type == FindObject_Change) && attr_def->type == TFO_Type
					|| attr_def->type == TFO_Date1 || attr_def->type == TFO_Date2
					|| attr_def->type == TFO_Date3 || attr_def->type == TFO_Date4)
				{
					//      ""     " "
					count++;
				}
				else
				{
					/*if(show_message)*/AfxMessageBox(APL_T("     '")+attr_def->name4user+_T("'"));
					return false;
				}
			}
			else
			{
				count++;
			}
			if(value.type == aplNOTYPE)
			{
				if((m_curr_type_descr->type == FindObject_Document || 
					m_curr_type_descr->type == FindObject_BP || 
					m_curr_type_descr->type == FindObject_Project || 
					m_curr_type_descr->type == FindObject_Change) && attr_def->type == TFO_Type && log_rel == CaplQLQuery::aplNOLOGREL
					|| attr_def->type == TFO_Date1 || attr_def->type == TFO_Date2
					|| attr_def->type == TFO_Date3 || attr_def->type == TFO_Date4)
				{
					//      ""     
				}
				else
				{
					/*if(show_message)*/AfxMessageBox(APL_T("     '")+attr_def->name4user+_T("'"));
					return false;
				}
			}

		}
	}

	if(show_message && !m_mode_slave && count == 0 &&
		m_list_approval.Size==0 &&
		m_list_char.Size==0 &&
		m_list_doc.Size==0 &&
		m_list_class.Size==0)
	{
		MessageBox( APL_T("     .\n      \n\n  "),
			0,MB_ICONQUESTION|MB_OK);
		return false;
	}

	//   
	if(!MakeObjectIdentify()){
		return false;
	}
	if(m_mode==FindObject_Document){
		if(!MakeQueryBlob()){
			return false;
		}
	}
	//     
	if(m_mode!=FindObject_Category && m_mode!=FindObject_Folder 
				&& m_mode!=FindObject_Find && m_mode!=FindObject_CombinedTable
				&& m_mode!=FindObject_ClassifSystem && m_mode!=FindObject_ClassifLevel
				&& m_mode!=FindObject_Task && m_mode!=FindObject_Process
				&& m_mode!=FindObject_Requirement)
	{
		if(!MakeQueryAppr()){
			return false;
		}
	}
	if(m_mode!=FindObject_Folder && m_mode!=FindObject_Find
				&& m_mode!=FindObject_Change && m_mode!=FindObject_CombinedTable
				&& m_mode!=FindObject_ClassifSystem && m_mode!=FindObject_ClassifLevel
				&& m_mode!=FindObject_Task && m_mode!=FindObject_Process
				&& m_mode!=FindObject_Requirement)
	{
		if(!MakeQueryChar()){
			return false;
		}
	}
	if(m_mode!=FindObject_Folder 
			&& m_mode!=FindObject_Find
			&& m_mode!=FindObject_CombinedTable
			&& m_mode!=FindObject_Task && m_mode!=FindObject_Process)
	{
		if(!MakeQueryDoc()){
			return false;
		}
	}
	if(m_mode==FindObject_BP || m_mode==FindObject_BPInst){
		if(!MakeQueryRes()){
			return false;
		}
	}
	if(m_mode!=FindObject_Category && m_mode!=FindObject_Folder 
		&& m_mode!=FindObject_Find && m_mode!=FindObject_CombinedTable
		&& m_mode!=FindObject_ClassifSystem && m_mode!=FindObject_ClassifLevel
		&& m_mode!=FindObject_Task && m_mode!=FindObject_Process
		&& m_mode!=FindObject_Requirement)
	{
		if(!MakeQueryClassif()){
			return false;
		}
	}

	//          
	if(m_cur_ext_num==0){
		//     .    
		//  
		switch(m_mode)
		{
		case FindObject_Document: // Doc
			m_fields=_T("Ext_");
			m_extents=_T("Ext_{apl_document")+m_object_condition+_T("}\n");
			break;
		case FindObject_BP: // Action
			m_fields=_T("Ext_");
			m_extents=_T("Ext_{apl_business_process")+m_object_condition+_T("}\n");
			break;
		case FindObject_ProductVer: // Product
		case FindObject_Product: // Product
		case FindObject_Lot: // Lot
		case FindObject_ProductInst: // Product Inst
		case FindObject_Category: 
		case FindObject_Folder: 			
		case FindObject_Project: 			
		case FindObject_Person: 			
		case FindObject_Organization: 			
		case FindObject_Find: 
		case FindObject_CombinedTable: 
		case FindObject_Change: 
		case FindObject_ClassifSystem: 
		case FindObject_ClassifLevel: 
		case FindObject_BPInst: 
		case FindObject_Process:
		case FindObject_Task:
		case FindObject_Requirement:
		case FindObject_Refusal:

			m_fields=_T("Ext_");
			m_extents=_T("Ext_{")+m_object_name+m_object_condition+_T("}\n");
			break;
		}				
		
	}

	if(m_mode==FindObject_Person && !m_ctrl_find_version.GetCheck())
	{
		aplExtent ext;
		CaplAttrValue tst_values[1];               
		tst_values[0].value.Set(APL_T("")); 
		tst_values[0].attr=m_api->m_appr_mgr.a_org_name;      
		m_api->m_data.FindInstancesWithAttrValuesInLocalCache(m_api->m_appr_mgr.e_org,0,1,tst_values,ext,false,false,false);
		if(ext.GetSize() == 0)
		{
			AfxMessageBox(APL_T("     !"));
		}
		else if(ext.GetSize() > 1)
		{
			AfxMessageBox(APL_T("       !"));
		}
		else
		{
			buf.Format(_T("#%i"),ext.GetAt(0)->GetId());
			m_extents += _T("Ext_D{person_and_organization(.the_organization = ") + buf + _T(" AND .the_person->") + m_object_name + m_object_condition + _T(")}.the_person\n");	
			m_fields += _T(" NOT IN Ext_D");
		}
	}
	
	m_QL_query=_T("SELECT");
	if(m_IsMatchCase == FALSE)
		m_QL_query+=_T(" NO_CASE");
	m_QL_query+=_T("\n");
	m_QL_query+=m_fields;
	m_QL_query+=_T("\nFROM\n")+m_extents+_T("\nEND_SELECT");
	
	m_is_adjustment=m_list_approval.Size>0 || m_list_char.Size>0 || m_list_doc.Size>0;

	if(m_AttrsWithLongPerform.GetSize() > 0)
	{
		CString mess;
		if(m_AttrsWithLongPerform.GetSize() > 1)
		{
			mess = APL_T("   '" );
			for(int z=0;z<m_AttrsWithLongPerform.GetSize();z++)
			{
				if(z > 0) mess += _T("', '");
				mess+= m_AttrsWithLongPerform.GetAt(z);
			}
		}
		else
		{
			mess = APL_T("   '" );
			mess+= m_AttrsWithLongPerform.GetAt(0);
		}
		mess+= APL_T("'    .\r\n    ?");
		if(AfxMessageBox(mess,MB_YESNO)==IDNO)
		{
			return false;
		}
	}


	return true;
}


//       
//       
bool CFindQueryDlgEx::MakeObjectIdentify()
{
	CString str_par=_T(""),str_rel=_T(""),str_rel_descr=_T(""),str_temp=_T(""),buf=_T("");
	int i,j;
	CString attr_conditions_3 = _T(""),path_group3 = _T("");
	CString attr_conditions_2 = _T(""),path_group2 = _T("");
	CString attr_conditions_1 = _T("");
	CString attr_conditions_top = _T("");
	CString attr_condition = _T("");
	
	CaplEntity* e_top_parent = 0;
	CaplAttr* a_top_parent_ref = 0;

	int num1=0,num2=0,num3=0,num_top=0;
	CString cur_word;

	aplExtent ext;

	SFindAttrDef *attr_def;
	CFindAttrPath *ap1 = 0, *apE = 0;
	CaplQLQuery::aplQLLogRelation log_rel = CaplQLQuery::aplNOLOGREL;
	CaplValue value,value2;
	CaplInstance *inst;
	CString str_mark;

	if(m_curr_type_descr == 0) return false;

	m_object_name = m_curr_type_descr->m_object_name;
	// 
	m_object_condition=_T("(");

	//      
	for(i=0;i<m_curr_type_descr->list_attrs.Size;i++)
	{
		attr_def = m_curr_type_descr->list_attrs.GetAt(i);
		if(attr_def == 0) continue;
		//    ,    
		if(m_attr_values.Get(attr_def->type,log_rel,value,value2))
		{
			//      -    
			ap1 = attr_def->attr_path;
			while(ap1 !=0 && ap1->next_step != 0)
			{
				ap1 = ap1->next_step;
			}
			apE = ap1;

			str_rel=_T(" ")+CaplQLQuery::LogOp2String(log_rel,false);
			str_rel_descr=_T(" ")+CaplQLQuery::LogOp2String(log_rel,false)+_T(" '");
			attr_condition = _T("");
			value.Get(str_par);

			switch(attr_def->type)
			{
			case TFO_Standart:
			case TFO_Groupe:
				if(str_par == APL_T("") || str_par == APL_T("") || str_par == APL_T(""))
				{
					attr_condition = apE->attr + str_rel+_T(" true ");
					m_descrtiption+= attr_def->name4user + _T(" ") + str_rel_descr + _T("true; ");
				}
				else
				{
					attr_condition = apE->attr + str_rel+_T(" false ");
					m_descrtiption+= attr_def->name4user + _T(" ") + str_rel_descr + _T("false; ");

				}
				break;

			case TFO_Type:
				if(log_rel==CaplQLQuery::aplNOLOGREL)
				{
					if(m_mode==FindObject_Change)
					{
						attr_condition = apE->attr + _T(" = '' ");
					}
					else
					{
						attr_condition = apE->attr + _T(" = #0 ");
					}
					m_descrtiption += APL_T(":  ; ");
				}
				else
				{
					if(m_mode == FindObject_ProductVer)
					{
						if(str_par == _T(""))
						{
							AfxMessageBox( APL_T("  !"));
							return false;
						}
						//   product-  
						str_par=m_api->m_prd_mgr.StrConvertRus2PdfType(str_par);
						attr_condition = apE->attr + _T(" ")+str_rel+_T(" '")+ str_par+ _T("'");

					}
					if(m_mode ==FindObject_Change)
					{
						if(str_par == _T(""))
						{
							AfxMessageBox( APL_T("  !"));
							return false;
						}
						//   -    
						attr_condition = apE->attr + _T(" ")+str_rel+_T(" '")+ str_par+ _T("'");

					}
					if(m_mode==FindObject_Document)
					{
						//          
						value.Get(inst);
						if(inst != 0 )
						{
							buf.Format(_T(" #%i"),inst->GetId());
							attr_condition = apE->attr + _T(" ")+str_rel+buf;
						}
						else
						{
							attr_condition = apE->attr + _T("->document_type.product_data_type ")+str_rel+_T(" '' ");
						}
						
						m_api->m_data.GetAttr(inst,m_api->m_doc_mgr.a_dt_pdt,str_par);

					}
					if(m_mode==FindObject_BP)
					{
						//          
						value.Get(inst);
						if(inst != 0 )
						{
							buf.Format(_T(" #%i"),inst->GetId());
							attr_condition = apE->attr + _T(" ")+str_rel+buf;
						}
						else
						{
							attr_condition = apE->attr + _T("->apl_business_process_type.name ")+str_rel+_T(" '' ");
						}
					}
					if(m_mode==FindObject_Project)
					{
						//          
						value.Get(inst);
						if(inst != 0 )
						{
							buf.Format(_T(" #%i"),inst->GetId());
							attr_condition = apE->attr + _T(" ")+str_rel+buf;
						}
						else
						{
							attr_condition = apE->attr + _T("->apl_project_type.name ")+str_rel+_T(" '' ");
						}
					}
					if(m_mode==FindObject_Refusal)
					{
						//          
						value.Get(inst);
						if(inst != 0 )
						{
							buf.Format(_T(" #%i"),inst->GetId());
							attr_condition = apE->attr + _T(" ")+str_rel+buf;
						}
						else
						{
							attr_condition = apE->attr + _T(" ")+str_rel+_T(" #0 ");
						}
					}
					m_descrtiption+= APL_T(" ='")+str_par+_T("'; ");
				}
				
				break;

			case TFO_Date1:  // - 
			case TFO_Date2:
			case TFO_Date3:
			case TFO_Date4:
				if(log_rel == CaplQLQuery::aplNOLOGREL )
				{
					attr_condition = apE->attr + _T(" = '' ");
				}
				else if(log_rel == CaplQLQuery::aplEQUAL )
				{
					attr_condition = apE->attr + _T(" like_left '")+str_par.Left(8)+_T("' ");
				}
				else if(log_rel == CaplQLQuery::aplBIG )
				{	
					attr_condition = apE->attr + str_rel+_T(" '")+str_par.Left(8)+_T("235959' ");
				}
				else if(log_rel == CaplQLQuery::aplBIGEQUAL )
				{
					attr_condition =apE->attr +  str_rel+_T(" '")+str_par.Left(8)+_T("000000' ");
				}
				else if(log_rel == CaplQLQuery::aplSMALL )
				{
					attr_condition = apE->attr + str_rel+_T(" '")+str_par.Left(8)+_T("000000' ");
				}
				else if(log_rel == CaplQLQuery::aplSMALLEQUAL )
				{
					attr_condition = apE->attr + str_rel+_T(" '")+str_par.Left(8)+_T("235959' ");
				}
				else if(log_rel == CaplQLQuery::aplNOTEQUAL )
				{
					attr_condition = apE->attr + _T(" not like_left '")+str_par.Left(8)+_T("' ");
				}
				else if(log_rel == CaplQLQuery::aplINDIAPAZON )
				{
					if(value2 < value)
					{
						MessageBox( APL_T("  ,   .\n    "),
							0,MB_ICONEXCLAMATION|MB_OK);
						return false;
					}
					attr_condition = _T("(") + apE->attr + _T(" > '")+str_par.Left(8)+_T("000000' AND");
					value2.Get(str_par);
					attr_condition += apE->attr + _T(" < '")+str_par.Left(8)+_T("235959' ) ");
				}
				m_descrtiption+= attr_def->name4user + _T(" ") + str_rel_descr + str_par;
				break;

			case TFO_RelContext:
				//    
				break;

			case TFO_ProcRefusalCulprit:
				//    
				m_AttrsWithLongPerform.Add(attr_def->name4user);
			case TFO_ProcOwner:
			case TFO_ProjCustomer:
			case TFO_ProjExecutors:
			case TFO_ProjCoexecutors:
			case TFO_InAggr:
			case TFO_RefOrg	:		
			case TFO_RefSector:		
			case TFO_RefCulprit:		
			case TFO_RefStage:		

			case TFO_RefMainPDF:		
			case TFO_RefMainItem:		
			case TFO_RefSystem	:	
			case TFO_RefFailedItem:	
			case TFO_RefFailedPart:	
			case TFO_RefConditions:	
			case TFO_RefDof		:	
			case TFO_RefFaultReason	:
			case TFO_RefMethod:		
			case TFO_RefConsequence	:
			case TFO_RefManif:		
			case TFO_ProcTemplate:		
			case TFO_ProcActivity:		
				value.Get(inst);
				if(inst != 0 )
				{
					buf.Format(_T(" #%i"),inst->GetId());
					attr_condition = apE->attr + _T(" ") + str_rel + buf;
				}
				break;

			case TFO_ProjKurator:
			case TFO_ProcTaskPerformer:
				value.Get(inst);
				if(inst != 0 )
				{
					buf.Format(_T(" #%i"),inst->GetId());
					attr_condition = _T("(") + apE->attr + _T(" ") + str_rel + buf ;
					if(log_rel == CaplQLQuery::aplEQUAL)
					{
						attr_condition += _T(" OR ");
					}
					else
					{
						attr_condition += _T(" AND ");
					}
					attr_condition += apE->attr + _T("->apl_official.actual_person ") + str_rel + buf + _T(")");
				}
				break;

			//case TFO_ProcTaskName: -   
			//case TFO_ProcState: -   
			case TFO_ProcTaskExpired:
				{
					COleDateTime odt = COleDateTime::GetCurrentTime();
					aplDate2String(odt,str_temp);
					if(str_par == APL_T(""))
					{
						attr_condition = apE->attr + _T(" < '") + str_temp + _T("'");
						m_descrtiption+= attr_def->name4user + APL_T(" =  ");
					}
					else
					{
						attr_condition = apE->attr + _T(" > '") + str_temp + _T("'");
						m_descrtiption+= attr_def->name4user + APL_T(" =  ");
					}
				}
				break;
			case TFO_ProcTaskExpiredNDays:
				{
					int int_val;
					value.Get(int_val);
					if(int_val==0)int_val=3;
					COleDateTimeSpan odts(int_val,0,0,0); 
					COleDateTime odt = COleDateTime::GetCurrentTime() + odts;
					aplDate2String(odt,str_temp);
					str_temp.Delete(8,6);
					str_temp+=_T("000000");

					attr_condition = apE->attr  + str_rel + _T("'") + str_temp + _T("'");
					m_descrtiption+= attr_def->name4user  + str_rel + str_par + APL_T("  ");

				}
				break;



			case TFO_Source:
				str_par=m_api->m_prd_mgr.StrConvertRus2MakeOrBuy(str_par);
				//break; -    !      !
			default:
				//AfxMessageBox( APL_T("      .\n  !"));
				//return false;
				if(str_par==_T("") && (log_rel==CaplQLQuery::aplLIKE ||
					log_rel==CaplQLQuery::aplNOTLIKE ||log_rel==CaplQLQuery::aplNOTLIKELEFT ||
					log_rel==CaplQLQuery::aplNOTLIKERIGHT))
				{
					AfxMessageBox( APL_T("  ")+ attr_def->name4user +APL_T(" !"));
					return false;
				}
				if(str_par.Find(_T('\''))==-1) str_mark=_T("'"); else str_mark=_T("\"");

				if(log_rel == CaplQLQuery::aplLOGICALRELATION || m_IsSubstring==TRUE )
				{
					if(! m_api->m_query_mgr.MakeAttrConditionWithGroup(str_par, apE->attr, attr_def->name4user, m_IsBrackets==TRUE, attr_condition, str_rel))
					{
						return false;
					}

				}
				else
				{
					attr_condition = apE->attr + str_rel+_T(" ") +str_mark+str_par+str_mark+_T(" ");
				}
				m_descrtiption+= attr_def->name4user + _T(" ") + str_rel_descr + str_par + _T("'; ");
				break;
			}

			//        
			if(attr_def->e_top_parent != 0 && attr_def->a_top_parent_ref != 0 )
			{
				ap1 = attr_def->attr_path;
				//attr_conditions_top += _T(" AND ");
				if(attr_def->type == TFO_RelContext)
				{
					// 
					value.Get(ext);
					if(ext.GetSize()==0)
					{
						AfxMessageBox( APL_T("    !"));
						return false;
					}
					for(j=0;j<ext.GetSize();j++)
					{
						str_par.Format(_T(" LIKE #%i"),ext.GetAt(j)->GetId());
						if(attr_conditions_top != _T(""))attr_conditions_top += _T(" AND ");
						attr_conditions_top += ap1->attr + str_par;
					}
					//attr_conditions_top += _T(" AND ") + ap1->attr + _T(" aggr_empty");
				}
				else
				{
					if(num_top > 0)attr_conditions_top += _T(" AND ");

					if(attr_condition != _T("")) str_temp = attr_condition;
					else if(! m_api->m_query_mgr.MakeAttrConditionWithGroup(str_par, ap1->attr, attr_def->name4user, m_IsBrackets==TRUE, str_temp, str_rel))
					{
						return false;
					}
					attr_conditions_top += str_temp;

				}

				num_top++;			
				e_top_parent = attr_def->e_top_parent;
				a_top_parent_ref = attr_def->a_top_parent_ref;
			}
			else if(attr_def->path_length == 1)
			{
				//ap1 = attr_def->attr_path;
				if(num1 > 0) attr_conditions_1 += _T(" AND ");
				attr_conditions_1 += attr_condition;
				num1++;			
			}
			else if(attr_def->path_length == 2)
			{
				path_group2 = _T("");
				ap1 = attr_def->attr_path;
				while(ap1 !=0 && ap1->next_step != 0)
				{
					path_group2 += ap1->attr + _T("->") + ap1->to_entity;
					ap1 = ap1->next_step;
				}
				if(num2 > 0) attr_conditions_2 += _T(" AND ");
				attr_conditions_2 += attr_condition;
				num2++;
			}
			else if(attr_def->path_length == 3)
			{
				path_group3 = _T("");
				ap1 = attr_def->attr_path;
				while(ap1 !=0 && ap1->next_step != 0)
				{
					path_group3 += ap1->attr + _T("->") + ap1->to_entity;
					ap1 = ap1->next_step;
				}
				if(num3 > 0) attr_conditions_3 += _T(" AND ");
				attr_conditions_3 += attr_condition;
				num3++;
			}
		}
	}
	
	if(num1 + num2 + num3 > 2)m_object_condition += _T("(");
	if(num1 > 0)
	{
		if(num1 > 1)m_object_condition += _T(" ( ");
		m_object_condition += attr_conditions_1;
		if(num1 > 1)m_object_condition += _T(" ) ");
	}
	if(num1 > 0 && (num2 > 0 || num3 > 0))m_object_condition += _T(" AND \n");
	if(num2 > 0)
	{
		m_object_condition += path_group2;
		if(num2 > 1)m_object_condition += _T(" ( ");
		m_object_condition += attr_conditions_2;
		if(num2 > 1)m_object_condition += _T(" ) ");
	}
	if(num2 > 0 && num3 > 0)m_object_condition += _T(" AND \n");
	if(num3 > 0)
	{
		m_object_condition += path_group3;
		if(num3 > 1)m_object_condition += _T(" ( ");
		m_object_condition += attr_conditions_3;
		if(num3 > 1)m_object_condition += _T(" ) ");
	}
	if(num1 + num2 + num3 > 2)m_object_condition += _T(")");

	if(num1 + num2 + num3 == 0)
	{
		if(m_mode==FindObject_ProductVer)
		{
			m_object_condition=_T(".of_product->product.id LIKE ''");
		}
		else
		{
			m_object_condition = _T("");
		}
	}
	else
	{
		m_object_condition += _T(")\n");
	}

	if(a_top_parent_ref!=0 && e_top_parent!=0 && attr_conditions_top != _T(""))
	{
		MakeExtAndField(e_top_parent,a_top_parent_ref,attr_conditions_top,true);
	}

	return true;
}// bool CFindQueryDlgEx::MakeObjectIdentify(){

//   QL     
bool CFindQueryDlgEx::MakeQueryClassif()
{
	ElValClass* el_class;

	CString condition = _T("") ,part_id, part_name, part_type, buf;
	int i,j,count;
	aplExtent ext_classif;

	CorrectFieldDescr1(m_list_class.Size, m_is_or_class);

	for(i=0;i<m_list_class.Size;i++)
	{
		condition = _T(" (");
		count=0;
		//      
		el_class=m_list_class.GetAt(i);
		if(el_class==0)continue;

		if(el_class->classif == 0)
			continue;

		CorrectFieldDescr2(i, m_is_or_class);

		m_descrtiption+= APL_T(" : ");
		
		// ( .   0 ,  )
		if(m_api->m_data.IsKindOf(el_class->classif, m_api->m_classifier_mgr.e_apl_classifier_system))
		{
			//        
			m_api->m_classifier_mgr.LoadSubClassifierSystems(el_class->classif,ext_classif,true);
			ext_classif.Add(el_class->classif);
			for(j=0;j<ext_classif.GetSize();j++)
			{
				buf.Format(_T(".system = #%i"),ext_classif.GetAt(j)->GetId());
				if(j>0){condition += _T(" OR ");m_descrtiption += _T("  ");}
				condition += buf;
				m_api->m_classifier_mgr.GetItemName(ext_classif.GetAt(j),buf);
				m_descrtiption += buf;
			}	
			condition += _T(")\n ");
		}
		else if(m_api->m_data.IsKindOf(el_class->classif, m_api->m_classifier_mgr.e_apl_classifier_level))
		{
			//         
			m_api->m_classifier_mgr.LoadSubClassifierLevels(el_class->classif,ext_classif,true);
			ext_classif.Add(el_class->classif);
			for(j=0;j<ext_classif.GetSize();j++)
			{
				buf.Format(_T(".classifier = #%i"),ext_classif.GetAt(j)->GetId());
				if(j>0){condition += _T(" OR ");m_descrtiption += _T("  ");}
				condition += buf;
				m_api->m_classifier_mgr.GetItemName(ext_classif.GetAt(j),buf);
				m_descrtiption += buf;
			}	
			condition += _T(")\n ");
		}

		MakeExtAndField(m_api->m_classifier_mgr.e_apl_classifier_association,
			m_api->m_classifier_mgr.a_apl_classifier_association_item,condition,el_class->is_exist);

	}

	CorrectFieldDescr3(m_list_class.Size, m_is_or_class);

	return true;

}


//   QL    
bool CFindQueryDlgEx::MakeQueryAppr()
{
	ElValApproval* el_apr;

	CString condition=_T(""),buf;
	CaplInstance* inst=0;
	bool is_second=false;

	int i;
//	int year,month,day;

	CorrectFieldDescr1(m_list_approval.Size, m_is_or_approval);

	//       
	if(m_indx_of_zero_approval!=-1)
	{
		el_apr=m_list_approval.GetAt(m_indx_of_zero_approval);
		if(el_apr==0)return false;
		m_descrtiption+=(el_apr->is_exist)? APL_T("   "): APL_T("    ");

		condition=_T(" .level LIKE ''");
		//  (),       
		MakeExtAndField(m_api->m_appr_mgr.e_apl_appr_pers_org,m_api->m_appr_mgr.a_appr_item,condition,el_apr->is_exist);
	}
	else
	{
		for(i=0;i<m_list_approval.Size;i++)
		{
			is_second=false;
			condition=_T(" ");
			
			el_apr=m_list_approval.GetAt(i);
			if(el_apr==0)continue;
			if(!m_mode_slave && el_apr->IsEmpty())
			{
				continue;
			}
			CorrectFieldDescr2(i, m_is_or_approval);

			m_descrtiption+=(el_apr->is_exist)? APL_T("  "): APL_T("  ");
			if(!el_apr->is_exist && m_mode==FindObject_All){
				AfxMessageBox( APL_T("      !"));
				return false;
			}

			//  (<=)  pathelement   
			if(el_apr->status != 0){
				buf.Format(_T(" .status = #%i"),el_apr->status->GetId());
				if(is_second)condition+=_T(" AND ");
				condition+=buf;
				is_second=true;
				apidata.GetAttr(el_apr->status,m_api->m_appr_mgr.a_appr_status_name,buf);
				m_descrtiption+=_T("'")+buf+_T("'; ");
			}
			if(el_apr->descr != _T("")){
				buf = _T(" .notes ");
				buf += CaplQLQuery::LogOp2String(el_apr->descr_relation, false);
				buf += _T(" '") + el_apr->descr+_T("' ");

				if(is_second)condition+=_T(" AND ");
				condition+=buf;
				is_second=true;

				m_descrtiption+=_T("  ");
				m_descrtiption += CaplQLQuery::LogOp2String(el_apr->descr_relation, true);
				m_descrtiption += _T(" '") + el_apr->descr+_T("'; ");

			}
			if(el_apr->person != 0)
			{
				if(apidata.IsKindOf(el_apr->person,m_api->m_appr_mgr.e_pers_org))
				{
					apidata.GetAttr(el_apr->person,m_api->m_appr_mgr.a_po_the_pers,inst);
				}
				else if(apidata.IsKindOf(el_apr->person,m_api->m_appr_mgr.e_person))
				{
					inst = el_apr->person;
				}
				else
				{
					inst = 0;
				}
				if(inst != 0)
				{
					buf.Format(_T(" (.person_organization->person_and_organization.the_person = #%i OR .person_organization = #%i )"),inst->GetId(),inst->GetId());
					if(is_second)condition+=_T(" AND ");
					condition+=buf;
					is_second=true;
					apidata.GetAttr(inst,m_api->m_appr_mgr.a_pers_last_name,buf);
					m_descrtiption+= APL_T(" ")+buf+_T("; ");
				}
			}
			if(el_apr->pers_org_role!=_T("")){
				if(el_apr->pers_org_role_eq){
					buf.Format(_T(" .role = '%s'"),el_apr->pers_org_role);
				}else{
					buf.Format(_T(" .role LIKE '%s'"),el_apr->pers_org_role);
				}
				if(is_second)condition+=_T(" AND ");
				condition+=buf;
				is_second=true;
				m_descrtiption+= APL_T("  '")+	el_apr->pers_org_role+_T("'; ");
			}
			if(el_apr->is_single_date){
				if(el_apr->date_time_beg != 0){
					buf=FillDateCompare(_T("approval_date_time_s"),CaplQLQuery::aplEQUAL,el_apr->date_time_beg);
					if(is_second)condition+=_T(" AND ");
					condition+=buf;
					is_second=true;
					buf=el_apr->date_time_beg->Format(_T("%d.%m.%Y %H:%M:%S"));
					m_descrtiption+= APL_T(" ")+	buf+_T("; ");
					
				}
			}else{
				if(el_apr->date_time_beg != 0){
					buf=FillDateCompare(_T("approval_date_time_s"),CaplQLQuery::aplBIGEQUAL,el_apr->date_time_beg);
					if(is_second)condition+=_T(" AND ");
					condition+=buf;
					is_second=true;
					buf=el_apr->date_time_beg->Format( APL_T(" %d.%m.%Y %H:%M:%S"));
					m_descrtiption+=buf;
				}
				if(el_apr->date_time_end != 0){
					buf=FillDateCompare(_T("approval_date_time_s"),CaplQLQuery::aplSMALLEQUAL,el_apr->date_time_end);
					if(is_second)condition+=_T(" AND ");
					condition+=buf;
					is_second=true;
					buf=el_apr->date_time_end->Format( APL_T("  %d.%m.%Y %H:%M:%S"));
					m_descrtiption+=buf;
				}
			}
			if(el_apr->revoc_date_time_beg != 0){
				buf=FillDateCompare(_T("revocation_date_time"),CaplQLQuery::aplBIGEQUAL,el_apr->revoc_date_time_beg);
				if(is_second)condition+=_T(" AND ");
				condition+=buf;
				is_second=true;
				buf=el_apr->revoc_date_time_beg->Format( APL_T(" %d.%m.%Y %H:%M:%S"));
				m_descrtiption+=buf;
			}
			if(el_apr->revoc_date_time_end != 0){
				buf=FillDateCompare(_T("revocation_date_time"),CaplQLQuery::aplSMALLEQUAL,el_apr->revoc_date_time_end);
				if(is_second)condition+=_T(" AND ");
				condition+=buf;
				is_second=true;
				buf=el_apr->revoc_date_time_end->Format( APL_T("  %d.%m.%Y %H:%M:%S"));
				m_descrtiption+=buf;
			}
			if(el_apr->is_dig_sign==0){
				buf.Format(_T(" .digital_sign = ''"),el_apr->pers_org_role);
				if(is_second)condition+=_T(" AND ");
				condition+=buf;
				is_second=true;
				m_descrtiption+=APL_T(" ");
			}else if(el_apr->is_dig_sign==1){
				buf.Format(_T(" .digital_sign != ''"),el_apr->pers_org_role);
				if(is_second)condition+=_T(" AND ");
				condition+=buf;
				is_second=true;
				m_descrtiption+=APL_T(" ");
			}

			m_descrtiption+=_T("; ");
			
			//  (),       
			MakeExtAndField(m_api->m_appr_mgr.e_apl_appr_pers_org,m_api->m_appr_mgr.a_appr_item,condition,el_apr->is_exist);
		}
	}
	CorrectFieldDescr3(m_list_approval.Size, m_is_or_approval);

	return true;
/**/
}

//   QL    
bool CFindQueryDlgEx::MakeQueryChar()
{
	int i=0;
	ElValChar* el_ch;
	CaplEntity* base_entity;
	CString condition,buf,buf1;

	CorrectFieldDescr1(m_list_char.Size, m_is_or_char);

	for(i=0;i<m_list_char.Size;i++)
	{
		condition=_T("");

		//      
		el_ch=m_list_char.GetAt(i);
		if(el_ch==0)continue;
		if(el_ch->apl_char==0)continue;
		
		if(!el_ch->is_exist && m_mode==FindObject_All){
			AfxMessageBox( APL_T("      !"));
			return false;
		}

		CorrectFieldDescr2(i, m_is_or_char);

		m_descrtiption+=(el_ch->is_exist)? APL_T("  \'"): APL_T("  \'");
		apidata.GetAttr(el_ch->apl_char,m_api->m_charact_mgr.a_apl_charact_name,buf);
		m_descrtiption+=buf+_T("\' ");
		if(el_ch->type != 0 )
		{
			m_descrtiption+= APL_T(" ; ");
		}
		if(el_ch->b_max || el_ch->b_min || el_ch->b_val|| el_ch->dtt != 0)
		{
			m_descrtiption+= APL_T(" ; ");
		}
		
			//  AND        
		//    
		buf.Format(_T(" .characteristic = #%i "),el_ch->apl_char->GetId());
		if(el_ch->type != 0){
			buf1.Format(_T(" AND .assignment_type = #%i"),el_ch->type->GetId());
		}else{
			buf1=_T("");
		}
		condition+=buf+buf1;
		base_entity=m_api->m_charact_mgr.e_apl_charact_value;
		if(el_ch->b_max || el_ch->b_min || el_ch->b_val){
				//     
			condition+=FillCharValue(el_ch,&base_entity);
		}
		MakeExtAndField(base_entity,m_api->m_charact_mgr.a_apl_charact_val_item,condition,el_ch->is_exist);
	}

	CorrectFieldDescr3(m_list_char.Size, m_is_or_char);

	return true;
}


//   QL   
CString CFindQueryDlgEx::FillCharValue(ElValChar* el_ch,CaplEntity** base_entity)
{
	CString result,s_val,s_max,s_min,buf;

	CaplInstance * unit;
	int num_field=0;
	if(base_entity==0)return _T("");

	if(el_ch->log_relation!=CaplQLQuery::aplEXIST){
//		result=_T(" AND .val->");   27  28 
		result=_T(" AND ");
	}else{
		result=_T("");
		return result;
	}
	
	apidata.GetAttrBN(el_ch->apl_char,_T("unit"),unit);
	if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_step_unit) ||
		apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_descript_unit) ||
		apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_enum_unit) || 
		apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_monetary_unit))
	{
		//    
		if(el_ch->b_val){
			s_val=_T(".val ")+
				CaplQLQuery::LogOp2String(el_ch->log_relation,false)+
				el_ch->val;
			num_field++;
		}
		if(el_ch->b_max){
			s_max=_T(".max_deviation ")+
				CaplQLQuery::LogOp2String(el_ch->log_relation_max,false)+
				el_ch->val_max;
			num_field++;
		}
		if(el_ch->b_min){
			s_min=_T(".min_deviation ")+
				CaplQLQuery::LogOp2String(el_ch->log_relation_min,false)+
				el_ch->val_min;
			num_field++;
		}

		//       
		//     apl_characterictic_value
		if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_step_unit)){
//			result+=_T("apl_measured_characteristic_value");   27  28 
			*base_entity=m_api->m_charact_mgr.e_meas_value;
			switch(num_field){
			case 1:
				if(el_ch->b_val){result+=s_val;}
				else if(el_ch->b_max){result+=s_max;}
				else if(el_ch->b_min){result+=s_min;}
				break;
			case 2:
				result+=_T("(");
				if(el_ch->b_val&&el_ch->b_max){
					result+=s_val+_T(" AND ")+s_max;
				}
				if(el_ch->b_val&&el_ch->b_min){
					result+=s_val+_T(" AND ")+s_min;
				}
				if(el_ch->b_max&&el_ch->b_min){
					result+=s_max+_T(" AND ")+s_min;
				}
				result+=_T(")");
				break;
			case 3:
				result+=_T("(")+s_val+_T(" AND ")+s_max+_T(" AND ")+s_min+_T(")");
				break;
			default:
				return CString(_T(""));
			}

		}else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_descript_unit)){
			if(!el_ch->b_val)return CString(_T(""));
//			result+=_T("apl_descriptive_characteristic_value")+s_val;   27  28 
			*base_entity=m_api->m_charact_mgr.e_descr_value;
			result+=s_val;
		}else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_enum_unit)){
			if(!el_ch->b_val)return CString(_T(""));
//			result+=_T("apl_enumeration_characteristic_value")+s_val;   27  28 
			*base_entity=m_api->m_charact_mgr.e_enum_value;
			result+=s_val;
		}else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_monetary_unit)){
			if(!el_ch->b_val)return CString(_T(""));
//			result+=_T("apl_monetary_characteristic_value")+s_val;   27  28 
			*base_entity=m_api->m_charact_mgr.e_monet_value;
			result+=s_val;
		}
	}else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_time_unit)){
		//     
		if(el_ch->b_val){
//			result+=_T("apl_point_in_time_characteristic_value")+   27  28 
			*base_entity=m_api->m_charact_mgr.e_time_val;
			result+=
				FillDateCompare(_T("val_s"),el_ch->log_relation,el_ch->dtt);
		}
	}
	else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_reference_unit))
	{
		if(el_ch->b_val){
			if(el_ch->m_cur_ref_val==0)return _T("");
			s_val.Format(_T(" #%i "),el_ch->m_cur_ref_val->GetId());
//			result+=_T("apl_reference_value.val ")+   27  28 
			*base_entity=m_api->m_charact_mgr.e_apl_reference_value;
			result+=_T(".val ")+
				CaplQLQuery::LogOp2String(el_ch->log_relation,false)+
				s_val;
		}
	}
	return result;
}

//   QL    
bool CFindQueryDlgEx::MakeQueryDoc()
{
	ElValDoc* el_doc;
	CString condition,part_id,part_name,part_type,buf;
	int i,count;

	CorrectFieldDescr1(m_list_doc.Size, m_is_or_doc);

	for(i=0;i<m_list_doc.Size;i++)
	{
		condition=_T(" .assigned_document->document");

		count=0;
		//      
		el_doc=m_list_doc.GetAt(i);
		if(el_doc==0)continue;
		if(!el_doc->is_exist && m_mode==FindObject_All){
			AfxMessageBox( APL_T("      !"));
			return false;
		}

		CorrectFieldDescr2(i, m_is_or_doc);

		m_descrtiption+=(el_doc->is_exist)? APL_T(" : "): APL_T(" : ");
		
		if(el_doc->id != _T("")){
			//  AND        
			//    
			if(el_doc->is_eq_id){
				part_id.Format(_T(".id = '%s' "),el_doc->id);
				m_descrtiption+= APL_T(" = '")+el_doc->id+_T("'; ");
			}else{
				part_id.Format(_T(".id LIKE '%s' "),el_doc->id);
				m_descrtiption+= APL_T("  '")+el_doc->id+_T("'; ");
			}
			count++;
			
		}
		if(el_doc->name != _T("")){
			//  AND        
			//    
			if(el_doc->is_eq_name){
				part_name.Format(_T(".name = '%s' "),el_doc->name);
				m_descrtiption+= APL_T(" = '")+el_doc->name+_T("'; ");
			}else{
				part_name.Format(_T(".name LIKE '%s' "),el_doc->name);
				m_descrtiption+= APL_T("  '")+el_doc->name+_T("'; ");
			}
			count++;
		}
		if(el_doc->type != 0){
			//  AND        
			//    
			part_type.Format(_T(".kind = #%i "),el_doc->type->GetId());
			count++;
			apidata.GetAttr(el_doc->type,m_api->m_doc_mgr.a_dt_pdt,buf);
			m_descrtiption+= APL_T(" = '")+buf+_T("'; ");
			
		}
		if(count==0){continue;}
		else if(count==1){
			if(el_doc->type != 0){condition+=part_type;}
			else if(el_doc->id != _T("")){condition+=part_id;}
			else if(el_doc->name != _T("")){condition+=part_name;}
		}else{
			condition+=_T("(");
			if(el_doc->type != 0){condition+=part_type;}
			if(el_doc->type != 0 && el_doc->id != _T("")){condition+=_T(" AND ");}
			if(el_doc->id != _T("")){condition+=part_id;}
			if(el_doc->name != _T("")){condition+=_T(" AND ")+part_name;}
			condition+=_T(")");
		}

		MakeExtAndField(m_api->m_doc_mgr.e_apl_doc_ref,
			m_api->m_doc_mgr.a_apl_doc_ref_item,condition,el_doc->is_exist);
	}

	CorrectFieldDescr3(m_list_doc.Size, m_is_or_doc);

	return true;
}

bool CFindQueryDlgEx::MakeQueryBlob()
{
	ElValBLOB* el_blob;
	CString prefix,middle,postfix;
	CString ext_eq=_T(""),ext_like=_T("");
	int i,count;
	if(m_ctrl_find_version.GetCheck()){
		//      
		prefix=_T("apl_document(")+m_object_condition+_T(" AND .active->");
		middle=_T("");
		postfix=_T("))}\r\n");
	}else{
		prefix=_T("");
		middle=_T("(.of_document->apl_document")+m_object_condition+_T(" AND ");
		postfix=_T("))}.of_document->apl_document\r\n");
	}
	if(m_list_blob.Size>0)m_descrtiption+= APL_T("     ");
	for(i=0;i<m_list_blob.Size;i++){
		count=0;
		//      
		el_blob=m_list_blob.GetAt(i);
		if(el_blob==0)continue;
		if(el_blob->word.FindOneOf(_T(",.;:?!\"'\\/%"))!=-1){
			AfxMessageBox( APL_T("     "));
			return false;
		}
		m_descrtiption+=_T(" ")+el_blob->word;
		if(el_blob->is_equal){
			if(ext_eq==_T("")){
				ext_eq=_T("Ext_BLOB_q{")+prefix+
					_T("apl_document_revision")+middle+_T(".access_form->apl_stored_document(.source = @BLOB_CONSIST('")+
					el_blob->word+_T("')\r\n");
			}else{
				ext_eq+=_T(" AND .source = @BLOB_CONSIST('")+el_blob->word+_T("')\r\n");
			}
		}else{
			if(ext_like==_T("")){
				ext_like=_T("Ext_BLOB_l{")+prefix+
					_T("apl_document_revision")+middle+_T(".access_form->apl_stored_document(.source LIKE @BLOB_CONSIST('")+
					el_blob->word+_T("')\r\n");
			}else{
				ext_like+=_T(" AND .source = @BLOB_CONSIST('")+el_blob->word+_T("')\r\n");
			}
		}
	}
	if(ext_eq!=_T("")){
		ext_eq+=postfix;
		if(m_fields!=_T(""))m_fields+=_T(" AND ");
		m_fields+=_T(" Ext_BLOB_q ");
	};
	if(ext_like!=_T("")){
		ext_like+=postfix;
		if(m_fields!=_T(""))m_fields+=_T(" AND ");
		m_fields+=_T(" Ext_BLOB_l ");
	};
	if(m_fields!=_T("")){m_fields+=_T(" \r\n ");m_cur_ext_num++;}
	m_extents+=ext_eq+ext_like;
	return true;
}


//   QL    
bool CFindQueryDlgEx::MakeQueryRes()
{
	ElValRes* el_res;
	CString condition,part_id,part_name,part_type,buf;
	int i,count;

	CorrectFieldDescr1(m_list_res.Size, m_is_or_res);

	for(i=0;i<m_list_res.Size;i++)
	{
		condition=_T(" ");

		count=0;
		//      
		el_res=m_list_res.GetAt(i);
		if(el_res==0)continue;
		if(!el_res->is_exist && m_mode==FindObject_All){
			AfxMessageBox( APL_T("      !"));
			return false;
		}

		CorrectFieldDescr2(i, m_is_or_res);

		m_descrtiption+=(el_res->is_exist)? APL_T(" : "): APL_T(" : ");
		
		if(el_res->id_res != _T("")){
			//  AND        
			//    
			if(el_res->is_eq_id_res){
				part_id.Format(_T(".id = '%s' "),el_res->id_res);
				m_descrtiption+= APL_T(" = '")+el_res->id_res+_T("'; ");
			}else{
				part_id.Format(_T(".id LIKE '%s' "),el_res->id_res);
				m_descrtiption+= APL_T("  '")+el_res->id_res+_T("'; ");
			}
			count++;
			
		}
		if(el_res->name_res != _T("")){
			//  AND        
			//    
			if(el_res->is_eq_name_res){
				part_name.Format(_T(".name = '%s' "),el_res->name_res);
				m_descrtiption+= APL_T(" = '")+el_res->name_res+_T("'; ");
			}else{
				part_name.Format(_T(".name LIKE '%s' "),el_res->name_res);
				m_descrtiption+= APL_T("  '")+el_res->name_res+_T("'; ");
			}
			count++;
		}
		if(el_res->type_res != 0){
			//  AND        
			//    
			part_type.Format(_T(".type = #%i "),el_res->type_res->GetId());
			count++;
			apidata.GetAttr(el_res->type_res,m_api->m_doc_mgr.a_dt_pdt,buf);
			m_descrtiption+= APL_T(" = '")+buf+_T("'; ");
			
		}
		if(count==0){continue;}
		else if(count==1){
			if(el_res->type_res != 0){condition+=part_type;}
			else if(el_res->id_res != _T("")){condition+=part_id;}
			else if(el_res->name_res != _T("")){condition+=part_name;}
		}else{
			condition+=_T("(");
			if(el_res->type_res != 0){condition+=part_type;}
			if(el_res->type_res != 0 && el_res->id_res != _T("")){condition+=_T(" AND ");}
			if(el_res->id_res != _T("")){condition+=part_id;}
			if(el_res->name_res != _T("")){condition+=_T(" AND ")+part_name;}
			condition+=_T(")");
		}
		MakeExtAndField(m_api->m_bp_mgr.e_bp_res,m_api->m_bp_mgr.a_bp_res_process,condition,el_res->is_exist);
	}

	CorrectFieldDescr3(m_list_res.Size, m_is_or_res);

	return true;
}

// "" QL (  - )     
//         
//    
void CFindQueryDlgEx::MakeExtAndField(CaplEntity *base_entity, CaplAttr *attr, CString conditions, bool is_exist)
{
	CString ext_name1,ext_name2,ext_name3,ext_name4,ext_name5,buf,fields,object_condition;
	if(base_entity==0)
		return;
	if(attr==0)
		return;
	if(conditions==_T(""))
		return;

	if(m_object_condition.IsEmpty() == TRUE)
	{
		object_condition = _T("");
	}
	else
	{
		object_condition = m_object_condition + _T(" AND ");
	}

	// ...
	ext_name1.Format(_T("Ext_%i "),m_cur_ext_num);
	ext_name2.Format(_T("Ext_%i_a "),m_cur_ext_num);
	
	//ext_name.Format(_T("\n Ext_%i"),m_cur_ext_num);

	if(base_entity->name == _T("apl_task"))
	{
		conditions += _T(" AND (.state = 'active' OR .state = 'work') ");
	}
	
	if(m_mode==FindObject_Document)
	{
		ext_name3.Format(_T("Ext_%i_b "),m_cur_ext_num);
		ext_name4.Format(_T("Ext_%i_x "),m_cur_ext_num);
		ext_name5.Format(_T("Ext_%i_z "),m_cur_ext_num);
		
		m_extents+=ext_name1+_T(" {")+ base_entity->name+_T("(\n\t\t")+
			_T(".")+attr->name+_T("->")+m_object_name+m_object_condition + _T(" AND ") + conditions +_T(")}.")+attr->name+_T("->apl_document_revision\n");
		fields=_T("(");
		if(m_ctrl_find_version.GetCheck())
		{
			//      
			m_extents+=ext_name2+_T(" {apl_document(")+object_condition + _T(" .active ");
			if(is_exist){m_extents+=_T(" IN ");}else{m_extents+=_T(" NOT_IN ");}
			m_extents+=_T(" #")+ext_name1+ _T(" )}\n");
			fields+=ext_name2;
		}
		else
		{
			//    
			if(is_exist){
				fields+=ext_name1+_T(".of_document->apl_document");
			}else{
				m_extents+=ext_name2+_T(" {apl_document_revision.# IN #")+
									ext_name1 +_T("}.of_document->apl_document\n");
				m_extents+=ext_name3+_T(" {apl_document(")+
					object_condition + _T(" .# NOT_IN #")+ext_name2+_T(" )}\n");
				fields+=ext_name3;
			}
		}
		m_extents+=ext_name4+_T(" {")+ base_entity->name+_T("(\n\t\t")+
			_T(".") + attr->name+_T("->apl_document") + m_object_condition + _T(" AND ") + conditions + _T(")}.") + attr->name+_T("->apl_document\n");
		if(is_exist)
		{
			fields+=_T(" OR ") + ext_name4+_T(" )\n\t");
		}
		else
		{
			m_extents+=ext_name5+_T(" {apl_document (")+object_condition+
					_T(" .# NOT_IN #")+ ext_name4 +_T(")}\n");
			fields+=_T(" AND ")+ext_name5+_T(" )\n\t");
		}
	}
	else if(m_mode==FindObject_BP)
	{
		ext_name3.Format(_T("Ext_%i_b "),m_cur_ext_num);
		ext_name4.Format(_T("Ext_%i_x "),m_cur_ext_num);
		ext_name5.Format(_T("Ext_%i_z "),m_cur_ext_num);

		m_extents+=ext_name1+_T(" {")+ base_entity->name+_T("(\n\t\t")+
			_T(".")+attr->name+_T("->")+m_object_name+m_object_condition + _T("AND") + conditions+_T(")}.")+attr->name+_T("\n");
		fields=_T("(");
		if(m_ctrl_find_version.GetCheck())
		{
			//      
			m_extents+=ext_name2+_T(" {apl_business_process(") + object_condition + _T(" .active_version ");
			if(is_exist){m_extents+=_T(" IN ");}else{m_extents+=_T(" NOT_IN ");}
			m_extents+=_T(" #")+ext_name1+ _T(" )}\n");
			fields+=ext_name2;
		}
		else
		{
			//    
			if(is_exist){
				fields+=ext_name1+_T(".")+attr->name+_T("->apl_business_process_version.process->apl_business_process");
			}else{
				m_extents+=ext_name2+_T(" {apl_business_process_version.# IN #")+
					ext_name1 +_T("}.process->apl_business_process\n");
				m_extents+=ext_name3+_T(" {apl_business_process(")+
					object_condition + _T(" .# NOT_IN #")+ext_name2+_T(" )}\n");
				fields+=ext_name3;
			}	
		}
		m_extents+= ext_name4 + _T(" {") + base_entity->name + _T("(\n\t\t")+
			_T(".") + attr->name + _T("->apl_business_process") + m_object_condition + _T("AND") + conditions + _T(")}.") + attr->name+_T("->apl_business_process\n");
		if(is_exist)
		{
			fields+= _T(" OR ") + ext_name4 + _T(" )\n\t");
		}
		else
		{
			m_extents+= ext_name5 + _T(" {apl_business_process (") + object_condition +
				_T(" .# NOT_IN #")+ ext_name4 +_T(")}\n");
			fields+= _T(" AND ") + ext_name5 + _T(" )\n\t");
		}
		
	}
	else if(m_mode==FindObject_All)
	{
		m_extents+= ext_name1 + _T(" {") + base_entity->name + _T("(\n\t\t") + conditions + _T(")}.item \n");
		if(is_exist)
		{
			fields= ext_name1;
		}
		else
		{
			m_extents+= ext_name2 + _T(" {") + m_object_name + _T("(") +
				object_condition + _T(" .# NOT_IN #") + ext_name1 + _T(" )}\n");
			fields= ext_name2;
		}	
	}
	else
	{
		m_extents+=ext_name1+_T(" {")+ base_entity->name+_T("(\n\t\t");

		if(m_object_condition != _T(""))
		{
			m_extents += _T(".")+attr->name+_T("->")+m_object_name + m_object_condition + _T("AND") ;
		}

		m_extents+= conditions+_T(")}.")+attr->name+_T("->")+m_object_name+_T("\n");
		if(is_exist)
		{
			fields=ext_name1;
		}
		else
		{
			m_extents += ext_name2+_T(" {")+m_object_name +_T("(") + 
				object_condition + _T(" .# NOT_IN #")+ext_name1+_T(" )}\n");
			fields=ext_name2;
		}	
	}
	m_fields+=fields;
	m_cur_ext_num++;
}//void CFindQueryDlgEx::MakeExtAndField(CaplEntity *base_entity,CString conditions,bool is_exist){


static int rec_num=0;

//        
CString CFindQueryDlgEx::FillDateCompare(CString name_attr,CaplQLQuery::aplQLLogRelation log_relation,COleDateTime* dtt){
//										int year,int month,int day){
	CString result,buf,buf1,log_op_str;
	if(dtt==0)return _T("");
/*	rec_num++;
	if(rec_num==1){
		result=_T("->apl_date_and_time");
	}*/
	
	//   <=  >=
	if(log_relation==CaplQLQuery::aplSMALLEQUAL){
		result+=_T("(")+FillDateCompare(name_attr,CaplQLQuery::aplSMALL,dtt)+
			_T(" OR ")+FillDateCompare(name_attr,CaplQLQuery::aplEQUAL,dtt)+
			_T(")");
//		rec_num--;
		return result;
	}else if(log_relation==CaplQLQuery::aplBIGEQUAL){
//		result+=_T("(")+FillDateCompare(CaplQLQuery::aplBIG,year,month,day)+
		result+=_T("(")+FillDateCompare(name_attr,CaplQLQuery::aplBIG,dtt)+
//			_T(" OR ")+FillDateCompare(CaplQLQuery::aplEQUAL,year,month,day)+
			_T(" OR ")+FillDateCompare(name_attr,CaplQLQuery::aplEQUAL,dtt)+
			_T(")");
//		rec_num--;
		return result;
	}

	log_op_str=CaplQLQuery::LogOp2String(log_relation,false);
	aplDate2String(*dtt,buf1);
	buf.Format(_T(".%s %s '%s' "),name_attr,log_op_str,buf1);
	result+=buf;
	
	/*	if(log_relation==CaplQLQuery::aplEQUAL){
	buf.Format(_T("(.year_component = %i AND .month_component = %i AND .day_component =%i)\n"),year,month,day);
	result+=buf;
	}else{
	CString log_op_str=CaplQLQuery::LogOp2String(log_relation,false);
	buf.Format(_T("		((.year_component %s %i) OR ")
	_T("		(.year_component = %i AND .month_component %s %i) OR\n")
	_T("		(.year_component = %i AND .month_component = %i AND .day_component %s %i))\n"),
	log_op_str,year,
	year,log_op_str,month,
	year,month,log_op_str,day);
	result+=buf;
}*/
	//	rec_num--;
	return result;
}

//      
bool CFindQueryDlgEx::Save2BufListQChar()
{
	BYTE type;
	int i;
	ElValChar* el_ch;
	bool flag;
	BYTE count =0;
	int id;
	CaplInstance* unit;
	DATE dt1;
	
	if(m_api==0)return false;
	if(m_dbuf==0)return false;

	// 1  - 
	type=(BYTE)m_list_char.Size;
	m_dbuf->Add(&type,1);

	//    
	for(i=0;i<m_list_char.Size;i++){
		//      
		el_ch=m_list_char.GetAt(i);
		flag=false;
		count=0;
		if(el_ch==0)flag=true;
		if(el_ch->apl_char==0)flag=true;
		if(!flag){
			if(el_ch->apl_char!=0)count++;
			if(el_ch->type!=0)count++;
			if(el_ch->b_val!=0)count++;
			if(el_ch->b_max!=0)count++;
			if(el_ch->b_min!=0)count++;
			if(count==0)flag=true;
		}
		if(flag){
			//1  -  (1 /0  )
			type=0;
			m_dbuf->Add(&type,1);
			// 1  -   
			//    
			type=0;
			m_dbuf->Add(&type,1);
			continue;
		}
		//1  -  (1 /0  )
		type=el_ch->is_exist?1:0;
		m_dbuf->Add(&type,1);
		// 1  -   
		m_dbuf->Add(&count,1);
		if(el_ch->apl_char!=0){
			// 1 -  (instance_id - 4 )
			type=1;
			m_dbuf->Add(&type,1);
			id=el_ch->apl_char->GetId();
			m_dbuf->Add(&id,4);
			apidata.GetAttrBN(el_ch->apl_char,_T("unit"),unit);
		}
		if(el_ch->type!=0){
			// 2 -   (instance_id - 4 )
			type=2;
			m_dbuf->Add(&type,1);
			id=el_ch->type->GetId();
			m_dbuf->Add(&id,4);
		}
		if(el_ch->b_val!=0){
			// 3 -  .  :
			type=3;
			m_dbuf->Add(&type,1);
			// 1   -      CaplQLQuery::aplQLLogRelation
			type=(BYTE)el_ch->log_relation;
			m_dbuf->Add(&type,1);
			if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_step_unit) ||
				apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_descript_unit) ||
				apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_enum_unit) || 
				apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_monetary_unit))
			{
				// 1 -  (1    +  )
				type=1;
				m_dbuf->Add(&type,1);
				SaveDataToBufBaseString(el_ch->val);
			}
			else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_time_unit))
			{
				// 4 -  ( 8 )
				type=4;
				m_dbuf->Add(&type,1);
				dt1=(DATE)(*el_ch->dtt);
				m_dbuf->Add(&dt1,8);
			}
			else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_reference_unit))
			{
				// 5 -  (4  - instance_id)
				type=5;
				m_dbuf->Add(&type,1);
				id=(el_ch->m_cur_ref_val==0)?0:el_ch->m_cur_ref_val->GetId();
				m_dbuf->Add(&id,4);
			}   
		}
		if(el_ch->b_max!=0)
		{
			// 3 -  .  :
			type=3;
			m_dbuf->Add(&type,1);
			// 1   -      CaplQLQuery::aplQLLogRelation
			type=(BYTE)el_ch->log_relation_max;
			m_dbuf->Add(&type,1);
			// 2 -  max (1    +  )
			type=2;
			m_dbuf->Add(&type,1);
			SaveDataToBufBaseString(el_ch->val_max);
		}
		if(el_ch->b_min!=0)
		{
			// 3 -  .  :
			type=3;
			m_dbuf->Add(&type,1);
			// 1   -      CaplQLQuery::aplQLLogRelation
			type=(BYTE)el_ch->log_relation_min;
			m_dbuf->Add(&type,1);
			// 3 -  min (1    +  )
			type=3;
			m_dbuf->Add(&type,1);
			SaveDataToBufBaseString(el_ch->val_min);
		}
	}
	return true;
}

///////////////////////////////////////////////////////////////////////
//    -   

//      
bool CFindQueryDlgEx::SaveDataToBufBaseString(CString str_par)
{
#ifdef _UNICODE
	//   -     
	m_dbuf->AddStrBuf(str_par);
#else
	//     ANSI  -     
	BYTE b_len;
	int length=str_par.GetLength()+1;
	if(length>250)length=250;
	b_len=(BYTE)length;
	m_dbuf->Add(&b_len,1);
	m_dbuf->Add(str_par.GetBuffer(length),length);
#endif
	return true;
}


bool CFindQueryDlgEx::SaveDataToBuf()
{
	aplExtent ext;
	CString buf;
	CString str_par;
	CaplDataBuf dbuf_temp;
	ElValDoc* el_doc=0;
	ElValApproval* el_apr=0;
	ElValBLOB* el_blob=0;
	ElValClass* el_class=0;
	CaplInstance *inst=0;
	DATE dt1,dt2;

	SFindAttrDef* attr_def = 0;	
	BYTE type_b,log_rel_BYTE;
	CaplQLQuery::aplQLLogRelation log_rel = CaplQLQuery::aplNOLOGREL;
	CaplValue value,value2;
	

	BYTE type;
	BYTE count=0;
	bool flag;
	int i,j,k,id,int_val;
	if(!m_changed)return true;
	if(m_dbuf==0)m_dbuf=new CaplDataBuf();
	
	m_dbuf->Clear();
	// 
#ifdef _UNICODE
	m_dbuf->Add(STD_HEADER_FIND_QUERY_DLG_U,strlen(STD_HEADER_FIND_QUERY_DLG_U)+1);
#else
	m_dbuf->Add(STD_HEADER_FIND_QUERY_DLG_A,strlen(STD_HEADER_FIND_QUERY_DLG_A)+1);
#endif
	//  
	type=m_mode;
	m_dbuf->Add(&type,1);
	count=0;

	//     m_attr_values   ,        m_curr_type_descr
	//   
	for(i=0;i<m_curr_type_descr->list_attrs.Size;i++)
	{
		attr_def = m_curr_type_descr->list_attrs.GetAt(i);
		if(attr_def == 0) continue;
		if(m_attr_values.IsExist(attr_def->type))count++;
	}
	
	m_dbuf->Add(&count,1);

	//    
	for(i=0;i<m_curr_type_descr->list_attrs.Size;i++)
	{
		attr_def = m_curr_type_descr->list_attrs.GetAt(i);
		if(attr_def == 0) continue;
		if(m_attr_values.Get(attr_def->type,log_rel,value,value2))
		{
			type_b = (BYTE) attr_def->type;
			m_dbuf->Add(&type_b,1);
			log_rel_BYTE = (BYTE) log_rel;
			m_dbuf->Add(&log_rel_BYTE,1);

			switch(attr_def->type)
			{
			case TFO_Id:
			case TFO_Name:
			case TFO_Descr:
			case TFO_Code:
			case TFO_CodeVer1:
			case TFO_CodeVer2:
			case TFO_CodeIzd:
			case TFO_Ver:
			case TFO_Source:
			case TFO_VerDescr:
// 			case TFO_RelPos:
// 			case TFO_RelPosId:
// 			case TFO_RelName:
// 			case TFO_RelDescr:
			case TFO_Standart:
			case TFO_Groupe:
			case TFO_Part:
			case TFO_Label:
			case TFO_VerList:
			case TFO_VerLists:
			case TFO_VerFormat:
			case TFO_VerLitera:
			case TFO_DocCode1:
			case TFO_DocCode2:
			case TFO_DocUrgency:
			case TFO_StrExt:
			case TFO_RefDocNum:	 //  -  
			case TFO_RefState:	 //  - 
			case TFO_RefDocType:	 //  -  
			case TFO_RefManifDescr:
			case TFO_ProcTaskId:
			case TFO_ProcTaskName:
			case TFO_ProcState:
			case TFO_ProcTaskExpired:
			case TFO_DocMaillist:
			case TFO_State:
				value.Get(str_par);
				SaveDataToBufBaseString(str_par);
				break;

			case TFO_ProcTaskExpiredNDays:
				value.Get(int_val);
				m_dbuf->Add(&int_val,4);
				break;

			case TFO_Date1:  // - 
			case TFO_Date2:
			case TFO_Date3:
			case TFO_Date4:
				value.Get(str_par);
				SaveDataToBufBaseString(str_par);

				value2.Get(str_par);
				SaveDataToBufBaseString(str_par);
				break;

			case TFO_ProjCustomer:
			case TFO_ProjKurator:
			case TFO_ProjExecutors:
			case TFO_ProjCoexecutors:
			case TFO_InAggr:
			case TFO_RefOrg:			
			case TFO_RefSector:		
			case TFO_RefCulprit:		
			case TFO_RefStage:		

			case TFO_RefMainPDF:		
			case TFO_RefMainItem:		
			case TFO_RefSystem:		
			case TFO_RefFailedItem:	
			case TFO_RefFailedPart:	
			case TFO_RefConditions:	
			case TFO_RefDof		:	
			case TFO_RefFaultReason:	
			case TFO_RefMethod	:	
			case TFO_RefConsequence	:
			case TFO_RefManif	:	
			case TFO_ProcTaskPerformer:
			case TFO_ProcRefusalCulprit:
			case TFO_ProcOwner:
			case TFO_ProcTemplate:
			case TFO_ProcActivity:

				value.Get(inst);
				if(inst!=0){k=inst->GetId();}else{k=0;}
				m_dbuf->Add(&k,4);
				break;

			case TFO_RelContext:
				//   
				value.Get(ext);
				type=(BYTE)ext.GetSize();
				m_dbuf->Add(&type,1);
				for(j=0;j<ext.GetSize();j++)
				{
					inst = ext.GetAt(j);
					if(inst!=0){k=inst->GetId();}else{k=0;}
					m_dbuf->Add(&k,4);
				}
				break;

			case TFO_Type:
				if(log_rel!=CaplQLQuery::aplNOLOGREL && log_rel!=CaplQLQuery::aplNOTEXIST)
				{
					if(m_mode==FindObject_ProductVer || m_mode==FindObject_Change)
					{
						value.Get(str_par);
						SaveDataToBufBaseString(str_par);
					}
					if(m_mode==FindObject_Document || m_mode==FindObject_BP || m_mode==FindObject_Project || m_mode==FindObject_Refusal)
					{
						//   ///       
						value.Get(inst);
						if(inst!=0){k=inst->GetId();}else{k=0;}
						m_dbuf->Add(&k,4);
					}
				}

				break;

			default:
				AfxMessageBox( APL_T("      .\n  !"));
				return false;
			}


		}
	}

	//   
	type=(BYTE)m_list_approval.Size;
	m_dbuf->Add(&type,1);
	for(i=0;i<m_list_approval.Size;i++)
	{
		el_apr=m_list_approval.GetAt(i);
		flag=false;
		count=0;
		if(el_apr==0)flag=true;
		if(!flag)
		{
			if(el_apr->status!=0)count++;
			if(el_apr->descr!=_T(""))count++;
			if(el_apr->person!=0)count++;
			if(el_apr->pers_org_role!=_T(""))count++;
			if(el_apr->date_time_beg!=0 || el_apr->date_time_end!=0)count++;
			if(el_apr->revoc_date_time_beg!=0 || el_apr->revoc_date_time_end!=0)count++;
			if(el_apr->is_dig_sign!=-1)count++;
			if(count==0 && !m_mode_slave)flag=true;
		}
		if(flag)
		{
			type=0;
			m_dbuf->Add(&type,1);
			//     
			type=0;
			m_dbuf->Add(&type,1);
			continue;
		}
		type=el_apr->is_exist?1:0;
		m_dbuf->Add(&type,1);
		m_dbuf->Add(&count,1);
		
		if(el_apr->status!=0)
		{
			type=1;
			m_dbuf->Add(&type,1);
			id=el_apr->status->GetId();
			m_dbuf->Add(&id,4);
		}
		if(el_apr->person!=0)
		{
			type=2;
			m_dbuf->Add(&type,1);
			if(el_apr->person!=0)
				id=el_apr->person->GetId();
			else
				id=0;
			
			m_dbuf->Add(&id,4);
		}
		if(el_apr->pers_org_role!=_T(""))
		{
			type=3;
			m_dbuf->Add(&type,1);
			type=(el_apr->pers_org_role_eq)?1:0;
			m_dbuf->Add(&type,1);
			count=(BYTE)el_apr->pers_org_role.GetLength()+1;
			m_dbuf->Add(&count,1);
			m_dbuf->Add(el_apr->pers_org_role.GetBuffer(count),count);
		}
		if(el_apr->date_time_beg!=0 || el_apr->date_time_end!=0)
		{
			type=4;
			m_dbuf->Add(&type,1);
			if(el_apr->is_single_date)
			{
				type=0;
				m_dbuf->Add(&type,1);
				if(el_apr->date_time_beg!=0)
					dt1=*el_apr->date_time_beg;
				else
					dt1=0;
				
				m_dbuf->Add(&dt1,8);
			}
			else
			{
				type=1;
				m_dbuf->Add(&type,1);
				if(el_apr->date_time_beg!=0)
					dt1=(DATE)(*el_apr->date_time_beg);
				else
					dt1=0;
				
				if(el_apr->date_time_end!=0)
					dt2=(DATE)(*el_apr->date_time_end);
				else
					dt2=0;
				
				m_dbuf->Add(&dt1,8);
				m_dbuf->Add(&dt2,8);
			}		
		}
		if(el_apr->revoc_date_time_beg!=0 || el_apr->revoc_date_time_end!=0)
		{
			type=5;
			m_dbuf->Add(&type,1);
			if(el_apr->revoc_date_time_beg!=0)
				dt1=(DATE)(*el_apr->revoc_date_time_beg);
			else
				dt1=0;
			
			if(el_apr->revoc_date_time_end!=0)
				dt2=(DATE)(*el_apr->revoc_date_time_end);
			else
				dt2=0;
			
			m_dbuf->Add(&dt1,8);
			m_dbuf->Add(&dt2,8);
		}
		if(el_apr->is_dig_sign!=-1)
		{
			type=6;
			m_dbuf->Add(&type,1);
			id = el_apr->is_dig_sign;
			m_dbuf->Add(&id,4);
		}		
		if(el_apr->descr!=_T(""))
		{
			type=7;
			m_dbuf->Add(&type,1);
			m_dbuf->AddStrBuf((LPCTSTR)el_apr->descr);
			type=(BYTE)el_apr->descr_relation;
			m_dbuf->Add(&type,1);
		}
	}
	//   
	Save2BufListQChar();

	//   
	type=(BYTE)m_list_doc.Size;
	m_dbuf->Add(&type,1);
	
	for(i=0;i<m_list_doc.Size;i++)
	{
		flag=false;
		count=0;
		//      
		el_doc=m_list_doc.GetAt(i);
		if(el_doc==0)flag=true;
		if(!flag)
		{
			if(el_doc->id!=_T(""))count++;
			if(el_doc->name!=_T(""))count++;
			if(el_doc->type!=0)count++;
			if(count==0)flag=true;
		}
		if(flag)
		{
			type=0;
			m_dbuf->Add(&type,1);
			//    
			type=0;
			m_dbuf->Add(&type,1);
			continue;
		}
		type=(el_doc->is_exist)?1:0;
		m_dbuf->Add(&type,1);
		m_dbuf->Add(&count,1);
		
		if(el_doc->id != _T(""))
		{
			type=1;
			m_dbuf->Add(&type,1);
			type=(el_doc->is_eq_id)?1:0;
			m_dbuf->Add(&type,1);
			SaveDataToBufBaseString(el_doc->id);
		}
		if(el_doc->name != _T(""))
		{
			type=2;
			m_dbuf->Add(&type,1);
			type=(el_doc->is_eq_name)?1:0;
			m_dbuf->Add(&type,1);
			SaveDataToBufBaseString(el_doc->name);
		}
		if(el_doc->type != 0)
		{
			type=3;
			m_dbuf->Add(&type,1);
			id=el_doc->type->GetId();
			m_dbuf->Add(&id,4);
		}
	}

	//  
	// 1  -      (1 - , 0  , 255 -  )
	if(m_can_make_table){
		type=(m_IsMakeTableResult)?1:0;
	}else{
		type=255;
	}
	m_dbuf->Add(&type,1);
	// ver 1_1
	//      
	if(m_ctrl_find_version.GetCheck()){type=1;}else{type=0;}
	m_dbuf->Add(&type,1);
	// ver_1_2
	type=(BYTE)m_list_blob.Size;
	m_dbuf->Add(&type,1);
	
	for(i=0;i<m_list_blob.Size;i++)
	{
		flag=false;
		//      
		el_blob=m_list_blob.GetAt(i);
		type=(el_blob->is_equal)?1:0;
		m_dbuf->Add(&type,1);
		SaveDataToBufBaseString(el_blob->word);
	}
	//      
	type=(m_IsSubstring == TRUE)?1:0;
	m_dbuf->Add(&type,1);
	//     
	type=(m_IsBrackets == TRUE)?1:0;
	m_dbuf->Add(&type,1);

	// ,   
	type=(BYTE)m_list_class.Size;
	m_dbuf->Add(&type,1);

	if(m_list_class.Size > 0)
	{
		for(i=0;i<m_list_class.Size;i++)
		{
			//      
			el_class=m_list_class.GetAt(i);
			count=0;
			if(el_class!=0)
			{
				if(el_class->classif!=0)count++;
			}
			if(count==0)
			{
				//    
				type=0;
				m_dbuf->Add(&type,1);
				type=0;
				m_dbuf->Add(&type,1);
				continue;
			}
			//1  -     
			type=(el_class->is_exist)?1:0;
			m_dbuf->Add(&type,1);
			//  1  - -  (  1,    )
			m_dbuf->Add(&count,1);
			if(el_class->classif != 0)
			{
				type=1;
				m_dbuf->Add(&type,1);
				id=el_class->classif->GetId();
				m_dbuf->Add(&id,4);
			}
		}
	}

	//    1.8 
	//     
	type=m_is_or_char?1:0;
	m_dbuf->Add(&type,1);
	type=m_is_or_doc?1:0;
	m_dbuf->Add(&type,1);
	type=m_is_or_approval?1:0;
	m_dbuf->Add(&type,1);
	type=m_is_or_res?1:0;
	m_dbuf->Add(&type,1);
	type=m_is_or_blob?1:0;
	m_dbuf->Add(&type,1);
	type=m_is_or_class?1:0;
	m_dbuf->Add(&type,1);

	//    1.9 
	//  " "
	type=(m_IsMatchCase==TRUE)?1:0;
	m_dbuf->Add(&type,1);

	return true;
}

//    
bool CFindQueryDlgEx::LoadFromBufBaseString(CString &str_par)
{
	if(m_dbuf->m_ansi_string)
	{
		BYTE type;
		m_dbuf->Read(&type,1);
		char* cbuf=new char[type+1];
		m_dbuf->Read(cbuf,type);
		cbuf[type]=0;
		//   str_par   -  =   
		str_par=cbuf;
		delete cbuf;
	}
	else
	{
		//    -  /   
		m_dbuf->ReadStrBuf(str_par);

	}
	return true;
}


bool CFindQueryDlgEx::LoadFromBufListQChar()
{
	BYTE count =0;
	aplExtent ext1,ext2;
	int i,j,k;
	BYTE type;
	bool flag;
	BYTE count2;
	ElValChar* el_ch;
	int id;
	BYTE type2;
	DATE dt1;

	if(m_api==0)return false;
	if(m_dbuf==0)return false;

	//   
	// 1  - 
	m_dbuf->Read(&count,1);
	apidata.GetEntityExtent(m_api->m_charact_mgr.e_apl_charact,ext1);
	apidata.GetEntityExtent(m_api->m_charact_mgr.e_apl_charact_type,ext2);
	
	for(i=0;i<count;i++)
	{
		//1  -  (1 /0  )
		m_dbuf->Read(&type,1);
		flag=type==1;
		//1  -   
		m_dbuf->Read(&count2,1);
		if(count2==0)continue;

		el_ch=new ElValChar();
		el_ch->is_exist=flag;
		for(k=0;k<count2;k++)
		{
			//1  - id  (  -  ):
			m_dbuf->Read(&type,1);
			switch(type)
			{
			case 1:
				//1 -  (instance_id - 4 )
				m_dbuf->Read(&id,4);
				//  
				el_ch->apl_char=0;
				for(j=0;j<ext1.GetSize();j++)
				{
					if(id==ext1.GetAt(j)->GetId())
					{
						el_ch->apl_char=ext1.GetAt(j);
						break;
					}
				}
				break;
			case 2:
				//2 -   (instance_id - 4 )
				m_dbuf->Read(&id,4);
				//  
				el_ch->type=0;
				for(j=0;j<ext2.GetSize();j++)
				{
					if(id==ext2.GetAt(j)->GetId())
					{
						el_ch->type=ext2.GetAt(j);
						break;
					}
				}
				break;
			case 3:
				//3 -  .  :
				// 1   -    
				m_dbuf->Read(&type2,1);
				//1  -   (  Y):
				m_dbuf->Read(&type,1);
				switch(type)
				{
				case 1:
					//1 -  (1    +  )
					LoadFromBufBaseString(el_ch->val);
					el_ch->b_val=true;
					el_ch->log_relation=(CaplQLQuery :: aplQLLogRelation)type2;
					break;
				case 2:
					//2 -  max (1    +  )
					LoadFromBufBaseString(el_ch->val_max);
					el_ch->b_max=true;
					el_ch->log_relation_max=(CaplQLQuery :: aplQLLogRelation)type2;
					break;
				case 3:
					//3 -  min (1    +  )
					LoadFromBufBaseString(el_ch->val_min);
					el_ch->b_min=true;
					el_ch->log_relation_min=(CaplQLQuery :: aplQLLogRelation)type2;
					break;
				case 4:
					//4 -  ( 8 )
					m_dbuf->Read(&dt1,8);
					if(dt1!=0)
					{
						if(el_ch->dtt==0)el_ch->dtt=new COleDateTime();
						*(el_ch->dtt)=dt1;
						el_ch->b_val=true;
						el_ch->log_relation=(CaplQLQuery :: aplQLLogRelation)type2;
					}
					break;
				case 5:
					//5 -  (4  - instance_id)
					m_dbuf->Read(&id,4);
					aplQFindInstIdInExtent(
						*((aplExtent*)(&(apidata.instances))),id,-1,true,&(el_ch->m_cur_ref_val));
					el_ch->b_val=true;
					el_ch->log_relation=(CaplQLQuery :: aplQLLogRelation)type2;
					break;
				}
			}	
		}
		if(el_ch->apl_char!=0){
			m_list_char.Add(el_ch);
		}
	}	
	return true;
}

bool CFindQueryDlgEx::LoadDataFromBuf()
{
	char* cbuf;
	aplExtent ext1,ext2,ext3, ext4load;
	CString buf;
	CString str_par;
	CaplDataBuf dbuf_temp;
	ElValDoc* el_doc=0;
	ElValApproval* el_apr=0;
	ElValBLOB* el_blob=0;
	ElValClass* el_class=0;
	DATE dt1,dt2;
	CaplInstance *inst=0;
	
	BYTE type_b,log_rel_BYTE,str_len_BYTE;
	CaplQLQuery::aplQLLogRelation log_rel = CaplQLQuery::aplNOLOGREL;
	CaplValue value,value2;
	TypeFOAttr type_attr;

	BYTE count=0, count2;
	bool flag;
	bool flag_ver_1_0 = false;
	bool flag_ver_1_1 = false;
	bool flag_ver_1_2 = false;
	bool flag_ver_1_3 = false;
	bool flag_ver_1_4 = false;
	bool flag_ver_1_5 = false;
	bool flag_ver_1_6 = false;
	bool flag_ver_1_7 = false;
	bool flag_ver_1_8 = false;
	bool flag_ver_1_9 = false;
	int i, j, k, id, int_val;	

	if(m_dbuf==0)return true;
	m_dbuf->Reset();
	if(m_dbuf->m_Size==0)return true;

	m_list_char.Clear();
	m_list_doc.Clear();
	m_list_approval.Clear();
	m_list_blob.Clear();
	m_list_class.Clear();

	m_ListAttributes.DeleteAllItems();
	m_attr_values.Clear();
	
	// 
	k=strlen(STD_HEADER_FIND_QUERY_DLG_A)+1;
	cbuf=new char[k];
	if(!m_dbuf->Read(cbuf,k))return true;

	if(CStringA(cbuf).Left(14) == _T("FindQueryData "))
	{
		m_dbuf->m_ansi_string = true;
	}
	else if(CStringA(cbuf).Left(14) == _T("FindQueryDatU "))
	{
		m_dbuf->m_ansi_string = false;
	}
	else
	{
		delete cbuf;
		AfxMessageBox( APL_T("      .\n  !"));
		return false;
	}

	if(CStringA(cbuf).Mid(14) == "v1.0")
	{
		// STD_HEADER_FIND_QUERY_DLG_1_0
		flag_ver_1_0 = true;
	}
	else if(CStringA(cbuf).Mid(14) == "v1.1")
	{
		// STD_HEADER_FIND_QUERY_DLG_1_1)
		flag_ver_1_1 = true;
	}
	else if(CStringA(cbuf).Mid(14) == "v1.2")
	{
		// STD_HEADER_FIND_QUERY_DLG_1_2)
		flag_ver_1_2 = true;
	}
	else if(CStringA(cbuf).Mid(14) == "v1.3")
	{
		// STD_HEADER_FIND_QUERY_DLG_1_3)
		flag_ver_1_3 = true;
	}
	else if(CStringA(cbuf).Mid(14) == "v1.4")
	{
		// STD_HEADER_FIND_QUERY_DLG_1_4)
		flag_ver_1_4 = true;
	}
	else if(CStringA(cbuf).Mid(14) == "v1.5")
	{
		// STD_HEADER_FIND_QUERY_DLG_1_5)
		flag_ver_1_5 = true;
	}
	else if(CStringA(cbuf).Mid(14) == "v1.6")
	{
		// STD_HEADER_FIND_QUERY_DLG_1_6)
		flag_ver_1_6 = true;
	}
	else if(CStringA(cbuf).Mid(14) == "v1.7")
	{
		// STD_HEADER_FIND_QUERY_DLG_1_7)
		flag_ver_1_7 = true;
	}
	else if(CStringA(cbuf).Mid(14) == "v1.8")
	{
		// #define STD_HEADER_FIND_QUERY_DLG_A_1_8	"FindQueryData v1.8\0"
		// #define STD_HEADER_FIND_QUERY_DLG_U_1_8 "FindQueryDatU v1.8\0"

		flag_ver_1_8 = true;
	}
	else if(CStringA(cbuf).Mid(14) == "v1.9")
	{
		// #define STD_HEADER_FIND_QUERY_DLG_A_1_9	"FindQueryData v1.9\0"
		// #define STD_HEADER_FIND_QUERY_DLG_U_1_9 "FindQueryDatU v1.9\0"
		flag_ver_1_9 = true;
	}
	else if(CStringA(cbuf).Mid(14) == "v2.0")
	{
		// #define STD_HEADER_FIND_QUERY_DLG_A		"FindQueryData v2.0\0"
		// #define STD_HEADER_FIND_QUERY_DLG_U		"FindQueryDatU v2.0\0"
		//flag_ver_2_0 = true; -   .     ,     !
	}
	else
	{
		delete cbuf;
		AfxMessageBox( APL_T("      .\n  !"));
		return false;
	}

	delete cbuf;

	if(flag_ver_1_1 || flag_ver_1_2 || flag_ver_1_3 || flag_ver_1_4 || flag_ver_1_5 || flag_ver_1_6 || flag_ver_1_7 || flag_ver_1_8)
	{
		//   ,   STEP_QL  NO_CASE.    
		m_IsMatchCase=TRUE;
	}

	//  
	m_dbuf->Read(&type_b,1);
	m_mode=(TypeFindObject)type_b;

	//   
	m_dbuf->Read(&count,1);
	for(j=0;j<count;j++)
	{
		m_dbuf->Read(&type_b,1);
		str_par=_T("");
		type_attr = (TypeFOAttr) type_b;
		m_dbuf->Read(&log_rel_BYTE,1);
		if(flag_ver_1_2 || flag_ver_1_1 || flag_ver_1_0)
		{
			if(log_rel_BYTE==1){log_rel=CaplQLQuery::aplEQUAL;}else{log_rel=CaplQLQuery::aplLIKE;}
		}
		else
		{
			log_rel=(CaplQLQuery::aplQLLogRelation)log_rel_BYTE;
		}


		switch(type_attr)
		{
		case TFO_Id:
		case TFO_Name:
		case TFO_Descr:
		case TFO_Code:
		case TFO_CodeVer1:
		case TFO_CodeVer2:
		case TFO_CodeIzd:
		case TFO_Ver:
		case TFO_Source:
		case TFO_VerDescr:
// 		case TFO_RelPos:
// 		case TFO_RelPosId:
// 		case TFO_RelName:
// 		case TFO_RelDescr:
		case TFO_Standart:
		case TFO_Groupe:
		case TFO_Part:
		case TFO_Label:
		case TFO_VerList:
		case TFO_VerLists:
		case TFO_VerFormat:
		case TFO_VerLitera:
		case TFO_DocCode1:
		case TFO_DocCode2:
		case TFO_DocUrgency:
		case TFO_StrExt:
		case TFO_RefDocNum:	 //  -  
		case TFO_RefState:	 //  - 
		case TFO_RefDocType:	 //  -  
		case TFO_RefManifDescr:
		case TFO_ProcTaskId:
		case TFO_ProcTaskName:
		case TFO_ProcState:
		case TFO_ProcTaskExpired:
		case TFO_DocMaillist:
		case TFO_State:
			LoadFromBufBaseString(str_par);
			value.Set(str_par);
			break;

		case TFO_ProcTaskExpiredNDays:
			m_dbuf->Read(&int_val,4);
			value.Set(int_val);
			break;

		case TFO_Date1:  // - 
		case TFO_Date2:
		case TFO_Date3:
		case TFO_Date4:
			LoadFromBufBaseString(str_par);
			if(str_par.GetLength()==14)
			{
				CString str = str_par.Left(8);
				str_par = str+_T("000000");
			}
			value.Set(str_par);

			if(flag_ver_1_5) break;

			LoadFromBufBaseString(str_par);
			if(str_par.GetLength()==14)
			{
				CString str = str_par.Left(8);
				str_par = str+_T("000000");
			}
			value2.Set(str_par);

			break;

		case TFO_ProjCustomer:
		case TFO_ProjKurator:
		case TFO_ProjExecutors:
		case TFO_ProjCoexecutors:
		case TFO_InAggr:
		case TFO_RefOrg:			
		case TFO_RefSector:		
		case TFO_RefCulprit:		
		case TFO_RefStage:		

		case TFO_RefMainPDF:		
		case TFO_RefMainItem:		
		case TFO_RefSystem:		
		case TFO_RefFailedItem:	
		case TFO_RefFailedPart:	
		case TFO_RefConditions:	
		case TFO_RefDof		:	
		case TFO_RefFaultReason:	
		case TFO_RefMethod	:	
		case TFO_RefConsequence	:
		case TFO_RefManif	:	
		case TFO_ProcTaskPerformer:
		case TFO_ProcRefusalCulprit:
		case TFO_ProcOwner:
		case TFO_ProcTemplate:
		case TFO_ProcActivity:

			m_dbuf->Read(&id,4);
			inst=m_api->m_data.GetInstById(id);
			value.Set(inst);
			ext4load.Add(inst);
			break;

		case TFO_RelContext:
			// c  
			ext1.Clear();
			m_dbuf->Read(&str_len_BYTE,1);
			for(i=0;i<str_len_BYTE;i++)
			{
				m_dbuf->Read(&id,4);
				ext1.Add(m_api->m_data.GetInstById(id));
			}
			value.Set(ext1);
			ext4load.Append(ext1);
			break;

		case TFO_Type:
			if(log_rel!=CaplQLQuery::aplNOLOGREL && log_rel!=CaplQLQuery::aplNOTEXIST)
			{
				if(m_mode==FindObject_ProductVer || m_mode==FindObject_Change)
				{
					LoadFromBufBaseString(str_par);
					value.Set(str_par);

				}
				else if(m_mode==FindObject_Document || m_mode==FindObject_BP || 
						m_mode==FindObject_Project || m_mode==FindObject_Refusal)
				{
					m_dbuf->Read(&id,4);
					inst=m_api->m_data.GetInstById(id);
					value.Set(inst);
					ext4load.Add(inst);
				}
			}
			else
			{
				value.Clear();
			}
			break;

		default:
			AfxMessageBox( APL_T("      .\n  !"));
			return false;
		}

		m_attr_values.Add(type_attr,log_rel,value,value2);

	}
	m_api->LoadExtentInfo(ext4load);
	
	//   
	m_dbuf->Read(&count,1);
	
	apidata.GetEntityExtentBN(_T("approval_status"),ext1);
	apidata.GetEntityExtentBN(_T("person_and_organization"),ext2);
	apidata.GetEntityExtentBN(_T("person"),ext3);
	for(i=0;i<count;i++)
	{
		m_dbuf->Read(&type_b,1);
		flag=type_b==1;
		m_dbuf->Read(&count2,1);
		if(count2==0)
		{
			if(m_mode_slave)m_indx_of_zero_approval = i;
			else continue;
		}
		el_apr=new ElValApproval();
		el_apr->is_exist=flag;

		for(j=0;j<count2;j++)
		{
			m_dbuf->Read(&type_b,1);
			switch(type_b)
			{
			case 1:
				// 1 -  (instance_id - 4 )
				m_dbuf->Read(&id,4);
				for(k=0;k<ext1.Size;k++)
				{
					if(ext1[k]->GetId()==id)
					{
						el_apr->status=ext1[k];
						break;
					}
				}
				break;
			case 2:
				// 2 -  (instance_id - 4 )
				m_dbuf->Read(&id,4);
				for(k=0;k<ext3.Size;k++)
				{
					if(ext3[k]->GetId()==id)
					{
						el_apr->person=ext3[k];
						break;
					}
				}
				if(el_apr->person==0)
				{
					//     ,   person_and_organization
					for(k=0;k<ext2.Size;k++)
					{
						if(ext2[k]->GetId()==id){
							el_apr->person=ext2[k];
							break;
						}
					}
				}
				break;
			case 3:
				// 3 -  (1 :1 ,0 ;  - 1    +  )
				m_dbuf->Read(&type_b,1);
				el_apr->pers_org_role_eq=type_b==1;
				LoadFromBufBaseString(el_apr->pers_org_role);
				break;
			case 4:
				// 4 -  ( :
				// 1  -  : 0 -  , 1 - ; 
				m_dbuf->Read(&type_b,1);
				if(type_b==0)
				{
					el_apr->is_single_date=true;
					m_dbuf->Read(&dt1,8);
					if(el_apr->date_time_beg==0)
					{
						el_apr->date_time_beg=new COleDateTime();
					}
					*(el_apr->date_time_beg)=(DATE)dt1;
				}
				else
				{
					el_apr->is_single_date=false;
					m_dbuf->Read(&dt1,8);
					m_dbuf->Read(&dt2,8);
					if(el_apr->date_time_beg==0 && dt1!=0)
					{
						el_apr->date_time_beg=new COleDateTime();
						*(el_apr->date_time_beg)=(DATE)dt1;
					}
					if(el_apr->date_time_end==0 && dt2!=0)
					{
						el_apr->date_time_end=new COleDateTime();
						*(el_apr->date_time_end)=(DATE)dt2;
					}
				}
				break;
			case 5:
				// 5 -  .  8-   "" 
				m_dbuf->Read(&dt1,8);
				m_dbuf->Read(&dt2,8);
				if(el_apr->revoc_date_time_beg==0 && dt1!=0)
				{
					el_apr->revoc_date_time_beg=new COleDateTime();
					*(el_apr->revoc_date_time_beg)=(DATE)dt1;
				}
				if(el_apr->revoc_date_time_end==0 && dt2!=0)
				{
					el_apr->revoc_date_time_end=new COleDateTime();
					*(el_apr->revoc_date_time_end)=(DATE)dt2;
				}
				break;
			case 6:
				// 6 -  / . 4 , int
				m_dbuf->Read(&id,4);
				el_apr->is_dig_sign=id;
				break;
			case 7:
				//flag_ver_1_9
				// 7 -  / . 4    + 
				m_dbuf->ReadStrBuf(el_apr->descr);
				m_dbuf->Read(&type_b,1);
				el_apr->descr_relation=(CaplQLQuery::aplQLLogRelation) type_b;
				break;
			}
				
		}
		m_list_approval.Add(el_apr);
		
	}
	LoadFromBufListQChar();
		
	//   
	// 1  - 
	m_dbuf->Read(&count,1);
	apidata.GetEntityExtent(m_api->m_doc_mgr.e_dt,ext1);
//	apidata.GetEntityExtent(m_api->m_charact_mgr.e_apl_charact_type,ext2);
	
	for(i=0;i<count;i++)
	{
		//1  -  (1 /0  )
		m_dbuf->Read(&type_b,1);
		flag=type_b==1;
		//1  -   
		m_dbuf->Read(&count2,1);
		if(count2==0)continue;

		el_doc=new ElValDoc();
		el_doc->is_exist=flag;

		for(k=0;k<count2;k++)
		{
			//1  - id  (  -  ):
			m_dbuf->Read(&type_b,1);
			switch(type_b)
			{
			case 1:
				//1 -  (1 : 1 /0 ; 1    +  )
				m_dbuf->Read(&type_b,1);
				el_doc->is_eq_id=type_b==1;
				LoadFromBufBaseString(el_doc->id);
				break;
			case 2:
				//2 -  (1 : 1 /0 ; 1    +  )
				m_dbuf->Read(&type_b,1);
				el_doc->is_eq_name=type_b==1;
				LoadFromBufBaseString(el_doc->name);
				break;
			case 3:
				//3 -  (4  - instance_id)
				m_dbuf->Read(&id,4);
				for(j=0;j<ext1.GetSize();j++)
				{
					if(ext1.GetAt(j)->GetId()==id)
					{
						el_doc->type=ext1.GetAt(j);
						break;
					}
				}
				break;
				
			}
		}
		m_list_doc.Add(el_doc);
	}
	
	//  
	// 1  -      (1 - , 0  , 255 -  )
	m_dbuf->Read(&type_b,1);
	switch(type_b)
	{
	case 0:
		//m_IsMakeTableResult=FALSE;
		m_can_make_table=true;
		break;
	case 1:
		//m_IsMakeTableResult=TRUE;
		m_can_make_table=true;
		break;
	case 252:
		//m_IsMakeTableResult=FALSE;
		m_can_make_table=false;
		m_CtrlMakeTableResult.EnableWindow(FALSE);
		break;
	}
	m_changed=false;
	if(flag_ver_1_0)return true;

	// ver 1_1

	//      
	m_dbuf->Read(&type_b,1);
	if(type_b==1)m_ctrl_find_version.SetCheck(1);

	if(flag_ver_1_1)return true;

	// ver_1_2

	//    
	// 1  - 
	m_dbuf->Read(&count,1);
	for(i=0;i<count;i++)
	{
		el_blob=new ElValBLOB();
		m_dbuf->Read(&type_b,1);
		flag=type_b==1;
		el_blob->is_equal=flag;
		LoadFromBufBaseString(el_blob->word);
		m_list_blob.Add(el_blob);
	}
	
	//      
	if(m_dbuf->Read(&type_b,1))
	{
		if(type_b==1)m_IsSubstring = TRUE;
	}
	//     
	if(m_dbuf->Read(&type_b,1))
	{
		if(type_b==1)m_IsBrackets = TRUE;
	}

	if(flag_ver_1_6) return true;

	// ,   
	// 1  - 
	m_dbuf->Read(&count,1);
	for(i=0;i<count;i++)
	{
		//1  -  (1 /0  )
		m_dbuf->Read(&type_b,1);
		flag=type_b==1;
		//1  -   
		m_dbuf->Read(&count2,1);
		if(count2==0)continue;

		el_class=new ElValClass();
		el_class->is_exist=flag;

		for(k=0;k<count2;k++)
		{
			//1  - id  (  -  ):
			m_dbuf->Read(&type_b,1);
			switch(type_b)
			{
			case 1:
				//1 -  (4  - instance_id)
				m_dbuf->Read(&id,4);
				el_class->classif = m_api->m_data.GetInstById(id);
				m_api->m_classifier_mgr.LoadClassifierInfo(el_class->classif);
				break;
			}
		}
		m_list_class.Add(el_class);
	}

	if(flag_ver_1_7)
		return true;
	
	m_dbuf->Read(&type_b, 1);
	m_is_or_char = type_b == 1;

	m_dbuf->Read(&type_b, 1);
	m_is_or_doc = type_b == 1;

	m_dbuf->Read(&type_b, 1);
	m_is_or_approval = type_b == 1;

	m_dbuf->Read(&type_b, 1);
	m_is_or_res = type_b == 1;

	m_dbuf->Read(&type_b, 1);
	m_is_or_blob = type_b == 1;

	m_dbuf->Read(&type_b, 1);
	m_is_or_class = type_b == 1;

	if(flag_ver_1_8)
		return true;

	//    1.9
	//  " "
	m_dbuf->Read(&type_b, 1);
	if(type_b==1)
		m_IsMatchCase=TRUE;

	return true;
}

bool CFindQueryDlgEx::SetDataBuf(CaplDataBuf &dbuf){
	if(m_dbuf==0){
		m_dbuf=new CaplDataBuf();
		if(m_dbuf==0)return false;
	}
	m_dbuf->Clear();
	m_dbuf->Add(dbuf.GetBuffer(),dbuf.m_Size);
	return true;
}

bool CFindQueryDlgEx::GetDataBuf(CaplDataBuf &dbuf){
	if(m_dbuf==0)
		return false;
	dbuf.Clear();
	dbuf.Add(m_dbuf->GetBuffer(),m_dbuf->m_Size);
	return true;
}


void CFindQueryDlgEx::OnChangeEdit() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CResizableDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	m_changed=true;
	
}

void CFindQueryDlgEx::OnChangeEditNameQuery() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CResizableDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	m_changed=true;	
}

void CFindQueryDlgEx::BeginEditAttrDef()
{
	int i,pos = 0, num_inserted=0, pos_curr = 0;
	SFindAttrDef* attr_def=0,*attr_def_curr=0;
	CRect rect,rectc;
	BOOL res=true;
	
	if(m_curr_type_descr == 0) return;
	m_num_curr_combo4edit= m_ListAttributes.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if( m_num_curr_combo4edit== -1)
	{
		return;
	}
	attr_def_curr = (SFindAttrDef*)m_ListAttributes.GetItemData(m_num_curr_combo4edit);

	// ,          &      
	m_Cmbx4Edit.ResetContent();
	for(i=0;i<m_curr_type_descr->list_attrs.Size;i++)
	{
		attr_def = m_curr_type_descr->list_attrs.GetAt(i);
		if(attr_def == 0) continue;
		if(attr_def_curr == attr_def) 
		{
			pos_curr = num_inserted;
		}
		else if(m_attr_values.IsExist(attr_def->type)) continue;

		//pos = m_Cmbx4Edit.AddString(attr_def->name4user);
		// :       (   AddString)
		pos = m_Cmbx4Edit.InsertString(m_Cmbx4Edit.GetCount(),attr_def->name4user);
		m_Cmbx4Edit.SetItemData(pos,(DWORD)attr_def);
		num_inserted++;
	}
	if(num_inserted == 0) return;
	m_Cmbx4Edit.SetCurSel(pos_curr);


	m_ActiveCtrl=&m_Cmbx4Edit;
	CalcMoveEdit(1);

	//  ,    
	m_curr_combo4edit=TSC_SelectTypeAttr;

}

void CFindQueryDlgEx::BeginEditAttrRel()
{
	if(m_curr_type_descr == 0) return;
	// 
	SFindAttrDef* attr_def = 0;
	CaplQLQuery::aplQLLogRelation val_log_rel = CaplQLQuery::aplNOLOGREL;
	CaplQLQuery::aplQLLogRelation tmp_log_rel = CaplQLQuery::aplNOLOGREL;
	CaplValue value,value2;
	CUIntArray log_rels;
	int i,pos;
	int def;
	
	m_num_curr_combo4edit= m_ListAttributes.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if( m_num_curr_combo4edit== -1)
	{
		return;
	}
	attr_def = (SFindAttrDef*)m_ListAttributes.GetItemData(m_num_curr_combo4edit);
	if(attr_def == 0) return;

	//        
	m_attr_types2log_rel.Get(attr_def->type,log_rels,def);

	if(log_rels.GetSize() == 1)
	{
		CaplQLQuery::aplQLLogRelation curr_rel = (CaplQLQuery::aplQLLogRelation)log_rels.GetAt(0);
		m_attr_values.Set(attr_def->type,curr_rel);

		//m_ListAttributes.SetItemText(m_num_curr_combo4edit,0,attr_def->name4user);
		m_ListAttributes.SetItemText(m_num_curr_combo4edit,1,CaplQLQuery::LogOp2String(curr_rel));
		return;
	}

	// ,      
	if(!m_attr_values.Get(attr_def->type,val_log_rel,value,value2))
	{
		val_log_rel = (CaplQLQuery::aplQLLogRelation) log_rels[def];
	}

	//     
	m_Cmbx4Edit.ResetContent();

	for(i=0;i<log_rels.GetSize();i++)
	{
		tmp_log_rel = (CaplQLQuery::aplQLLogRelation) log_rels.GetAt(i);
		//        ,  " " 
		if((m_curr_type_descr->type == FindObject_ProductVer || m_curr_type_descr->type == FindObject_Refusal) && tmp_log_rel == CaplQLQuery::aplNOLOGREL) continue;

		pos = m_Cmbx4Edit.AddString(CaplQLQuery::LogOp2String(tmp_log_rel));
		m_Cmbx4Edit.SetItemData(pos,(DWORD)tmp_log_rel);
		if(tmp_log_rel == val_log_rel || pos == 0)
		{
			m_Cmbx4Edit.SetCurSel(pos);
		}
	}

	m_ActiveCtrl = &m_Cmbx4Edit;
	CalcMoveEdit(2);

	//  ,    
	m_curr_combo4edit=TSC_SelectLogOp;

}

void CFindQueryDlgEx::CalcMoveEdit(int column)
{
	BOOL res=true;
	int height_def;
	int i;
	int x_left = 0,x_right = 0;

	CRect rect,rectc;

	if(m_ActiveCtrl == 0) return;

	//      
	for(i=0;i<column;i++)
	{
		if(i == column-1) x_left = x_right;
		x_right += m_ListAttributes.GetColumnWidth(i);
	}
	//        -   
	m_ListAttributes.GetClientRect(&rectc);
	if(rectc.right < x_right)x_right = rectc.right - 1;

	//   - 
	//    
	m_ListAttributes.GetItemRect(m_num_curr_combo4edit,rect,LVIR_BOUNDS);
	height_def = rect.Height()-1;

	//   
	rect.left = x_left + 2;
	rect.right = x_right + 1;

	if(m_ActiveCtrl == &m_Cmbx4Edit || m_ActiveCtrl == &m_CmbxEdit4Edit)
	{
		//  .    
	}
	else if(m_ActiveCtrl == &m_Edit4Edit)
	{
		//  edit.    edit
		rect.left += 4;
		rect.top += 3;
		rect.bottom -= 2;
		rect.right -= 4;
	}
	else if(m_ActiveCtrl == &m_CtrlDate4Edit)
	{
		if(m_edit2date)
		{
			CRect rec2;
			DWORD width_std = 80;
			DWORD offset_1 =  14;
			DWORD offset_2 =  15;
			
			rec2 = rect;
			m_ListAttributes.SetItemText(m_num_curr_combo4edit,2,APL_T("                            "));
			rect.left = rect.left + offset_1;
 			rect.right = rect.left + width_std;
			rec2.left = rect.right + offset_2;
			rec2.right = rec2.left + width_std;
			res=m_CtrlDate4Edit2.SetWindowPos(&wndTop,rec2.left,rec2.top,rec2.Width(),rec2.Height(),SWP_SHOWWINDOW|SWP_NOCOPYBITS);
			m_CtrlDate4Edit2.SetFocus();
			m_CtrlDate4Edit2.SetForegroundWindow();
		}
	}
	res=m_ActiveCtrl->SetWindowPos(&wndTop,rect.left,rect.top,rect.Width(),rect.Height(),SWP_SHOWWINDOW|SWP_NOCOPYBITS);
	m_ActiveCtrl->SetFocus();
	m_ActiveCtrl->SetForegroundWindow();

}

#define ADD_STR2COMBO_WITH_SELECT(_str_val) pos=m_Cmbx4Edit.AddString( _str_val);if(str_val==_str_val || pos==0)m_Cmbx4Edit.SetCurSel(pos);
#define ADD_STR2COMBO_WITH_SELECT_F(_str_val) pos=m_CmbxEdit4Edit.AddString( _str_val);if(str_val==_str_val){m_CmbxEdit4Edit.SetCurSel(pos);non_standart=false;}

void CFindQueryDlgEx::BeginEditAttrVal()
{
	if(m_curr_type_descr == 0) return;
	// 
	SFindAttrDef* attr_def = 0;
	CaplQLQuery::aplQLLogRelation val_log_rel = CaplQLQuery::aplNOLOGREL;
	CaplValue value,value2;
	CString str_val;
	aplExtent ext;
	COleDateTime odt;
	long FlagsSelectInstance;

	CUIntArray log_rels;
	int i,pos,int_val;
	
	CaplInstance* curr_type_inst=0,*inst=0;
	m_ActiveCtrl = 0;
	m_hwndEditInComboItem = 0;
	m_edit2date = false;
	
	m_num_curr_combo4edit= m_ListAttributes.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if( m_num_curr_combo4edit== -1)
	{
		return;
	}
	attr_def = (SFindAttrDef*)m_ListAttributes.GetItemData(m_num_curr_combo4edit);
	if(attr_def == 0) return;

	// ,      
	m_attr_values.Get(attr_def->type,val_log_rel,value,value2);

	// ,       
	switch(attr_def->type)
	{
	case TFO_RelContext:  // - 
		//    . 
		//   -          
		value.Get(ext);
		m_api->m_prd_mgr.ChangeItemContext(ext);
		value.Set(ext);
		m_attr_values.Set(attr_def->type,value,value2);
		m_api->m_prd_mgr.PrintItemContextInString(ext,str_val);
		m_ListAttributes.SetItemText(m_num_curr_combo4edit,2,str_val);
		return;
		break;

	case TFO_ProjCustomer:
	case TFO_ProjKurator:
	case TFO_ProjExecutors:
	case TFO_ProjCoexecutors:
	case TFO_InAggr:
	case TFO_RefOrg:
	case TFO_RefCulprit:
	case TFO_RefSector:	
	case TFO_RefStage:	
	case TFO_RefMainPDF:	 
	case TFO_RefMainItem:	 
	case TFO_RefSystem:	 
	case TFO_RefFailedItem:	 
	case TFO_RefFailedPart:	 
	case TFO_RefConditions:	 
	case TFO_RefDof:		 
	case TFO_RefFaultReason:
	case TFO_RefMethod:		 
	case TFO_RefConsequence:
	case TFO_RefManif:		 
	case TFO_ProcTaskPerformer:
	case TFO_ProcRefusalCulprit:
	case TFO_ProcOwner:
		//         .
		//   -          
		value.Get(inst); 

		switch(attr_def->m_type_select)
		{
		case TSI_ClassifierItem:
			m_api->m_classifier_mgr.SelectItem(&inst,attr_def->m_ciChooseParent,APL_SELECT_CLASSIFIER_ITEM,attr_def->m_sChooseTitle);
			break;

		case TSI_ClassifierLevel:
			m_api->m_classifier_mgr.SelectItem(&inst,attr_def->m_ciChooseParent,APL_SELECT_CLASSIFIER_LEVEL,attr_def->m_sChooseTitle);
			break;

		case TSI_Persorg:
			inst = m_api->m_appr_mgr.SelectPersonOrOrganization(APL_MODE_SELECT_ORG|APL_MODE_SELECT_PERSON , 
												ext, attr_def->m_sChooseTitle, APL_T("    "));
			break;

		case TSI_Org:
			m_api->m_appr_mgr.SelectOrganization(&inst,attr_def->m_sChooseTitle);
			break;

		case TSI_Pdf:
			{	// CaplFaultMgr::SelectMainPdf
				CString sSpavElement;
				CaplInstance *ciMain = 0;
				m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\   "),sSpavElement,_T(""));
				if(m_api->m_prd_mgr.FindPKIEx(&ciMain, 0, false, true,true,LPCTSTR(sSpavElement)))
				{		
					inst = ciMain;
				}
			}
			break;

		case TSI_Item:
			if(m_api->m_expl_mgr!=0)m_api->m_expl_mgr->FindPrdInst1(&inst, aplFindAllPrdInst);
			else inst = m_api->m_prd_mgr.SelectInstanceEx(APL_MODE_SELECT_PRDINST,attr_def->m_sChooseTitle);
			break;

		case TSI_System:
			if(m_api->m_expl_mgr!=0)m_api->m_expl_mgr->SelectPlanerSystem1(&inst, aplSelectPlanerSystem, 0);
			//else api->m_classifier_mgr.SelectItem(&ciLvl, ciRoot, APL_SELECT_CLASSIFIER_LEVEL, sTitle);
			break;

		default:
			FlagsSelectInstance= //APL_MODE_SELECT_CATEGORY|
				APL_MODE_SELECT_FOLDER|
				APL_MODE_SELECT_PRD|
				APL_MODE_SELECT_PDF|
				APL_MODE_SELECT_DOC|
				APL_MODE_SELECT_BP|
				APL_MODE_SELECT_LOT|
				APL_MODE_SELECT_PRDINST|
				APL_MODE_SELECT_DOC_REVISION|
				APL_MODE_SELECT_BP_REVISION|
				//APL_MODE_SELECT_CATEG_REVISION|
				//APL_MODE_SELECT_PROJECT|	
				APL_MODE_SELECT_ORG|
				//APL_MODE_SELECT_PERSON|
				//APL_MODE_SELECT_OFFICIAL|
				//APL_MODE_SELECT_CHANGE|
				APL_MODE_SELECT_BPINST
				;
			inst= m_api->m_categ_mgr.SelectInstance(FlagsSelectInstance);
			break;
		}

		if(inst != 0)
		{
			value.Set(inst);
			m_attr_values.Set(attr_def->type,value,value2);
			switch(attr_def->m_type_select)
			{
			case TSI_Persorg:
				if(m_api->m_data.IsKindOf(inst, m_api->m_appr_mgr.e_person)) m_api->m_appr_mgr.GetPersonName(inst,str_val);
				else if(m_api->m_data.IsKindOf(inst, m_api->m_appr_mgr.e_org)) m_api->m_data.GetAttr(inst,m_api->m_appr_mgr.a_org_name,str_val); 
				break;
			default:
				str_val = m_api->GetItemName(inst);
				break;
			}
		}
		else
		{
			str_val = _T("");
		}
		m_ListAttributes.SetItemText(m_num_curr_combo4edit,2,str_val);
		m_changed=true;
		return;
		break;

	case TFO_ProcTemplate:
		//     .
		//   -          
		value.Get(inst); 
		
		{
			aplExtent templs;
			CaplInstance* owner= m_api->m_appr_mgr.GetCurrentPerson();
			m_api->m_wf_mgr->GetUserProcessTempList(owner, templs);
			inst = m_api->m_wf_mgr->SelectTemplateSchema(templs, inst); 
		}

		if(inst != 0)
		{
			value.Set(inst);
			m_attr_values.Set(attr_def->type,value,value2);
			str_val = m_api->GetItemName(inst);
			m_ListAttributes.SetItemText(m_num_curr_combo4edit,2,str_val);
			m_changed=true;
		}
		else
		{
			//     -   
		}
		return;
		break;

	case TFO_ProcActivity:
		//     .
		//   -          
		value.Get(inst); 
		
		{
			aplExtent templs;
			CaplInstance* owner= m_api->m_appr_mgr.GetCurrentPerson();
			m_api->m_wf_mgr->GetUserProcessTempList(owner, templs);
			inst = m_api->m_wf_mgr->SelectTemplateSchema(templs, inst, true, APL_MODE_WFL_SELECT_ACTIVITI); 
		}

		if(inst != 0)
		{
			value.Set(inst);
			m_attr_values.Set(attr_def->type,value,value2);
			str_val = m_api->GetItemName(inst);
			m_ListAttributes.SetItemText(m_num_curr_combo4edit,2,str_val);
			m_changed=true;
		}
		else
		{
			//     -   
		}
		return;
		break;

	case TFO_Type:  // -  
		if(val_log_rel == CaplQLQuery::aplNOTEXIST || val_log_rel == CaplQLQuery::aplNOLOGREL)
		{
			//      - 
			m_changed=true;
			value.Clear();
			m_attr_values.Set(attr_def->type,value,value2);
			m_ListAttributes.SetItemText(m_num_curr_combo4edit,2,_T(""));
			return;
		}
		//    ,     -    
		switch(m_mode)
		{
		case FindObject_ProductVer:
			m_ActiveCtrl = &m_Cmbx4Edit;
			m_Cmbx4Edit.ResetContent();
			value.Get(str_val);
			for(i=0;i<m_api->m_prd_mgr.m_list_pdf_types.GetSize();i++)
			{
				ADD_STR2COMBO_WITH_SELECT(m_api->m_prd_mgr.m_list_pdf_types.GetAt(i));
			}
			break;
		case FindObject_Change:
			m_ActiveCtrl = &m_Cmbx4Edit;
			m_Cmbx4Edit.ResetContent();
			value.Get(str_val);
			for(i=0;i<attr_def->m_list_selected_string.GetSize();i++)
			{
				ADD_STR2COMBO_WITH_SELECT(attr_def->m_list_selected_string.GetAt(i)->str);
			}
			break;
		case FindObject_Document:
			//     .          
			value.Get(curr_type_inst);
			curr_type_inst = m_api->m_doc_mgr.SelectDocType(curr_type_inst,0,true);
			if(curr_type_inst==0)return;
			
			m_changed=true;
			value.Set(curr_type_inst);
			m_attr_values.Set(attr_def->type,value,value2);
			apidata.GetAttr(curr_type_inst,m_api->m_doc_mgr.a_dt_pdt,str_val);
			m_ListAttributes.SetItemText(m_num_curr_combo4edit,2,str_val);
			return;
			break;
		case FindObject_BP:
			//     .          
			value.Get(curr_type_inst);
			curr_type_inst = m_api->m_bp_mgr.SelectBpType(curr_type_inst,0);
			if(curr_type_inst==0)return;

			m_changed=true;
			value.Set(curr_type_inst);
			m_attr_values.Set(attr_def->type,value,value2);
			apidata.GetAttr(curr_type_inst,m_api->m_bp_mgr.a_bp_type_name,str_val);
			m_ListAttributes.SetItemText(m_num_curr_combo4edit,2,str_val);
			return;
			break;
		case FindObject_Project:
			m_Cmbx4Edit.ResetContent();
			m_ActiveCtrl = &m_Cmbx4Edit;
			value.Get(curr_type_inst);
			for(i=0;i<m_list_project_types.Size;i++)
			{
				apidata.GetAttr(m_list_project_types.GetAt(i),m_api->m_project_mgr->a_project_type_name,str_val);
				pos=m_Cmbx4Edit.AddString(str_val);
				m_Cmbx4Edit.SetItemData(pos,(DWORD)m_list_project_types.GetAt(i));
				if(i==0)m_Cmbx4Edit.SetCurSel(pos);//        
				if(m_list_project_types.GetAt(i) == curr_type_inst)m_Cmbx4Edit.SetCurSel(pos);
			}
			break;
		case FindObject_Refusal:
			m_Cmbx4Edit.ResetContent();
			m_ActiveCtrl = &m_Cmbx4Edit;
			value.Get(curr_type_inst);
			{
				CString sName;
				aplExtent aeItems;
				CaplInstance *ciLvl = m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_TYPE_CLASSIFIER_LVL,true);
				if(!ciLvl) 
				{
					AfxMessageBox(APL_T("     !!!"));
					return;
				}

				m_api->m_classifier_mgr.LoadSubClassifierLevels(ciLvl, aeItems);
				for(int i=0; i<aeItems.Size; i++)
				{
					m_api->m_data.GetAttr(aeItems[i], m_api->m_classifier_mgr.a_apl_classifier_level_name, sName);
					if(sName.IsEmpty()) continue;

					pos = m_Cmbx4Edit.AddString(sName);
					m_Cmbx4Edit.SetItemData(pos, (DWORD)aeItems[i]);
					if(i==0)m_Cmbx4Edit.SetCurSel(pos);//        
					if(aeItems[i]==curr_type_inst)m_Cmbx4Edit.SetCurSel(pos);
				}
			}
			break;
		default:
			AfxMessageBox(APL_T("      \"\"!!!"));
			return;
		}
		break;

	case TFO_RefDocType:
		m_CmbxEdit4Edit.ResetContent();
		m_ActiveCtrl = &m_CmbxEdit4Edit;
		value.Get(str_val);
		{
			//           .  ,         
			COMBOBOXINFO info = { sizeof(COMBOBOXINFO) };
			m_CmbxEdit4Edit.GetComboBoxInfo(&info);
			m_hwndEditInComboItem = info.hwndItem;

			bool non_standart=true;
			for(i=0;i<attr_def->m_list_selected_string.GetSize();i++)
			{
				ADD_STR2COMBO_WITH_SELECT_F(attr_def->m_list_selected_string.GetAt(i)->str);
			}

			ADD_STR2COMBO_WITH_SELECT(APL_T(""));
			if(non_standart && str_val!=_T(""))
			{
				ADD_STR2COMBO_WITH_SELECT_F(str_val);
			}
			ADD_STR2COMBO_WITH_SELECT_F(APL_T(""));
		}
		break;

	case TFO_Date1:  // - 
	case TFO_Date2:
	case TFO_Date3:
	case TFO_Date4:
		if(val_log_rel ==  CaplQLQuery::aplNOLOGREL) 
		{
			m_ActiveCtrl = 0;
			value.Clear();
			m_attr_values.Set(attr_def->type,value,value2);
			str_val = _T("");
			m_ListAttributes.SetItemText(m_num_curr_combo4edit,2,str_val);
			return;
		}
		else
		{
			m_ActiveCtrl = &m_CtrlDate4Edit;
			value.Get(str_val);
			if(!aplString2Date(str_val,odt))
			{
				odt = COleDateTime::GetCurrentTime();
			}
			m_Date4Edit.SetDateTime(odt.GetYear(),odt.GetMonth(),odt.GetDay(), 0,0,0);
			m_CtrlDate4Edit.SetParent(this);
			m_CtrlDate4Edit2.SetParent(this);
			if(val_log_rel ==  CaplQLQuery::aplINDIAPAZON) 
			{
				m_edit2date = true;
				value2.Get(str_val);
				if(!aplString2Date(str_val,odt))
				{
					odt = COleDateTime::GetCurrentTime();
				}
				m_Date4Edit2.SetDateTime(odt.GetYear(),odt.GetMonth(),odt.GetDay(), 0,0,0);
			}
			else m_edit2date = false;
			UpdateData(FALSE);
			m_CtrlDate4Edit.SetParent(&m_ListAttributes);
			m_CtrlDate4Edit2.SetParent(&m_ListAttributes);
		}
		break;

	case TFO_ProcTaskExpiredNDays:
		{
			m_ActiveCtrl = &m_Edit4Edit;
			value.Get(int_val);
			str_val.Format(_T("%i"),int_val);
			m_Edit4Edit.SetWindowText(str_val);
			LONG style = GetWindowLong(m_Edit4Edit.m_hWnd, GWL_STYLE);
			SetWindowLong(m_Edit4Edit.m_hWnd, GWL_STYLE, style | ES_NUMBER );
		}
		break;


	case TFO_Standart:  // - 
	case TFO_Groupe:
	case TFO_RefState:
	case TFO_DocUrgency:
	case TFO_Source:  // - 
	case TFO_VerFormat:
	case TFO_DocCode1:
	case TFO_DocCode2:
	case TFO_ProcTaskExpired:
	case TFO_ProcState:
	case TFO_State:

		m_ActiveCtrl = &m_Cmbx4Edit;
		m_Cmbx4Edit.ResetContent();
		value.Get(str_val);
		
		if(attr_def->m_list_selected_string.GetSize() > 0)
		{
			//    ,      ,       
			if(str_val!=_T(""))
			{
				int indx_map = attr_def->m_list_selected_string.FindByOut(str_val);
				if(indx_map!=-1)str_val = attr_def->m_list_selected_string.GetAt(indx_map)->str;
			}

			//            .
			for(i=0;i<attr_def->m_list_selected_string.GetSize();i++)
			{
				ADD_STR2COMBO_WITH_SELECT(attr_def->m_list_selected_string.GetAt(i)->str);
			}
			break;
		}
		//    break -      -    !

	case TFO_CodeVer1:		
		//         
		if(m_mode == FindObject_Change)
		{
			CString sSprav;
			m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\ "), sSprav);
			if(sSprav!=_T(""))
			{
				CaplInstance *org=0, *sprav=m_api->m_classifier_mgr.GetClassifierSystemById(sSprav);
				if(0==sprav)
				{
					AfxMessageBox(APL_NO_T("      '\\ '!!!"));
				}
				m_api->m_classifier_mgr.SelectItem(&org,sprav);
				if(0==org) 
					return;
				m_api->m_data.GetAttr(org,m_api->m_appr_mgr.a_org_id,value);
				value.Get(str_val);
				m_ListAttributes.SetItemText(m_num_curr_combo4edit,2,str_val);
				m_attr_values.Set(attr_def->type,value,value2);
				m_changed=true;
				return;
			}
		}
		//    break -   FindObject_Change    -    !

	case TFO_RefDocNum: //  -  
		//      -   
	default:
		//     
		m_ActiveCtrl = &m_Edit4Edit;
		value.Get(str_val);
		m_Edit4Edit.SetWindowText(str_val);
		break;
	}	
	
	//   
	//m_ActiveCtrl->GetWindowRect(&rect);

	CalcMoveEdit(3);
	
	//  ,    
	m_curr_combo4edit=TSC_SelectValue;
}

void CFindQueryDlgEx::OnBnClickedBtnAttrAdd()
{
	AttributesAdd();
}

void CFindQueryDlgEx::AttributesAdd()
{
	int i,pos = 0,num_inserted=0;
	SFindAttrDef* attr_def;
	CRect rect,rectc;
	BOOL res=true;

	if(m_curr_type_descr == 0) return;

	
	// ,          &      
	m_Cmbx4Edit.ResetContent();
	for(i=0;i<m_curr_type_descr->list_attrs.Size;i++)
	{
		attr_def = m_curr_type_descr->list_attrs.GetAt(i);
		if(attr_def == 0) continue;
		if(m_attr_values.IsExist(attr_def->type)) continue;
		
		//pos = m_Cmbx4Edit.AddString(attr_def->name4user);
		// :       (   AddString)
		pos = m_Cmbx4Edit.InsertString(m_Cmbx4Edit.GetCount(),attr_def->name4user);
		m_Cmbx4Edit.SetItemData(pos,(DWORD)attr_def);
		num_inserted++;
	}
	if(num_inserted == 0) return;
	m_Cmbx4Edit.SetCurSel(0);


	//      
	m_num_curr_combo4edit = m_ListAttributes.InsertItem(m_ListAttributes.GetItemCount(),_T(""));

	m_ActiveCtrl=&m_Cmbx4Edit;
	CalcMoveEdit(1);

	//  ,    
	m_curr_combo4edit=TSC_SelectTypeAttr;
}

void CFindQueryDlgEx::OnBnClickedBtnAttrDel()
{
	AttributesDel();
}
void CFindQueryDlgEx::AttributesDel()
{
	if(m_curr_type_descr == 0) return;
		// 
	int num_curr;
	SFindAttrDef* attr_def = 0;
	
	do{
		num_curr= m_ListAttributes.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
		if( num_curr== -1)
		{
			return;
		}
		attr_def = (SFindAttrDef*)m_ListAttributes.GetItemData(num_curr);
		if(attr_def == 0) continue;
		m_attr_values.Del(attr_def->type);
		m_ListAttributes.DeleteItem(num_curr);
		m_changed=true;
	}while(true);
}

void CFindQueryDlgEx::OnBnClickedBtnAttrEdit()
{
	if(m_curr_type_descr == 0) return;
	// 
	const MSG* msg;
	CPoint mouseclick;
	msg=GetCurrentMessage();
	//mouseclick -   
	mouseclick=msg->pt;
	CaplMenu menu;
	CMenu* pPopup =0;
	//  
	VERIFY(menu.LoadMenu(IDR_CONTEXT_MENU));
	pPopup = menu.GetSubMenu(12);

	CaplMenu::Install(this); 

	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
		TPM_RIGHTBUTTON|TPM_RETURNCMD,msg->pt.x, msg->pt.y,this);
	//       :
	switch (res)
	{
	case ID_FIND_CHANGE_REL: BeginEditAttrRel(); break;
	case ID_FIND_CHANGE_VAL:BeginEditAttrVal();	break;
	default:break;
	}

}

BOOL CFindQueryDlgEx::PreTranslateMessage(MSG* pMsg)
{
	// TODO: Add your specialized code here and/or call the base class
	BOOL res=FALSE;

#ifdef _DEBUG
// 	CString str;
// 	str.Format(_T("%i \n"),pMsg->message);
// 	OutputDebugString(str);
#endif

	if(pMsg!=0)
	{
		switch ( pMsg->message )
		{
		case WM_KEYDOWN:
		case WM_LBUTTONDOWN:
		case WM_LBUTTONDBLCLK:
		case WM_RBUTTONDOWN:
		case WM_RBUTTONDBLCLK:
		case WM_MBUTTONDOWN:
		case WM_MBUTTONDBLCLK:
			res = TestEndEdit(pMsg);
			break;
		}
	}
	if(res == TRUE) return TRUE;
	return CResizableDialog::PreTranslateMessage(pMsg);
}

long CFindQueryDlgEx::GetAttrType(SFindAttrDef *attr_def)
{
	if(attr_def == 0) return aplNOTYPE;
	switch(attr_def->type)
	{
	case TFO_Id:
	case TFO_Name:
	case TFO_Descr:
	case TFO_Code:
	case TFO_CodeVer1:
	case TFO_CodeVer2:
	case TFO_CodeIzd:
	case TFO_Ver:
	case TFO_VerDescr:
		// 			case TFO_RelPos:
		// 			case TFO_RelPosId:
		// 			case TFO_RelName:
		// 			case TFO_RelDescr:
	case TFO_Part:
	case TFO_Label:
	case TFO_VerList:
	case TFO_VerLists:
	case TFO_VerLitera:
	case TFO_StrExt:
	case TFO_RefManifDescr:
	case TFO_DocMaillist:
	case TFO_State:
		return aplSTRING;
		break;
	case TFO_Source:
		return apl_STRING_S1;
		break;
	case TFO_Standart:
		return apl_STRING_S2;
		break;
	case TFO_Groupe:
		return apl_STRING_S1;
		break;
	case TFO_VerFormat:
		return apl_STRING_S3;
		break;
	case TFO_DocCode1:
		return apl_STRING_S4;
		break;
	case TFO_DocCode2:
		return apl_STRING_S5;
		break;
	case TFO_DocUrgency:
		return apl_STRING_S6;
		break;

	case TFO_RefDocNum:
		return aplSTRING;
		break;
	case TFO_RefDocType:
		return apl_STRING_S1;
		break;
	case TFO_RefState:
		return apl_STRING_S2;
		break;

	case TFO_Date1:  // - 
	case TFO_Date2:
	case TFO_Date3:
	case TFO_Date4:
		return apl_DATE;
		break;

	case TFO_ProjCustomer:
	case TFO_ProjKurator:
	case TFO_ProjExecutors:
	case TFO_ProjCoexecutors:
	case TFO_InAggr:
		return aplINSTANCE;
	case TFO_RefOrg:
	case TFO_RefSector:return aplINSTANCE_S0;
	case TFO_RefCulprit:return aplINSTANCE_S1;
	case TFO_RefStage:	return aplINSTANCE_S2;
	case TFO_RefMainPDF:	 return aplINSTANCE_S3;
	case TFO_RefMainItem:	 return aplINSTANCE_S4;
	case TFO_RefSystem:	 return aplINSTANCE_S5;
	case TFO_RefFailedItem:	 return aplINSTANCE_S6;
	case TFO_RefFailedPart:	 return aplINSTANCE_S7;
	case TFO_RefConditions:	 return aplINSTANCE_S8;
	case TFO_RefDof:		 return aplINSTANCE_S9;
	case TFO_RefFaultReason:return aplINSTANCE_S10;
	case TFO_RefMethod:		 return aplINSTANCE_S11;
	case TFO_RefConsequence:return aplINSTANCE_S12;
	case TFO_RefManif:		return aplINSTANCE_S13;
	case TFO_RelContext: return aplAGGR;

	case TFO_Type:
		if(m_mode==FindObject_Document || m_mode==FindObject_BP || m_mode==FindObject_Project || m_mode==FindObject_Refusal)
		{
			//   //       
			return aplINSTANCE;
		}
		else
		{
			return aplSTRING;
		}
		break;	

	case TFO_ProcTaskId: return aplSTRING;
	case TFO_ProcTaskName: return aplSTRING;
	case TFO_ProcTaskExpired: return apl_STRING_S2;
	case TFO_ProcTaskExpiredNDays: return aplINTEGER;

	case TFO_ProcTaskPerformer:
	case TFO_ProcRefusalCulprit:
	case TFO_ProcOwner:
	case TFO_ProcTemplate:
		return aplINSTANCE;
		break;
	}

	return aplNOTYPE;
	
}

BOOL CFindQueryDlgEx::TestEndEdit(MSG* pMsg)
{
	BOOL retval = FALSE;
	bool is_end_combo = false;
	bool is_undo = false;
	SFindAttrDef *attr_def = 0,*attr_def_prev = 0;
	int num_select;
	CaplValue value,value2;
	CUIntArray log_rels_arr;
	CaplQLQuery::aplQLLogRelation curr_rel = CaplQLQuery::aplNOLOGREL;
	CString str_val,str1;
	CaplInstance* curr_type_inst=0;
	int def, int_val;
	bool need_print_table = true;

	if(pMsg == 0) return FALSE;
	if(m_ActiveCtrl == 0) return FALSE;

	if(pMsg->hwnd != m_ActiveCtrl->m_hWnd && pMsg->hwnd != m_CtrlDate4Edit2.m_hWnd && pMsg->hwnd != m_hwndEditInComboItem)
	{
		//        
		is_end_combo = true;
	}
	else if(pMsg->message == WM_KEYDOWN )
	{
		switch (pMsg->wParam)
		{
		case VK_ESCAPE:
			//  Escvape. ,   
			is_undo = true;
			is_end_combo = true;
			retval = TRUE;
			break;
		case VK_RETURN:
			//  Enter. ,   
			//     -      ;)
			retval = TRUE;
			is_end_combo = true;
			break;
		case VK_TAB:
			//  Tab.    
			is_end_combo = true;
			break;
		}
	}
	if(is_end_combo)
	{
		m_Cmbx4Edit.ShowWindow(SW_HIDE);
		m_CmbxEdit4Edit.ShowWindow(SW_HIDE);
		m_Edit4Edit.ShowWindow(SW_HIDE);
		LONG style = GetWindowLong(m_Edit4Edit.m_hWnd, GWL_STYLE);
		SetWindowLong(m_Edit4Edit.m_hWnd, GWL_STYLE, style & ~ES_NUMBER);
		m_CtrlDate4Edit.ShowWindow(SW_HIDE);
		m_CtrlDate4Edit2.ShowWindow(SW_HIDE);

		if(retval == TRUE) m_ListAttributes.SetFocus();

		if(	m_curr_combo4edit == TSC_NonEdit)
		{
			//     
		}
		else if(m_curr_combo4edit == TSC_SelectTypeAttr)
		{
			if(is_undo)
			{
				//  !  ,   ,     :) m_ListAttributes.DeleteItem(m_num_curr_combo4edit);
			}
			else
			{
				num_select = m_Cmbx4Edit.GetCurSel();
				if(num_select != -1)
				{
					attr_def = (SFindAttrDef*) m_Cmbx4Edit.GetItemData(num_select);
				}
				if(attr_def!=0)
				{
					attr_def_prev = (SFindAttrDef *)m_ListAttributes.GetItemData(m_num_curr_combo4edit);
					if(attr_def_prev != 0)
					{
						if(attr_def_prev != attr_def)
						{
							if(GetAttrType(attr_def) == GetAttrType( attr_def_prev))
							{
								m_attr_values.Get(attr_def_prev->type,curr_rel,value,value2);
							}
							else
							{
								value.Clear();
								m_ListAttributes.SetItemText(m_num_curr_combo4edit,2,_T(""));
							}
							m_attr_values.Del(attr_def_prev->type);

							m_ListAttributes.SetItemData(m_num_curr_combo4edit,(DWORD)attr_def);
							m_attr_types2log_rel.Get(attr_def->type,log_rels_arr,def);
							curr_rel = (CaplQLQuery::aplQLLogRelation)log_rels_arr.GetAt(def);
							m_attr_values.Add(attr_def->type,curr_rel,value,value2);
							m_ListAttributes.SetItemText(m_num_curr_combo4edit,0,attr_def->name4user);
							m_ListAttributes.SetItemText(m_num_curr_combo4edit,1,CaplQLQuery::LogOp2String(curr_rel));
							m_changed=true;
						}
					}
					else
					{
						m_ListAttributes.SetItemData(m_num_curr_combo4edit,(DWORD)attr_def);
						m_attr_types2log_rel.Get(attr_def->type,log_rels_arr,def);
						curr_rel = (CaplQLQuery::aplQLLogRelation)log_rels_arr.GetAt(def);
						m_attr_values.Add(attr_def->type,curr_rel,value,value2);
						m_ListAttributes.SetItemText(m_num_curr_combo4edit,0,attr_def->name4user);
						m_ListAttributes.SetItemText(m_num_curr_combo4edit,1,CaplQLQuery::LogOp2String(curr_rel));
						m_changed=true;
					}

				}
			}
		}
		else if(m_curr_combo4edit == TSC_SelectLogOp)
		{
			if(is_undo)
			{
				//   
			}
			else
			{
				attr_def = (SFindAttrDef*) m_ListAttributes.GetItemData(m_num_curr_combo4edit);
				if(attr_def!=0)
				{
					num_select = m_Cmbx4Edit.GetCurSel();
					curr_rel = (CaplQLQuery::aplQLLogRelation)m_Cmbx4Edit.GetItemData(num_select);
					m_attr_values.Set(attr_def->type,curr_rel);
					m_changed=true;

					//m_ListAttributes.SetItemText(m_num_curr_combo4edit,0,attr_def->name4user);
					m_ListAttributes.SetItemText(m_num_curr_combo4edit,1,CaplQLQuery::LogOp2String(curr_rel));

					if(curr_rel == CaplQLQuery::aplNOTEXIST || curr_rel == CaplQLQuery::aplNOLOGREL)
					{
						//      - 
						value.Clear();
						value2.Clear();
						m_attr_values.Set(attr_def->type,value,value2);
						m_ListAttributes.SetItemText(m_num_curr_combo4edit,2,_T(""));
					}
					else if( GetAttrType(attr_def) == apl_DATE)
					{
						//      ,    .   ,   
						PrintDateValues(curr_rel==CaplQLQuery::aplINDIAPAZON,str_val);
						m_ListAttributes.SetItemText(m_num_curr_combo4edit,2,str_val);
					}
				}
			}
		}
		else if(m_curr_combo4edit == TSC_SelectValue)
		{
			attr_def = (SFindAttrDef*) m_ListAttributes.GetItemData(m_num_curr_combo4edit);
			if(is_undo)
			{
				//   
				if(attr_def!=0)
				{
					if(GetAttrType(attr_def)==apl_DATE)
					{
						PrintDateValues(m_edit2date,str_val);
						m_ListAttributes.SetItemText(m_num_curr_combo4edit,2,str_val);
					}
				}
			}
			else
			{
				if(attr_def!=0)
				{
					
					// ,       
					switch(attr_def->type)
					{
					case TFO_Id:  // -  
					case TFO_Name:  // -   (   )
					case TFO_Descr:  // -  
					case TFO_Code:  // -      
					case TFO_Ver:  // -   
					case TFO_CodeVer1:  // -    1
					case TFO_CodeVer2:  // -    2
					case TFO_CodeIzd:	// -   
					case TFO_VerDescr:
// 					case TFO_RelPos:
// 					case TFO_RelPosId:
// 					case TFO_RelName:
// 					case TFO_RelDescr:
					case TFO_Part:
					case TFO_Label:
					case TFO_VerList:
					case TFO_VerLists:
					case TFO_VerLitera:
					case TFO_StrExt:
					case TFO_RefDocNum: //  -  
					case TFO_RefManifDescr:
					case TFO_ProcTaskId:
					case TFO_ProcTaskName:
					case TFO_DocMaillist:
						m_Edit4Edit.GetWindowText(str_val);
						str_val.TrimLeft();
						str_val.TrimRight();
						value.Set(str_val);
						break;

					case TFO_Type:  // -  
						//    ,     -    
						switch(m_mode)
						{
						case FindObject_ProductVer:
						case FindObject_Change:
							m_Cmbx4Edit.GetWindowText(str_val);
							value.Set(str_val);
							break;
						case FindObject_Document:
							//     
							break;
						case FindObject_BP:
							//     
							break;
						case FindObject_Project:
							m_Cmbx4Edit.GetWindowText(str_val);
							num_select = m_Cmbx4Edit.GetCurSel();
							curr_type_inst = (CaplInstance*)m_Cmbx4Edit.GetItemData(num_select);
							value.Set(curr_type_inst);
							break;
						case FindObject_Refusal:
							m_Cmbx4Edit.GetWindowText(str_val);
							num_select = m_Cmbx4Edit.GetCurSel();
							if(num_select!=-1)
							{
								curr_type_inst = (CaplInstance*)m_Cmbx4Edit.GetItemData(num_select);
								value.Set(curr_type_inst);
							}
							break;
						default:
							AfxMessageBox(APL_T("      \"\"!!!"));
							return retval;
						}
						break;
					case TFO_VerFormat:
					case TFO_Source:  // - 
					case TFO_Standart:  // - 
					case TFO_Groupe:
					case TFO_DocUrgency: //  - 
					case TFO_DocCode1:
					case TFO_DocCode2:
					case TFO_RefState: //  - 
					case TFO_ProcTaskExpired:	//  -  
					case TFO_ProcState:		//  - 
					case TFO_State:

						m_Cmbx4Edit.GetWindowText(str_val);
						if(str_val!=_T(""))
						{
							str1 = _T("");
							int indx_map = attr_def->m_list_selected_string.FindByIn(str_val);
							if(indx_map!=-1 && attr_def->m_list_selected_string.GetAt(indx_map)->val != _T("")) 
							{
								str1 = attr_def->m_list_selected_string.GetAt(indx_map)->val;
							}
						}
						if(str1==_T(""))value.Set(str_val);
						else value.Set(str1);
						break;

					case TFO_ProcTaskExpiredNDays:	//  -     3 
						m_Edit4Edit.GetWindowText(str_val);
						int_val = _atoi(str_val);
						value.Set(int_val);
						break;

					case TFO_RelContext:  // - 
					case TFO_ProjCustomer:
					case TFO_ProjKurator:
					case TFO_ProjExecutors:
					case TFO_ProjCoexecutors:
					case TFO_InAggr:
					case TFO_RefOrg:
					case TFO_RefSector:
					case TFO_RefCulprit:
					case TFO_RefStage:	
					case TFO_RefMainPDF:	 
					case TFO_RefMainItem:	 
					case TFO_RefSystem:	 
					case TFO_RefFailedItem:	 
					case TFO_RefFailedPart:	 
					case TFO_RefConditions:	 
					case TFO_RefDof:		 
					case TFO_RefFaultReason:
					case TFO_RefMethod:		 
					case TFO_RefConsequence:
					case TFO_RefManif:		 
					case TFO_ProcTaskPerformer:
					case TFO_ProcRefusalCulprit:
					case TFO_ProcOwner:
					case TFO_ProcTemplate:
						//    
						break;

					case TFO_Date1:  // - 
					case TFO_Date2:
					case TFO_Date3:
					case TFO_Date4:
						m_CtrlDate4Edit.SetParent(this);
						m_CtrlDate4Edit2.SetParent(this);
						UpdateData(TRUE);

						aplDate2String(m_Date4Edit,str_val);
						value.Set(str_val);
						aplDate2String(m_Date4Edit2,str_val);
						value2.Set(str_val);
						PrintDateValues(m_edit2date,str_val);
						m_ListAttributes.SetItemText(m_num_curr_combo4edit,2,str_val);
						need_print_table = false;
						break;

					case TFO_RefDocType: //  -  
						m_CmbxEdit4Edit.GetWindowText(str_val);
						value.Set(str_val);
						break;

					default:
						AfxMessageBox(APL_T("       !"));
						return retval;
					}

					m_changed=true;
					m_attr_values.Set(attr_def->type,value,value2);
					if(need_print_table)m_ListAttributes.SetItemText(m_num_curr_combo4edit,2,str_val);
				}
			}
		}

		m_curr_combo4edit = TSC_NonEdit;

	}

	return retval;
}

//     
void CFindQueryDlgEx::OnDblclkListAttributes(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	if(pNMLV->iItem == -1)
	{
		OnBnClickedBtnAttrAdd();
	}
	else if(pNMLV->iSubItem == 0)
	{
		BeginEditAttrDef();
	}
	else if(pNMLV->iSubItem == 1)
	{
		BeginEditAttrRel();
	}
	else if(pNMLV->iSubItem == 2)
	{
		BeginEditAttrVal();
	}

	// 	const MSG* msg;
	// 	CPoint mouseclick;
	// 	msg=GetCurrentMessage();
	// 	//mouseclick -   
	// 	mouseclick=msg->pt;
}


void CFindQueryDlgEx::OnBnClickedChkBrackets()
{
	// TODO: Add your control notification handler code here
	m_changed=true;
	UpdateData(TRUE);
}

void CFindQueryDlgEx::OnBnClickedChkSubstring()
{
	// TODO: Add your control notification handler code here
	m_changed=true;
	UpdateData(TRUE);

	//     
	//   ,   
	//CheckSubStringCtrl();
}

//     
//   ,   
// void CFindQueryDlgEx::CheckSubStringCtrl()
// {
// 	CRect rect_ab,rect_ch1,rect_ch2,rect_attrs;
// 	int delta;
// 
// 	m_CtrlStaticAttrs.GetWindowRect(rect_ab);
// 	m_ListAttributes.GetWindowRect(rect_attrs);
// 	m_CtrlChkSubstring.GetWindowRect(rect_ch1);
// 	m_CtrlChkBrackets.GetWindowRect(rect_ch2);
// 	delta = rect_ch2.bottom - rect_ch1.bottom;
// 	
// 	ScreenToClient(&rect_ab);
// 	ScreenToClient(&rect_attrs);
// 
// 	if(m_IsSubstring == TRUE)
// 	{
// 		rect_ab.bottom+=delta;
// 		rect_attrs.top+=delta;
// 
// 		m_CtrlChkBrackets.ShowWindow(SW_SHOWNORMAL);
// 	}
// 	else
// 	{
// 		rect_ab.bottom-=delta;
// 		rect_attrs.top-=delta;
// 		m_CtrlChkBrackets.ShowWindow(SW_HIDE);
// 	}
// 	m_CtrlStaticAttrs.ShowWindow(SW_HIDE);
// 	m_CtrlStaticAttrs.MoveWindow(rect_ab,TRUE);
// 	m_CtrlStaticAttrs.ShowWindow(SW_SHOWNORMAL);
// 	m_ListAttributes.MoveWindow(rect_attrs,TRUE);
// 
// 	AddAnchor(IDC_LIST_ATTRIBUTES, TOP_LEFT, MIDDLE_RIGHT);
// }

void CFindQueryDlgEx::OnBnClickedChkMakeNewWindow()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if(m_IsNewWindow)
	{
		m_IsMakeTableResult = FALSE;
		UpdateData(FALSE);
	}
}

void CFindQueryDlgEx::OnBnClickedChkMakeTableResult()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if(m_IsMakeTableResult)
	{
		m_IsNewWindow = FALSE;
		UpdateData(FALSE);
	}
}

int ox = 0;

void CFindQueryDlgEx::OnSize(UINT nType, int cx, int cy)
{
	CResizableDialog::OnSize(nType, cx, cy);
	CRect rect;
/*  DIV:      . ,    ; AddAnchor   
	   ,   -   
	if(IsWindow(m_CtrlMatchCase.m_hWnd))
	{
		m_CtrlMatchCase.GetWindowRect(&rect);
		ScreenToClient(&rect);
		rect.right+=cx - ox;
		m_CtrlMatchCase.MoveWindow(&rect);
	}
	if(IsWindow(m_CtrlChkSubstring.m_hWnd))
	{
		m_CtrlChkSubstring.GetWindowRect(&rect);
		ScreenToClient(&rect);
		m_CtrlChkSubstring.SetWindowPos(&m_CtrlChkSubstring,rect.top,rect.left,rect.Width(),rect.Height(),SWP_SHOWWINDOW   );
	}
*/
	//     
	//   ,   
// 	if(IsWindow(m_CtrlChkBrackets.m_hWnd))
// 	{
// 		m_CtrlChkBrackets.GetWindowRect(&rect);
// 		ScreenToClient(&rect);
// 		m_CtrlChkBrackets.SetWindowPos(&m_CtrlChkBrackets,rect.top,rect.left,rect.Width(),rect.Height(),SWP_SHOWWINDOW   );
// 	}
	ox=cx;

	// TODO: Add your message handler code here
}


int CNonSortedStrStrArray::Add(LPCTSTR str, LPCTSTR val)
{
	items.Add( new CaplStrStrMapItem(str,val));
	return items.Size;
}
//********************************************************
int  CNonSortedStrStrArray::FindByIn(LPCTSTR str) const
{
	for(int i=0;i<items.Size;i++){
		if(items[i]->str==str)return i;
	}
	return -1;
}

int  CNonSortedStrStrArray::FindByOut(LPCTSTR val) const
{
	for(int i=0;i<items.Size;i++){
		if(items[i]->val==val)return i;
	}
	return -1;
}

CNonSortedStrStrArray::CaplStrStrMapItem* CNonSortedStrStrArray::GetAt(int index) const
{
	return items[index];
}

void CFindQueryDlgEx::OnBnClickedRadioAndOr()
{
	// TODO: Add your control notification handler code here
	if(m_page_num==adj_appr)
	{
		m_is_or_approval = !m_is_or_approval;
		m_changed=true;
	}
	else if(m_page_num==adj_char)
	{
		m_is_or_char = !m_is_or_char;
		m_changed=true;
	}
	else if(m_page_num==adj_doc)
	{
		m_is_or_doc = !m_is_or_doc;
		m_changed=true;
	}
	else if(m_page_num==adj_res)
	{
		m_is_or_res = !m_is_or_res;
		m_changed=true;
	}
	else if(m_page_num==adj_blob)
	{
		if(!m_api->m_data.CanFindInBLOB()){return;}
		m_is_or_blob = !m_is_or_blob;
		m_changed=true;
	}
	else if(m_page_num==adj_class)
	{
		m_changed=true;
		m_is_or_class = !m_is_or_class;
	}

}

void CFindQueryDlgEx::SetAdjAndOr(bool is_or)
{
	m_CtrlRadioOr.SetCheck(is_or?TRUE:FALSE);
	m_CtrlRadioAnd.SetCheck(is_or?FALSE:TRUE);

}

void CFindQueryDlgEx::CorrectFieldDescr1(int size, bool is_or)
{
	if(m_fields!=_T("") && size > 0)
	{
		m_fields+=_T(" AND \n");
		m_descrtiption+= APL_T("  ");
	}
	if(is_or && size > 1)
	{
		m_fields+=_T("\t( ");
		m_descrtiption+= APL_T(" ( ");
	}
}

void CFindQueryDlgEx::CorrectFieldDescr2(int i, bool is_or)
{
	if(i > 0)
	{
		if(is_or)
		{
			m_descrtiption+= APL_T("  ");
			m_fields+=_T(" OR ");
		}
		else
		{
			m_descrtiption+= APL_T("  ");
			m_fields+=_T(" AND ");
		}
	}
}

void CFindQueryDlgEx::CorrectFieldDescr3(int size, bool is_or)
{
	if(is_or && size > 1)
	{
		m_fields+=_T(" ) ");
		m_descrtiption+= APL_T(" ) ");
	}
}

void CFindQueryDlgEx::OnBnClickedChkMatchCase()
{
	if(m_IsMatchCase != m_CtrlMatchCase.GetCheck())
		m_changed=true;
}
