// FindQueryNiiao.cpp : implementation file
//

#include "stdafx.h"
#include "apl_api.h"
#include "resource.h"
#include "FindAdjustCharactDlg.h"
#include "FindQueryNiiao.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFindQueryNiiao dialog


CFindQueryNiiao::CFindQueryNiiao(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CFindQueryNiiao::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFindQueryNiiao)
	m_IsMakeTableResult = TRUE;
	m_StateSaveQuery = FALSE;
	m_StateFindType = -1;
	//}}AFX_DATA_INIT
	m_QL_query=_T("");
	m_mode=FindObjectNIAO_ProductVer;
	m_mode_text=_T("");
	m_cur_ext_num=0;
	m_extents=_T("");
	m_fields=_T("");
	m_is_load_bmp=false;
//	m_vis_mode=0;
	m_is_adjustment=false;
	m_can_make_table=true;
	m_can_save=true;
	m_read_only=false;
	
	m_StringSource=_T("");
	m_StringType=_T("");
	m_dbuf=0;
	
	m_changed=false;

	m_active_attr=0;
	m_active_list_char=0;

	m_page_num=FindObjectNIAO_ProductVer;
	m_old_page_num=FindObjectNIAO_ProductVer;

	m_num_ext_pdf=0;
	m_num_ext_pi=0;
	m_num_ext_bpi=0;	
	
	m_api=0;
	m_instance=0;
	
	m_adj_add_icon=0;
	m_adj_del_icon=0;
	m_adj_edit_icon=0;
	
}

CFindQueryNiiao::~CFindQueryNiiao()
{
	::DestroyIcon(m_adj_add_icon);
	::DestroyIcon(m_adj_del_icon);
	::DestroyIcon(m_adj_edit_icon);
	if(m_dbuf!=0)delete m_dbuf;
}

void CFindQueryNiiao::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFindQueryNiiao)
	DDX_Control(pDX, ID_EXECUTE_FIND, m_BtnFind);
	DDX_Control(pDX, IDC_EDIT_NAME_QUERY, m_edt_name_query);
	DDX_Control(pDX, IDC_CHK_SAVE_QUERY, m_ChkSaveQuery);
	DDX_Control(pDX, IDC_SELECT_FIND_TYPE, m_SelectFindType);
	DDX_Control(pDX, IDC_COMBO_STATE_ID, m_CmbxStId);
	DDX_Control(pDX, IDC_COMBO_STATE_NAME, m_CmbxStName);
	DDX_Control(pDX, IDC_COMBO_STATE_DESCR, m_CmbxStDescr);
	DDX_Control(pDX, IDC_COMBO_STATE_TYPE, m_CmbxStType);
	DDX_Control(pDX, IDC_COMBO_STATE_CODE, m_CmbxStCode);
	DDX_Control(pDX, IDC_COMBO_STATE_SOURCE, m_CmbxStSource);
	DDX_Control(pDX, IDC_COMBO_STATE_VER, m_CmbxStVer);
	DDX_Control(pDX, IDC_EDIT_ID, m_EditId);
	DDX_Control(pDX, IDC_EDIT_NAME, m_EditName);
	DDX_Control(pDX, IDC_EDIT_DESCR, m_EditDescr);
	DDX_Control(pDX, IDC_COMBO_TYPE, m_EditType);
	DDX_Control(pDX, IDC_EDIT_CODE, m_EditCode);
	DDX_Control(pDX, IDC_COMBO_SOURCE, m_EditSource);
	DDX_Control(pDX, IDC_EDIT_VER, m_EditVer);
//	DDX_Control(pDX, IDC_CHK_FIND_VERSION, m_ctrl_find_version);
	DDX_Control(pDX, ID_ADJUST_EDIT, m_adj_edit);
	DDX_Control(pDX, ID_ADJUST_DEL, m_adj_del);
	DDX_Control(pDX, ID_ADJUST_ADD, m_adj_add);
	DDX_Control(pDX, IDC_LIST_ADJUST, m_ListAdjust);
	DDX_Control(pDX, IDC_TAB_ATTR, m_TabAttr);
	DDX_Control(pDX, IDC_CHK_ST_ID, m_Chk_StId);
	DDX_Control(pDX, IDC_CHK_ST_NAME, m_Chk_StName);
	DDX_Control(pDX, IDC_CHK_ST_DESCR, m_Chk_StDescr);
	DDX_Control(pDX, IDC_CHK_ST_TYPE, m_Chk_StType);
	DDX_Control(pDX, IDC_CHK_ST_CODE, m_Chk_StCode);
	DDX_Control(pDX, IDC_CHK_ST_SOURCE, m_Chk_StSource);
	DDX_Control(pDX, IDC_CHK_ST_VER, m_Chk_StVer);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	DDX_Control(pDX, ID_SHOW_STEPQL, m_BtnShowStepQl);
	DDX_Control(pDX, IDC_CHK_MAKE_TABLE_RESULT, m_CtrlMakeTableResult);
	DDX_Check(pDX, IDC_CHK_MAKE_TABLE_RESULT, m_IsMakeTableResult);
	DDX_Text(pDX, IDC_EDIT_NAME_QUERY, m_StringNameQuery);
	DDX_Check(pDX, IDC_CHK_SAVE_QUERY, m_StateSaveQuery);
	DDX_CBIndex(pDX, IDC_SELECT_FIND_TYPE, m_StateFindType);	
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFindQueryNiiao, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CFindQueryNiiao)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_ATTR, OnSelchangeTabAttr)
	ON_CBN_SELCHANGE(IDC_SELECT_FIND_TYPE, OnSelchangeSelectFindType)
	ON_BN_CLICKED(ID_ADJUST_ADD, OnAdjustAdd)
	ON_BN_CLICKED(ID_ADJUST_DEL, OnAdjustDel)
	ON_BN_CLICKED(ID_ADJUST_EDIT, OnAdjustEdit)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_ADJUST, OnDblclkListAdjust)
//	ON_BN_CLICKED(IDC_CHK_FIND_VERSION, OnChkFindVersion)
	ON_BN_CLICKED(ID_EXECUTE_FIND, OnExecuteFind)
	ON_NOTIFY(NM_RCLICK, IDC_LIST_ADJUST, OnRclickListAdjust)
	ON_BN_CLICKED(ID_SHOW_STEPQL, OnShowStepql)
	ON_CBN_SELCHANGE(IDC_COMBO_STATE_ID, OnSelchangeComboState)
	ON_BN_CLICKED(IDC_CHK_SAVE_QUERY, OnChkSaveQuery)
	ON_EN_CHANGE(IDC_EDIT_ID, OnChangeEdit)
	ON_CBN_SELCHANGE(IDC_COMBO_STATE_NAME, OnSelchangeComboState)
	ON_CBN_SELCHANGE(IDC_COMBO_STATE_DESCR, OnSelchangeComboState)
	ON_CBN_SELCHANGE(IDC_COMBO_STATE_CODE, OnSelchangeComboState)
	ON_CBN_SELCHANGE(IDC_COMBO_STATE_SOURCE, OnSelchangeComboState)
	ON_CBN_SELCHANGE(IDC_COMBO_STATE_TYPE, OnSelchangeComboState)
	ON_CBN_SELCHANGE(IDC_COMBO_STATE_VER, OnSelchangeComboState)
	ON_BN_CLICKED(IDC_CHK_ST_CODE, OnSelchangeComboState)
	ON_BN_CLICKED(IDC_CHK_ST_DESCR, OnSelchangeComboState)
	ON_BN_CLICKED(IDC_CHK_ST_ID, OnSelchangeComboState)
	ON_BN_CLICKED(IDC_CHK_ST_NAME, OnSelchangeComboState)
	ON_BN_CLICKED(IDC_CHK_ST_SOURCE, OnSelchangeComboState)
	ON_BN_CLICKED(IDC_CHK_ST_TYPE, OnSelchangeComboState)
	ON_BN_CLICKED(IDC_CHK_ST_VER, OnSelchangeComboState)
	ON_EN_CHANGE(IDC_EDIT_NAME, OnChangeEdit)
	ON_EN_CHANGE(IDC_EDIT_DESCR, OnChangeEdit)
	ON_EN_CHANGE(IDC_EDIT_CODE, OnChangeEdit)
	ON_EN_CHANGE(IDC_EDIT_VER, OnChangeEdit)
	ON_CBN_SELCHANGE(IDC_COMBO_TYPE, OnChangeEdit)
	ON_CBN_SELCHANGE(IDC_COMBO_SOURCE, OnChangeEdit)
	//}}AFX_MSG_MAP
	//ON_NOTIFY_EX(TTN_NEEDTEXT, 0, OnToolTipShow)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFindQueryNiiao message handlers

BOOL CFindQueryNiiao::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	EnableToolTips(TRUE);
	UpdateData(FALSE);
	
	m_BtnFind.SetIcon(GetAplStdIco16(APLSTDICO_PLAY));
	m_BtnFind.SetFlat(FALSE);
	m_BtnCancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_BtnCancel.SetFlat(FALSE);
	m_BtnShowStepQl.SetIcon(GetAplStdIco16(APLSTDICO_STQL));
	m_BtnShowStepQl.SetFlat(FALSE);
	
	int i;

	COLORMAP  cm;
	cm.from=RGB(192,192,192);
	cm.to=GetSysColor(COLOR_BTNFACE);

	if(!m_is_load_bmp)
	{
		if(aplGetBitPerPixel(this)>8)
			m_name_bmp.LoadMappedBitmap(IDB_FIND_NAME,0,&cm,1);
		else 
			m_name_bmp.LoadMappedBitmap(IDB_FIND_NAME_16,0,&cm,1);
		
		imagelist_tab.Create(IDR_ICONS,16,2,cm.from);
		imagelist_but.Create(IDR_MENU_ICONS,20,2,cm.from);
		m_is_load_bmp=true;
	}
//	HBITMAP hBmpOld=m_st_header.SetBitmap(HBITMAP(m_name_bmp));
//	::DeleteObject(hBmpOld);
//	m_TabAttr.SetImageList(&imagelist_tab);

	m_adj_add_icon=imagelist_but.ExtractIcon(0);
	m_adj_del_icon=imagelist_but.ExtractIcon(1);
	m_adj_edit_icon=imagelist_but.ExtractIcon(7);
	
	m_adj_add.SetIcon( m_adj_add_icon);
	m_adj_del.SetIcon( m_adj_del_icon);
	m_adj_edit.SetIcon(m_adj_edit_icon);

	// TODO: Add extra initialization here
	m_EditSource.ResetContent();
	for(i=0;i<m_api->m_prd_mgr.m_list_mob_types.GetSize();i++){
		m_EditSource.AddString(m_api->m_prd_mgr.m_list_mob_types.GetAt(i));
	}

	aplExtent ext;
	CString buf;

	ext.Clear();
	//m_list_action_types.Clear();
	//apidata.GetEntityExtent(m_api->m_bp_mgr.e_bp_type,m_list_action_types);

	//  
	i=0;
	i=m_SelectFindType.InsertString(i, APL_T(" "));
	m_SelectFindType.SetItemData(i,(DWORD) FindObjectNIAO_ProductVer);
	i++;
	i=m_SelectFindType.InsertString(i, APL_T(" "));
	m_SelectFindType.SetItemData(i,(DWORD) FindObjectNIAO_ProductInst);
	i++;
	i=m_SelectFindType.InsertString(i, APL_T(" -"));
	m_SelectFindType.SetItemData(i,(DWORD) FindObjectNIAO_BPInst);
	i++;

	//    
	m_CmbxStId.AddString( APL_T(""));
	m_CmbxStId.AddString( APL_T(""));
	m_CmbxStId.SetCurSel(1);
	m_CmbxStName.AddString( APL_T(""));
	m_CmbxStName.AddString( APL_T(""));
	m_CmbxStName.SetCurSel(1);
	m_CmbxStDescr.AddString( APL_T(""));
	m_CmbxStDescr.AddString( APL_T(""));
	m_CmbxStDescr.SetCurSel(1);
	m_CmbxStType.AddString( APL_T(""));
	m_CmbxStType.SetCurSel(0);
	m_CmbxStCode.AddString( APL_T(""));
	m_CmbxStCode.AddString( APL_T(""));
	m_CmbxStCode.SetCurSel(1);
	m_CmbxStSource.AddString( APL_T(""));
	m_CmbxStSource.SetCurSel(0);
	m_CmbxStVer.AddString( APL_T(""));
	m_CmbxStVer.AddString( APL_T(""));
	m_CmbxStVer.SetCurSel(1);
	
	//    
	HWND hWnd = ::GetDlgItem(m_hWnd, IDC_LIST_ADJUST);
	ListView_SetExtendedListViewStyle(hWnd, 
		ListView_GetExtendedListViewStyle(hWnd) | LVS_EX_FULLROWSELECT /*| LVS_EX_GRIDLINES */);

	//    
	m_TabAttr.InsertItem(0, APL_T(" "));
	m_TabAttr.InsertItem(1, APL_T(" "));
	m_TabAttr.InsertItem(2, APL_T(" -"));

	m_list_char_pdf.Clear();
	m_list_char_pi.Clear();
	m_list_char_bpi.Clear();
	
	LoadDataFromBuf();
	if(m_mode_slave){
		m_edt_name_query.EnableWindow(false);
	}

	m_active_attr=0;
	m_active_list_char=0;
	
	m_page_num=FindObjectNIAO_ProductVer;
	m_old_page_num=FindObjectNIAO_ProductVer;
	
	
	// -   
	m_SelectFindType.SetCurSel(m_mode);
	m_TabAttr.SetCurSel((int)m_page_num);
	
	m_CtrlMakeTableResult.EnableWindow(m_can_make_table);
	m_ChkSaveQuery.EnableWindow(m_can_save);

	
	//OnSelchangeSelectFindType();

	DrawTabPage();
	FillTabAdjust();
	
	OnSelchangeSelectFindType();
	SelchangeTabAttr();
	OnChkSaveQuery();
	
	if(m_read_only){
		m_edt_name_query.EnableWindow(FALSE);
		m_SelectFindType.EnableWindow(FALSE);
		m_EditId.EnableWindow(FALSE);m_Chk_StId.EnableWindow(FALSE);m_CmbxStId.EnableWindow(FALSE);
		m_EditName.EnableWindow(FALSE);m_Chk_StName.EnableWindow(FALSE);m_CmbxStName.EnableWindow(FALSE);
		m_EditDescr.EnableWindow(FALSE);m_Chk_StDescr.EnableWindow(FALSE);m_CmbxStDescr.EnableWindow(FALSE);
		m_EditType.EnableWindow(FALSE);m_Chk_StType.EnableWindow(FALSE);m_CmbxStType.EnableWindow(FALSE);
		m_EditCode.EnableWindow(FALSE);m_Chk_StCode.EnableWindow(FALSE);m_CmbxStCode.EnableWindow(FALSE);
		m_EditSource.EnableWindow(FALSE);m_Chk_StSource.EnableWindow(FALSE);m_CmbxStSource.EnableWindow(FALSE);
		m_EditVer.EnableWindow(FALSE);m_Chk_StVer.EnableWindow(FALSE);m_CmbxStVer.EnableWindow(FALSE);
		m_adj_add.EnableWindow(FALSE);m_adj_del.EnableWindow(FALSE);
		m_CtrlMakeTableResult.EnableWindow(FALSE);

	}
	m_changed=false;
				
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
// :    CaplTranslateDialog
/*BOOL CFindQueryNiiao::OnToolTipShow( UINT id, NMHDR * pNMHDR, LRESULT * pResult )
{
	TOOLTIPTEXT *pTTT = (TOOLTIPTEXT *)pNMHDR;
	UINT nID = pNMHDR->idFrom;
	CString buf;
	
	if (pTTT->uFlags & TTF_IDISHWND){
		nID = ::GetDlgCtrlID((HWND)nID);
		//CString tooltip_text;
		//tooltip_text.LoadString(nID);
		//		if(nID==IDC_CHK_NAME){m_ChkName.GetWindowText(buf);tooltip_text+=buf;}
		//pTTT->lpszText = _tcsdup(tooltip_text);
		pTTT->lpszText = (TCHAR*)nID;
		pTTT->hinst = AfxGetResourceHandle();
		return(true);
	}
	return false;
}*/



//     
void CFindQueryNiiao::OnSelchangeComboState() 
{
	// TODO: Add your control notification handler code here
	if(m_active_attr==0)return;
	m_changed=true;
	if(m_Chk_StId.GetCheck()==0){
		m_active_attr->m_state_id=0;
	}else{
		m_active_attr->m_state_id=m_CmbxStId.GetCurSel()+1;
	}
	if(m_Chk_StName.GetCheck()==0){
		m_active_attr->m_state_name=0;
	}else{
		m_active_attr->m_state_name=m_CmbxStName.GetCurSel()+1;
	}
	if(m_Chk_StDescr.GetCheck()==0){
		m_active_attr->m_state_descr=0;
	}else{
		m_active_attr->m_state_descr=m_CmbxStDescr.GetCurSel()+1;
	}
	if(m_Chk_StType.GetCheck()==0){
		m_active_attr->m_state_type=0;
	}else{
		m_active_attr->m_state_type=m_CmbxStType.GetCurSel()+1;
	}
	if(m_Chk_StCode.GetCheck()==0){
		m_active_attr->m_state_code=0;
	}else{
		m_active_attr->m_state_code=m_CmbxStCode.GetCurSel()+1;
	}
	if(m_Chk_StSource.GetCheck()==0){
		m_active_attr->m_state_source=0;
	}else{
		m_active_attr->m_state_source=m_CmbxStSource.GetCurSel()+1;
	}
	if(m_Chk_StVer.GetCheck()==0){
		m_active_attr->m_state_ver=0;
	}else{
		m_active_attr->m_state_ver=m_CmbxStVer.GetCurSel()+1;
	}
	SetEditComboState();
}

void CFindQueryNiiao::SetEditComboState()
{
	if(m_active_attr==0)return;
	m_changed=true;
	m_EditId.EnableWindow(m_active_attr->m_state_id!=0);
	m_CmbxStId.EnableWindow(m_active_attr->m_state_id!=0);
	m_Chk_StId.SetCheck(m_active_attr->m_state_id!=0);
	
	m_EditName.EnableWindow(m_active_attr->m_state_name!=0);
	m_CmbxStName.EnableWindow(m_active_attr->m_state_name!=0);
	m_Chk_StName.SetCheck(m_active_attr->m_state_name!=0);
	
	m_EditDescr.EnableWindow(m_active_attr->m_state_descr!=0);
	m_CmbxStDescr.EnableWindow(m_active_attr->m_state_descr!=0);
	m_Chk_StDescr.SetCheck(m_active_attr->m_state_descr!=0);
	
	m_EditType.EnableWindow(m_active_attr->m_state_type!=0);
	m_CmbxStType.EnableWindow(m_active_attr->m_state_type!=0);
	m_Chk_StType.SetCheck(m_active_attr->m_state_type!=0);
	
	m_EditCode.EnableWindow(m_active_attr->m_state_code!=0);
	m_CmbxStCode.EnableWindow(m_active_attr->m_state_code!=0);
	m_Chk_StCode.SetCheck(m_active_attr->m_state_code!=0);
	
	m_EditSource.EnableWindow(m_active_attr->m_state_source!=0);
	m_CmbxStSource.EnableWindow(m_active_attr->m_state_source!=0);
	m_Chk_StSource.SetCheck(m_active_attr->m_state_source!=0);
	
	m_EditVer.EnableWindow(m_active_attr->m_state_ver!=0);
	m_CmbxStVer.EnableWindow(m_active_attr->m_state_ver!=0);
	m_Chk_StVer.SetCheck(m_active_attr->m_state_ver!=0);
	
}

void CFindQueryNiiao::OnChkSaveQuery() 
{
	// TODO: Add your control notification handler code here
	//m_edt_name_query.EnableWindow(m_ChkSaveQuery.GetCheck());
	//m_edt_descr_query.EnableWindow(m_ChkSaveQuery.GetCheck());
}
/*
void CFindQueryNiiao::OnChkFindVersion() 
{
	// TODO: Add your control notification handler code here
	m_changed=true;
}
*/
//    -      
void CFindQueryNiiao::OnSelchangeSelectFindType() 
{

	// TODO: Add your control notification handler code here
	m_changed=true;
	int i;
	i=m_SelectFindType.GetCurSel();
	m_mode=(TypeFindObjectNIIAO)m_SelectFindType.GetItemData(i);
//	m_CtrlMakeTableResult.EnableWindow(true);
	switch(m_mode)
	{
	case FindObjectNIAO_ProductVer: // Product version
		m_mode_text= APL_T(" ");
		break;
	case FindObjectNIAO_ProductInst: // Product Inst
		m_mode_text= APL_T(" ");
		break;
	case FindObjectNIAO_BPInst: // Action
		m_mode_text= APL_T("  ");
		break;
	}
}

//    
void CFindQueryNiiao::OnSelchangeTabAttr(NMHDR* pNMHDR, LRESULT* pResult) 
{
	*pResult = 0;
	if(!SelchangeTabAttr()){
		m_page_num=m_old_page_num;
		m_TabAttr.SetCurSel((int)m_page_num);
	}
	m_old_page_num=m_page_num;
}

bool CFindQueryNiiao::SelchangeTabAttr() 
{

	// TODO: Add your control notification handler code here
	int pos=m_TabAttr.GetCurSel();
	int i,k;
	CString str_par;
	m_page_num=(TypeFindObjectNIIAO)pos;
	SParam* old_active_attr=m_active_attr;

	if(m_active_attr!=0){
		//     
		if(m_active_attr->m_state_id!=0){
			m_EditId.GetWindowText(str_par);
			if(str_par==_T("")){
				AfxMessageBox( APL_T("   !"));
				return false;
			}
			m_active_attr->m_id=str_par;
		}
		if(m_active_attr->m_state_name!=0){
			m_EditName.GetWindowText(str_par);
			if(str_par==_T("")){
				if(m_mode==FindObjectNIAO_ProductInst){
					AfxMessageBox( APL_T("    !"));
				}else{
					AfxMessageBox( APL_T("   !"));
				}
				return false;
			}
			m_active_attr->m_name=str_par;
		}
		if(m_active_attr->m_state_descr!=0){
			m_EditDescr.GetWindowText(str_par);
			if(str_par==_T("")){
				AfxMessageBox( APL_T("   !"));
				return false;
			}
			m_active_attr->m_descr=str_par;
		}
		if(m_active_attr->m_state_type!=0){
			m_EditType.GetWindowText(str_par);
			k=m_EditType.GetCurSel();
			if(m_old_page_num==FindObjectNIAO_ProductVer){
				//   product-  
				m_active_attr->m_type=str_par;
			}
		}
		if(m_active_attr->m_state_code!=0){
			m_EditCode.GetWindowText(str_par);
			if(str_par==_T("")){
				AfxMessageBox( APL_T("   !"));
				return false;
			}
			m_active_attr->m_code=str_par;
		}
		if(m_active_attr->m_state_source!=0){
			m_EditSource.GetWindowText(str_par);
			
			pos=m_EditSource.GetCurSel();
			m_active_attr->m_source=pos;
			
		}
		if(m_active_attr->m_state_ver!=0){
			m_EditVer.GetWindowText(str_par);
			if(str_par==_T("")){
				AfxMessageBox( APL_T("    !"));
				return false;
			}
			m_active_attr->m_ver=str_par;
		}
	}

//	m_ctrl_find_version.ShowWindow(SW_HIDE);
	switch(m_page_num)
	{
	case FindObjectNIAO_ProductVer: // Product version
		m_active_attr=&m_attr_pdf;
		SetStateName( APL_T(""), APL_T(""), APL_T(""),
			 APL_T(""), APL_T("  "),
			 APL_T(""), APL_T(""));
		break;
	case FindObjectNIAO_ProductInst: // Product Inst
		m_active_attr=&m_attr_pi;
		SetStateName( APL_T(""), APL_T(" "), APL_T(""),_T(""),_T(""),_T(""),_T(""));
		break;
	case FindObjectNIAO_BPInst: // Action
		m_active_attr=&m_attr_bpi;
		SetStateName( APL_T(""), APL_T(""), APL_T(""),
			_T(""),_T(""),_T(""),_T(""));
		//m_ctrl_find_version.ShowWindow(SW_NORMAL);
		//m_ctrl_find_version.SetWindowText(APL_T("   ."));
		break;
	}

	OnSelchangeComboState();
	FillTabAdjust();
	
	//       
	if(m_active_attr->m_state_id!=0){
		m_EditId.SetWindowText(m_active_attr->m_id);
	}else{
		m_EditId.SetWindowText(_T(""));
	}
	if(m_active_attr->m_state_name!=0){
		m_EditName.SetWindowText(m_active_attr->m_name);
	}else{
		m_EditName.SetWindowText(_T(""));
	}
	if(m_active_attr->m_state_descr!=0){
		m_EditDescr.SetWindowText(m_active_attr->m_descr);
	}else{
		m_EditDescr.SetWindowText(_T(""));
	}
	
	//   ;   
	pos=0;
	if(m_page_num==FindObjectNIAO_ProductVer){
		m_EditType.ResetContent();
		for(i=0;i<m_api->m_prd_mgr.m_list_pdf_types.GetSize();i++){
			str_par=m_api->m_prd_mgr.m_list_pdf_types.GetAt(i);
			m_EditType.AddString(str_par);
			if(m_active_attr->m_state_type!=0){
				if(str_par==m_active_attr->m_type){
					pos=i;
				}
			}
		}
	}
	m_EditType.SetCurSel(pos);

	if(m_active_attr->m_state_code!=0){
		m_EditCode.SetWindowText(m_active_attr->m_code);
	}else{
		m_EditCode.SetWindowText(_T(""));
	}

	//   ;   
	pos=m_active_attr->m_source;
	m_EditSource.SetCurSel(pos);

	if(m_active_attr->m_state_ver!=0){
		m_EditVer.SetWindowText(m_active_attr->m_ver);
	}else{
		m_EditVer.SetWindowText(_T(""));
	}

	return true;
}

//      "" - " "
void CFindQueryNiiao::SetStateName(CString id,CString name,CString descr,CString type,CString code,CString source,CString ver)
{
	
	UpdateData(TRUE);
	if(m_active_attr==0)return;
	if(id==_T("")){
		m_CmbxStId.SetCurSel(1);
		m_Chk_StId.SetWindowText( APL_T(""));
		m_active_attr->m_state_id=0;
	}else{
		if(m_active_attr->m_state_id!=0)m_CmbxStId.SetCurSel(m_active_attr->m_state_id-1);
		m_Chk_StId.SetWindowText(id);
	}
	m_Chk_StId.EnableWindow(id!=_T(""));

	if(name==_T("")){
		m_CmbxStName.SetCurSel(1);
		m_Chk_StName.SetWindowText( APL_T(""));
		m_active_attr->m_state_name=0;
	}else{
		if(m_active_attr->m_state_name!=0)m_CmbxStName.SetCurSel(m_active_attr->m_state_name-1);
		m_Chk_StName.SetWindowText(name);
	}
	m_Chk_StName.EnableWindow(name!=_T(""));

	if(descr==_T("")){
		m_CmbxStDescr.SetCurSel(1);
		m_Chk_StDescr.SetWindowText( APL_T(""));
		m_active_attr->m_state_descr=0;
	}else{
		if(m_active_attr->m_state_descr!=0)m_CmbxStDescr.SetCurSel(m_active_attr->m_state_descr-1);
		m_Chk_StDescr.SetWindowText(descr);
	}
	m_Chk_StDescr.EnableWindow(descr!=_T(""));
	
	if(type==_T("")){
		m_CmbxStType.SetCurSel(0);
		m_Chk_StType.SetWindowText( APL_T(""));
		m_active_attr->m_state_type=0;
	}else{
		if(m_active_attr->m_state_type!=0)m_CmbxStType.SetCurSel(m_active_attr->m_state_type-1);
		m_Chk_StType.SetWindowText(type);
	}
	m_Chk_StType.EnableWindow (type!=_T("") );
	
	if(code==_T("")){
		m_CmbxStCode.SetCurSel(1);
		m_Chk_StCode.SetWindowText( APL_T(""));
		m_active_attr->m_state_code=0;
	}else{
		if(m_active_attr->m_state_code!=0)m_CmbxStCode.SetCurSel(m_active_attr->m_state_code-1);
		m_Chk_StCode.SetWindowText(code);
	}
	m_Chk_StCode.EnableWindow(code!=_T(""));
	
	if(source==_T("")){
		m_CmbxStSource.SetCurSel(0);
		m_Chk_StSource.SetWindowText( APL_T(""));
		m_active_attr->m_state_source=0;
	}else{
		if(m_active_attr->m_state_source!=0)m_CmbxStSource.SetCurSel(m_active_attr->m_state_source-1);
		m_Chk_StSource.SetWindowText(source);
	}
	m_Chk_StSource.EnableWindow(source !=_T(""));
	
	if(ver==_T("")){
		m_CmbxStVer.SetCurSel(1);
		m_Chk_StVer.SetWindowText( APL_T(""));
		m_active_attr->m_state_ver=0;
	}else{
		if(m_active_attr->m_state_ver!=0)m_CmbxStVer.SetCurSel(m_active_attr->m_state_ver-1);
		m_Chk_StVer.SetWindowText(ver);
	}
	m_Chk_StVer.EnableWindow(ver!=_T(""));
	
	SetEditComboState();

}


/////////////////////////////////////////////////////////////////////////////
// CFindQueryNiiao  -  


//     -      
void CFindQueryNiiao::DrawTabPage(){

	RECT rect;
	int i;
	//  
	int nColumnCount = m_ListAdjust.GetHeaderCtrl()->GetItemCount();
	for (i=0;i < nColumnCount;i++){
		m_ListAdjust.DeleteColumn(0);
	}
	//        
	m_ListAdjust.GetWindowRect(&rect);
	int width=rect.right-rect.left;
	m_adj_add.EnableWindow(TRUE);
	m_adj_del.EnableWindow(TRUE);
	m_adj_edit.EnableWindow(TRUE);

	// 
	m_ListAdjust.InsertColumn(0, APL_T(""),LVCFMT_LEFT,width*15/100);
	m_ListAdjust.InsertColumn(1, APL_T(""),LVCFMT_LEFT,width*30/100);
	m_ListAdjust.InsertColumn(2, APL_T(""),LVCFMT_LEFT,width*20/100);
	m_ListAdjust.InsertColumn(3, APL_T(""),LVCFMT_LEFT,width*15/100);
	m_ListAdjust.InsertColumn(4, APL_T(""),LVCFMT_LEFT,width*19/100);
}

//     .  
void CFindQueryNiiao::FillTabAdjust()
{

	ElValChar* el_ch;
	COleDateTime odt;
	CString buf,buf1;
	CaplInstance *unit;
	CString str_type,str_is;
	int i,item_num;//,iY,iM,iD;
//	double rval;
	m_ListAdjust.DeleteAllItems();
	switch(m_page_num){
	case FindObjectNIAO_ProductVer:
		m_active_list_char=&m_list_char_pdf;
		break;
	case FindObjectNIAO_ProductInst:
		m_active_list_char=&m_list_char_pi;
		break;
	case FindObjectNIAO_BPInst:
		m_active_list_char=&m_list_char_bpi;
		break;
		
	}
	// 
	for(i=0;i<m_active_list_char->Size;i++){
		el_ch=m_active_list_char->GetAt(i);
		if(el_ch==0){
			MessageBox( APL_T("  !"),_T("Error"),MB_OK|MB_ICONERROR);
			return;
		}
		if(el_ch->apl_char!=0){
			apidata.GetAttrBN(el_ch->apl_char,_T("name"),buf);
		}else{
			MessageBox( APL_T(" -   !"),_T("Error"),MB_OK|MB_ICONERROR);
			return;
		}

		apidata.GetAttrBN(el_ch->apl_char,_T("unit"),unit);
		if(el_ch->is_exist){str_is= APL_T("");}else{str_is= APL_T("");}
		if(el_ch->type){apidata.GetAttrBN(el_ch->type,_T("name"),str_type);}else{str_type=_T("");}
		
		if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_step_unit))
		{
			if(!el_ch->b_val && !el_ch->b_max && !el_ch->b_min){
				item_num=m_ListAdjust.InsertItem(i,str_is,0);
				m_ListAdjust.SetItemData(item_num,(DWORD)i);
				m_ListAdjust.SetItemText(item_num,1,buf);
				m_ListAdjust.SetItemText(item_num,2,str_type);
			}
			if(el_ch->b_val){
				item_num=m_ListAdjust.InsertItem(i,str_is,0);
				m_ListAdjust.SetItemData(item_num,(DWORD)i);

				buf1.Format( APL_T("%s:"),buf);
				m_ListAdjust.SetItemText(item_num,1,buf1);
				m_ListAdjust.SetItemText(item_num,2,str_type);
				m_ListAdjust.SetItemText(item_num,3,CaplQLQuery::LogOp2String(el_ch->log_relation));
				buf1=el_ch->val;
				m_ListAdjust.SetItemText(item_num,4,buf1);
			}
			if(el_ch->b_max){
				item_num=m_ListAdjust.InsertItem(i,str_is,0);
				m_ListAdjust.SetItemData(item_num,(DWORD)i);

				buf1.Format( APL_T("%s: "),buf);
				m_ListAdjust.SetItemText(item_num,1,buf1);
				m_ListAdjust.SetItemText(item_num,2,str_type);
				m_ListAdjust.SetItemText(item_num,3,CaplQLQuery::LogOp2String(el_ch->log_relation_max));
				buf1=el_ch->val_max;
				m_ListAdjust.SetItemText(item_num,4,buf1);
			}
			if(el_ch->b_min){
				item_num=m_ListAdjust.InsertItem(i,str_is,0);
				m_ListAdjust.SetItemData(item_num,(DWORD)i);

				buf1.Format( APL_T("%s: "),buf);
				m_ListAdjust.SetItemText(item_num,1,buf1);
				m_ListAdjust.SetItemText(item_num,2,str_type);
				m_ListAdjust.SetItemText(item_num,3,CaplQLQuery::LogOp2String(el_ch->log_relation_min));
				buf1=el_ch->val_min;
				m_ListAdjust.SetItemText(item_num,4,buf1);
			}
		}
		else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_descript_unit)||
			apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_enum_unit) )
		{
			item_num=m_ListAdjust.InsertItem(i,str_is,0);
			m_ListAdjust.SetItemData(item_num,(DWORD)i);
			m_ListAdjust.SetItemText(item_num,1,buf);
			m_ListAdjust.SetItemText(item_num,2,str_type);
			if(el_ch->b_val){
				m_ListAdjust.SetItemText(item_num,3,CaplQLQuery::LogOp2String(el_ch->log_relation));
				buf1=el_ch->val;
				m_ListAdjust.SetItemText(item_num,4,buf1);
			}
				
		}
		else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_monetary_unit))
		{
			item_num=m_ListAdjust.InsertItem(i,str_is,0);
			m_ListAdjust.SetItemData(item_num,(DWORD)i);
			
			m_ListAdjust.SetItemText(item_num,1,buf);
			m_ListAdjust.SetItemText(item_num,2,str_type);
			if(el_ch->b_val){
				m_ListAdjust.SetItemText(item_num,3,CaplQLQuery::LogOp2String(el_ch->log_relation));
				buf1=el_ch->val;
				m_ListAdjust.SetItemText(item_num,4,buf1);
			}
		}
		else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_time_unit))
		{
			item_num=m_ListAdjust.InsertItem(i,str_is,0);
			m_ListAdjust.SetItemData(item_num,(DWORD)i);
			
			m_ListAdjust.SetItemText(item_num,1,buf);
			m_ListAdjust.SetItemText(item_num,2,str_type);
			if(el_ch->b_val){
				m_ListAdjust.SetItemText(item_num,3,CaplQLQuery::LogOp2String(el_ch->log_relation));
				//buf1.Format(_T("%02s:%02s:%s"),el_ch->val_min,el_ch->val_max,el_ch->val);
				if(el_ch->dtt!=0){
					buf1=el_ch->dtt->Format(_T("%d.%m.%Y %H:%M:%S"));
				}else{
					buf1=APL_T(" ");
				}
				m_ListAdjust.SetItemText(item_num,4,buf1);
			}
		}
		else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_reference_unit))
		{
			item_num=m_ListAdjust.InsertItem(i,str_is,0);
			m_ListAdjust.SetItemData(item_num,(DWORD)i);
			
			m_ListAdjust.SetItemText(item_num,1,buf);
			m_ListAdjust.SetItemText(item_num,2,str_type);
			if(el_ch->b_val){
				m_ListAdjust.SetItemText(item_num,3,CaplQLQuery::LogOp2String(el_ch->log_relation));
				m_api->m_charact_mgr.GetItemName(el_ch->m_cur_ref_val,buf1);
				m_ListAdjust.SetItemText(item_num,4,buf1);
			}
		}
		else
		{//       ""
			item_num=m_ListAdjust.InsertItem(i,str_is,0);
			m_ListAdjust.SetItemData(item_num,(DWORD)i);
			m_ListAdjust.SetItemText(item_num,1,buf);
			m_ListAdjust.SetItemText(item_num,2,str_type);
			m_ListAdjust.SetItemText(item_num,3,CaplQLQuery::LogOp2String(el_ch->log_relation));
		}
		
	}

}


void CFindQueryNiiao::OnRclickListAdjust(NMHDR* pNMHDR, LRESULT* pResult) 
{

	// TODO: Add your control notification handler code here
	*pResult = 0;
	if(m_read_only)return;
	
	const MSG* msg;
	CPoint mouseclick;
	msg=GetCurrentMessage();
	//mouseclick -   
	mouseclick=msg->pt;
	CMenu menu;
	CMenu* pPopup =0;
	//  
	VERIFY(menu.LoadMenu(IDR_CONTEXT_MENU));
	pPopup = menu.GetSubMenu(0);
	
	int num_curr= m_ListAdjust.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if( num_curr== -1){
		pPopup->RemoveMenu(IDC_CHANGE,MF_BYCOMMAND);
		pPopup->RemoveMenu(IDC_DELETE,MF_BYCOMMAND);
	}else{
		pPopup->SetDefaultItem(IDC_CHANGE,MF_BYCOMMAND);
	}
	
	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
		TPM_RIGHTBUTTON|TPM_RETURNCMD,msg->pt.x, msg->pt.y,this);
	//       :
	switch (res)
	{
	case IDC_ADD: OnAdjustAdd();      break;
	case IDC_DELETE:OnAdjustDel();	break;
	case IDC_CHANGE:OnAdjustEdit();	break;
	default:break;
	}

}


//    ""
void CFindQueryNiiao::OnAdjustAdd() 
{

	// TODO: Add your control notification handler code here
	CFindAdjustCharactDlg char_dlg;
	if(m_read_only)return;

	char_dlg.m_api=m_api;

	if(char_dlg.DoModal()==IDOK && char_dlg.m_el!=0){
		if(char_dlg.m_el->apl_char)
		{
			m_changed=true;
			m_active_list_char->Add(char_dlg.m_el);
		}
	}
	FillTabAdjust();

}

//    ""
void CFindQueryNiiao::OnAdjustDel() 
{

	// TODO: Add your control notification handler code here
	if(m_read_only)return;

	int num_curr= m_ListAdjust.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if( num_curr== -1){
		AfxMessageBox( APL_T("  !"));
		return;
	}
	num_curr=m_ListAdjust.GetItemData(num_curr);
	m_active_list_char->Remove(num_curr);

	FillTabAdjust();

}

//     
void CFindQueryNiiao::OnDblclkListAdjust(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	OnAdjustEdit();
	*pResult = 0;
}

//    ""
void CFindQueryNiiao::OnAdjustEdit() 
{

	// TODO: Add your control notification handler code here
	CFindAdjustCharactDlg char_dlg;
	ElValChar* el_char=0;
	
	char_dlg.m_api=m_api;char_dlg.m_read_only=m_read_only;
	
	int num_curr= m_ListAdjust.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if( num_curr== -1){
		AfxMessageBox( APL_T("  !"));
		return;
	}
	
	char_dlg.m_el=m_active_list_char->GetAt(m_ListAdjust.GetItemData(num_curr));
	el_char= new ElValChar(char_dlg.m_el);
	if(char_dlg.DoModal()==IDOK && !el_char->Compare(char_dlg.m_el))	
		m_changed=true;
	delete el_char;
	
	FillTabAdjust();
	
}



/////////////////////////////////////////////////////////////////////////////////////
//   

bool CFindQueryNiiao::TestNameQuery() 
{

	if(!m_can_save)
		return true;
	CString name;
	UpdateData(TRUE);
	//if(m_ChkSaveQuery.GetCheck()!=1)return true;
	if(m_api==0)return true;
	CaplAttrValue tst_values[1];
	aplExtent ext;
	bool flag=false;
	tst_values[0].value.Set(m_StringNameQuery);
	tst_values[0].attr=m_api->m_query_mgr.a_apl_query_name;
	if(m_api->m_data.NET_FindInstancesWithAttrValues(
		m_api->m_query_mgr.e_apl_query,1,&tst_values[0],ext,false)>0)
	{
		if(ext.Size>1 || ext[0]!=m_instance){
			AfxMessageBox( APL_T("   !"),MB_ICONERROR);
			return false;
		}
	}

	return true;
}


void CFindQueryNiiao::OnExecuteFind() 
{
	m_can_make_table=m_CtrlMakeTableResult.IsWindowEnabled()==1;
	//UpdateData(TRUE);
	if(!SelchangeTabAttr()){
		return;
	}
	if(!TestNameQuery())return;
	SaveDataToBuf();
	if(GenerateStepQL()){
		CaplTranslateDialog::OnOK();
	}
};

void CFindQueryNiiao::OnShowStepql() 
{
	// TODO: Add your control notification handler code here
	m_can_make_table=m_CtrlMakeTableResult.IsWindowEnabled()==1;
	UpdateData(TRUE);
	if(!SelchangeTabAttr()){
		return;
	}
	if(!TestNameQuery())return;
	SaveDataToBuf();
	if(GenerateStepQL()){
		EndDialog(ID_SHOW_STEPQL);
	}
}

bool CFindQueryNiiao::GenerateStepQL()
{
	// TODO: Add your control notification handler code here
	int name_num=0;
	UpdateData(TRUE);
	m_cur_ext_num=0;
	m_fields=_T("");m_extents=_T("");
	m_num_ext_pdf=0;
	m_num_ext_pi=0;
	m_num_ext_bpi=0;	
	
	int i;
	bool flag_end=true,flag_char=false;
	CString object_identify,char_object_identify,buf,path;
	
	if(m_api==0)return false;
	m_attr_pdf.GetCount();
	m_attr_pi.GetCount();
	m_attr_bpi.GetCount();

	if(m_attr_pdf.m_count==0 && m_list_char_pdf.Size==0 &&
		m_attr_pi.m_count==0 && m_list_char_pi.Size==0 &&
		m_attr_bpi.m_count==0 && m_list_char_bpi.Size==0)
	{
		MessageBox( APL_T("     .\n      \n\n  "),
			0,MB_ICONERROR|MB_OK);
		return false;
	}
	/////////////////////////     FindObjectNIAO_ProductVer 
	if(flag_end){
		char_object_identify=_T("");
		if(m_attr_pdf.m_count!=0){
			if(!MakeObjectIdentify(&m_attr_pdf,FindObjectNIAO_ProductVer,object_identify))return false;
		}else{
			object_identify=_T("");
		}
		if(object_identify==_T("") && m_list_char_pdf.Size==0){
			m_num_ext_pdf=0;
		}else{
			if(object_identify!=_T(""))object_identify=_T("(")+object_identify+_T(")");
			if(m_list_char_pdf.Size>0){
				if(object_identify!=_T(""))char_object_identify=_T(".item->apl_product_definition_formation")+object_identify;
				MakeQueryChar(&m_list_char_pdf,FindObjectNIAO_ProductVer,
					char_object_identify,object_identify,
					_T("apl_product_definition_formation"));
				m_num_ext_pdf=m_list_char_pdf.Size;
			}else{
				m_num_ext_pdf=1;
				m_extents+=_T("\nExt_pdf_0{apl_product_definition_formation")+object_identify+_T("}\n");
			}
		}
		if(m_mode==FindObjectNIAO_ProductVer && 
			m_attr_pi.m_count==0 && m_list_char_pi.Size==0 &&
			m_attr_bpi.m_count==0 && m_list_char_bpi.Size==0)
		{
			//     
			for(i=0;i<m_num_ext_pdf;i++){
				buf.Format(_T("Ext_pdf_%i"),i);
				if(m_fields!=_T(""))m_fields+=_T(" AND ");
				m_fields+=buf;
			}
			flag_end=false;
		}
	}
	
	/////////////////////////                 FindObjectNIAO_ProductInst
	if(flag_end){
		char_object_identify=_T("");
		if(m_attr_pi.m_count!=0){
			if(!MakeObjectIdentify(&m_attr_pi,FindObjectNIAO_ProductInst,object_identify))return false;
		}else{
			object_identify=_T("");
		}
		for(i=0;i<m_num_ext_pdf;i++){
			buf.Format(_T(".formation IN #Ext_pdf_%i"),i);
			if(object_identify!=_T(""))object_identify+=_T(" AND ");
			object_identify+=buf;
		}
		if(object_identify==_T("") && m_list_char_pi.Size==0){
			m_num_ext_pi=0;
		}else{
			if(object_identify!=_T(""))object_identify=_T("(")+object_identify+_T(")");
			if(m_list_char_pi.Size>0){
				if(object_identify!=_T(""))char_object_identify=_T(".item->apl_product_instance")+object_identify;
				MakeQueryChar(&m_list_char_pi,FindObjectNIAO_ProductInst,
					char_object_identify,object_identify,_T("apl_product_instance"));
				m_num_ext_pi=m_list_char_pi.Size;
			}else{
				m_num_ext_pi=1;
				m_extents+=_T("\nExt_pi_0{apl_product_instance")+object_identify+_T("}\n");
			}
		}	
		if(m_attr_bpi.m_count==0 && m_list_char_bpi.Size==0 &&
			(m_mode==FindObjectNIAO_ProductInst || m_mode==FindObjectNIAO_ProductVer))
		{
			if(m_mode==FindObjectNIAO_ProductVer){
				/*
				if(m_list_char_pi.Size>0){
					path=_T(".item->apl_product_instance.formation ");
				}else{
					path=_T(".formation ");
				}*/
				path=_T(".formation ");
			}else{
				path=_T("");
			}
			//     
			for(i=0;i<m_num_ext_pi;i++){
				buf.Format(_T("Ext_pi_%i"),i);
				if(m_fields!=_T(""))m_fields+=_T(" AND ");
				m_fields+=buf+path;
			}
			flag_end=false;
		}
	}
	
	/////////////////////////                 FindObjectNIAO_BPInst
	if(flag_end){
		char_object_identify=_T("");
		if(m_attr_bpi.m_count!=0){
			if(!MakeObjectIdentify(&m_attr_bpi,FindObjectNIAO_BPInst,object_identify))return false;
		}else{
			object_identify=_T("");
		}
		if(object_identify==_T("") && m_list_char_bpi.Size==0){
			m_num_ext_bpi=0;
		}else{
			if(object_identify!=_T(""))object_identify=_T("(")+object_identify+_T(")");
			if(m_list_char_bpi.Size>0){
				if(object_identify!=_T(""))char_object_identify=_T(".item->apl_business_process_instance")+object_identify;
				MakeQueryChar(&m_list_char_bpi,FindObjectNIAO_BPInst,
					char_object_identify,object_identify,_T("apl_business_process_instance"));
				m_num_ext_bpi=m_list_char_bpi.Size;
			}else{
				m_num_ext_bpi=1;
				m_extents+=_T("\nExt_bpi_0{apl_business_process_instance")+object_identify+_T("}\n");
			}
		}
		m_extents+=_T("\nExt_bpi_ref{apl_business_process_instance_reference");
		if(m_num_ext_pi+m_num_ext_bpi>0){
			m_extents+=_T("(");
		}
		for(i=0;i<m_num_ext_pi;i++){
			buf.Format(_T(".item IN #Ext_pi_%i"),i);
			if(i!=0)m_extents+=_T(" AND ");
			m_extents+=buf;
		}
		if(m_num_ext_pi>0 && m_num_ext_bpi>0){
			m_extents+=_T(" AND ");
		}
		for(i=0;i<m_num_ext_bpi;i++){
			buf.Format(_T(".assigned_process_instance IN #Ext_bpi_%i"),i);
			if(i!=0)m_extents+=_T(" AND ");
			m_extents+=buf;
		}
		if(m_num_ext_pi+m_num_ext_bpi>0){
			m_extents+=_T(")");
		}
		m_extents+=_T("}\n");
		
		if(m_mode==FindObjectNIAO_ProductInst){
			path=_T(".item->apl_product_instance ");
		}else if(m_mode==FindObjectNIAO_ProductVer){
			path=_T(".item->apl_product_instance.formation->product_definition_formation ");
		}else{
			path=_T(".assigned_process_instance");
		}
		buf.Format(_T("Ext_bpi_ref"));
		m_fields+=buf+path;
		flag_end=false;
	}
	
	
	m_QL_query=_T("SELECT\n")+m_fields+_T("\nFROM\n")+m_extents+_T("\nEND_SELECT");
	m_is_adjustment=m_list_char_pdf.Size>0 || m_list_char_pi.Size>0 || m_list_char_bpi.Size>0;

	return true;
}

//       
//       
bool CFindQueryNiiao::MakeObjectIdentify(SParam	*active_attr,
						TypeFindObjectNIIAO mode,CString &object_condition)
{

	CString str_par,str_rel;
	CString object_name;
	int i;//,id;
	struct sArrName{
		CString name_attr;
		CString sql;
	} ArrName[7];
	CArray<int,int> ListAttr;
	CArray<int,int> ListAttrPdf;
//	int count_only_prd=0;

	//       
	switch(mode){
	case FindObjectNIAO_ProductVer: // Product definition formation
		object_name=m_api->m_prd_mgr.e_apl_pdf->name; //_T("apl_product_definition_formation");
		ArrName[0].name_attr=_T(".id");
		ArrName[1].name_attr=_T(".name");
		ArrName[2].name_attr=_T(".formation_type");
		ArrName[3].name_attr=_T(".code");
		ArrName[4].name_attr=_T(".make_or_buy");
		ArrName[6].name_attr=_T(".id");
		break;
	case FindObjectNIAO_ProductInst: // Product Inst
		object_name=_T("apl_product_instance");
		ArrName[0].name_attr=_T(".id");
		ArrName[1].name_attr=_T(".serial_number");
		break;
	case FindObjectNIAO_BPInst: // Action
		object_name=_T("apl_business_process_version.process->apl_business_process");
		ArrName[0].name_attr=_T(".id");
		ArrName[1].name_attr=_T(".name");
		ArrName[2].name_attr=_T(".type");
		break;
	}
	//      !
	ArrName[5].name_attr=_T(".description");
	
	// 
	object_condition=_T("");
	

	//        -
	if(active_attr->m_state_id!=0){
		str_par=active_attr->m_id;
		if(active_attr->m_state_id==1){str_rel=_T(" = '");}else{str_rel=_T(" LIKE '");}
		ArrName[0].sql=str_rel+str_par+_T("' ");
		if(mode==FindObjectNIAO_ProductVer){ListAttrPdf.Add(0);}else{ListAttr.Add(0);}
	}
	if(active_attr->m_state_name!=0){
		str_par=active_attr->m_name;

		if(active_attr->m_state_name==1){str_rel=_T(" = '");}else{str_rel=_T(" LIKE '");}
		ArrName[1].sql=str_rel+str_par+_T("' ");
		if(mode==FindObjectNIAO_ProductVer){ListAttrPdf.Add(1);}else{ListAttr.Add(1);}
	}
	if(active_attr->m_state_descr!=0){
		str_par=active_attr->m_descr;

		if(active_attr->m_state_descr==1){str_rel=_T(" = '");}else{str_rel=_T(" LIKE '");}
		ArrName[5].sql=str_rel+str_par+_T("' ");
		ListAttr.Add(5);
	}
	if(active_attr->m_state_type!=0){
			
		if(mode==FindObjectNIAO_ProductVer){
			str_par=active_attr->m_type;
			//   product-  
			str_par=m_api->m_prd_mgr.StrConvertRus2PdfType(str_par);
			
			ArrName[2].sql.Format(_T(" = '%s'"),str_par);
		}
		ListAttr.Add(2);
	}
	if(active_attr->m_state_code!=0){
		str_par=active_attr->m_code;

		if(active_attr->m_state_code==1){str_rel=_T(" = '");}else{str_rel=_T(" LIKE '");}
		ArrName[3].sql=str_rel+str_par+_T("' ");
		ListAttr.Add(3);
	}
	if(active_attr->m_state_source!=0){
//		str_par=active_attr->m_source;
//		m_EditSource.AddString(APL_T(" "));		-"not_known"	- 0
//		m_EditSource.AddString(APL_T(""));			-"bought"	- 1
//		m_EditSource.AddString(APL_T(""));	-"made"	- 2
		
		switch(active_attr->m_source){
		case 0:
			str_par=_T("not_known");
			break;
		case 1:
			str_par=_T("bought");
			break;
		case 2:
			str_par=_T("made");
			break;
		default:
			AfxMessageBox( APL_T("   !"));
			return false;
		}
		
		ArrName[4].sql.Format(_T(" = '%s'"),str_par);
		ListAttr.Add(4);
	}
	if(active_attr->m_state_ver!=0){
		str_par=active_attr->m_ver;

		if(active_attr->m_state_ver==1){str_rel=_T(" = '");}else{str_rel=_T(" LIKE '");}
		ArrName[6].sql=str_rel+str_par+_T("' ");
		ListAttr.Add(6);
	}
	
	int size_prd=ListAttr.GetSize();
	int size_pdf=ListAttrPdf.GetSize();
	if(mode==FindObjectNIAO_ProductVer){
		if(size_prd+size_pdf>0 )
		{
			if(size_prd>1 || (size_prd>0 && size_pdf>0))object_condition+=_T("(");
			if(size_pdf>=1)object_condition+=_T(".of_product->product");
			if(size_pdf==2)object_condition+=_T("(");
			for(i=0;i<size_pdf;i++){
				object_condition+=ArrName[ListAttrPdf.GetAt(i)].name_attr +
					_T(" ")+ArrName[ListAttrPdf.GetAt(i)].sql;
				if(i+1<size_pdf){object_condition+=_T(" AND ");}
			}
			if(size_pdf==2)object_condition+=_T(")");
			if((size_prd>=2 || size_prd>=1) && size_pdf>0)object_condition+=_T(" AND ");
			for(i=0;i<size_prd;i++){
				object_condition+=ArrName[ListAttr.GetAt(i)].name_attr +
					_T(" ")+ArrName[ListAttr.GetAt(i)].sql;
				if(i+1<size_prd){object_condition+=_T(" AND ");}
			}
			if(size_prd>1 || (size_prd>0 && size_pdf>0))object_condition+=_T(")");
			
		}else{
			object_condition=ArrName[3].name_attr+_T(" LIKE ''");
		}
	}else{
		if(size_prd>=1){
			if(size_prd>=2){object_condition=_T("(");}else{object_condition=_T("");}
			for(i=0;i<size_prd;i++){
				object_condition+=ArrName[ListAttr.GetAt(i)].name_attr + 
					_T(" ")+ArrName[ListAttr.GetAt(i)].sql;
				if(i+1<size_prd){object_condition+=_T(" AND ");}
			}
			if(size_prd>=2)object_condition+=_T(")");
		}else{
			object_condition=ArrName[0].name_attr+_T(" LIKE ''");
		}
	}

	return true;
}// bool CFindQueryNiiao::MakeObjectIdentify(){




//   QL    
void CFindQueryNiiao::MakeQueryChar(
	CaplTAggr<ElValChar*,ElValChar*,APLAGGR_UNIQUE|APLAGGR_LIST|APLAGGR_AUTOKILLREF> *active_list_char,
								TypeFindObjectNIIAO mode,CString char_object_identify,CString object_identify,CString res_ent)
{

	int i=0;
	ElValChar* el_ch;
	CaplEntity* base_entity=0;
	CString condition=_T(""),buf,buf1,name_def,name_ext,ext,body;
	switch(mode){
	case FindObjectNIAO_ProductVer:name_def=_T("Ext_pdf_");break;
	case FindObjectNIAO_ProductInst:name_def=_T("Ext_pi_");break;
	case FindObjectNIAO_BPInst:name_def=_T("Ext_bpi_");break;
	default: return;
	}
	if(object_identify!=_T("")){
		object_identify+=_T(" AND \n\t\t");
	}
	

	for(i=0;i<active_list_char->Size;i++){
		name_ext.Format(name_def+_T("%i"),i);
		condition=_T("");
		if(char_object_identify!=_T("")){
			condition=char_object_identify+_T(" AND \n\t\t");
		}
		//      
		el_ch=active_list_char->GetAt(i);
		if(el_ch==0)continue;
		if(el_ch->apl_char==0)continue;

		//  AND        
		//    
		buf.Format(_T(" .characteristic = #%i "),el_ch->apl_char->GetId());
		if(el_ch->type!=0){
			buf1.Format(_T(" AND .assignment_type = #%i"),el_ch->type->GetId());
		}else{
			buf1=_T("");
		}
		if(el_ch->is_exist){
			condition+=buf+buf1+_T("\n\t\t");
		}else{
			condition=buf+buf1+_T("\n\t\t");
		}
		base_entity=m_api->m_charact_mgr.e_apl_charact_value;
		if(el_ch->b_max || el_ch->b_min || el_ch->b_val){
				//     
			condition+=FillCharValue(el_ch,&base_entity);
		}
		if(base_entity==0)return;
		body=base_entity->name+_T("(\n\t\t")+condition+_T(")}\n\t\t.item->")+res_ent+_T(" ");
		if(el_ch->is_exist){
			ext=_T("\n")+name_ext+_T("{")+body;
		}else{
			ext=_T("\n")+name_ext+_T("_prev{")+body;
			ext+=_T("\n")+name_ext+_T("{")+res_ent+_T("(")+object_identify+_T(".# NOT_IN #")+name_ext+_T("_prev)} ");
		}
		m_extents+=ext;
	}

}


//   QL   
CString CFindQueryNiiao::FillCharValue(ElValChar* el_ch,CaplEntity** base_entity)
{

	CString result=_T(""),s_val=_T(""),s_max=_T(""),s_min=_T(""),buf=_T("");

	CaplInstance * unit;
	int num_field=0;
	if(base_entity==0)return _T("");

	if(el_ch->log_relation!=CaplQLQuery::aplEXIST){
//		result=_T(" AND .val->");   27  28 
		result=_T(" AND ");
	}else{
		result=_T("");
		return result;
	}
	
	apidata.GetAttrBN(el_ch->apl_char,_T("unit"),unit);
	if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_step_unit) ||
		apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_descript_unit) ||
		apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_enum_unit) || 
		apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_monetary_unit))
	{
		//    
		if(el_ch->b_val){
			s_val=_T(".val ")+
				CaplQLQuery::LogOp2String(el_ch->log_relation,false)+
				el_ch->val;
			num_field++;
		}
		if(el_ch->b_max){
			s_max=_T(".max_deviation ")+
				CaplQLQuery::LogOp2String(el_ch->log_relation_max,false)+
				el_ch->val_max;
			num_field++;
		}
		if(el_ch->b_min){
			s_min=_T(".min_deviation ")+
				CaplQLQuery::LogOp2String(el_ch->log_relation_min,false)+
				el_ch->val_min;
			num_field++;
		}

		//       
		//     apl_characterictic_value
		if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_step_unit)){
//			result+=_T("apl_measured_characteristic_value");   27  28 
			*base_entity=m_api->m_charact_mgr.e_meas_value;
			switch(num_field){
			case 1:
				if(el_ch->b_val){result+=s_val;}
				else if(el_ch->b_max){result+=s_max;}
				else if(el_ch->b_min){result+=s_min;}
				break;
			case 2:
				result+=_T("(");
				if(el_ch->b_val&&el_ch->b_max){
					result+=s_val+_T(" AND ")+s_max;
				}
				if(el_ch->b_val&&el_ch->b_min){
					result+=s_val+_T(" AND ")+s_min;
				}
				if(el_ch->b_max&&el_ch->b_min){
					result+=s_max+_T(" AND ")+s_min;
				}
				result+=_T(")");
				break;
			case 3:
				result+=_T("(")+s_val+_T(" AND ")+s_max+_T(" AND ")+s_min+_T(")");
				break;
			default:
				return CString(_T(""));
			}

		}else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_descript_unit)){
			if(!el_ch->b_val)return CString(_T(""));
//			result+=_T("apl_descriptive_characteristic_value")+s_val;   27  28 
			*base_entity=m_api->m_charact_mgr.e_descr_value;
			result+=s_val;
		}else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_enum_unit)){
			if(!el_ch->b_val)return CString(_T(""));
//			result+=_T("apl_enumeration_characteristic_value")+s_val;   27  28 
			*base_entity=m_api->m_charact_mgr.e_enum_value;
			result+=s_val;
		}else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_monetary_unit)){
			if(!el_ch->b_val)return CString(_T(""));
//			result+=_T("apl_monetary_characteristic_value")+s_val;   27  28 
			*base_entity=m_api->m_charact_mgr.e_monet_value;
			result+=s_val;
		}
	}else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_time_unit)){
		//     
		if(el_ch->b_val){
//			result+=_T("apl_point_in_time_characteristic_value")+   27  28 
			*base_entity=m_api->m_charact_mgr.e_time_val;
			result+=
				FillDateCompare(_T("val_s"),el_ch->log_relation,el_ch->dtt);
		}
	}
	else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_reference_unit))
	{
		if(el_ch->b_val){
			if(el_ch->m_cur_ref_val==0)return _T("");
			s_val.Format(_T(" #%i "),el_ch->m_cur_ref_val->GetId());
//			result+=_T("apl_reference_value.val ")+   27  28 
			*base_entity=m_api->m_charact_mgr.e_apl_reference_value;
			result+=_T(".val ")+
				CaplQLQuery::LogOp2String(el_ch->log_relation,false)+
				s_val;
		}
	}

	return result;
}


static int rec_num=0;
//        
CString CFindQueryNiiao::FillDateCompare(CString name_attr,CaplQLQuery::aplQLLogRelation log_relation,COleDateTime* dtt){
//										int year,int month,int day){
	CString result,buf,buf1,log_op_str;
	if(dtt==0)return _T("");
/*	rec_num++;
	if(rec_num==1){
		result=_T("->apl_date_and_time");
	}*/
	
	//   <=  >=
	if(log_relation==CaplQLQuery::aplSMALLEQUAL){
		result+=_T("(")+FillDateCompare(name_attr,CaplQLQuery::aplSMALL,dtt)+
			_T(" OR ")+FillDateCompare(name_attr,CaplQLQuery::aplEQUAL,dtt)+
			_T(")");
//		rec_num--;
		return result;
	}else if(log_relation==CaplQLQuery::aplBIGEQUAL){
//		result+=_T("(")+FillDateCompare(CaplQLQuery::aplBIG,year,month,day)+
		result+=_T("(")+FillDateCompare(name_attr,CaplQLQuery::aplBIG,dtt)+
//			_T(" OR ")+FillDateCompare(CaplQLQuery::aplEQUAL,year,month,day)+
			_T(" OR ")+FillDateCompare(name_attr,CaplQLQuery::aplEQUAL,dtt)+
			_T(")");
//		rec_num--;
		return result;
	}

	log_op_str=CaplQLQuery::LogOp2String(log_relation,false);
	aplDate2String(*dtt,buf1);
	buf.Format(_T(".%s %s '%s' "),name_attr,log_op_str,buf1);
	result+=buf;
	
	/*	if(log_relation==CaplQLQuery::aplEQUAL){
	buf.Format(_T("(.year_component = %i AND .month_component = %i AND .day_component =%i)\n"),year,month,day);
	result+=buf;
	}else{
	CString log_op_str=CaplQLQuery::LogOp2String(log_relation,false);
	buf.Format(_T("		((.year_component %s %i) OR ")
	_T("		(.year_component = %i AND .month_component %s %i) OR\n")
	_T("		(.year_component = %i AND .month_component = %i AND .day_component %s %i))\n"),
	log_op_str,year,
	year,log_op_str,month,
	year,month,log_op_str,day);
	result+=buf;
}*/
	//	rec_num--;
	return result;
}


///////////////////////////////////////////////////////////////////////
//    -   

bool CFindQueryNiiao::SaveDataToBuf()
{
	BYTE type;
	BYTE count=0;
	if(!m_changed)return true;
	if(m_dbuf==0)m_dbuf=new CaplDataBuf();
	
	m_dbuf->Clear();
	// 
	m_dbuf->Add(STD_HEADER_FIND_QUERY_NIAO,_strlen(STD_HEADER_FIND_QUERY_NIAO)+1);
	//  
	type=m_mode;
	m_dbuf->Add(&type,1);

	///////////////////////////////////////////////////
	//  pdf
	SaveAttrToBuf(&m_attr_pdf,FindObjectNIAO_ProductVer);
	///////////////////////////////////////////////////
	//  pdf
	SaveCharacteristikToBuf(&m_list_char_pdf);

	///////////////////////////////////////////////////
	//  pi
	SaveAttrToBuf(&m_attr_pi,FindObjectNIAO_ProductInst);
	///////////////////////////////////////////////////
	//  pi
	SaveCharacteristikToBuf(&m_list_char_pi);
	

	///////////////////////////////////////////////////
	//  bp
	SaveAttrToBuf(&m_attr_bpi,FindObjectNIAO_BPInst);
	//   ?
	//type=(m_ctrl_find_version.GetCheck()==1)?1:0;
	type=0;
	m_dbuf->Add(&type,1);

	///////////////////////////////////////////////////
	//  bpi
	SaveCharacteristikToBuf(&m_list_char_bpi);
	
	
	
	///////////////////////////////////////////////////
	//  
	// 1  -      (1 - , 0  , 255 -  )
	if(m_can_make_table){
		type=(m_IsMakeTableResult)?1:0;
	}else{
		type=255;
	}
	m_dbuf->Add(&type,1);
	
	//m_changed=false;

	return true;
}

bool CFindQueryNiiao::SaveAttrToBuf(SParam	*active_attr,TypeFindObjectNIIAO mode)
{
	
	BYTE type;
	BYTE count=0;
	int length,k;
	aplExtent ext;
	CString buf;
	
	if(active_attr==0)return false;

	active_attr->GetCount();
	count=active_attr->m_count;
	
	m_dbuf->Add(&count,1);
	if(active_attr->m_state_id!=0 && active_attr->m_id != _T(""))
	{
		type=TFO_Id;
		m_dbuf->Add(&type,1);
		type=(active_attr->m_state_id==1)?1:0;
		m_dbuf->Add(&type,1);
		length=active_attr->m_id.GetLength()+1;
		if(length>250)length=250;
		type=(BYTE)length;
		m_dbuf->Add(&type,1);
		m_dbuf->Add(active_attr->m_id.GetBuffer(length),length);
	}
	if(active_attr->m_state_name!=0 && active_attr->m_name != _T(""))
	{
		type=TFO_Name;
		m_dbuf->Add(&type,1);
		type=(active_attr->m_state_name==1)?1:0;
		m_dbuf->Add(&type,1);
		length=active_attr->m_name.GetLength()+1;
		if(length>250)length=250;
		type=(BYTE)length;
		m_dbuf->Add(&type,1);
		m_dbuf->Add(active_attr->m_name.GetBuffer(length),length);
	}
	if(active_attr->m_state_descr!=0 && active_attr->m_descr != _T(""))
	{
		type=TFO_Descr;
		m_dbuf->Add(&type,1);
		type=(active_attr->m_state_descr==1)?1:0;
		m_dbuf->Add(&type,1);
		length=active_attr->m_descr.GetLength()+1;
		if(length>250)length=250;
		type=(BYTE)length;
		m_dbuf->Add(&type,1);
		m_dbuf->Add(active_attr->m_descr.GetBuffer(length),length);
	}
	if(active_attr->m_state_type!=0 )
	{
		type=TFO_Type;
		m_dbuf->Add(&type,1);
		type=(active_attr->m_state_type==1)?1:0;
		m_dbuf->Add(&type,1);
		if(mode==FindObjectNIAO_ProductVer){
			length=active_attr->m_type.GetLength()+1;
			if(length>250)length=250;
			type=(BYTE)length;
			m_dbuf->Add(&type,1);
			m_dbuf->Add(active_attr->m_type.GetBuffer(length),length);
		}else if(mode==FindObjectNIAO_BPInst){
			//         
			k=active_attr->m_type_id;
			m_dbuf->Add(&k,4);
		}
	}
	if(active_attr->m_state_code!=0 && active_attr->m_code != _T(""))
	{
		type=TFO_Code;
		m_dbuf->Add(&type,1);
		type=(active_attr->m_state_code==1)?1:0;
		m_dbuf->Add(&type,1);
		length=active_attr->m_code.GetLength()+1;
		if(length>250)length=250;
		type=(BYTE)length;
		m_dbuf->Add(&type,1);
		m_dbuf->Add(active_attr->m_code.GetBuffer(length),length);
	}
	if(active_attr->m_state_source!=0 )
	{
		type=TFO_Source;
		m_dbuf->Add(&type,1);
		type=(active_attr->m_state_source==1)?1:0;
		m_dbuf->Add(&type,1);
		type=(BYTE)active_attr->m_source;
		m_dbuf->Add(&type,1);
	}
	if(active_attr->m_state_ver!=0 && active_attr->m_ver != _T(""))
	{
		type=TFO_Ver;
		m_dbuf->Add(&type,1);
		type=(active_attr->m_state_ver==1)?1:0;
		m_dbuf->Add(&type,1);
		length=active_attr->m_ver.GetLength()+1;
		if(length>250)length=250;
		type=(BYTE)length;
		m_dbuf->Add(&type,1);
		m_dbuf->Add(active_attr->m_ver.GetBuffer(length),length);
	}	
	
	return true;
}
	

bool CFindQueryNiiao::SaveCharacteristikToBuf(CaplTAggr<ElValChar*,ElValChar*,APLAGGR_UNIQUE|APLAGGR_LIST|APLAGGR_AUTOKILLREF> *list_char)
{
	
	BYTE type;
	ElValChar* el_ch;
	bool flag;
	DATE dt1;
	BYTE count=0;
	int i,id,length;
	CaplInstance *unit;
	if(list_char==0)return false;
	
	// 1  - 
	type=(BYTE)list_char->Size;
	m_dbuf->Add(&type,1);
	
	//    
	for(i=0;i<list_char->Size;i++){
		//      
		el_ch=list_char->GetAt(i);
		flag=false;
		count=0;
		if(el_ch==0)flag=true;
		if(el_ch->apl_char==0)flag=true;
		if(!flag){
			if(el_ch->apl_char!=0)count++;
			if(el_ch->type!=0)count++;
			if(el_ch->b_val!=0)count++;
			if(el_ch->b_max!=0)count++;
			if(el_ch->b_min!=0)count++;
			if(count==0)flag=true;
		}
		if(flag){
			//1  -  (1 /0  )
			type=0;
			m_dbuf->Add(&type,1);
			// 1  -   
			//    
			type=0;
			m_dbuf->Add(&type,1);
			continue;
		}
		//1  -  (1 /0  )
		type=el_ch->is_exist?1:0;
		m_dbuf->Add(&type,1);
		// 1  -   
		m_dbuf->Add(&count,1);
		if(el_ch->apl_char!=0){
			// 1 -  (instance_id - 4 )
			type=1;
			m_dbuf->Add(&type,1);
			id=el_ch->apl_char->GetId();
			m_dbuf->Add(&id,4);
			apidata.GetAttrBN(el_ch->apl_char,_T("unit"),unit);
		}
		if(el_ch->type!=0){
			// 2 -   (instance_id - 4 )
			type=2;
			m_dbuf->Add(&type,1);
			id=el_ch->type->GetId();
			m_dbuf->Add(&id,4);
		}
		if(el_ch->b_val!=0){
			// 3 -  .  :
			type=3;
			m_dbuf->Add(&type,1);
			// 1   -      CaplQLQuery::aplQLLogRelation
			type=(BYTE)el_ch->log_relation;
			m_dbuf->Add(&type,1);
			if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_step_unit) ||
				apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_descript_unit) ||
				apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_enum_unit) || 
				apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_monetary_unit))
			{
				// 1 -  (1    +  )
				type=1;
				m_dbuf->Add(&type,1);
				length=el_ch->val.GetLength()+1;
				if(length>250)length=250;
				count=(BYTE)length;
				m_dbuf->Add(&count,1);
				m_dbuf->Add(el_ch->val.GetBuffer(length),length);
			}else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_time_unit)){
				// 4 -  ( 8 )
				type=4;
				m_dbuf->Add(&type,1);
				dt1=(DATE)(*el_ch->dtt);
				m_dbuf->Add(&dt1,8);
			}
			else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_reference_unit))
			{
				// 5 -  (4  - instance_id)
				type=5;
				m_dbuf->Add(&type,1);
				id=(el_ch->m_cur_ref_val==0)?0:el_ch->m_cur_ref_val->GetId();
				m_dbuf->Add(&id,4);
			}   
		}
		if(el_ch->b_max!=0){
			// 3 -  .  :
			type=3;
			m_dbuf->Add(&type,1);
			// 1   -      CaplQLQuery::aplQLLogRelation
			type=(BYTE)el_ch->log_relation_max;
			m_dbuf->Add(&type,1);
			// 2 -  max (1    +  )
			type=2;
			m_dbuf->Add(&type,1);
			length=el_ch->val_max.GetLength()+1;
			if(length>250)length=250;
			count=(BYTE)length;
			m_dbuf->Add(&count,1);
			m_dbuf->Add(el_ch->val_max.GetBuffer(length),length);
		}
		if(el_ch->b_min!=0){
			// 3 -  .  :
			type=3;
			m_dbuf->Add(&type,1);
			// 1   -      CaplQLQuery::aplQLLogRelation
			type=(BYTE)el_ch->log_relation_min;
			m_dbuf->Add(&type,1);
			// 3 -  min (1    +  )
			type=3;
			m_dbuf->Add(&type,1);
			length=el_ch->val_min.GetLength()+1;
			if(length>250)length=250;
			count=(BYTE)length;
			m_dbuf->Add(&count,1);
			m_dbuf->Add(el_ch->val_min.GetBuffer(length),length);
		}
	}	
	
	return true;
}


bool CFindQueryNiiao::LoadDataFromBuf()
{
#ifdef _UNICODE
	AfxMessageBox(APL_T("       Unicode!"));
	return false;
#endif

	char* cbuf;
	aplExtent ext1,ext2,ext3;
	CString buf;
	CString str_par;
	CaplDataBuf dbuf_temp;
	
	BYTE type;
	BYTE count=0;
	int k;	

	if(m_dbuf==0)return true;
	m_dbuf->Reset();

	// 
	k=_strlen(STD_HEADER_FIND_QUERY_NIAO)+1;
	cbuf=new char[k];
	m_dbuf->Read(cbuf,k);
	if(CString(cbuf)!=STD_HEADER_FIND_QUERY_NIAO){
		delete cbuf;
		return false;
	}
	delete cbuf;
	//  
	m_dbuf->Read(&type,1);
	m_mode=(TypeFindObjectNIIAO)type;


	///////////////////////////////////////////////////
	//  pdf
	LoadAttrFromBuf(&m_attr_pdf,FindObjectNIAO_ProductVer);
	///////////////////////////////////////////////////
	//  pdf
	LoadCharacteristikFromBuf(&m_list_char_pdf);
	
	///////////////////////////////////////////////////
	//  pi
	LoadAttrFromBuf(&m_attr_pi,FindObjectNIAO_ProductInst);
	///////////////////////////////////////////////////
	//  pi
	LoadCharacteristikFromBuf(&m_list_char_pi);
	
	
	///////////////////////////////////////////////////
	//  bp
	LoadAttrFromBuf(&m_attr_bpi,FindObjectNIAO_BPInst);
	//   ?
	m_dbuf->Read(&type,1);
	//m_ctrl_find_version.SetCheck(type==1);
	
	///////////////////////////////////////////////////
	//  bpi
	LoadCharacteristikFromBuf(&m_list_char_bpi);
	
	
	//  
	// 1  -      (1 - , 0  , 255 -  )
	m_dbuf->Read(&type,1);
	switch(type){
	case 0:
		//m_IsMakeTableResult=FALSE;
		m_can_make_table=true;
		break;
	case 1:
		//m_IsMakeTableResult=TRUE;
		m_can_make_table=true;
		break;
	case 252:
		//m_IsMakeTableResult=FALSE;
		m_can_make_table=false;
		m_CtrlMakeTableResult.EnableWindow(FALSE);
		break;
	}
	m_changed=false;

	return true;
}

bool CFindQueryNiiao::LoadAttrFromBuf(SParam *active_attr,TypeFindObjectNIIAO mode)
{
	
	char* cbuf;
	aplExtent ext2;
	CString buf;
	CString str_par;
	CaplDataBuf dbuf_temp;
	
	BYTE type;
	BYTE count=0;
	int j,id;	
	
	if(m_dbuf==0)return true;
	if(active_attr==0)return false;

	//   
	m_dbuf->Read(&count,1);
	for(j=0;j<count;j++){
		m_dbuf->Read(&type,1);
		switch(type){
		case TFO_Id:
			m_dbuf->Read(&type,1);
			active_attr->m_state_id=(type==1)?1:2;
			m_dbuf->Read(&type,1);
			cbuf=new char[type];
			m_dbuf->Read(cbuf,type);
			str_par=cbuf;
			delete cbuf;

			active_attr->m_id=str_par;
			break;
		case TFO_Name:
			m_dbuf->Read(&type,1);
			active_attr->m_state_name=(type==1)?1:2;
			m_dbuf->Read(&type,1);
			cbuf=new char[type];
			m_dbuf->Read(cbuf,type);
			str_par=cbuf;
			delete cbuf;
			
			active_attr->m_name=str_par;
			break;
		case TFO_Descr:
			m_dbuf->Read(&type,1);
			active_attr->m_state_descr=(type==1)?1:2;
			m_dbuf->Read(&type,1);
			cbuf=new char[type];
			m_dbuf->Read(cbuf,type);
			str_par=cbuf;
			delete cbuf;
			
			active_attr->m_descr=str_par;
			break;
		case TFO_Type:
			m_dbuf->Read(&type,1);
			active_attr->m_state_type=(type==1)?1:2;
			if(mode==FindObjectNIAO_ProductVer){
				m_dbuf->Read(&type,1);
				cbuf=new char[type];
				m_dbuf->Read(cbuf,type);
				str_par=cbuf;
				active_attr->m_type=str_par;
				delete cbuf;
			}else if(mode==FindObjectNIAO_BPInst){
				str_par=_T("");
				m_dbuf->Read(&id,4);
				active_attr->m_type_id=id;
			}
			break;
		case TFO_Code:
			m_dbuf->Read(&type,1);
			active_attr->m_state_code=(type==1)?1:2;
			m_dbuf->Read(&type,1);
			cbuf=new char[type];
			m_dbuf->Read(cbuf,type);
			str_par=cbuf;
			delete cbuf;
			
			active_attr->m_code=str_par;
			break;
			
		case TFO_Source:
			m_dbuf->Read(&type,1);
			active_attr->m_state_source=(type==1)?1:2;
			m_dbuf->Read(&type,1);
			active_attr->m_source=(int)type;
			break;
		case TFO_Ver:
			m_dbuf->Read(&type,1);
			active_attr->m_state_ver=(type==1)?1:2;
			m_dbuf->Read(&type,1);
			cbuf=new char[type];
			m_dbuf->Read(cbuf,type);
			str_par=cbuf;
			delete cbuf;
			
			active_attr->m_ver=str_par;
			break;
		}
	}

	return true;
}

bool CFindQueryNiiao::LoadCharacteristikFromBuf(CaplTAggr<ElValChar*,ElValChar*,APLAGGR_UNIQUE|APLAGGR_LIST|APLAGGR_AUTOKILLREF> *list_char)
{
	
	BYTE type,type2;
	ElValChar* el_ch;
	bool flag;
	DATE dt1;
	BYTE count=0,count2=0;
	int i,j,k,id;
	aplExtent ext1,ext2;
	char* cbuf;

	if(list_char==0)return false;
	list_char->Clear();
	
	//   
	// 1  - 
	m_dbuf->Read(&count,1);
	apidata.GetEntityExtent(m_api->m_charact_mgr.e_apl_charact,ext1);
	apidata.GetEntityExtent(m_api->m_charact_mgr.e_apl_charact_type,ext2);
	
	for(i=0;i<count;i++){
		//1  -  (1 /0  )
		m_dbuf->Read(&type,1);
		flag=type==1;
		//1  -   
		m_dbuf->Read(&count2,1);
		if(count2==0)continue;
		el_ch=new ElValChar();
		el_ch->is_exist=flag;
		for(k=0;k<count2;k++){
			//1  - id  (  -  ):
			m_dbuf->Read(&type,1);
			switch(type){
			case 1:
				//1 -  (instance_id - 4 )
				m_dbuf->Read(&id,4);
				//  
				el_ch->apl_char=0;
				for(j=0;j<ext1.GetSize();j++){
					if(id==ext1.GetAt(j)->GetId()){
						el_ch->apl_char=ext1.GetAt(j);
						break;
					}
				}
				break;
			case 2:
				//2 -   (instance_id - 4 )
				m_dbuf->Read(&id,4);
				//  
				el_ch->type=0;
				for(j=0;j<ext2.GetSize();j++){
					if(id==ext2.GetAt(j)->GetId()){
						el_ch->type=ext2.GetAt(j);
						break;
					}
				}
				break;
			case 3:
				//3 -  .  :
				// 1   -    
				m_dbuf->Read(&type2,1);
				//1  -   (  Y):
				m_dbuf->Read(&type,1);
				switch(type){
				case 1:
					//1 -  (1    +  )
					m_dbuf->Read(&type,1);
					cbuf=new char[type];
					m_dbuf->Read(cbuf,type);
					el_ch->val=cbuf;
					delete cbuf;
					el_ch->b_val=true;
					el_ch->log_relation=(CaplQLQuery :: aplQLLogRelation)type2;
					break;
				case 2:
					//2 -  max (1    +  )
					m_dbuf->Read(&type,1);
					cbuf=new char[type];
					m_dbuf->Read(cbuf,type);
					el_ch->val_max=cbuf;
					delete cbuf;
					el_ch->b_max=true;
					el_ch->log_relation_max=(CaplQLQuery :: aplQLLogRelation)type2;
					break;
				case 3:
					//3 -  min (1    +  )
					m_dbuf->Read(&type,1);
					cbuf=new char[type];
					m_dbuf->Read(cbuf,type);
					el_ch->val_min=cbuf;
					delete cbuf;
					el_ch->b_min=true;
					el_ch->log_relation_min=(CaplQLQuery :: aplQLLogRelation)type2;
					break;
				case 4:
					//4 -  ( 8 )
					m_dbuf->Read(&dt1,8);
					if(el_ch->dtt==0)el_ch->dtt=new COleDateTime();
					*(el_ch->dtt)=dt1;
					el_ch->b_val=true;
					el_ch->log_relation=(CaplQLQuery :: aplQLLogRelation)type2;
					break;
				case 5:
					//5 -  (4  - instance_id)
					m_dbuf->Read(&id,4);
					aplQFindInstIdInExtent(
						*((aplExtent*)(&(apidata.instances))),id,-1,true,&(el_ch->m_cur_ref_val));
					el_ch->b_val=true;
					el_ch->log_relation=(CaplQLQuery :: aplQLLogRelation)type2;
					break;
				}
			}	
		}

		

		list_char->Add(el_ch);
	}	
	
	return true;
	
}

bool CFindQueryNiiao::SetDataBuf(CaplDataBuf &dbuf)
{
	if(m_dbuf==0){
		m_dbuf=new CaplDataBuf();
		if(m_dbuf==0)return false;
	}
	m_dbuf->Clear();
	m_dbuf->Add(dbuf.GetBuffer(),dbuf.m_Size);
	
	return true;
}

bool CFindQueryNiiao::GetDataBuf(CaplDataBuf &dbuf)
{
	dbuf.Clear();
	if(m_dbuf==0)
		return false;
	dbuf.Add(m_dbuf->GetBuffer(),m_dbuf->m_Size);
	
	return true;
}


void CFindQueryNiiao::OnChangeEdit() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	m_changed=true;
	
}
