// GetPasswordDialog.cpp : implementation file
//

#include "stdafx.h"
#include "GetPasswordDialog.h"


// CGetPasswordDialog dialog

IMPLEMENT_DYNAMIC(CGetPasswordDialog, CaplTranslateDialog)

CGetPasswordDialog::CGetPasswordDialog(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CGetPasswordDialog::IDD, pParent)
{

}

CGetPasswordDialog::~CGetPasswordDialog()
{
}

void CGetPasswordDialog::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_NEW_PASS, m_psw_ctrl);
	DDX_Control(pDX, IDC_NEW_PASS2, m_psw2_ctrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_HEADER, m_header_ctrl);
	DDX_Control(pDX, IDC_ST_CHECK, m_st_chek);
	DDX_Control(pDX, IDC_ST_CHECK2, m_st_chek2);
}


BEGIN_MESSAGE_MAP(CGetPasswordDialog, CaplTranslateDialog)
	ON_EN_CHANGE(IDC_NEW_PASS, &CGetPasswordDialog::OnEnChangeNewPass)
	ON_EN_CHANGE(IDC_NEW_PASS2, &CGetPasswordDialog::OnEnChangeNewPass2)
END_MESSAGE_MAP()


// CGetPasswordDialog message handlers

BOOL CGetPasswordDialog::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	m_st_chek.SetIcon(GetAplStdIco16(APLSTDICO_INCORRECT));
	m_st_chek2.SetIcon(GetAplStdIco16(APLSTDICO_INCORRECT));

	if(m_sHeader!=_T("")) m_header_ctrl.SetWindowText(m_sHeader);


	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CGetPasswordDialog::OnOK()
{
	CString sPsw,sPsw2;
	m_psw_ctrl.GetWindowText(sPsw);
	m_psw2_ctrl.GetWindowText(sPsw2);

	if(sPsw==_T("")) {AfxMessageBox(APL_T(" !"),MB_ICONSTOP); return;};
	if(sPsw!=sPsw2) {AfxMessageBox(APL_T("  !"),MB_ICONSTOP); return;};

	m_sPassword=sPsw;

	CaplTranslateDialog::OnOK();
}

void CGetPasswordDialog::OnEnChangeNewPass(){SetCorrectIcons();}

void CGetPasswordDialog::OnEnChangeNewPass2() {SetCorrectIcons();}


void CGetPasswordDialog::SetCorrectIcons()
{
	CString sPsw,sPsw2;
	m_psw_ctrl.GetWindowText(sPsw);
	m_psw2_ctrl.GetWindowText(sPsw2);

	if(sPsw.GetLength()>0) m_st_chek.SetIcon(GetAplStdIco16(APLSTDICO_CORRECT));
	else  m_st_chek.SetIcon(GetAplStdIco16(APLSTDICO_INCORRECT));

	if(sPsw2==_T("") || sPsw!=sPsw2)m_st_chek2.SetIcon(GetAplStdIco16(APLSTDICO_INCORRECT));
	else m_st_chek2.SetIcon(GetAplStdIco16(APLSTDICO_CORRECT));
};