// HardCopyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "HardCopyDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHardCopyDlg dialog


CHardCopyDlg::CHardCopyDlg(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CHardCopyDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHardCopyDlg)
	m_act_change_name = _T("");
	m_copy_basis = _T("");
	m_copy_id = _T("");
	m_cur_change_name = _T("");
	m_cur_ver_id = _T("");
	m_doc_name = _T("");
	m_issue_date = COleDateTime::GetCurrentTime();
	m_owner_name = _T("");
	m_place_of_use_name = _T("");
	m_update_date = COleDateTime::GetCurrentTime();
	m_changes_date = COleDateTime::GetCurrentTime();
	m_state = -1;
	m_act_ver_id = _T("");
	//}}AFX_DATA_INIT
	m_doc=0;
	m_doc_copy=0;
	m_owner=0;
	m_place_of_use=0;
	m_api=0;
	m_doc_act_ver=0;
	m_doc_cur_ver=0;
	m_act_doc_change=0;
	m_cur_doc_change=0;
	m_doc_copy_rev_change=0;
	m_doc_copy_owner_change=0;
	m_cur_person=0;
}


void CHardCopyDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHardCopyDlg)
	DDX_Control(pDX, IDC_DOC_ACT_VER_ID, m_act_ver_id_ctrl);
	DDX_Control(pDX, IDC_DOC_TEXT, m_doc_text_ctrl);
	DDX_Control(pDX, IDC_ACT_VER_TEXT, m_act_ver_text_ctrl);
	DDX_Control(pDX, IDC_ACT_CHANGE, m_act_change_name_ctrl);
	DDX_Control(pDX, IDC_STATE, m_state_ctrl);
	DDX_Control(pDX, IDC_BASIS_TEXT, m_basis_text_ctrl);
	DDX_Control(pDX, IDC_PLACE_OF_USE_NAME, m_place_of_use_name_ctrl);
	DDX_Control(pDX, IDC_PLACE_OF_USE_TEXT, m_place_of_use_text_ctrl);
	DDX_Control(pDX, IDC_OWNER_TEXT, m_owner_name_text_ctrl);
	DDX_Control(pDX, IDC_OWNER_NAME, m_owner_name_ctrl);
	DDX_Control(pDX, IDC_COPY_BASIS, m_copy_basis_ctrl);
	DDX_Control(pDX, IDC_COPY_OWNER_FRAME, m_owner_frame_ctrl);
	DDX_Control(pDX, IDC_OWNERS_HISTORY_BTN, m_owners_history_btn);
	DDX_Control(pDX, IDC_COPY_ACTUALITY_FRAME, m_copy_act_frame_ctrl);
	DDX_Control(pDX, IDC_CHANGES_HISTORY_BTN, m_changes_history_btn);
	DDX_Control(pDX, IDC_CHANGES_DATE_TEXT, m_changes_date_text_ctrl);
	DDX_Control(pDX, IDC_CHANGES_DATE, m_changes_date_ctrl);
	DDX_Control(pDX, IDC_CHANGE_OWNER_BTN, m_change_owner_btn);
	DDX_Control(pDX, IDC_ISSUE_DATE, m_issue_date_ctrl);
	DDX_Control(pDX, IDC_MARK_CHANGED_BTN, m_mark_changed_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_VIEW_CUR_VER_BTN, m_view_cur_ver_btn);
	DDX_Control(pDX, IDC_VIEW_ACT_VER_BTN, m_view_act_ver_btn);
	DDX_Control(pDX, IDC_UPDATE_DATE_TEXT, m_update_date_text_ctrl);
	DDX_Control(pDX, IDC_UPDATE_DATE, m_update_date_ctrl);
	DDX_Control(pDX, IDC_SELECT_PLACE_OF_USE_BTN, m_select_place_of_use_btn);
	DDX_Control(pDX, IDC_SELECT_OWNER_BTN, m_select_owner_btn);
	DDX_Control(pDX, IDC_SELECT_DOC_BTN, m_select_doc_btn);
	DDX_Control(pDX, IDC_DOC_CUR_VER_ID, m_cur_ver_id_ctrl);
	DDX_Control(pDX, IDC_CUR_VER_TEXT, m_cur_ver_text_ctrl);
	DDX_Control(pDX, IDC_CUR_CHANGE, m_cur_change_name_ctrl);
	DDX_Control(pDX, IDC_CUR_CHANGE_TEXT, m_cur_change_text_ctrl);
	DDX_Text(pDX, IDC_ACT_CHANGE, m_act_change_name);
	DDX_Text(pDX, IDC_COPY_BASIS, m_copy_basis);
	DDX_Text(pDX, IDC_COPY_ID, m_copy_id);
	DDX_Text(pDX, IDC_CUR_CHANGE, m_cur_change_name);
	DDX_Text(pDX, IDC_DOC_CUR_VER_ID, m_cur_ver_id);
	DDX_Text(pDX, IDC_DOCUMENT_NAME, m_doc_name);
	DDX_DateTimeCtrl(pDX, IDC_ISSUE_DATE, m_issue_date);
	DDX_Text(pDX, IDC_OWNER_NAME, m_owner_name);
	DDX_Text(pDX, IDC_PLACE_OF_USE_NAME, m_place_of_use_name);
	DDX_DateTimeCtrl(pDX, IDC_UPDATE_DATE, m_update_date);
	DDX_DateTimeCtrl(pDX, IDC_CHANGES_DATE, m_changes_date);
	DDX_CBIndex(pDX, IDC_STATE, m_state);
	DDX_Text(pDX, IDC_DOC_ACT_VER_ID, m_act_ver_id);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHardCopyDlg, CaplResizableDialog)
	//{{AFX_MSG_MAP(CHardCopyDlg)
	ON_BN_CLICKED(IDC_SELECT_DOC_BTN, OnSelectDocBtn)
	ON_BN_CLICKED(IDC_SELECT_OWNER_BTN, OnSelectOwnerBtn)
	ON_BN_CLICKED(IDC_SELECT_PLACE_OF_USE_BTN, OnSelectPlaceOfUseBtn)
	ON_BN_CLICKED(IDC_VIEW_CUR_VER_BTN, OnViewCurVerBtn)
	ON_BN_CLICKED(IDC_MARK_CHANGED_BTN, OnMarkChangedBtn)
	ON_BN_CLICKED(IDC_CHANGE_OWNER_BTN, OnChangeOwnerBtn)
	ON_BN_CLICKED(IDC_CHANGES_HISTORY_BTN, OnChangesHistoryBtn)
	ON_BN_CLICKED(IDC_OWNERS_HISTORY_BTN, OnOwnersHistoryBtn)
	ON_BN_CLICKED(IDC_VIEW_ACT_VER_BTN, OnViewActVerBtn)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHardCopyDlg message handlers

BOOL CHardCopyDlg::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();
	if(m_api==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));

	
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   

	m_view_cur_ver_btn.SetTooltipText( APL_T("    "));
	m_view_act_ver_btn.SetTooltipText( APL_T("   "));
	m_mark_changed_btn.SetTooltipText( APL_T("       "));
	
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	m_mark_changed_btn.SetFlat(FALSE);
	m_view_cur_ver_btn.SetIcon(GetAplTableIco(APL_TABLE_VIEW));
	m_view_cur_ver_btn.SetFlat(FALSE);
	m_view_cur_ver_btn.SetWindowText(_T(""));
	m_view_act_ver_btn.SetIcon(GetAplTableIco(APL_TABLE_VIEW));
	m_view_act_ver_btn.SetFlat(FALSE);
	m_view_act_ver_btn.SetWindowText(_T(""));
	
	m_view_act_ver_btn.EnableWindow(FALSE);
	m_view_cur_ver_btn.EnableWindow(FALSE);
	m_cur_person=m_api->m_appr_mgr.GetCurrentPerson();
	if(!m_cur_person) 
	{
		m_mark_changed_btn.EnableWindow(FALSE);
	}
	if(m_doc_copy)
	{
		m_select_doc_btn.EnableWindow(FALSE);
		m_issue_date_ctrl.EnableWindow(FALSE);
		m_select_owner_btn.EnableWindow(FALSE);
		m_copy_basis_ctrl.SetReadOnly(TRUE);
		m_select_place_of_use_btn.EnableWindow(FALSE);
		SetFromInst();
	}
	else
	{
		m_update_date_ctrl.ShowWindow(SW_HIDE);
		m_update_date_text_ctrl.ShowWindow(SW_HIDE);
		m_mark_changed_btn.ShowWindow(SW_HIDE);
		m_changes_date_ctrl.ShowWindow(SW_HIDE);
		m_changes_date_text_ctrl.ShowWindow(SW_HIDE);
		m_change_owner_btn.ShowWindow(SW_HIDE);
		m_owners_history_btn.ShowWindow(SW_HIDE);
		m_changes_history_btn.ShowWindow(SW_HIDE);
		m_cur_change_name_ctrl.ShowWindow(SW_HIDE);
		m_cur_change_text_ctrl.ShowWindow(SW_HIDE);
		m_cur_ver_id_ctrl.ShowWindow(SW_HIDE);
		m_cur_ver_text_ctrl.ShowWindow(SW_HIDE);
		m_view_cur_ver_btn.ShowWindow(SW_HIDE);
		m_copy_act_frame_ctrl.ShowWindow(SW_HIDE);
		m_cur_ver_id_ctrl.ShowWindow(SW_HIDE);
		m_view_act_ver_btn.ShowWindow(SW_HIDE);
		m_act_ver_text_ctrl.ShowWindow(SW_HIDE);
		m_act_change_name_ctrl.ShowWindow(SW_HIDE);
		m_doc_text_ctrl.ShowWindow(SW_HIDE);
		m_act_ver_id_ctrl.ShowWindow(SW_HIDE);
			
		CRect rect;
		m_copy_act_frame_ctrl.GetWindowRect(&rect);
		CRect rect1;
		m_owner_frame_ctrl.GetWindowRect(&rect1);
		int cy=rect1.top-rect.top;

		m_owners_history_btn.GetWindowRect(&rect);
		int button_right=rect.right;

		rect1.top-=cy;rect1.bottom-=cy;
		ScreenToClient(&rect1);
		m_owner_frame_ctrl.MoveWindow(&rect1);

		m_select_place_of_use_btn.GetWindowRect(&rect1);
		rect1.top-=cy;rect1.bottom-=cy;
		rect1.left=button_right-rect1.Width();rect1.right=button_right;
		ScreenToClient(&rect1);
		m_select_place_of_use_btn.MoveWindow(&rect1);

		m_select_owner_btn.GetWindowRect(&rect1);
		rect1.top-=cy;rect1.bottom-=cy;
		int sel_button_shift=rect1.left;
		rect1.left=button_right-rect1.Width();rect1.right=button_right;
		sel_button_shift=rect1.left-sel_button_shift;
		ScreenToClient(&rect1);
		m_select_owner_btn.MoveWindow(&rect1);
		
		m_place_of_use_name_ctrl.GetWindowRect(&rect1);
		rect1.top-=cy;rect1.bottom-=cy;
		rect1.right+=sel_button_shift;
		ScreenToClient(&rect1);
		m_place_of_use_name_ctrl.MoveWindow(&rect1);
		
		m_place_of_use_text_ctrl.GetWindowRect(&rect1);
		rect1.top-=cy;rect1.bottom-=cy;
		ScreenToClient(&rect1);
		m_place_of_use_text_ctrl.MoveWindow(&rect1);

		m_owner_name_text_ctrl.GetWindowRect(&rect1);
		rect1.top-=cy;rect1.bottom-=cy;
		ScreenToClient(&rect1);
		m_owner_name_text_ctrl.MoveWindow(&rect1);

		m_owner_name_ctrl.GetWindowRect(&rect1);
		rect1.top-=cy;rect1.bottom-=cy;
		rect1.right+=sel_button_shift;
		ScreenToClient(&rect1);
		m_owner_name_ctrl.MoveWindow(&rect1);
		
		m_basis_text_ctrl.GetWindowRect(&rect1);
		rect1.top-=cy;rect1.bottom-=cy;
		ScreenToClient(&rect1);
		m_basis_text_ctrl.MoveWindow(&rect1);

		m_copy_basis_ctrl.GetWindowRect(&rect1);
		rect1.top-=cy;rect1.bottom-=cy;
		rect1.right+=sel_button_shift;
		ScreenToClient(&rect1);
		m_copy_basis_ctrl.MoveWindow(&rect1);

		m_ok_btn.GetWindowRect(&rect1);
		rect1.top-=cy;rect1.bottom-=cy;
		ScreenToClient(&rect1);
		m_ok_btn.MoveWindow(&rect1);

		m_cancel_btn.GetWindowRect(&rect1);
		rect1.top-=cy;rect1.bottom-=cy;
		ScreenToClient(&rect1);
		m_cancel_btn.MoveWindow(&rect1);

		GetWindowRect(&rect1);
		rect1.bottom-=cy;
		MoveWindow(&rect1);
		
		m_state=0;
		m_state_ctrl.EnableWindow(FALSE);
		UpdateData(FALSE);

		if(m_doc) RefreshDocInfo();
		if(!m_owner) m_owner=m_cur_person;
		if(m_owner) RefreshOwnerInfo();
		
		if(!m_place_of_use && m_owner)
		{
			aplExtent ext;
			m_api->m_appr_mgr.FindPersonOrganizations(m_owner,ext);
			if(ext.GetSize()) m_place_of_use=ext[0];
		}
		if(m_place_of_use) RefreshPlaceOfUseInfo();
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CHardCopyDlg::OnSelectDocBtn() 
{
	CaplInstance *doc=m_api->m_doc_mgr.SelectInstance(APL_MODE_SELECT_DOC, APL_T(" "));
	if(doc)
	{
		m_doc=doc;
		RefreshDocInfo();
		m_cur_doc_change=m_act_doc_change;
		if(m_cur_doc_change) m_api->m_data.GetAttr(m_cur_doc_change, m_api->m_change_mgr.a_chng_item_id, m_cur_change_name);
		UpdateData(FALSE);
	}

	
}

void CHardCopyDlg::RefreshOwnerInfo()
{
	if(!m_owner) return;
	UpdateData(TRUE);
	m_api->m_appr_mgr.GetPersonName(m_owner,m_owner_name);
	UpdateData(FALSE);
}

void CHardCopyDlg::RefreshPlaceOfUseInfo()
{
	if(!m_place_of_use) return;
	UpdateData(TRUE);
	m_api->m_data.GetAttr(m_place_of_use,m_api->m_appr_mgr.a_org_name,m_place_of_use_name); 
	UpdateData(FALSE);
}

void CHardCopyDlg::OnSelectOwnerBtn() 
{
	// TODO: Add your control notification handler code here
	aplExtent ext;
	CaplInstance *inst=m_api->m_appr_mgr.SelectPersonOrOrganization(APL_MODE_SELECT_PERSON, ext,  APL_T("    "),  APL_T("    "));
	if(inst)
	{
		m_owner=inst;
		RefreshOwnerInfo();
	}
	
}

void CHardCopyDlg::OnSelectPlaceOfUseBtn() 
{
	aplExtent ext;
	CaplInstance *inst=m_api->m_appr_mgr.SelectPersonOrOrganization(APL_MODE_SELECT_ORG, ext,  APL_T("  "),  APL_T("    "));
	if(inst)
	{
		m_place_of_use=inst;
		RefreshPlaceOfUseInfo();
	}
	
}

void CHardCopyDlg::OnOK() 
{
	if(!SaveChanges()) return;
	
	CaplResizableDialog::OnOK();
}

void CHardCopyDlg::OnViewCurVerBtn() 
{
	if(!m_doc_cur_ver) return;
	
	m_api->m_doc_mgr.View(m_doc_cur_ver);
	
}

void CHardCopyDlg::OnMarkChangedBtn() 
{
	UpdateData(TRUE);
	m_doc_cur_ver=m_doc_act_ver;
	if(m_doc_cur_ver) m_api->m_data.GetAttr(m_doc_cur_ver,m_api->m_doc_mgr.a_apl_doc_rev_id,m_cur_ver_id);
	m_cur_doc_change=m_act_doc_change;
	if(m_cur_doc_change) m_api->m_data.GetAttr(m_cur_doc_change, m_api->m_change_mgr.a_chng_item_id, m_cur_change_name);
	m_changes_date_ctrl.EnableWindow(FALSE);
	m_update_date=m_changes_date;
	m_mark_changed_btn.EnableWindow(FALSE);
	UpdateData(FALSE);
}

void CHardCopyDlg::OnChangeOwnerBtn() 
{
	//CaplInstance *old_owner=m_owner;
	//OnSelectOwnerBtn();
	//if(old_owner!=m_owner)
	//{
		m_select_owner_btn.EnableWindow(TRUE);
		m_copy_basis_ctrl.SetReadOnly(FALSE);
		m_select_place_of_use_btn.EnableWindow(TRUE);
		m_change_owner_btn.EnableWindow(FALSE);
		m_copy_basis=_T("");
		//m_place_of_use=0;
		//m_place_of_use_name=_T("");
		UpdateData(FALSE);
	//}
}

void CHardCopyDlg::OnChangesHistoryBtn() 
{
	if(!m_doc_copy) return;
	m_api->m_doc_mgr.ShowHardCopyRevChanges(m_doc_copy);
	
}

void CHardCopyDlg::OnOwnersHistoryBtn() 
{
	if(!m_doc_copy) return;
	m_api->m_doc_mgr.ShowHardCopyOwnerChanges(m_doc_copy);
	
}

void CHardCopyDlg::SetFromInst()
{
	if(!m_doc_copy) return;
	m_api->m_data.GetAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_id,m_copy_id);
	UpdateData(FALSE);

	m_api->m_data.GetAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_doc,m_doc);
	if(m_doc) RefreshDocInfo();

	m_api->m_data.GetAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_cur_rev,m_doc_cur_ver);
	if(m_doc_cur_ver)
	{
		m_api->m_data.GetAttr(m_doc_cur_ver,m_api->m_doc_mgr.a_apl_doc_rev_id,m_cur_ver_id);
		m_view_cur_ver_btn.EnableWindow(TRUE);
		UpdateData(FALSE);
		if(m_doc)
		{
			aplExtent ext_changes;
			m_api->m_change_mgr.GetAllChanges(m_doc, ext_changes);
			for(int i=0; i<ext_changes.GetSize();i++)
			{
				CaplInstance* rev;
				m_api->m_data.GetAttr(ext_changes[i], m_api->m_change_mgr.a_avc_new_rev, rev);
				if(rev==m_doc_cur_ver)
				{
					m_cur_doc_change=ext_changes[i];
					m_api->m_data.GetAttr(m_cur_doc_change, m_api->m_change_mgr.a_chng_item_id, m_cur_change_name);
					UpdateData(FALSE);
					break;
				}
			}
		}
	}
	if(m_doc_cur_ver!=m_doc_act_ver && m_cur_person)
	{
		m_mark_changed_btn.EnableWindow(TRUE);
	}
	CString buf;
	m_api->m_data.GetAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_state,buf);
	if(buf!=_T("")) m_state_ctrl.SelectString(-1,buf);

	m_api->m_data.GetAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_owner,m_owner);
	RefreshOwnerInfo();

	m_api->m_data.GetAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_place_of_use,m_place_of_use);
	RefreshPlaceOfUseInfo();
	
	m_api->m_data.GetAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_issue_date,buf);
	if(buf!=_T(""))
	{
		aplString2Date(buf,m_issue_date);
	}
	m_api->m_data.GetAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_last_update,buf);
	if(buf!=_T(""))
	{
		aplString2Date(buf,m_update_date);
	}

	aplExtent own_chg;
	CaplAttrValue find_values[3];
	find_values[0].value.Set(m_doc_copy);
	find_values[0].attr= m_api->m_doc_mgr.a_doc_copy_owner_change_hard_copy;
	find_values[1].value.Set(m_owner);
	find_values[1].attr= m_api->m_doc_mgr.a_doc_copy_owner_change_new_owner;
	find_values[2].value.Set(m_place_of_use);
	find_values[2].attr= m_api->m_doc_mgr.a_doc_copy_owner_change_new_place_of_use;
	m_api->m_data.NET_FindInstancesWithAttrValues(m_api->m_doc_mgr.e_doc_copy_owner_change, 3, &find_values[0], own_chg, true);	
	if(own_chg.GetSize())
	{
		CaplLoadData ld(&m_api->m_data,DEF_SOURCE);
		ld.AddQuery(0,own_chg[0],true);
		ld.LoadEx();
		m_api->m_data.GetAttr(own_chg[0],m_api->m_doc_mgr.a_doc_copy_owner_change_basis,m_copy_basis);
	}
	UpdateData(FALSE);
}

void CHardCopyDlg::RefreshDocInfo()
{
	if(!m_doc) return;
	UpdateData(TRUE);
	m_api->GetItemName(m_doc,m_doc_name);
	m_api->m_data.GetAttr(m_doc,m_api->m_doc_mgr.a_apl_doc_active,m_doc_act_ver);
	m_act_ver_id=_T("");
	m_doc_cur_ver=0;
	m_act_change_name=_T("");
	m_act_doc_change=0;
	m_cur_doc_change=0;
	if(m_doc_act_ver)
	{
		m_api->m_data.GetAttr(m_doc_act_ver,m_api->m_doc_mgr.a_apl_doc_rev_id,m_act_ver_id);
		m_doc_cur_ver=m_doc_act_ver;
		aplExtent ext_changes;
		m_api->m_change_mgr.GetAllChanges(m_doc, ext_changes);
		for(int i=0;ext_changes.GetSize();i++)
		{
			CaplInstance* rev;
			m_api->m_data.GetAttr(ext_changes[i], m_api->m_change_mgr.a_avc_new_rev, rev);
			if(rev==m_doc_act_ver)
			{
				m_act_doc_change=ext_changes[i];
				m_api->m_data.GetAttr(m_act_doc_change, m_api->m_change_mgr.a_chng_item_id, m_act_change_name);
				break;
			}
		}
	}
	if(m_doc_act_ver) m_view_act_ver_btn.EnableWindow(TRUE);
	else m_view_act_ver_btn.EnableWindow(FALSE);
	if(m_copy_id==_T(""))
	{
		CString buf=_T("");
		int num=m_api->m_doc_mgr.GetNextHardCopyNumber(m_doc);
		if(num>-1) m_copy_id.Format(_T("%d"),num);
	}
	UpdateData(FALSE);	
}

void CHardCopyDlg::OnViewActVerBtn() 
{
	if(!m_doc_act_ver) return;
	
	m_api->m_doc_mgr.View(m_doc_act_ver);
	
}

bool CHardCopyDlg::SaveChanges()
{
	UpdateData(TRUE);
	if(!m_doc)
	{
		AfxMessageBox( APL_T("  !"));
		return false;
	}
	if(!m_owner)
	{
		AfxMessageBox( APL_T("     !"));
		return false;
	}
	if(m_copy_id==_T("")) 
	{
		AfxMessageBox( APL_T("    !"));
		return false;
	}
	CString buf,old_id=_T("");
	if(m_doc_copy) m_api->m_data.GetAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_id,old_id);
	if(old_id!=m_copy_id) 
	{
		//  id
		CaplAttrValue tst_values[2];               
		tst_values[0].value.Set((LPCTSTR)m_copy_id); 
		tst_values[0].attr=m_api->m_doc_mgr.a_doc_copy_id;      
		tst_values[1].value.Set(m_doc); 
		tst_values[1].attr=m_api->m_doc_mgr.a_doc_copy_doc;      
		aplExtent ext_doc_copy_inst;
		
		m_api->m_data.NET_FindInstancesWithAttrValues(m_api->m_doc_mgr.e_doc_copy,2,&tst_values[0],ext_doc_copy_inst,false);
		if(ext_doc_copy_inst.GetSize())
		{
			AfxMessageBox( APL_T("         !!!"));
			return false;
		}
	}
	COleDateTime cur_dt=COleDateTime::GetCurrentTime();
	CString issue_date_s,update_date_s;
	m_update_date.SetDateTime(m_update_date.GetYear(),m_update_date.GetMonth(),m_update_date.GetDay(),cur_dt.GetHour(),cur_dt.GetMinute(),cur_dt.GetSecond());
	m_issue_date.SetDateTime(m_issue_date.GetYear(),m_issue_date.GetMonth(),m_issue_date.GetDay(),cur_dt.GetHour(),cur_dt.GetMinute(),cur_dt.GetSecond());
	aplDate2String(m_issue_date,issue_date_s);
	aplDate2String(m_update_date,update_date_s);
	if(!m_doc_copy)//  
	{
		m_doc_copy=m_api->m_data.CreateInstance(m_api->m_doc_mgr.e_doc_copy);
		if(!m_doc_copy) return false;
		m_api->m_data.PutAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_doc,m_doc);	
		m_api->m_data.PutAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_first_rev,m_doc_act_ver);	
		m_api->m_data.PutAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_issue_date,issue_date_s);	
		update_date_s=issue_date_s;
	}
	if(old_id!=m_copy_id) m_api->m_data.PutAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_id,m_copy_id);	
	m_api->m_data.GetAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_state,buf);
	CString new_state;
	m_state_ctrl.GetWindowText(new_state);
	if(buf!=new_state) m_api->m_data.PutAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_state,new_state);
	CaplInstance *inst;
	m_api->m_data.GetAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_cur_rev,inst);
	if(inst!=m_doc_cur_ver) 
	{
		m_api->m_data.PutAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_cur_rev,m_doc_cur_ver);
		m_api->m_data.PutAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_last_update,update_date_s);	
		CaplInstance *first_rev;
		m_api->m_data.GetAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_first_rev,first_rev);	
		if(first_rev!=m_doc_cur_ver)// -  
		{
			m_api->m_doc_mgr.ApplyHardCopyRevChanges(m_doc_copy,m_cur_person,m_act_doc_change,update_date_s);
		}
	}
	CaplInstance *old_owner=0,*old_place_of_use=0;
	m_api->m_data.GetAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_owner,old_owner);
	m_api->m_data.GetAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_place_of_use,old_place_of_use);
	if(old_owner!=m_owner || old_place_of_use!=m_place_of_use)
	{
		if(old_owner!=m_owner) m_api->m_data.PutAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_owner,m_owner);
		if(old_place_of_use!=m_place_of_use) m_api->m_data.PutAttr(m_doc_copy,m_api->m_doc_mgr.a_doc_copy_place_of_use,m_place_of_use);
		// -   
		m_doc_copy_owner_change=m_api->m_data.CreateInstance(m_api->m_doc_mgr.e_doc_copy_owner_change);
		if(m_doc_copy_owner_change)
		{
			m_api->m_data.PutAttr(m_doc_copy_owner_change,m_api->m_doc_mgr.a_doc_copy_owner_change_basis,m_copy_basis);
			m_api->m_data.PutAttr(m_doc_copy_owner_change,m_api->m_doc_mgr.a_doc_copy_owner_change_hand_date,update_date_s);
			m_api->m_data.PutAttr(m_doc_copy_owner_change,m_api->m_doc_mgr.a_doc_copy_owner_change_new_owner,m_owner);
			m_api->m_data.PutAttr(m_doc_copy_owner_change,m_api->m_doc_mgr.a_doc_copy_owner_change_new_place_of_use,m_place_of_use);
			m_api->m_data.PutAttr(m_doc_copy_owner_change,m_api->m_doc_mgr.a_doc_copy_owner_change_hard_copy,m_doc_copy);
		}
	}
	return true;
}
